use rustc_abi::Endian;

use crate::spec::{Abi, Arch, FloatAbi, Target, TargetMetadata, TargetOptions, base};

pub(crate) fn target() -> Target {
    Target {
        llvm_target: "armeb-unknown-linux-gnueabi".into(),
        metadata: TargetMetadata {
            description: Some("Arm BE8 the default Arm big-endian architecture since Armv6".into()),
            tier: Some(3),
            host_tools: None, // ?
            std: Some(true),
        },
        pointer_width: 32,
        data_layout: "E-m:e-p:32:32-Fi8-i64:64-v128:64:128-a:0:32-n32-S64".into(),
        arch: Arch::Arm,
        options: TargetOptions {
            abi: Abi::Eabi,
            llvm_floatabi: Some(FloatAbi::Soft),
            features: "+strict-align,+v8,+crc".into(),
            endian: Endian::Big,
            max_atomic_width: Some(64),
            mcount: "\u{1}__gnu_mcount_nc".into(),
            llvm_mcount_intrinsic: Some("llvm.arm.gnu.eabi.mcount".into()),
            ..base::linux_gnu::opts()
        },
    }
}
