/* s3 compat server functions auto-generated by pidl */
#include "bin/default/librpc/gen_ndr/ndr_epmapper.h"
#include "bin/default/librpc/gen_ndr/ndr_epmapper_scompat.h"
#include <librpc/rpc/dcesrv_core.h>
#include <rpc_server/rpc_config.h>
#include <rpc_server/rpc_server.h>
#include <util/debug.h>

enum s3compat_rpc_dispatch {
	S3COMPAT_RPC_DISPATCH_EXTERNAL = 0x00000001,
	S3COMPAT_RPC_DISPATCH_INTERNAL = 0x00000002,
};

/* epmapper - dcerpc server boilerplate generated by pidl */
static NTSTATUS epmapper__op_bind(struct dcesrv_connection_context *context, const struct dcesrv_interface *iface)
{
#ifdef DCESRV_INTERFACE_EPMAPPER_BIND
	return DCESRV_INTERFACE_EPMAPPER_BIND(context,iface);
#else
	return NT_STATUS_OK;
#endif
}

static void epmapper__op_unbind(struct dcesrv_connection_context *context, const struct dcesrv_interface *iface)
{
#ifdef DCESRV_INTERFACE_EPMAPPER_UNBIND
	DCESRV_INTERFACE_EPMAPPER_UNBIND(context, iface);
#else
	return;
#endif
}

NTSTATUS epmapper__op_ndr_pull(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, struct ndr_pull *pull, void **r)
{
	enum ndr_err_code ndr_err;
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	dce_call->fault_code = 0;

	if (opnum >= ndr_table_epmapper.num_calls) {
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	*r = talloc_named(mem_ctx, ndr_table_epmapper.calls[opnum].struct_size, "struct %s", ndr_table_epmapper.calls[opnum].name);
	NT_STATUS_HAVE_NO_MEMORY(*r);

	/* unravel the NDR for the packet */
	ndr_err = ndr_table_epmapper.calls[opnum].ndr_pull(pull, NDR_IN, *r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		dce_call->fault_code = DCERPC_FAULT_NDR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS epmapper__op_dispatch_internal(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r, enum s3compat_rpc_dispatch dispatch)
{
	uint16_t opnum = dce_call->pkt.u.request.opnum;
	struct pipes_struct *p = NULL;
	NTSTATUS status = NT_STATUS_OK;
	bool impersonated = false;

	/* Retrieve pipes struct */
	p = dcesrv_get_pipes_struct(dce_call->conn);
	p->dce_call = dce_call;
	p->mem_ctx = mem_ctx;
	/* Reset pipes struct fault state */
	p->fault_state = 0;

	/* Impersonate */
	if (dispatch == S3COMPAT_RPC_DISPATCH_EXTERNAL) {
		impersonated = become_authenticated_pipe_user(dce_call->auth_state->session_info);
		if (!impersonated) {
			dce_call->fault_code = DCERPC_FAULT_ACCESS_DENIED;
			status = NT_STATUS_NET_WRITE_FAULT;
			goto fail;
		}
	}

	switch (opnum) {
	case 0: { /* epm_Insert */
		struct epm_Insert *r2 = (struct epm_Insert *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(epm_Insert, NDR_IN, r2);
		}
		r2->out.result = _epm_Insert(p, r2);
		break;
	}
	case 1: { /* epm_Delete */
		struct epm_Delete *r2 = (struct epm_Delete *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(epm_Delete, NDR_IN, r2);
		}
		r2->out.result = _epm_Delete(p, r2);
		break;
	}
	case 2: { /* epm_Lookup */
		struct epm_Lookup *r2 = (struct epm_Lookup *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(epm_Lookup, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.entry_handle = r2->in.entry_handle;
		r2->out.num_ents = talloc_zero(r2, uint32_t);
		if (r2->out.num_ents == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.entries = talloc_zero_array(r2, struct epm_entry_t, r2->in.max_ents);
		if (r2->out.entries == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _epm_Lookup(p, r2);
		break;
	}
	case 3: { /* epm_Map */
		struct epm_Map *r2 = (struct epm_Map *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(epm_Map, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.entry_handle = r2->in.entry_handle;
		r2->out.num_towers = talloc_zero(r2, uint32_t);
		if (r2->out.num_towers == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.towers = talloc_zero_array(r2, struct epm_twr_p_t, r2->in.max_towers);
		if (r2->out.towers == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _epm_Map(p, r2);
		break;
	}
	case 4: { /* epm_LookupHandleFree */
		struct epm_LookupHandleFree *r2 = (struct epm_LookupHandleFree *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(epm_LookupHandleFree, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.entry_handle = r2->in.entry_handle;
		r2->out.result = _epm_LookupHandleFree(p, r2);
		break;
	}
	case 5: { /* epm_InqObject */
		struct epm_InqObject *r2 = (struct epm_InqObject *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(epm_InqObject, NDR_IN, r2);
		}
		r2->out.result = _epm_InqObject(p, r2);
		break;
	}
	case 6: { /* epm_MgmtDelete */
		struct epm_MgmtDelete *r2 = (struct epm_MgmtDelete *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(epm_MgmtDelete, NDR_IN, r2);
		}
		r2->out.result = _epm_MgmtDelete(p, r2);
		break;
	}
	case 7: { /* epm_MapAuth */
		struct epm_MapAuth *r2 = (struct epm_MapAuth *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(epm_MapAuth, NDR_IN, r2);
		}
		r2->out.result = _epm_MapAuth(p, r2);
		break;
	}
	default:
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		break;
	}

fail:
	/* Unimpersonate */
	if (impersonated) {
		unbecome_authenticated_pipe_user();
	}

	p->dce_call = NULL;
	p->mem_ctx = NULL;
	/* Check pipes struct fault state */
	if (p->fault_state != 0) {
		dce_call->fault_code = p->fault_state;
	}
	if (dce_call->fault_code != 0) {
		status = NT_STATUS_NET_WRITE_FAULT;
	}

	return status;
}

NTSTATUS epmapper__op_dispatch(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	return epmapper__op_dispatch_internal(dce_call, mem_ctx, r, S3COMPAT_RPC_DISPATCH_EXTERNAL);
}

NTSTATUS epmapper__op_reply(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	switch (opnum) {
	case 0: { /* epm_Insert */
		struct epm_Insert *r2 = (struct epm_Insert *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function epm_Insert replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(epm_Insert, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in epm_Insert\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 1: { /* epm_Delete */
		struct epm_Delete *r2 = (struct epm_Delete *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function epm_Delete replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(epm_Delete, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in epm_Delete\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 2: { /* epm_Lookup */
		struct epm_Lookup *r2 = (struct epm_Lookup *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function epm_Lookup replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(epm_Lookup, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in epm_Lookup\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 3: { /* epm_Map */
		struct epm_Map *r2 = (struct epm_Map *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function epm_Map replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(epm_Map, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in epm_Map\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 4: { /* epm_LookupHandleFree */
		struct epm_LookupHandleFree *r2 = (struct epm_LookupHandleFree *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function epm_LookupHandleFree replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(epm_LookupHandleFree, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in epm_LookupHandleFree\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 5: { /* epm_InqObject */
		struct epm_InqObject *r2 = (struct epm_InqObject *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function epm_InqObject replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(epm_InqObject, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in epm_InqObject\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 6: { /* epm_MgmtDelete */
		struct epm_MgmtDelete *r2 = (struct epm_MgmtDelete *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function epm_MgmtDelete replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(epm_MgmtDelete, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in epm_MgmtDelete\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 7: { /* epm_MapAuth */
		struct epm_MapAuth *r2 = (struct epm_MapAuth *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function epm_MapAuth replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(epm_MapAuth, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in epm_MapAuth\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	default:
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		break;
	}

	if (dce_call->fault_code != 0) {
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

NTSTATUS epmapper__op_ndr_push(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, struct ndr_push *push, const void *r)
{
	enum ndr_err_code ndr_err;
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	ndr_err = ndr_table_epmapper.calls[opnum].ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		dce_call->fault_code = DCERPC_FAULT_NDR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

NTSTATUS epmapper__op_local(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	return epmapper__op_dispatch_internal(dce_call, mem_ctx, r, S3COMPAT_RPC_DISPATCH_INTERNAL);
}

static const struct dcesrv_interface dcesrv_epmapper_interface = {
	.name      = "epmapper",
	.syntax_id = {{0xe1af8308,0x5d1f,0x11c9,{0x91,0xa4},{0x08,0x00,0x2b,0x14,0xa0,0xfa}},3.0},
	.bind      = epmapper__op_bind,
	.unbind    = epmapper__op_unbind,
	.ndr_pull  = epmapper__op_ndr_pull,
	.dispatch  = epmapper__op_dispatch,
	.reply     = epmapper__op_reply,
	.ndr_push  = epmapper__op_ndr_push,
	.local     = epmapper__op_local,
#ifdef DCESRV_INTERFACE_EPMAPPER_FLAGS
	.flags     = DCESRV_INTERFACE_EPMAPPER_FLAGS
#else
	.flags     = 0
#endif
};

static NTSTATUS epmapper__op_init_server(struct dcesrv_context *dce_ctx, const struct dcesrv_endpoint_server *ep_server)
{
	uint32_t i;
	NTSTATUS ret;

#ifdef DCESRV_INTERFACE_EPMAPPER_NCACN_NP_SECONDARY_ENDPOINT
	const char *ncacn_np_secondary_endpoint = DCESRV_INTERFACE_EPMAPPER_NCACN_NP_SECONDARY_ENDPOINT;
#else
	const char *ncacn_np_secondary_endpoint = NULL;
#endif

	for (i=0;i<ndr_table_epmapper.endpoints->count;i++) {
		const char *name = ndr_table_epmapper.endpoints->names[i];

		ret = dcesrv_interface_register(dce_ctx, name, ncacn_np_secondary_endpoint, &dcesrv_epmapper_interface, NULL);
		if (!NT_STATUS_IS_OK(ret)) {
			DBG_ERR("Failed to register endpoint '%s'\n",name);
			return ret;
		}
	}

	return NT_STATUS_OK;
}

static NTSTATUS epmapper__op_shutdown_server(struct dcesrv_context *dce_ctx, const struct dcesrv_endpoint_server *ep_server)
{
	return NT_STATUS_OK;
}

static bool epmapper__op_interface_by_uuid(struct dcesrv_interface *iface, const struct GUID *uuid, uint32_t if_version)
{
	if (dcesrv_epmapper_interface.syntax_id.if_version == if_version && GUID_equal(&dcesrv_epmapper_interface.syntax_id.uuid, uuid)) {
		memcpy(iface,&dcesrv_epmapper_interface, sizeof(*iface));
		return true;
	}

	return false;
}

static bool epmapper__op_interface_by_name(struct dcesrv_interface *iface, const char *name)
{
	if (strcmp(dcesrv_epmapper_interface.name, name)==0) {
		memcpy(iface, &dcesrv_epmapper_interface, sizeof(*iface));
		return true;
	}

	return false;
}

static const struct dcesrv_endpoint_server epmapper_ep_server = {
	/* fill in our name */
	.name = "epmapper",

	/* Initialization flag */
	.initialized = false,

	/* fill in all the operations */
#ifdef DCESRV_INTERFACE_EPMAPPER_INIT_SERVER
	.init_server = DCESRV_INTERFACE_EPMAPPER_INIT_SERVER,
#else
	.init_server = epmapper__op_init_server,
#endif
#ifdef DCESRV_INTERFACE_EPMAPPER_SHUTDOWN_SERVER
	.shutdown_server = DCESRV_INTERFACE_EPMAPPER_SHUTDOWN_SERVER,
#else
	.shutdown_server = epmapper__op_shutdown_server,
#endif
	.interface_by_uuid = epmapper__op_interface_by_uuid,
	.interface_by_name = epmapper__op_interface_by_name
};

const struct dcesrv_endpoint_server *epmapper_get_ep_server(void)
{
	return &epmapper_ep_server;
}
