// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanCommMailMetrics_h
#define mozilla_GleanCommMailMetrics_h

#include "mozilla/JSONStringWriteFuncs.h"
#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace mail {
  /**
   * generated from mail.account_count
   * Count of how many accounts were set up, keyed by account type.
   */
  constexpr impl::Labeled<impl::StringMetric, DynamicLabel> account_count(1102);

  /**
   * generated from mail.account_preferences
   */

  struct AccountPreferencesObjectItem {
    Maybe<nsCString> protocol;
    Maybe<int64_t> socket_type;
    Maybe<int64_t> auth_method;
    Maybe<nsCString> store_type;
    Maybe<bool> login_at_startup;
    Maybe<bool> check_new_mail;
    Maybe<int64_t> check_time;
    Maybe<int64_t> delete_model;
    Maybe<bool> use_idle;
    Maybe<bool> cleanup_inbox_on_exit;
    Maybe<bool> empty_trash_on_exit;
    Maybe<bool> download_on_biff;
    Maybe<bool> headers_only;
    Maybe<bool> leave_on_server;
    Maybe<bool> delete_by_age_from_server;
    Maybe<int64_t> num_days_to_leave_on_server;
    Maybe<int64_t> notify_max_articles;
    Maybe<bool> always_authenticate;
  };

  using AccountPreferencesObject = nsTArray<AccountPreferencesObjectItem>;
  /**
   * Values of basic account preferences.
   */
  constexpr impl::ObjectMetric<AccountPreferencesObject, struct AccountPreferencesObjectTag> account_preferences(1103);

  /**
   * generated from mail.certificate_exception_added
   */
  struct CertificateExceptionAddedExtra {
    mozilla::Maybe<nsCString> errorCategory;
    mozilla::Maybe<nsCString> port;
    mozilla::Maybe<nsCString> protocol;
    mozilla::Maybe<nsCString> ui;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (errorCategory) {
        extraKeys.AppendElement()->AssignASCII("error_category");
        extraValues.EmplaceBack(errorCategory.value());
      }
      if (port) {
        extraKeys.AppendElement()->AssignASCII("port");
        extraValues.EmplaceBack(port.value());
      }
      if (protocol) {
        extraKeys.AppendElement()->AssignASCII("protocol");
        extraValues.EmplaceBack(protocol.value());
      }
      if (ui) {
        extraKeys.AppendElement()->AssignASCII("ui");
        extraValues.EmplaceBack(ui.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Tracks each time a TLS certificate exception is created, what the problem with the certificate is, and what code is using the certificate.
   */
  constexpr impl::EventMetric<CertificateExceptionAddedExtra> certificate_exception_added(1104);

  /**
   * generated from mail.compact_duration
   * Counts how long each folder compaction takes.
   */
  constexpr impl::TimingDistributionMetric compact_duration(1105);

  /**
   * generated from mail.compact_result
   * Counts the number of folder compactions that happen and how they ended.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, DynamicLabel> compact_result(1106);

  /**
   * generated from mail.compact_space_recovered
   * Number of bytes recovered by compaction.
   */
  constexpr impl::MemoryDistributionMetric compact_space_recovered(1107);

  /**
   * generated from mail.failed_email_account_setup
   * How many times email accounts setup failed, keyed by account config source.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, DynamicLabel> failed_email_account_setup(1108);

  /**
   * generated from mail.folder_opened
   */
  enum class FolderOpenedLabel: uint16_t {
    eInbox = 0,
    eDrafts = 1,
    eTrash = 2,
    eSentmail = 3,
    eTemplates = 4,
    eJunk = 5,
    eArchive = 6,
    eQueue = 7,
    eVirtual = 8,
    eOther = 9,
    e__Other__,
  };
  /**
   * How many times folders of each type are opened.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, FolderOpenedLabel> folder_opened(1109);

  /**
   * generated from mail.folder_size_on_disk
   */
  enum class FolderSizeOnDiskLabel: uint16_t {
    eInbox = 0,
    eDrafts = 1,
    eTrash = 2,
    eSentmail = 3,
    eTemplates = 4,
    eJunk = 5,
    eArchive = 6,
    eQueue = 7,
    eVirtual = 8,
    eOther = 9,
    eTotal = 10,
    e__Other__,
  };
  /**
   * How many bytes each type of folder takes on disk.
   */
  constexpr impl::Labeled<impl::StringMetric, FolderSizeOnDiskLabel> folder_size_on_disk(1110);

  /**
   * generated from mail.folder_total_messages
   */
  enum class FolderTotalMessagesLabel: uint16_t {
    eInbox = 0,
    eDrafts = 1,
    eTrash = 2,
    eSentmail = 3,
    eTemplates = 4,
    eJunk = 5,
    eArchive = 6,
    eQueue = 7,
    eVirtual = 8,
    eOther = 9,
    eTotal = 10,
    e__Other__,
  };
  /**
   * How many messages each type of folder has.
   */
  constexpr impl::Labeled<impl::StringMetric, FolderTotalMessagesLabel> folder_total_messages(1111);

  /**
   * generated from mail.import
   */
  struct ImportExtra {
    mozilla::Maybe<nsCString> importer;
    mozilla::Maybe<nsCString> result;
    mozilla::Maybe<nsCString> types;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (importer) {
        extraKeys.AppendElement()->AssignASCII("importer");
        extraValues.EmplaceBack(importer.value());
      }
      if (result) {
        extraKeys.AppendElement()->AssignASCII("result");
        extraValues.EmplaceBack(result.value());
      }
      if (types) {
        extraKeys.AppendElement()->AssignASCII("types");
        extraValues.EmplaceBack(types.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Records each time about:import is used to import a profile, calendar entries, or address book entries.
   */
  constexpr impl::EventMetric<ImportExtra> import(1112);

  /**
   * generated from mail.mails_read
   * How many emails were read by the user.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mails_read(1113);

  /**
   * generated from mail.mails_read_secure
   */
  struct MailsReadSecureExtra {
    mozilla::Maybe<bool> isEncrypted;
    mozilla::Maybe<bool> isSigned;
    mozilla::Maybe<nsCString> security;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (isEncrypted) {
        extraKeys.AppendElement()->AssignASCII("is_encrypted");
        extraValues.AppendElement()->AssignASCII(isEncrypted.value() ? "true" : "false");
      }
      if (isSigned) {
        extraKeys.AppendElement()->AssignASCII("is_signed");
        extraValues.AppendElement()->AssignASCII(isSigned.value() ? "true" : "false");
      }
      if (security) {
        extraKeys.AppendElement()->AssignASCII("security");
        extraValues.EmplaceBack(security.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * How many times different kinds of secure emails are read (for the first time), keyed by type. TODO: should fold this and mails_read into one
   */
  constexpr impl::EventMetric<MailsReadSecureExtra> mails_read_secure(1114);

  /**
   * generated from mail.mbox_read_errors
   * Counts mbox read failures by type.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, DynamicLabel> mbox_read_errors(1115);

  /**
   * generated from mail.notification_enabled_actions
   * The enabled actions on the new mail notification, in order.
   */
  constexpr impl::StringListMetric notification_enabled_actions(1116);

  /**
   * generated from mail.notification_used_actions
   * A count of how many times each new mail notification action is used. Labels identify the actions, as defined in MailNotificationManager.sys.mjs.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, DynamicLabel> notification_used_actions(1117);

  /**
   * generated from mail.oauth2_authentication
   */
  struct Oauth2AuthenticationExtra {
    mozilla::Maybe<nsCString> issuer;
    mozilla::Maybe<nsCString> reason;
    mozilla::Maybe<nsCString> result;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (issuer) {
        extraKeys.AppendElement()->AssignASCII("issuer");
        extraValues.EmplaceBack(issuer.value());
      }
      if (reason) {
        extraKeys.AppendElement()->AssignASCII("reason");
        extraValues.EmplaceBack(reason.value());
      }
      if (result) {
        extraKeys.AppendElement()->AssignASCII("result");
        extraValues.EmplaceBack(result.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Records each time the OAuth authentication window is displayed, including the provider's name, the reason for showing the window, and if the authentication was successful.
   */
  constexpr impl::EventMetric<Oauth2AuthenticationExtra> oauth2_authentication(1118);

  /**
   * generated from mail.oauth2_provider_count
   * A count of incoming mail accounts using OAuth2 for authentication, keyed by OAuth2 issuer.
   */
  constexpr impl::Labeled<impl::StringMetric, DynamicLabel> oauth2_provider_count(1119);

  /**
   * generated from mail.preferences_boolean
   */
  enum class PreferencesBooleanLabel: uint16_t {
    eAppUpdateServiceEnabled = 0,
    eBrowserCacheDiskSmartSizeEnabled = 1,
    eBrowserCrashreportsUnsubmittedcheckAutosubmit2 = 2,
    eBrowserDisplayUseSystemColors = 3,
    eBrowserSafebrowsingEnabled = 4,
    eDatareportingHealthreportUploadenabled = 5,
    eGeneralAutoscroll = 6,
    eGeneralSmoothscroll = 7,
    eIntlRegionalPrefsUseOsLocales = 8,
    eLayersAccelerationDisabled = 9,
    eLayoutCssAlwaysUnderlineLinks = 10,
    eLdap2AutocompleteUsedirectory = 11,
    eMailAccounthubEnabled = 12,
    eMailAccounthubAddressbookEnabled = 13,
    eMailBiffAlertShowPreview = 14,
    eMailBiffAlertShowSender = 15,
    eMailBiffAlertShowSubject = 16,
    eMailBiffPlaySound = 17,
    eMailBiffShowAlert = 18,
    eMailBiffShowTrayIcon = 19,
    eMailBiffUseSystemAlert = 20,
    eMailChatEnabled = 21,
    eMailChatPlaySound = 22,
    eMailChatShowDesktopNotifications = 23,
    eMailCloseMessageWindowOnDelete = 24,
    eMailCollectEmailAddressOutgoing = 25,
    eMailComposeAttachmentReminder = 26,
    eMailComposeAutosave = 27,
    eMailComposeBigAttachmentsNotify = 28,
    eMailComposeDefaultToParagraph = 29,
    eMailDarkReaderEnabled = 30,
    eMailDarkReaderShowToggle = 31,
    eMailDeleteMatchesSortOrder = 32,
    eMailDisplayGlyph = 33,
    eMailE2eeAutoDisable = 34,
    eMailE2eeAutoEnable = 35,
    eMailE2eeNotifyOnAutoDisable = 36,
    eMailEnableAutocomplete = 37,
    eMailFixedWidthMessages = 38,
    eMailForwardAddExtension = 39,
    eMailMdnReportEnabled = 40,
    eMailMinimizetotray = 41,
    eMailOperateOnMsgsInCollapsedThreads = 42,
    eMailPhishingDetectionEnabled = 43,
    eMailPromptPurgeThreshold = 44,
    eMailPurgeAsk = 45,
    eMailReceiptRequestReturnReceiptOn = 46,
    eMailShellCheckdefaultclient = 47,
    eMailShowcondensedaddresses = 48,
    eMailSpamLoggingEnabled = 49,
    eMailSpamManualmark = 50,
    eMailSpamMarkasreadonspam = 51,
    eMailSpellcheckInline = 52,
    eMailSpellcheckbeforesend = 53,
    eMailThreadConversationEnabled = 54,
    eMailThreadpaneTableHorizontalScroll = 55,
    eMailWarnOnSendAccelKey = 56,
    eMailnewsDatabaseGlobalIndexerEnabled = 57,
    eMailnewsDownloadtotempfile = 58,
    eMailnewsMarkMessageReadAuto = 59,
    eMailnewsMarkMessageReadDelay = 60,
    eMailnewsMessageDisplayDisableRemoteImage = 61,
    eMailnewsScrollToNewMessage = 62,
    eMailnewsSendformatAutoDowngrade = 63,
    eMailnewsStartPageEnabled = 64,
    eMessengerOptionsGetattentiononnewmessages = 65,
    eMessengerStatusAwaywhenidle = 66,
    eMessengerStatusReportidle = 67,
    eMsgcomposeDefaultColors = 68,
    eNetworkCookieBlockfuturecookies = 69,
    eNetworkProxyShareProxySettings = 70,
    eNetworkProxySocksRemoteDns = 71,
    eOfflineAutodetect = 72,
    ePlacesHistoryEnabled = 73,
    ePrivacyClearonshutdownCache = 74,
    ePrivacyDonottrackheaderEnabled = 75,
    ePurpleConversationsImSendTyping = 76,
    ePurpleLoggingLogChats = 77,
    ePurpleLoggingLogIms = 78,
    eSearchintegrationEnable = 79,
    eSignonAutologinProxy = 80,
    eWidgetGtkOverlayScrollbarsEnabled = 81,
    e__Other__,
  };
  /**
   * Values of boolean preferences.
   */
  constexpr impl::Labeled<impl::BooleanMetric, PreferencesBooleanLabel> preferences_boolean(1120);

  /**
   * generated from mail.preferences_integer
   */
  enum class PreferencesIntegerLabel: uint16_t {
    eMailAddressdisplayformat = 0,
    eMailBiffAlertPreviewLength = 1,
    eMailPaneConfigDynamic = 2,
    eMailUiDisplayDateformatDefault = 3,
    eMailUiDisplayDateformatThisweek = 4,
    eMailUiDisplayDateformatToday = 5,
    e__Other__,
  };
  /**
   * Values of integer preferences.
   */
  constexpr impl::Labeled<impl::StringMetric, PreferencesIntegerLabel> preferences_integer(1121);

  /**
   * generated from mail.successful_email_account_setup
   * How many times email accounts setup succeeded, keyed by account config source.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, DynamicLabel> successful_email_account_setup(1122);

  /**
   * generated from mail.ui_configuration_folder_tree_modes
   * Configuration of the folder tree; which modes are shown.
   */
  constexpr impl::StringListMetric ui_configuration_folder_tree_modes(1123);

  /**
   * generated from mail.ui_configuration_message_header
   */
  enum class UiConfigurationMessageHeaderLabel: uint16_t {
    eShowavatar = 0,
    eShowbigavatar = 1,
    eShowfulladdress = 2,
    eHidelabels = 3,
    eSubjectlarge = 4,
    eButtonstyle = 5,
    e__Other__,
  };
  /**
   * Configuration of the message header display. Customization state; expected values are "true" or "false". For buttonStyle values are "default", "only-icons", "only-text".
   */
  constexpr impl::Labeled<impl::StringMetric, UiConfigurationMessageHeaderLabel> ui_configuration_message_header(1124);

  /**
   * generated from mail.ui_configuration_pane_visibility
   */
  enum class UiConfigurationPaneVisibilityLabel: uint16_t {
    eFolderpane = 0,
    eMessagepane = 1,
    e__Other__,
  };
  /**
   * Configuration of the folder and message panes. Whether they are set to be shown or not.
   */
  constexpr impl::Labeled<impl::BooleanMetric, UiConfigurationPaneVisibilityLabel> ui_configuration_pane_visibility(1125);

  /**
   * generated from mail.ui_interaction
   */
  struct UiInteractionExtra {
    mozilla::Maybe<nsCString> id;
    mozilla::Maybe<nsCString> source;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (id) {
        extraKeys.AppendElement()->AssignASCII("id");
        extraValues.EmplaceBack(id.value());
      }
      if (source) {
        extraKeys.AppendElement()->AssignASCII("source");
        extraValues.EmplaceBack(source.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Records a count of interactions with various UI widgets.
   */
  constexpr impl::EventMetric<UiInteractionExtra> ui_interaction(1126);

  /**
   * generated from mail.websearch_usage
   * How many times search the web was used, keyed by search engine name.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, DynamicLabel> websearch_usage(1127);
}

template <>
inline void impl::ObjectMetric<mail::AccountPreferencesObject, mail::AccountPreferencesObjectTag>::Set(const mail::AccountPreferencesObject& aObj) const {
  nsCString json;
  JSONStringRefWriteFunc writeFunc(json);
  JSONWriter writer(writeFunc, JSONWriter::CollectionStyle::SingleLineStyle);

  writer.StartArrayElement();
  {
    for (const auto& aobjItem: aObj) {
      writer.StartObjectElement();
      {
        if (aobjItem.protocol.isSome()) {
          writer.StringProperty("protocol", *(aobjItem.protocol));
        }
        if (aobjItem.socket_type.isSome()) {
          writer.IntProperty("socket_type", *(aobjItem.socket_type));
        }
        if (aobjItem.auth_method.isSome()) {
          writer.IntProperty("auth_method", *(aobjItem.auth_method));
        }
        if (aobjItem.store_type.isSome()) {
          writer.StringProperty("store_type", *(aobjItem.store_type));
        }
        if (aobjItem.login_at_startup.isSome()) {
          writer.BoolProperty("login_at_startup", *(aobjItem.login_at_startup));
        }
        if (aobjItem.check_new_mail.isSome()) {
          writer.BoolProperty("check_new_mail", *(aobjItem.check_new_mail));
        }
        if (aobjItem.check_time.isSome()) {
          writer.IntProperty("check_time", *(aobjItem.check_time));
        }
        if (aobjItem.delete_model.isSome()) {
          writer.IntProperty("delete_model", *(aobjItem.delete_model));
        }
        if (aobjItem.use_idle.isSome()) {
          writer.BoolProperty("use_idle", *(aobjItem.use_idle));
        }
        if (aobjItem.cleanup_inbox_on_exit.isSome()) {
          writer.BoolProperty("cleanup_inbox_on_exit", *(aobjItem.cleanup_inbox_on_exit));
        }
        if (aobjItem.empty_trash_on_exit.isSome()) {
          writer.BoolProperty("empty_trash_on_exit", *(aobjItem.empty_trash_on_exit));
        }
        if (aobjItem.download_on_biff.isSome()) {
          writer.BoolProperty("download_on_biff", *(aobjItem.download_on_biff));
        }
        if (aobjItem.headers_only.isSome()) {
          writer.BoolProperty("headers_only", *(aobjItem.headers_only));
        }
        if (aobjItem.leave_on_server.isSome()) {
          writer.BoolProperty("leave_on_server", *(aobjItem.leave_on_server));
        }
        if (aobjItem.delete_by_age_from_server.isSome()) {
          writer.BoolProperty("delete_by_age_from_server", *(aobjItem.delete_by_age_from_server));
        }
        if (aobjItem.num_days_to_leave_on_server.isSome()) {
          writer.IntProperty("num_days_to_leave_on_server", *(aobjItem.num_days_to_leave_on_server));
        }
        if (aobjItem.notify_max_articles.isSome()) {
          writer.IntProperty("notify_max_articles", *(aobjItem.notify_max_articles));
        }
        if (aobjItem.always_authenticate.isSome()) {
          writer.BoolProperty("always_authenticate", *(aobjItem.always_authenticate));
        }
      }
      writer.EndObject();

    }
  }
  writer.EndArray();


  SetStr(json);
}

} // namespace mozilla::glean

#endif // mozilla_GleanCommMailMetrics_h
