/* Automatically generated by wasm2c */
#include <assert.h>
#include <math.h>
#include <stdarg.h>
#include <stddef.h>
#include <string.h>
#if defined(__MINGW32__)
#include <malloc.h>
#elif defined(_MSC_VER)
#include <intrin.h>
#include <malloc.h>
#define alloca _alloca
#elif defined(__FreeBSD__) || defined(__OpenBSD__)
#include <stdlib.h>
#else
#include <alloca.h>
#endif

#include "rlbox.wasm.h"
#define IS_SINGLE_UNSHARED_MEMORY 1

// Computes a pointer to an object of the given size in a little-endian memory.
//
// On a little-endian host, this is just &mem->data[addr] - the object's size is
// unused. On a big-endian host, it's &mem->data[mem->size - addr - n], where n
// is the object's size.
//
// Note that mem may be evaluated multiple times.
//
// Parameters:
// mem - The memory.
// addr - The address.
// n - The size of the object.
//
// Result:
// A pointer for an object of size n.
#if WABT_BIG_ENDIAN
#define MEM_ADDR(mem, addr, n) &(mem)->data[(mem)->size - (addr) - (n)]
#else
#define MEM_ADDR(mem, addr, n) &(mem)->data[addr]
#endif

// We can only use Segue for this module if it uses a single unshared imported
// or exported memory
#if WASM_RT_USE_SEGUE && IS_SINGLE_UNSHARED_MEMORY
#define WASM_RT_USE_SEGUE_FOR_THIS_MODULE 1
#else
#define WASM_RT_USE_SEGUE_FOR_THIS_MODULE 0
#endif

#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE
// POSIX uses FS for TLS, GS is free
static inline void* wasm_rt_segue_read_base() {
  if (wasm_rt_fsgsbase_inst_supported) {
    return (void*)__builtin_ia32_rdgsbase64();
  } else {
    return wasm_rt_syscall_get_segue_base();
  }
}
static inline void wasm_rt_segue_write_base(void* base) {
#if WASM_RT_SEGUE_FREE_SEGMENT
  if (wasm_rt_last_segment_val == base) {
    return;
  }

  wasm_rt_last_segment_val = base;
#endif

  if (wasm_rt_fsgsbase_inst_supported) {
    __builtin_ia32_wrgsbase64((uintptr_t)base);
  } else {
    wasm_rt_syscall_set_segue_base(base);
  }
}
#define MEM_ADDR_MEMOP(mem, addr, n) ((uint8_t __seg_gs*)(uintptr_t)addr)
#else
#define MEM_ADDR_MEMOP(mem, addr, n) MEM_ADDR(mem, addr, n)
#endif

#define TRAP(x) (wasm_rt_trap(WASM_RT_TRAP_##x), 0)

#if WASM_RT_STACK_DEPTH_COUNT
#define FUNC_PROLOGUE                                            \
  if (++wasm_rt_call_stack_depth > WASM_RT_MAX_CALL_STACK_DEPTH) \
    TRAP(EXHAUSTION);

#define FUNC_EPILOGUE --wasm_rt_call_stack_depth
#else
#define FUNC_PROLOGUE

#define FUNC_EPILOGUE
#endif

#define UNREACHABLE TRAP(UNREACHABLE)

static inline bool func_types_eq(const wasm_rt_func_type_t a,
                                 const wasm_rt_func_type_t b) {
  return (a == b) || LIKELY(a && b && !memcmp(a, b, 32));
}

#define CHECK_CALL_INDIRECT(table, ft, x)                \
  (LIKELY((x) < table.size && table.data[x].func &&      \
          func_types_eq(ft, table.data[x].func_type)) || \
   TRAP(CALL_INDIRECT))

#define DO_CALL_INDIRECT(table, t, x, ...) ((t)table.data[x].func)(__VA_ARGS__)

#define CALL_INDIRECT(table, t, ft, x, ...) \
  (CHECK_CALL_INDIRECT(table, ft, x),       \
   DO_CALL_INDIRECT(table, t, x, __VA_ARGS__))

#ifdef SUPPORT_MEMORY64
#define RANGE_CHECK(mem, offset, len)              \
  do {                                             \
    uint64_t res;                                  \
    if (__builtin_add_overflow(offset, len, &res)) \
      TRAP(OOB);                                   \
    if (UNLIKELY(res > mem->size))                 \
      TRAP(OOB);                                   \
  } while (0);
#else
#define RANGE_CHECK(mem, offset, len)               \
  if (UNLIKELY(offset + (uint64_t)len > mem->size)) \
    TRAP(OOB);
#endif

#if WASM_RT_USE_SEGUE_FOR_THIS_MODULE && WASM_RT_SANITY_CHECKS
#include <stdio.h>
#define WASM_RT_CHECK_BASE(mem)                                               \
  if (((uintptr_t)((mem)->data)) != ((uintptr_t)wasm_rt_segue_read_base())) { \
    puts("Segment register mismatch\n");                                      \
    abort();                                                                  \
  }
#else
#define WASM_RT_CHECK_BASE(mem)
#endif

#if WASM_RT_MEMCHECK_GUARD_PAGES
#define MEMCHECK(mem, a, t) WASM_RT_CHECK_BASE(mem);
#else
#define MEMCHECK(mem, a, t) \
  WASM_RT_CHECK_BASE(mem);  \
  RANGE_CHECK(mem, a, sizeof(t))
#endif

#ifdef __GNUC__
#define FORCE_READ_INT(var) __asm__("" ::"r"(var));
// Clang on Mips requires "f" constraints on floats
// See https://github.com/llvm/llvm-project/issues/64241
#if defined(__clang__) && \
    (defined(mips) || defined(__mips__) || defined(__mips))
#define FORCE_READ_FLOAT(var) __asm__("" ::"f"(var));
#else
#define FORCE_READ_FLOAT(var) __asm__("" ::"r"(var));
#endif
#else
#define FORCE_READ_INT(var)
#define FORCE_READ_FLOAT(var)
#endif

static inline void load_data(void* dest, const void* src, size_t n) {
  if (!n) {
    return;
  }
  wasm_rt_memcpy(dest, src, n);
#if WABT_BIG_ENDIAN
  u8* dest_chars = dest;
  for (size_t i = 0; i < (n >> 1); i++) {
    u8 cursor = dest_chars[i];
    dest_chars[i] = dest_chars[n - i - 1];
    dest_chars[n - i - 1] = cursor;
  }
#endif
}

#define LOAD_DATA(m, o, i, s)            \
  do {                                   \
    RANGE_CHECK((&m), o, s);             \
    load_data(MEM_ADDR(&m, o, s), i, s); \
  } while (0)

#define DEFINE_LOAD(name, t1, t2, t3, force_read)                  \
  static inline t3 name(wasm_rt_memory_t* mem, u64 addr) {         \
    MEMCHECK(mem, addr, t1);                                       \
    t1 result;                                                     \
    wasm_rt_memcpy(&result, MEM_ADDR_MEMOP(mem, addr, sizeof(t1)), \
                   sizeof(t1));                                    \
    force_read(result);                                            \
    return (t3)(t2)result;                                         \
  }

#define DEFINE_STORE(name, t1, t2)                                     \
  static inline void name(wasm_rt_memory_t* mem, u64 addr, t2 value) { \
    MEMCHECK(mem, addr, t1);                                           \
    t1 wrapped = (t1)value;                                            \
    wasm_rt_memcpy(MEM_ADDR_MEMOP(mem, addr, sizeof(t1)), &wrapped,    \
                   sizeof(t1));                                        \
  }

DEFINE_LOAD(i32_load, u32, u32, u32, FORCE_READ_INT)
DEFINE_LOAD(i64_load, u64, u64, u64, FORCE_READ_INT)
DEFINE_LOAD(f32_load, f32, f32, f32, FORCE_READ_FLOAT)
DEFINE_LOAD(f64_load, f64, f64, f64, FORCE_READ_FLOAT)
DEFINE_LOAD(i32_load8_s, s8, s32, u32, FORCE_READ_INT)
DEFINE_LOAD(i64_load8_s, s8, s64, u64, FORCE_READ_INT)
DEFINE_LOAD(i32_load8_u, u8, u32, u32, FORCE_READ_INT)
DEFINE_LOAD(i64_load8_u, u8, u64, u64, FORCE_READ_INT)
DEFINE_LOAD(i32_load16_s, s16, s32, u32, FORCE_READ_INT)
DEFINE_LOAD(i64_load16_s, s16, s64, u64, FORCE_READ_INT)
DEFINE_LOAD(i32_load16_u, u16, u32, u32, FORCE_READ_INT)
DEFINE_LOAD(i64_load16_u, u16, u64, u64, FORCE_READ_INT)
DEFINE_LOAD(i64_load32_s, s32, s64, u64, FORCE_READ_INT)
DEFINE_LOAD(i64_load32_u, u32, u64, u64, FORCE_READ_INT)
DEFINE_STORE(i32_store, u32, u32)
DEFINE_STORE(i64_store, u64, u64)
DEFINE_STORE(f32_store, f32, f32)
DEFINE_STORE(f64_store, f64, f64)
DEFINE_STORE(i32_store8, u8, u32)
DEFINE_STORE(i32_store16, u16, u32)
DEFINE_STORE(i64_store8, u8, u64)
DEFINE_STORE(i64_store16, u16, u64)
DEFINE_STORE(i64_store32, u32, u64)

#if defined(_MSC_VER)

// Adapted from
// https://github.com/nemequ/portable-snippets/blob/master/builtin/builtin.h

static inline int I64_CLZ(unsigned long long v) {
  unsigned long r = 0;
#if defined(_M_AMD64) || defined(_M_ARM)
  if (_BitScanReverse64(&r, v)) {
    return 63 - r;
  }
#else
  if (_BitScanReverse(&r, (unsigned long)(v >> 32))) {
    return 31 - r;
  } else if (_BitScanReverse(&r, (unsigned long)v)) {
    return 63 - r;
  }
#endif
  return 64;
}

static inline int I32_CLZ(unsigned long v) {
  unsigned long r = 0;
  if (_BitScanReverse(&r, v)) {
    return 31 - r;
  }
  return 32;
}

static inline int I64_CTZ(unsigned long long v) {
  if (!v) {
    return 64;
  }
  unsigned long r = 0;
#if defined(_M_AMD64) || defined(_M_ARM)
  _BitScanForward64(&r, v);
  return (int)r;
#else
  if (_BitScanForward(&r, (unsigned int)(v))) {
    return (int)(r);
  }

  _BitScanForward(&r, (unsigned int)(v >> 32));
  return (int)(r + 32);
#endif
}

static inline int I32_CTZ(unsigned long v) {
  if (!v) {
    return 32;
  }
  unsigned long r = 0;
  _BitScanForward(&r, v);
  return (int)r;
}

#define POPCOUNT_DEFINE_PORTABLE(f_n, T)                            \
  static inline u32 f_n(T x) {                                      \
    x = x - ((x >> 1) & (T) ~(T)0 / 3);                             \
    x = (x & (T) ~(T)0 / 15 * 3) + ((x >> 2) & (T) ~(T)0 / 15 * 3); \
    x = (x + (x >> 4)) & (T) ~(T)0 / 255 * 15;                      \
    return (T)(x * ((T) ~(T)0 / 255)) >> (sizeof(T) - 1) * 8;       \
  }

POPCOUNT_DEFINE_PORTABLE(I32_POPCNT, u32)
POPCOUNT_DEFINE_PORTABLE(I64_POPCNT, u64)

#undef POPCOUNT_DEFINE_PORTABLE

#else

#define I32_CLZ(x) ((x) ? __builtin_clz(x) : 32)
#define I64_CLZ(x) ((x) ? __builtin_clzll(x) : 64)
#define I32_CTZ(x) ((x) ? __builtin_ctz(x) : 32)
#define I64_CTZ(x) ((x) ? __builtin_ctzll(x) : 64)
#define I32_POPCNT(x) (__builtin_popcount(x))
#define I64_POPCNT(x) (__builtin_popcountll(x))

#endif

#define DIV_S(ut, min, x, y)                                      \
  ((UNLIKELY((y) == 0))                                           \
       ? TRAP(DIV_BY_ZERO)                                        \
       : (UNLIKELY((x) == min && (y) == -1)) ? TRAP(INT_OVERFLOW) \
                                             : (ut)((x) / (y)))

#define REM_S(ut, min, x, y) \
  ((UNLIKELY((y) == 0))      \
       ? TRAP(DIV_BY_ZERO)   \
       : (UNLIKELY((x) == min && (y) == -1)) ? 0 : (ut)((x) % (y)))

#define I32_DIV_S(x, y) DIV_S(u32, INT32_MIN, (s32)x, (s32)y)
#define I64_DIV_S(x, y) DIV_S(u64, INT64_MIN, (s64)x, (s64)y)
#define I32_REM_S(x, y) REM_S(u32, INT32_MIN, (s32)x, (s32)y)
#define I64_REM_S(x, y) REM_S(u64, INT64_MIN, (s64)x, (s64)y)

#define DIVREM_U(op, x, y) \
  ((UNLIKELY((y) == 0)) ? TRAP(DIV_BY_ZERO) : ((x)op(y)))

#define DIV_U(x, y) DIVREM_U(/, x, y)
#define REM_U(x, y) DIVREM_U(%, x, y)

#define ROTL(x, y, mask) \
  (((x) << ((y) & (mask))) | ((x) >> (((mask) - (y) + 1) & (mask))))
#define ROTR(x, y, mask) \
  (((x) >> ((y) & (mask))) | ((x) << (((mask) - (y) + 1) & (mask))))

#define I32_ROTL(x, y) ROTL(x, y, 31)
#define I64_ROTL(x, y) ROTL(x, y, 63)
#define I32_ROTR(x, y) ROTR(x, y, 31)
#define I64_ROTR(x, y) ROTR(x, y, 63)

#define FMIN(x, y)                                                     \
  ((UNLIKELY((x) != (x)))                                              \
       ? NAN                                                           \
       : (UNLIKELY((y) != (y)))                                        \
             ? NAN                                                     \
             : (UNLIKELY((x) == 0 && (y) == 0)) ? (signbit(x) ? x : y) \
                                                : (x < y) ? x : y)

#define FMAX(x, y)                                                     \
  ((UNLIKELY((x) != (x)))                                              \
       ? NAN                                                           \
       : (UNLIKELY((y) != (y)))                                        \
             ? NAN                                                     \
             : (UNLIKELY((x) == 0 && (y) == 0)) ? (signbit(x) ? y : x) \
                                                : (x > y) ? x : y)

#define TRUNC_S(ut, st, ft, min, minop, max, x)                           \
  ((UNLIKELY((x) != (x)))                                                 \
       ? TRAP(INVALID_CONVERSION)                                         \
       : (UNLIKELY(!((x)minop(min) && (x) < (max)))) ? TRAP(INT_OVERFLOW) \
                                                     : (ut)(st)(x))

#define I32_TRUNC_S_F32(x) \
  TRUNC_S(u32, s32, f32, (f32)INT32_MIN, >=, 2147483648.f, x)
#define I64_TRUNC_S_F32(x) \
  TRUNC_S(u64, s64, f32, (f32)INT64_MIN, >=, (f32)INT64_MAX, x)
#define I32_TRUNC_S_F64(x) \
  TRUNC_S(u32, s32, f64, -2147483649., >, 2147483648., x)
#define I64_TRUNC_S_F64(x) \
  TRUNC_S(u64, s64, f64, (f64)INT64_MIN, >=, (f64)INT64_MAX, x)

#define TRUNC_U(ut, ft, max, x)                                          \
  ((UNLIKELY((x) != (x)))                                                \
       ? TRAP(INVALID_CONVERSION)                                        \
       : (UNLIKELY(!((x) > (ft)-1 && (x) < (max)))) ? TRAP(INT_OVERFLOW) \
                                                    : (ut)(x))

#define I32_TRUNC_U_F32(x) TRUNC_U(u32, f32, 4294967296.f, x)
#define I64_TRUNC_U_F32(x) TRUNC_U(u64, f32, (f32)UINT64_MAX, x)
#define I32_TRUNC_U_F64(x) TRUNC_U(u32, f64, 4294967296., x)
#define I64_TRUNC_U_F64(x) TRUNC_U(u64, f64, (f64)UINT64_MAX, x)

#define TRUNC_SAT_S(ut, st, ft, min, smin, minop, max, smax, x) \
  ((UNLIKELY((x) != (x)))                                       \
       ? 0                                                      \
       : (UNLIKELY(!((x)minop(min))))                           \
             ? smin                                             \
             : (UNLIKELY(!((x) < (max)))) ? smax : (ut)(st)(x))

#define I32_TRUNC_SAT_S_F32(x)                                            \
  TRUNC_SAT_S(u32, s32, f32, (f32)INT32_MIN, INT32_MIN, >=, 2147483648.f, \
              INT32_MAX, x)
#define I64_TRUNC_SAT_S_F32(x)                                              \
  TRUNC_SAT_S(u64, s64, f32, (f32)INT64_MIN, INT64_MIN, >=, (f32)INT64_MAX, \
              INT64_MAX, x)
#define I32_TRUNC_SAT_S_F64(x)                                        \
  TRUNC_SAT_S(u32, s32, f64, -2147483649., INT32_MIN, >, 2147483648., \
              INT32_MAX, x)
#define I64_TRUNC_SAT_S_F64(x)                                              \
  TRUNC_SAT_S(u64, s64, f64, (f64)INT64_MIN, INT64_MIN, >=, (f64)INT64_MAX, \
              INT64_MAX, x)

#define TRUNC_SAT_U(ut, ft, max, smax, x)               \
  ((UNLIKELY((x) != (x))) ? 0                           \
                          : (UNLIKELY(!((x) > (ft)-1))) \
                                ? 0                     \
                                : (UNLIKELY(!((x) < (max)))) ? smax : (ut)(x))

#define I32_TRUNC_SAT_U_F32(x) \
  TRUNC_SAT_U(u32, f32, 4294967296.f, UINT32_MAX, x)
#define I64_TRUNC_SAT_U_F32(x) \
  TRUNC_SAT_U(u64, f32, (f32)UINT64_MAX, UINT64_MAX, x)
#define I32_TRUNC_SAT_U_F64(x) TRUNC_SAT_U(u32, f64, 4294967296., UINT32_MAX, x)
#define I64_TRUNC_SAT_U_F64(x) \
  TRUNC_SAT_U(u64, f64, (f64)UINT64_MAX, UINT64_MAX, x)

#define DEFINE_REINTERPRET(name, t1, t2)         \
  static inline t2 name(t1 x) {                  \
    t2 result;                                   \
    wasm_rt_memcpy(&result, &x, sizeof(result)); \
    return result;                               \
  }

DEFINE_REINTERPRET(f32_reinterpret_i32, u32, f32)
DEFINE_REINTERPRET(i32_reinterpret_f32, f32, u32)
DEFINE_REINTERPRET(f64_reinterpret_i64, u64, f64)
DEFINE_REINTERPRET(i64_reinterpret_f64, f64, u64)

static float quiet_nanf(float x) {
  uint32_t tmp;
  wasm_rt_memcpy(&tmp, &x, 4);
  tmp |= 0x7fc00000lu;
  wasm_rt_memcpy(&x, &tmp, 4);
  return x;
}

static double quiet_nan(double x) {
  uint64_t tmp;
  wasm_rt_memcpy(&tmp, &x, 8);
  tmp |= 0x7ff8000000000000llu;
  wasm_rt_memcpy(&x, &tmp, 8);
  return x;
}

static double wasm_quiet(double x) {
  if (UNLIKELY(isnan(x))) {
    return quiet_nan(x);
  }
  return x;
}

static float wasm_quietf(float x) {
  if (UNLIKELY(isnan(x))) {
    return quiet_nanf(x);
  }
  return x;
}

static double wasm_floor(double x) {
  if (UNLIKELY(isnan(x))) {
    return quiet_nan(x);
  }
  return floor(x);
}

static float wasm_floorf(float x) {
  if (UNLIKELY(isnan(x))) {
    return quiet_nanf(x);
  }
  return floorf(x);
}

static double wasm_ceil(double x) {
  if (UNLIKELY(isnan(x))) {
    return quiet_nan(x);
  }
  return ceil(x);
}

static float wasm_ceilf(float x) {
  if (UNLIKELY(isnan(x))) {
    return quiet_nanf(x);
  }
  return ceilf(x);
}

static double wasm_trunc(double x) {
  if (UNLIKELY(isnan(x))) {
    return quiet_nan(x);
  }
  return trunc(x);
}

static float wasm_truncf(float x) {
  if (UNLIKELY(isnan(x))) {
    return quiet_nanf(x);
  }
  return truncf(x);
}

static float wasm_nearbyintf(float x) {
  if (UNLIKELY(isnan(x))) {
    return quiet_nanf(x);
  }
  return nearbyintf(x);
}

static double wasm_nearbyint(double x) {
  if (UNLIKELY(isnan(x))) {
    return quiet_nan(x);
  }
  return nearbyint(x);
}

static float wasm_fabsf(float x) {
  if (UNLIKELY(isnan(x))) {
    uint32_t tmp;
    wasm_rt_memcpy(&tmp, &x, 4);
    tmp = tmp & ~(1UL << 31);
    wasm_rt_memcpy(&x, &tmp, 4);
    return x;
  }
  return fabsf(x);
}

static double wasm_fabs(double x) {
  if (UNLIKELY(isnan(x))) {
    uint64_t tmp;
    wasm_rt_memcpy(&tmp, &x, 8);
    tmp = tmp & ~(1ULL << 63);
    wasm_rt_memcpy(&x, &tmp, 8);
    return x;
  }
  return fabs(x);
}

static double wasm_sqrt(double x) {
  if (UNLIKELY(isnan(x))) {
    return quiet_nan(x);
  }
  return sqrt(x);
}

static float wasm_sqrtf(float x) {
  if (UNLIKELY(isnan(x))) {
    return quiet_nanf(x);
  }
  return sqrtf(x);
}

static inline void memory_fill(wasm_rt_memory_t* mem, u32 d, u32 val, u32 n) {
  RANGE_CHECK(mem, d, n);
  memset(MEM_ADDR(mem, d, n), val, n);
}

static inline void memory_copy(wasm_rt_memory_t* dest,
                               const wasm_rt_memory_t* src,
                               u32 dest_addr,
                               u32 src_addr,
                               u32 n) {
  RANGE_CHECK(dest, dest_addr, n);
  RANGE_CHECK(src, src_addr, n);
  memmove(MEM_ADDR(dest, dest_addr, n), MEM_ADDR(src, src_addr, n), n);
}

static inline void memory_init(wasm_rt_memory_t* dest,
                               const u8* src,
                               u32 src_size,
                               u32 dest_addr,
                               u32 src_addr,
                               u32 n) {
  if (UNLIKELY(src_addr + (uint64_t)n > src_size))
    TRAP(OOB);
  LOAD_DATA((*dest), dest_addr, src + src_addr, n);
}

typedef struct {
  enum { RefFunc, RefNull, GlobalGet } expr_type;
  wasm_rt_func_type_t type;
  wasm_rt_function_ptr_t func;
  wasm_rt_tailcallee_t func_tailcallee;
  size_t module_offset;
} wasm_elem_segment_expr_t;

static inline void funcref_table_init(wasm_rt_funcref_table_t* dest,
                                      const wasm_elem_segment_expr_t* src,
                                      u32 src_size,
                                      u32 dest_addr,
                                      u32 src_addr,
                                      u32 n,
                                      void* module_instance) {
  if (UNLIKELY(src_addr + (uint64_t)n > src_size))
    TRAP(OOB);
  if (UNLIKELY(dest_addr + (uint64_t)n > dest->size))
    TRAP(OOB);
  for (u32 i = 0; i < n; i++) {
    const wasm_elem_segment_expr_t* const src_expr = &src[src_addr + i];
    wasm_rt_funcref_t* const dest_val = &(dest->data[dest_addr + i]);
    switch (src_expr->expr_type) {
      case RefFunc:
        *dest_val = (wasm_rt_funcref_t){
            src_expr->type, src_expr->func, src_expr->func_tailcallee,
            (char*)module_instance + src_expr->module_offset};
        break;
      case RefNull:
        *dest_val = wasm_rt_funcref_null_value;
        break;
      case GlobalGet:
        *dest_val = **(wasm_rt_funcref_t**)((char*)module_instance +
                                            src_expr->module_offset);
        break;
    }
  }
}

// Currently wasm2c only supports initializing externref tables with ref.null.
static inline void externref_table_init(wasm_rt_externref_table_t* dest,
                                        u32 src_size,
                                        u32 dest_addr,
                                        u32 src_addr,
                                        u32 n) {
  if (UNLIKELY(src_addr + (uint64_t)n > src_size))
    TRAP(OOB);
  if (UNLIKELY(dest_addr + (uint64_t)n > dest->size))
    TRAP(OOB);
  for (u32 i = 0; i < n; i++) {
    dest->data[dest_addr + i] = wasm_rt_externref_null_value;
  }
}

#define DEFINE_TABLE_COPY(type)                                              \
  static inline void type##_table_copy(wasm_rt_##type##_table_t* dest,       \
                                       const wasm_rt_##type##_table_t* src,  \
                                       u32 dest_addr, u32 src_addr, u32 n) { \
    if (UNLIKELY(dest_addr + (uint64_t)n > dest->size))                      \
      TRAP(OOB);                                                             \
    if (UNLIKELY(src_addr + (uint64_t)n > src->size))                        \
      TRAP(OOB);                                                             \
                                                                             \
    memmove(dest->data + dest_addr, src->data + src_addr,                    \
            n * sizeof(wasm_rt_##type##_t));                                 \
  }

DEFINE_TABLE_COPY(funcref)
DEFINE_TABLE_COPY(externref)

#define DEFINE_TABLE_GET(type)                        \
  static inline wasm_rt_##type##_t type##_table_get(  \
      const wasm_rt_##type##_table_t* table, u32 i) { \
    if (UNLIKELY(i >= table->size))                   \
      TRAP(OOB);                                      \
    return table->data[i];                            \
  }

DEFINE_TABLE_GET(funcref)
DEFINE_TABLE_GET(externref)

#define DEFINE_TABLE_SET(type)                                               \
  static inline void type##_table_set(const wasm_rt_##type##_table_t* table, \
                                      u32 i, const wasm_rt_##type##_t val) { \
    if (UNLIKELY(i >= table->size))                                          \
      TRAP(OOB);                                                             \
    table->data[i] = val;                                                    \
  }

DEFINE_TABLE_SET(funcref)
DEFINE_TABLE_SET(externref)

#define DEFINE_TABLE_FILL(type)                                               \
  static inline void type##_table_fill(const wasm_rt_##type##_table_t* table, \
                                       u32 d, const wasm_rt_##type##_t val,   \
                                       u32 n) {                               \
    if (UNLIKELY((uint64_t)d + n > table->size))                              \
      TRAP(OOB);                                                              \
    for (uint32_t i = d; i < d + n; i++) {                                    \
      table->data[i] = val;                                                   \
    }                                                                         \
  }

DEFINE_TABLE_FILL(funcref)
DEFINE_TABLE_FILL(externref)

#if defined(__GNUC__) || defined(__clang__)
#define FUNC_TYPE_DECL_EXTERN_T(x) extern const char* const x
#define FUNC_TYPE_EXTERN_T(x) const char* const x
#define FUNC_TYPE_T(x) static const char* const x
#else
#define FUNC_TYPE_DECL_EXTERN_T(x) extern const char x[]
#define FUNC_TYPE_EXTERN_T(x) const char x[]
#define FUNC_TYPE_T(x) static const char x[]
#endif

#if (__STDC_VERSION__ < 201112L) && !defined(static_assert)
#define static_assert(X) \
  extern int(*assertion(void))[!!sizeof(struct { int x : (X) ? 2 : -1; })];
#endif

#ifdef _MSC_VER
#define WEAK_FUNC_DECL(func, fallback)                             \
  __pragma(comment(linker, "/alternatename:" #func "=" #fallback)) \
                                                                   \
      void                                                         \
      fallback(void** instance_ptr, void* tail_call_stack,         \
               wasm_rt_tailcallee_t* next)
#else
#define WEAK_FUNC_DECL(func, fallback)                                        \
  __attribute__((weak)) void func(void** instance_ptr, void* tail_call_stack, \
                                  wasm_rt_tailcallee_t* next)
#endif

#include <simde/wasm/simd128.h>

#ifndef WASM_RT_SIMD_TYPE_DEFINED
#define WASM_RT_SIMD_TYPE_DEFINED
typedef simde_v128_t v128;
#endif

#if defined(__GNUC__) && defined(__x86_64__)
#define SIMD_FORCE_READ(var) __asm__("" ::"x"(var));
#elif defined(__GNUC__) && defined(__aarch64__)
#define SIMD_FORCE_READ(var) __asm__("" ::"w"(var));
#else
#define SIMD_FORCE_READ(var)
#endif
// TODO: equivalent constraint for ARM and other architectures

#define DEFINE_SIMD_LOAD_FUNC(name, func, t)                 \
  static inline v128 name(wasm_rt_memory_t* mem, u64 addr) { \
    MEMCHECK(mem, addr, t);                                  \
    v128 result = func(MEM_ADDR(mem, addr, sizeof(t)));      \
    SIMD_FORCE_READ(result);                                 \
    return result;                                           \
  }

#define DEFINE_SIMD_LOAD_LANE(name, func, t, lane)                     \
  static inline v128 name(wasm_rt_memory_t* mem, u64 addr, v128 vec) { \
    MEMCHECK(mem, addr, t);                                            \
    v128 result = func(MEM_ADDR(mem, addr, sizeof(t)), vec, lane);     \
    SIMD_FORCE_READ(result);                                           \
    return result;                                                     \
  }

#define DEFINE_SIMD_STORE(name, t)                                       \
  static inline void name(wasm_rt_memory_t* mem, u64 addr, v128 value) { \
    MEMCHECK(mem, addr, t);                                              \
    simde_wasm_v128_store(MEM_ADDR(mem, addr, sizeof(t)), value);        \
  }

#define DEFINE_SIMD_STORE_LANE(name, func, t, lane)                      \
  static inline void name(wasm_rt_memory_t* mem, u64 addr, v128 value) { \
    MEMCHECK(mem, addr, t);                                              \
    func(MEM_ADDR(mem, addr, sizeof(t)), value, lane);                   \
  }

// clang-format off
#if WABT_BIG_ENDIAN
static inline v128 v128_impl_load32_zero(const void* a) {
  return simde_wasm_i8x16_swizzle(
      simde_wasm_v128_load32_zero(a),
      simde_wasm_i8x16_const(12,13,14,15,8,9,10,11,4,5,6,7,0,1,2,3));
}
static inline v128 v128_impl_load64_zero(const void* a) {
  return simde_wasm_i8x16_swizzle(
      simde_wasm_v128_load64_zero(a),
      simde_wasm_i8x16_const(8,9,10,11,12,13,14,15,0,1,2,3,4,5,6,7));
}
#else
#define v128_impl_load32_zero simde_wasm_v128_load32_zero
#define v128_impl_load64_zero simde_wasm_v128_load64_zero
#endif

DEFINE_SIMD_LOAD_FUNC(v128_load, simde_wasm_v128_load, v128)

DEFINE_SIMD_LOAD_FUNC(v128_load8_splat, simde_wasm_v128_load8_splat, u8)
DEFINE_SIMD_LOAD_FUNC(v128_load16_splat, simde_wasm_v128_load16_splat, u16)
DEFINE_SIMD_LOAD_FUNC(v128_load32_splat, simde_wasm_v128_load32_splat, u32)
DEFINE_SIMD_LOAD_FUNC(v128_load64_splat, simde_wasm_v128_load64_splat, u64)

DEFINE_SIMD_LOAD_FUNC(i16x8_load8x8, simde_wasm_i16x8_load8x8, u64)
DEFINE_SIMD_LOAD_FUNC(u16x8_load8x8, simde_wasm_u16x8_load8x8, u64)
DEFINE_SIMD_LOAD_FUNC(i32x4_load16x4, simde_wasm_i32x4_load16x4, u64)
DEFINE_SIMD_LOAD_FUNC(u32x4_load16x4, simde_wasm_u32x4_load16x4, u64)
DEFINE_SIMD_LOAD_FUNC(i64x2_load32x2, simde_wasm_i64x2_load32x2, u64)
DEFINE_SIMD_LOAD_FUNC(u64x2_load32x2, simde_wasm_u64x2_load32x2, u64)

DEFINE_SIMD_LOAD_FUNC(v128_load32_zero, v128_impl_load32_zero, u32)
DEFINE_SIMD_LOAD_FUNC(v128_load64_zero, v128_impl_load64_zero, u64)

#if WABT_BIG_ENDIAN
DEFINE_SIMD_LOAD_LANE(v128_load8_lane0, simde_wasm_v128_load8_lane, u8, 15)
DEFINE_SIMD_LOAD_LANE(v128_load8_lane1, simde_wasm_v128_load8_lane, u8, 14)
DEFINE_SIMD_LOAD_LANE(v128_load8_lane2, simde_wasm_v128_load8_lane, u8, 13)
DEFINE_SIMD_LOAD_LANE(v128_load8_lane3, simde_wasm_v128_load8_lane, u8, 12)
DEFINE_SIMD_LOAD_LANE(v128_load8_lane4, simde_wasm_v128_load8_lane, u8, 11)
DEFINE_SIMD_LOAD_LANE(v128_load8_lane5, simde_wasm_v128_load8_lane, u8, 10)
DEFINE_SIMD_LOAD_LANE(v128_load8_lane6, simde_wasm_v128_load8_lane, u8, 9)
DEFINE_SIMD_LOAD_LANE(v128_load8_lane7, simde_wasm_v128_load8_lane, u8, 8)
DEFINE_SIMD_LOAD_LANE(v128_load8_lane8, simde_wasm_v128_load8_lane, u8, 7)
DEFINE_SIMD_LOAD_LANE(v128_load8_lane9, simde_wasm_v128_load8_lane, u8, 6)
DEFINE_SIMD_LOAD_LANE(v128_load8_lane10, simde_wasm_v128_load8_lane, u8, 5)
DEFINE_SIMD_LOAD_LANE(v128_load8_lane11, simde_wasm_v128_load8_lane, u8, 4)
DEFINE_SIMD_LOAD_LANE(v128_load8_lane12, simde_wasm_v128_load8_lane, u8, 3)
DEFINE_SIMD_LOAD_LANE(v128_load8_lane13, simde_wasm_v128_load8_lane, u8, 2)
DEFINE_SIMD_LOAD_LANE(v128_load8_lane14, simde_wasm_v128_load8_lane, u8, 1)
DEFINE_SIMD_LOAD_LANE(v128_load8_lane15, simde_wasm_v128_load8_lane, u8, 0)
DEFINE_SIMD_LOAD_LANE(v128_load16_lane0, simde_wasm_v128_load16_lane, u16, 7)
DEFINE_SIMD_LOAD_LANE(v128_load16_lane1, simde_wasm_v128_load16_lane, u16, 6)
DEFINE_SIMD_LOAD_LANE(v128_load16_lane2, simde_wasm_v128_load16_lane, u16, 5)
DEFINE_SIMD_LOAD_LANE(v128_load16_lane3, simde_wasm_v128_load16_lane, u16, 4)
DEFINE_SIMD_LOAD_LANE(v128_load16_lane4, simde_wasm_v128_load16_lane, u16, 3)
DEFINE_SIMD_LOAD_LANE(v128_load16_lane5, simde_wasm_v128_load16_lane, u16, 2)
DEFINE_SIMD_LOAD_LANE(v128_load16_lane6, simde_wasm_v128_load16_lane, u16, 1)
DEFINE_SIMD_LOAD_LANE(v128_load16_lane7, simde_wasm_v128_load16_lane, u16, 0)
DEFINE_SIMD_LOAD_LANE(v128_load32_lane0, simde_wasm_v128_load32_lane, u32, 3)
DEFINE_SIMD_LOAD_LANE(v128_load32_lane1, simde_wasm_v128_load32_lane, u32, 2)
DEFINE_SIMD_LOAD_LANE(v128_load32_lane2, simde_wasm_v128_load32_lane, u32, 1)
DEFINE_SIMD_LOAD_LANE(v128_load32_lane3, simde_wasm_v128_load32_lane, u32, 0)
DEFINE_SIMD_LOAD_LANE(v128_load64_lane0, simde_wasm_v128_load64_lane, u64, 1)
DEFINE_SIMD_LOAD_LANE(v128_load64_lane1, simde_wasm_v128_load64_lane, u64, 0)
#else
DEFINE_SIMD_LOAD_LANE(v128_load8_lane0, simde_wasm_v128_load8_lane, u8, 0)
DEFINE_SIMD_LOAD_LANE(v128_load8_lane1, simde_wasm_v128_load8_lane, u8, 1)
DEFINE_SIMD_LOAD_LANE(v128_load8_lane2, simde_wasm_v128_load8_lane, u8, 2)
DEFINE_SIMD_LOAD_LANE(v128_load8_lane3, simde_wasm_v128_load8_lane, u8, 3)
DEFINE_SIMD_LOAD_LANE(v128_load8_lane4, simde_wasm_v128_load8_lane, u8, 4)
DEFINE_SIMD_LOAD_LANE(v128_load8_lane5, simde_wasm_v128_load8_lane, u8, 5)
DEFINE_SIMD_LOAD_LANE(v128_load8_lane6, simde_wasm_v128_load8_lane, u8, 6)
DEFINE_SIMD_LOAD_LANE(v128_load8_lane7, simde_wasm_v128_load8_lane, u8, 7)
DEFINE_SIMD_LOAD_LANE(v128_load8_lane8, simde_wasm_v128_load8_lane, u8, 8)
DEFINE_SIMD_LOAD_LANE(v128_load8_lane9, simde_wasm_v128_load8_lane, u8, 9)
DEFINE_SIMD_LOAD_LANE(v128_load8_lane10, simde_wasm_v128_load8_lane, u8, 10)
DEFINE_SIMD_LOAD_LANE(v128_load8_lane11, simde_wasm_v128_load8_lane, u8, 11)
DEFINE_SIMD_LOAD_LANE(v128_load8_lane12, simde_wasm_v128_load8_lane, u8, 12)
DEFINE_SIMD_LOAD_LANE(v128_load8_lane13, simde_wasm_v128_load8_lane, u8, 13)
DEFINE_SIMD_LOAD_LANE(v128_load8_lane14, simde_wasm_v128_load8_lane, u8, 14)
DEFINE_SIMD_LOAD_LANE(v128_load8_lane15, simde_wasm_v128_load8_lane, u8, 15)
DEFINE_SIMD_LOAD_LANE(v128_load16_lane0, simde_wasm_v128_load16_lane, u16, 0)
DEFINE_SIMD_LOAD_LANE(v128_load16_lane1, simde_wasm_v128_load16_lane, u16, 1)
DEFINE_SIMD_LOAD_LANE(v128_load16_lane2, simde_wasm_v128_load16_lane, u16, 2)
DEFINE_SIMD_LOAD_LANE(v128_load16_lane3, simde_wasm_v128_load16_lane, u16, 3)
DEFINE_SIMD_LOAD_LANE(v128_load16_lane4, simde_wasm_v128_load16_lane, u16, 4)
DEFINE_SIMD_LOAD_LANE(v128_load16_lane5, simde_wasm_v128_load16_lane, u16, 5)
DEFINE_SIMD_LOAD_LANE(v128_load16_lane6, simde_wasm_v128_load16_lane, u16, 6)
DEFINE_SIMD_LOAD_LANE(v128_load16_lane7, simde_wasm_v128_load16_lane, u16, 7)
DEFINE_SIMD_LOAD_LANE(v128_load32_lane0, simde_wasm_v128_load32_lane, u32, 0)
DEFINE_SIMD_LOAD_LANE(v128_load32_lane1, simde_wasm_v128_load32_lane, u32, 1)
DEFINE_SIMD_LOAD_LANE(v128_load32_lane2, simde_wasm_v128_load32_lane, u32, 2)
DEFINE_SIMD_LOAD_LANE(v128_load32_lane3, simde_wasm_v128_load32_lane, u32, 3)
DEFINE_SIMD_LOAD_LANE(v128_load64_lane0, simde_wasm_v128_load64_lane, u64, 0)
DEFINE_SIMD_LOAD_LANE(v128_load64_lane1, simde_wasm_v128_load64_lane, u64, 1)
#endif

DEFINE_SIMD_STORE(v128_store, v128)

#if WABT_BIG_ENDIAN
DEFINE_SIMD_STORE_LANE(v128_store8_lane0, simde_wasm_v128_store8_lane, u8, 15)
DEFINE_SIMD_STORE_LANE(v128_store8_lane1, simde_wasm_v128_store8_lane, u8, 14)
DEFINE_SIMD_STORE_LANE(v128_store8_lane2, simde_wasm_v128_store8_lane, u8, 13)
DEFINE_SIMD_STORE_LANE(v128_store8_lane3, simde_wasm_v128_store8_lane, u8, 12)
DEFINE_SIMD_STORE_LANE(v128_store8_lane4, simde_wasm_v128_store8_lane, u8, 11)
DEFINE_SIMD_STORE_LANE(v128_store8_lane5, simde_wasm_v128_store8_lane, u8, 10)
DEFINE_SIMD_STORE_LANE(v128_store8_lane6, simde_wasm_v128_store8_lane, u8, 9)
DEFINE_SIMD_STORE_LANE(v128_store8_lane7, simde_wasm_v128_store8_lane, u8, 8)
DEFINE_SIMD_STORE_LANE(v128_store8_lane8, simde_wasm_v128_store8_lane, u8, 7)
DEFINE_SIMD_STORE_LANE(v128_store8_lane9, simde_wasm_v128_store8_lane, u8, 6)
DEFINE_SIMD_STORE_LANE(v128_store8_lane10, simde_wasm_v128_store8_lane, u8, 5)
DEFINE_SIMD_STORE_LANE(v128_store8_lane11, simde_wasm_v128_store8_lane, u8, 4)
DEFINE_SIMD_STORE_LANE(v128_store8_lane12, simde_wasm_v128_store8_lane, u8, 3)
DEFINE_SIMD_STORE_LANE(v128_store8_lane13, simde_wasm_v128_store8_lane, u8, 2)
DEFINE_SIMD_STORE_LANE(v128_store8_lane14, simde_wasm_v128_store8_lane, u8, 1)
DEFINE_SIMD_STORE_LANE(v128_store8_lane15, simde_wasm_v128_store8_lane, u8, 0)
DEFINE_SIMD_STORE_LANE(v128_store16_lane0, simde_wasm_v128_store16_lane, u16, 7)
DEFINE_SIMD_STORE_LANE(v128_store16_lane1, simde_wasm_v128_store16_lane, u16, 6)
DEFINE_SIMD_STORE_LANE(v128_store16_lane2, simde_wasm_v128_store16_lane, u16, 5)
DEFINE_SIMD_STORE_LANE(v128_store16_lane3, simde_wasm_v128_store16_lane, u16, 4)
DEFINE_SIMD_STORE_LANE(v128_store16_lane4, simde_wasm_v128_store16_lane, u16, 3)
DEFINE_SIMD_STORE_LANE(v128_store16_lane5, simde_wasm_v128_store16_lane, u16, 2)
DEFINE_SIMD_STORE_LANE(v128_store16_lane6, simde_wasm_v128_store16_lane, u16, 1)
DEFINE_SIMD_STORE_LANE(v128_store16_lane7, simde_wasm_v128_store16_lane, u16, 0)
DEFINE_SIMD_STORE_LANE(v128_store32_lane0, simde_wasm_v128_store32_lane, u32, 3)
DEFINE_SIMD_STORE_LANE(v128_store32_lane1, simde_wasm_v128_store32_lane, u32, 2)
DEFINE_SIMD_STORE_LANE(v128_store32_lane2, simde_wasm_v128_store32_lane, u32, 1)
DEFINE_SIMD_STORE_LANE(v128_store32_lane3, simde_wasm_v128_store32_lane, u32, 0)
DEFINE_SIMD_STORE_LANE(v128_store64_lane0, simde_wasm_v128_store64_lane, u64, 1)
DEFINE_SIMD_STORE_LANE(v128_store64_lane1, simde_wasm_v128_store64_lane, u64, 0)
#else
DEFINE_SIMD_STORE_LANE(v128_store8_lane0, simde_wasm_v128_store8_lane, u8, 0)
DEFINE_SIMD_STORE_LANE(v128_store8_lane1, simde_wasm_v128_store8_lane, u8, 1)
DEFINE_SIMD_STORE_LANE(v128_store8_lane2, simde_wasm_v128_store8_lane, u8, 2)
DEFINE_SIMD_STORE_LANE(v128_store8_lane3, simde_wasm_v128_store8_lane, u8, 3)
DEFINE_SIMD_STORE_LANE(v128_store8_lane4, simde_wasm_v128_store8_lane, u8, 4)
DEFINE_SIMD_STORE_LANE(v128_store8_lane5, simde_wasm_v128_store8_lane, u8, 5)
DEFINE_SIMD_STORE_LANE(v128_store8_lane6, simde_wasm_v128_store8_lane, u8, 6)
DEFINE_SIMD_STORE_LANE(v128_store8_lane7, simde_wasm_v128_store8_lane, u8, 7)
DEFINE_SIMD_STORE_LANE(v128_store8_lane8, simde_wasm_v128_store8_lane, u8, 8)
DEFINE_SIMD_STORE_LANE(v128_store8_lane9, simde_wasm_v128_store8_lane, u8, 9)
DEFINE_SIMD_STORE_LANE(v128_store8_lane10, simde_wasm_v128_store8_lane, u8, 10)
DEFINE_SIMD_STORE_LANE(v128_store8_lane11, simde_wasm_v128_store8_lane, u8, 11)
DEFINE_SIMD_STORE_LANE(v128_store8_lane12, simde_wasm_v128_store8_lane, u8, 12)
DEFINE_SIMD_STORE_LANE(v128_store8_lane13, simde_wasm_v128_store8_lane, u8, 13)
DEFINE_SIMD_STORE_LANE(v128_store8_lane14, simde_wasm_v128_store8_lane, u8, 14)
DEFINE_SIMD_STORE_LANE(v128_store8_lane15, simde_wasm_v128_store8_lane, u8, 15)
DEFINE_SIMD_STORE_LANE(v128_store16_lane0, simde_wasm_v128_store16_lane, u16, 0)
DEFINE_SIMD_STORE_LANE(v128_store16_lane1, simde_wasm_v128_store16_lane, u16, 1)
DEFINE_SIMD_STORE_LANE(v128_store16_lane2, simde_wasm_v128_store16_lane, u16, 2)
DEFINE_SIMD_STORE_LANE(v128_store16_lane3, simde_wasm_v128_store16_lane, u16, 3)
DEFINE_SIMD_STORE_LANE(v128_store16_lane4, simde_wasm_v128_store16_lane, u16, 4)
DEFINE_SIMD_STORE_LANE(v128_store16_lane5, simde_wasm_v128_store16_lane, u16, 5)
DEFINE_SIMD_STORE_LANE(v128_store16_lane6, simde_wasm_v128_store16_lane, u16, 6)
DEFINE_SIMD_STORE_LANE(v128_store16_lane7, simde_wasm_v128_store16_lane, u16, 7)
DEFINE_SIMD_STORE_LANE(v128_store32_lane0, simde_wasm_v128_store32_lane, u32, 0)
DEFINE_SIMD_STORE_LANE(v128_store32_lane1, simde_wasm_v128_store32_lane, u32, 1)
DEFINE_SIMD_STORE_LANE(v128_store32_lane2, simde_wasm_v128_store32_lane, u32, 2)
DEFINE_SIMD_STORE_LANE(v128_store32_lane3, simde_wasm_v128_store32_lane, u32, 3)
DEFINE_SIMD_STORE_LANE(v128_store64_lane0, simde_wasm_v128_store64_lane, u64, 0)
DEFINE_SIMD_STORE_LANE(v128_store64_lane1, simde_wasm_v128_store64_lane, u64, 1)
#endif

#if WABT_BIG_ENDIAN
#define v128_const(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p) simde_wasm_i8x16_const(p,o,n,m,l,k,j,i,h,g,f,e,d,c,b,a)
#define v128_i8x16_extract_lane(v, l) simde_wasm_i8x16_extract_lane(v, 15-(l))
#define v128_u8x16_extract_lane(v, l) simde_wasm_u8x16_extract_lane(v, 15-(l))
#define v128_i16x8_extract_lane(v, l) simde_wasm_i16x8_extract_lane(v, 7-(l))
#define v128_u16x8_extract_lane(v, l) simde_wasm_u16x8_extract_lane(v, 7-(l))
#define v128_i32x4_extract_lane(v, l) simde_wasm_i32x4_extract_lane(v, 3-(l))
#define v128_i64x2_extract_lane(v, l) simde_wasm_i64x2_extract_lane(v, 1-(l))
#define v128_f32x4_extract_lane(v, l) simde_wasm_f32x4_extract_lane(v, 3-(l))
#define v128_f64x2_extract_lane(v, l) simde_wasm_f64x2_extract_lane(v, 1-(l))
#define v128_i8x16_replace_lane(v, l, x) simde_wasm_i8x16_replace_lane(v, 15-(l), x)
#define v128_u8x16_replace_lane(v, l, x) simde_wasm_u8x16_replace_lane(v, 15-(l), x)
#define v128_i16x8_replace_lane(v, l, x) simde_wasm_i16x8_replace_lane(v, 7-(l), x)
#define v128_u16x8_replace_lane(v, l, x) simde_wasm_u16x8_replace_lane(v, 7-(l), x)
#define v128_i32x4_replace_lane(v, l, x) simde_wasm_i32x4_replace_lane(v, 3-(l), x)
#define v128_i64x2_replace_lane(v, l, x) simde_wasm_i64x2_replace_lane(v, 1-(l), x)
#define v128_f32x4_replace_lane(v, l, x) simde_wasm_f32x4_replace_lane(v, 3-(l), x)
#define v128_f64x2_replace_lane(v, l, x) simde_wasm_f64x2_replace_lane(v, 1-(l), x)
#define v128_i8x16_bitmask(v) simde_wasm_i8x16_bitmask(simde_wasm_i8x16_swizzle(v, simde_wasm_i8x16_const(15,14,13,12,11,10,9,8,7,6,5,4,3,2,1,0)))
#define v128_i16x8_bitmask(v) simde_wasm_i16x8_bitmask(simde_wasm_i8x16_swizzle(v, simde_wasm_i8x16_const(14,15,12,13,10,11,8,9,6,7,4,5,2,3,0,1)))
#define v128_i32x4_bitmask(v) simde_wasm_i32x4_bitmask(simde_wasm_i8x16_swizzle(v, simde_wasm_i8x16_const(12,13,14,15,8,9,10,11,4,5,6,7,0,1,2,3)))
#define v128_i64x2_bitmask(v) simde_wasm_i64x2_bitmask(simde_wasm_i8x16_swizzle(v, simde_wasm_i8x16_const(8,9,10,11,12,13,14,15,0,1,2,3,4,5,6,7)))
#define v128_i8x16_swizzle(v1, v2) simde_wasm_i8x16_swizzle(v1, simde_wasm_v128_xor(v2, simde_wasm_i8x16_splat(15)))
#define v128_i8x16_shuffle(v1,v2,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p) simde_wasm_i8x16_shuffle(v2,v1,31-(p),31-(o),31-(n),31-(m),31-(l),31-(k),31-(j),31-(i),31-(h),31-(g),31-(f),31-(e),31-(d),31-(c),31-(b),31-(a))
#define v128_i16x8_extmul_high_i8x16 simde_wasm_i16x8_extmul_low_i8x16
#define v128_u16x8_extmul_high_u8x16 simde_wasm_u16x8_extmul_low_u8x16
#define v128_i16x8_extmul_low_i8x16  simde_wasm_i16x8_extmul_high_i8x16
#define v128_u16x8_extmul_low_u8x16  simde_wasm_u16x8_extmul_high_u8x16
#define v128_i32x4_extmul_high_i16x8 simde_wasm_i32x4_extmul_low_i16x8
#define v128_u32x4_extmul_high_u16x8 simde_wasm_u32x4_extmul_low_u16x8
#define v128_i32x4_extmul_low_i16x8  simde_wasm_i32x4_extmul_high_i16x8
#define v128_u32x4_extmul_low_u16x8  simde_wasm_u32x4_extmul_high_u16x8
#define v128_i64x2_extmul_high_i32x4 simde_wasm_i64x2_extmul_low_i32x4
#define v128_u64x2_extmul_high_u32x4 simde_wasm_u64x2_extmul_low_u32x4
#define v128_i64x2_extmul_low_i32x4  simde_wasm_i64x2_extmul_high_i32x4
#define v128_u64x2_extmul_low_u32x4  simde_wasm_u64x2_extmul_high_u32x4
#define v128_i16x8_extend_high_i8x16 simde_wasm_i16x8_extend_low_i8x16
#define v128_u16x8_extend_high_u8x16 simde_wasm_u16x8_extend_low_u8x16
#define v128_i16x8_extend_low_i8x16  simde_wasm_i16x8_extend_high_i8x16
#define v128_u16x8_extend_low_u8x16  simde_wasm_u16x8_extend_high_u8x16
#define v128_i32x4_extend_high_i16x8 simde_wasm_i32x4_extend_low_i16x8
#define v128_u32x4_extend_high_u16x8 simde_wasm_u32x4_extend_low_u16x8
#define v128_i32x4_extend_low_i16x8  simde_wasm_i32x4_extend_high_i16x8
#define v128_u32x4_extend_low_u16x8  simde_wasm_u32x4_extend_high_u16x8
#define v128_i64x2_extend_high_i32x4 simde_wasm_i64x2_extend_low_i32x4
#define v128_u64x2_extend_high_u32x4 simde_wasm_u64x2_extend_low_u32x4
#define v128_i64x2_extend_low_i32x4  simde_wasm_i64x2_extend_high_i32x4
#define v128_u64x2_extend_low_u32x4  simde_wasm_u64x2_extend_high_u32x4
#define v128_i32x4_trunc_sat_f64x2_zero(a)      \
  simde_wasm_i8x16_swizzle(                     \
      simde_wasm_i32x4_trunc_sat_f64x2_zero(a), \
      simde_wasm_i8x16_const(8,9,10,11,12,13,14,15,0,1,2,3,4,5,6,7))
#define v128_u32x4_trunc_sat_f64x2_zero(a)      \
  simde_wasm_i8x16_swizzle(                     \
      simde_wasm_u32x4_trunc_sat_f64x2_zero(a), \
      simde_wasm_i8x16_const(8,9,10,11,12,13,14,15,0,1,2,3,4,5,6,7))
#define v128_i16x8_narrow_i32x4(a,b) simde_wasm_i16x8_narrow_i32x4(b,a)
#define v128_u16x8_narrow_i32x4(a,b) simde_wasm_u16x8_narrow_i32x4(b,a)
#define v128_i8x16_narrow_i16x8(a,b) simde_wasm_i8x16_narrow_i16x8(b,a)
#define v128_u8x16_narrow_i16x8(a,b) simde_wasm_u8x16_narrow_i16x8(b,a)
#define v128_f64x2_promote_low_f32x4(a)                        \
  simde_wasm_f64x2_promote_low_f32x4(simde_wasm_i8x16_swizzle( \
      a,                                                       \
      simde_wasm_i8x16_const(8,9,10,11,12,13,14,15,0,1,2,3,4,5,6,7)))
#define v128_f32x4_demote_f64x2_zero(a)      \
  simde_wasm_i8x16_swizzle(                  \
      simde_wasm_f32x4_demote_f64x2_zero(a), \
      simde_wasm_i8x16_const(8,9,10,11,12,13,14,15,0,1,2,3,4,5,6,7))
#define v128_f64x2_convert_low_i32x4(a)                        \
  simde_wasm_f64x2_convert_low_i32x4(simde_wasm_i8x16_swizzle( \
      a,                                                       \
      simde_wasm_i8x16_const(8,9,10,11,12,13,14,15,0,1,2,3,4,5,6,7)))
#define v128_f64x2_convert_low_u32x4(a)                        \
  simde_wasm_f64x2_convert_low_u32x4(simde_wasm_i8x16_swizzle( \
      a,                                                       \
      simde_wasm_i8x16_const(8,9,10,11,12,13,14,15,0,1,2,3,4,5,6,7)))
#else
#define v128_const simde_wasm_i8x16_const
#define v128_i8x16_extract_lane simde_wasm_i8x16_extract_lane
#define v128_u8x16_extract_lane simde_wasm_u8x16_extract_lane
#define v128_i16x8_extract_lane simde_wasm_i16x8_extract_lane
#define v128_u16x8_extract_lane simde_wasm_u16x8_extract_lane
#define v128_i32x4_extract_lane simde_wasm_i32x4_extract_lane
#define v128_i64x2_extract_lane simde_wasm_i64x2_extract_lane
#define v128_f32x4_extract_lane simde_wasm_f32x4_extract_lane
#define v128_f64x2_extract_lane simde_wasm_f64x2_extract_lane
#define v128_i8x16_replace_lane simde_wasm_i8x16_replace_lane
#define v128_u8x16_replace_lane simde_wasm_u8x16_replace_lane
#define v128_i16x8_replace_lane simde_wasm_i16x8_replace_lane
#define v128_u16x8_replace_lane simde_wasm_u16x8_replace_lane
#define v128_i32x4_replace_lane simde_wasm_i32x4_replace_lane
#define v128_i64x2_replace_lane simde_wasm_i64x2_replace_lane
#define v128_f32x4_replace_lane simde_wasm_f32x4_replace_lane
#define v128_f64x2_replace_lane simde_wasm_f64x2_replace_lane
#define v128_i8x16_bitmask simde_wasm_i8x16_bitmask
#define v128_i16x8_bitmask simde_wasm_i16x8_bitmask
#define v128_i32x4_bitmask simde_wasm_i32x4_bitmask
#define v128_i64x2_bitmask simde_wasm_i64x2_bitmask
#define v128_i8x16_swizzle simde_wasm_i8x16_swizzle
#define v128_i8x16_shuffle simde_wasm_i8x16_shuffle
#define v128_i16x8_extmul_high_i8x16 simde_wasm_i16x8_extmul_high_i8x16
#define v128_u16x8_extmul_high_u8x16 simde_wasm_u16x8_extmul_high_u8x16
#define v128_i16x8_extmul_low_i8x16  simde_wasm_i16x8_extmul_low_i8x16
#define v128_u16x8_extmul_low_u8x16  simde_wasm_u16x8_extmul_low_u8x16
#define v128_i32x4_extmul_high_i16x8 simde_wasm_i32x4_extmul_high_i16x8
#define v128_u32x4_extmul_high_u16x8 simde_wasm_u32x4_extmul_high_u16x8
#define v128_i32x4_extmul_low_i16x8  simde_wasm_i32x4_extmul_low_i16x8
#define v128_u32x4_extmul_low_u16x8  simde_wasm_u32x4_extmul_low_u16x8
#define v128_i64x2_extmul_high_i32x4 simde_wasm_i64x2_extmul_high_i32x4
#define v128_u64x2_extmul_high_u32x4 simde_wasm_u64x2_extmul_high_u32x4
#define v128_i64x2_extmul_low_i32x4  simde_wasm_i64x2_extmul_low_i32x4
#define v128_u64x2_extmul_low_u32x4  simde_wasm_u64x2_extmul_low_u32x4
#define v128_i16x8_extend_high_i8x16 simde_wasm_i16x8_extend_high_i8x16
#define v128_u16x8_extend_high_u8x16 simde_wasm_u16x8_extend_high_u8x16
#define v128_i16x8_extend_low_i8x16  simde_wasm_i16x8_extend_low_i8x16
#define v128_u16x8_extend_low_u8x16  simde_wasm_u16x8_extend_low_u8x16
#define v128_i32x4_extend_high_i16x8 simde_wasm_i32x4_extend_high_i16x8
#define v128_u32x4_extend_high_u16x8 simde_wasm_u32x4_extend_high_u16x8
#define v128_i32x4_extend_low_i16x8  simde_wasm_i32x4_extend_low_i16x8
#define v128_u32x4_extend_low_u16x8  simde_wasm_u32x4_extend_low_u16x8
#define v128_i64x2_extend_high_i32x4 simde_wasm_i64x2_extend_high_i32x4
#define v128_u64x2_extend_high_u32x4 simde_wasm_u64x2_extend_high_u32x4
#define v128_i64x2_extend_low_i32x4  simde_wasm_i64x2_extend_low_i32x4
#define v128_u64x2_extend_low_u32x4  simde_wasm_u64x2_extend_low_u32x4
#define v128_i32x4_trunc_sat_f64x2_zero simde_wasm_i32x4_trunc_sat_f64x2_zero
#define v128_u32x4_trunc_sat_f64x2_zero simde_wasm_u32x4_trunc_sat_f64x2_zero
#define v128_i16x8_narrow_i32x4 simde_wasm_i16x8_narrow_i32x4
#define v128_u16x8_narrow_i32x4 simde_wasm_u16x8_narrow_i32x4
#define v128_i8x16_narrow_i16x8 simde_wasm_i8x16_narrow_i16x8
#define v128_u8x16_narrow_i16x8 simde_wasm_u8x16_narrow_i16x8
#define v128_f64x2_promote_low_f32x4 simde_wasm_f64x2_promote_low_f32x4
#define v128_f32x4_demote_f64x2_zero simde_wasm_f32x4_demote_f64x2_zero
#define v128_f64x2_convert_low_i32x4 simde_wasm_f64x2_convert_low_i32x4
#define v128_f64x2_convert_low_u32x4 simde_wasm_f64x2_convert_low_u32x4
#endif
// clang-format on


static void w2c_rlbox_0x5F_wasm_call_ctors_0(w2c_rlbox*);
static u32 w2c_rlbox_undefined_weak0x3A_0x5Fwasilibc_find_relpath_alloc(w2c_rlbox*, u32, u32, u32, u32, u32);
static void w2c_rlbox_0x5F_wasm_init_memory_0(w2c_rlbox*);
static void w2c_rlbox_0x5Fstart_0(w2c_rlbox*);
static void w2c_rlbox_ogg_set_mem_functions_0(w2c_rlbox*, u32, u32, u32, u32);
static void w2c_rlbox_oggpack_writeinit_0(w2c_rlbox*, u32);
static void w2c_rlbox_oggpackB_writeinit_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_oggpack_writecheck_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_oggpackB_writecheck_0(w2c_rlbox*, u32);
static void w2c_rlbox_oggpack_writetrunc_0(w2c_rlbox*, u32, u32);
static void w2c_rlbox_oggpackB_writetrunc_0(w2c_rlbox*, u32, u32);
static void w2c_rlbox_oggpack_write_0(w2c_rlbox*, u32, u32, u32);
static void w2c_rlbox_oggpack_writeclear_0(w2c_rlbox*, u32);
static void w2c_rlbox_oggpackB_write_0(w2c_rlbox*, u32, u32, u32);
static void w2c_rlbox_oggpack_writealign_0(w2c_rlbox*, u32);
static void w2c_rlbox_oggpackB_writealign_0(w2c_rlbox*, u32);
static void w2c_rlbox_oggpack_writecopy_0(w2c_rlbox*, u32, u32, u32);
static void w2c_rlbox_oggpack_writecopy_helper(w2c_rlbox*, u32, u32, u32, u32, u32);
static void w2c_rlbox_oggpackB_writecopy_0(w2c_rlbox*, u32, u32, u32);
static void w2c_rlbox_oggpack_reset_0(w2c_rlbox*, u32);
static void w2c_rlbox_oggpackB_reset_0(w2c_rlbox*, u32);
static void w2c_rlbox_oggpackB_writeclear_0(w2c_rlbox*, u32);
static void w2c_rlbox_oggpack_readinit_0(w2c_rlbox*, u32, u32, u32);
static void w2c_rlbox_oggpackB_readinit_0(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_oggpack_look_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_oggpackB_look_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_oggpack_look1_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_oggpackB_look1_0(w2c_rlbox*, u32);
static void w2c_rlbox_oggpack_adv_0(w2c_rlbox*, u32, u32);
static void w2c_rlbox_oggpackB_adv_0(w2c_rlbox*, u32, u32);
static void w2c_rlbox_oggpack_adv1_0(w2c_rlbox*, u32);
static void w2c_rlbox_oggpackB_adv1_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_oggpack_read_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_oggpackB_read_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_oggpack_read1_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_oggpackB_read1_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_oggpack_bytes_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_oggpack_bits_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_oggpackB_bytes_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_oggpackB_bits_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_oggpack_get_buffer_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_oggpackB_get_buffer_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_ogg_page_version_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_ogg_page_continued_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_ogg_page_bos_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_ogg_page_eos_0(w2c_rlbox*, u32);
static u64 w2c_rlbox_ogg_page_granulepos_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_ogg_page_serialno_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_ogg_page_pageno_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_ogg_page_packets_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_ogg_stream_init_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_ogg_stream_clear_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_ogg_stream_check_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_ogg_stream_destroy_0(w2c_rlbox*, u32);
static void w2c_rlbox_ogg_page_checksum_set_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_0x5Fos_update_crc(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_ogg_stream_iovecin_0(w2c_rlbox*, u32, u32, u32, u32, u64);
static u32 w2c_rlbox_0x5Fos_body_expand(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_0x5Fos_lacing_expand(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_ogg_stream_packetin_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_ogg_stream_flush_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_ogg_stream_flush_i(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_ogg_stream_flush_fill_0(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_ogg_stream_pageout_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_ogg_stream_pageout_fill_0(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_ogg_stream_eos_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_ogg_sync_init_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_ogg_sync_clear_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_ogg_sync_destroy_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_ogg_sync_check_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_ogg_sync_buffer_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_ogg_sync_wrote_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_ogg_sync_pageseek_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_ogg_sync_pageout_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_ogg_stream_pagein_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_ogg_sync_reset_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_ogg_stream_reset_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_ogg_stream_reset_serialno_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_ogg_stream_packetout_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_0x5Fpacketout(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_ogg_stream_packetpeek_0(w2c_rlbox*, u32, u32);
static void w2c_rlbox_ogg_packet_clear_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_XML_ParserCreate_MM_0(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_parserCreate(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_prologInitProcessor(w2c_rlbox*, u32, u32, u32, u32);
static void w2c_rlbox_XML_ParserFree_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_XML_ExternalEntityParserCreate_0(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_poolCopyString(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_lookup(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_poolGrow(w2c_rlbox*, u32);
static u32 w2c_rlbox_copyEntityTable(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_setContext(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_externalEntityInitProcessor(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_externalParEntInitProcessor(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_addBinding(w2c_rlbox*, u32, u32, u32, u32, u32);
static void w2c_rlbox_poolDestroy(w2c_rlbox*, u32);
static void w2c_rlbox_hashTableDestroy(w2c_rlbox*, u32);
static u32 w2c_rlbox_initializeEncoding(w2c_rlbox*, u32);
static u32 w2c_rlbox_externalEntityInitProcessor2(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_entityValueInitProcessor(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_externalParEntProcessor(w2c_rlbox*, u32, u32, u32, u32);
static void w2c_rlbox_XML_UseParserAsHandlerArg_0(w2c_rlbox*, u32);
static void w2c_rlbox_XML_SetReturnNSTriplet_0(w2c_rlbox*, u32, u32);
static void w2c_rlbox_XML_SetUserData_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_XML_SetBase_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_XML_GetBase_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_XML_GetSpecifiedAttributeCount_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_XML_GetIdAttributeIndex_0(w2c_rlbox*, u32);
static void w2c_rlbox_XML_SetElementHandler_0(w2c_rlbox*, u32, u32, u32);
static void w2c_rlbox_XML_SetCharacterDataHandler_0(w2c_rlbox*, u32, u32);
static void w2c_rlbox_XML_SetProcessingInstructionHandler_0(w2c_rlbox*, u32, u32);
static void w2c_rlbox_XML_SetCommentHandler_0(w2c_rlbox*, u32, u32);
static void w2c_rlbox_XML_SetCdataSectionHandler_0(w2c_rlbox*, u32, u32, u32);
static void w2c_rlbox_XML_SetDefaultHandlerExpand_0(w2c_rlbox*, u32, u32);
static void w2c_rlbox_XML_SetDoctypeDeclHandler_0(w2c_rlbox*, u32, u32, u32);
static void w2c_rlbox_XML_SetUnparsedEntityDeclHandler_0(w2c_rlbox*, u32, u32);
static void w2c_rlbox_XML_SetNotationDeclHandler_0(w2c_rlbox*, u32, u32);
static void w2c_rlbox_XML_SetNamespaceDeclHandler_0(w2c_rlbox*, u32, u32, u32);
static void w2c_rlbox_XML_SetExternalEntityRefHandler_0(w2c_rlbox*, u32, u32);
static void w2c_rlbox_XML_SetExternalEntityRefHandlerArg_0(w2c_rlbox*, u32, u32);
static void w2c_rlbox_XML_SetXmlDeclHandler_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_XML_SetParamEntityParsing_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_XML_SetHashSalt_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_XML_Parse_0(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_startParsing(w2c_rlbox*, u32);
static u32 w2c_rlbox_errorProcessor(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_callProcessor(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_XML_GetBuffer_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_XML_ParseBuffer_0(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_XML_StopParser_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_XML_ResumeParser_0(w2c_rlbox*, u32);
static void w2c_rlbox_XML_GetParsingStatus_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_XML_GetErrorCode_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_XML_GetCurrentByteIndex_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_XML_GetCurrentLineNumber_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_XML_GetCurrentColumnNumber_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_XML_SetBillionLaughsAttackProtectionMaximumAmplification_0(w2c_rlbox*, u32, f32);
static u32 w2c_rlbox_XML_SetBillionLaughsAttackProtectionActivationThreshold_0(w2c_rlbox*, u32, u64);
static u32 w2c_rlbox_MOZ_XML_GetMismatchedTag_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_MOZ_XML_ProcessingEntityValue_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_XML_SetReparseDeferralEnabled_0(w2c_rlbox*, u32, u32);
static void w2c_rlbox_MOZ_XML_SetXmlDeclHandler_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_MOZ_XML_ParserCreate_MM_0(w2c_rlbox*, u32, u32, u32);
static void w2c_rlbox_MOZ_XML_SetElementHandler_0(w2c_rlbox*, u32, u32, u32);
static void w2c_rlbox_MOZ_XML_SetCharacterDataHandler_0(w2c_rlbox*, u32, u32);
static void w2c_rlbox_MOZ_XML_SetProcessingInstructionHandler_0(w2c_rlbox*, u32, u32);
static void w2c_rlbox_MOZ_XML_SetCommentHandler_0(w2c_rlbox*, u32, u32);
static void w2c_rlbox_MOZ_XML_SetCdataSectionHandler_0(w2c_rlbox*, u32, u32, u32);
static void w2c_rlbox_MOZ_XML_SetDefaultHandlerExpand_0(w2c_rlbox*, u32, u32);
static void w2c_rlbox_MOZ_XML_SetDoctypeDeclHandler_0(w2c_rlbox*, u32, u32, u32);
static void w2c_rlbox_MOZ_XML_SetExternalEntityRefHandler_0(w2c_rlbox*, u32, u32);
static void w2c_rlbox_MOZ_XML_SetReturnNSTriplet_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_MOZ_XML_SetBase_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_MOZ_XML_GetBase_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_MOZ_XML_GetSpecifiedAttributeCount_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_MOZ_XML_Parse_0(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_MOZ_XML_StopParser_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_MOZ_XML_ResumeParser_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_MOZ_XML_ExternalEntityParserCreate_0(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_MOZ_XML_SetParamEntityParsing_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_MOZ_XML_SetHashSalt_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_MOZ_XML_GetErrorCode_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_MOZ_XML_GetCurrentLineNumber_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_MOZ_XML_GetCurrentColumnNumber_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_MOZ_XML_GetCurrentByteIndex_0(w2c_rlbox*, u32);
static void w2c_rlbox_MOZ_XML_ParserFree_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_MOZ_XML_SetReparseDeferralEnabled_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_prologProcessor(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_handleUnknownEncoding(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_doProlog(w2c_rlbox*, u32, u32, u32, u32, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_accountingDiffTolerated(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_processXmlDecl(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_poolStoreString(w2c_rlbox*, u32, u32, u32, u32);
static void w2c_rlbox_normalizePublicId(w2c_rlbox*, u32);
static u32 w2c_rlbox_contentProcessor(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_doContent(w2c_rlbox*, u32, u32, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_getElementType(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_getAttributeId(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_poolAppendString(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_poolAppend(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_defineAttribute(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_storeAttributeValue(w2c_rlbox*, u32, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_storeEntityValue(w2c_rlbox*, u32, u32, u32, u32, u32);
static void w2c_rlbox_reportDefault(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_doIgnoreSection(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_ignoreSectionProcessor(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_nextScaffoldPart(w2c_rlbox*, u32);
static u32 w2c_rlbox_reportProcessingInstruction(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_reportComment(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_processInternalEntity(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_hash(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_setElementTypePrefix(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_appendAttributeValue(w2c_rlbox*, u32, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_internalEntityProcessor(w2c_rlbox*, u32, u32, u32, u32);
static void w2c_rlbox_normalizeLines(w2c_rlbox*, u32);
static u32 w2c_rlbox_sip24_update(w2c_rlbox*, u32, u32, u32);
static u64 w2c_rlbox_sip24_final(w2c_rlbox*, u32);
static void w2c_rlbox_sip_round(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_storeAtts(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static void w2c_rlbox_freeBindings(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_epilogProcessor(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_doCdataSection(w2c_rlbox*, u32, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_cdataSectionProcessor(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_externalEntityContentProcessor(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_externalEntityInitProcessor3(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_entityValueProcessor(w2c_rlbox*, u32, u32, u32, u32);
static void w2c_rlbox_0x5FINTERNAL_trim_to_complete_utf8_characters_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_XmlUtf8Encode_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_XmlUtf16Encode_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_XmlSizeOfUnknownEncoding_0(w2c_rlbox*);
static u32 w2c_rlbox_XmlInitUnknownEncoding_0(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_checkCharRefNumber(w2c_rlbox*, u32);
static u32 w2c_rlbox_unknown_isInvalid(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_unknown_isNmstrt(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_unknown_isName(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_unknown_toUtf16(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_unknown_toUtf8(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_XmlGetUtf8InternalEncoding_0(w2c_rlbox*);
static u32 w2c_rlbox_XmlGetUtf16InternalEncoding_0(w2c_rlbox*);
static u32 w2c_rlbox_XmlInitEncoding_0(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_getEncodingIndex(w2c_rlbox*, u32);
static void w2c_rlbox_initUpdatePosition(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_initScanContent(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_initScanProlog(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_streqci(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_initScan(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static void w2c_rlbox_normal_updatePosition(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_XmlParseXmlDecl_0(w2c_rlbox*, u32, u32, u32, u32, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_findEncoding(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_doParseXmlDecl(w2c_rlbox*, u32, u32, u32, u32, u32, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_parsePseudoAttribute(w2c_rlbox*, u32, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_XmlGetUtf8InternalEncodingNS_0(w2c_rlbox*);
static u32 w2c_rlbox_XmlGetUtf16InternalEncodingNS_0(w2c_rlbox*);
static u32 w2c_rlbox_XmlInitEncodingNS_0(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_initScanContentNS(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_initScanPrologNS(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_XmlParseXmlDeclNS_0(w2c_rlbox*, u32, u32, u32, u32, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_findEncodingNS(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_XmlInitUnknownEncodingNS_0(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_normal_prologTok(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_normal_scanLit(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_normal_scanDecl(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_normal_scanPi(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_normal_scanPercent(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_normal_scanPoundName(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_normal_contentTok(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_normal_scanComment(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_normal_scanRef(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_normal_scanAtts(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_normal_cdataSectionTok(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_normal_ignoreSectionTok(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_normal_attributeValueTok(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_normal_entityValueTok(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_normal_nameMatchesAscii(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_normal_nameLength(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_normal_skipS(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_normal_getAtts(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_normal_charRefNumber(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_normal_predefinedEntityName(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_normal_isPublicId(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_latin1_toUtf8(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_latin1_toUtf16(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_normal_checkPiTarget(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_utf8_toUtf8(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_utf8_toUtf16(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_utf8_isName2(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_utf8_isName3(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_isNever(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_utf8_isNmstrt2(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_utf8_isNmstrt3(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_utf8_isInvalid2(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_utf8_isInvalid3(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_utf8_isInvalid4(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_little2_prologTok(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_unicode_byte_type(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_little2_scanLit(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_little2_scanDecl(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_little2_scanPi(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_little2_scanPercent(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_little2_scanPoundName(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_little2_contentTok(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_little2_scanAtts(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_little2_scanRef(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_little2_scanComment(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_little2_cdataSectionTok(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_little2_ignoreSectionTok(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_little2_attributeValueTok(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_little2_entityValueTok(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_little2_nameMatchesAscii(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_little2_nameLength(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_little2_skipS(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_little2_getAtts(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_little2_charRefNumber(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_little2_predefinedEntityName(w2c_rlbox*, u32, u32, u32);
static void w2c_rlbox_little2_updatePosition(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_little2_isPublicId(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_little2_toUtf8(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_little2_toUtf16(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_little2_checkPiTarget(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_ascii_toUtf8(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_big2_prologTok(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_big2_scanLit(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_big2_scanDecl(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_big2_scanPi(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_big2_scanPercent(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_big2_scanPoundName(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_big2_contentTok(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_big2_scanAtts(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_big2_scanRef(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_big2_scanComment(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_big2_cdataSectionTok(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_big2_ignoreSectionTok(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_big2_attributeValueTok(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_big2_entityValueTok(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_big2_nameMatchesAscii(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_big2_nameLength(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_big2_skipS(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_big2_getAtts(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_big2_charRefNumber(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_big2_predefinedEntityName(w2c_rlbox*, u32, u32, u32);
static void w2c_rlbox_big2_updatePosition(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_big2_isPublicId(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_big2_toUtf8(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_big2_toUtf16(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_big2_checkPiTarget(w2c_rlbox*, u32, u32, u32);
static void w2c_rlbox_XmlPrologStateInit_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_prolog0(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_prolog1(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_doctype0(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_error(w2c_rlbox*, u32, u32, u32, u32, u32);
static void w2c_rlbox_XmlPrologStateInitExternalEntity_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_externalSubset0(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_externalSubset1(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_doctype1(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_internalSubset(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_prolog2(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_doctype3(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_doctype2(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_entity0(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_attlist0(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_element0(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_notation0(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_doctype5(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_doctype4(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_entity1(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_entity2(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_attlist1(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_element1(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_notation1(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_entity7(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_entity4(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_entity3(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_declClose(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_entity9(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_entity8(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_entity10(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_condSect0(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_condSect1(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_condSect2(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_entity5(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_entity6(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_attlist2(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_attlist5(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_attlist8(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_attlist3(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_attlist9(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_attlist6(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_attlist4(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_attlist7(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_element2(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_element7(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_element3(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_element6(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_element4(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_element5(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_notation3(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_notation2(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_notation4(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_main(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_FileMgr0x3A0x3AFileMgr0x28char0x20const0x2A0x2C0x20char0x20const0x2A0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_FileMgr0x3A0x3Agetline0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_FileMgr0x3A0x3Agetlinenum0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_FileMgr0x3A0x3A0x7EFileMgr0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_RegisterHunspellCallbacks_0(w2c_rlbox*, u32, u32, u32, u32, u32, u32, u32);
static void w2c_rlbox_AffEntry0x3A0x3A0x7EAffEntry0x280x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_AffEntry0x3A0x3A0x7EAffEntry0x280x290x2E1(w2c_rlbox*, u32);
static u32 w2c_rlbox_PfxEntry0x3A0x3APfxEntry0x28AffixMgr0x2A0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_PfxEntry0x3A0x3Aadd0x28char0x20const0x2A0x2C0x20unsigned0x20long0x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_PfxEntry0x3A0x3Atest_condition0x28char0x20const0x2A0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3Aoperator0x3D0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_PfxEntry0x3A0x3Acheckword0x28char0x20const0x2A0x2C0x20int0x2C0x20char0x2C0x20unsigned0x20short0x29(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_PfxEntry0x3A0x3Acheck_twosfx0x28char0x20const0x2A0x2C0x20int0x2C0x20char0x2C0x20unsigned0x20short0x29(w2c_rlbox*, u32, u32, u32, u32, u32);
static void w2c_rlbox_PfxEntry0x3A0x3Acheck_twosfx_morph0x28char0x20const0x2A0x2C0x20int0x2C0x20char0x2C0x20unsigned0x20short0x29(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static void w2c_rlbox_PfxEntry0x3A0x3Acheck_morph0x28char0x20const0x2A0x2C0x20int0x2C0x20char0x2C0x20unsigned0x20short0x29(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_SfxEntry0x3A0x3ASfxEntry0x28AffixMgr0x2A0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_SfxEntry0x3A0x3Aadd0x28char0x20const0x2A0x2C0x20unsigned0x20long0x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_SfxEntry0x3A0x3Atest_condition0x28char0x20const0x2A0x2C0x20char0x20const0x2A0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_SfxEntry0x3A0x3Acheckword0x28char0x20const0x2A0x2C0x20int0x2C0x20int0x2C0x20PfxEntry0x2A0x2C0x20unsigned0x20short0x2C0x20unsigned0x20short0x2C0x20unsigned0x20short0x29(w2c_rlbox*, u32, u32, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3Abasic_string0x5Babi0x3Ann2101050x5D0x28char0x20const0x2A0x2C0x20unsigned0x20long0x29(w2c_rlbox*, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A_0x5Fthrow_length_error0x5Babi0x3Ann2101050x5D0x280x29(w2c_rlbox*);
static u32 w2c_rlbox_SfxEntry0x3A0x3Acheck_twosfx0x28char0x20const0x2A0x2C0x20int0x2C0x20int0x2C0x20PfxEntry0x2A0x2C0x20unsigned0x20short0x29(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3Abasic_string0x5Babi0x3Ann2101050x5D0x3C00x3E0x28char0x20const0x2A0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_SfxEntry0x3A0x3Acheck_twosfx_morph0x28char0x20const0x2A0x2C0x20int0x2C0x20int0x2C0x20PfxEntry0x2A0x2C0x20unsigned0x20short0x29(w2c_rlbox*, u32, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_SfxEntry0x3A0x3Aget_next_homonym0x28hentry0x2A0x2C0x20int0x2C0x20PfxEntry0x2A0x2C0x20unsigned0x20short0x2C0x20unsigned0x20short0x29(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static void w2c_rlbox_SfxEntry0x3A0x3AinitReverseWord0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_PfxEntry0x3A0x3A0x7EPfxEntry0x280x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_SfxEntry0x3A0x3A0x7ESfxEntry0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_SfxEntry0x3A0x3A0x7ESfxEntry0x280x290x2E1(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fthrow_length_error0x5Babi0x3Ann2101050x5D0x28char0x20const0x2A0x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_AffixMgr0x3A0x3AAffixMgr0x28char0x20const0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3CHashMgr0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3CHashMgr0x2A0x3E0x3E0x20const0x260x2C0x20char0x20const0x2A0x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_AffixMgr0x3A0x3Aparse_file0x28char0x20const0x2A0x2C0x20char0x20const0x2A0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3Aerase0x28unsigned0x20long0x2C0x20unsigned0x20long0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_AffixMgr0x3A0x3Aparse_flag0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x2C0x20unsigned0x20short0x2A0x2C0x20FileMgr0x2A0x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_AffixMgr0x3A0x3Aparse_num0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x2C0x20int0x2A0x2C0x20FileMgr0x2A0x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_AffixMgr0x3A0x3Aparse_cpdsyllable0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x2C0x20FileMgr0x2A0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_AffixMgr0x3A0x3Aparse_convtable0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x2C0x20FileMgr0x2A0x2C0x20RepList0x2A0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x29(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_AffixMgr0x3A0x3Aparse_phonetable0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x2C0x20FileMgr0x2A0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_AffixMgr0x3A0x3Aparse_checkcpdtable0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x2C0x20FileMgr0x2A0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_AffixMgr0x3A0x3Aparse_defcpdtable0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x2C0x20FileMgr0x2A0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_AffixMgr0x3A0x3Aparse_maptable0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x2C0x20FileMgr0x2A0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_AffixMgr0x3A0x3Aparse_breaktable0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x2C0x20FileMgr0x2A0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3Afind_first_not_of0x5Babi0x3Ann2101050x5D0x28char0x20const0x2A0x2C0x20unsigned0x20long0x290x20const(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_AffixMgr0x3A0x3Aparse_affix0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x2C0x20char0x2C0x20FileMgr0x2A0x2C0x20char0x2A0x29(w2c_rlbox*, u32, u32, u32, u32, u32);
static void w2c_rlbox_AffixMgr0x3A0x3AfinishFileMgr0x28FileMgr0x2A0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_AffixMgr0x3A0x3Aprocess_pfx_order0x280x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_AffixMgr0x3A0x3Aprocess_sfx_order0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x3E0x3A0x3Apush_back0x5Babi0x3Ann2101050x5D0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x260x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_AffixMgr0x3A0x3A0x7EAffixMgr0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x3E0x3A0x3A_0x5Fdestroy_vector0x3A0x3Aoperator0x280x290x5Babi0x3Ann2101050x5D0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Cunsigned0x20short0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cunsigned0x20short0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Cunsigned0x20short0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cunsigned0x20short0x3E0x3E0x3E0x3E0x3A0x3A_0x5Fdestroy_vector0x3A0x3Aoperator0x280x290x5Babi0x3Ann2101050x5D0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Avector0x3Cpatentry0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cpatentry0x3E0x3E0x3A0x3A_0x5Fdestroy_vector0x3A0x3Aoperator0x280x290x5Babi0x3Ann2101050x5D0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x3E0x3E0x3E0x3A0x3A_0x5Fdestroy_vector0x3A0x3Aoperator0x280x290x5Babi0x3Ann2101050x5D0x280x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_AffixMgr0x3A0x3Aprocess_pfx_in_order0x28PfxEntry0x2A0x2C0x20PfxEntry0x2A0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_AffixMgr0x3A0x3Aprocess_sfx_in_order0x28SfxEntry0x2A0x2C0x20SfxEntry0x2A0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_AffixMgr0x3A0x3Aprocess_pfx_tree_to_list0x280x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_AffixMgr0x3A0x3Aprocess_sfx_tree_to_list0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A_0x5Fthrow_out_of_range0x5Babi0x3Ann2101050x5D0x280x29(w2c_rlbox*);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A_0x5Finit_with_size0x5Babi0x3Ann2101050x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Cchar0x20const0x2A0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Cchar0x20const0x2A0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Cchar0x20const0x2A0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Cchar0x20const0x2A0x3E0x2C0x20unsigned0x20long0x29(w2c_rlbox*, u32, u32, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A_0x5Fassign_trivial0x5Babi0x3Ann2101050x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Cchar0x20const0x2A0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Cchar0x20const0x2A0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Cchar0x20const0x2A0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Cchar0x20const0x2A0x3E0x2C0x20unsigned0x20long0x29(w2c_rlbox*, u32, u32, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fintrosort0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cvoid0x2C0x20void0x3E0x260x2C0x20w_char0x2A0x2C0x20false0x3E0x28w_char0x2A0x2C0x20w_char0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cvoid0x2C0x20void0x3E0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Aiterator_traits0x3Cw_char0x2A0x3E0x3A0x3Adifference_type0x2C0x20bool0x29(w2c_rlbox*, u32, u32, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x3E0x3A0x3A_0x5Fbase_destruct_at_end0x5Babi0x3Ann2101050x5D0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2A0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Avector0x3Cpatentry0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cpatentry0x3E0x3E0x3A0x3Areserve0x28unsigned0x20long0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Avector0x3Cpatentry0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cpatentry0x3E0x3E0x3A0x3Apush_back0x5Babi0x3Ann2101050x5D0x28patentry0x260x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3Abasic_string0x5Babi0x3Ann2101050x5D0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x2C0x20unsigned0x20long0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x20const0x260x29(w2c_rlbox*, u32, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Cunsigned0x20short0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cunsigned0x20short0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Cunsigned0x20short0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cunsigned0x20short0x3E0x3E0x3E0x3E0x3A0x3Areserve0x28unsigned0x20long0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Avector0x3Cunsigned0x20short0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cunsigned0x20short0x3E0x3E0x260x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Cunsigned0x20short0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cunsigned0x20short0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Cunsigned0x20short0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cunsigned0x20short0x3E0x3E0x3E0x3E0x3A0x3Aemplace_back0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Cunsigned0x20short0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cunsigned0x20short0x3E0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Avector0x3Cunsigned0x20short0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cunsigned0x20short0x3E0x3E0x260x260x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Avector0x3Cunsigned0x20short0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cunsigned0x20short0x3E0x3E0x3A0x3Apush_back0x5Babi0x3Ann2101050x5D0x28unsigned0x20short0x260x260x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x3E0x3E0x3E0x3A0x3Areserve0x28unsigned0x20long0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x3E0x260x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x3E0x3E0x3E0x3A0x3Aemplace_back0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x3E0x260x260x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x3E0x3A0x3Areserve0x28unsigned0x20long0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_entries_container0x3A0x3Ainitialize0x28int0x2C0x20char0x2C0x20unsigned0x20short0x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_entries_container0x3A0x3Aadd_entry0x28char0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_AffixMgr0x3A0x3Areverse_condition0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_AffixMgr0x3A0x3Aredundant_condition0x28char0x2C0x20char0x20const0x2A0x2C0x20int0x2C0x20char0x20const0x2A0x2C0x20int0x29(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_AffixMgr0x3A0x3Aencodeit0x28AffEntry0x260x2C0x20char0x20const0x2A0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x260x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3Aappend0x5Babi0x3Ann2101050x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Cchar0x20const0x2A0x3E0x2C0x2000x3E0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Cchar0x20const0x2A0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Cchar0x20const0x2A0x3E0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_AffixMgr0x3A0x3Abuild_pfxtree0x28PfxEntry0x2A0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_AffixMgr0x3A0x3Abuild_sfxtree0x28SfxEntry0x2A0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_entries_container0x3A0x3A0x7Eentries_container0x280x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_AffixMgr0x3A0x3Aget_encoding0x280x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fsplit_buffer0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x260x3E0x3A0x3A_0x5Fsplit_buffer0x28unsigned0x20long0x2C0x20unsigned0x20long0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x260x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fsplit_buffer0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x260x3E0x3A0x3A0x7E_0x5Fsplit_buffer0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x3E0x3A0x3A_0x5Fthrow_length_error0x5Babi0x3Ann2101050x5D0x280x29(w2c_rlbox*);
static u32 w2c_rlbox_AffixMgr0x3A0x3Adebugflag0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x260x2C0x20unsigned0x20short0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_AffixMgr0x3A0x3Aencode_flag0x28unsigned0x20short0x290x20const(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_AffixMgr0x3A0x3Acondlen0x28char0x20const0x2A0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_AffixMgr0x3A0x3Aprefix_check0x28char0x20const0x2A0x2C0x20int0x2C0x20char0x2C0x20unsigned0x20short0x29(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_AffixMgr0x3A0x3Aprefix_check_twosfx0x28char0x20const0x2A0x2C0x20int0x2C0x20char0x2C0x20unsigned0x20short0x29(w2c_rlbox*, u32, u32, u32, u32, u32);
static void w2c_rlbox_AffixMgr0x3A0x3Aprefix_check_morph0x28char0x20const0x2A0x2C0x20int0x2C0x20char0x2C0x20unsigned0x20short0x29(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static void w2c_rlbox_AffixMgr0x3A0x3Aprefix_check_twosfx_morph0x28char0x20const0x2A0x2C0x20int0x2C0x20char0x2C0x20unsigned0x20short0x29(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_AffixMgr0x3A0x3Acpdrep_check0x28char0x20const0x2A0x2C0x20int0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_AffixMgr0x3A0x3Alookup0x28char0x20const0x2A0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_AffixMgr0x3A0x3Aaffix_check0x28char0x20const0x2A0x2C0x20int0x2C0x20unsigned0x20short0x2C0x20char0x29(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_AffixMgr0x3A0x3Aget_reptable0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_AffixMgr0x3A0x3Acpdwordpair_check0x28char0x20const0x2A0x2C0x20int0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_AffixMgr0x3A0x3Acpdpat_check0x28char0x20const0x2A0x2C0x20int0x2C0x20hentry0x2A0x2C0x20hentry0x2A0x2C0x20char0x29(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_AffixMgr0x3A0x3Acpdcase_check0x28char0x20const0x2A0x2C0x20int0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_AffixMgr0x3A0x3Adefcpd_check0x28hentry0x2A0x2A0x2A0x2C0x20short0x2C0x20hentry0x2A0x2C0x20hentry0x2A0x2A0x2C0x20char0x29(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Avector0x3Cmetachar_data0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cmetachar_data0x3E0x3E0x3A0x3Aresize0x28unsigned0x20long0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Avector0x3Cmetachar_data0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cmetachar_data0x3E0x3E0x3A0x3A_0x5Fappend0x28unsigned0x20long0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_AffixMgr0x3A0x3Aget_syllable0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_AffixMgr0x3A0x3Asetcminmax0x28int0x2A0x2C0x20int0x2A0x2C0x20char0x20const0x2A0x2C0x20int0x29(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_AffixMgr0x3A0x3Acompound_check0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x2C0x20short0x2C0x20short0x2C0x20short0x2C0x20short0x2C0x20hentry0x2A0x2A0x2C0x20hentry0x2A0x2A0x2C0x20char0x2C0x20char0x2C0x20int0x2A0x29(w2c_rlbox*, u32, u32, u32, u32, u32, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_AffixMgr0x3A0x3Asuffix_check0x28char0x20const0x2A0x2C0x20int0x2C0x20int0x2C0x20PfxEntry0x2A0x2C0x20unsigned0x20short0x2C0x20unsigned0x20short0x2C0x20char0x29(w2c_rlbox*, u32, u32, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_AffixMgr0x3A0x3Asuffix_check_twosfx0x28char0x20const0x2A0x2C0x20int0x2C0x20int0x2C0x20PfxEntry0x2A0x2C0x20unsigned0x20short0x29(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_AffixMgr0x3A0x3Acompound_check_morph0x28char0x20const0x2A0x2C0x20int0x2C0x20short0x2C0x20short0x2C0x20short0x2C0x20short0x2C0x20hentry0x2A0x2A0x2C0x20hentry0x2A0x2A0x2C0x20char0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x2A0x29(w2c_rlbox*, u32, u32, u32, u32, u32, u32, u32, u32, u32, u32, u32, u32);
static void w2c_rlbox_AffixMgr0x3A0x3Aaffix_check_morph0x28char0x20const0x2A0x2C0x20int0x2C0x20unsigned0x20short0x2C0x20char0x29(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static void w2c_rlbox_AffixMgr0x3A0x3Asuffix_check_morph0x28char0x20const0x2A0x2C0x20int0x2C0x20int0x2C0x20PfxEntry0x2A0x2C0x20unsigned0x20short0x2C0x20unsigned0x20short0x2C0x20char0x29(w2c_rlbox*, u32, u32, u32, u32, u32, u32, u32, u32, u32);
static void w2c_rlbox_AffixMgr0x3A0x3Asuffix_check_twosfx_morph0x28char0x20const0x2A0x2C0x20int0x2C0x20int0x2C0x20PfxEntry0x2A0x2C0x20unsigned0x20short0x29(w2c_rlbox*, u32, u32, u32, u32, u32, u32, u32);
static void w2c_rlbox_AffixMgr0x3A0x3Amorphgen0x28char0x20const0x2A0x2C0x20int0x2C0x20unsigned0x20short0x20const0x2A0x2C0x20unsigned0x20short0x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x2C0x20int0x29(w2c_rlbox*, u32, u32, u32, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_morphcmp0x28char0x20const0x2A0x2C0x20char0x20const0x2A0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_AffixMgr0x3A0x3Aexpand_rootword0x28guessword0x2A0x2C0x20int0x2C0x20char0x20const0x2A0x2C0x20int0x2C0x20unsigned0x20short0x20const0x2A0x2C0x20unsigned0x20short0x2C0x20char0x20const0x2A0x2C0x20int0x2C0x20char0x20const0x2A0x29(w2c_rlbox*, u32, u32, u32, u32, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_AffixMgr0x3A0x3Aget_iconvtable0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_AffixMgr0x3A0x3Aget_oconvtable0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_AffixMgr0x3A0x3Aget_phonetable0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_AffixMgr0x3A0x3Aget_maptable0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_AffixMgr0x3A0x3Aget_breaktable0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_AffixMgr0x3A0x3Aget_langnum0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_AffixMgr0x3A0x3Aget_complexprefixes0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_AffixMgr0x3A0x3Aget_fullstrip0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_AffixMgr0x3A0x3Aget_keepcase0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_AffixMgr0x3A0x3Aget_forceucase0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_AffixMgr0x3A0x3Aget_warn0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_AffixMgr0x3A0x3Aget_forbidwarn0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_AffixMgr0x3A0x3Aget_checksharps0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_AffixMgr0x3A0x3Aget_ignore0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_AffixMgr0x3A0x3Aget_ignore_utf160x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_AffixMgr0x3A0x3Aget_key_string0x280x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_AffixMgr0x3A0x3Aget_try_string0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_AffixMgr0x3A0x3Aget_wordchars0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_AffixMgr0x3A0x3Aget_wordchars_utf160x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_AffixMgr0x3A0x3Aget_compound0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_AffixMgr0x3A0x3Aget_compoundflag0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_AffixMgr0x3A0x3Aget_forbiddenword0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_AffixMgr0x3A0x3Aget_nosuggest0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_AffixMgr0x3A0x3Aget_nongramsuggest0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_AffixMgr0x3A0x3Aget_substandard0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_AffixMgr0x3A0x3Aget_needaffix0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_AffixMgr0x3A0x3Aget_onlyincompound0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_AffixMgr0x3A0x3Aget_version0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_AffixMgr0x3A0x3Ahave_contclass0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_AffixMgr0x3A0x3Aget_utf80x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_AffixMgr0x3A0x3Aget_maxngramsugs0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_AffixMgr0x3A0x3Aget_maxcpdsugs0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_AffixMgr0x3A0x3Aget_maxdiff0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_AffixMgr0x3A0x3Aget_onlymaxdiff0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_AffixMgr0x3A0x3Aget_nosplitsugs0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_AffixMgr0x3A0x3Aget_sugswithdots0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fsplit_buffer0x3Cpatentry0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cpatentry0x3E0x260x3E0x3A0x3A_0x5Fsplit_buffer0x28unsigned0x20long0x2C0x20unsigned0x20long0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cpatentry0x3E0x260x29(w2c_rlbox*, u32, u32, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Funinitialized_allocator_relocate0x5Babi0x3Ann2101050x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cpatentry0x3E0x2C0x20patentry0x2A0x3E0x28std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cpatentry0x3E0x260x2C0x20patentry0x2A0x2C0x20patentry0x2A0x2C0x20patentry0x2A0x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fsplit_buffer0x3Cpatentry0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cpatentry0x3E0x260x3E0x3A0x3A0x7E_0x5Fsplit_buffer0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Avector0x3Cpatentry0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cpatentry0x3E0x3E0x3A0x3A_0x5Fthrow_length_error0x5Babi0x3Ann2101050x5D0x280x29(w2c_rlbox*);
static u32 w2c_rlbox_patentry0x2A0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Cpatentry0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cpatentry0x3E0x3E0x3A0x3A_0x5Femplace_back_slow_path0x3Cpatentry0x3E0x28patentry0x260x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fsplit_buffer0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Cunsigned0x20short0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cunsigned0x20short0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Cunsigned0x20short0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cunsigned0x20short0x3E0x3E0x3E0x260x3E0x3A0x3A_0x5Fsplit_buffer0x28unsigned0x20long0x2C0x20unsigned0x20long0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Cunsigned0x20short0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cunsigned0x20short0x3E0x3E0x3E0x260x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fsplit_buffer0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Cunsigned0x20short0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cunsigned0x20short0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Cunsigned0x20short0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cunsigned0x20short0x3E0x3E0x3E0x260x3E0x3A0x3A0x7E_0x5Fsplit_buffer0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Cunsigned0x20short0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cunsigned0x20short0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Cunsigned0x20short0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cunsigned0x20short0x3E0x3E0x3E0x3E0x3A0x3A_0x5Fthrow_length_error0x5Babi0x3Ann2101050x5D0x280x29(w2c_rlbox*);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fsplit_buffer0x3Cunsigned0x20short0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cunsigned0x20short0x3E0x260x3E0x3A0x3A_0x5Fsplit_buffer0x28unsigned0x20long0x2C0x20unsigned0x20long0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cunsigned0x20short0x3E0x260x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fsplit_buffer0x3Cunsigned0x20short0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cunsigned0x20short0x3E0x260x3E0x3A0x3A0x7E_0x5Fsplit_buffer0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Avector0x3Cunsigned0x20short0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cunsigned0x20short0x3E0x3E0x3A0x3A_0x5Fthrow_length_error0x5Babi0x3Ann2101050x5D0x280x29(w2c_rlbox*);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fsplit_buffer0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x3E0x3E0x260x3E0x3A0x3A_0x5Fsplit_buffer0x28unsigned0x20long0x2C0x20unsigned0x20long0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x3E0x3E0x260x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fsplit_buffer0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x3E0x3E0x260x3E0x3A0x3A0x7E_0x5Fsplit_buffer0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x3E0x3E0x3E0x3A0x3A_0x5Fthrow_length_error0x5Babi0x3Ann2101050x5D0x280x29(w2c_rlbox*);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Avector0x3CAffEntry0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3CAffEntry0x2A0x3E0x3E0x3A0x3Areserve0x28unsigned0x20long0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Avector0x3CAffEntry0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3CAffEntry0x2A0x3E0x3E0x3A0x3Apush_back0x5Babi0x3Ann2101050x5D0x28AffEntry0x2A0x260x260x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A_0x5Fgrow_by0x5Babi0x3Ann2101050x5D0x28unsigned0x20long0x2C0x20unsigned0x20long0x2C0x20unsigned0x20long0x2C0x20unsigned0x20long0x2C0x20unsigned0x20long0x2C0x20unsigned0x20long0x29(w2c_rlbox*, u32, u32, u32, u32, u32, u32, u32);
static void w2c_rlbox_AffixMgr0x3A0x3Aget_suffix_words0x28unsigned0x20short0x2A0x2C0x20int0x2C0x20char0x20const0x2A0x29(w2c_rlbox*, u32, u32, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x3E0x3A0x3Apush_back0x5Babi0x3Ann2101050x5D0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2A0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x3E0x3A0x3A_0x5Femplace_back_slow_path0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x3E0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fsplit_buffer0x3CAffEntry0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3CAffEntry0x2A0x3E0x260x3E0x3A0x3A_0x5Fsplit_buffer0x28unsigned0x20long0x2C0x20unsigned0x20long0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3CAffEntry0x2A0x3E0x260x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fsplit_buffer0x3CAffEntry0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3CAffEntry0x2A0x3E0x260x3E0x3A0x3A0x7E_0x5Fsplit_buffer0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Avector0x3CAffEntry0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3CAffEntry0x2A0x3E0x3E0x3A0x3A_0x5Fthrow_length_error0x5Babi0x3Ann2101050x5D0x280x29(w2c_rlbox*);
static void w2c_rlbox_std0x3A0x3A_0x5Fthrow_bad_array_new_length0x5Babi0x3Ann2101050x5D0x280x29(w2c_rlbox*);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fthrow_out_of_range0x5Babi0x3Ann2101050x5D0x28char0x20const0x2A0x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cpatentry0x3E0x3A0x3Adestroy0x5Babi0x3Ann2101050x5D0x28patentry0x2A0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Cunsigned0x20short0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cunsigned0x20short0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Cunsigned0x20short0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cunsigned0x20short0x3E0x3E0x3E0x3E0x3A0x3A_0x5Fbase_destruct_at_end0x5Babi0x3Ann2101050x5D0x28std0x3A0x3A_0x5F20x3A0x3Avector0x3Cunsigned0x20short0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cunsigned0x20short0x3E0x3E0x2A0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fsplit_buffer0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x260x3E0x3A0x3A_0x5Fdestruct_at_end0x5Babi0x3Ann2101050x5D0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2A0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Avector0x3Cmetachar_data0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cmetachar_data0x3E0x3E0x3A0x3A_0x5Fthrow_length_error0x5Babi0x3Ann2101050x5D0x280x29(w2c_rlbox*);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fsplit_buffer0x3Cmetachar_data0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cmetachar_data0x3E0x260x3E0x3A0x3A_0x5Fsplit_buffer0x28unsigned0x20long0x2C0x20unsigned0x20long0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cmetachar_data0x3E0x260x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fsplit_buffer0x3Cmetachar_data0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cmetachar_data0x3E0x260x3E0x3A0x3A0x7E_0x5Fsplit_buffer0x280x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_w_char0x2A0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fpartial_sort_impl0x5Babi0x3Ann2101050x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cvoid0x2C0x20void0x3E0x260x2C0x20w_char0x2A0x2C0x20w_char0x2A0x3E0x28w_char0x2A0x2C0x20w_char0x2A0x2C0x20w_char0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cvoid0x2C0x20void0x3E0x260x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_w_char0x2A0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fpartition_with_equals_on_left0x5Babi0x3Ann2101050x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20w_char0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cvoid0x2C0x20void0x3E0x260x3E0x28w_char0x2A0x2C0x20w_char0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cvoid0x2C0x20void0x3E0x260x29(w2c_rlbox*, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Apair0x3Cw_char0x2A0x2C0x20bool0x3E0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fpartition_with_equals_on_right0x5Babi0x3Ann2101050x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20w_char0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cvoid0x2C0x20void0x3E0x260x3E0x28w_char0x2A0x2C0x20w_char0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cvoid0x2C0x20void0x3E0x260x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_bool0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Finsertion_sort_incomplete0x5Babi0x3Ann2101050x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cvoid0x2C0x20void0x3E0x260x2C0x20w_char0x2A0x3E0x28w_char0x2A0x2C0x20w_char0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cvoid0x2C0x20void0x3E0x260x29(w2c_rlbox*, u32, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fsift_down0x5Babi0x3Ann2101050x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cvoid0x2C0x20void0x3E0x260x2C0x20w_char0x2A0x3E0x28w_char0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cvoid0x2C0x20void0x3E0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Aiterator_traits0x3Cw_char0x2A0x3E0x3A0x3Adifference_type0x2C0x20w_char0x2A0x29(w2c_rlbox*, u32, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fsplit_buffer0x3Cpatentry0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cpatentry0x3E0x260x3E0x3A0x3Aclear0x5Babi0x3Ann2101050x5D0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fsplit_buffer0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Cunsigned0x20short0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cunsigned0x20short0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Cunsigned0x20short0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cunsigned0x20short0x3E0x3E0x3E0x260x3E0x3A0x3A_0x5Fdestruct_at_end0x5Babi0x3Ann2101050x5D0x28std0x3A0x3A_0x5F20x3A0x3Avector0x3Cunsigned0x20short0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cunsigned0x20short0x3E0x3E0x2A0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fsplit_buffer0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x3E0x3E0x260x3E0x3A0x3Aclear0x5Babi0x3Ann2101050x5D0x280x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_u16_u80x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Cw_char0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cw_char0x3E0x3E0x20const0x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_u8_u160x28std0x3A0x3A_0x5F20x3A0x3Avector0x3Cw_char0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cw_char0x3E0x3E0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Avector0x3Cw_char0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cw_char0x3E0x3E0x3A0x3Apush_back0x5Babi0x3Ann2101050x5D0x28w_char0x20const0x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fsplit_buffer0x3Cw_char0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cw_char0x3E0x260x3E0x3A0x3A_0x5Fsplit_buffer0x28unsigned0x20long0x2C0x20unsigned0x20long0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cw_char0x3E0x260x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fsplit_buffer0x3Cw_char0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cw_char0x3E0x260x3E0x3A0x3A0x7E_0x5Fsplit_buffer0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Avector0x3Cw_char0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cw_char0x3E0x3E0x3A0x3A_0x5Fthrow_length_error0x5Babi0x3Ann2101050x5D0x280x29(w2c_rlbox*);
static u32 w2c_rlbox_mystrsep0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Cchar0x20const0x2A0x3E0x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_mystrdup0x28char0x20const0x2A0x29(w2c_rlbox*, u32);
static void w2c_rlbox_mychomp0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x260x29(w2c_rlbox*, u32);
static void w2c_rlbox_line_tok0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x2C0x20char0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_stringstream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3Abasic_stringstream0x5Babi0x3Ann2101050x5D0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x2C0x20unsigned0x20int0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x260x20std0x3A0x3A_0x5F20x3A0x3Agetline0x5Babi0x3Ann2101050x5D0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x260x2C0x20char0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_stringbuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3Abasic_stringbuf0x5Babi0x3Ann2101050x5D0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x2C0x20unsigned0x20int0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x260x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3Aappend0x5Babi0x3Ann2101050x5D0x3Cchar0x20const0x2A0x2C0x2000x3E0x28char0x20const0x2A0x2C0x20char0x20const0x2A0x29(w2c_rlbox*, u32, u32, u32);
static void w2c_rlbox_line_uniq0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x260x2C0x20char0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_line_uniq_app0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x260x2C0x20char0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_strlinecat0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_fieldlen0x28char0x20const0x2A0x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_copy_field0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3Afind0x5Babi0x3Ann2101050x5D0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x2C0x20unsigned0x20long0x290x20const(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_mystrrep0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_reverseword0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x260x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_reverseword_utf0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x260x29(w2c_rlbox*, u32);
static void w2c_rlbox_uniqlist0x28std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x3E0x260x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2A0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Ffind0x5Babi0x3Ann2101050x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fidentity0x3E0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fidentity0x260x29(w2c_rlbox*, u32, u32, u32, u32);
static void w2c_rlbox_upper_utf0x28w_char0x2C0x20int0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_unicodetoupper0x28unsigned0x20short0x2C0x20int0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_lower_utf0x28w_char0x2C0x20int0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_unicodetolower0x28unsigned0x20short0x2C0x20int0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_mkallcap0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x260x2C0x20cs_info0x20const0x2A0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_mkallsmall0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x260x2C0x20cs_info0x20const0x2A0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_mkallsmall_utf0x28std0x3A0x3A_0x5F20x3A0x3Avector0x3Cw_char0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cw_char0x3E0x3E0x260x2C0x20int0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_mkallcap_utf0x28std0x3A0x3A_0x5F20x3A0x3Avector0x3Cw_char0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cw_char0x3E0x3E0x260x2C0x20int0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_mkinitcap0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x260x2C0x20cs_info0x20const0x2A0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_mkinitcap_utf0x28std0x3A0x3A_0x5F20x3A0x3Avector0x3Cw_char0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cw_char0x3E0x3E0x260x2C0x20int0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_mkinitsmall0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x260x2C0x20cs_info0x20const0x2A0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_mkinitsmall_utf0x28std0x3A0x3A_0x5F20x3A0x3Avector0x3Cw_char0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cw_char0x3E0x3E0x260x2C0x20int0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_store_pointer0x28char0x2A0x2C0x20char0x2A0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_get_stored_pointer0x28char0x20const0x2A0x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_get_current_cs0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x29(w2c_rlbox*, u32);
static void w2c_rlbox_get_casechars0x28char0x20const0x2A0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_get_lang_num0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x29(w2c_rlbox*, u32);
static void w2c_rlbox_free_utf_tbl0x280x29(w2c_rlbox*);
static u32 w2c_rlbox_unicodeisalpha0x28unsigned0x20short0x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_get_captype0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x2C0x20cs_info0x2A0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_get_captype_utf80x28std0x3A0x3A_0x5F20x3A0x3Avector0x3Cw_char0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cw_char0x3E0x3E0x20const0x260x2C0x20int0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_remove_ignored_chars_utf0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Cw_char0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cw_char0x3E0x3E0x20const0x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_remove_ignored_chars0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_parse_string0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x260x2C0x20int0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_parse_array0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Cw_char0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cw_char0x3E0x3E0x260x2C0x20int0x2C0x20int0x29(w2c_rlbox*, u32, u32, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_stringbuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A_0x5Finit_buf_ptrs0x5Babi0x3Ann2101050x5D0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A_0x5Finit_with_size0x5Babi0x3Ann2101050x5D0x3Cchar0x20const0x2A0x2C0x20char0x20const0x2A0x3E0x28char0x20const0x2A0x2C0x20char0x20const0x2A0x2C0x20unsigned0x20long0x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_HashMgr0x3A0x3AHashMgr0x28char0x20const0x2A0x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_HashMgr0x3A0x3Aload_config0x28char0x20const0x2A0x2C0x20char0x20const0x2A0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_HashMgr0x3A0x3Aload_tables0x28char0x20const0x2A0x2C0x20char0x20const0x2A0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3Afind0x5Babi0x3Ann2101050x5D0x28char0x20const0x2A0x2C0x20unsigned0x20long0x290x20const(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_HashMgr0x3A0x3Adecode_flag0x28char0x20const0x2A0x290x20const(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_HashMgr0x3A0x3Aparse_aliasf0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x2C0x20FileMgr0x2A0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_HashMgr0x3A0x3Aparse_aliasm0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x2C0x20FileMgr0x2A0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_HashMgr0x3A0x3Aparse_reptable0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x2C0x20FileMgr0x2A0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_HashMgr0x3A0x3Adecode_flags0x28unsigned0x20short0x2A0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x2C0x20FileMgr0x2A0x2C0x20bool0x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_HashMgr0x3A0x3Aget_clen_and_captype0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x2C0x20int0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Cw_char0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cw_char0x3E0x3E0x260x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_HashMgr0x3A0x3Aadd_word0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x2C0x20int0x2C0x20unsigned0x20short0x2A0x2C0x20int0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x2A0x2C0x20bool0x2C0x20int0x29(w2c_rlbox*, u32, u32, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_HashMgr0x3A0x3Aadd_hidden_capitalized_word0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x2C0x20int0x2C0x20unsigned0x20short0x2A0x2C0x20int0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x2A0x2C0x20int0x29(w2c_rlbox*, u32, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_HashMgr0x3A0x3A0x7EHashMgr0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cunsigned0x20char0x200x5B0x5D0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cunsigned0x20char0x200x5B0x5D0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cunsigned0x20char0x200x5B0x5D0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cunsigned0x20char0x200x5B0x5D0x3E0x3E0x3E0x3E0x3A0x3A_0x5Fdestroy_vector0x3A0x3Aoperator0x280x290x5Babi0x3Ann2101050x5D0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Avector0x3Creplentry0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Creplentry0x3E0x3E0x3A0x3A_0x5Fdestroy_vector0x3A0x3Aoperator0x280x290x5Babi0x3Ann2101050x5D0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_HashMgr0x3A0x3Aarena_free0x28void0x2A0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_HashMgr0x3A0x3Alookup0x28char0x20const0x2A0x290x20const(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_HashMgr0x3A0x3Ahash0x28char0x20const0x2A0x290x20const(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_HashMgr0x3A0x3Aarena_alloc0x28int0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Avector0x3Creplentry0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Creplentry0x3E0x3E0x3A0x3Areserve0x28unsigned0x20long0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Avector0x3Creplentry0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Creplentry0x3E0x3E0x3A0x3Apush_back0x5Babi0x3Ann2101050x5D0x28replentry0x260x260x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cunsigned0x20char0x200x5B0x5D0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cunsigned0x20char0x200x5B0x5D0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cunsigned0x20char0x200x5B0x5D0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cunsigned0x20char0x200x5B0x5D0x3E0x3E0x3E0x3E0x3A0x3Apush_back0x5Babi0x3Ann2101050x5D0x28std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cunsigned0x20char0x200x5B0x5D0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cunsigned0x20char0x200x5B0x5D0x3E0x3E0x260x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_HashMgr0x3A0x3Aget_aliasm0x28int0x290x20const(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fsplit_buffer0x3Creplentry0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Creplentry0x3E0x260x3E0x3A0x3A_0x5Fsplit_buffer0x28unsigned0x20long0x2C0x20unsigned0x20long0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Creplentry0x3E0x260x29(w2c_rlbox*, u32, u32, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Funinitialized_allocator_relocate0x5Babi0x3Ann2101050x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3Aallocator0x3Creplentry0x3E0x2C0x20replentry0x2A0x3E0x28std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Creplentry0x3E0x260x2C0x20replentry0x2A0x2C0x20replentry0x2A0x2C0x20replentry0x2A0x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fsplit_buffer0x3Creplentry0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Creplentry0x3E0x260x3E0x3A0x3A0x7E_0x5Fsplit_buffer0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Avector0x3Creplentry0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Creplentry0x3E0x3E0x3A0x3A_0x5Fthrow_length_error0x5Babi0x3Ann2101050x5D0x280x29(w2c_rlbox*);
static u32 w2c_rlbox_replentry0x2A0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Creplentry0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Creplentry0x3E0x3E0x3A0x3A_0x5Femplace_back_slow_path0x3Creplentry0x3E0x28replentry0x260x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_HashMgr0x3A0x3Aget_clen_and_captype0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x2C0x20int0x2A0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_HashMgr0x3A0x3Aremove0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_HashMgr0x3A0x3Aremove_forbidden_flag0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_HashMgr0x3A0x3Aadd0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_HashMgr0x3A0x3Aadd_with_affix0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_HashMgr0x3A0x3Awalk_hashtable0x28int0x260x2C0x20hentry0x2A0x290x20const(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_HashMgr0x3A0x3Aget_aliasf0x28int0x2C0x20unsigned0x20short0x2A0x2A0x2C0x20FileMgr0x2A0x290x20const(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_HashMgr0x3A0x3Adecode_flags0x28std0x3A0x3A_0x5F20x3A0x3Avector0x3Cunsigned0x20short0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cunsigned0x20short0x3E0x3E0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x2C0x20FileMgr0x2A0x290x20const(w2c_rlbox*, u32, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Avector0x3Cunsigned0x20short0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cunsigned0x20short0x3E0x3E0x3A0x3Areserve0x28unsigned0x20long0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Avector0x3Cunsigned0x20short0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cunsigned0x20short0x3E0x3E0x3A0x3Aresize0x28unsigned0x20long0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Avector0x3Cunsigned0x20short0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cunsigned0x20short0x3E0x3E0x3A0x3A_0x5Fappend0x28unsigned0x20long0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_HashMgr0x3A0x3Aencode_flag0x28unsigned0x20short0x290x20const(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_ostringstream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3Abasic_ostringstream0x5Babi0x3Ann2101050x5D0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Creplentry0x3E0x3A0x3Adestroy0x5Babi0x3Ann2101050x5D0x28replentry0x2A0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_HashMgr0x3A0x3Ais_aliasf0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_HashMgr0x3A0x3Ais_aliasm0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_HashMgr0x3A0x3Aget_reptable0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fsplit_buffer0x3Cstd0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cunsigned0x20char0x200x5B0x5D0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cunsigned0x20char0x200x5B0x5D0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cunsigned0x20char0x200x5B0x5D0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cunsigned0x20char0x200x5B0x5D0x3E0x3E0x3E0x260x3E0x3A0x3A_0x5Fsplit_buffer0x28unsigned0x20long0x2C0x20unsigned0x20long0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cunsigned0x20char0x200x5B0x5D0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cunsigned0x20char0x200x5B0x5D0x3E0x3E0x3E0x260x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fsplit_buffer0x3Cstd0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cunsigned0x20char0x200x5B0x5D0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cunsigned0x20char0x200x5B0x5D0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cunsigned0x20char0x200x5B0x5D0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cunsigned0x20char0x200x5B0x5D0x3E0x3E0x3E0x260x3E0x3A0x3A0x7E_0x5Fsplit_buffer0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cunsigned0x20char0x200x5B0x5D0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cunsigned0x20char0x200x5B0x5D0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cunsigned0x20char0x200x5B0x5D0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cunsigned0x20char0x200x5B0x5D0x3E0x3E0x3E0x3E0x3A0x3A_0x5Fthrow_length_error0x5Babi0x3Ann2101050x5D0x280x29(w2c_rlbox*);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cunsigned0x20char0x200x5B0x5D0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cunsigned0x20char0x200x5B0x5D0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cunsigned0x20char0x200x5B0x5D0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cunsigned0x20char0x200x5B0x5D0x3E0x3E0x3E0x3E0x3A0x3Aclear0x5Babi0x3Ann2101050x5D0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fsplit_buffer0x3Creplentry0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Creplentry0x3E0x260x3E0x3A0x3Aclear0x5Babi0x3Ann2101050x5D0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fsplit_buffer0x3Cstd0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cunsigned0x20char0x200x5B0x5D0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cunsigned0x20char0x200x5B0x5D0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cunsigned0x20char0x200x5B0x5D0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cunsigned0x20char0x200x5B0x5D0x3E0x3E0x3E0x260x3E0x3A0x3A_0x5Fdestruct_at_end0x5Babi0x3Ann2101050x5D0x28std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cunsigned0x20char0x200x5B0x5D0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cunsigned0x20char0x200x5B0x5D0x3E0x3E0x2A0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_HunspellImpl0x3A0x3AHunspellImpl0x28char0x20const0x2A0x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x29(w2c_rlbox*, u32, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Avector0x3CHashMgr0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3CHashMgr0x2A0x3E0x3E0x3A0x3Apush_back0x5Babi0x3Ann2101050x5D0x28HashMgr0x2A0x260x260x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x3E0x3A0x3A_0x5Fassign_with_size0x5Babi0x3Ann2101050x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2A0x3E0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2A0x2C0x20long0x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fsplit_buffer0x3CHashMgr0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3CHashMgr0x2A0x3E0x260x3E0x3A0x3A_0x5Fsplit_buffer0x28unsigned0x20long0x2C0x20unsigned0x20long0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3CHashMgr0x2A0x3E0x260x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fsplit_buffer0x3CHashMgr0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3CHashMgr0x2A0x3E0x260x3E0x3A0x3A0x7E_0x5Fsplit_buffer0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Avector0x3CHashMgr0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3CHashMgr0x2A0x3E0x3E0x3A0x3A_0x5Fthrow_length_error0x5Babi0x3Ann2101050x5D0x280x29(w2c_rlbox*);
static u32 w2c_rlbox_HunspellImpl0x3A0x3A0x7EHunspellImpl0x280x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_HunspellImpl0x3A0x3Aadd_dic0x28char0x20const0x2A0x2C0x20char0x20const0x2A0x29(w2c_rlbox*, u32, u32, u32);
static void w2c_rlbox_HunspellImpl0x3A0x3Aclean_ignore0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_HunspellImpl0x3A0x3Acleanword20x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Cw_char0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cw_char0x3E0x3E0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x2C0x20int0x2A0x2C0x20unsigned0x20long0x2A0x29(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static void w2c_rlbox_HunspellImpl0x3A0x3Acleanword0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x2C0x20int0x2A0x2C0x20int0x2A0x29(w2c_rlbox*, u32, u32, u32, u32, u32);
static void w2c_rlbox_HunspellImpl0x3A0x3Amkallcap0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_HunspellImpl0x3A0x3Amkallsmall20x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Cw_char0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cw_char0x3E0x3E0x260x29(w2c_rlbox*, u32, u32, u32);
static void w2c_rlbox_HunspellImpl0x3A0x3Asharps_u8_l10x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_HunspellImpl0x3A0x3Aspellsharps0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x260x2C0x20unsigned0x20long0x2C0x20int0x2C0x20int0x2C0x20int0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2A0x29(w2c_rlbox*, u32, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_HunspellImpl0x3A0x3Acheckword0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x2C0x20int0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2A0x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_bool0x20std0x3A0x3A_0x5F20x3A0x3Abinary_search0x5Babi0x3Ann2101050x5D0x3Cunsigned0x20short0x2A0x2C0x20unsigned0x20short0x3E0x28unsigned0x20short0x2A0x2C0x20unsigned0x20short0x2A0x2C0x20unsigned0x20short0x20const0x260x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_bool0x20std0x3A0x3A_0x5F20x3A0x3Abinary_search0x5Babi0x3Ann2101050x5D0x3Cunsigned0x20short0x2A0x2C0x20int0x3E0x28unsigned0x20short0x2A0x2C0x20unsigned0x20short0x2A0x2C0x20int0x20const0x260x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_HunspellImpl0x3A0x3Ais_keepcase0x28hentry0x20const0x2A0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_HunspellImpl0x3A0x3Ainsert_sug0x28std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x3E0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x3E0x3A0x3Ainsert0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x2A0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x29(w2c_rlbox*, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x3E0x3A0x3A_0x5Fmove_range0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2A0x29(w2c_rlbox*, u32, u32, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fsplit_buffer0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x260x3E0x3A0x3Aemplace_back0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x3E0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_HunspellImpl0x3A0x3Aspell0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x2C0x20int0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2A0x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_HunspellImpl0x3A0x3Aspell_internal0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x2C0x20int0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2A0x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_HunspellImpl0x3A0x3Amkinitcap20x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Cw_char0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cw_char0x3E0x3E0x260x29(w2c_rlbox*, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20std0x3A0x3A_0x5F20x3A0x3Aoperator0x2B0x5Babi0x3Ann2101050x5D0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x29(w2c_rlbox*, u32, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Cw_char0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cw_char0x3E0x3E0x3A0x3A_0x5Fassign_with_size0x5Babi0x3Ann2101050x5D0x3Cw_char0x2A0x2C0x20w_char0x2A0x3E0x28w_char0x2A0x2C0x20w_char0x2A0x2C0x20long0x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Cw_char0x2A0x3E0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Cw_char0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cw_char0x3E0x3E0x3A0x3A_0x5Finsert_with_size0x5Babi0x3Ann2101050x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Cw_char0x2A0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Cw_char0x2A0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Cw_char0x20const0x2A0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Cw_char0x2A0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Cw_char0x2A0x3E0x2C0x20long0x29(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_bool0x20std0x3A0x3A_0x5F20x3A0x3Aoperator0x3D0x3D0x5Babi0x3Ann2101050x5D0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x2C0x20char0x20const0x2A0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3Abasic_string0x5Babi0x3Ann2101050x5D0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Funinitialized_size_tag0x2C0x20unsigned0x20long0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x20const0x260x29(w2c_rlbox*, u32, u32, u32);
static void w2c_rlbox_HunspellImpl0x3A0x3Asuggest0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x29(w2c_rlbox*, u32, u32, u32);
static void w2c_rlbox_HunspellImpl0x3A0x3Asuggest_internal0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x2C0x20bool0x260x2C0x20unsigned0x20long0x260x2C0x20int0x260x29(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static void w2c_rlbox_HunspellImpl0x3A0x3Amkinitcap0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x260x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x3E0x3A0x3Aresize0x28unsigned0x20long0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_HunspellImpl0x3A0x3Aspellml0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_HunspellImpl0x3A0x3Amkinitsmall20x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Cw_char0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cw_char0x3E0x3E0x260x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_HunspellImpl0x3A0x3Aspell0x28char0x20const0x2A0x2C0x20int0x2A0x2C0x20char0x2A0x2A0x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x3E0x3A0x3Aerase0x5Babi0x3Ann2101050x5D0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x2A0x3E0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x3E0x3A0x3Ainsert0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x2A0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x260x260x29(w2c_rlbox*, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x3E0x3A0x3A_0x5Fappend0x28unsigned0x20long0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_HunspellImpl0x3A0x3Acheck_xml_par0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x2C0x20unsigned0x20long0x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x29(w2c_rlbox*, u32, u32, u32, u32, u32);
static void w2c_rlbox_HunspellImpl0x3A0x3Aget_xml_par0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x2C0x20unsigned0x20long0x29(w2c_rlbox*, u32, u32, u32, u32);
static void w2c_rlbox_HunspellImpl0x3A0x3Aanalyze0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x29(w2c_rlbox*, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x3E0x3A0x3A_0x5Fvdeallocate0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_HunspellImpl0x3A0x3Astem0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x29(w2c_rlbox*, u32, u32, u32);
static void w2c_rlbox_HunspellImpl0x3A0x3Agenerate0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x29(w2c_rlbox*, u32, u32, u32, u32);
static void w2c_rlbox_HunspellImpl0x3A0x3Aget_xml_list0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x2C0x20unsigned0x20long0x2C0x20char0x20const0x2A0x29(w2c_rlbox*, u32, u32, u32, u32, u32);
static void w2c_rlbox_HunspellImpl0x3A0x3Agenerate0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x3E0x20const0x260x29(w2c_rlbox*, u32, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Apair0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2A0x3E0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fmove_impl0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x3E0x3A0x3Aoperator0x280x290x5Babi0x3Ann2101050x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2A0x3E0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2A0x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fsplit_buffer0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x260x3E0x3A0x3Aemplace_back0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x260x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_HunspellImpl0x3A0x3Aget_dict_encoding0x280x290x20const(w2c_rlbox*, u32);
static void w2c_rlbox_HunspellImpl0x3A0x3Astem0x28std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x3E0x20const0x260x29(w2c_rlbox*, u32, u32, u32);
static void w2c_rlbox_HunspellImpl0x3A0x3Aanalyze_internal0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_HunspellImpl0x3A0x3Aget_wordchars_cpp0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_HunspellImpl0x3A0x3Aget_wordchars_utf160x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_HunspellImpl0x3A0x3Aadd0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_HunspellImpl0x3A0x3Aadd_with_affix0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_HunspellImpl0x3A0x3Aremove0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_HunspellImpl0x3A0x3Aget_version_cpp0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_HunspellImpl0x3A0x3Aget_csconv0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_HunspellImpl0x3A0x3Acat_result0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_HunspellImpl0x3A0x3Aget_langnum0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_HunspellImpl0x3A0x3Ainput_conv0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x260x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_HunspellImpl0x3A0x3Aget_xml_pos0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x2C0x20unsigned0x20long0x2C0x20char0x20const0x2A0x29(w2c_rlbox*, u32, u32, u32, u32);
static void w2c_rlbox_HunspellImpl0x3A0x3Asuffix_suggest0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_HunspellImpl0x3A0x3Asuggest0x28char0x2A0x2A0x2A0x2C0x20char0x20const0x2A0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Amunge_vector0x28char0x2A0x2A0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x3E0x20const0x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_HunspellImpl0x3A0x3Asuffix_suggest0x28char0x2A0x2A0x2A0x2C0x20char0x20const0x2A0x29(w2c_rlbox*, u32, u32, u32);
static void w2c_rlbox_HunspellImpl0x3A0x3Afree_list0x28char0x2A0x2A0x2A0x2C0x20int0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_HunspellImpl0x3A0x3Aget_dic_encoding0x280x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_HunspellImpl0x3A0x3Aanalyze0x28char0x2A0x2A0x2A0x2C0x20char0x20const0x2A0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_HunspellImpl0x3A0x3Astem0x28char0x2A0x2A0x2A0x2C0x20char0x20const0x2A0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_HunspellImpl0x3A0x3Astem0x28char0x2A0x2A0x2A0x2C0x20char0x2A0x2A0x2C0x20int0x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_HunspellImpl0x3A0x3Agenerate0x28char0x2A0x2A0x2A0x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_HunspellImpl0x3A0x3Agenerate0x28char0x2A0x2A0x2A0x2C0x20char0x20const0x2A0x2C0x20char0x2A0x2A0x2C0x20int0x29(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_HunspellImpl0x3A0x3Aget_wordchars0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_HunspellImpl0x3A0x3Aget_version0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_HunspellImpl0x3A0x3Ainput_conv0x28char0x20const0x2A0x2C0x20char0x2A0x2C0x20unsigned0x20long0x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_Hunspell0x3A0x3AHunspell0x28char0x20const0x2A0x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_Hunspell0x3A0x3A0x7EHunspell0x280x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_Hunspell0x3A0x3Aadd_dic0x28char0x20const0x2A0x2C0x20char0x20const0x2A0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_Hunspell0x3A0x3Aspell0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x2C0x20int0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2A0x29(w2c_rlbox*, u32, u32, u32, u32);
static void w2c_rlbox_Hunspell0x3A0x3Asuggest0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x29(w2c_rlbox*, u32, u32, u32);
static void w2c_rlbox_Hunspell0x3A0x3Asuffix_suggest0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_Hunspell0x3A0x3Aget_dict_encoding0x280x290x20const(w2c_rlbox*, u32);
static void w2c_rlbox_Hunspell0x3A0x3Astem0x28std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x3E0x20const0x260x29(w2c_rlbox*, u32, u32, u32);
static void w2c_rlbox_Hunspell0x3A0x3Astem0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_Hunspell0x3A0x3Aget_wordchars_cpp0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_Hunspell0x3A0x3Aget_wordchars_utf160x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_Hunspell0x3A0x3Aadd0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_Hunspell0x3A0x3Aadd_with_affix0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_Hunspell0x3A0x3Aremove0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_Hunspell0x3A0x3Aget_version_cpp0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_Hunspell0x3A0x3Aget_csconv0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_Hunspell0x3A0x3Aanalyze0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x29(w2c_rlbox*, u32, u32, u32);
static void w2c_rlbox_Hunspell0x3A0x3Agenerate0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x3E0x20const0x260x29(w2c_rlbox*, u32, u32, u32, u32);
static void w2c_rlbox_Hunspell0x3A0x3Agenerate0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_Hunspell0x3A0x3Aget_langnum0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_Hunspell0x3A0x3Ainput_conv0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x260x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_Hunspell0x3A0x3Aspell0x28char0x20const0x2A0x2C0x20int0x2A0x2C0x20char0x2A0x2A0x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_Hunspell0x3A0x3Asuggest0x28char0x2A0x2A0x2A0x2C0x20char0x20const0x2A0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_Hunspell0x3A0x3Asuffix_suggest0x28char0x2A0x2A0x2A0x2C0x20char0x20const0x2A0x29(w2c_rlbox*, u32, u32, u32);
static void w2c_rlbox_Hunspell0x3A0x3Afree_list0x28char0x2A0x2A0x2A0x2C0x20int0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_Hunspell0x3A0x3Aget_dic_encoding0x280x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_Hunspell0x3A0x3Aanalyze0x28char0x2A0x2A0x2A0x2C0x20char0x20const0x2A0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_Hunspell0x3A0x3Astem0x28char0x2A0x2A0x2A0x2C0x20char0x20const0x2A0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_Hunspell0x3A0x3Astem0x28char0x2A0x2A0x2A0x2C0x20char0x2A0x2A0x2C0x20int0x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_Hunspell0x3A0x3Agenerate0x28char0x2A0x2A0x2A0x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_Hunspell0x3A0x3Agenerate0x28char0x2A0x2A0x2A0x2C0x20char0x20const0x2A0x2C0x20char0x2A0x2A0x2C0x20int0x29(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_Hunspell0x3A0x3Aget_wordchars0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_Hunspell0x3A0x3Aget_version0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_Hunspell0x3A0x3Ainput_conv0x28char0x20const0x2A0x2C0x20char0x2A0x2C0x20unsigned0x20long0x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_Hunspell_create_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_Hunspell_create_key_0(w2c_rlbox*, u32, u32, u32);
static void w2c_rlbox_Hunspell_destroy_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_Hunspell_add_dic_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_Hunspell_spell_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_Hunspell_get_dic_encoding_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_Hunspell_suggest_0(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_Hunspell_analyze_0(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_Hunspell_stem_0(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_Hunspell_stem2_0(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_Hunspell_generate_0(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_Hunspell_generate2_0(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_Hunspell_add_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_Hunspell_add_with_affix_0(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_Hunspell_remove_0(w2c_rlbox*, u32, u32);
static void w2c_rlbox_Hunspell_free_list_0(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2A0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Funinitialized_allocator_copy0x5Babi0x3Ann2101050x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2A0x3E0x28std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2A0x29(w2c_rlbox*, u32, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x3E0x3A0x3A_0x5Fvallocate0x5Babi0x3Ann2101050x5D0x28unsigned0x20long0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Apair0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2A0x3E0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fmove_backward_impl0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x3E0x3A0x3Aoperator0x280x290x5Babi0x3Ann2101050x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2A0x3E0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2A0x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Avector0x3Cw_char0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cw_char0x3E0x3E0x3A0x3A_0x5Fvdeallocate0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Avector0x3Cw_char0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cw_char0x3E0x3E0x3A0x3A_0x5Fvallocate0x5Babi0x3Ann2101050x5D0x28unsigned0x20long0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_init_phonet_hash0x28phonetable0x260x29(w2c_rlbox*, u32);
static void w2c_rlbox_phonet0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x2C0x20phonetable0x260x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_RepList0x3A0x3ARepList0x28int0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_RepList0x3A0x3A0x7ERepList0x280x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_RepList0x3A0x3Aitem0x28int0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_RepList0x3A0x3Afind0x28char0x20const0x2A0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_RepList0x3A0x3Areplace0x28char0x20const0x2A0x2C0x20int0x2C0x20bool0x29(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_RepList0x3A0x3Aadd0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_RepList0x3A0x3Aconv0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x260x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_SuggestMgr0x3A0x3ASuggestMgr0x28char0x20const0x2A0x2C0x20unsigned0x20int0x2C0x20AffixMgr0x2A0x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_SuggestMgr0x3A0x3A0x7ESuggestMgr0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_SuggestMgr0x3A0x3Atestsug0x28std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x3E0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x2C0x20int0x2C0x20int0x2A0x2C0x20long0x20long0x2A0x29(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_SuggestMgr0x3A0x3Acheckword0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x2C0x20int0x2C0x20int0x2A0x2C0x20long0x20long0x2A0x29(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_SuggestMgr0x3A0x3Asuggest0x28std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x3E0x260x2C0x20char0x20const0x2A0x2C0x20int0x2A0x29(w2c_rlbox*, u32, u32, u32, u32);
static void w2c_rlbox_SuggestMgr0x3A0x3Acapchars_utf0x28std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x3E0x260x2C0x20w_char0x20const0x2A0x2C0x20int0x2C0x20int0x29(w2c_rlbox*, u32, u32, u32, u32, u32);
static void w2c_rlbox_SuggestMgr0x3A0x3Acapchars0x28std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x3E0x260x2C0x20char0x20const0x2A0x2C0x20int0x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_SuggestMgr0x3A0x3Areplchars0x28std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x3E0x260x2C0x20char0x20const0x2A0x2C0x20int0x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_SuggestMgr0x3A0x3Amapchars0x28std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x3E0x260x2C0x20char0x20const0x2A0x2C0x20int0x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_SuggestMgr0x3A0x3Aswapchar_utf0x28std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x3E0x260x2C0x20w_char0x20const0x2A0x2C0x20int0x2C0x20int0x29(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_SuggestMgr0x3A0x3Aswapchar0x28std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x3E0x260x2C0x20char0x20const0x2A0x2C0x20int0x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_SuggestMgr0x3A0x3Alongswapchar_utf0x28std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x3E0x260x2C0x20w_char0x20const0x2A0x2C0x20int0x2C0x20int0x29(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_SuggestMgr0x3A0x3Alongswapchar0x28std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x3E0x260x2C0x20char0x20const0x2A0x2C0x20int0x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_SuggestMgr0x3A0x3Abadcharkey_utf0x28std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x3E0x260x2C0x20w_char0x20const0x2A0x2C0x20int0x2C0x20int0x29(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_SuggestMgr0x3A0x3Abadcharkey0x28std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x3E0x260x2C0x20char0x20const0x2A0x2C0x20int0x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_SuggestMgr0x3A0x3Aextrachar_utf0x28std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x3E0x260x2C0x20w_char0x20const0x2A0x2C0x20int0x2C0x20int0x29(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_SuggestMgr0x3A0x3Aextrachar0x28std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x3E0x260x2C0x20char0x20const0x2A0x2C0x20int0x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_SuggestMgr0x3A0x3Aforgotchar_utf0x28std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x3E0x260x2C0x20w_char0x20const0x2A0x2C0x20int0x2C0x20int0x29(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_SuggestMgr0x3A0x3Aforgotchar0x28std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x3E0x260x2C0x20char0x20const0x2A0x2C0x20int0x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_SuggestMgr0x3A0x3Amovechar_utf0x28std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x3E0x260x2C0x20w_char0x20const0x2A0x2C0x20int0x2C0x20int0x29(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_SuggestMgr0x3A0x3Amovechar0x28std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x3E0x260x2C0x20char0x20const0x2A0x2C0x20int0x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_SuggestMgr0x3A0x3Abadchar_utf0x28std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x3E0x260x2C0x20w_char0x20const0x2A0x2C0x20int0x2C0x20int0x29(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_SuggestMgr0x3A0x3Abadchar0x28std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x3E0x260x2C0x20char0x20const0x2A0x2C0x20int0x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_SuggestMgr0x3A0x3Adoubletwochars_utf0x28std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x3E0x260x2C0x20w_char0x20const0x2A0x2C0x20int0x2C0x20int0x29(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_SuggestMgr0x3A0x3Adoubletwochars0x28std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x3E0x260x2C0x20char0x20const0x2A0x2C0x20int0x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_SuggestMgr0x3A0x3Atwowords0x28std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x3E0x260x2C0x20char0x20const0x2A0x2C0x20int0x2C0x20bool0x29(w2c_rlbox*, u32, u32, u32, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Cw_char0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cw_char0x3E0x3E0x3A0x3A_0x5Finit_with_size0x5Babi0x3Ann2101050x5D0x3Cw_char0x20const0x2A0x2C0x20w_char0x20const0x2A0x3E0x28w_char0x20const0x2A0x2C0x20w_char0x20const0x2A0x2C0x20unsigned0x20long0x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_SuggestMgr0x3A0x3Amap_related0x28char0x20const0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x260x2C0x20int0x2C0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x3E0x260x2C0x20int0x2C0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x3E0x3E0x3E0x20const0x260x2C0x20int0x2A0x2C0x20long0x20long0x2A0x29(w2c_rlbox*, u32, u32, u32, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Avector0x3Cw_char0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cw_char0x3E0x3E0x3A0x3Ainsert0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Cw_char0x20const0x2A0x3E0x2C0x20w_char0x20const0x260x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Cw_char0x2A0x3E0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Cw_char0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cw_char0x3E0x3E0x3A0x3A_0x5Finsert_with_size0x5Babi0x3Ann2101050x5D0x3Cw_char0x20const0x2A0x2C0x20w_char0x20const0x2A0x3E0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Cw_char0x20const0x2A0x3E0x2C0x20w_char0x20const0x2A0x2C0x20w_char0x20const0x2A0x2C0x20long0x29(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Cchar0x2A0x3E0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A_0x5Finsert_with_size0x3Cchar0x20const0x2A0x2C0x20char0x20const0x2A0x3E0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Cchar0x20const0x2A0x3E0x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x2C0x20unsigned0x20long0x29(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_SuggestMgr0x3A0x3Acheck_forbidden0x28char0x20const0x2A0x2C0x20int0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_SuggestMgr0x3A0x3Amystrlen0x28char0x20const0x2A0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fsplit_buffer0x3Cw_char0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cw_char0x3E0x260x3E0x3A0x3Aemplace_back0x3Cw_char0x20const0x260x3E0x28w_char0x20const0x260x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_SuggestMgr0x3A0x3Angsuggest0x28std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x3E0x260x2C0x20char0x20const0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3CHashMgr0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3CHashMgr0x2A0x3E0x3E0x20const0x260x2C0x20int0x29(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_SuggestMgr0x3A0x3Aleftcommonsubstring0x28std0x3A0x3A_0x5F20x3A0x3Avector0x3Cw_char0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cw_char0x3E0x3E0x20const0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Cw_char0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cw_char0x3E0x3E0x20const0x260x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_SuggestMgr0x3A0x3Angram0x28int0x2C0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Cw_char0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cw_char0x3E0x3E0x20const0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Cw_char0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cw_char0x3E0x3E0x20const0x260x2C0x20int0x29(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_SuggestMgr0x3A0x3Aleftcommonsubstring0x28char0x20const0x2A0x2C0x20char0x20const0x2A0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_SuggestMgr0x3A0x3Angram0x28int0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x2C0x20int0x29(w2c_rlbox*, u32, u32, u32, u32, u32);
static void w2c_rlbox_SuggestMgr0x3A0x3Abubblesort0x28char0x2A0x2A0x2C0x20char0x2A0x2A0x2C0x20int0x2A0x2C0x20int0x29(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_SuggestMgr0x3A0x3Alcslen0x28char0x20const0x2A0x2C0x20char0x20const0x2A0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_SuggestMgr0x3A0x3Acommoncharacterpositions0x28char0x20const0x2A0x2C0x20char0x20const0x2A0x2C0x20int0x2A0x29(w2c_rlbox*, u32, u32, u32, u32);
static void w2c_rlbox_SuggestMgr0x3A0x3Alcs0x28char0x20const0x2A0x2C0x20char0x20const0x2A0x2C0x20int0x2A0x2C0x20int0x2A0x2C0x20char0x2A0x2A0x29(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_SuggestMgr0x3A0x3Alcslen0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x29(w2c_rlbox*, u32, u32, u32);
static void w2c_rlbox_SuggestMgr0x3A0x3Asuggest_morph0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x29(w2c_rlbox*, u32, u32, u32);
static void w2c_rlbox_SuggestMgr0x3A0x3Asuggest_hentry_gen0x28hentry0x2A0x2C0x20char0x20const0x2A0x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_get_sfxcount0x28char0x20const0x2A0x29(w2c_rlbox*, u32);
static void w2c_rlbox_SuggestMgr0x3A0x3Asuggest_gen0x28std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x3E0x20const0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Cchar0x2A0x3E0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A_0x5Finsert_from_safe_copy0x5Babi0x3Ann2101050x5D0x3Cchar0x20const0x2A0x2C0x20char0x20const0x2A0x3E0x28unsigned0x20long0x2C0x20unsigned0x20long0x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x29(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Cchar0x2A0x3E0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A_0x5Finsert_from_safe_copy0x5Babi0x3Ann2101050x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Cchar0x20const0x2A0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Cchar0x20const0x2A0x3E0x3E0x28unsigned0x20long0x2C0x20unsigned0x20long0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Cchar0x20const0x2A0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Cchar0x20const0x2A0x3E0x29(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_gr_get_glyph_to_char_association_0(w2c_rlbox*, u32, u32, u32);
static void w2c_rlbox_gr_free_char_association_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_bmp_subtable0x28graphite20x3A0x3AFace0x3A0x3ATable0x20const0x260x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_smp_subtable0x28graphite20x3A0x3AFace0x3A0x3ATable0x20const0x260x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_graphite20x3A0x3ACachedCmap0x3A0x3ACachedCmap0x28graphite20x3A0x3AFace0x20const0x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_bool0x20cache_subtable0x3C0x26graphite20x3A0x3ATtfUtil0x3A0x3ACmapSubtable12NextCodepoint0x28void0x20const0x2A0x2C0x20unsigned0x20int0x2C0x20int0x2A0x290x2C0x200x26graphite20x3A0x3ATtfUtil0x3A0x3ACmapSubtable12Lookup0x28void0x20const0x2A0x2C0x20unsigned0x20int0x2C0x20int0x290x3E0x28unsigned0x20short0x2A0x2A0x2C0x20void0x20const0x2A0x2C0x20unsigned0x20int0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_bool0x20cache_subtable0x3C0x26graphite20x3A0x3ATtfUtil0x3A0x3ACmapSubtable4NextCodepoint0x28void0x20const0x2A0x2C0x20unsigned0x20int0x2C0x20int0x2A0x290x2C0x200x26graphite20x3A0x3ATtfUtil0x3A0x3ACmapSubtable4Lookup0x28void0x20const0x2A0x2C0x20unsigned0x20int0x2C0x20int0x290x3E0x28unsigned0x20short0x2A0x2A0x2C0x20void0x20const0x2A0x2C0x20unsigned0x20int0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_graphite20x3A0x3ACachedCmap0x3A0x3A0x7ECachedCmap0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_graphite20x3A0x3ACachedCmap0x3A0x3A0x7ECachedCmap0x280x290x2E1(w2c_rlbox*, u32);
static u32 w2c_rlbox_graphite20x3A0x3ACachedCmap0x3A0x3Aoperator0x5B0x5D0x28unsigned0x20int0x290x20const(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_graphite20x3A0x3ACachedCmap0x3A0x3Aoperator0x20bool0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_graphite20x3A0x3ADirectCmap0x3A0x3ADirectCmap0x28graphite20x3A0x3AFace0x20const0x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_graphite20x3A0x3ADirectCmap0x3A0x3Aoperator0x5B0x5D0x28unsigned0x20int0x290x20const(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_graphite20x3A0x3ADirectCmap0x3A0x3Aoperator0x20bool0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_graphite20x3A0x3ADirectCmap0x3A0x3A0x7EDirectCmap0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_graphite20x3A0x3ADirectCmap0x3A0x3A0x7EDirectCmap0x280x290x2E1(w2c_rlbox*, u32);
static u32 w2c_rlbox_graphite20x3A0x3Avm0x3A0x3AMachine0x3A0x3ACode0x3A0x3ACode0x28bool0x2C0x20unsigned0x20char0x20const0x2A0x2C0x20unsigned0x20char0x20const0x2A0x2C0x20unsigned0x20char0x2C0x20unsigned0x20short0x2C0x20graphite20x3A0x3ASilf0x20const0x260x2C0x20graphite20x3A0x3AFace0x20const0x260x2C0x20graphite20x3A0x3Apasstype0x2C0x20unsigned0x20char0x2A0x2A0x29(w2c_rlbox*, u32, u32, u32, u32, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_graphite20x3A0x3Avm0x3A0x3AMachine0x3A0x3ACode0x3A0x3Adecoder0x3A0x3Aload0x28unsigned0x20char0x20const0x2A0x2C0x20unsigned0x20char0x20const0x2A0x29(w2c_rlbox*, u32, u32, u32);
static void w2c_rlbox_graphite20x3A0x3Avm0x3A0x3AMachine0x3A0x3ACode0x3A0x3Adecoder0x3A0x3Aapply_analysis0x28void0x2A0x2A0x2C0x20void0x2A0x2A0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_graphite20x3A0x3Avm0x3A0x3AMachine0x3A0x3ACode0x3A0x3Adecoder0x3A0x3Afetch_opcode0x28unsigned0x20char0x20const0x2A0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_graphite20x3A0x3Avm0x3A0x3AMachine0x3A0x3ACode0x3A0x3Adecoder0x3A0x3Aanalyse_opcode0x28graphite20x3A0x3Avm0x3A0x3Aopcode0x2C0x20signed0x20char0x20const0x2A0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_graphite20x3A0x3Avm0x3A0x3AMachine0x3A0x3ACode0x3A0x3Adecoder0x3A0x3Aemit_opcode0x28graphite20x3A0x3Avm0x3A0x3Aopcode0x2C0x20unsigned0x20char0x20const0x2A0x260x29(w2c_rlbox*, u32, u32, u32);
static void w2c_rlbox_graphite20x3A0x3Avm0x3A0x3AMachine0x3A0x3ACode0x3A0x3Arelease_buffers0x280x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_graphite20x3A0x3Avm0x3A0x3AMachine0x3A0x3ACode0x3A0x3A0x7ECode0x280x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_graphite20x3A0x3Avm0x3A0x3AMachine0x3A0x3ACode0x3A0x3Adecoder0x3A0x3Avalidate_opcode0x28unsigned0x20char0x2C0x20unsigned0x20char0x20const0x2A0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_graphite20x3A0x3Avm0x3A0x3AMachine0x3A0x3ACode0x3A0x3Adecoder0x3A0x3Atest_context0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_graphite20x3A0x3Avm0x3A0x3AMachine0x3A0x3ACode0x3A0x3Adecoder0x3A0x3Atest_ref0x28signed0x20char0x290x20const(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_graphite20x3A0x3Avm0x3A0x3AMachine0x3A0x3ACode0x3A0x3Adecoder0x3A0x3Avalid_upto0x28unsigned0x20short0x2C0x20unsigned0x20short0x290x20const(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_graphite20x3A0x3Avm0x3A0x3AMachine0x3A0x3ACode0x3A0x3Adecoder0x3A0x3Atest_attr0x28gr_attrCode0x290x20const(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_graphite20x3A0x3Avm0x3A0x3AMachine0x3A0x3ACode0x3A0x3Arun0x28graphite20x3A0x3Avm0x3A0x3AMachine0x260x2C0x20graphite20x3A0x3ASlot0x2A0x2A0x260x290x20const(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_graphite20x3A0x3AShiftCollider0x3A0x3AinitSlot0x28graphite20x3A0x3ASegment0x2A0x2C0x20graphite20x3A0x3ASlot0x2A0x2C0x20graphite20x3A0x3ARect0x20const0x260x2C0x20float0x2C0x20float0x2C0x20graphite20x3A0x3APosition0x20const0x260x2C0x20graphite20x3A0x3APosition0x20const0x260x2C0x20int0x2C0x20graphite20x3A0x3Ajson0x2A0x29(w2c_rlbox*, u32, u32, u32, u32, f32, f32, u32, u32, u32, u32);
static void w2c_rlbox_graphite20x3A0x3AVector0x3Cgraphite20x3A0x3AZones0x3A0x3AExclusion0x3E0x3A0x3Apush_back0x28graphite20x3A0x3AZones0x3A0x3AExclusion0x20const0x260x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_graphite20x3A0x3AShiftCollider0x3A0x3AaddBox_slope0x28bool0x2C0x20graphite20x3A0x3ARect0x20const0x260x2C0x20graphite20x3A0x3ABBox0x20const0x260x2C0x20graphite20x3A0x3ASlantBox0x20const0x260x2C0x20graphite20x3A0x3APosition0x20const0x260x2C0x20float0x2C0x20float0x2C0x20bool0x2C0x20int0x29(w2c_rlbox*, u32, u32, u32, u32, u32, u32, f32, f32, u32, u32);
static u32 w2c_rlbox_graphite20x3A0x3AShiftCollider0x3A0x3AmergeSlot0x28graphite20x3A0x3ASegment0x2A0x2C0x20graphite20x3A0x3ASlot0x2A0x2C0x20graphite20x3A0x3ASlotCollision0x20const0x2A0x2C0x20graphite20x3A0x3APosition0x20const0x260x2C0x20bool0x2C0x20bool0x2C0x20bool0x260x2C0x20bool0x2C0x20graphite20x3A0x3Ajson0x2A0x29(w2c_rlbox*, u32, u32, u32, u32, u32, u32, u32, u32, u32, u32);
static void w2c_rlbox_graphite20x3A0x3AShiftCollider0x3A0x3AremoveBox0x28graphite20x3A0x3ARect0x20const0x260x2C0x20graphite20x3A0x3ABBox0x20const0x260x2C0x20graphite20x3A0x3ASlantBox0x20const0x260x2C0x20graphite20x3A0x3APosition0x20const0x260x2C0x20int0x29(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static void w2c_rlbox_graphite20x3A0x3ASlotCollision0x3A0x3AinitFromSlot0x28graphite20x3A0x3ASegment0x2A0x2C0x20graphite20x3A0x3ASlot0x2A0x29(w2c_rlbox*, u32, u32, u32);
static void w2c_rlbox_graphite20x3A0x3AShiftCollider0x3A0x3Aresolve0x28graphite20x3A0x3ASegment0x2A0x2C0x20bool0x260x2C0x20graphite20x3A0x3Ajson0x2A0x29(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_graphite20x3A0x3AKernCollider0x3A0x3AinitSlot0x28graphite20x3A0x3ASegment0x2A0x2C0x20graphite20x3A0x3ASlot0x2A0x2C0x20graphite20x3A0x3ARect0x20const0x260x2C0x20float0x2C0x20graphite20x3A0x3APosition0x20const0x260x2C0x20graphite20x3A0x3APosition0x20const0x260x2C0x20int0x2C0x20float0x2C0x20float0x2C0x20graphite20x3A0x3Ajson0x2A0x29(w2c_rlbox*, u32, u32, u32, u32, f32, u32, u32, u32, f32, f32, u32);
static f32 w2c_rlbox_get_edge0x28graphite20x3A0x3ASegment0x2A0x2C0x20graphite20x3A0x3ASlot0x20const0x2A0x2C0x20graphite20x3A0x3APosition0x20const0x260x2C0x20float0x2C0x20float0x2C0x20float0x2C0x20bool0x29(w2c_rlbox*, u32, u32, u32, f32, f32, f32, u32);
static u32 w2c_rlbox_graphite20x3A0x3AKernCollider0x3A0x3AmergeSlot0x28graphite20x3A0x3ASegment0x2A0x2C0x20graphite20x3A0x3ASlot0x2A0x2C0x20graphite20x3A0x3APosition0x20const0x260x2C0x20float0x2C0x20int0x2C0x20graphite20x3A0x3Ajson0x2A0x29(w2c_rlbox*, u32, u32, u32, u32, f32, u32, u32);
static void w2c_rlbox_graphite20x3A0x3AKernCollider0x3A0x3Aresolve0x28graphite20x3A0x3ASegment0x2A0x2C0x20graphite20x3A0x3ASlot0x2A0x2C0x20int0x2C0x20graphite20x3A0x3Ajson0x2A0x29(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static void w2c_rlbox_graphite20x3A0x3AKernCollider0x3A0x3Ashift0x28graphite20x3A0x3APosition0x20const0x260x2C0x20int0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_graphite20x3A0x3ASlotCollision0x3A0x3ASlotCollision0x28graphite20x3A0x3ASegment0x2A0x2C0x20graphite20x3A0x3ASlot0x2A0x29(w2c_rlbox*, u32, u32, u32);
static f32 w2c_rlbox_graphite20x3A0x3ASlotCollision0x3A0x3AgetKern0x28int0x290x20const(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_graphite20x3A0x3ASlotCollision0x3A0x3Aignore0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_lz40x3A0x3Adecompress0x28void0x20const0x2A0x2C0x20unsigned0x20long0x2C0x20void0x2A0x2C0x20unsigned0x20long0x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_graphite20x3A0x3AFace0x3A0x3AFace0x28void0x20const0x2A0x2C0x20gr_face_ops0x20const0x260x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_graphite20x3A0x3AFace0x3A0x3A0x7EFace0x280x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_graphite20x3A0x3ANameTable0x3A0x3A0x7ENameTable0x280x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_graphite20x3A0x3ASillMap0x3A0x3A0x7ESillMap0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_graphite20x3A0x3AFace0x3A0x3AsetLogger0x28_IO_FILE0x2A0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_graphite20x3A0x3ASillMap0x3A0x3ALangFeaturePair0x3A0x3A0x7ELangFeaturePair0x280x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_graphite20x3A0x3AFeatureMap0x3A0x3A0x7EFeatureMap0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_graphite20x3A0x3AFace0x3A0x3A0x7EFace0x280x290x2E1(w2c_rlbox*, u32);
static f32 w2c_rlbox_graphite20x3A0x3AFace0x3A0x3Adefault_glyph_advance0x28void0x20const0x2A0x2C0x20unsigned0x20short0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_graphite20x3A0x3AFace0x3A0x3AreadGlyphs0x28unsigned0x20int0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_graphite20x3A0x3AFace0x3A0x3AnameTable0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_graphite20x3A0x3AFace0x3A0x3ATable0x3A0x3ATable0x28graphite20x3A0x3AFace0x20const0x260x2C0x20graphite20x3A0x3ATtfUtil0x3A0x3ATag0x2C0x20unsigned0x20int0x29(w2c_rlbox*, u32, u32, u32, u32);
static void w2c_rlbox_graphite20x3A0x3AFace0x3A0x3ATable0x3A0x3Arelease0x280x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_graphite20x3A0x3AFace0x3A0x3AreadGraphite0x28graphite20x3A0x3AFace0x3A0x3ATable0x20const0x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_graphite20x3A0x3AFace0x3A0x3AreadFeatures0x280x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_graphite20x3A0x3AFace0x3A0x3ArunGraphite0x28graphite20x3A0x3ASegment0x2A0x2C0x20graphite20x3A0x3ASilf0x20const0x2A0x290x20const(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_graphite20x3A0x3AFace0x3A0x3AchooseSilf0x28unsigned0x20int0x290x20const(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_graphite20x3A0x3AFace0x3A0x3AfindPseudo0x28unsigned0x20int0x290x20const(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_graphite20x3A0x3AFace0x3A0x3AgetGlyphMetric0x28unsigned0x20short0x2C0x20unsigned0x20char0x290x20const(w2c_rlbox*, u32, u32, u32);
static void w2c_rlbox_graphite20x3A0x3AFace0x3A0x3AtakeFileFace0x28graphite20x3A0x3AFileFace0x2A0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_graphite20x3A0x3AFace0x3A0x3AlanguageForLocale0x28char0x20const0x2A0x290x20const(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_graphite20x3A0x3AFace0x3A0x3ATable0x3A0x3Adecompress0x280x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_graphite20x3A0x3AFace0x3A0x3ATable0x3A0x3Aoperator0x3D0x28graphite20x3A0x3AFace0x3A0x3ATable0x20const0x260x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_graphite20x3A0x3AFeatureRef0x3A0x3AFeatureRef0x28graphite20x3A0x3AFace0x20const0x260x2C0x20unsigned0x20short0x260x2C0x20unsigned0x20int0x2C0x20unsigned0x20int0x2C0x20unsigned0x20short0x2C0x20graphite20x3A0x3AFeatureRef0x3A0x3Aflags_t0x2C0x20graphite20x3A0x3AFeatureSetting0x2A0x2C0x20unsigned0x20short0x29(w2c_rlbox*, u32, u32, u32, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_graphite20x3A0x3AFeatureRef0x3A0x3A0x7EFeatureRef0x280x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_graphite20x3A0x3AFeatureMap0x3A0x3AreadFeats0x28graphite20x3A0x3AFace0x20const0x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_graphite20x3A0x3AVector0x3Cunsigned0x20int0x3E0x3A0x3AVector0x28unsigned0x20long0x2C0x20unsigned0x20int0x20const0x260x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_graphite20x3A0x3AFeatureRef0x3A0x3AapplyValToFeature0x28unsigned0x20int0x2C0x20graphite20x3A0x3AFeatureVal0x260x290x20const(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3AcmpNameAndFeatures0x28void0x20const0x2A0x2C0x20void0x20const0x2A0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_graphite20x3A0x3ASillMap0x3A0x3AreadFace0x28graphite20x3A0x3AFace0x20const0x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_graphite20x3A0x3ASillMap0x3A0x3AreadSill0x28graphite20x3A0x3AFace0x20const0x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_graphite20x3A0x3AVector0x3Cunsigned0x20int0x3E0x3A0x3AVector0x28graphite20x3A0x3AVector0x3Cunsigned0x20int0x3E0x20const0x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_graphite20x3A0x3AFeatureMap0x3A0x3AfindFeatureRef0x28unsigned0x20int0x290x20const(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_graphite20x3A0x3ASillMap0x3A0x3AcloneFeatures0x28unsigned0x20int0x290x20const(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_graphite20x3A0x3AFeatureRef0x3A0x3AgetFeatureVal0x28graphite20x3A0x3AFeatureVal0x20const0x260x290x20const(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_graphite20x3A0x3AFont0x3A0x3AFont0x28float0x2C0x20graphite20x3A0x3AFace0x20const0x260x2C0x20void0x20const0x2A0x2C0x20gr_font_ops0x20const0x2A0x29(w2c_rlbox*, u32, f32, u32, u32, u32);
static u32 w2c_rlbox_graphite20x3A0x3AFont0x3A0x3A0x7EFont0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_graphite20x3A0x3AFont0x3A0x3A0x7EFont0x280x290x2E1(w2c_rlbox*, u32);
static u32 w2c_rlbox_graphite20x3A0x3AGlyphCache0x3A0x3AGlyphCache0x28graphite20x3A0x3AFace0x20const0x260x2C0x20unsigned0x20int0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_graphite20x3A0x3AGlyphCache0x3A0x3ALoader0x3A0x3ALoader0x28graphite20x3A0x3AFace0x20const0x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_graphite20x3A0x3AGlyphCache0x3A0x3ALoader0x3A0x3Aread_glyph0x28unsigned0x20short0x2C0x20graphite20x3A0x3AGlyphFace0x260x2C0x20int0x2A0x290x20const(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_graphite20x3A0x3AGlyphCache0x3A0x3ALoader0x3A0x3Aread_box0x28unsigned0x20short0x2C0x20graphite20x3A0x3AGlyphBox0x2A0x2C0x20graphite20x3A0x3AGlyphFace0x20const0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_graphite20x3A0x3AGlyphCache0x3A0x3Aglyph0x28unsigned0x20short0x290x20const(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_graphite20x3A0x3AGlyphFace0x3A0x3AGlyphFace0x3C0x28anonymous0x20namespace0x290x3A0x3A_glat_iterator0x3Cunsigned0x20char0x3E0x3E0x28graphite20x3A0x3ARect0x20const0x260x2C0x20graphite20x3A0x3APosition0x20const0x260x2C0x200x28anonymous0x20namespace0x290x3A0x3A_glat_iterator0x3Cunsigned0x20char0x3E0x2C0x200x28anonymous0x20namespace0x290x3A0x3A_glat_iterator0x3Cunsigned0x20char0x3E0x29(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_graphite20x3A0x3AGlyphFace0x3A0x3AGlyphFace0x3C0x28anonymous0x20namespace0x290x3A0x3A_glat_iterator0x3Cunsigned0x20short0x3E0x3E0x28graphite20x3A0x3ARect0x20const0x260x2C0x20graphite20x3A0x3APosition0x20const0x260x2C0x200x28anonymous0x20namespace0x290x3A0x3A_glat_iterator0x3Cunsigned0x20short0x3E0x2C0x200x28anonymous0x20namespace0x290x3A0x3A_glat_iterator0x3Cunsigned0x20short0x3E0x29(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_graphite20x3A0x3AGlyphCache0x3A0x3A0x7EGlyphCache0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_readbox0x28graphite20x3A0x3ARect0x260x2C0x20unsigned0x20char0x2C0x20unsigned0x20char0x2C0x20unsigned0x20char0x2C0x20unsigned0x20char0x29(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_graphite20x3A0x3AGlyphFace0x3A0x3AgetMetric0x28unsigned0x20char0x290x20const(w2c_rlbox*, u32, u32);
static void w2c_rlbox_graphite20x3A0x3AZones0x3A0x3Aexclude_with_margins0x28float0x2C0x20float0x2C0x20int0x29(w2c_rlbox*, u32, f32, f32, u32);
static void w2c_rlbox_graphite20x3A0x3AZones0x3A0x3Aremove0x28float0x2C0x20float0x29(w2c_rlbox*, u32, f32, f32);
static void w2c_rlbox_graphite20x3A0x3AZones0x3A0x3Ainsert0x28graphite20x3A0x3AZones0x3A0x3AExclusion0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_graphite20x3A0x3AVector0x3Cgraphite20x3A0x3AZones0x3A0x3AExclusion0x3E0x3A0x3Ainsert0x28graphite20x3A0x3AZones0x3A0x3AExclusion0x2A0x2C0x20graphite20x3A0x3AZones0x3A0x3AExclusion0x20const0x260x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_graphite20x3A0x3AZones0x3A0x3Afind_exclusion_under0x28float0x290x20const(w2c_rlbox*, u32, f32);
static f32 w2c_rlbox_graphite20x3A0x3AZones0x3A0x3Aclosest0x28float0x2C0x20float0x260x290x20const(w2c_rlbox*, u32, f32, u32);
static u32 w2c_rlbox_graphite20x3A0x3AZones0x3A0x3AExclusion0x3A0x3Atrack_cost0x28float0x260x2C0x20float0x260x2C0x20float0x290x20const(w2c_rlbox*, u32, u32, u32, f32);
static f32 w2c_rlbox_graphite20x3A0x3AZones0x3A0x3AExclusion0x3A0x3Atest_position0x28float0x290x20const(w2c_rlbox*, u32, f32);
static void w2c_rlbox_JustifyTotal0x3A0x3Aaccumulate0x28graphite20x3A0x3ASlot0x2A0x2C0x20graphite20x3A0x3ASegment0x2A0x2C0x20int0x29(w2c_rlbox*, u32, u32, u32, u32);
static f32 w2c_rlbox_graphite20x3A0x3ASegment0x3A0x3Ajustify0x28graphite20x3A0x3ASlot0x2A0x2C0x20graphite20x3A0x3AFont0x20const0x2A0x2C0x20float0x2C0x20graphite20x3A0x3AjustFlags0x2C0x20graphite20x3A0x3ASlot0x2A0x2C0x20graphite20x3A0x3ASlot0x2A0x29(w2c_rlbox*, u32, u32, u32, f32, u32, u32, u32);
static u32 w2c_rlbox_graphite20x3A0x3AVector0x3CJustifyTotal0x3E0x3A0x3AVector0x28unsigned0x20long0x2C0x20JustifyTotal0x20const0x260x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_graphite20x3A0x3ASegment0x3A0x3AaddLineEnd0x28graphite20x3A0x3ASlot0x2A0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_graphite20x3A0x3ASegment0x3A0x3AdelLineEnd0x28graphite20x3A0x3ASlot0x2A0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_graphite20x3A0x3ANameTable0x3A0x3ANameTable0x28void0x20const0x2A0x2C0x20unsigned0x20long0x2C0x20unsigned0x20short0x2C0x20unsigned0x20short0x29(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_graphite20x3A0x3ALocale2Lang0x3A0x3ALocale2Lang0x280x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_graphite20x3A0x3ANameTable0x3A0x3AsetPlatformEncoding0x28unsigned0x20short0x2C0x20unsigned0x20short0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_graphite20x3A0x3ANameTable0x3A0x3AgetName0x28unsigned0x20short0x260x2C0x20unsigned0x20short0x2C0x20gr_encform0x2C0x20unsigned0x20int0x260x29(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_graphite20x3A0x3A_utf_iterator0x3Cunsigned0x20short0x20const0x3E0x3A0x3Areference0x3A0x3Aoperator0x20unsigned0x20int0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_graphite20x3A0x3A_utf_iterator0x3Cunsigned0x20char0x3E0x3A0x3Areference0x3A0x3Aoperator0x3D0x28unsigned0x20int0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_graphite20x3A0x3ANameTable0x3A0x3AgetLanguageId0x28char0x20const0x2A0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_graphite20x3A0x3ALocale2Lang0x3A0x3AgetMsId0x28char0x20const0x2A0x290x20const(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_graphite20x3A0x3APass0x3A0x3APass0x280x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_graphite20x3A0x3APass0x3A0x3A0x7EPass0x280x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_graphite20x3A0x3APass0x3A0x3AreadPass0x28unsigned0x20char0x20const0x2A0x2C0x20unsigned0x20long0x2C0x20unsigned0x20long0x2C0x20graphite20x3A0x3AFace0x260x2C0x20graphite20x3A0x3Apasstype0x2C0x20unsigned0x20int0x2C0x20graphite20x3A0x3AError0x260x29(w2c_rlbox*, u32, u32, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_graphite20x3A0x3Avm0x3A0x3AMachine0x3A0x3ACode0x3A0x3Aoperator0x3D0x28graphite20x3A0x3Avm0x3A0x3AMachine0x3A0x3ACode0x20const0x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_graphite20x3A0x3APass0x3A0x3AreadRanges0x28unsigned0x20char0x20const0x2A0x2C0x20unsigned0x20long0x2C0x20graphite20x3A0x3AError0x260x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_graphite20x3A0x3APass0x3A0x3AreadRules0x28unsigned0x20char0x20const0x2A0x2C0x20unsigned0x20long0x2C0x20unsigned0x20char0x20const0x2A0x2C0x20unsigned0x20short0x20const0x2A0x2C0x20unsigned0x20short0x20const0x2A0x2C0x20unsigned0x20char0x20const0x2A0x2C0x20unsigned0x20short0x20const0x2A0x2C0x20unsigned0x20char0x20const0x2A0x2C0x20graphite20x3A0x3AFace0x260x2C0x20graphite20x3A0x3Apasstype0x2C0x20graphite20x3A0x3AError0x260x29(w2c_rlbox*, u32, u32, u32, u32, u32, u32, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_graphite20x3A0x3APass0x3A0x3AreadStates0x28unsigned0x20char0x20const0x2A0x2C0x20unsigned0x20char0x20const0x2A0x2C0x20unsigned0x20char0x20const0x2A0x2C0x20graphite20x3A0x3AFace0x260x2C0x20graphite20x3A0x3AError0x260x29(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_cmpRuleEntry0x28void0x20const0x2A0x2C0x20void0x20const0x2A0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_graphite20x3A0x3APass0x3A0x3ArunGraphite0x28graphite20x3A0x3Avm0x3A0x3AMachine0x260x2C0x20graphite20x3A0x3AFiniteStateMachine0x260x2C0x20bool0x290x20const(w2c_rlbox*, u32, u32, u32, u32);
static void w2c_rlbox_graphite20x3A0x3APass0x3A0x3AfindNDoRule0x28graphite20x3A0x3ASlot0x2A0x260x2C0x20graphite20x3A0x3Avm0x3A0x3AMachine0x260x2C0x20graphite20x3A0x3AFiniteStateMachine0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_graphite20x3A0x3APass0x3A0x3AcollisionShift0x28graphite20x3A0x3ASegment0x2A0x2C0x20int0x2C0x20graphite20x3A0x3Ajson0x2A0x290x20const(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_graphite20x3A0x3APass0x3A0x3AcollisionKern0x28graphite20x3A0x3ASegment0x2A0x2C0x20int0x2C0x20graphite20x3A0x3Ajson0x2A0x290x20const(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_graphite20x3A0x3APass0x3A0x3AcollisionFinish0x28graphite20x3A0x3ASegment0x2A0x2C0x20graphite20x3A0x3Ajson0x2A0x290x20const(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_graphite20x3A0x3APass0x3A0x3ArunFSM0x28graphite20x3A0x3AFiniteStateMachine0x260x2C0x20graphite20x3A0x3ASlot0x2A0x290x20const(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_graphite20x3A0x3APass0x3A0x3AtestConstraint0x28graphite20x3A0x3ARule0x20const0x260x2C0x20graphite20x3A0x3Avm0x3A0x3AMachine0x260x290x20const(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_graphite20x3A0x3APass0x3A0x3AdoAction0x28graphite20x3A0x3Avm0x3A0x3AMachine0x3A0x3ACode0x20const0x2A0x2C0x20graphite20x3A0x3ASlot0x2A0x260x2C0x20graphite20x3A0x3Avm0x3A0x3AMachine0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32);
static void w2c_rlbox_graphite20x3A0x3ASlotMap0x3A0x3AcollectGarbage0x28graphite20x3A0x3ASlot0x2A0x260x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_graphite20x3A0x3APass0x3A0x3AadjustSlot0x28int0x2C0x20graphite20x3A0x3ASlot0x2A0x260x2C0x20graphite20x3A0x3ASlotMap0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_graphite20x3A0x3APass0x3A0x3AresolveCollisions0x28graphite20x3A0x3ASegment0x2A0x2C0x20graphite20x3A0x3ASlot0x2A0x2C0x20graphite20x3A0x3ASlot0x2A0x2C0x20graphite20x3A0x3AShiftCollider0x260x2C0x20bool0x2C0x20int0x2C0x20bool0x260x2C0x20bool0x260x2C0x20graphite20x3A0x3Ajson0x2A0x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32, u32, u32, u32, u32);
static f32 w2c_rlbox_graphite20x3A0x3APass0x3A0x3AresolveKern0x28graphite20x3A0x3ASegment0x2A0x2C0x20graphite20x3A0x3ASlot0x2A0x2C0x20graphite20x3A0x3ASlot0x2A0x2C0x20int0x2C0x20float0x260x2C0x20float0x260x2C0x20graphite20x3A0x3Ajson0x2A0x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_graphite20x3A0x3ARect0x3A0x3AhitTest0x28graphite20x3A0x3ARect0x260x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_graphite20x3A0x3ARect0x3A0x3Aoverlap0x28graphite20x3A0x3APosition0x260x2C0x20graphite20x3A0x3ARect0x260x2C0x20graphite20x3A0x3APosition0x260x29(w2c_rlbox*, u32, u32, u32, u32, u32);
static f32 w2c_rlbox_boundmin0x28float0x2C0x20float0x2C0x20float0x2C0x20float0x260x29(w2c_rlbox*, f32, f32, f32, u32);
static u32 w2c_rlbox_graphite20x3A0x3ASegment0x3A0x3ASegment0x28unsigned0x20long0x2C0x20graphite20x3A0x3AFace0x20const0x2A0x2C0x20unsigned0x20int0x2C0x20int0x29(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_graphite20x3A0x3ASegment0x3A0x3AnewSlot0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_graphite20x3A0x3ASegment0x3A0x3AfreeSlot0x28graphite20x3A0x3ASlot0x2A0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_graphite20x3A0x3AVector0x3Cgraphite20x3A0x3ASlot0x2A0x3E0x3A0x3Apush_back0x28graphite20x3A0x3ASlot0x2A0x20const0x260x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_graphite20x3A0x3AVector0x3Cshort0x2A0x3E0x3A0x3Apush_back0x28short0x2A0x20const0x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_graphite20x3A0x3ASegment0x3A0x3A0x7ESegment0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_graphite20x3A0x3AVector0x3Cgraphite20x3A0x3AFeatureVal0x3E0x3A0x3Aclear0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_graphite20x3A0x3ASegment0x3A0x3AappendSlot0x28int0x2C0x20int0x2C0x20int0x2C0x20int0x2C0x20unsigned0x20long0x29(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_graphite20x3A0x3ASegment0x3A0x3AnewJustify0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_graphite20x3A0x3AVector0x3Cgraphite20x3A0x3ASlotJustify0x2A0x3E0x3A0x3Apush_back0x28graphite20x3A0x3ASlotJustify0x2A0x20const0x260x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_graphite20x3A0x3ASegment0x3A0x3AfreeJustify0x28graphite20x3A0x3ASlotJustify0x2A0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_graphite20x3A0x3ASegment0x3A0x3AreverseSlots0x280x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_graphite20x3A0x3ASegment0x3A0x3AglyphAttr0x28unsigned0x20short0x2C0x20unsigned0x20short0x290x20const(w2c_rlbox*, u32, u32, u32);
static void w2c_rlbox_graphite20x3A0x3ASegment0x3A0x3AlinkClusters0x28graphite20x3A0x3ASlot0x2A0x2C0x20graphite20x3A0x3ASlot0x2A0x29(w2c_rlbox*, u32, u32, u32);
static void w2c_rlbox_graphite20x3A0x3ASegment0x3A0x3ApositionSlots0x28graphite20x3A0x3AFont0x20const0x2A0x2C0x20graphite20x3A0x3ASlot0x2A0x2C0x20graphite20x3A0x3ASlot0x2A0x2C0x20bool0x2C0x20bool0x29(w2c_rlbox*, u32, u32, u32, u32, u32, u32, u32);
static void w2c_rlbox_graphite20x3A0x3ASegment0x3A0x3AassociateChars0x28int0x2C0x20unsigned0x20long0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_graphite20x3A0x3ASegment0x3A0x3Aread_text0x28graphite20x3A0x3AFace0x20const0x2A0x2C0x20graphite20x3A0x3AFeatureVal0x20const0x2A0x2C0x20gr_encform0x2C0x20void0x20const0x2A0x2C0x20unsigned0x20long0x29(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static void w2c_rlbox_graphite20x3A0x3AVector0x3Cgraphite20x3A0x3AFeatureVal0x3E0x3A0x3Apush_back0x28graphite20x3A0x3AFeatureVal0x20const0x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_graphite20x3A0x3A_utf_iterator0x3Cunsigned0x20char0x20const0x3E0x3A0x3Areference0x3A0x3Aoperator0x20unsigned0x20int0x280x290x20const(w2c_rlbox*, u32);
static void w2c_rlbox_graphite20x3A0x3ASegment0x3A0x3AdoMirror0x28unsigned0x20short0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_graphite20x3A0x3ASegment0x3A0x3AinitCollisions0x280x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_graphite20x3A0x3ASilf0x3A0x3ASilf0x280x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_graphite20x3A0x3ASilf0x3A0x3A0x7ESilf0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_graphite20x3A0x3ASilf0x3A0x3AreleaseBuffers0x280x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_graphite20x3A0x3ASilf0x3A0x3AreadGraphite0x28unsigned0x20char0x20const0x2A0x2C0x20unsigned0x20long0x2C0x20graphite20x3A0x3AFace0x260x2C0x20unsigned0x20int0x29(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_graphite20x3A0x3ASilf0x3A0x3AreadClassMap0x28unsigned0x20char0x20const0x2A0x2C0x20unsigned0x20long0x2C0x20unsigned0x20int0x2C0x20graphite20x3A0x3AError0x260x29(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_graphite20x3A0x3ASilf0x3A0x3AfindPseudo0x28unsigned0x20int0x290x20const(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_graphite20x3A0x3ASilf0x3A0x3AfindClassIndex0x28unsigned0x20short0x2C0x20unsigned0x20short0x290x20const(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_graphite20x3A0x3ASilf0x3A0x3AgetClassGlyph0x28unsigned0x20short0x2C0x20unsigned0x20int0x290x20const(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_graphite20x3A0x3ASilf0x3A0x3ArunGraphite0x28graphite20x3A0x3ASegment0x2A0x2C0x20unsigned0x20char0x2C0x20unsigned0x20char0x2C0x20int0x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_graphite20x3A0x3ASlot0x3A0x3ASlot0x28short0x2A0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_graphite20x3A0x3ASlot0x3A0x3Aset0x28graphite20x3A0x3ASlot0x20const0x260x2C0x20int0x2C0x20unsigned0x20long0x2C0x20unsigned0x20long0x2C0x20unsigned0x20long0x29(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static void w2c_rlbox_graphite20x3A0x3ASlot0x3A0x3Aupdate0x28int0x2C0x20int0x2C0x20graphite20x3A0x3APosition0x260x29(w2c_rlbox*, u32, u32, u32, u32);
static void w2c_rlbox_graphite20x3A0x3ASlot0x3A0x3Afinalise0x28graphite20x3A0x3ASegment0x20const0x2A0x2C0x20graphite20x3A0x3AFont0x20const0x2A0x2C0x20graphite20x3A0x3APosition0x260x2C0x20graphite20x3A0x3ARect0x260x2C0x20unsigned0x20char0x2C0x20float0x260x2C0x20bool0x2C0x20bool0x2C0x20int0x29(w2c_rlbox*, u32, u32, u32, u32, u32, u32, u32, u32, u32, u32, u32);
static void w2c_rlbox_graphite20x3A0x3ASlot0x3A0x3AfloodShift0x28graphite20x3A0x3APosition0x2C0x20int0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_graphite20x3A0x3ASlot0x3A0x3AclusterMetric0x28graphite20x3A0x3ASegment0x20const0x2A0x2C0x20unsigned0x20char0x2C0x20unsigned0x20char0x2C0x20bool0x29(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_graphite20x3A0x3ASlot0x3A0x3AgetAttr0x28graphite20x3A0x3ASegment0x20const0x2A0x2C0x20gr_attrCode0x2C0x20unsigned0x20char0x290x20const(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_graphite20x3A0x3ASlot0x3A0x3AgetJustify0x28graphite20x3A0x3ASegment0x20const0x2A0x2C0x20unsigned0x20char0x2C0x20unsigned0x20char0x290x20const(w2c_rlbox*, u32, u32, u32, u32);
static void w2c_rlbox_graphite20x3A0x3ASlot0x3A0x3AsetAttr0x28graphite20x3A0x3ASegment0x2A0x2C0x20gr_attrCode0x2C0x20unsigned0x20char0x2C0x20short0x2C0x20graphite20x3A0x3ASlotMap0x20const0x260x29(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static void w2c_rlbox_graphite20x3A0x3ASlot0x3A0x3AsetJustify0x28graphite20x3A0x3ASegment0x2A0x2C0x20unsigned0x20char0x2C0x20unsigned0x20char0x2C0x20short0x29(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_graphite20x3A0x3ASlot0x3A0x3AremoveChild0x28graphite20x3A0x3ASlot0x2A0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_graphite20x3A0x3ASlotJustify0x3A0x3ALoadSlot0x28graphite20x3A0x3ASlot0x20const0x2A0x2C0x20graphite20x3A0x3ASegment0x20const0x2A0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_graphite20x3A0x3ASlot0x3A0x3Achild0x28graphite20x3A0x3ASlot0x2A0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_graphite20x3A0x3ASlot0x3A0x3Asibling0x28graphite20x3A0x3ASlot0x2A0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_graphite20x3A0x3ASlot0x3A0x3AsetGlyph0x28graphite20x3A0x3ASegment0x2A0x2C0x20unsigned0x20short0x2C0x20graphite20x3A0x3AGlyphFace0x20const0x2A0x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_graphite20x3A0x3ASlot0x3A0x3AnextInCluster0x28graphite20x3A0x3ASlot0x20const0x2A0x290x20const(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_graphite20x3A0x3ASlot0x3A0x3AisChildOf0x28graphite20x3A0x3ASlot0x20const0x2A0x290x20const(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_graphite20x3A0x3Asparse0x3A0x3A0x7Esparse0x280x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_graphite20x3A0x3Asparse0x3A0x3Aoperator0x5B0x5D0x28unsigned0x20short0x290x20const(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_graphite20x3A0x3Asparse0x3A0x3Acapacity0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_graphite20x3A0x3ATtfUtil0x3A0x3AGetHeaderInfo0x28unsigned0x20long0x260x2C0x20unsigned0x20long0x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_graphite20x3A0x3ATtfUtil0x3A0x3ACheckHeader0x28void0x20const0x2A0x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_graphite20x3A0x3ATtfUtil0x3A0x3AGetTableDirInfo0x28void0x20const0x2A0x2C0x20unsigned0x20long0x260x2C0x20unsigned0x20long0x260x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_graphite20x3A0x3ATtfUtil0x3A0x3AGetTableInfo0x28graphite20x3A0x3ATtfUtil0x3A0x3ATag0x2C0x20void0x20const0x2A0x2C0x20void0x20const0x2A0x2C0x20unsigned0x20long0x260x2C0x20unsigned0x20long0x260x29(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_graphite20x3A0x3ATtfUtil0x3A0x3ACheckTable0x28graphite20x3A0x3ATtfUtil0x3A0x3ATag0x2C0x20void0x20const0x2A0x2C0x20unsigned0x20long0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_graphite20x3A0x3ATtfUtil0x3A0x3AGlyphCount0x28void0x20const0x2A0x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_graphite20x3A0x3ATtfUtil0x3A0x3ADesignUnits0x28void0x20const0x2A0x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_graphite20x3A0x3ATtfUtil0x3A0x3AGetNameInfo0x28void0x20const0x2A0x2C0x20int0x2C0x20int0x2C0x20int0x2C0x20int0x2C0x20unsigned0x20long0x260x2C0x20unsigned0x20long0x260x29(w2c_rlbox*, u32, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_graphite20x3A0x3ATtfUtil0x3A0x3AHorMetrics0x28unsigned0x20short0x2C0x20void0x20const0x2A0x2C0x20unsigned0x20long0x2C0x20void0x20const0x2A0x2C0x20int0x260x2C0x20unsigned0x20int0x260x29(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_graphite20x3A0x3ATtfUtil0x3A0x3AFindCmapSubtable0x28void0x20const0x2A0x2C0x20int0x2C0x20int0x2C0x20unsigned0x20long0x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_graphite20x3A0x3ATtfUtil0x3A0x3ACheckCmapSubtable40x28void0x20const0x2A0x2C0x20void0x20const0x2A0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_graphite20x3A0x3ATtfUtil0x3A0x3ACmapSubtable4Lookup0x28void0x20const0x2A0x2C0x20unsigned0x20int0x2C0x20int0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_graphite20x3A0x3ATtfUtil0x3A0x3ACmapSubtable4NextCodepoint0x28void0x20const0x2A0x2C0x20unsigned0x20int0x2C0x20int0x2A0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_graphite20x3A0x3ATtfUtil0x3A0x3ACheckCmapSubtable120x28void0x20const0x2A0x2C0x20void0x20const0x2A0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_graphite20x3A0x3ATtfUtil0x3A0x3ACmapSubtable12Lookup0x28void0x20const0x2A0x2C0x20unsigned0x20int0x2C0x20int0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_graphite20x3A0x3ATtfUtil0x3A0x3ACmapSubtable12NextCodepoint0x28void0x20const0x2A0x2C0x20unsigned0x20int0x2C0x20int0x2A0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_graphite20x3A0x3ATtfUtil0x3A0x3ALocaLookup0x28unsigned0x20short0x2C0x20void0x20const0x2A0x2C0x20unsigned0x20long0x2C0x20void0x20const0x2A0x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_graphite20x3A0x3ATtfUtil0x3A0x3AGlyfLookup0x28void0x20const0x2A0x2C0x20unsigned0x20long0x2C0x20unsigned0x20long0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_graphite20x3A0x3ATtfUtil0x3A0x3AGlyfBox0x28void0x20const0x2A0x2C0x20int0x260x2C0x20int0x260x2C0x20int0x260x2C0x20int0x260x29(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_graphite20x3A0x3ATtfUtil0x3A0x3AGlyfLookup0x28unsigned0x20short0x2C0x20void0x20const0x2A0x2C0x20void0x20const0x2A0x2C0x20unsigned0x20long0x2C0x20unsigned0x20long0x2C0x20void0x20const0x2A0x29(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_graphite20x3A0x3Avm0x3A0x3AMachine0x3A0x3Arun0x28void0x2A0x20const0x2A0x2C0x20unsigned0x20char0x20const0x2A0x2C0x20graphite20x3A0x3ASlot0x2A0x2A0x260x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_graphite20x3A0x3Avm0x3A0x3AMachine0x3A0x3AgetOpcodeTable0x280x29(w2c_rlbox*);
static u32 w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Anop0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Apush_byte0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Apush_byte_u0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Apush_short0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Apush_short_u0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Apush_long0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Aadd0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Asub0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Amul0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Adiv_0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Amin_0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Amax_0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Aneg0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Atrunc80x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Atrunc160x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Acond0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Aand_0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Aor_0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Anot_0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Aequal0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Anot_eq_0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Aless0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Agtr0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Aless_eq0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Agtr_eq0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Anext0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Aput_glyph_8bit_obs0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Aput_subs_8bit_obs0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Aput_copy0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Ainsert0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Adelete_0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Aassoc0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Acntxt_item0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Aattr_set0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Aattr_add0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Aattr_sub0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Aattr_set_slot0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Aiattr_set_slot0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Apush_slot_attr0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Apush_glyph_attr_obs0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Apush_glyph_metric0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Apush_feat0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_graphite20x3A0x3ASegment0x3A0x3AgetFeature0x28int0x2C0x20unsigned0x20char0x290x20const(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Apush_att_to_gattr_obs0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Apush_att_to_glyph_metric0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Apush_islot_attr0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Apop_ret0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Aret_zero0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Aret_true0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Aiattr_set0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Aiattr_add0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Aiattr_sub0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Apush_proc_state0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Apush_version0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Aput_subs0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Aput_glyph0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Apush_glyph_attr0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Apush_att_to_glyph_attr0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Abor0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Aband0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Abnot0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Asetbits0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Aset_feat0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(w2c_rlbox*, u32, u32, u32, u32);
static void w2c_rlbox_graphite20x3A0x3ASegment0x3A0x3AsetFeature0x28int0x2C0x20unsigned0x20char0x2C0x20unsigned0x20int0x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Atemp_copy0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_gr_cinfo_unicode_char_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_gr_cinfo_break_weight_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_gr_cinfo_after_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_gr_cinfo_before_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_gr_cinfo_base_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_gr_make_face_with_ops_0(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_gr_make_face_0(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_gr_make_face_with_seg_cache_and_ops_0(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_gr_make_face_with_seg_cache_0(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_gr_str_to_tag_0(w2c_rlbox*, u32);
static void w2c_rlbox_gr_tag_to_str_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_gr_face_featureval_for_lang_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_gr_face_find_fref_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_gr_face_n_fref_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_gr_face_fref_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_gr_face_n_languages_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_gr_face_lang_by_index_0(w2c_rlbox*, u32, u32);
static void w2c_rlbox_gr_face_destroy_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_gr_face_name_lang_for_locale_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_gr_face_n_glyphs_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_gr_face_info_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_gr_face_is_char_supported_0(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_gr_fref_feature_value_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_gr_fref_set_feature_value_0(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_gr_fref_id_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_gr_fref_n_values_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_gr_fref_value_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_gr_fref_label_0(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_gr_fref_value_label_0(w2c_rlbox*, u32, u32, u32, u32, u32);
static void w2c_rlbox_gr_label_destroy_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_gr_featureval_clone_0(w2c_rlbox*, u32);
static void w2c_rlbox_gr_featureval_destroy_0(w2c_rlbox*, u32);
static void w2c_rlbox_gr_engine_version_0(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_gr_make_font_0(w2c_rlbox*, f32, u32);
static u32 w2c_rlbox_gr_make_font_with_ops_0(w2c_rlbox*, f32, u32, u32, u32);
static u32 w2c_rlbox_gr_make_font_with_advance_fn_0(w2c_rlbox*, f32, u32, u32, u32);
static void w2c_rlbox_gr_font_destroy_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_gr_count_unicode_characters_0(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_graphite20x3A0x3A_utf_iterator0x3Cunsigned0x20char0x20const0x3E0x3A0x3Avalidate0x28graphite20x3A0x3A_utf_iterator0x3Cunsigned0x20char0x20const0x3E0x20const0x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_gr_make_seg_0(w2c_rlbox*, u32, u32, u32, u32, u32, u32, u32, u32);
static void w2c_rlbox_gr_seg_destroy_0(w2c_rlbox*, u32);
static f32 w2c_rlbox_gr_seg_advance_X_0(w2c_rlbox*, u32);
static f32 w2c_rlbox_gr_seg_advance_Y_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_gr_seg_n_cinfo_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_gr_seg_cinfo_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_gr_seg_n_slots_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_gr_seg_first_slot_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_gr_seg_last_slot_0(w2c_rlbox*, u32);
static f32 w2c_rlbox_gr_seg_justify_0(w2c_rlbox*, u32, u32, u32, f64, u32, u32, u32);
static u32 w2c_rlbox_gr_slot_next_in_segment_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_gr_slot_prev_in_segment_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_gr_slot_attached_to_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_gr_slot_first_attachment_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_gr_slot_next_sibling_attachment_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_gr_slot_gid_0(w2c_rlbox*, u32);
static f32 w2c_rlbox_gr_slot_origin_X_0(w2c_rlbox*, u32);
static f32 w2c_rlbox_gr_slot_origin_Y_0(w2c_rlbox*, u32);
static f32 w2c_rlbox_gr_slot_advance_X_0(w2c_rlbox*, u32, u32, u32);
static f32 w2c_rlbox_gr_slot_advance_Y_0(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_gr_slot_before_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_gr_slot_after_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_gr_slot_index_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_gr_slot_attr_0(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_gr_slot_can_insert_before_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_gr_slot_original_0(w2c_rlbox*, u32);
static void w2c_rlbox_gr_slot_linebreak_before_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_moz_xmalloc_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_moz_xcalloc_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_moz_xrealloc_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_moz_xstrdup_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_moz_xmemdup_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_moz_malloc_usable_size_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_moz_malloc_size_of_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_moz_malloc_enclosing_size_of_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_RLBoxConvertWOFF2ToTTF_0(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3Abasic_string0x5Babi0x3Ann2101050x5D0x28unsigned0x20long0x2C0x20char0x29(w2c_rlbox*, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x3A0x3Aoperator0x280x290x5Babi0x3Ann2101050x5D0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2A0x290x20const(w2c_rlbox*, u32, u32);
static void w2c_rlbox_RLBoxDeleteWOFF2String_0(w2c_rlbox*, u32);
static void w2c_rlbox_RegisterWOFF2Callback_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_RLBoxBrotliDecoderDecompress_0(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_woff20x3A0x3ASize255UShort0x28unsigned0x20short0x29(w2c_rlbox*, u32);
static void w2c_rlbox_woff20x3A0x3AWrite255UShort0x28std0x3A0x3A_0x5F20x3A0x3Avector0x3Cunsigned0x20char0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cunsigned0x20char0x3E0x3E0x2A0x2C0x20int0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Avector0x3Cunsigned0x20char0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cunsigned0x20char0x3E0x3E0x3A0x3Apush_back0x5Babi0x3Ann2101050x5D0x28unsigned0x20char0x260x260x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Avector0x3Cunsigned0x20char0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cunsigned0x20char0x3E0x3E0x3A0x3A_0x5Fthrow_length_error0x5Babi0x3Ann2101050x5D0x280x29(w2c_rlbox*);
static void w2c_rlbox_woff20x3A0x3AStore255UShort0x28int0x2C0x20unsigned0x20long0x2A0x2C0x20unsigned0x20char0x2A0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_woff20x3A0x3ARead255UShort0x28woff20x3A0x3ABuffer0x2A0x2C0x20unsigned0x20int0x2A0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_woff20x3A0x3ABuffer0x3A0x3AReadU160x28unsigned0x20short0x2A0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_woff20x3A0x3AReadBase1280x28woff20x3A0x3ABuffer0x2A0x2C0x20unsigned0x20int0x2A0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_woff20x3A0x3ABase128Size0x28unsigned0x20long0x29(w2c_rlbox*, u32);
static void w2c_rlbox_woff20x3A0x3AStoreBase1280x28unsigned0x20long0x2C0x20unsigned0x20long0x2A0x2C0x20unsigned0x20char0x2A0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_woff20x3A0x3AComputeULongSum0x28unsigned0x20char0x20const0x2A0x2C0x20unsigned0x20long0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_woff20x3A0x3ACollectionHeaderSize0x28unsigned0x20int0x2C0x20unsigned0x20int0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_woff20x3A0x3AComputeWOFF2FinalSize0x28unsigned0x20char0x20const0x2A0x2C0x20unsigned0x20long0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_woff20x3A0x3AConvertWOFF2ToTTF0x28unsigned0x20char0x2A0x2C0x20unsigned0x20long0x2C0x20unsigned0x20char0x20const0x2A0x2C0x20unsigned0x20long0x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_woff20x3A0x3AConvertWOFF2ToTTF0x28unsigned0x20char0x20const0x2A0x2C0x20unsigned0x20long0x2C0x20woff20x3A0x3AWOFF2Out0x2A0x29(w2c_rlbox*, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Avector0x3Cwoff20x3A0x3ATable0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cwoff20x3A0x3ATable0x3E0x3E0x3A0x3Aresize0x28unsigned0x20long0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Avector0x3Cwoff20x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ATtcFont0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cwoff20x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ATtcFont0x3E0x3E0x3A0x3A_0x5Fbase_destruct_at_end0x5Babi0x3Ann2101050x5D0x28woff20x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ATtcFont0x2A0x29(w2c_rlbox*, u32, u32);
static u64 w2c_rlbox_woff20x3A0x3A0x28anonymous0x20namespace0x290x3A0x3AComputeOffsetToFirstTable0x28woff20x3A0x3A0x28anonymous0x20namespace0x290x3A0x3AWOFF2Header0x20const0x260x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Avector0x3Cwoff20x3A0x3ATable0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cwoff20x3A0x3ATable0x3E0x3E0x3A0x3Avector0x5Babi0x3Ann2101050x5D0x28std0x3A0x3A_0x5F20x3A0x3Avector0x3Cwoff20x3A0x3ATable0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cwoff20x3A0x3ATable0x3E0x3E0x20const0x260x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Apair0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Ftree_iterator0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fvalue_type0x3Cunsigned0x20int0x2C0x20unsigned0x20short0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Ftree_node0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fvalue_type0x3Cunsigned0x20int0x2C0x20unsigned0x20short0x3E0x2C0x20void0x2A0x3E0x2A0x2C0x20long0x3E0x2C0x20bool0x3E0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Ftree0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fvalue_type0x3Cunsigned0x20int0x2C0x20unsigned0x20short0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fmap_value_compare0x3Cunsigned0x20int0x2C0x20std0x3A0x3A_0x5F20x3A0x3Apair0x3Cunsigned0x20int0x20const0x2C0x20unsigned0x20short0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aless0x3Cunsigned0x20int0x3E0x2C0x20true0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cunsigned0x20int0x20const0x2C0x20unsigned0x20short0x3E0x3E0x3E0x3A0x3A_0x5Femplace_unique_key_args0x3Cunsigned0x20int0x2C0x20std0x3A0x3A_0x5F20x3A0x3Apiecewise_construct_t0x20const0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Atuple0x3Cunsigned0x20int0x20const0x260x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Atuple0x3C0x3E0x3E0x28unsigned0x20int0x20const0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Apiecewise_construct_t0x20const0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Atuple0x3Cunsigned0x20int0x20const0x260x3E0x260x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Atuple0x3C0x3E0x260x260x29(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Ftree0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fvalue_type0x3Cunsigned0x20int0x2C0x20unsigned0x20short0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fmap_value_compare0x3Cunsigned0x20int0x2C0x20std0x3A0x3A_0x5F20x3A0x3Apair0x3Cunsigned0x20int0x20const0x2C0x20unsigned0x20short0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aless0x3Cunsigned0x20int0x3E0x2C0x20true0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cunsigned0x20int0x20const0x2C0x20unsigned0x20short0x3E0x3E0x3E0x3A0x3Adestroy0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Ftree_node0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fvalue_type0x3Cunsigned0x20int0x2C0x20unsigned0x20short0x3E0x2C0x20void0x2A0x3E0x2A0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fintrosort0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cvoid0x2C0x20void0x3E0x260x2C0x20woff20x3A0x3ATable0x2A0x2C0x20false0x3E0x28woff20x3A0x3ATable0x2A0x2C0x20woff20x3A0x3ATable0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cvoid0x2C0x20void0x3E0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Aiterator_traits0x3Cwoff20x3A0x3ATable0x2A0x3E0x3A0x3Adifference_type0x2C0x20bool0x29(w2c_rlbox*, u32, u32, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Avector0x3Cwoff20x3A0x3A0x28anonymous0x20namespace0x290x3A0x3AWOFF2FontInfo0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cwoff20x3A0x3A0x28anonymous0x20namespace0x290x3A0x3AWOFF2FontInfo0x3E0x3E0x3A0x3Aresize0x28unsigned0x20long0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_woff20x3A0x3A0x28anonymous0x20namespace0x290x3A0x3AStoreOffsetTable0x28unsigned0x20char0x2A0x2C0x20unsigned0x20long0x2C0x20unsigned0x20int0x2C0x20unsigned0x20short0x29(w2c_rlbox*, u32, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Apair0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Ftree_iterator0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fvalue_type0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Ftree_node0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fvalue_type0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x2C0x20void0x2A0x3E0x2A0x2C0x20long0x3E0x2C0x20bool0x3E0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Ftree0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fvalue_type0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fmap_value_compare0x3Cunsigned0x20int0x2C0x20std0x3A0x3A_0x5F20x3A0x3Apair0x3Cunsigned0x20int0x20const0x2C0x20unsigned0x20int0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aless0x3Cunsigned0x20int0x3E0x2C0x20true0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cunsigned0x20int0x20const0x2C0x20unsigned0x20int0x3E0x3E0x3E0x3A0x3A_0x5Femplace_unique_key_args0x3Cunsigned0x20int0x2C0x20std0x3A0x3A_0x5F20x3A0x3Apiecewise_construct_t0x20const0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Atuple0x3Cunsigned0x20int0x20const0x260x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Atuple0x3C0x3E0x3E0x28unsigned0x20int0x20const0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Apiecewise_construct_t0x20const0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Atuple0x3Cunsigned0x20int0x20const0x260x3E0x260x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Atuple0x3C0x3E0x260x260x29(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Avector0x3Cwoff20x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ATtcFont0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cwoff20x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ATtcFont0x3E0x3E0x3A0x3A_0x5Fthrow_length_error0x5Babi0x3Ann2101050x5D0x280x29(w2c_rlbox*);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Avector0x3Cwoff20x3A0x3ATable0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cwoff20x3A0x3ATable0x2A0x3E0x3E0x3A0x3Apush_back0x5Babi0x3Ann2101050x5D0x28woff20x3A0x3ATable0x2A0x260x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Ftree_iterator0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fvalue_type0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x2C0x20unsigned0x20int0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Ftree_node0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fvalue_type0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x2C0x20unsigned0x20int0x3E0x2C0x20void0x2A0x3E0x2A0x2C0x20long0x3E0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Ftree0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fvalue_type0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x2C0x20unsigned0x20int0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fmap_value_compare0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Apair0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x20const0x2C0x20unsigned0x20int0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aless0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x3E0x2C0x20true0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x20const0x2C0x20unsigned0x20int0x3E0x3E0x3E0x3A0x3Afind0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Apair0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x20const0x260x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Avector0x3Cunsigned0x20short0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cunsigned0x20short0x3E0x3E0x3A0x3Apush_back0x5Babi0x3Ann2101050x5D0x28unsigned0x20short0x20const0x260x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Avector0x3Cshort0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cshort0x3E0x3E0x3A0x3Apush_back0x5Babi0x3Ann2101050x5D0x28short0x20const0x260x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Apair0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Ftree_iterator0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fvalue_type0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x2C0x20unsigned0x20int0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Ftree_node0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fvalue_type0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x2C0x20unsigned0x20int0x3E0x2C0x20void0x2A0x3E0x2A0x2C0x20long0x3E0x2C0x20bool0x3E0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Ftree0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fvalue_type0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x2C0x20unsigned0x20int0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fmap_value_compare0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Apair0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x20const0x2C0x20unsigned0x20int0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aless0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x3E0x2C0x20true0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x20const0x2C0x20unsigned0x20int0x3E0x3E0x3E0x3A0x3A_0x5Femplace_unique_key_args0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Apiecewise_construct_t0x20const0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Atuple0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x20const0x260x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Atuple0x3C0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Apair0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x20const0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Apiecewise_construct_t0x20const0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Atuple0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x20const0x260x3E0x260x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Atuple0x3C0x3E0x260x260x29(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Avector0x3Cunsigned0x20int0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cunsigned0x20int0x3E0x3E0x3A0x3Avector0x5Babi0x3Ann2101050x5D0x28unsigned0x20long0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Avector0x3Cshort0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cshort0x3E0x3E0x3A0x3Aresize0x28unsigned0x20long0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Avector0x3Cunsigned0x20int0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cunsigned0x20int0x3E0x3E0x3A0x3Apush_back0x5Babi0x3Ann2101050x5D0x28unsigned0x20int0x20const0x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_woff20x3A0x3A0x28anonymous0x20namespace0x290x3A0x3APad40x28woff20x3A0x3AWOFF2Out0x2A0x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Ftree0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fvalue_type0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x2C0x20unsigned0x20int0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fmap_value_compare0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Apair0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x20const0x2C0x20unsigned0x20int0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aless0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x3E0x2C0x20true0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x20const0x2C0x20unsigned0x20int0x3E0x3E0x3E0x3A0x3Adestroy0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Ftree_node0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fvalue_type0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x2C0x20unsigned0x20int0x3E0x2C0x20void0x2A0x3E0x2A0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3Aallocator_traits0x3Cstd0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cwoff20x3A0x3A0x28anonymous0x20namespace0x290x3A0x3AWOFF2FontInfo0x3E0x3E0x3A0x3Adestroy0x5Babi0x3Ann2101050x5D0x3Cwoff20x3A0x3A0x28anonymous0x20namespace0x290x3A0x3AWOFF2FontInfo0x2C0x2000x3E0x28std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cwoff20x3A0x3A0x28anonymous0x20namespace0x290x3A0x3AWOFF2FontInfo0x3E0x260x2C0x20woff20x3A0x3A0x28anonymous0x20namespace0x290x3A0x3AWOFF2FontInfo0x2A0x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Avector0x3Cwoff20x3A0x3ATable0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cwoff20x3A0x3ATable0x3E0x3E0x3A0x3A_0x5Fappend0x28unsigned0x20long0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fsplit_buffer0x3Cwoff20x3A0x3ATable0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cwoff20x3A0x3ATable0x3E0x260x3E0x3A0x3A_0x5Fsplit_buffer0x28unsigned0x20long0x2C0x20unsigned0x20long0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cwoff20x3A0x3ATable0x3E0x260x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fsplit_buffer0x3Cwoff20x3A0x3ATable0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cwoff20x3A0x3ATable0x3E0x260x3E0x3A0x3A0x7E_0x5Fsplit_buffer0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Avector0x3Cwoff20x3A0x3ATable0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cwoff20x3A0x3ATable0x3E0x3E0x3A0x3A_0x5Fthrow_length_error0x5Babi0x3Ann2101050x5D0x280x29(w2c_rlbox*);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Avector0x3Cwoff20x3A0x3ATable0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cwoff20x3A0x3ATable0x3E0x3E0x3A0x3A_0x5Fvallocate0x5Babi0x3Ann2101050x5D0x28unsigned0x20long0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Avector0x3Cwoff20x3A0x3A0x28anonymous0x20namespace0x290x3A0x3AWOFF2FontInfo0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cwoff20x3A0x3A0x28anonymous0x20namespace0x290x3A0x3AWOFF2FontInfo0x3E0x3E0x3A0x3A_0x5Fthrow_length_error0x5Babi0x3Ann2101050x5D0x280x29(w2c_rlbox*);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Ftree0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fvalue_type0x3Cunsigned0x20int0x2C0x20unsigned0x20short0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fmap_value_compare0x3Cunsigned0x20int0x2C0x20std0x3A0x3A_0x5F20x3A0x3Apair0x3Cunsigned0x20int0x20const0x2C0x20unsigned0x20short0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aless0x3Cunsigned0x20int0x3E0x2C0x20true0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cunsigned0x20int0x20const0x2C0x20unsigned0x20short0x3E0x3E0x3E0x3A0x3A_0x5Finsert_node_at0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Ftree_end_node0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Ftree_node_base0x3Cvoid0x2A0x3E0x2A0x3E0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Ftree_node_base0x3Cvoid0x2A0x3E0x2A0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Ftree_node_base0x3Cvoid0x2A0x3E0x2A0x29(w2c_rlbox*, u32, u32, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Ftree_balance_after_insert0x5Babi0x3Ann2101050x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Ftree_node_base0x3Cvoid0x2A0x3E0x2A0x3E0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Ftree_node_base0x3Cvoid0x2A0x3E0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Ftree_node_base0x3Cvoid0x2A0x3E0x2A0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fsort50x5Babi0x3Ann2101050x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cvoid0x2C0x20void0x3E0x260x2C0x20woff20x3A0x3ATable0x2A0x2C0x2000x3E0x28woff20x3A0x3ATable0x2A0x2C0x20woff20x3A0x3ATable0x2A0x2C0x20woff20x3A0x3ATable0x2A0x2C0x20woff20x3A0x3ATable0x2A0x2C0x20woff20x3A0x3ATable0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cvoid0x2C0x20void0x3E0x260x29(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Finsertion_sort0x5Babi0x3Ann2101050x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cvoid0x2C0x20void0x3E0x260x2C0x20woff20x3A0x3ATable0x2A0x3E0x28woff20x3A0x3ATable0x2A0x2C0x20woff20x3A0x3ATable0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cvoid0x2C0x20void0x3E0x260x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_woff20x3A0x3ATable0x2A0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fpartial_sort_impl0x5Babi0x3Ann2101050x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cvoid0x2C0x20void0x3E0x260x2C0x20woff20x3A0x3ATable0x2A0x2C0x20woff20x3A0x3ATable0x2A0x3E0x28woff20x3A0x3ATable0x2A0x2C0x20woff20x3A0x3ATable0x2A0x2C0x20woff20x3A0x3ATable0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cvoid0x2C0x20void0x3E0x260x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_woff20x3A0x3ATable0x2A0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fpartition_with_equals_on_left0x5Babi0x3Ann2101050x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20woff20x3A0x3ATable0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cvoid0x2C0x20void0x3E0x260x3E0x28woff20x3A0x3ATable0x2A0x2C0x20woff20x3A0x3ATable0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cvoid0x2C0x20void0x3E0x260x29(w2c_rlbox*, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Apair0x3Cwoff20x3A0x3ATable0x2A0x2C0x20bool0x3E0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fpartition_with_equals_on_right0x5Babi0x3Ann2101050x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20woff20x3A0x3ATable0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cvoid0x2C0x20void0x3E0x260x3E0x28woff20x3A0x3ATable0x2A0x2C0x20woff20x3A0x3ATable0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cvoid0x2C0x20void0x3E0x260x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_bool0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Finsertion_sort_incomplete0x5Babi0x3Ann2101050x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cvoid0x2C0x20void0x3E0x260x2C0x20woff20x3A0x3ATable0x2A0x3E0x28woff20x3A0x3ATable0x2A0x2C0x20woff20x3A0x3ATable0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cvoid0x2C0x20void0x3E0x260x29(w2c_rlbox*, u32, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fsift_down0x5Babi0x3Ann2101050x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cvoid0x2C0x20void0x3E0x260x2C0x20woff20x3A0x3ATable0x2A0x3E0x28woff20x3A0x3ATable0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cvoid0x2C0x20void0x3E0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Aiterator_traits0x3Cwoff20x3A0x3ATable0x2A0x3E0x3A0x3Adifference_type0x2C0x20woff20x3A0x3ATable0x2A0x29(w2c_rlbox*, u32, u32, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fsift_up0x5Babi0x3Ann2101050x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cvoid0x2C0x20void0x3E0x260x2C0x20woff20x3A0x3ATable0x2A0x3E0x28woff20x3A0x3ATable0x2A0x2C0x20woff20x3A0x3ATable0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cvoid0x2C0x20void0x3E0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Aiterator_traits0x3Cwoff20x3A0x3ATable0x2A0x3E0x3A0x3Adifference_type0x29(w2c_rlbox*, u32, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Ftree0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fvalue_type0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fmap_value_compare0x3Cunsigned0x20int0x2C0x20std0x3A0x3A_0x5F20x3A0x3Apair0x3Cunsigned0x20int0x20const0x2C0x20unsigned0x20int0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aless0x3Cunsigned0x20int0x3E0x2C0x20true0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cunsigned0x20int0x20const0x2C0x20unsigned0x20int0x3E0x3E0x3E0x3A0x3Adestroy0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Ftree_node0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fvalue_type0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x2C0x20void0x2A0x3E0x2A0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Ftree0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fvalue_type0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fmap_value_compare0x3Cunsigned0x20int0x2C0x20std0x3A0x3A_0x5F20x3A0x3Apair0x3Cunsigned0x20int0x20const0x2C0x20unsigned0x20int0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aless0x3Cunsigned0x20int0x3E0x2C0x20true0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cunsigned0x20int0x20const0x2C0x20unsigned0x20int0x3E0x3E0x3E0x3A0x3A_0x5Finsert_node_at0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Ftree_end_node0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Ftree_node_base0x3Cvoid0x2A0x3E0x2A0x3E0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Ftree_node_base0x3Cvoid0x2A0x3E0x2A0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Ftree_node_base0x3Cvoid0x2A0x3E0x2A0x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fsplit_buffer0x3Cwoff20x3A0x3ATable0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cwoff20x3A0x3ATable0x2A0x3E0x260x3E0x3A0x3A_0x5Fsplit_buffer0x28unsigned0x20long0x2C0x20unsigned0x20long0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cwoff20x3A0x3ATable0x2A0x3E0x260x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fsplit_buffer0x3Cwoff20x3A0x3ATable0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cwoff20x3A0x3ATable0x2A0x3E0x260x3E0x3A0x3A0x7E_0x5Fsplit_buffer0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Avector0x3Cwoff20x3A0x3ATable0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cwoff20x3A0x3ATable0x2A0x3E0x3E0x3A0x3A_0x5Fthrow_length_error0x5Babi0x3Ann2101050x5D0x280x29(w2c_rlbox*);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Avector0x3Cunsigned0x20int0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cunsigned0x20int0x3E0x3E0x3A0x3A_0x5Fvallocate0x5Babi0x3Ann2101050x5D0x28unsigned0x20long0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Avector0x3Cshort0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cshort0x3E0x3E0x3A0x3A_0x5Fappend0x28unsigned0x20long0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fsplit_buffer0x3Cunsigned0x20int0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cunsigned0x20int0x3E0x260x3E0x3A0x3A_0x5Fsplit_buffer0x28unsigned0x20long0x2C0x20unsigned0x20long0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cunsigned0x20int0x3E0x260x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fsplit_buffer0x3Cunsigned0x20int0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cunsigned0x20int0x3E0x260x3E0x3A0x3A0x7E_0x5Fsplit_buffer0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Avector0x3Cunsigned0x20int0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cunsigned0x20int0x3E0x3E0x3A0x3A_0x5Fthrow_length_error0x5Babi0x3Ann2101050x5D0x280x29(w2c_rlbox*);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fsplit_buffer0x3Cshort0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cshort0x3E0x260x3E0x3A0x3A_0x5Fsplit_buffer0x28unsigned0x20long0x2C0x20unsigned0x20long0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cshort0x3E0x260x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fsplit_buffer0x3Cshort0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cshort0x3E0x260x3E0x3A0x3A0x7E_0x5Fsplit_buffer0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Avector0x3Cshort0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cshort0x3E0x3E0x3A0x3A_0x5Fthrow_length_error0x5Babi0x3Ann2101050x5D0x280x29(w2c_rlbox*);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Ftree_node_base0x3Cvoid0x2A0x3E0x2A0x260x20std0x3A0x3A_0x5F20x3A0x3A_0x5Ftree0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fvalue_type0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x2C0x20unsigned0x20int0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fmap_value_compare0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Apair0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x20const0x2C0x20unsigned0x20int0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aless0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x3E0x2C0x20true0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x20const0x2C0x20unsigned0x20int0x3E0x3E0x3E0x3A0x3A_0x5Ffind_equal0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Ftree_end_node0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Ftree_node_base0x3Cvoid0x2A0x3E0x2A0x3E0x2A0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Apair0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x20const0x260x29(w2c_rlbox*, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Ftree0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fvalue_type0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x2C0x20unsigned0x20int0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fmap_value_compare0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Apair0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x20const0x2C0x20unsigned0x20int0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aless0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x3E0x2C0x20true0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x20const0x2C0x20unsigned0x20int0x3E0x3E0x3E0x3A0x3A_0x5Finsert_node_at0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Ftree_end_node0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Ftree_node_base0x3Cvoid0x2A0x3E0x2A0x3E0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Ftree_node_base0x3Cvoid0x2A0x3E0x2A0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Ftree_node_base0x3Cvoid0x2A0x3E0x2A0x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_woff20x3A0x3AWOFF2StringOut0x3A0x3AWOFF2StringOut0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2A0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_woff20x3A0x3AWOFF2StringOut0x3A0x3AWrite0x28void0x20const0x2A0x2C0x20unsigned0x20long0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_woff20x3A0x3AWOFF2StringOut0x3A0x3AWrite0x28void0x20const0x2A0x2C0x20unsigned0x20long0x2C0x20unsigned0x20long0x29(w2c_rlbox*, u32, u32, u32, u32);
static void w2c_rlbox_woff20x3A0x3AWOFF2StringOut0x3A0x3ASetMaxSize0x28unsigned0x20long0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_woff20x3A0x3AWOFF2MemoryOut0x3A0x3AWOFF2MemoryOut0x28unsigned0x20char0x2A0x2C0x20unsigned0x20long0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_woff20x3A0x3AWOFF2MemoryOut0x3A0x3AWrite0x28void0x20const0x2A0x2C0x20unsigned0x20long0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_woff20x3A0x3AWOFF2MemoryOut0x3A0x3AWrite0x28void0x20const0x2A0x2C0x20unsigned0x20long0x2C0x20unsigned0x20long0x29(w2c_rlbox*, u32, u32, u32, u32);
static void w2c_rlbox_woff20x3A0x3AWOFF2StringOut0x3A0x3A0x7EWOFF2StringOut0x280x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_woff20x3A0x3AWOFF2StringOut0x3A0x3ASize0x280x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_woff20x3A0x3AWOFF2Out0x3A0x3A0x7EWOFF2Out0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_woff20x3A0x3AWOFF2MemoryOut0x3A0x3A0x7EWOFF2MemoryOut0x280x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_woff20x3A0x3AWOFF2MemoryOut0x3A0x3ASize0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_init(w2c_rlbox*);
static u64 w2c_rlbox_0x5F_clock_0(w2c_rlbox*);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fsort0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cchar0x2C0x20char0x3E0x260x2C0x20char0x2A0x3E0x28char0x2A0x2C0x20char0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cchar0x2C0x20char0x3E0x260x29(w2c_rlbox*, u32, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fintrosort0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x2C0x20char0x2A0x2C0x20true0x3E0x28char0x2A0x2C0x20char0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aiterator_traits0x3Cchar0x2A0x3E0x3A0x3Adifference_type0x2C0x20bool0x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_char0x2A0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fpartial_sort_impl0x5Babi0x3Ann2101050x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x260x2C0x20char0x2A0x2C0x20char0x2A0x3E0x28char0x2A0x2C0x20char0x2A0x2C0x20char0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x260x29(w2c_rlbox*, u32, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Apair0x3Cchar0x2A0x2C0x20bool0x3E0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fbitset_partition0x5Babi0x3Ann2101050x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20char0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x3E0x28char0x2A0x2C0x20char0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_bool0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Finsertion_sort_incomplete0x5Babi0x3Ann2101050x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x2C0x20char0x2A0x3E0x28char0x2A0x2C0x20char0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fsort0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cwchar_t0x2C0x20wchar_t0x3E0x260x2C0x20wchar_t0x2A0x3E0x28wchar_t0x2A0x2C0x20wchar_t0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cwchar_t0x2C0x20wchar_t0x3E0x260x29(w2c_rlbox*, u32, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fintrosort0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x2C0x20wchar_t0x2A0x2C0x20true0x3E0x28wchar_t0x2A0x2C0x20wchar_t0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aiterator_traits0x3Cwchar_t0x2A0x3E0x3A0x3Adifference_type0x2C0x20bool0x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_wchar_t0x2A0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fpartial_sort_impl0x5Babi0x3Ann2101050x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x260x2C0x20wchar_t0x2A0x2C0x20wchar_t0x2A0x3E0x28wchar_t0x2A0x2C0x20wchar_t0x2A0x2C0x20wchar_t0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x260x29(w2c_rlbox*, u32, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Apair0x3Cwchar_t0x2A0x2C0x20bool0x3E0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fbitset_partition0x5Babi0x3Ann2101050x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20wchar_t0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x3E0x28wchar_t0x2A0x2C0x20wchar_t0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_bool0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Finsertion_sort_incomplete0x5Babi0x3Ann2101050x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x2C0x20wchar_t0x2A0x3E0x28wchar_t0x2A0x2C0x20wchar_t0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fsort0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Csigned0x20char0x2C0x20signed0x20char0x3E0x260x2C0x20signed0x20char0x2A0x3E0x28signed0x20char0x2A0x2C0x20signed0x20char0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Csigned0x20char0x2C0x20signed0x20char0x3E0x260x29(w2c_rlbox*, u32, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fintrosort0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x2C0x20signed0x20char0x2A0x2C0x20true0x3E0x28signed0x20char0x2A0x2C0x20signed0x20char0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aiterator_traits0x3Csigned0x20char0x2A0x3E0x3A0x3Adifference_type0x2C0x20bool0x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_signed0x20char0x2A0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fpartial_sort_impl0x5Babi0x3Ann2101050x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x260x2C0x20signed0x20char0x2A0x2C0x20signed0x20char0x2A0x3E0x28signed0x20char0x2A0x2C0x20signed0x20char0x2A0x2C0x20signed0x20char0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x260x29(w2c_rlbox*, u32, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Apair0x3Csigned0x20char0x2A0x2C0x20bool0x3E0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fbitset_partition0x5Babi0x3Ann2101050x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20signed0x20char0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x3E0x28signed0x20char0x2A0x2C0x20signed0x20char0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_bool0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Finsertion_sort_incomplete0x5Babi0x3Ann2101050x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x2C0x20signed0x20char0x2A0x3E0x28signed0x20char0x2A0x2C0x20signed0x20char0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fsort0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cunsigned0x20char0x2C0x20unsigned0x20char0x3E0x260x2C0x20unsigned0x20char0x2A0x3E0x28unsigned0x20char0x2A0x2C0x20unsigned0x20char0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cunsigned0x20char0x2C0x20unsigned0x20char0x3E0x260x29(w2c_rlbox*, u32, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fintrosort0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x2C0x20unsigned0x20char0x2A0x2C0x20true0x3E0x28unsigned0x20char0x2A0x2C0x20unsigned0x20char0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aiterator_traits0x3Cunsigned0x20char0x2A0x3E0x3A0x3Adifference_type0x2C0x20bool0x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_unsigned0x20char0x2A0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fpartial_sort_impl0x5Babi0x3Ann2101050x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x260x2C0x20unsigned0x20char0x2A0x2C0x20unsigned0x20char0x2A0x3E0x28unsigned0x20char0x2A0x2C0x20unsigned0x20char0x2A0x2C0x20unsigned0x20char0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x260x29(w2c_rlbox*, u32, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Apair0x3Cunsigned0x20char0x2A0x2C0x20bool0x3E0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fbitset_partition0x5Babi0x3Ann2101050x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20unsigned0x20char0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x3E0x28unsigned0x20char0x2A0x2C0x20unsigned0x20char0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_bool0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Finsertion_sort_incomplete0x5Babi0x3Ann2101050x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x2C0x20unsigned0x20char0x2A0x3E0x28unsigned0x20char0x2A0x2C0x20unsigned0x20char0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fsort0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cshort0x2C0x20short0x3E0x260x2C0x20short0x2A0x3E0x28short0x2A0x2C0x20short0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cshort0x2C0x20short0x3E0x260x29(w2c_rlbox*, u32, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fintrosort0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x2C0x20short0x2A0x2C0x20true0x3E0x28short0x2A0x2C0x20short0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aiterator_traits0x3Cshort0x2A0x3E0x3A0x3Adifference_type0x2C0x20bool0x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_short0x2A0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fpartial_sort_impl0x5Babi0x3Ann2101050x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x260x2C0x20short0x2A0x2C0x20short0x2A0x3E0x28short0x2A0x2C0x20short0x2A0x2C0x20short0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x260x29(w2c_rlbox*, u32, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Apair0x3Cshort0x2A0x2C0x20bool0x3E0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fbitset_partition0x5Babi0x3Ann2101050x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20short0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x3E0x28short0x2A0x2C0x20short0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_bool0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Finsertion_sort_incomplete0x5Babi0x3Ann2101050x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x2C0x20short0x2A0x3E0x28short0x2A0x2C0x20short0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fsort0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cunsigned0x20short0x2C0x20unsigned0x20short0x3E0x260x2C0x20unsigned0x20short0x2A0x3E0x28unsigned0x20short0x2A0x2C0x20unsigned0x20short0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cunsigned0x20short0x2C0x20unsigned0x20short0x3E0x260x29(w2c_rlbox*, u32, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fintrosort0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x2C0x20unsigned0x20short0x2A0x2C0x20true0x3E0x28unsigned0x20short0x2A0x2C0x20unsigned0x20short0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aiterator_traits0x3Cunsigned0x20short0x2A0x3E0x3A0x3Adifference_type0x2C0x20bool0x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_unsigned0x20short0x2A0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fpartial_sort_impl0x5Babi0x3Ann2101050x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x260x2C0x20unsigned0x20short0x2A0x2C0x20unsigned0x20short0x2A0x3E0x28unsigned0x20short0x2A0x2C0x20unsigned0x20short0x2A0x2C0x20unsigned0x20short0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x260x29(w2c_rlbox*, u32, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Apair0x3Cunsigned0x20short0x2A0x2C0x20bool0x3E0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fbitset_partition0x5Babi0x3Ann2101050x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20unsigned0x20short0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x3E0x28unsigned0x20short0x2A0x2C0x20unsigned0x20short0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_bool0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Finsertion_sort_incomplete0x5Babi0x3Ann2101050x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x2C0x20unsigned0x20short0x2A0x3E0x28unsigned0x20short0x2A0x2C0x20unsigned0x20short0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fsort0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cint0x2C0x20int0x3E0x260x2C0x20int0x2A0x3E0x28int0x2A0x2C0x20int0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cint0x2C0x20int0x3E0x260x29(w2c_rlbox*, u32, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fintrosort0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x2C0x20int0x2A0x2C0x20true0x3E0x28int0x2A0x2C0x20int0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aiterator_traits0x3Cint0x2A0x3E0x3A0x3Adifference_type0x2C0x20bool0x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_int0x2A0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fpartial_sort_impl0x5Babi0x3Ann2101050x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x260x2C0x20int0x2A0x2C0x20int0x2A0x3E0x28int0x2A0x2C0x20int0x2A0x2C0x20int0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x260x29(w2c_rlbox*, u32, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Apair0x3Cint0x2A0x2C0x20bool0x3E0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fbitset_partition0x5Babi0x3Ann2101050x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20int0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x3E0x28int0x2A0x2C0x20int0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_bool0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Finsertion_sort_incomplete0x5Babi0x3Ann2101050x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x2C0x20int0x2A0x3E0x28int0x2A0x2C0x20int0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fsort0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x260x2C0x20unsigned0x20int0x2A0x3E0x28unsigned0x20int0x2A0x2C0x20unsigned0x20int0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x260x29(w2c_rlbox*, u32, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fintrosort0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x2C0x20unsigned0x20int0x2A0x2C0x20true0x3E0x28unsigned0x20int0x2A0x2C0x20unsigned0x20int0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aiterator_traits0x3Cunsigned0x20int0x2A0x3E0x3A0x3Adifference_type0x2C0x20bool0x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_unsigned0x20int0x2A0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fpartial_sort_impl0x5Babi0x3Ann2101050x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x260x2C0x20unsigned0x20int0x2A0x2C0x20unsigned0x20int0x2A0x3E0x28unsigned0x20int0x2A0x2C0x20unsigned0x20int0x2A0x2C0x20unsigned0x20int0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x260x29(w2c_rlbox*, u32, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Apair0x3Cunsigned0x20int0x2A0x2C0x20bool0x3E0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fbitset_partition0x5Babi0x3Ann2101050x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20unsigned0x20int0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x3E0x28unsigned0x20int0x2A0x2C0x20unsigned0x20int0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_bool0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Finsertion_sort_incomplete0x5Babi0x3Ann2101050x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x2C0x20unsigned0x20int0x2A0x3E0x28unsigned0x20int0x2A0x2C0x20unsigned0x20int0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fsort0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Clong0x2C0x20long0x3E0x260x2C0x20long0x2A0x3E0x28long0x2A0x2C0x20long0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Clong0x2C0x20long0x3E0x260x29(w2c_rlbox*, u32, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fintrosort0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x2C0x20long0x2A0x2C0x20true0x3E0x28long0x2A0x2C0x20long0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aiterator_traits0x3Clong0x2A0x3E0x3A0x3Adifference_type0x2C0x20bool0x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_long0x2A0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fpartial_sort_impl0x5Babi0x3Ann2101050x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x260x2C0x20long0x2A0x2C0x20long0x2A0x3E0x28long0x2A0x2C0x20long0x2A0x2C0x20long0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x260x29(w2c_rlbox*, u32, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Apair0x3Clong0x2A0x2C0x20bool0x3E0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fbitset_partition0x5Babi0x3Ann2101050x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20long0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x3E0x28long0x2A0x2C0x20long0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_bool0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Finsertion_sort_incomplete0x5Babi0x3Ann2101050x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x2C0x20long0x2A0x3E0x28long0x2A0x2C0x20long0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fsort0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cunsigned0x20long0x2C0x20unsigned0x20long0x3E0x260x2C0x20unsigned0x20long0x2A0x3E0x28unsigned0x20long0x2A0x2C0x20unsigned0x20long0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cunsigned0x20long0x2C0x20unsigned0x20long0x3E0x260x29(w2c_rlbox*, u32, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fintrosort0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x2C0x20unsigned0x20long0x2A0x2C0x20true0x3E0x28unsigned0x20long0x2A0x2C0x20unsigned0x20long0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aiterator_traits0x3Cunsigned0x20long0x2A0x3E0x3A0x3Adifference_type0x2C0x20bool0x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_unsigned0x20long0x2A0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fpartial_sort_impl0x5Babi0x3Ann2101050x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x260x2C0x20unsigned0x20long0x2A0x2C0x20unsigned0x20long0x2A0x3E0x28unsigned0x20long0x2A0x2C0x20unsigned0x20long0x2A0x2C0x20unsigned0x20long0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x260x29(w2c_rlbox*, u32, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Apair0x3Cunsigned0x20long0x2A0x2C0x20bool0x3E0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fbitset_partition0x5Babi0x3Ann2101050x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20unsigned0x20long0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x3E0x28unsigned0x20long0x2A0x2C0x20unsigned0x20long0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_bool0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Finsertion_sort_incomplete0x5Babi0x3Ann2101050x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x2C0x20unsigned0x20long0x2A0x3E0x28unsigned0x20long0x2A0x2C0x20unsigned0x20long0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fsort0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Clong0x20long0x2C0x20long0x20long0x3E0x260x2C0x20long0x20long0x2A0x3E0x28long0x20long0x2A0x2C0x20long0x20long0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Clong0x20long0x2C0x20long0x20long0x3E0x260x29(w2c_rlbox*, u32, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fintrosort0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x2C0x20long0x20long0x2A0x2C0x20true0x3E0x28long0x20long0x2A0x2C0x20long0x20long0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aiterator_traits0x3Clong0x20long0x2A0x3E0x3A0x3Adifference_type0x2C0x20bool0x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_long0x20long0x2A0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fpartial_sort_impl0x5Babi0x3Ann2101050x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x260x2C0x20long0x20long0x2A0x2C0x20long0x20long0x2A0x3E0x28long0x20long0x2A0x2C0x20long0x20long0x2A0x2C0x20long0x20long0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x260x29(w2c_rlbox*, u32, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Apair0x3Clong0x20long0x2A0x2C0x20bool0x3E0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fbitset_partition0x5Babi0x3Ann2101050x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20long0x20long0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x3E0x28long0x20long0x2A0x2C0x20long0x20long0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_bool0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Finsertion_sort_incomplete0x5Babi0x3Ann2101050x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x2C0x20long0x20long0x2A0x3E0x28long0x20long0x2A0x2C0x20long0x20long0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fsort0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cunsigned0x20long0x20long0x2C0x20unsigned0x20long0x20long0x3E0x260x2C0x20unsigned0x20long0x20long0x2A0x3E0x28unsigned0x20long0x20long0x2A0x2C0x20unsigned0x20long0x20long0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cunsigned0x20long0x20long0x2C0x20unsigned0x20long0x20long0x3E0x260x29(w2c_rlbox*, u32, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fintrosort0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x2C0x20unsigned0x20long0x20long0x2A0x2C0x20true0x3E0x28unsigned0x20long0x20long0x2A0x2C0x20unsigned0x20long0x20long0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aiterator_traits0x3Cunsigned0x20long0x20long0x2A0x3E0x3A0x3Adifference_type0x2C0x20bool0x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_unsigned0x20long0x20long0x2A0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fpartial_sort_impl0x5Babi0x3Ann2101050x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x260x2C0x20unsigned0x20long0x20long0x2A0x2C0x20unsigned0x20long0x20long0x2A0x3E0x28unsigned0x20long0x20long0x2A0x2C0x20unsigned0x20long0x20long0x2A0x2C0x20unsigned0x20long0x20long0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x260x29(w2c_rlbox*, u32, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Apair0x3Cunsigned0x20long0x20long0x2A0x2C0x20bool0x3E0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fbitset_partition0x5Babi0x3Ann2101050x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20unsigned0x20long0x20long0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x3E0x28unsigned0x20long0x20long0x2A0x2C0x20unsigned0x20long0x20long0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_bool0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Finsertion_sort_incomplete0x5Babi0x3Ann2101050x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x2C0x20unsigned0x20long0x20long0x2A0x3E0x28unsigned0x20long0x20long0x2A0x2C0x20unsigned0x20long0x20long0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fsort0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cfloat0x2C0x20float0x3E0x260x2C0x20float0x2A0x3E0x28float0x2A0x2C0x20float0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cfloat0x2C0x20float0x3E0x260x29(w2c_rlbox*, u32, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fintrosort0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x2C0x20float0x2A0x2C0x20true0x3E0x28float0x2A0x2C0x20float0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aiterator_traits0x3Cfloat0x2A0x3E0x3A0x3Adifference_type0x2C0x20bool0x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_float0x2A0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fpartial_sort_impl0x5Babi0x3Ann2101050x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x260x2C0x20float0x2A0x2C0x20float0x2A0x3E0x28float0x2A0x2C0x20float0x2A0x2C0x20float0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x260x29(w2c_rlbox*, u32, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Apair0x3Cfloat0x2A0x2C0x20bool0x3E0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fbitset_partition0x5Babi0x3Ann2101050x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20float0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x3E0x28float0x2A0x2C0x20float0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_bool0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Finsertion_sort_incomplete0x5Babi0x3Ann2101050x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x2C0x20float0x2A0x3E0x28float0x2A0x2C0x20float0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fsort0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cdouble0x2C0x20double0x3E0x260x2C0x20double0x2A0x3E0x28double0x2A0x2C0x20double0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cdouble0x2C0x20double0x3E0x260x29(w2c_rlbox*, u32, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fintrosort0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x2C0x20double0x2A0x2C0x20true0x3E0x28double0x2A0x2C0x20double0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aiterator_traits0x3Cdouble0x2A0x3E0x3A0x3Adifference_type0x2C0x20bool0x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_double0x2A0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fpartial_sort_impl0x5Babi0x3Ann2101050x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x260x2C0x20double0x2A0x2C0x20double0x2A0x3E0x28double0x2A0x2C0x20double0x2A0x2C0x20double0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x260x29(w2c_rlbox*, u32, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Apair0x3Cdouble0x2A0x2C0x20bool0x3E0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fbitset_partition0x5Babi0x3Ann2101050x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20double0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x3E0x28double0x2A0x2C0x20double0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_bool0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Finsertion_sort_incomplete0x5Babi0x3Ann2101050x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x2C0x20double0x2A0x3E0x28double0x2A0x2C0x20double0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fsort0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Clong0x20double0x2C0x20long0x20double0x3E0x260x2C0x20long0x20double0x2A0x3E0x28long0x20double0x2A0x2C0x20long0x20double0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Clong0x20double0x2C0x20long0x20double0x3E0x260x29(w2c_rlbox*, u32, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fintrosort0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x2C0x20long0x20double0x2A0x2C0x20false0x3E0x28long0x20double0x2A0x2C0x20long0x20double0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aiterator_traits0x3Clong0x20double0x2A0x3E0x3A0x3Adifference_type0x2C0x20bool0x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_long0x20double0x2A0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fpartial_sort_impl0x5Babi0x3Ann2101050x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x260x2C0x20long0x20double0x2A0x2C0x20long0x20double0x2A0x3E0x28long0x20double0x2A0x2C0x20long0x20double0x2A0x2C0x20long0x20double0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x260x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_bool0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Finsertion_sort_incomplete0x5Babi0x3Ann2101050x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x2C0x20long0x20double0x2A0x3E0x28long0x20double0x2A0x2C0x20long0x20double0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aranges0x3A0x3Aless0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A_0x5Finit0x28char0x20const0x2A0x2C0x20unsigned0x20long0x29(w2c_rlbox*, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A_0x5Finit0x28unsigned0x20long0x2C0x20char0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3Abasic_string0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x2C0x20unsigned0x20long0x2C0x20unsigned0x20long0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x20const0x260x29(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_string0x280x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3Aoperator0x3D0x28char0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3Aassign0x28unsigned0x20long0x2C0x20char0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3Aassign0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x2C0x20unsigned0x20long0x2C0x20unsigned0x20long0x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A_0x5Fassign_external0x28char0x20const0x2A0x2C0x20unsigned0x20long0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3Aappend0x28unsigned0x20long0x2C0x20char0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3Aappend0x28char0x20const0x2A0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3Aappend0x28char0x20const0x2A0x2C0x20unsigned0x20long0x29(w2c_rlbox*, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A_0x5Fgrow_by_and_replace0x28unsigned0x20long0x2C0x20unsigned0x20long0x2C0x20unsigned0x20long0x2C0x20unsigned0x20long0x2C0x20unsigned0x20long0x2C0x20unsigned0x20long0x2C0x20char0x20const0x2A0x29(w2c_rlbox*, u32, u32, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3Aappend0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x2C0x20unsigned0x20long0x2C0x20unsigned0x20long0x29(w2c_rlbox*, u32, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3Apush_back0x28char0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3Ainsert0x28unsigned0x20long0x2C0x20char0x20const0x2A0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3Ainsert0x28unsigned0x20long0x2C0x20char0x20const0x2A0x2C0x20unsigned0x20long0x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3Ainsert0x28unsigned0x20long0x2C0x20unsigned0x20long0x2C0x20char0x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3Ainsert0x28unsigned0x20long0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x2C0x20unsigned0x20long0x2C0x20unsigned0x20long0x29(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3Ainsert0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Cchar0x20const0x2A0x3E0x2C0x20char0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3Areplace0x28unsigned0x20long0x2C0x20unsigned0x20long0x2C0x20char0x20const0x2A0x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3Areplace0x28unsigned0x20long0x2C0x20unsigned0x20long0x2C0x20char0x20const0x2A0x2C0x20unsigned0x20long0x29(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3Areplace0x28unsigned0x20long0x2C0x20unsigned0x20long0x2C0x20unsigned0x20long0x2C0x20char0x29(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3Areplace0x28unsigned0x20long0x2C0x20unsigned0x20long0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x2C0x20unsigned0x20long0x2C0x20unsigned0x20long0x29(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3Aresize0x28unsigned0x20long0x2C0x20char0x29(w2c_rlbox*, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3Areserve0x28unsigned0x20long0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3Acopy0x28char0x2A0x2C0x20unsigned0x20long0x2C0x20unsigned0x20long0x290x20const(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3Afind0x28char0x2C0x20unsigned0x20long0x290x20const(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3Afind0x28char0x20const0x2A0x2C0x20unsigned0x20long0x2C0x20unsigned0x20long0x290x20const(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3Arfind0x28char0x2C0x20unsigned0x20long0x290x20const(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3Arfind0x28char0x20const0x2A0x2C0x20unsigned0x20long0x2C0x20unsigned0x20long0x290x20const(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3Afind_first_of0x28char0x20const0x2A0x2C0x20unsigned0x20long0x2C0x20unsigned0x20long0x290x20const(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3Afind_last_of0x28char0x20const0x2A0x2C0x20unsigned0x20long0x2C0x20unsigned0x20long0x290x20const(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3Afind_first_not_of0x28char0x20const0x2A0x2C0x20unsigned0x20long0x2C0x20unsigned0x20long0x290x20const(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3Afind_last_not_of0x28char0x20const0x2A0x2C0x20unsigned0x20long0x2C0x20unsigned0x20long0x290x20const(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3Aat0x28unsigned0x20long0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3Aat0x28unsigned0x20long0x290x20const(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3Acompare0x28char0x20const0x2A0x290x20const(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3Acompare0x28unsigned0x20long0x2C0x20unsigned0x20long0x2C0x20char0x20const0x2A0x2C0x20unsigned0x20long0x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3Acompare0x28unsigned0x20long0x2C0x20unsigned0x20long0x2C0x20char0x20const0x2A0x290x20const(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3Acompare0x28unsigned0x20long0x2C0x20unsigned0x20long0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x2C0x20unsigned0x20long0x2C0x20unsigned0x20long0x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A_0x5Finit_copy_ctor_external0x28char0x20const0x2A0x2C0x20unsigned0x20long0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A_0x5Fassign_external0x28char0x20const0x2A0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x260x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A_0x5Fassign_no_alias0x3Cfalse0x3E0x28char0x20const0x2A0x2C0x20unsigned0x20long0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x260x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A_0x5Fassign_no_alias0x3Ctrue0x3E0x28char0x20const0x2A0x2C0x20unsigned0x20long0x29(w2c_rlbox*, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A_0x5Ferase_external_with_move0x28unsigned0x20long0x2C0x20unsigned0x20long0x29(w2c_rlbox*, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cwchar_t0x3E0x3E0x3A0x3A_0x5Finit0x28wchar_t0x20const0x2A0x2C0x20unsigned0x20long0x29(w2c_rlbox*, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cwchar_t0x3E0x3E0x3A0x3A_0x5Fthrow_length_error0x5Babi0x3Ann2101050x5D0x280x29(w2c_rlbox*);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cwchar_t0x3E0x3E0x3A0x3A_0x5Finit0x28unsigned0x20long0x2C0x20wchar_t0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cwchar_t0x3E0x3E0x3A0x3Abasic_string0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cwchar_t0x3E0x3E0x20const0x260x2C0x20unsigned0x20long0x2C0x20unsigned0x20long0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cwchar_t0x3E0x20const0x260x29(w2c_rlbox*, u32, u32, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cwchar_t0x3E0x3E0x3A0x3A_0x5Fthrow_out_of_range0x5Babi0x3Ann2101050x5D0x280x29(w2c_rlbox*);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cwchar_t0x3E0x3E0x3A0x3A0x7Ebasic_string0x280x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cwchar_t0x3E0x3E0x3A0x3Aoperator0x3D0x28wchar_t0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cwchar_t0x3E0x3E0x3A0x3Aassign0x28unsigned0x20long0x2C0x20wchar_t0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cwchar_t0x3E0x3E0x3A0x3Aassign0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cwchar_t0x3E0x3E0x20const0x260x2C0x20unsigned0x20long0x2C0x20unsigned0x20long0x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cwchar_t0x3E0x3E0x3A0x3A_0x5Fassign_external0x28wchar_t0x20const0x2A0x2C0x20unsigned0x20long0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cwchar_t0x3E0x3E0x3A0x3Aappend0x28unsigned0x20long0x2C0x20wchar_t0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cwchar_t0x3E0x3E0x3A0x3Aappend0x28wchar_t0x20const0x2A0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cwchar_t0x3E0x3E0x3A0x3A_0x5Fgrow_by_and_replace0x28unsigned0x20long0x2C0x20unsigned0x20long0x2C0x20unsigned0x20long0x2C0x20unsigned0x20long0x2C0x20unsigned0x20long0x2C0x20unsigned0x20long0x2C0x20wchar_t0x20const0x2A0x29(w2c_rlbox*, u32, u32, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cwchar_t0x3E0x3E0x3A0x3Aappend0x28wchar_t0x20const0x2A0x2C0x20unsigned0x20long0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cwchar_t0x3E0x3E0x3A0x3Aappend0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cwchar_t0x3E0x3E0x20const0x260x2C0x20unsigned0x20long0x2C0x20unsigned0x20long0x29(w2c_rlbox*, u32, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cwchar_t0x3E0x3E0x3A0x3Apush_back0x28wchar_t0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cwchar_t0x3E0x3E0x3A0x3Ainsert0x28unsigned0x20long0x2C0x20wchar_t0x20const0x2A0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cwchar_t0x3E0x3E0x3A0x3Ainsert0x28unsigned0x20long0x2C0x20wchar_t0x20const0x2A0x2C0x20unsigned0x20long0x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cwchar_t0x3E0x3E0x3A0x3Ainsert0x28unsigned0x20long0x2C0x20unsigned0x20long0x2C0x20wchar_t0x29(w2c_rlbox*, u32, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cwchar_t0x3E0x3E0x3A0x3A_0x5Fgrow_by0x5Babi0x3Ann2101050x5D0x28unsigned0x20long0x2C0x20unsigned0x20long0x2C0x20unsigned0x20long0x2C0x20unsigned0x20long0x2C0x20unsigned0x20long0x2C0x20unsigned0x20long0x29(w2c_rlbox*, u32, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cwchar_t0x3E0x3E0x3A0x3Ainsert0x28unsigned0x20long0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cwchar_t0x3E0x3E0x20const0x260x2C0x20unsigned0x20long0x2C0x20unsigned0x20long0x29(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cwchar_t0x3E0x3E0x3A0x3Ainsert0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Cwchar_t0x20const0x2A0x3E0x2C0x20wchar_t0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cwchar_t0x3E0x3E0x3A0x3Areplace0x28unsigned0x20long0x2C0x20unsigned0x20long0x2C0x20wchar_t0x20const0x2A0x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cwchar_t0x3E0x3E0x3A0x3Areplace0x28unsigned0x20long0x2C0x20unsigned0x20long0x2C0x20wchar_t0x20const0x2A0x2C0x20unsigned0x20long0x29(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cwchar_t0x3E0x3E0x3A0x3Areplace0x28unsigned0x20long0x2C0x20unsigned0x20long0x2C0x20unsigned0x20long0x2C0x20wchar_t0x29(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cwchar_t0x3E0x3E0x3A0x3Areplace0x28unsigned0x20long0x2C0x20unsigned0x20long0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cwchar_t0x3E0x3E0x20const0x260x2C0x20unsigned0x20long0x2C0x20unsigned0x20long0x29(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cwchar_t0x3E0x3E0x3A0x3Aresize0x28unsigned0x20long0x2C0x20wchar_t0x29(w2c_rlbox*, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cwchar_t0x3E0x3E0x3A0x3Areserve0x28unsigned0x20long0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cwchar_t0x3E0x3E0x3A0x3Acopy0x28wchar_t0x2A0x2C0x20unsigned0x20long0x2C0x20unsigned0x20long0x290x20const(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cwchar_t0x3E0x3E0x3A0x3Afind0x28wchar_t0x2C0x20unsigned0x20long0x290x20const(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cwchar_t0x3E0x3E0x3A0x3Afind0x28wchar_t0x20const0x2A0x2C0x20unsigned0x20long0x2C0x20unsigned0x20long0x290x20const(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cwchar_t0x3E0x3E0x3A0x3Arfind0x28wchar_t0x2C0x20unsigned0x20long0x290x20const(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cwchar_t0x3E0x3E0x3A0x3Arfind0x28wchar_t0x20const0x2A0x2C0x20unsigned0x20long0x2C0x20unsigned0x20long0x290x20const(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cwchar_t0x3E0x3E0x3A0x3Afind_first_of0x28wchar_t0x20const0x2A0x2C0x20unsigned0x20long0x2C0x20unsigned0x20long0x290x20const(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cwchar_t0x3E0x3E0x3A0x3Afind_last_of0x28wchar_t0x20const0x2A0x2C0x20unsigned0x20long0x2C0x20unsigned0x20long0x290x20const(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cwchar_t0x3E0x3E0x3A0x3Afind_first_not_of0x28wchar_t0x20const0x2A0x2C0x20unsigned0x20long0x2C0x20unsigned0x20long0x290x20const(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cwchar_t0x3E0x3E0x3A0x3Afind_last_not_of0x28wchar_t0x20const0x2A0x2C0x20unsigned0x20long0x2C0x20unsigned0x20long0x290x20const(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cwchar_t0x3E0x3E0x3A0x3Aat0x28unsigned0x20long0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cwchar_t0x3E0x3E0x3A0x3Aat0x28unsigned0x20long0x290x20const(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cwchar_t0x3E0x3E0x3A0x3Acompare0x28wchar_t0x20const0x2A0x290x20const(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cwchar_t0x3E0x3E0x3A0x3Acompare0x28unsigned0x20long0x2C0x20unsigned0x20long0x2C0x20wchar_t0x20const0x2A0x2C0x20unsigned0x20long0x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cwchar_t0x3E0x3E0x3A0x3Acompare0x28unsigned0x20long0x2C0x20unsigned0x20long0x2C0x20wchar_t0x20const0x2A0x290x20const(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cwchar_t0x3E0x3E0x3A0x3Acompare0x28unsigned0x20long0x2C0x20unsigned0x20long0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cwchar_t0x3E0x3E0x20const0x260x2C0x20unsigned0x20long0x2C0x20unsigned0x20long0x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cwchar_t0x3E0x3E0x3A0x3A_0x5Finit_copy_ctor_external0x28wchar_t0x20const0x2A0x2C0x20unsigned0x20long0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cwchar_t0x3E0x3E0x3A0x3A_0x5Fassign_external0x28wchar_t0x20const0x2A0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cwchar_t0x3E0x3E0x260x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cwchar_t0x3E0x3E0x3A0x3A_0x5Fassign_no_alias0x3Cfalse0x3E0x28wchar_t0x20const0x2A0x2C0x20unsigned0x20long0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cwchar_t0x3E0x3E0x260x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cwchar_t0x3E0x3E0x3A0x3A_0x5Fassign_no_alias0x3Ctrue0x3E0x28wchar_t0x20const0x2A0x2C0x20unsigned0x20long0x29(w2c_rlbox*, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cwchar_t0x3E0x3E0x3A0x3A_0x5Ferase_external_with_move0x28unsigned0x20long0x2C0x20unsigned0x20long0x29(w2c_rlbox*, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20std0x3A0x3A_0x5F20x3A0x3Aoperator0x2B0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x28char0x20const0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Astoi0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x2C0x20unsigned0x20long0x2A0x2C0x20int0x29(w2c_rlbox*, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20std0x3A0x3A_0x5F20x3A0x3Aoperator0x2B0x5Babi0x3Ann2101050x5D0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x2C0x20char0x20const0x2A0x29(w2c_rlbox*, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fthrow_invalid_argument0x5Babi0x3Ann2101050x5D0x28char0x20const0x2A0x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Astol0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x2C0x20unsigned0x20long0x2A0x2C0x20int0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Astoul0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x2C0x20unsigned0x20long0x2A0x2C0x20int0x29(w2c_rlbox*, u32, u32, u32);
static u64 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Astoll0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x2C0x20unsigned0x20long0x2A0x2C0x20int0x29(w2c_rlbox*, u32, u32, u32);
static u64 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Astoull0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x2C0x20unsigned0x20long0x2A0x2C0x20int0x29(w2c_rlbox*, u32, u32, u32);
static f32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Astof0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x2C0x20unsigned0x20long0x2A0x29(w2c_rlbox*, u32, u32);
static f64 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Astod0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x2C0x20unsigned0x20long0x2A0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Astold0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x2C0x20unsigned0x20long0x2A0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Astoi0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cwchar_t0x3E0x3E0x20const0x260x2C0x20unsigned0x20long0x2A0x2C0x20int0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Astol0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cwchar_t0x3E0x3E0x20const0x260x2C0x20unsigned0x20long0x2A0x2C0x20int0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Astoul0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cwchar_t0x3E0x3E0x20const0x260x2C0x20unsigned0x20long0x2A0x2C0x20int0x29(w2c_rlbox*, u32, u32, u32);
static u64 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Astoll0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cwchar_t0x3E0x3E0x20const0x260x2C0x20unsigned0x20long0x2A0x2C0x20int0x29(w2c_rlbox*, u32, u32, u32);
static u64 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Astoull0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cwchar_t0x3E0x3E0x20const0x260x2C0x20unsigned0x20long0x2A0x2C0x20int0x29(w2c_rlbox*, u32, u32, u32);
static f32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Astof0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cwchar_t0x3E0x3E0x20const0x260x2C0x20unsigned0x20long0x2A0x29(w2c_rlbox*, u32, u32);
static f64 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Astod0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cwchar_t0x3E0x3E0x20const0x260x2C0x20unsigned0x20long0x2A0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Astold0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cwchar_t0x3E0x3E0x20const0x260x2C0x20unsigned0x20long0x2A0x29(w2c_rlbox*, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Ato_string0x28int0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fitoa0x3A0x3A_0x5Fbase_10_u320x5Babi0x3Ann2101050x5D0x28char0x2A0x2C0x20unsigned0x20int0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Ato_string0x28long0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Ato_string0x28long0x20long0x29(w2c_rlbox*, u32, u64);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Ato_string0x28unsigned0x20int0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Ato_string0x28unsigned0x20long0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Ato_string0x28unsigned0x20long0x20long0x29(w2c_rlbox*, u32, u64);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Ato_wstring0x28int0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Ato_wstring0x28long0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Ato_wstring0x28long0x20long0x29(w2c_rlbox*, u32, u64);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Ato_wstring0x28unsigned0x20int0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Ato_wstring0x28unsigned0x20long0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Ato_wstring0x28unsigned0x20long0x20long0x29(w2c_rlbox*, u32, u64);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Ato_string0x28float0x29(w2c_rlbox*, u32, f32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Ato_string0x28double0x29(w2c_rlbox*, u32, f64);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Ato_string0x28long0x20double0x29(w2c_rlbox*, u32, u64, u64);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Ato_wstring0x28float0x29(w2c_rlbox*, u32, f32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Ato_wstring0x28double0x29(w2c_rlbox*, u32, f64);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Ato_wstring0x28long0x20double0x29(w2c_rlbox*, u32, u64, u64);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Flibcpp_verbose_abort0x28char0x20const0x2A0x2C0x200x2E0x2E0x2E0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3Alogic_error0x3A0x3Alogic_error0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3Alogic_error0x3A0x3Alogic_error0x28char0x20const0x2A0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3Alogic_error0x3A0x3Alogic_error0x28std0x3A0x3Alogic_error0x20const0x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3Alogic_error0x3A0x3Aoperator0x3D0x28std0x3A0x3Alogic_error0x20const0x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3Aruntime_error0x3A0x3Aruntime_error0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3Aruntime_error0x3A0x3Aruntime_error0x28char0x20const0x2A0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3Aruntime_error0x3A0x3Aruntime_error0x28std0x3A0x3Aruntime_error0x20const0x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3Aruntime_error0x3A0x3Aoperator0x3D0x28std0x3A0x3Aruntime_error0x20const0x260x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fthrow_runtime_error0x28char0x20const0x2A0x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Aerror_category0x3A0x3A0x7Eerror_category0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Aerror_category0x3A0x3A0x7Eerror_category0x280x290x2E1(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Aerror_category0x3A0x3Adefault_error_condition0x28int0x290x20const(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Aerror_category0x3A0x3Aequivalent0x28int0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aerror_condition0x20const0x260x290x20const(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Aerror_category0x3A0x3Aequivalent0x28std0x3A0x3A_0x5F20x3A0x3Aerror_code0x20const0x260x2C0x20int0x290x20const(w2c_rlbox*, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fdo_message0x3A0x3Amessage0x28int0x290x20const(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fgeneric_error_category0x3A0x3Aname0x280x290x20const(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fgeneric_error_category0x3A0x3Amessage0x28int0x290x20const(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Ageneric_category0x280x29(w2c_rlbox*);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fsystem_error_category0x3A0x3Aname0x280x290x20const(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fsystem_error_category0x3A0x3Amessage0x28int0x290x20const(w2c_rlbox*, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fsystem_error_category0x3A0x3Adefault_error_condition0x28int0x290x20const(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Asystem_category0x280x29(w2c_rlbox*);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Aerror_condition0x3A0x3Amessage0x280x290x20const(w2c_rlbox*, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Aerror_code0x3A0x3Amessage0x280x290x20const(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Asystem_error0x3A0x3Asystem_error0x28std0x3A0x3A_0x5F20x3A0x3Aerror_code0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Asystem_error0x3A0x3Asystem_error0x28std0x3A0x3A_0x5F20x3A0x3Aerror_code0x2C0x20char0x20const0x2A0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Asystem_error0x3A0x3Asystem_error0x28std0x3A0x3A_0x5F20x3A0x3Aerror_code0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Asystem_error0x3A0x3Asystem_error0x28int0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aerror_category0x20const0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Asystem_error0x3A0x3Asystem_error0x28int0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aerror_category0x20const0x260x2C0x20char0x20const0x2A0x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Asystem_error0x3A0x3Asystem_error0x28int0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aerror_category0x20const0x260x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Asystem_error0x3A0x3A0x7Esystem_error0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Asystem_error0x3A0x3A0x7Esystem_error0x280x290x2E1(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fthrow_system_error0x28int0x2C0x20char0x20const0x2A0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fdo_message0x3A0x3A0x7E_0x5Fdo_message0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fgeneric_error_category0x3A0x3A0x7E_0x5Fgeneric_error_category0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fsystem_error_category0x3A0x3A0x7E_0x5Fsystem_error_category0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5Fthrow_bad_alloc0x280x29(w2c_rlbox*);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fiostream_category0x3A0x3Aname0x280x290x20const(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fiostream_category0x3A0x3Amessage0x28int0x290x20const(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Aiostream_category0x280x29(w2c_rlbox*);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Aios_base0x3A0x3Afailure0x3A0x3Afailure0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Aerror_code0x20const0x260x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Aios_base0x3A0x3Afailure0x3A0x3Afailure0x28char0x20const0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aerror_code0x20const0x260x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Aios_base0x3A0x3Afailure0x3A0x3A0x7Efailure0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Aios_base0x3A0x3Afailure0x3A0x3A0x7Efailure0x280x290x2E1(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Aios_base0x3A0x3A_0x5Fcall_callbacks0x28std0x3A0x3A_0x5F20x3A0x3Aios_base0x3A0x3Aevent0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Aios_base0x3A0x3Aimbue0x28std0x3A0x3A_0x5F20x3A0x3Alocale0x20const0x260x29(w2c_rlbox*, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Aios_base0x3A0x3Agetloc0x280x290x20const(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Aios_base0x3A0x3Axalloc0x280x29(w2c_rlbox*);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Aios_base0x3A0x3Aiword0x28int0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fthrow_failure0x5Babi0x3Ann2101050x5D0x28char0x20const0x2A0x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Aios_base0x3A0x3Apword0x28int0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Aios_base0x3A0x3Aregister_callback0x28void0x200x280x2A0x290x28std0x3A0x3A_0x5F20x3A0x3Aios_base0x3A0x3Aevent0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20int0x290x2C0x20int0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Aios_base0x3A0x3A0x7Eios_base0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Aios_base0x3A0x3A0x7Eios_base0x280x290x2E1(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Aios_base0x3A0x3Aclear0x28unsigned0x20int0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Aios_base0x3A0x3Ainit0x28void0x2A0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Aios_base0x3A0x3Acopyfmt0x28std0x3A0x3A_0x5F20x3A0x3Aios_base0x20const0x260x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Aios_base0x3A0x3Amove0x28std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Aios_base0x3A0x3Aswap0x28std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Aios_base0x3A0x3A_0x5Fset_badbit_and_consider_rethrow0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Aios_base0x3A0x3A_0x5Fset_failbit_and_consider_rethrow0x280x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Aios_base0x3A0x3Async_with_stdio0x28bool0x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fiostream_category0x3A0x3A0x7E_0x5Fiostream_category0x280x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3Auncaught_exception0x280x29(w2c_rlbox*);
static u32 w2c_rlbox_std0x3A0x3Auncaught_exceptions0x280x29(w2c_rlbox*);
static u32 w2c_rlbox_std0x3A0x3Aexception_ptr0x3A0x3A0x7Eexception_ptr0x280x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3Aexception_ptr0x3A0x3Aexception_ptr0x28std0x3A0x3Aexception_ptr0x20const0x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3Aexception_ptr0x3A0x3Aoperator0x3D0x28std0x3A0x3Aexception_ptr0x20const0x260x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_std0x3A0x3Aexception_ptr0x3A0x3A_0x5Ffrom_native_exception_pointer0x28void0x2A0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3Anested_exception0x3A0x3Anested_exception0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3Acurrent_exception0x280x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3Anested_exception0x3A0x3A0x7Enested_exception0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3Anested_exception0x3A0x3A0x7Enested_exception0x280x290x2E1(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3Anested_exception0x3A0x3Arethrow_nested0x280x290x20const(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3Arethrow_exception0x28std0x3A0x3Aexception_ptr0x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_ios0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_ios0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_ios0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_ios0x280x290x2E1(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_ios0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Acopyfmt0x28std0x3A0x3A_0x5F20x3A0x3Abasic_ios0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x20const0x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_streambuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_streambuf0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_streambuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_streambuf0x280x290x2E1(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_streambuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Abasic_streambuf0x280x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_streambuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Abasic_streambuf0x28std0x3A0x3A_0x5F20x3A0x3Abasic_streambuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x20const0x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_streambuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Aoperator0x3D0x28std0x3A0x3A_0x5F20x3A0x3Abasic_streambuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x20const0x260x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_streambuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Aswap0x28std0x3A0x3A_0x5F20x3A0x3Abasic_streambuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x260x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_streambuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Aimbue0x28std0x3A0x3A_0x5F20x3A0x3Alocale0x20const0x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_streambuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Asetbuf0x28char0x2A0x2C0x20long0x29(w2c_rlbox*, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_streambuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Aseekoff0x28long0x20long0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x3A0x3Aseekdir0x2C0x20unsigned0x20int0x29(w2c_rlbox*, u32, u32, u64, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_streambuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Aseekpos0x28std0x3A0x3A_0x5F20x3A0x3Afpos0x3C_0x5Fmbstate_t0x3E0x2C0x20unsigned0x20int0x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_streambuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Async0x280x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_streambuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Ashowmanyc0x280x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_streambuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Axsgetn0x28char0x2A0x2C0x20long0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_streambuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Aunderflow0x280x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_streambuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Auflow0x280x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_streambuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Apbackfail0x28int0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_streambuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Axsputn0x28char0x20const0x2A0x2C0x20long0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_streambuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Aoverflow0x28int0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_istream0x280x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_istream0x280x290x2E1(w2c_rlbox*, u32);
static u32 w2c_rlbox_virtual0x20thunk0x20to0x20std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_istream0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_istream0x280x290x2E2(w2c_rlbox*, u32);
static void w2c_rlbox_virtual0x20thunk0x20to0x20std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_istream0x280x290x2E1(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Asentry0x3A0x3Asentry0x28std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x260x2C0x20bool0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_ostream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Aflush0x280x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Aoperator0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Abasic_streambuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2A0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Aoperator0x3E0x3E0x28bool0x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x260x20std0x3A0x3A_0x5F20x3A0x3A_0x5Finput_arithmetic0x5Babi0x3Ann2101050x5D0x3Cbool0x2C0x20char0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x260x2C0x20bool0x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Aoperator0x3E0x3E0x28short0x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x260x20std0x3A0x3A_0x5F20x3A0x3A_0x5Finput_arithmetic_with_numeric_limits0x5Babi0x3Ann2101050x5D0x3Cshort0x2C0x20char0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x260x2C0x20short0x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Aoperator0x3E0x3E0x28unsigned0x20short0x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x260x20std0x3A0x3A_0x5F20x3A0x3A_0x5Finput_arithmetic0x5Babi0x3Ann2101050x5D0x3Cunsigned0x20short0x2C0x20char0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x260x2C0x20unsigned0x20short0x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Aoperator0x3E0x3E0x28int0x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x260x20std0x3A0x3A_0x5F20x3A0x3A_0x5Finput_arithmetic_with_numeric_limits0x5Babi0x3Ann2101050x5D0x3Cint0x2C0x20char0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x260x2C0x20int0x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Aoperator0x3E0x3E0x28unsigned0x20int0x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x260x20std0x3A0x3A_0x5F20x3A0x3A_0x5Finput_arithmetic0x5Babi0x3Ann2101050x5D0x3Cunsigned0x20int0x2C0x20char0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x260x2C0x20unsigned0x20int0x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Aoperator0x3E0x3E0x28long0x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x260x20std0x3A0x3A_0x5F20x3A0x3A_0x5Finput_arithmetic0x5Babi0x3Ann2101050x5D0x3Clong0x2C0x20char0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x260x2C0x20long0x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Aoperator0x3E0x3E0x28unsigned0x20long0x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x260x20std0x3A0x3A_0x5F20x3A0x3A_0x5Finput_arithmetic0x5Babi0x3Ann2101050x5D0x3Cunsigned0x20long0x2C0x20char0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x260x2C0x20unsigned0x20long0x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Aoperator0x3E0x3E0x28long0x20long0x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x260x20std0x3A0x3A_0x5F20x3A0x3A_0x5Finput_arithmetic0x5Babi0x3Ann2101050x5D0x3Clong0x20long0x2C0x20char0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x260x2C0x20long0x20long0x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Aoperator0x3E0x3E0x28unsigned0x20long0x20long0x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x260x20std0x3A0x3A_0x5F20x3A0x3A_0x5Finput_arithmetic0x5Babi0x3Ann2101050x5D0x3Cunsigned0x20long0x20long0x2C0x20char0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x260x2C0x20unsigned0x20long0x20long0x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Aoperator0x3E0x3E0x28float0x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x260x20std0x3A0x3A_0x5F20x3A0x3A_0x5Finput_arithmetic0x5Babi0x3Ann2101050x5D0x3Cfloat0x2C0x20char0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x260x2C0x20float0x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Aoperator0x3E0x3E0x28double0x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x260x20std0x3A0x3A_0x5F20x3A0x3A_0x5Finput_arithmetic0x5Babi0x3Ann2101050x5D0x3Cdouble0x2C0x20char0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x260x2C0x20double0x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Aoperator0x3E0x3E0x28long0x20double0x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x260x20std0x3A0x3A_0x5F20x3A0x3A_0x5Finput_arithmetic0x5Babi0x3Ann2101050x5D0x3Clong0x20double0x2C0x20char0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x260x2C0x20long0x20double0x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Aoperator0x3E0x3E0x28void0x2A0x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x260x20std0x3A0x3A_0x5F20x3A0x3A_0x5Finput_arithmetic0x5Babi0x3Ann2101050x5D0x3Cvoid0x2A0x2C0x20char0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x260x2C0x20void0x2A0x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Aget0x280x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Aget0x28char0x2A0x2C0x20long0x2C0x20char0x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Aget0x28std0x3A0x3A_0x5F20x3A0x3Abasic_streambuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x260x2C0x20char0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Agetline0x28char0x2A0x2C0x20long0x2C0x20char0x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Aignore0x28long0x2C0x20int0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Apeek0x280x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Aread0x28char0x2A0x2C0x20long0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Areadsome0x28char0x2A0x2C0x20long0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Aputback0x28char0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Aunget0x280x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Async0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Atellg0x280x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Aseekg0x28std0x3A0x3A_0x5F20x3A0x3Afpos0x3C_0x5Fmbstate_t0x3E0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Aseekg0x28long0x20long0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x3A0x3Aseekdir0x29(w2c_rlbox*, u32, u64, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_ostream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_ostream0x280x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_ostream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_ostream0x280x290x2E1(w2c_rlbox*, u32);
static u32 w2c_rlbox_virtual0x20thunk0x20to0x20std0x3A0x3A_0x5F20x3A0x3Abasic_ostream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_ostream0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_ostream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_ostream0x280x290x2E2(w2c_rlbox*, u32);
static void w2c_rlbox_virtual0x20thunk0x20to0x20std0x3A0x3A_0x5F20x3A0x3Abasic_ostream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_ostream0x280x290x2E1(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_ostream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Asentry0x3A0x3Asentry0x28std0x3A0x3A_0x5F20x3A0x3Abasic_ostream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_ostream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Asentry0x3A0x3A0x7Esentry0x280x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_ostream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Aoperator0x3C0x3C0x28bool0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_ostream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x260x20std0x3A0x3A_0x5F20x3A0x3Abasic_ostream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3A_0x5Fput_num0x5Babi0x3Ann2101050x5D0x3Cbool0x3E0x28bool0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_ostream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Aoperator0x3C0x3C0x28short0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_ostream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x260x20std0x3A0x3A_0x5F20x3A0x3Abasic_ostream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3A_0x5Fput_num_integer_promote0x5Babi0x3Ann2101050x5D0x3Cshort0x3E0x28short0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_ostream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Aoperator0x3C0x3C0x28unsigned0x20short0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_ostream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x260x20std0x3A0x3A_0x5F20x3A0x3Abasic_ostream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3A_0x5Fput_num_integer_promote0x5Babi0x3Ann2101050x5D0x3Cunsigned0x20short0x3E0x28unsigned0x20short0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_ostream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Aoperator0x3C0x3C0x28int0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_ostream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x260x20std0x3A0x3A_0x5F20x3A0x3Abasic_ostream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3A_0x5Fput_num_integer_promote0x5Babi0x3Ann2101050x5D0x3Cint0x3E0x28int0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_ostream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Aoperator0x3C0x3C0x28unsigned0x20int0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_ostream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x260x20std0x3A0x3A_0x5F20x3A0x3Abasic_ostream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3A_0x5Fput_num_integer_promote0x5Babi0x3Ann2101050x5D0x3Cunsigned0x20int0x3E0x28unsigned0x20int0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_ostream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Aoperator0x3C0x3C0x28long0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_ostream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x260x20std0x3A0x3A_0x5F20x3A0x3Abasic_ostream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3A_0x5Fput_num0x5Babi0x3Ann2101050x5D0x3Clong0x3E0x28long0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_ostream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Aoperator0x3C0x3C0x28unsigned0x20long0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_ostream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x260x20std0x3A0x3A_0x5F20x3A0x3Abasic_ostream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3A_0x5Fput_num0x5Babi0x3Ann2101050x5D0x3Cunsigned0x20long0x3E0x28unsigned0x20long0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_ostream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Aoperator0x3C0x3C0x28long0x20long0x29(w2c_rlbox*, u32, u64);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_ostream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x260x20std0x3A0x3A_0x5F20x3A0x3Abasic_ostream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3A_0x5Fput_num0x5Babi0x3Ann2101050x5D0x3Clong0x20long0x3E0x28long0x20long0x29(w2c_rlbox*, u32, u64);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_ostream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Aoperator0x3C0x3C0x28unsigned0x20long0x20long0x29(w2c_rlbox*, u32, u64);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_ostream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x260x20std0x3A0x3A_0x5F20x3A0x3Abasic_ostream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3A_0x5Fput_num0x5Babi0x3Ann2101050x5D0x3Cunsigned0x20long0x20long0x3E0x28unsigned0x20long0x20long0x29(w2c_rlbox*, u32, u64);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_ostream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Aoperator0x3C0x3C0x28float0x29(w2c_rlbox*, u32, f32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_ostream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x260x20std0x3A0x3A_0x5F20x3A0x3Abasic_ostream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3A_0x5Fput_num0x5Babi0x3Ann2101050x5D0x3Cdouble0x3E0x28double0x29(w2c_rlbox*, u32, f64);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_ostream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Aoperator0x3C0x3C0x28double0x29(w2c_rlbox*, u32, f64);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_ostream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Aoperator0x3C0x3C0x28long0x20double0x29(w2c_rlbox*, u32, u64, u64);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_ostream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x260x20std0x3A0x3A_0x5F20x3A0x3Abasic_ostream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3A_0x5Fput_num0x5Babi0x3Ann2101050x5D0x3Clong0x20double0x3E0x28long0x20double0x29(w2c_rlbox*, u32, u64, u64);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_ostream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Aoperator0x3C0x3C0x28void0x20const0x2A0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_ostream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x260x20std0x3A0x3A_0x5F20x3A0x3Abasic_ostream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3A_0x5Fput_num0x5Babi0x3Ann2101050x5D0x3Cvoid0x20const0x2A0x3E0x28void0x20const0x2A0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_ostream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Aoperator0x3C0x3C0x28std0x3A0x3A_0x5F20x3A0x3Abasic_streambuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2A0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_ostream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Aput0x28char0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_ostream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Awrite0x28char0x20const0x2A0x2C0x20long0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_iostream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_iostream0x280x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_iostream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_iostream0x280x290x2E1(w2c_rlbox*, u32);
static u32 w2c_rlbox_non0x2Dvirtual0x20thunk0x20to0x20std0x3A0x3A_0x5F20x3A0x3Abasic_iostream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_iostream0x280x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_virtual0x20thunk0x20to0x20std0x3A0x3A_0x5F20x3A0x3Abasic_iostream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_iostream0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_iostream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_iostream0x280x290x2E2(w2c_rlbox*, u32);
static void w2c_rlbox_non0x2Dvirtual0x20thunk0x20to0x20std0x3A0x3A_0x5F20x3A0x3Abasic_iostream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_iostream0x280x290x2E1(w2c_rlbox*, u32);
static void w2c_rlbox_virtual0x20thunk0x20to0x20std0x3A0x3A_0x5F20x3A0x3Abasic_iostream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_iostream0x280x290x2E1(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_ios0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3A0x7Ebasic_ios0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_ios0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3A0x7Ebasic_ios0x280x290x2E1(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_ios0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3Acopyfmt0x28std0x3A0x3A_0x5F20x3A0x3Abasic_ios0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x20const0x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_streambuf0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3A0x7Ebasic_streambuf0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_streambuf0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3A0x7Ebasic_streambuf0x280x290x2E1(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_streambuf0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3Abasic_streambuf0x280x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_streambuf0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3Abasic_streambuf0x28std0x3A0x3A_0x5F20x3A0x3Abasic_streambuf0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x20const0x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_streambuf0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3Aoperator0x3D0x28std0x3A0x3A_0x5F20x3A0x3Abasic_streambuf0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x20const0x260x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_streambuf0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3Aswap0x28std0x3A0x3A_0x5F20x3A0x3Abasic_streambuf0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x260x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_streambuf0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3Aimbue0x28std0x3A0x3A_0x5F20x3A0x3Alocale0x20const0x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_streambuf0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3Asetbuf0x28wchar_t0x2A0x2C0x20long0x29(w2c_rlbox*, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_streambuf0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3Aseekoff0x28long0x20long0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x3A0x3Aseekdir0x2C0x20unsigned0x20int0x29(w2c_rlbox*, u32, u32, u64, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_streambuf0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3Aseekpos0x28std0x3A0x3A_0x5F20x3A0x3Afpos0x3C_0x5Fmbstate_t0x3E0x2C0x20unsigned0x20int0x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_streambuf0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3Async0x280x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_streambuf0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3Ashowmanyc0x280x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_streambuf0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3Axsgetn0x28wchar_t0x2A0x2C0x20long0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_streambuf0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3Aunderflow0x280x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_streambuf0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3Auflow0x280x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_streambuf0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3Apbackfail0x28int0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_streambuf0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3Axsputn0x28wchar_t0x20const0x2A0x2C0x20long0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_streambuf0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3Aoverflow0x28int0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3A0x7Ebasic_istream0x280x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3A0x7Ebasic_istream0x280x290x2E1(w2c_rlbox*, u32);
static u32 w2c_rlbox_virtual0x20thunk0x20to0x20std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3A0x7Ebasic_istream0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3A0x7Ebasic_istream0x280x290x2E2(w2c_rlbox*, u32);
static void w2c_rlbox_virtual0x20thunk0x20to0x20std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3A0x7Ebasic_istream0x280x290x2E1(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3Asentry0x3A0x3Asentry0x28std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x260x2C0x20bool0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_ostream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3Aflush0x280x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3Aoperator0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Abasic_streambuf0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2A0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3Aoperator0x3E0x3E0x28bool0x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x260x20std0x3A0x3A_0x5F20x3A0x3A_0x5Finput_arithmetic0x5Babi0x3Ann2101050x5D0x3Cbool0x2C0x20wchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x260x2C0x20bool0x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3Aoperator0x3E0x3E0x28short0x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x260x20std0x3A0x3A_0x5F20x3A0x3A_0x5Finput_arithmetic_with_numeric_limits0x5Babi0x3Ann2101050x5D0x3Cshort0x2C0x20wchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x260x2C0x20short0x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3Aoperator0x3E0x3E0x28unsigned0x20short0x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x260x20std0x3A0x3A_0x5F20x3A0x3A_0x5Finput_arithmetic0x5Babi0x3Ann2101050x5D0x3Cunsigned0x20short0x2C0x20wchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x260x2C0x20unsigned0x20short0x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3Aoperator0x3E0x3E0x28int0x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x260x20std0x3A0x3A_0x5F20x3A0x3A_0x5Finput_arithmetic_with_numeric_limits0x5Babi0x3Ann2101050x5D0x3Cint0x2C0x20wchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x260x2C0x20int0x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3Aoperator0x3E0x3E0x28unsigned0x20int0x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x260x20std0x3A0x3A_0x5F20x3A0x3A_0x5Finput_arithmetic0x5Babi0x3Ann2101050x5D0x3Cunsigned0x20int0x2C0x20wchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x260x2C0x20unsigned0x20int0x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3Aoperator0x3E0x3E0x28long0x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x260x20std0x3A0x3A_0x5F20x3A0x3A_0x5Finput_arithmetic0x5Babi0x3Ann2101050x5D0x3Clong0x2C0x20wchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x260x2C0x20long0x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3Aoperator0x3E0x3E0x28unsigned0x20long0x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x260x20std0x3A0x3A_0x5F20x3A0x3A_0x5Finput_arithmetic0x5Babi0x3Ann2101050x5D0x3Cunsigned0x20long0x2C0x20wchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x260x2C0x20unsigned0x20long0x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3Aoperator0x3E0x3E0x28long0x20long0x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x260x20std0x3A0x3A_0x5F20x3A0x3A_0x5Finput_arithmetic0x5Babi0x3Ann2101050x5D0x3Clong0x20long0x2C0x20wchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x260x2C0x20long0x20long0x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3Aoperator0x3E0x3E0x28unsigned0x20long0x20long0x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x260x20std0x3A0x3A_0x5F20x3A0x3A_0x5Finput_arithmetic0x5Babi0x3Ann2101050x5D0x3Cunsigned0x20long0x20long0x2C0x20wchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x260x2C0x20unsigned0x20long0x20long0x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3Aoperator0x3E0x3E0x28float0x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x260x20std0x3A0x3A_0x5F20x3A0x3A_0x5Finput_arithmetic0x5Babi0x3Ann2101050x5D0x3Cfloat0x2C0x20wchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x260x2C0x20float0x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3Aoperator0x3E0x3E0x28double0x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x260x20std0x3A0x3A_0x5F20x3A0x3A_0x5Finput_arithmetic0x5Babi0x3Ann2101050x5D0x3Cdouble0x2C0x20wchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x260x2C0x20double0x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3Aoperator0x3E0x3E0x28long0x20double0x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x260x20std0x3A0x3A_0x5F20x3A0x3A_0x5Finput_arithmetic0x5Babi0x3Ann2101050x5D0x3Clong0x20double0x2C0x20wchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x260x2C0x20long0x20double0x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3Aoperator0x3E0x3E0x28void0x2A0x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x260x20std0x3A0x3A_0x5F20x3A0x3A_0x5Finput_arithmetic0x5Babi0x3Ann2101050x5D0x3Cvoid0x2A0x2C0x20wchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x260x2C0x20void0x2A0x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3Aget0x280x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3Aget0x28wchar_t0x2A0x2C0x20long0x2C0x20wchar_t0x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3Aget0x28std0x3A0x3A_0x5F20x3A0x3Abasic_streambuf0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x260x2C0x20wchar_t0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3Agetline0x28wchar_t0x2A0x2C0x20long0x2C0x20wchar_t0x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3Aignore0x28long0x2C0x20int0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3Apeek0x280x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3Aread0x28wchar_t0x2A0x2C0x20long0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3Areadsome0x28wchar_t0x2A0x2C0x20long0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3Aputback0x28wchar_t0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3Aunget0x280x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3Async0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3Atellg0x280x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3Aseekg0x28std0x3A0x3A_0x5F20x3A0x3Afpos0x3C_0x5Fmbstate_t0x3E0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3Aseekg0x28long0x20long0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x3A0x3Aseekdir0x29(w2c_rlbox*, u32, u64, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_ostream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3A0x7Ebasic_ostream0x280x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_ostream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3A0x7Ebasic_ostream0x280x290x2E1(w2c_rlbox*, u32);
static u32 w2c_rlbox_virtual0x20thunk0x20to0x20std0x3A0x3A_0x5F20x3A0x3Abasic_ostream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3A0x7Ebasic_ostream0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_ostream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3A0x7Ebasic_ostream0x280x290x2E2(w2c_rlbox*, u32);
static void w2c_rlbox_virtual0x20thunk0x20to0x20std0x3A0x3A_0x5F20x3A0x3Abasic_ostream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3A0x7Ebasic_ostream0x280x290x2E1(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_ostream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3Asentry0x3A0x3Asentry0x28std0x3A0x3A_0x5F20x3A0x3Abasic_ostream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_ostream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3Asentry0x3A0x3A0x7Esentry0x280x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_ostream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3Aoperator0x3C0x3C0x28bool0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_ostream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x260x20std0x3A0x3A_0x5F20x3A0x3Abasic_ostream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3A_0x5Fput_num0x5Babi0x3Ann2101050x5D0x3Cbool0x3E0x28bool0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_ostream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3Aoperator0x3C0x3C0x28short0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_ostream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x260x20std0x3A0x3A_0x5F20x3A0x3Abasic_ostream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3A_0x5Fput_num_integer_promote0x5Babi0x3Ann2101050x5D0x3Cshort0x3E0x28short0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_ostream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3Aoperator0x3C0x3C0x28unsigned0x20short0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_ostream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x260x20std0x3A0x3A_0x5F20x3A0x3Abasic_ostream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3A_0x5Fput_num_integer_promote0x5Babi0x3Ann2101050x5D0x3Cunsigned0x20short0x3E0x28unsigned0x20short0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_ostream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3Aoperator0x3C0x3C0x28int0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_ostream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x260x20std0x3A0x3A_0x5F20x3A0x3Abasic_ostream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3A_0x5Fput_num_integer_promote0x5Babi0x3Ann2101050x5D0x3Cint0x3E0x28int0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_ostream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3Aoperator0x3C0x3C0x28unsigned0x20int0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_ostream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x260x20std0x3A0x3A_0x5F20x3A0x3Abasic_ostream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3A_0x5Fput_num_integer_promote0x5Babi0x3Ann2101050x5D0x3Cunsigned0x20int0x3E0x28unsigned0x20int0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_ostream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3Aoperator0x3C0x3C0x28long0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_ostream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x260x20std0x3A0x3A_0x5F20x3A0x3Abasic_ostream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3A_0x5Fput_num0x5Babi0x3Ann2101050x5D0x3Clong0x3E0x28long0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_ostream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3Aoperator0x3C0x3C0x28unsigned0x20long0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_ostream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x260x20std0x3A0x3A_0x5F20x3A0x3Abasic_ostream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3A_0x5Fput_num0x5Babi0x3Ann2101050x5D0x3Cunsigned0x20long0x3E0x28unsigned0x20long0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_ostream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3Aoperator0x3C0x3C0x28long0x20long0x29(w2c_rlbox*, u32, u64);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_ostream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x260x20std0x3A0x3A_0x5F20x3A0x3Abasic_ostream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3A_0x5Fput_num0x5Babi0x3Ann2101050x5D0x3Clong0x20long0x3E0x28long0x20long0x29(w2c_rlbox*, u32, u64);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_ostream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3Aoperator0x3C0x3C0x28unsigned0x20long0x20long0x29(w2c_rlbox*, u32, u64);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_ostream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x260x20std0x3A0x3A_0x5F20x3A0x3Abasic_ostream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3A_0x5Fput_num0x5Babi0x3Ann2101050x5D0x3Cunsigned0x20long0x20long0x3E0x28unsigned0x20long0x20long0x29(w2c_rlbox*, u32, u64);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_ostream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3Aoperator0x3C0x3C0x28float0x29(w2c_rlbox*, u32, f32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_ostream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x260x20std0x3A0x3A_0x5F20x3A0x3Abasic_ostream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3A_0x5Fput_num0x5Babi0x3Ann2101050x5D0x3Cdouble0x3E0x28double0x29(w2c_rlbox*, u32, f64);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_ostream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3Aoperator0x3C0x3C0x28double0x29(w2c_rlbox*, u32, f64);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_ostream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3Aoperator0x3C0x3C0x28long0x20double0x29(w2c_rlbox*, u32, u64, u64);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_ostream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x260x20std0x3A0x3A_0x5F20x3A0x3Abasic_ostream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3A_0x5Fput_num0x5Babi0x3Ann2101050x5D0x3Clong0x20double0x3E0x28long0x20double0x29(w2c_rlbox*, u32, u64, u64);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_ostream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3Aoperator0x3C0x3C0x28void0x20const0x2A0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_ostream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x260x20std0x3A0x3A_0x5F20x3A0x3Abasic_ostream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3A_0x5Fput_num0x5Babi0x3Ann2101050x5D0x3Cvoid0x20const0x2A0x3E0x28void0x20const0x2A0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_ostream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3Aoperator0x3C0x3C0x28std0x3A0x3A_0x5F20x3A0x3Abasic_streambuf0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2A0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_ostream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3Aput0x28wchar_t0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_ostream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3Awrite0x28wchar_t0x20const0x2A0x2C0x20long0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_stringbuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3Abasic_stringbuf0x28std0x3A0x3A_0x5F20x3A0x3Abasic_stringbuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x260x260x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_stringbuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A_0x5Fmove_init0x5Babi0x3Ann2101050x5D0x28std0x3A0x3A_0x5F20x3A0x3Abasic_stringbuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x260x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_stringbuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3Aoperator0x3D0x28std0x3A0x3A_0x5F20x3A0x3Abasic_stringbuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x260x260x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_stringbuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3Aswap0x28std0x3A0x3A_0x5F20x3A0x3Abasic_stringbuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x260x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_stringbuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3Astr0x280x290x20const(w2c_rlbox*, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_stringbuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3Astr0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_stringbuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3Aunderflow0x280x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_stringbuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3Apbackfail0x28int0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_stringbuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3Aoverflow0x28int0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_stringbuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3Aseekoff0x28long0x20long0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x3A0x3Aseekdir0x2C0x20unsigned0x20int0x29(w2c_rlbox*, u32, u32, u64, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_stringstream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3Aoperator0x3D0x28std0x3A0x3A_0x5F20x3A0x3Abasic_stringstream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x260x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_ostringstream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3Aoperator0x3D0x28std0x3A0x3A_0x5F20x3A0x3Abasic_ostringstream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x260x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_istringstream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3Aoperator0x3D0x28std0x3A0x3A_0x5F20x3A0x3Abasic_istringstream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x260x260x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_ifstream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Aopen0x28char0x20const0x2A0x2C0x20unsigned0x20int0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_filebuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Aopen0x28char0x20const0x2A0x2C0x20unsigned0x20int0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_filebuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3A_0x5Fmake_mdstring0x28unsigned0x20int0x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_ifstream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Aopen0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x2C0x20unsigned0x20int0x29(w2c_rlbox*, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_ofstream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Aopen0x28char0x20const0x2A0x2C0x20unsigned0x20int0x29(w2c_rlbox*, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_ofstream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Aopen0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x2C0x20unsigned0x20int0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_filebuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Abasic_filebuf0x280x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_filebuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Abasic_filebuf0x28std0x3A0x3A_0x5F20x3A0x3Abasic_filebuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x260x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_filebuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_filebuf0x280x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_filebuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Async0x280x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_filebuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Aclose0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_filebuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_filebuf0x280x290x2E1(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_filebuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Aswap0x28std0x3A0x3A_0x5F20x3A0x3Abasic_filebuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_filebuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Aunderflow0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fthrow_bad_cast0x5Babi0x3Ann2101050x5D0x280x29(w2c_rlbox*);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_filebuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3A_0x5Fread_mode0x280x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_filebuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Apbackfail0x28int0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_filebuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Aoverflow0x28int0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_filebuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3A_0x5Fwrite_mode0x280x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_filebuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Asetbuf0x28char0x2A0x2C0x20long0x29(w2c_rlbox*, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_filebuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Aseekoff0x28long0x20long0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x3A0x3Aseekdir0x2C0x20unsigned0x20int0x29(w2c_rlbox*, u32, u32, u64, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_filebuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Aseekpos0x28std0x3A0x3A_0x5F20x3A0x3Afpos0x3C_0x5Fmbstate_t0x3E0x2C0x20unsigned0x20int0x29(w2c_rlbox*, u32, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_filebuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Aimbue0x28std0x3A0x3A_0x5F20x3A0x3Alocale0x20const0x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_stringbuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_stringbuf0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_stringbuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_stringbuf0x280x290x2E1(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_stringbuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3Aseekpos0x28std0x3A0x3A_0x5F20x3A0x3Afpos0x3C_0x5Fmbstate_t0x3E0x2C0x20unsigned0x20int0x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_stringstream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_stringstream0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_stringstream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_stringstream0x280x290x2E1(w2c_rlbox*, u32);
static u32 w2c_rlbox_non0x2Dvirtual0x20thunk0x20to0x20std0x3A0x3A_0x5F20x3A0x3Abasic_stringstream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_stringstream0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_non0x2Dvirtual0x20thunk0x20to0x20std0x3A0x3A_0x5F20x3A0x3Abasic_stringstream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_stringstream0x280x290x2E1(w2c_rlbox*, u32);
static u32 w2c_rlbox_virtual0x20thunk0x20to0x20std0x3A0x3A_0x5F20x3A0x3Abasic_stringstream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_stringstream0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_virtual0x20thunk0x20to0x20std0x3A0x3A_0x5F20x3A0x3Abasic_stringstream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_stringstream0x280x290x2E1(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_ostringstream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_ostringstream0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_ostringstream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_ostringstream0x280x290x2E1(w2c_rlbox*, u32);
static u32 w2c_rlbox_virtual0x20thunk0x20to0x20std0x3A0x3A_0x5F20x3A0x3Abasic_ostringstream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_ostringstream0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_virtual0x20thunk0x20to0x20std0x3A0x3A_0x5F20x3A0x3Abasic_ostringstream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_ostringstream0x280x290x2E1(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_istringstream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_istringstream0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_istringstream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_istringstream0x280x290x2E1(w2c_rlbox*, u32);
static u32 w2c_rlbox_virtual0x20thunk0x20to0x20std0x3A0x3A_0x5F20x3A0x3Abasic_istringstream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_istringstream0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_virtual0x20thunk0x20to0x20std0x3A0x3A_0x5F20x3A0x3Abasic_istringstream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_istringstream0x280x290x2E1(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_ifstream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_ifstream0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_ifstream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_ifstream0x280x290x2E1(w2c_rlbox*, u32);
static u32 w2c_rlbox_virtual0x20thunk0x20to0x20std0x3A0x3A_0x5F20x3A0x3Abasic_ifstream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_ifstream0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_virtual0x20thunk0x20to0x20std0x3A0x3A_0x5F20x3A0x3Abasic_ifstream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_ifstream0x280x290x2E1(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_ofstream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_ofstream0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_ofstream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_ofstream0x280x290x2E1(w2c_rlbox*, u32);
static u32 w2c_rlbox_virtual0x20thunk0x20to0x20std0x3A0x3A_0x5F20x3A0x3Abasic_ofstream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_ofstream0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_virtual0x20thunk0x20to0x20std0x3A0x3A_0x5F20x3A0x3Abasic_ofstream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_ofstream0x280x290x2E1(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abad_weak_ptr0x3A0x3A0x7Ebad_weak_ptr0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abad_weak_ptr0x3A0x3A0x7Ebad_weak_ptr0x280x290x2E1(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abad_weak_ptr0x3A0x3Awhat0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fshared_count0x3A0x3A0x7E_0x5Fshared_count0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fshared_count0x3A0x3A0x7E_0x5Fshared_count0x280x290x2E1(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fshared_weak_count0x3A0x3A0x7E_0x5Fshared_weak_count0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fshared_weak_count0x3A0x3A_0x5Frelease_weak0x280x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fshared_weak_count0x3A0x3Alock0x280x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fshared_weak_count0x3A0x3A_0x5Fget_deleter0x28std0x3A0x3Atype_info0x20const0x260x290x20const(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Aalign0x28unsigned0x20long0x2C0x20unsigned0x20long0x2C0x20void0x2A0x260x2C0x20unsigned0x20long0x260x29(w2c_rlbox*, u32, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcall_once0x28unsigned0x20long0x20volatile0x260x2C0x20void0x2A0x2C0x20void0x200x280x2A0x290x28void0x2A0x290x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acollate0x3Cchar0x3E0x3A0x3A0x7Ecollate0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acollate0x3Cchar0x3E0x3A0x3A0x7Ecollate0x280x290x2E1(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acollate0x3Cchar0x3E0x3A0x3Ado_compare0x28char0x20const0x2A0x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acollate0x3Cchar0x3E0x3A0x3Ado_transform0x28char0x20const0x2A0x2C0x20char0x20const0x2A0x290x20const(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acollate0x3Cchar0x3E0x3A0x3Ado_hash0x28char0x20const0x2A0x2C0x20char0x20const0x2A0x290x20const(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acollate0x3Cwchar_t0x3E0x3A0x3A0x7Ecollate0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acollate0x3Cwchar_t0x3E0x3A0x3A0x7Ecollate0x280x290x2E1(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acollate0x3Cwchar_t0x3E0x3A0x3Ado_compare0x28wchar_t0x20const0x2A0x2C0x20wchar_t0x20const0x2A0x2C0x20wchar_t0x20const0x2A0x2C0x20wchar_t0x20const0x2A0x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acollate0x3Cwchar_t0x3E0x3A0x3Ado_transform0x28wchar_t0x20const0x2A0x2C0x20wchar_t0x20const0x2A0x290x20const(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acollate0x3Cwchar_t0x3E0x3A0x3Ado_hash0x28wchar_t0x20const0x2A0x2C0x20wchar_t0x20const0x2A0x290x20const(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_get0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3Ado_get0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20bool0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fcall_once_proxy0x5Babi0x3Ann2101050x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3Atuple0x3Cstd0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3Aid0x3A0x3A_0x5Fget0x280x290x3A0x3A0x24_00x260x260x3E0x3E0x28void0x2A0x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x2A0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fscan_keyword0x5Babi0x3Ann2101050x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Actype0x3Cchar0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Actype0x3Cchar0x3E0x20const0x260x2C0x20unsigned0x20int0x260x2C0x20bool0x29(w2c_rlbox*, u32, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_get0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3Ado_get0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20long0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x20std0x3A0x3A_0x5F20x3A0x3Anum_get0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3A_0x5Fdo_get_signed0x5Babi0x3Ann2101050x5D0x3Clong0x3E0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20long0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fnum_get0x3Cchar0x3E0x3A0x3A_0x5Fstage2_int_loop0x28char0x2C0x20int0x2C0x20char0x2A0x2C0x20char0x2A0x260x2C0x20unsigned0x20int0x260x2C0x20char0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x2C0x20unsigned0x20int0x2A0x2C0x20unsigned0x20int0x2A0x260x2C0x20char0x2A0x29(w2c_rlbox*, u32, u32, u32, u32, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_get0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3Ado_get0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20long0x20long0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x20std0x3A0x3A_0x5F20x3A0x3Anum_get0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3A_0x5Fdo_get_signed0x5Babi0x3Ann2101050x5D0x3Clong0x20long0x3E0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20long0x20long0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_get0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3Ado_get0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20unsigned0x20short0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x20std0x3A0x3A_0x5F20x3A0x3Anum_get0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3A_0x5Fdo_get_unsigned0x5Babi0x3Ann2101050x5D0x3Cunsigned0x20short0x3E0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20unsigned0x20short0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_get0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3Ado_get0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20unsigned0x20int0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x20std0x3A0x3A_0x5F20x3A0x3Anum_get0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3A_0x5Fdo_get_unsigned0x5Babi0x3Ann2101050x5D0x3Cunsigned0x20int0x3E0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20unsigned0x20int0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_get0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3Ado_get0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20unsigned0x20long0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x20std0x3A0x3A_0x5F20x3A0x3Anum_get0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3A_0x5Fdo_get_unsigned0x5Babi0x3Ann2101050x5D0x3Cunsigned0x20long0x3E0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20unsigned0x20long0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_get0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3Ado_get0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20unsigned0x20long0x20long0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x20std0x3A0x3A_0x5F20x3A0x3Anum_get0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3A_0x5Fdo_get_unsigned0x5Babi0x3Ann2101050x5D0x3Cunsigned0x20long0x20long0x3E0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20unsigned0x20long0x20long0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_get0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3Ado_get0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20float0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x20std0x3A0x3A_0x5F20x3A0x3Anum_get0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3A_0x5Fdo_get_floating_point0x5Babi0x3Ann2101050x5D0x3Cfloat0x3E0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20float0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fnum_get0x3Cchar0x3E0x3A0x3A_0x5Fstage2_float_prep0x28std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20char0x2A0x2C0x20char0x260x2C0x20char0x260x29(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fnum_get0x3Cchar0x3E0x3A0x3A_0x5Fstage2_float_loop0x28char0x2C0x20bool0x260x2C0x20char0x260x2C0x20char0x2A0x2C0x20char0x2A0x260x2C0x20char0x2C0x20char0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x2C0x20unsigned0x20int0x2A0x2C0x20unsigned0x20int0x2A0x260x2C0x20unsigned0x20int0x260x2C0x20char0x2A0x29(w2c_rlbox*, u32, u32, u32, u32, u32, u32, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_get0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3Ado_get0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20double0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x20std0x3A0x3A_0x5F20x3A0x3Anum_get0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3A_0x5Fdo_get_floating_point0x5Babi0x3Ann2101050x5D0x3Cdouble0x3E0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20double0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_get0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3Ado_get0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20long0x20double0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x20std0x3A0x3A_0x5F20x3A0x3Anum_get0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3A_0x5Fdo_get_floating_point0x5Babi0x3Ann2101050x5D0x3Clong0x20double0x3E0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20long0x20double0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_get0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3Ado_get0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20void0x2A0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Flibcpp_sscanf_l0x28char0x20const0x2A0x2C0x20_0x5Flocale_struct0x2A0x2C0x20char0x20const0x2A0x2C0x200x2E0x2E0x2E0x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcloc0x280x29(w2c_rlbox*);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_get0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3Ado_get0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20bool0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cwchar_t0x3E0x3E0x20const0x2A0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fscan_keyword0x5Babi0x3Ann2101050x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cwchar_t0x3E0x3E0x20const0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Actype0x3Cwchar_t0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cwchar_t0x3E0x3E0x20const0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cwchar_t0x3E0x3E0x20const0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Actype0x3Cwchar_t0x3E0x20const0x260x2C0x20unsigned0x20int0x260x2C0x20bool0x29(w2c_rlbox*, u32, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_get0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3Ado_get0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20long0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x20std0x3A0x3A_0x5F20x3A0x3Anum_get0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3A_0x5Fdo_get_signed0x5Babi0x3Ann2101050x5D0x3Clong0x3E0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20long0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fnum_get0x3Cwchar_t0x3E0x3A0x3A_0x5Fstage2_int_loop0x28wchar_t0x2C0x20int0x2C0x20char0x2A0x2C0x20char0x2A0x260x2C0x20unsigned0x20int0x260x2C0x20wchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x2C0x20unsigned0x20int0x2A0x2C0x20unsigned0x20int0x2A0x260x2C0x20wchar_t0x2A0x29(w2c_rlbox*, u32, u32, u32, u32, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_get0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3Ado_get0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20long0x20long0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x20std0x3A0x3A_0x5F20x3A0x3Anum_get0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3A_0x5Fdo_get_signed0x5Babi0x3Ann2101050x5D0x3Clong0x20long0x3E0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20long0x20long0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_get0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3Ado_get0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20unsigned0x20short0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x20std0x3A0x3A_0x5F20x3A0x3Anum_get0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3A_0x5Fdo_get_unsigned0x5Babi0x3Ann2101050x5D0x3Cunsigned0x20short0x3E0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20unsigned0x20short0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_get0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3Ado_get0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20unsigned0x20int0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x20std0x3A0x3A_0x5F20x3A0x3Anum_get0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3A_0x5Fdo_get_unsigned0x5Babi0x3Ann2101050x5D0x3Cunsigned0x20int0x3E0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20unsigned0x20int0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_get0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3Ado_get0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20unsigned0x20long0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x20std0x3A0x3A_0x5F20x3A0x3Anum_get0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3A_0x5Fdo_get_unsigned0x5Babi0x3Ann2101050x5D0x3Cunsigned0x20long0x3E0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20unsigned0x20long0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_get0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3Ado_get0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20unsigned0x20long0x20long0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x20std0x3A0x3A_0x5F20x3A0x3Anum_get0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3A_0x5Fdo_get_unsigned0x5Babi0x3Ann2101050x5D0x3Cunsigned0x20long0x20long0x3E0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20unsigned0x20long0x20long0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_get0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3Ado_get0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20float0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x20std0x3A0x3A_0x5F20x3A0x3Anum_get0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3A_0x5Fdo_get_floating_point0x5Babi0x3Ann2101050x5D0x3Cfloat0x3E0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20float0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fnum_get0x3Cwchar_t0x3E0x3A0x3A_0x5Fstage2_float_prep0x28std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20wchar_t0x2A0x2C0x20wchar_t0x260x2C0x20wchar_t0x260x29(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fnum_get0x3Cwchar_t0x3E0x3A0x3A_0x5Fstage2_float_loop0x28wchar_t0x2C0x20bool0x260x2C0x20char0x260x2C0x20char0x2A0x2C0x20char0x2A0x260x2C0x20wchar_t0x2C0x20wchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x2C0x20unsigned0x20int0x2A0x2C0x20unsigned0x20int0x2A0x260x2C0x20unsigned0x20int0x260x2C0x20wchar_t0x2A0x29(w2c_rlbox*, u32, u32, u32, u32, u32, u32, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_get0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3Ado_get0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20double0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x20std0x3A0x3A_0x5F20x3A0x3Anum_get0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3A_0x5Fdo_get_floating_point0x5Babi0x3Ann2101050x5D0x3Cdouble0x3E0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20double0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_get0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3Ado_get0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20long0x20double0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x20std0x3A0x3A_0x5F20x3A0x3Anum_get0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3A_0x5Fdo_get_floating_point0x5Babi0x3Ann2101050x5D0x3Clong0x20double0x3E0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20long0x20double0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_get0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3Ado_get0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20void0x2A0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fnum_get0x3Cchar0x3E0x3A0x3A_0x5Fstage2_int_prep0x28std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20char0x2A0x2C0x20char0x260x29(w2c_rlbox*, u32, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fnum_get0x3Cwchar_t0x3E0x3A0x3A_0x5Fstage2_int_prep0x28std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20wchar_t0x2A0x2C0x20wchar_t0x260x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_put0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3Ado_put0x28std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20char0x2C0x20bool0x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_put0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3Ado_put0x28std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20char0x2C0x20long0x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x20std0x3A0x3A_0x5F20x3A0x3Anum_put0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3A_0x5Fdo_put_integral0x5Babi0x3Ann2101050x5D0x3Clong0x3E0x28std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20char0x2C0x20long0x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fto_chars_result0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fto_chars_integral0x5Babi0x3Ann2101050x5D0x3Cunsigned0x20long0x2C0x2000x3E0x28char0x2A0x2C0x20char0x2A0x2C0x20unsigned0x20long0x2C0x20int0x29(w2c_rlbox*, u32, u32, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fnum_put0x3Cchar0x3E0x3A0x3A_0x5Fwiden_and_group_int0x28char0x2A0x2C0x20char0x2A0x2C0x20char0x2A0x2C0x20char0x2A0x2C0x20char0x2A0x260x2C0x20char0x2A0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Alocale0x20const0x260x29(w2c_rlbox*, u32, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fpad_and_output0x5Babi0x3Ann2101050x5D0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20char0x29(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_put0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3Ado_put0x28std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20char0x2C0x20long0x20long0x290x20const(w2c_rlbox*, u32, u32, u32, u32, u64);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x20std0x3A0x3A_0x5F20x3A0x3Anum_put0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3A_0x5Fdo_put_integral0x5Babi0x3Ann2101050x5D0x3Clong0x20long0x3E0x28std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20char0x2C0x20long0x20long0x290x20const(w2c_rlbox*, u32, u32, u32, u32, u64);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fto_chars_result0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fto_chars_integral0x5Babi0x3Ann2101050x5D0x3Cunsigned0x20long0x20long0x2C0x2000x3E0x28char0x2A0x2C0x20char0x2A0x2C0x20unsigned0x20long0x20long0x2C0x20int0x29(w2c_rlbox*, u32, u32, u32, u64, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_put0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3Ado_put0x28std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20char0x2C0x20unsigned0x20long0x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x20std0x3A0x3A_0x5F20x3A0x3Anum_put0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3A_0x5Fdo_put_integral0x5Babi0x3Ann2101050x5D0x3Cunsigned0x20long0x3E0x28std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20char0x2C0x20unsigned0x20long0x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_put0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3Ado_put0x28std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20char0x2C0x20unsigned0x20long0x20long0x290x20const(w2c_rlbox*, u32, u32, u32, u32, u64);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x20std0x3A0x3A_0x5F20x3A0x3Anum_put0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3A_0x5Fdo_put_integral0x5Babi0x3Ann2101050x5D0x3Cunsigned0x20long0x20long0x3E0x28std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20char0x2C0x20unsigned0x20long0x20long0x290x20const(w2c_rlbox*, u32, u32, u32, u32, u64);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_put0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3Ado_put0x28std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20char0x2C0x20double0x290x20const(w2c_rlbox*, u32, u32, u32, u32, f64);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x20std0x3A0x3A_0x5F20x3A0x3Anum_put0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3A_0x5Fdo_put_floating_point0x5Babi0x3Ann2101050x5D0x3Cdouble0x3E0x28std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20char0x2C0x20double0x2C0x20char0x20const0x2A0x290x20const(w2c_rlbox*, u32, u32, u32, u32, f64, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Flibcpp_snprintf_l0x28char0x2A0x2C0x20unsigned0x20long0x2C0x20_0x5Flocale_struct0x2A0x2C0x20char0x20const0x2A0x2C0x200x2E0x2E0x2E0x29(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Flibcpp_asprintf_l0x28char0x2A0x2A0x2C0x20_0x5Flocale_struct0x2A0x2C0x20char0x20const0x2A0x2C0x200x2E0x2E0x2E0x29(w2c_rlbox*, u32, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fnum_put0x3Cchar0x3E0x3A0x3A_0x5Fwiden_and_group_float0x28char0x2A0x2C0x20char0x2A0x2C0x20char0x2A0x2C0x20char0x2A0x2C0x20char0x2A0x260x2C0x20char0x2A0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Alocale0x20const0x260x29(w2c_rlbox*, u32, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_put0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3Ado_put0x28std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20char0x2C0x20long0x20double0x290x20const(w2c_rlbox*, u32, u32, u32, u32, u64, u64);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x20std0x3A0x3A_0x5F20x3A0x3Anum_put0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3A_0x5Fdo_put_floating_point0x5Babi0x3Ann2101050x5D0x3Clong0x20double0x3E0x28std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20char0x2C0x20long0x20double0x2C0x20char0x20const0x2A0x290x20const(w2c_rlbox*, u32, u32, u32, u32, u64, u64, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_put0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3Ado_put0x28std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20char0x2C0x20void0x20const0x2A0x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_put0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3Ado_put0x28std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20wchar_t0x2C0x20bool0x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_put0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3Ado_put0x28std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20wchar_t0x2C0x20long0x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x20std0x3A0x3A_0x5F20x3A0x3Anum_put0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3A_0x5Fdo_put_integral0x5Babi0x3Ann2101050x5D0x3Clong0x3E0x28std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20wchar_t0x2C0x20long0x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fnum_put0x3Cwchar_t0x3E0x3A0x3A_0x5Fwiden_and_group_int0x28char0x2A0x2C0x20char0x2A0x2C0x20char0x2A0x2C0x20wchar_t0x2A0x2C0x20wchar_t0x2A0x260x2C0x20wchar_t0x2A0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Alocale0x20const0x260x29(w2c_rlbox*, u32, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fpad_and_output0x5Babi0x3Ann2101050x5D0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20wchar_t0x20const0x2A0x2C0x20wchar_t0x20const0x2A0x2C0x20wchar_t0x20const0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20wchar_t0x29(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_put0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3Ado_put0x28std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20wchar_t0x2C0x20long0x20long0x290x20const(w2c_rlbox*, u32, u32, u32, u32, u64);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x20std0x3A0x3A_0x5F20x3A0x3Anum_put0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3A_0x5Fdo_put_integral0x5Babi0x3Ann2101050x5D0x3Clong0x20long0x3E0x28std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20wchar_t0x2C0x20long0x20long0x290x20const(w2c_rlbox*, u32, u32, u32, u32, u64);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_put0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3Ado_put0x28std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20wchar_t0x2C0x20unsigned0x20long0x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x20std0x3A0x3A_0x5F20x3A0x3Anum_put0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3A_0x5Fdo_put_integral0x5Babi0x3Ann2101050x5D0x3Cunsigned0x20long0x3E0x28std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20wchar_t0x2C0x20unsigned0x20long0x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_put0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3Ado_put0x28std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20wchar_t0x2C0x20unsigned0x20long0x20long0x290x20const(w2c_rlbox*, u32, u32, u32, u32, u64);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x20std0x3A0x3A_0x5F20x3A0x3Anum_put0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3A_0x5Fdo_put_integral0x5Babi0x3Ann2101050x5D0x3Cunsigned0x20long0x20long0x3E0x28std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20wchar_t0x2C0x20unsigned0x20long0x20long0x290x20const(w2c_rlbox*, u32, u32, u32, u32, u64);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_put0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3Ado_put0x28std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20wchar_t0x2C0x20double0x290x20const(w2c_rlbox*, u32, u32, u32, u32, f64);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x20std0x3A0x3A_0x5F20x3A0x3Anum_put0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3A_0x5Fdo_put_floating_point0x5Babi0x3Ann2101050x5D0x3Cdouble0x3E0x28std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20wchar_t0x2C0x20double0x2C0x20char0x20const0x2A0x290x20const(w2c_rlbox*, u32, u32, u32, u32, f64, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fnum_put0x3Cwchar_t0x3E0x3A0x3A_0x5Fwiden_and_group_float0x28char0x2A0x2C0x20char0x2A0x2C0x20char0x2A0x2C0x20wchar_t0x2A0x2C0x20wchar_t0x2A0x260x2C0x20wchar_t0x2A0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Alocale0x20const0x260x29(w2c_rlbox*, u32, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_put0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3Ado_put0x28std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20wchar_t0x2C0x20long0x20double0x290x20const(w2c_rlbox*, u32, u32, u32, u32, u64, u64);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x20std0x3A0x3A_0x5F20x3A0x3Anum_put0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3A_0x5Fdo_put_floating_point0x5Babi0x3Ann2101050x5D0x3Clong0x20double0x3E0x28std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20wchar_t0x2C0x20long0x20double0x2C0x20char0x20const0x2A0x290x20const(w2c_rlbox*, u32, u32, u32, u32, u64, u64, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_put0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3Ado_put0x28std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20wchar_t0x2C0x20void0x20const0x2A0x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Atime_get0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3Aget0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20tm0x2A0x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Atime_get0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3Ado_date_order0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Atime_get0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3Ado_get_time0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20tm0x2A0x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Atime_get0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3Ado_get_date0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20tm0x2A0x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Atime_get0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3Ado_get_weekday0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20tm0x2A0x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Atime_get0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3A_0x5Fget_weekdayname0x28int0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20unsigned0x20int0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Actype0x3Cchar0x3E0x20const0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Atime_get0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3Ado_get_monthname0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20tm0x2A0x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Atime_get0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3A_0x5Fget_monthname0x28int0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20unsigned0x20int0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Actype0x3Cchar0x3E0x20const0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Atime_get0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3Ado_get_year0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20tm0x2A0x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_int0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fget_up_to_n_digits0x5Babi0x3Ann2101050x5D0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20unsigned0x20int0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Actype0x3Cchar0x3E0x20const0x260x2C0x20int0x29(w2c_rlbox*, u32, u32, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Atime_get0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3A_0x5Fget_year0x28int0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20unsigned0x20int0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Actype0x3Cchar0x3E0x20const0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Atime_get0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3Ado_get0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20tm0x2A0x2C0x20char0x2C0x20char0x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Atime_get0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3A_0x5Fget_white_space0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20unsigned0x20int0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Actype0x3Cchar0x3E0x20const0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Atime_get0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3A_0x5Fget_percent0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20unsigned0x20int0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Actype0x3Cchar0x3E0x20const0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Atime_get0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3A_0x5Fget_day0x28int0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20unsigned0x20int0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Actype0x3Cchar0x3E0x20const0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Atime_get0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3A_0x5Fget_hour0x28int0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20unsigned0x20int0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Actype0x3Cchar0x3E0x20const0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Atime_get0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3A_0x5Fget_12_hour0x28int0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20unsigned0x20int0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Actype0x3Cchar0x3E0x20const0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Atime_get0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3A_0x5Fget_day_year_num0x28int0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20unsigned0x20int0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Actype0x3Cchar0x3E0x20const0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Atime_get0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3A_0x5Fget_month0x28int0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20unsigned0x20int0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Actype0x3Cchar0x3E0x20const0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Atime_get0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3A_0x5Fget_minute0x28int0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20unsigned0x20int0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Actype0x3Cchar0x3E0x20const0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Atime_get0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3A_0x5Fget_am_pm0x28int0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20unsigned0x20int0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Actype0x3Cchar0x3E0x20const0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Atime_get0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3A_0x5Fget_second0x28int0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20unsigned0x20int0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Actype0x3Cchar0x3E0x20const0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Atime_get0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3A_0x5Fget_weekday0x28int0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20unsigned0x20int0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Actype0x3Cchar0x3E0x20const0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Atime_get0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3A_0x5Fget_year40x28int0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20unsigned0x20int0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Actype0x3Cchar0x3E0x20const0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Atime_get0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3Aget0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20tm0x2A0x2C0x20wchar_t0x20const0x2A0x2C0x20wchar_t0x20const0x2A0x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Atime_get0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3Ado_date_order0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Atime_get0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3Ado_get_time0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20tm0x2A0x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Atime_get0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3Ado_get_date0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20tm0x2A0x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Atime_get0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3Ado_get_weekday0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20tm0x2A0x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Atime_get0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3A_0x5Fget_weekdayname0x28int0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20unsigned0x20int0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Actype0x3Cwchar_t0x3E0x20const0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Atime_get0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3Ado_get_monthname0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20tm0x2A0x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Atime_get0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3A_0x5Fget_monthname0x28int0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20unsigned0x20int0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Actype0x3Cwchar_t0x3E0x20const0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Atime_get0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3Ado_get_year0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20tm0x2A0x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_int0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fget_up_to_n_digits0x5Babi0x3Ann2101050x5D0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20unsigned0x20int0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Actype0x3Cwchar_t0x3E0x20const0x260x2C0x20int0x29(w2c_rlbox*, u32, u32, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Atime_get0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3A_0x5Fget_year0x28int0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20unsigned0x20int0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Actype0x3Cwchar_t0x3E0x20const0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Atime_get0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3Ado_get0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20tm0x2A0x2C0x20char0x2C0x20char0x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Atime_get0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3A_0x5Fget_white_space0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20unsigned0x20int0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Actype0x3Cwchar_t0x3E0x20const0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Atime_get0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3A_0x5Fget_percent0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20unsigned0x20int0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Actype0x3Cwchar_t0x3E0x20const0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Atime_get0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3A_0x5Fget_day0x28int0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20unsigned0x20int0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Actype0x3Cwchar_t0x3E0x20const0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Atime_get0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3A_0x5Fget_hour0x28int0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20unsigned0x20int0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Actype0x3Cwchar_t0x3E0x20const0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Atime_get0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3A_0x5Fget_12_hour0x28int0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20unsigned0x20int0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Actype0x3Cwchar_t0x3E0x20const0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Atime_get0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3A_0x5Fget_day_year_num0x28int0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20unsigned0x20int0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Actype0x3Cwchar_t0x3E0x20const0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Atime_get0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3A_0x5Fget_month0x28int0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20unsigned0x20int0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Actype0x3Cwchar_t0x3E0x20const0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Atime_get0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3A_0x5Fget_minute0x28int0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20unsigned0x20int0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Actype0x3Cwchar_t0x3E0x20const0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Atime_get0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3A_0x5Fget_am_pm0x28int0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20unsigned0x20int0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Actype0x3Cwchar_t0x3E0x20const0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Atime_get0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3A_0x5Fget_second0x28int0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20unsigned0x20int0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Actype0x3Cwchar_t0x3E0x20const0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Atime_get0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3A_0x5Fget_weekday0x28int0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20unsigned0x20int0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Actype0x3Cwchar_t0x3E0x20const0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Atime_get0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3A_0x5Fget_year40x28int0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20unsigned0x20int0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Actype0x3Cwchar_t0x3E0x20const0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Atime_put0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3Aput0x28std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20char0x2C0x20tm0x20const0x2A0x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Atime_put0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3Ado_put0x28std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20char0x2C0x20tm0x20const0x2A0x2C0x20char0x2C0x20char0x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Ftime_put0x3A0x3A_0x5Fdo_put0x28char0x2A0x2C0x20char0x2A0x260x2C0x20tm0x20const0x2A0x2C0x20char0x2C0x20char0x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Atime_put0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3Aput0x28std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20wchar_t0x2C0x20tm0x20const0x2A0x2C0x20wchar_t0x20const0x2A0x2C0x20wchar_t0x20const0x2A0x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Atime_put0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3Ado_put0x28std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20wchar_t0x2C0x20tm0x20const0x2A0x2C0x20char0x2C0x20char0x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Ftime_put0x3A0x3A_0x5Fdo_put0x28wchar_t0x2A0x2C0x20wchar_t0x2A0x260x2C0x20tm0x20const0x2A0x2C0x20char0x2C0x20char0x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cchar0x2C0x20false0x3E0x3A0x3Ado_decimal_point0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cchar0x2C0x20false0x3E0x3A0x3Ado_thousands_sep0x280x290x20const(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cchar0x2C0x20false0x3E0x3A0x3Ado_grouping0x280x290x20const(w2c_rlbox*, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cchar0x2C0x20false0x3E0x3A0x3Ado_curr_symbol0x280x290x20const(w2c_rlbox*, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cchar0x2C0x20false0x3E0x3A0x3Ado_positive_sign0x280x290x20const(w2c_rlbox*, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cchar0x2C0x20false0x3E0x3A0x3Ado_negative_sign0x280x290x20const(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cchar0x2C0x20false0x3E0x3A0x3Ado_frac_digits0x280x290x20const(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cchar0x2C0x20false0x3E0x3A0x3Ado_pos_format0x280x290x20const(w2c_rlbox*, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cchar0x2C0x20false0x3E0x3A0x3Ado_neg_format0x280x290x20const(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cchar0x2C0x20true0x3E0x3A0x3Ado_decimal_point0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cchar0x2C0x20true0x3E0x3A0x3Ado_thousands_sep0x280x290x20const(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cchar0x2C0x20true0x3E0x3A0x3Ado_grouping0x280x290x20const(w2c_rlbox*, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cchar0x2C0x20true0x3E0x3A0x3Ado_curr_symbol0x280x290x20const(w2c_rlbox*, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cchar0x2C0x20true0x3E0x3A0x3Ado_positive_sign0x280x290x20const(w2c_rlbox*, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cchar0x2C0x20true0x3E0x3A0x3Ado_negative_sign0x280x290x20const(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cchar0x2C0x20true0x3E0x3A0x3Ado_frac_digits0x280x290x20const(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cchar0x2C0x20true0x3E0x3A0x3Ado_pos_format0x280x290x20const(w2c_rlbox*, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cchar0x2C0x20true0x3E0x3A0x3Ado_neg_format0x280x290x20const(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cwchar_t0x2C0x20false0x3E0x3A0x3Ado_decimal_point0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cwchar_t0x2C0x20false0x3E0x3A0x3Ado_thousands_sep0x280x290x20const(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cwchar_t0x2C0x20false0x3E0x3A0x3Ado_grouping0x280x290x20const(w2c_rlbox*, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cwchar_t0x2C0x20false0x3E0x3A0x3Ado_curr_symbol0x280x290x20const(w2c_rlbox*, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cwchar_t0x2C0x20false0x3E0x3A0x3Ado_positive_sign0x280x290x20const(w2c_rlbox*, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cwchar_t0x2C0x20false0x3E0x3A0x3Ado_negative_sign0x280x290x20const(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cwchar_t0x2C0x20false0x3E0x3A0x3Ado_frac_digits0x280x290x20const(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cwchar_t0x2C0x20false0x3E0x3A0x3Ado_pos_format0x280x290x20const(w2c_rlbox*, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cwchar_t0x2C0x20false0x3E0x3A0x3Ado_neg_format0x280x290x20const(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cwchar_t0x2C0x20true0x3E0x3A0x3Ado_decimal_point0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cwchar_t0x2C0x20true0x3E0x3A0x3Ado_thousands_sep0x280x290x20const(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cwchar_t0x2C0x20true0x3E0x3A0x3Ado_grouping0x280x290x20const(w2c_rlbox*, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cwchar_t0x2C0x20true0x3E0x3A0x3Ado_curr_symbol0x280x290x20const(w2c_rlbox*, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cwchar_t0x2C0x20true0x3E0x3A0x3Ado_positive_sign0x280x290x20const(w2c_rlbox*, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cwchar_t0x2C0x20true0x3E0x3A0x3Ado_negative_sign0x280x290x20const(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cwchar_t0x2C0x20true0x3E0x3A0x3Ado_frac_digits0x280x290x20const(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cwchar_t0x2C0x20true0x3E0x3A0x3Ado_pos_format0x280x290x20const(w2c_rlbox*, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cwchar_t0x2C0x20true0x3E0x3A0x3Ado_neg_format0x280x290x20const(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cchar0x2C0x20false0x3E0x3A0x3Ado_decimal_point0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cchar0x2C0x20false0x3E0x3A0x3Ado_thousands_sep0x280x290x20const(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cchar0x2C0x20false0x3E0x3A0x3Ado_grouping0x280x290x20const(w2c_rlbox*, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cchar0x2C0x20false0x3E0x3A0x3Ado_curr_symbol0x280x290x20const(w2c_rlbox*, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cchar0x2C0x20false0x3E0x3A0x3Ado_positive_sign0x280x290x20const(w2c_rlbox*, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cchar0x2C0x20false0x3E0x3A0x3Ado_negative_sign0x280x290x20const(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cchar0x2C0x20false0x3E0x3A0x3Ado_frac_digits0x280x290x20const(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cchar0x2C0x20false0x3E0x3A0x3Ado_pos_format0x280x290x20const(w2c_rlbox*, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cchar0x2C0x20false0x3E0x3A0x3Ado_neg_format0x280x290x20const(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cchar0x2C0x20true0x3E0x3A0x3Ado_decimal_point0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cchar0x2C0x20true0x3E0x3A0x3Ado_thousands_sep0x280x290x20const(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cchar0x2C0x20true0x3E0x3A0x3Ado_grouping0x280x290x20const(w2c_rlbox*, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cchar0x2C0x20true0x3E0x3A0x3Ado_curr_symbol0x280x290x20const(w2c_rlbox*, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cchar0x2C0x20true0x3E0x3A0x3Ado_positive_sign0x280x290x20const(w2c_rlbox*, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cchar0x2C0x20true0x3E0x3A0x3Ado_negative_sign0x280x290x20const(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cchar0x2C0x20true0x3E0x3A0x3Ado_frac_digits0x280x290x20const(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cchar0x2C0x20true0x3E0x3A0x3Ado_pos_format0x280x290x20const(w2c_rlbox*, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cchar0x2C0x20true0x3E0x3A0x3Ado_neg_format0x280x290x20const(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cwchar_t0x2C0x20false0x3E0x3A0x3Ado_decimal_point0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cwchar_t0x2C0x20false0x3E0x3A0x3Ado_thousands_sep0x280x290x20const(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cwchar_t0x2C0x20false0x3E0x3A0x3Ado_grouping0x280x290x20const(w2c_rlbox*, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cwchar_t0x2C0x20false0x3E0x3A0x3Ado_curr_symbol0x280x290x20const(w2c_rlbox*, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cwchar_t0x2C0x20false0x3E0x3A0x3Ado_positive_sign0x280x290x20const(w2c_rlbox*, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cwchar_t0x2C0x20false0x3E0x3A0x3Ado_negative_sign0x280x290x20const(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cwchar_t0x2C0x20false0x3E0x3A0x3Ado_frac_digits0x280x290x20const(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cwchar_t0x2C0x20false0x3E0x3A0x3Ado_pos_format0x280x290x20const(w2c_rlbox*, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cwchar_t0x2C0x20false0x3E0x3A0x3Ado_neg_format0x280x290x20const(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cwchar_t0x2C0x20true0x3E0x3A0x3Ado_decimal_point0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cwchar_t0x2C0x20true0x3E0x3A0x3Ado_thousands_sep0x280x290x20const(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cwchar_t0x2C0x20true0x3E0x3A0x3Ado_grouping0x280x290x20const(w2c_rlbox*, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cwchar_t0x2C0x20true0x3E0x3A0x3Ado_curr_symbol0x280x290x20const(w2c_rlbox*, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cwchar_t0x2C0x20true0x3E0x3A0x3Ado_positive_sign0x280x290x20const(w2c_rlbox*, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cwchar_t0x2C0x20true0x3E0x3A0x3Ado_negative_sign0x280x290x20const(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cwchar_t0x2C0x20true0x3E0x3A0x3Ado_frac_digits0x280x290x20const(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cwchar_t0x2C0x20true0x3E0x3A0x3Ado_pos_format0x280x290x20const(w2c_rlbox*, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cwchar_t0x2C0x20true0x3E0x3A0x3Ado_neg_format0x280x290x20const(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoney_get0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3Ado_get0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20bool0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20long0x20double0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fdo_nothing0x28void0x2A0x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoney_get0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3A_0x5Fdo_get0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20bool0x2C0x20std0x3A0x3A_0x5F20x3A0x3Alocale0x20const0x260x2C0x20unsigned0x20int0x2C0x20unsigned0x20int0x260x2C0x20bool0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Actype0x3Cchar0x3E0x20const0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cchar0x2C0x20void0x200x280x2A0x290x28void0x2A0x290x3E0x260x2C0x20char0x2A0x260x2C0x20char0x2A0x29(w2c_rlbox*, u32, u32, u32, u32, u32, u32, u32, u32, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fmoney_get0x3Cchar0x3E0x3A0x3A_0x5Fgather_info0x28bool0x2C0x20std0x3A0x3A_0x5F20x3A0x3Alocale0x20const0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Amoney_base0x3A0x3Apattern0x260x2C0x20char0x260x2C0x20char0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x260x2C0x20int0x260x29(w2c_rlbox*, u32, u32, u32, u32, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoney_get0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3Ado_get0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20bool0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x260x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3Aappend0x5Babi0x3Ann2101050x5D0x3Cchar0x2A0x2C0x2000x3E0x28char0x2A0x2C0x20char0x2A0x29(w2c_rlbox*, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcheck_grouping0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x2C0x20unsigned0x20int0x2A0x2C0x20unsigned0x20int0x2A0x2C0x20unsigned0x20int0x260x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoney_get0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3Ado_get0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20bool0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20long0x20double0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoney_get0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3A_0x5Fdo_get0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20bool0x2C0x20std0x3A0x3A_0x5F20x3A0x3Alocale0x20const0x260x2C0x20unsigned0x20int0x2C0x20unsigned0x20int0x260x2C0x20bool0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Actype0x3Cwchar_t0x3E0x20const0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cwchar_t0x2C0x20void0x200x280x2A0x290x28void0x2A0x290x3E0x260x2C0x20wchar_t0x2A0x260x2C0x20wchar_t0x2A0x29(w2c_rlbox*, u32, u32, u32, u32, u32, u32, u32, u32, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fmoney_get0x3Cwchar_t0x3E0x3A0x3A_0x5Fgather_info0x28bool0x2C0x20std0x3A0x3A_0x5F20x3A0x3Alocale0x20const0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Amoney_base0x3A0x3Apattern0x260x2C0x20wchar_t0x260x2C0x20wchar_t0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cwchar_t0x3E0x3E0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cwchar_t0x3E0x3E0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cwchar_t0x3E0x3E0x260x2C0x20int0x260x29(w2c_rlbox*, u32, u32, u32, u32, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoney_get0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3Ado_get0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20bool0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cwchar_t0x3E0x3E0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cwchar_t0x3E0x3E0x260x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cwchar_t0x3E0x3E0x3A0x3Aappend0x5Babi0x3Ann2101050x5D0x3Cwchar_t0x2A0x2C0x2000x3E0x28wchar_t0x2A0x2C0x20wchar_t0x2A0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoney_put0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3Ado_put0x28std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20bool0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20char0x2C0x20long0x20double0x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u64, u64);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fmoney_put0x3Cchar0x3E0x3A0x3A_0x5Fgather_info0x28bool0x2C0x20bool0x2C0x20std0x3A0x3A_0x5F20x3A0x3Alocale0x20const0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Amoney_base0x3A0x3Apattern0x260x2C0x20char0x260x2C0x20char0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x260x2C0x20int0x260x29(w2c_rlbox*, u32, u32, u32, u32, u32, u32, u32, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fmoney_put0x3Cchar0x3E0x3A0x3A_0x5Fformat0x28char0x2A0x2C0x20char0x2A0x260x2C0x20char0x2A0x260x2C0x20unsigned0x20int0x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Actype0x3Cchar0x3E0x20const0x260x2C0x20bool0x2C0x20std0x3A0x3A_0x5F20x3A0x3Amoney_base0x3A0x3Apattern0x20const0x260x2C0x20char0x2C0x20char0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x2C0x20int0x29(w2c_rlbox*, u32, u32, u32, u32, u32, u32, u32, u32, u32, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoney_put0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3Ado_put0x28std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20bool0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20char0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoney_put0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3Ado_put0x28std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20bool0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20wchar_t0x2C0x20long0x20double0x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u64, u64);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fmoney_put0x3Cwchar_t0x3E0x3A0x3A_0x5Fgather_info0x28bool0x2C0x20bool0x2C0x20std0x3A0x3A_0x5F20x3A0x3Alocale0x20const0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Amoney_base0x3A0x3Apattern0x260x2C0x20wchar_t0x260x2C0x20wchar_t0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cwchar_t0x3E0x3E0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cwchar_t0x3E0x3E0x260x2C0x20int0x260x29(w2c_rlbox*, u32, u32, u32, u32, u32, u32, u32, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fmoney_put0x3Cwchar_t0x3E0x3A0x3A_0x5Fformat0x28wchar_t0x2A0x2C0x20wchar_t0x2A0x260x2C0x20wchar_t0x2A0x260x2C0x20unsigned0x20int0x2C0x20wchar_t0x20const0x2A0x2C0x20wchar_t0x20const0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Actype0x3Cwchar_t0x3E0x20const0x260x2C0x20bool0x2C0x20std0x3A0x3A_0x5F20x3A0x3Amoney_base0x3A0x3Apattern0x20const0x260x2C0x20wchar_t0x2C0x20wchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cwchar_t0x3E0x3E0x20const0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cwchar_t0x3E0x3E0x20const0x260x2C0x20int0x29(w2c_rlbox*, u32, u32, u32, u32, u32, u32, u32, u32, u32, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoney_put0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3Ado_put0x28std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20bool0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20wchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cwchar_t0x3E0x3E0x20const0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amessages0x3Cchar0x3E0x3A0x3Ado_open0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Alocale0x20const0x260x290x20const(w2c_rlbox*, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amessages0x3Cchar0x3E0x3A0x3Ado_get0x28long0x2C0x20int0x2C0x20int0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amessages0x3Cchar0x3E0x3A0x3Ado_close0x28long0x290x20const(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amessages0x3Cwchar_t0x3E0x3A0x3Ado_open0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Alocale0x20const0x260x290x20const(w2c_rlbox*, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amessages0x3Cwchar_t0x3E0x3A0x3Ado_get0x28long0x2C0x20int0x2C0x20int0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cwchar_t0x3E0x3E0x20const0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amessages0x3Cwchar_t0x3E0x3A0x3Ado_close0x28long0x290x20const(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt_byname0x3Cchar0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3A0x7Ecodecvt_byname0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt_byname0x3Cchar0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3A0x7Ecodecvt_byname0x280x290x2E1(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt_byname0x3Cwchar_t0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3A0x7Ecodecvt_byname0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt_byname0x3Cwchar_t0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3A0x7Ecodecvt_byname0x280x290x2E1(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt_byname0x3Cchar16_t0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3A0x7Ecodecvt_byname0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt_byname0x3Cchar16_t0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3A0x7Ecodecvt_byname0x280x290x2E1(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt_byname0x3Cchar32_t0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3A0x7Ecodecvt_byname0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt_byname0x3Cchar32_t0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3A0x7Ecodecvt_byname0x280x290x2E1(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt_byname0x3Cchar16_t0x2C0x20char8_t0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3A0x7Ecodecvt_byname0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt_byname0x3Cchar16_t0x2C0x20char8_t0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3A0x7Ecodecvt_byname0x280x290x2E1(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt_byname0x3Cchar32_t0x2C0x20char8_t0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3A0x7Ecodecvt_byname0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt_byname0x3Cchar32_t0x2C0x20char8_t0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3A0x7Ecodecvt_byname0x280x290x2E1(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x3A0x3A_0x5Fimp0x28unsigned0x20long0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x3A0x3Ainstall0x3Cstd0x3A0x3A_0x5F20x3A0x3Acollate0x3Cchar0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Acollate0x3Cchar0x3E0x2A0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x3A0x3Ainstall0x3Cstd0x3A0x3A_0x5F20x3A0x3Acollate0x3Cwchar_t0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Acollate0x3Cwchar_t0x3E0x2A0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x3A0x3Ainstall0x3Cstd0x3A0x3A_0x5F20x3A0x3Actype0x3Cchar0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Actype0x3Cchar0x3E0x2A0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x3A0x3Ainstall0x3Cstd0x3A0x3A_0x5F20x3A0x3Actype0x3Cwchar_t0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Actype0x3Cwchar_t0x3E0x2A0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x3A0x3Ainstall0x3Cstd0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x2A0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x3A0x3Ainstall0x3Cstd0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cwchar_t0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cwchar_t0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x2A0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x3A0x3Ainstall0x3Cstd0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar16_t0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar16_t0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x2A0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x3A0x3Ainstall0x3Cstd0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar32_t0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar32_t0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x2A0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x3A0x3Ainstall0x3Cstd0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar16_t0x2C0x20char8_t0x2C0x20_0x5Fmbstate_t0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar16_t0x2C0x20char8_t0x2C0x20_0x5Fmbstate_t0x3E0x2A0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x3A0x3Ainstall0x3Cstd0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar32_t0x2C0x20char8_t0x2C0x20_0x5Fmbstate_t0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar32_t0x2C0x20char8_t0x2C0x20_0x5Fmbstate_t0x3E0x2A0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x3A0x3Ainstall0x3Cstd0x3A0x3A_0x5F20x3A0x3Anumpunct0x3Cchar0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Anumpunct0x3Cchar0x3E0x2A0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x3A0x3Ainstall0x3Cstd0x3A0x3A_0x5F20x3A0x3Anumpunct0x3Cwchar_t0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Anumpunct0x3Cwchar_t0x3E0x2A0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x3A0x3Ainstall0x3Cstd0x3A0x3A_0x5F20x3A0x3Anum_get0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Anum_get0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x2A0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x3A0x3Ainstall0x3Cstd0x3A0x3A_0x5F20x3A0x3Anum_get0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Anum_get0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x2A0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x3A0x3Ainstall0x3Cstd0x3A0x3A_0x5F20x3A0x3Anum_put0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Anum_put0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x2A0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x3A0x3Ainstall0x3Cstd0x3A0x3A_0x5F20x3A0x3Anum_put0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Anum_put0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x2A0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x3A0x3Ainstall0x3Cstd0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cchar0x2C0x20false0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cchar0x2C0x20false0x3E0x2A0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x3A0x3Ainstall0x3Cstd0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cchar0x2C0x20true0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cchar0x2C0x20true0x3E0x2A0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x3A0x3Ainstall0x3Cstd0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cwchar_t0x2C0x20false0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cwchar_t0x2C0x20false0x3E0x2A0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x3A0x3Ainstall0x3Cstd0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cwchar_t0x2C0x20true0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cwchar_t0x2C0x20true0x3E0x2A0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x3A0x3Ainstall0x3Cstd0x3A0x3A_0x5F20x3A0x3Amoney_get0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Amoney_get0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x2A0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x3A0x3Ainstall0x3Cstd0x3A0x3A_0x5F20x3A0x3Amoney_get0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Amoney_get0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x2A0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x3A0x3Ainstall0x3Cstd0x3A0x3A_0x5F20x3A0x3Amoney_put0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Amoney_put0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x2A0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x3A0x3Ainstall0x3Cstd0x3A0x3A_0x5F20x3A0x3Amoney_put0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Amoney_put0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x2A0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x3A0x3Ainstall0x3Cstd0x3A0x3A_0x5F20x3A0x3Atime_get0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Atime_get0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x2A0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x3A0x3Ainstall0x3Cstd0x3A0x3A_0x5F20x3A0x3Atime_get0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Atime_get0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x2A0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x3A0x3Ainstall0x3Cstd0x3A0x3A_0x5F20x3A0x3Atime_put0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Atime_put0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x2A0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x3A0x3Ainstall0x3Cstd0x3A0x3A_0x5F20x3A0x3Atime_put0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Atime_put0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x2A0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x3A0x3Ainstall0x3Cstd0x3A0x3A_0x5F20x3A0x3Amessages0x3Cchar0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Amessages0x3Cchar0x3E0x2A0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x3A0x3Ainstall0x3Cstd0x3A0x3A_0x5F20x3A0x3Amessages0x3Cwchar_t0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Amessages0x3Cwchar_t0x3E0x2A0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3Afacet0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fsso_allocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3Afacet0x2A0x2C0x2030ul0x3E0x3E0x3A0x3A_0x5Fappend0x28unsigned0x20long0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x3A0x3A_0x5Fimp0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x2C0x20unsigned0x20long0x29(w2c_rlbox*, u32, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3Afacet0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fsso_allocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3Afacet0x2A0x2C0x2030ul0x3E0x3E0x3A0x3A_0x5Fassign_with_size0x5Babi0x3Ann2101050x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3Afacet0x2A0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3Afacet0x2A0x2A0x3E0x28std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3Afacet0x2A0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3Afacet0x2A0x2A0x2C0x20long0x29(w2c_rlbox*, u32, u32, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x3A0x3Ainstall0x3Cstd0x3A0x3A_0x5F20x3A0x3Acollate_byname0x3Cchar0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Acollate_byname0x3Cchar0x3E0x2A0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x3A0x3Ainstall0x3Cstd0x3A0x3A_0x5F20x3A0x3Acollate_byname0x3Cwchar_t0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Acollate_byname0x3Cwchar_t0x3E0x2A0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x3A0x3Ainstall0x3Cstd0x3A0x3A_0x5F20x3A0x3Actype_byname0x3Cchar0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Actype_byname0x3Cchar0x3E0x2A0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x3A0x3Ainstall0x3Cstd0x3A0x3A_0x5F20x3A0x3Actype_byname0x3Cwchar_t0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Actype_byname0x3Cwchar_t0x3E0x2A0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x3A0x3Ainstall0x3Cstd0x3A0x3A_0x5F20x3A0x3Acodecvt_byname0x3Cchar0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Acodecvt_byname0x3Cchar0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x2A0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x3A0x3Ainstall0x3Cstd0x3A0x3A_0x5F20x3A0x3Acodecvt_byname0x3Cwchar_t0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Acodecvt_byname0x3Cwchar_t0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x2A0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x3A0x3Ainstall0x3Cstd0x3A0x3A_0x5F20x3A0x3Acodecvt_byname0x3Cchar16_t0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Acodecvt_byname0x3Cchar16_t0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x2A0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x3A0x3Ainstall0x3Cstd0x3A0x3A_0x5F20x3A0x3Acodecvt_byname0x3Cchar32_t0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Acodecvt_byname0x3Cchar32_t0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x2A0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x3A0x3Ainstall0x3Cstd0x3A0x3A_0x5F20x3A0x3Acodecvt_byname0x3Cchar16_t0x2C0x20char8_t0x2C0x20_0x5Fmbstate_t0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Acodecvt_byname0x3Cchar16_t0x2C0x20char8_t0x2C0x20_0x5Fmbstate_t0x3E0x2A0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x3A0x3Ainstall0x3Cstd0x3A0x3A_0x5F20x3A0x3Acodecvt_byname0x3Cchar32_t0x2C0x20char8_t0x2C0x20_0x5Fmbstate_t0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Acodecvt_byname0x3Cchar32_t0x2C0x20char8_t0x2C0x20_0x5Fmbstate_t0x3E0x2A0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x3A0x3Ainstall0x3Cstd0x3A0x3A_0x5F20x3A0x3Anumpunct_byname0x3Cchar0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Anumpunct_byname0x3Cchar0x3E0x2A0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x3A0x3Ainstall0x3Cstd0x3A0x3A_0x5F20x3A0x3Anumpunct_byname0x3Cwchar_t0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Anumpunct_byname0x3Cwchar_t0x3E0x2A0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cchar0x2C0x20false0x3E0x3A0x3Ainit0x28char0x20const0x2A0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x3A0x3Ainstall0x3Cstd0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cchar0x2C0x20false0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cchar0x2C0x20false0x3E0x2A0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cchar0x2C0x20true0x3E0x3A0x3Ainit0x28char0x20const0x2A0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x3A0x3Ainstall0x3Cstd0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cchar0x2C0x20true0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cchar0x2C0x20true0x3E0x2A0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cwchar_t0x2C0x20false0x3E0x3A0x3Ainit0x28char0x20const0x2A0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x3A0x3Ainstall0x3Cstd0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cwchar_t0x2C0x20false0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cwchar_t0x2C0x20false0x3E0x2A0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cwchar_t0x2C0x20true0x3E0x3A0x3Ainit0x28char0x20const0x2A0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x3A0x3Ainstall0x3Cstd0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cwchar_t0x2C0x20true0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cwchar_t0x2C0x20true0x3E0x2A0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Ftime_get_storage0x3Cchar0x3E0x3A0x3A_0x5Ftime_get_storage0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x3A0x3Ainstall0x3Cstd0x3A0x3A_0x5F20x3A0x3Atime_get_byname0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Atime_get_byname0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x2A0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Ftime_get_storage0x3Cwchar_t0x3E0x3A0x3A_0x5Ftime_get_storage0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x3A0x3Ainstall0x3Cstd0x3A0x3A_0x5F20x3A0x3Atime_get_byname0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Atime_get_byname0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x2A0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x3A0x3Ainstall0x3Cstd0x3A0x3A_0x5F20x3A0x3Atime_put_byname0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Atime_put_byname0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x2A0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x3A0x3Ainstall0x3Cstd0x3A0x3A_0x5F20x3A0x3Atime_put_byname0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Atime_put_byname0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x2A0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x3A0x3Ainstall0x3Cstd0x3A0x3A_0x5F20x3A0x3Amessages_byname0x3Cchar0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Amessages_byname0x3Cchar0x3E0x2A0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x3A0x3Ainstall0x3Cstd0x3A0x3A_0x5F20x3A0x3Amessages_byname0x3Cwchar_t0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Amessages_byname0x3Cwchar_t0x3E0x2A0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20std0x3A0x3A_0x5F20x3A0x3Aoperator0x2B0x5Babi0x3Ann2101050x5D0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x28char0x20const0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x260x260x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3Aclassic0x280x29(w2c_rlbox*);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x3A0x3A_0x5Fimp0x28std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x20const0x260x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3Afacet0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fsso_allocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3Afacet0x2A0x2C0x2030ul0x3E0x3E0x3A0x3A_0x5Fthrow_length_error0x5Babi0x3Ann2101050x5D0x280x29(w2c_rlbox*);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x3A0x3A_0x5Fimp0x28std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x20const0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x2C0x20int0x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x3A0x3A_0x5Fimp0x28std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x20const0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x20const0x260x2C0x20int0x29(w2c_rlbox*, u32, u32, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x3A0x3Ainstall_from0x3Cstd0x3A0x3A_0x5F20x3A0x3Acollate0x3Cchar0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x20const0x260x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x3A0x3Ainstall_from0x3Cstd0x3A0x3A_0x5F20x3A0x3Acollate0x3Cwchar_t0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x20const0x260x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x3A0x3Ainstall_from0x3Cstd0x3A0x3A_0x5F20x3A0x3Actype0x3Cchar0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x20const0x260x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x3A0x3Ainstall_from0x3Cstd0x3A0x3A_0x5F20x3A0x3Actype0x3Cwchar_t0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x20const0x260x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x3A0x3Ainstall_from0x3Cstd0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x20const0x260x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x3A0x3Ainstall_from0x3Cstd0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar16_t0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x20const0x260x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x3A0x3Ainstall_from0x3Cstd0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar32_t0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x20const0x260x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x3A0x3Ainstall_from0x3Cstd0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar16_t0x2C0x20char8_t0x2C0x20_0x5Fmbstate_t0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x20const0x260x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x3A0x3Ainstall_from0x3Cstd0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar32_t0x2C0x20char8_t0x2C0x20_0x5Fmbstate_t0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x20const0x260x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x3A0x3Ainstall_from0x3Cstd0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cwchar_t0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x20const0x260x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x3A0x3Ainstall_from0x3Cstd0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cchar0x2C0x20false0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x20const0x260x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x3A0x3Ainstall_from0x3Cstd0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cchar0x2C0x20true0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x20const0x260x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x3A0x3Ainstall_from0x3Cstd0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cwchar_t0x2C0x20false0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x20const0x260x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x3A0x3Ainstall_from0x3Cstd0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cwchar_t0x2C0x20true0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x20const0x260x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x3A0x3Ainstall_from0x3Cstd0x3A0x3A_0x5F20x3A0x3Amoney_get0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x20const0x260x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x3A0x3Ainstall_from0x3Cstd0x3A0x3A_0x5F20x3A0x3Amoney_get0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x20const0x260x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x3A0x3Ainstall_from0x3Cstd0x3A0x3A_0x5F20x3A0x3Amoney_put0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x20const0x260x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x3A0x3Ainstall_from0x3Cstd0x3A0x3A_0x5F20x3A0x3Amoney_put0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x20const0x260x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x3A0x3Ainstall_from0x3Cstd0x3A0x3A_0x5F20x3A0x3Anumpunct0x3Cchar0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x20const0x260x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x3A0x3Ainstall_from0x3Cstd0x3A0x3A_0x5F20x3A0x3Anumpunct0x3Cwchar_t0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x20const0x260x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x3A0x3Ainstall_from0x3Cstd0x3A0x3A_0x5F20x3A0x3Anum_get0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x20const0x260x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x3A0x3Ainstall_from0x3Cstd0x3A0x3A_0x5F20x3A0x3Anum_get0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x20const0x260x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x3A0x3Ainstall_from0x3Cstd0x3A0x3A_0x5F20x3A0x3Anum_put0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x20const0x260x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x3A0x3Ainstall_from0x3Cstd0x3A0x3A_0x5F20x3A0x3Anum_put0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x20const0x260x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x3A0x3Ainstall_from0x3Cstd0x3A0x3A_0x5F20x3A0x3Atime_get0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x20const0x260x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x3A0x3Ainstall_from0x3Cstd0x3A0x3A_0x5F20x3A0x3Atime_get0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x20const0x260x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x3A0x3Ainstall_from0x3Cstd0x3A0x3A_0x5F20x3A0x3Atime_put0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x20const0x260x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x3A0x3Ainstall_from0x3Cstd0x3A0x3A_0x5F20x3A0x3Atime_put0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x20const0x260x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x3A0x3Ainstall_from0x3Cstd0x3A0x3A_0x5F20x3A0x3Amessages0x3Cchar0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x20const0x260x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x3A0x3Ainstall_from0x3Cstd0x3A0x3A_0x5F20x3A0x3Amessages0x3Cwchar_t0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x20const0x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x3A0x3A_0x5Fimp0x28std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x20const0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3Afacet0x2A0x2C0x20long0x29(w2c_rlbox*, u32, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x3A0x3Ainstall0x28std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3Afacet0x2A0x2C0x20long0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x3A0x3A0x7E_0x5Fimp0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x3A0x3A0x7E_0x5Fimp0x280x290x2E1(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x3A0x3Ause_facet0x28long0x290x20const(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fglobal0x280x29(w2c_rlbox*);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x3A0x3Aacquire0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x3A0x3Arelease0x280x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3Alocale0x280x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3Alocale0x28std0x3A0x3A_0x5F20x3A0x3Alocale0x20const0x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A0x7Elocale0x280x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3Aoperator0x3D0x28std0x3A0x3A_0x5F20x3A0x3Alocale0x20const0x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3Alocale0x28char0x20const0x2A0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3Alocale0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3Alocale0x28std0x3A0x3A_0x5F20x3A0x3Alocale0x20const0x260x2C0x20char0x20const0x2A0x2C0x20int0x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3Alocale0x28std0x3A0x3A_0x5F20x3A0x3Alocale0x20const0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x2C0x20int0x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3Alocale0x28std0x3A0x3A_0x5F20x3A0x3Alocale0x20const0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Alocale0x20const0x260x2C0x20int0x29(w2c_rlbox*, u32, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3Aname0x280x290x20const(w2c_rlbox*, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Finstall_ctor0x28std0x3A0x3A_0x5F20x3A0x3Alocale0x20const0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3Afacet0x2A0x2C0x20long0x29(w2c_rlbox*, u32, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3Aglobal0x28std0x3A0x3A_0x5F20x3A0x3Alocale0x20const0x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3Ahas_facet0x28std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3Aid0x260x290x20const(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3Aid0x3A0x3A_0x5Fget0x280x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3Ause_facet0x28std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3Aid0x260x290x20const(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3Aoperator0x3D0x3D0x28std0x3A0x3A_0x5F20x3A0x3Alocale0x20const0x260x290x20const(w2c_rlbox*, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3Afacet0x3A0x3A0x7Efacet0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3Afacet0x3A0x3A_0x5Fon_zero_shared0x280x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acollate_byname0x3Cchar0x3E0x3A0x3Acollate_byname0x28char0x20const0x2A0x2C0x20unsigned0x20long0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acollate_byname0x3Cchar0x3E0x3A0x3Acollate_byname0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x2C0x20unsigned0x20long0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acollate_byname0x3Cchar0x3E0x3A0x3A0x7Ecollate_byname0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acollate_byname0x3Cchar0x3E0x3A0x3A0x7Ecollate_byname0x280x290x2E1(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acollate_byname0x3Cchar0x3E0x3A0x3Ado_compare0x28char0x20const0x2A0x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acollate_byname0x3Cchar0x3E0x3A0x3Ado_transform0x28char0x20const0x2A0x2C0x20char0x20const0x2A0x290x20const(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acollate_byname0x3Cwchar_t0x3E0x3A0x3Acollate_byname0x28char0x20const0x2A0x2C0x20unsigned0x20long0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acollate_byname0x3Cwchar_t0x3E0x3A0x3Acollate_byname0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x2C0x20unsigned0x20long0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acollate_byname0x3Cwchar_t0x3E0x3A0x3A0x7Ecollate_byname0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acollate_byname0x3Cwchar_t0x3E0x3A0x3A0x7Ecollate_byname0x280x290x2E1(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acollate_byname0x3Cwchar_t0x3E0x3A0x3Ado_compare0x28wchar_t0x20const0x2A0x2C0x20wchar_t0x20const0x2A0x2C0x20wchar_t0x20const0x2A0x2C0x20wchar_t0x20const0x2A0x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acollate_byname0x3Cwchar_t0x3E0x3A0x3Ado_transform0x28wchar_t0x20const0x2A0x2C0x20wchar_t0x20const0x2A0x290x20const(w2c_rlbox*, u32, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype0x3Cwchar_t0x3E0x3A0x3A0x7Ectype0x280x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype0x3Cwchar_t0x3E0x3A0x3Ado_is0x28unsigned0x20long0x2C0x20wchar_t0x290x20const(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype0x3Cchar0x3E0x3A0x3Aclassic_table0x280x29(w2c_rlbox*);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype0x3Cwchar_t0x3E0x3A0x3Ado_is0x28wchar_t0x20const0x2A0x2C0x20wchar_t0x20const0x2A0x2C0x20unsigned0x20long0x2A0x290x20const(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype0x3Cwchar_t0x3E0x3A0x3Ado_scan_is0x28unsigned0x20long0x2C0x20wchar_t0x20const0x2A0x2C0x20wchar_t0x20const0x2A0x290x20const(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype0x3Cwchar_t0x3E0x3A0x3Ado_scan_not0x28unsigned0x20long0x2C0x20wchar_t0x20const0x2A0x2C0x20wchar_t0x20const0x2A0x290x20const(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype0x3Cwchar_t0x3E0x3A0x3Ado_toupper0x28wchar_t0x290x20const(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype0x3Cwchar_t0x3E0x3A0x3Ado_toupper0x28wchar_t0x2A0x2C0x20wchar_t0x20const0x2A0x290x20const(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype0x3Cwchar_t0x3E0x3A0x3Ado_tolower0x28wchar_t0x290x20const(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype0x3Cwchar_t0x3E0x3A0x3Ado_tolower0x28wchar_t0x2A0x2C0x20wchar_t0x20const0x2A0x290x20const(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype0x3Cwchar_t0x3E0x3A0x3Ado_widen0x28char0x290x20const(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype0x3Cwchar_t0x3E0x3A0x3Ado_widen0x28char0x20const0x2A0x2C0x20char0x20const0x2A0x2C0x20wchar_t0x2A0x290x20const(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype0x3Cwchar_t0x3E0x3A0x3Ado_narrow0x28wchar_t0x2C0x20char0x290x20const(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype0x3Cwchar_t0x3E0x3A0x3Ado_narrow0x28wchar_t0x20const0x2A0x2C0x20wchar_t0x20const0x2A0x2C0x20char0x2C0x20char0x2A0x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype0x3Cchar0x3E0x3A0x3Actype0x28unsigned0x20long0x20const0x2A0x2C0x20bool0x2C0x20unsigned0x20long0x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype0x3Cchar0x3E0x3A0x3A0x7Ectype0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype0x3Cchar0x3E0x3A0x3A0x7Ectype0x280x290x2E1(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype0x3Cchar0x3E0x3A0x3Ado_toupper0x28char0x290x20const(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype0x3Cchar0x3E0x3A0x3Ado_toupper0x28char0x2A0x2C0x20char0x20const0x2A0x290x20const(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype0x3Cchar0x3E0x3A0x3Ado_tolower0x28char0x290x20const(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype0x3Cchar0x3E0x3A0x3Ado_tolower0x28char0x2A0x2C0x20char0x20const0x2A0x290x20const(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype0x3Cchar0x3E0x3A0x3Ado_widen0x28char0x290x20const(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype0x3Cchar0x3E0x3A0x3Ado_widen0x28char0x20const0x2A0x2C0x20char0x20const0x2A0x2C0x20char0x2A0x290x20const(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype0x3Cchar0x3E0x3A0x3Ado_narrow0x28char0x2C0x20char0x290x20const(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype0x3Cchar0x3E0x3A0x3Ado_narrow0x28char0x20const0x2A0x2C0x20char0x20const0x2A0x2C0x20char0x2C0x20char0x2A0x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype_byname0x3Cchar0x3E0x3A0x3Actype_byname0x28char0x20const0x2A0x2C0x20unsigned0x20long0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype_byname0x3Cchar0x3E0x3A0x3Actype_byname0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x2C0x20unsigned0x20long0x29(w2c_rlbox*, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype_byname0x3Cchar0x3E0x3A0x3A0x7Ectype_byname0x280x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype_byname0x3Cchar0x3E0x3A0x3Ado_toupper0x28char0x290x20const(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype_byname0x3Cchar0x3E0x3A0x3Ado_toupper0x28char0x2A0x2C0x20char0x20const0x2A0x290x20const(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype_byname0x3Cchar0x3E0x3A0x3Ado_tolower0x28char0x290x20const(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype_byname0x3Cchar0x3E0x3A0x3Ado_tolower0x28char0x2A0x2C0x20char0x20const0x2A0x290x20const(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype_byname0x3Cwchar_t0x3E0x3A0x3Actype_byname0x28char0x20const0x2A0x2C0x20unsigned0x20long0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype_byname0x3Cwchar_t0x3E0x3A0x3Actype_byname0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x2C0x20unsigned0x20long0x29(w2c_rlbox*, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype_byname0x3Cwchar_t0x3E0x3A0x3A0x7Ectype_byname0x280x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype_byname0x3Cwchar_t0x3E0x3A0x3Ado_is0x28unsigned0x20long0x2C0x20wchar_t0x290x20const(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype_byname0x3Cwchar_t0x3E0x3A0x3Ado_is0x28wchar_t0x20const0x2A0x2C0x20wchar_t0x20const0x2A0x2C0x20unsigned0x20long0x2A0x290x20const(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype_byname0x3Cwchar_t0x3E0x3A0x3Ado_scan_is0x28unsigned0x20long0x2C0x20wchar_t0x20const0x2A0x2C0x20wchar_t0x20const0x2A0x290x20const(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype_byname0x3Cwchar_t0x3E0x3A0x3Ado_scan_not0x28unsigned0x20long0x2C0x20wchar_t0x20const0x2A0x2C0x20wchar_t0x20const0x2A0x290x20const(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype_byname0x3Cwchar_t0x3E0x3A0x3Ado_toupper0x28wchar_t0x290x20const(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype_byname0x3Cwchar_t0x3E0x3A0x3Ado_toupper0x28wchar_t0x2A0x2C0x20wchar_t0x20const0x2A0x290x20const(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype_byname0x3Cwchar_t0x3E0x3A0x3Ado_tolower0x28wchar_t0x290x20const(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype_byname0x3Cwchar_t0x3E0x3A0x3Ado_tolower0x28wchar_t0x2A0x2C0x20wchar_t0x20const0x2A0x290x20const(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype_byname0x3Cwchar_t0x3E0x3A0x3Ado_widen0x28char0x290x20const(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype_byname0x3Cwchar_t0x3E0x3A0x3Ado_widen0x28char0x20const0x2A0x2C0x20char0x20const0x2A0x2C0x20wchar_t0x2A0x290x20const(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype_byname0x3Cwchar_t0x3E0x3A0x3Ado_narrow0x28wchar_t0x2C0x20char0x290x20const(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype_byname0x3Cwchar_t0x3E0x3A0x3Ado_narrow0x28wchar_t0x20const0x2A0x2C0x20wchar_t0x20const0x2A0x2C0x20char0x2C0x20char0x2A0x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3A0x7Ecodecvt0x280x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_out0x28_0x5Fmbstate_t0x260x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x260x2C0x20char0x2A0x2C0x20char0x2A0x2C0x20char0x2A0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_in0x28_0x5Fmbstate_t0x260x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x260x2C0x20char0x2A0x2C0x20char0x2A0x2C0x20char0x2A0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_unshift0x28_0x5Fmbstate_t0x260x2C0x20char0x2A0x2C0x20char0x2A0x2C0x20char0x2A0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_encoding0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_always_noconv0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_length0x28_0x5Fmbstate_t0x260x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x2C0x20unsigned0x20long0x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_max_length0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cwchar_t0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Acodecvt0x28unsigned0x20long0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cwchar_t0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Acodecvt0x28char0x20const0x2A0x2C0x20unsigned0x20long0x29(w2c_rlbox*, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cwchar_t0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3A0x7Ecodecvt0x280x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cwchar_t0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_out0x28_0x5Fmbstate_t0x260x2C0x20wchar_t0x20const0x2A0x2C0x20wchar_t0x20const0x2A0x2C0x20wchar_t0x20const0x2A0x260x2C0x20char0x2A0x2C0x20char0x2A0x2C0x20char0x2A0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cwchar_t0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_in0x28_0x5Fmbstate_t0x260x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x260x2C0x20wchar_t0x2A0x2C0x20wchar_t0x2A0x2C0x20wchar_t0x2A0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cwchar_t0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_unshift0x28_0x5Fmbstate_t0x260x2C0x20char0x2A0x2C0x20char0x2A0x2C0x20char0x2A0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cwchar_t0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_encoding0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cwchar_t0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_always_noconv0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cwchar_t0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_length0x28_0x5Fmbstate_t0x260x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x2C0x20unsigned0x20long0x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cwchar_t0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_max_length0x280x290x20const(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar16_t0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3A0x7Ecodecvt0x280x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar16_t0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_out0x28_0x5Fmbstate_t0x260x2C0x20char16_t0x20const0x2A0x2C0x20char16_t0x20const0x2A0x2C0x20char16_t0x20const0x2A0x260x2C0x20char0x2A0x2C0x20char0x2A0x2C0x20char0x2A0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Autf16_to_utf80x28unsigned0x20short0x20const0x2A0x2C0x20unsigned0x20short0x20const0x2A0x2C0x20unsigned0x20short0x20const0x2A0x260x2C0x20unsigned0x20char0x2A0x2C0x20unsigned0x20char0x2A0x2C0x20unsigned0x20char0x2A0x260x2C0x20unsigned0x20long0x2C0x20std0x3A0x3A_0x5F20x3A0x3Acodecvt_mode0x29(w2c_rlbox*, u32, u32, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar16_t0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_in0x28_0x5Fmbstate_t0x260x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x260x2C0x20char16_t0x2A0x2C0x20char16_t0x2A0x2C0x20char16_t0x2A0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Autf8_to_utf160x28unsigned0x20char0x20const0x2A0x2C0x20unsigned0x20char0x20const0x2A0x2C0x20unsigned0x20char0x20const0x2A0x260x2C0x20unsigned0x20short0x2A0x2C0x20unsigned0x20short0x2A0x2C0x20unsigned0x20short0x2A0x260x2C0x20unsigned0x20long0x2C0x20std0x3A0x3A_0x5F20x3A0x3Acodecvt_mode0x29(w2c_rlbox*, u32, u32, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar16_t0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_unshift0x28_0x5Fmbstate_t0x260x2C0x20char0x2A0x2C0x20char0x2A0x2C0x20char0x2A0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar16_t0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_encoding0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar16_t0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_always_noconv0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar16_t0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_length0x28_0x5Fmbstate_t0x260x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x2C0x20unsigned0x20long0x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Autf8_to_utf16_length0x28unsigned0x20char0x20const0x2A0x2C0x20unsigned0x20char0x20const0x2A0x2C0x20unsigned0x20long0x2C0x20unsigned0x20long0x2C0x20std0x3A0x3A_0x5F20x3A0x3Acodecvt_mode0x29(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar16_t0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_max_length0x280x290x20const(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar16_t0x2C0x20char8_t0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3A0x7Ecodecvt0x280x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar16_t0x2C0x20char8_t0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_out0x28_0x5Fmbstate_t0x260x2C0x20char16_t0x20const0x2A0x2C0x20char16_t0x20const0x2A0x2C0x20char16_t0x20const0x2A0x260x2C0x20char8_t0x2A0x2C0x20char8_t0x2A0x2C0x20char8_t0x2A0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar16_t0x2C0x20char8_t0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_in0x28_0x5Fmbstate_t0x260x2C0x20char8_t0x20const0x2A0x2C0x20char8_t0x20const0x2A0x2C0x20char8_t0x20const0x2A0x260x2C0x20char16_t0x2A0x2C0x20char16_t0x2A0x2C0x20char16_t0x2A0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar16_t0x2C0x20char8_t0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_unshift0x28_0x5Fmbstate_t0x260x2C0x20char8_t0x2A0x2C0x20char8_t0x2A0x2C0x20char8_t0x2A0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar16_t0x2C0x20char8_t0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_encoding0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar16_t0x2C0x20char8_t0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_always_noconv0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar16_t0x2C0x20char8_t0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_length0x28_0x5Fmbstate_t0x260x2C0x20char8_t0x20const0x2A0x2C0x20char8_t0x20const0x2A0x2C0x20unsigned0x20long0x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar16_t0x2C0x20char8_t0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_max_length0x280x290x20const(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar32_t0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3A0x7Ecodecvt0x280x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar32_t0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_out0x28_0x5Fmbstate_t0x260x2C0x20char32_t0x20const0x2A0x2C0x20char32_t0x20const0x2A0x2C0x20char32_t0x20const0x2A0x260x2C0x20char0x2A0x2C0x20char0x2A0x2C0x20char0x2A0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Aucs4_to_utf80x28unsigned0x20int0x20const0x2A0x2C0x20unsigned0x20int0x20const0x2A0x2C0x20unsigned0x20int0x20const0x2A0x260x2C0x20unsigned0x20char0x2A0x2C0x20unsigned0x20char0x2A0x2C0x20unsigned0x20char0x2A0x260x2C0x20unsigned0x20long0x2C0x20std0x3A0x3A_0x5F20x3A0x3Acodecvt_mode0x29(w2c_rlbox*, u32, u32, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar32_t0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_in0x28_0x5Fmbstate_t0x260x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x260x2C0x20char32_t0x2A0x2C0x20char32_t0x2A0x2C0x20char32_t0x2A0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Autf8_to_ucs40x28unsigned0x20char0x20const0x2A0x2C0x20unsigned0x20char0x20const0x2A0x2C0x20unsigned0x20char0x20const0x2A0x260x2C0x20unsigned0x20int0x2A0x2C0x20unsigned0x20int0x2A0x2C0x20unsigned0x20int0x2A0x260x2C0x20unsigned0x20long0x2C0x20std0x3A0x3A_0x5F20x3A0x3Acodecvt_mode0x29(w2c_rlbox*, u32, u32, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar32_t0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_unshift0x28_0x5Fmbstate_t0x260x2C0x20char0x2A0x2C0x20char0x2A0x2C0x20char0x2A0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar32_t0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_encoding0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar32_t0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_always_noconv0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar32_t0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_length0x28_0x5Fmbstate_t0x260x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x2C0x20unsigned0x20long0x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Autf8_to_ucs4_length0x28unsigned0x20char0x20const0x2A0x2C0x20unsigned0x20char0x20const0x2A0x2C0x20unsigned0x20long0x2C0x20unsigned0x20long0x2C0x20std0x3A0x3A_0x5F20x3A0x3Acodecvt_mode0x29(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar32_t0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_max_length0x280x290x20const(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar32_t0x2C0x20char8_t0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3A0x7Ecodecvt0x280x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar32_t0x2C0x20char8_t0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_out0x28_0x5Fmbstate_t0x260x2C0x20char32_t0x20const0x2A0x2C0x20char32_t0x20const0x2A0x2C0x20char32_t0x20const0x2A0x260x2C0x20char8_t0x2A0x2C0x20char8_t0x2A0x2C0x20char8_t0x2A0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar32_t0x2C0x20char8_t0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_in0x28_0x5Fmbstate_t0x260x2C0x20char8_t0x20const0x2A0x2C0x20char8_t0x20const0x2A0x2C0x20char8_t0x20const0x2A0x260x2C0x20char32_t0x2A0x2C0x20char32_t0x2A0x2C0x20char32_t0x2A0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar32_t0x2C0x20char8_t0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_unshift0x28_0x5Fmbstate_t0x260x2C0x20char8_t0x2A0x2C0x20char8_t0x2A0x2C0x20char8_t0x2A0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar32_t0x2C0x20char8_t0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_encoding0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar32_t0x2C0x20char8_t0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_always_noconv0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar32_t0x2C0x20char8_t0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_length0x28_0x5Fmbstate_t0x260x2C0x20char8_t0x20const0x2A0x2C0x20char8_t0x20const0x2A0x2C0x20unsigned0x20long0x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar32_t0x2C0x20char8_t0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_max_length0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf80x3Cwchar_t0x3E0x3A0x3Ado_out0x28_0x5Fmbstate_t0x260x2C0x20wchar_t0x20const0x2A0x2C0x20wchar_t0x20const0x2A0x2C0x20wchar_t0x20const0x2A0x260x2C0x20char0x2A0x2C0x20char0x2A0x2C0x20char0x2A0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf80x3Cwchar_t0x3E0x3A0x3Ado_in0x28_0x5Fmbstate_t0x260x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x260x2C0x20wchar_t0x2A0x2C0x20wchar_t0x2A0x2C0x20wchar_t0x2A0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf80x3Cwchar_t0x3E0x3A0x3Ado_unshift0x28_0x5Fmbstate_t0x260x2C0x20char0x2A0x2C0x20char0x2A0x2C0x20char0x2A0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf80x3Cwchar_t0x3E0x3A0x3Ado_encoding0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf80x3Cwchar_t0x3E0x3A0x3Ado_always_noconv0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf80x3Cwchar_t0x3E0x3A0x3Ado_length0x28_0x5Fmbstate_t0x260x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x2C0x20unsigned0x20long0x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf80x3Cwchar_t0x3E0x3A0x3Ado_max_length0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf80x3Cchar16_t0x3E0x3A0x3Ado_out0x28_0x5Fmbstate_t0x260x2C0x20char16_t0x20const0x2A0x2C0x20char16_t0x20const0x2A0x2C0x20char16_t0x20const0x2A0x260x2C0x20char0x2A0x2C0x20char0x2A0x2C0x20char0x2A0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf80x3Cchar16_t0x3E0x3A0x3Ado_in0x28_0x5Fmbstate_t0x260x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x260x2C0x20char16_t0x2A0x2C0x20char16_t0x2A0x2C0x20char16_t0x2A0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf80x3Cchar16_t0x3E0x3A0x3Ado_unshift0x28_0x5Fmbstate_t0x260x2C0x20char0x2A0x2C0x20char0x2A0x2C0x20char0x2A0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf80x3Cchar16_t0x3E0x3A0x3Ado_encoding0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf80x3Cchar16_t0x3E0x3A0x3Ado_always_noconv0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf80x3Cchar16_t0x3E0x3A0x3Ado_length0x28_0x5Fmbstate_t0x260x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x2C0x20unsigned0x20long0x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf80x3Cchar16_t0x3E0x3A0x3Ado_max_length0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf80x3Cchar32_t0x3E0x3A0x3Ado_out0x28_0x5Fmbstate_t0x260x2C0x20char32_t0x20const0x2A0x2C0x20char32_t0x20const0x2A0x2C0x20char32_t0x20const0x2A0x260x2C0x20char0x2A0x2C0x20char0x2A0x2C0x20char0x2A0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf80x3Cchar32_t0x3E0x3A0x3Ado_in0x28_0x5Fmbstate_t0x260x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x260x2C0x20char32_t0x2A0x2C0x20char32_t0x2A0x2C0x20char32_t0x2A0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf80x3Cchar32_t0x3E0x3A0x3Ado_unshift0x28_0x5Fmbstate_t0x260x2C0x20char0x2A0x2C0x20char0x2A0x2C0x20char0x2A0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf80x3Cchar32_t0x3E0x3A0x3Ado_encoding0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf80x3Cchar32_t0x3E0x3A0x3Ado_always_noconv0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf80x3Cchar32_t0x3E0x3A0x3Ado_length0x28_0x5Fmbstate_t0x260x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x2C0x20unsigned0x20long0x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf80x3Cchar32_t0x3E0x3A0x3Ado_max_length0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf160x3Cwchar_t0x2C0x20false0x3E0x3A0x3Ado_out0x28_0x5Fmbstate_t0x260x2C0x20wchar_t0x20const0x2A0x2C0x20wchar_t0x20const0x2A0x2C0x20wchar_t0x20const0x2A0x260x2C0x20char0x2A0x2C0x20char0x2A0x2C0x20char0x2A0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf160x3Cwchar_t0x2C0x20false0x3E0x3A0x3Ado_in0x28_0x5Fmbstate_t0x260x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x260x2C0x20wchar_t0x2A0x2C0x20wchar_t0x2A0x2C0x20wchar_t0x2A0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf160x3Cwchar_t0x2C0x20false0x3E0x3A0x3Ado_unshift0x28_0x5Fmbstate_t0x260x2C0x20char0x2A0x2C0x20char0x2A0x2C0x20char0x2A0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf160x3Cwchar_t0x2C0x20false0x3E0x3A0x3Ado_encoding0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf160x3Cwchar_t0x2C0x20false0x3E0x3A0x3Ado_always_noconv0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf160x3Cwchar_t0x2C0x20false0x3E0x3A0x3Ado_length0x28_0x5Fmbstate_t0x260x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x2C0x20unsigned0x20long0x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf160x3Cwchar_t0x2C0x20false0x3E0x3A0x3Ado_max_length0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf160x3Cwchar_t0x2C0x20true0x3E0x3A0x3Ado_out0x28_0x5Fmbstate_t0x260x2C0x20wchar_t0x20const0x2A0x2C0x20wchar_t0x20const0x2A0x2C0x20wchar_t0x20const0x2A0x260x2C0x20char0x2A0x2C0x20char0x2A0x2C0x20char0x2A0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf160x3Cwchar_t0x2C0x20true0x3E0x3A0x3Ado_in0x28_0x5Fmbstate_t0x260x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x260x2C0x20wchar_t0x2A0x2C0x20wchar_t0x2A0x2C0x20wchar_t0x2A0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf160x3Cwchar_t0x2C0x20true0x3E0x3A0x3Ado_unshift0x28_0x5Fmbstate_t0x260x2C0x20char0x2A0x2C0x20char0x2A0x2C0x20char0x2A0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf160x3Cwchar_t0x2C0x20true0x3E0x3A0x3Ado_encoding0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf160x3Cwchar_t0x2C0x20true0x3E0x3A0x3Ado_always_noconv0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf160x3Cwchar_t0x2C0x20true0x3E0x3A0x3Ado_length0x28_0x5Fmbstate_t0x260x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x2C0x20unsigned0x20long0x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf160x3Cwchar_t0x2C0x20true0x3E0x3A0x3Ado_max_length0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf160x3Cchar16_t0x2C0x20false0x3E0x3A0x3Ado_out0x28_0x5Fmbstate_t0x260x2C0x20char16_t0x20const0x2A0x2C0x20char16_t0x20const0x2A0x2C0x20char16_t0x20const0x2A0x260x2C0x20char0x2A0x2C0x20char0x2A0x2C0x20char0x2A0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf160x3Cchar16_t0x2C0x20false0x3E0x3A0x3Ado_in0x28_0x5Fmbstate_t0x260x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x260x2C0x20char16_t0x2A0x2C0x20char16_t0x2A0x2C0x20char16_t0x2A0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf160x3Cchar16_t0x2C0x20false0x3E0x3A0x3Ado_unshift0x28_0x5Fmbstate_t0x260x2C0x20char0x2A0x2C0x20char0x2A0x2C0x20char0x2A0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf160x3Cchar16_t0x2C0x20false0x3E0x3A0x3Ado_encoding0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf160x3Cchar16_t0x2C0x20false0x3E0x3A0x3Ado_always_noconv0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf160x3Cchar16_t0x2C0x20false0x3E0x3A0x3Ado_length0x28_0x5Fmbstate_t0x260x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x2C0x20unsigned0x20long0x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf160x3Cchar16_t0x2C0x20false0x3E0x3A0x3Ado_max_length0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf160x3Cchar16_t0x2C0x20true0x3E0x3A0x3Ado_out0x28_0x5Fmbstate_t0x260x2C0x20char16_t0x20const0x2A0x2C0x20char16_t0x20const0x2A0x2C0x20char16_t0x20const0x2A0x260x2C0x20char0x2A0x2C0x20char0x2A0x2C0x20char0x2A0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf160x3Cchar16_t0x2C0x20true0x3E0x3A0x3Ado_in0x28_0x5Fmbstate_t0x260x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x260x2C0x20char16_t0x2A0x2C0x20char16_t0x2A0x2C0x20char16_t0x2A0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf160x3Cchar16_t0x2C0x20true0x3E0x3A0x3Ado_unshift0x28_0x5Fmbstate_t0x260x2C0x20char0x2A0x2C0x20char0x2A0x2C0x20char0x2A0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf160x3Cchar16_t0x2C0x20true0x3E0x3A0x3Ado_encoding0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf160x3Cchar16_t0x2C0x20true0x3E0x3A0x3Ado_always_noconv0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf160x3Cchar16_t0x2C0x20true0x3E0x3A0x3Ado_length0x28_0x5Fmbstate_t0x260x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x2C0x20unsigned0x20long0x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf160x3Cchar16_t0x2C0x20true0x3E0x3A0x3Ado_max_length0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf160x3Cchar32_t0x2C0x20false0x3E0x3A0x3Ado_out0x28_0x5Fmbstate_t0x260x2C0x20char32_t0x20const0x2A0x2C0x20char32_t0x20const0x2A0x2C0x20char32_t0x20const0x2A0x260x2C0x20char0x2A0x2C0x20char0x2A0x2C0x20char0x2A0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf160x3Cchar32_t0x2C0x20false0x3E0x3A0x3Ado_in0x28_0x5Fmbstate_t0x260x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x260x2C0x20char32_t0x2A0x2C0x20char32_t0x2A0x2C0x20char32_t0x2A0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf160x3Cchar32_t0x2C0x20false0x3E0x3A0x3Ado_unshift0x28_0x5Fmbstate_t0x260x2C0x20char0x2A0x2C0x20char0x2A0x2C0x20char0x2A0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf160x3Cchar32_t0x2C0x20false0x3E0x3A0x3Ado_encoding0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf160x3Cchar32_t0x2C0x20false0x3E0x3A0x3Ado_always_noconv0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf160x3Cchar32_t0x2C0x20false0x3E0x3A0x3Ado_length0x28_0x5Fmbstate_t0x260x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x2C0x20unsigned0x20long0x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf160x3Cchar32_t0x2C0x20false0x3E0x3A0x3Ado_max_length0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf160x3Cchar32_t0x2C0x20true0x3E0x3A0x3Ado_out0x28_0x5Fmbstate_t0x260x2C0x20char32_t0x20const0x2A0x2C0x20char32_t0x20const0x2A0x2C0x20char32_t0x20const0x2A0x260x2C0x20char0x2A0x2C0x20char0x2A0x2C0x20char0x2A0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf160x3Cchar32_t0x2C0x20true0x3E0x3A0x3Ado_in0x28_0x5Fmbstate_t0x260x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x260x2C0x20char32_t0x2A0x2C0x20char32_t0x2A0x2C0x20char32_t0x2A0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf160x3Cchar32_t0x2C0x20true0x3E0x3A0x3Ado_unshift0x28_0x5Fmbstate_t0x260x2C0x20char0x2A0x2C0x20char0x2A0x2C0x20char0x2A0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf160x3Cchar32_t0x2C0x20true0x3E0x3A0x3Ado_encoding0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf160x3Cchar32_t0x2C0x20true0x3E0x3A0x3Ado_always_noconv0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf160x3Cchar32_t0x2C0x20true0x3E0x3A0x3Ado_length0x28_0x5Fmbstate_t0x260x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x2C0x20unsigned0x20long0x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf160x3Cchar32_t0x2C0x20true0x3E0x3A0x3Ado_max_length0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf8_utf160x3Cwchar_t0x3E0x3A0x3Ado_out0x28_0x5Fmbstate_t0x260x2C0x20wchar_t0x20const0x2A0x2C0x20wchar_t0x20const0x2A0x2C0x20wchar_t0x20const0x2A0x260x2C0x20char0x2A0x2C0x20char0x2A0x2C0x20char0x2A0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Autf16_to_utf80x28unsigned0x20int0x20const0x2A0x2C0x20unsigned0x20int0x20const0x2A0x2C0x20unsigned0x20int0x20const0x2A0x260x2C0x20unsigned0x20char0x2A0x2C0x20unsigned0x20char0x2A0x2C0x20unsigned0x20char0x2A0x260x2C0x20unsigned0x20long0x2C0x20std0x3A0x3A_0x5F20x3A0x3Acodecvt_mode0x29(w2c_rlbox*, u32, u32, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf8_utf160x3Cwchar_t0x3E0x3A0x3Ado_in0x28_0x5Fmbstate_t0x260x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x260x2C0x20wchar_t0x2A0x2C0x20wchar_t0x2A0x2C0x20wchar_t0x2A0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Autf8_to_utf160x28unsigned0x20char0x20const0x2A0x2C0x20unsigned0x20char0x20const0x2A0x2C0x20unsigned0x20char0x20const0x2A0x260x2C0x20unsigned0x20int0x2A0x2C0x20unsigned0x20int0x2A0x2C0x20unsigned0x20int0x2A0x260x2C0x20unsigned0x20long0x2C0x20std0x3A0x3A_0x5F20x3A0x3Acodecvt_mode0x29(w2c_rlbox*, u32, u32, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf8_utf160x3Cwchar_t0x3E0x3A0x3Ado_unshift0x28_0x5Fmbstate_t0x260x2C0x20char0x2A0x2C0x20char0x2A0x2C0x20char0x2A0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf8_utf160x3Cwchar_t0x3E0x3A0x3Ado_encoding0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf8_utf160x3Cwchar_t0x3E0x3A0x3Ado_always_noconv0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf8_utf160x3Cwchar_t0x3E0x3A0x3Ado_length0x28_0x5Fmbstate_t0x260x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x2C0x20unsigned0x20long0x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf8_utf160x3Cwchar_t0x3E0x3A0x3Ado_max_length0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf8_utf160x3Cchar16_t0x3E0x3A0x3Ado_out0x28_0x5Fmbstate_t0x260x2C0x20char16_t0x20const0x2A0x2C0x20char16_t0x20const0x2A0x2C0x20char16_t0x20const0x2A0x260x2C0x20char0x2A0x2C0x20char0x2A0x2C0x20char0x2A0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf8_utf160x3Cchar16_t0x3E0x3A0x3Ado_in0x28_0x5Fmbstate_t0x260x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x260x2C0x20char16_t0x2A0x2C0x20char16_t0x2A0x2C0x20char16_t0x2A0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf8_utf160x3Cchar16_t0x3E0x3A0x3Ado_unshift0x28_0x5Fmbstate_t0x260x2C0x20char0x2A0x2C0x20char0x2A0x2C0x20char0x2A0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf8_utf160x3Cchar16_t0x3E0x3A0x3Ado_encoding0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf8_utf160x3Cchar16_t0x3E0x3A0x3Ado_always_noconv0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf8_utf160x3Cchar16_t0x3E0x3A0x3Ado_length0x28_0x5Fmbstate_t0x260x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x2C0x20unsigned0x20long0x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf8_utf160x3Cchar16_t0x3E0x3A0x3Ado_max_length0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf8_utf160x3Cchar32_t0x3E0x3A0x3Ado_out0x28_0x5Fmbstate_t0x260x2C0x20char32_t0x20const0x2A0x2C0x20char32_t0x20const0x2A0x2C0x20char32_t0x20const0x2A0x260x2C0x20char0x2A0x2C0x20char0x2A0x2C0x20char0x2A0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf8_utf160x3Cchar32_t0x3E0x3A0x3Ado_in0x28_0x5Fmbstate_t0x260x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x260x2C0x20char32_t0x2A0x2C0x20char32_t0x2A0x2C0x20char32_t0x2A0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf8_utf160x3Cchar32_t0x3E0x3A0x3Ado_unshift0x28_0x5Fmbstate_t0x260x2C0x20char0x2A0x2C0x20char0x2A0x2C0x20char0x2A0x260x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf8_utf160x3Cchar32_t0x3E0x3A0x3Ado_encoding0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf8_utf160x3Cchar32_t0x3E0x3A0x3Ado_always_noconv0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf8_utf160x3Cchar32_t0x3E0x3A0x3Ado_length0x28_0x5Fmbstate_t0x260x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x2C0x20unsigned0x20long0x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf8_utf160x3Cchar32_t0x3E0x3A0x3Ado_max_length0x280x290x20const(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fnarrow_to_utf80x3C16ul0x3E0x3A0x3A0x7E_0x5Fnarrow_to_utf80x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fnarrow_to_utf80x3C32ul0x3E0x3A0x3A0x7E_0x5Fnarrow_to_utf80x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fwiden_from_utf80x3C16ul0x3E0x3A0x3A0x7E_0x5Fwiden_from_utf80x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fwiden_from_utf80x3C32ul0x3E0x3A0x3A0x7E_0x5Fwiden_from_utf80x280x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anumpunct0x3Cchar0x3E0x3A0x3Anumpunct0x28unsigned0x20long0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anumpunct0x3Cwchar_t0x3E0x3A0x3Anumpunct0x28unsigned0x20long0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anumpunct0x3Cchar0x3E0x3A0x3A0x7Enumpunct0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anumpunct0x3Cchar0x3E0x3A0x3A0x7Enumpunct0x280x290x2E1(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anumpunct0x3Cwchar_t0x3E0x3A0x3A0x7Enumpunct0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anumpunct0x3Cwchar_t0x3E0x3A0x3A0x7Enumpunct0x280x290x2E1(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anumpunct0x3Cchar0x3E0x3A0x3Ado_decimal_point0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anumpunct0x3Cwchar_t0x3E0x3A0x3Ado_decimal_point0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anumpunct0x3Cchar0x3E0x3A0x3Ado_thousands_sep0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anumpunct0x3Cwchar_t0x3E0x3A0x3Ado_thousands_sep0x280x290x20const(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anumpunct0x3Cchar0x3E0x3A0x3Ado_grouping0x280x290x20const(w2c_rlbox*, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anumpunct0x3Cwchar_t0x3E0x3A0x3Ado_grouping0x280x290x20const(w2c_rlbox*, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anumpunct0x3Cchar0x3E0x3A0x3Ado_truename0x280x290x20const(w2c_rlbox*, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anumpunct0x3Cwchar_t0x3E0x3A0x3Ado_truename0x280x290x20const(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cwchar_t0x3E0x3E0x3A0x3Abasic_string0x5Babi0x3Ann2101050x5D0x3C00x3E0x28wchar_t0x20const0x2A0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anumpunct0x3Cchar0x3E0x3A0x3Ado_falsename0x280x290x20const(w2c_rlbox*, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anumpunct0x3Cwchar_t0x3E0x3A0x3Ado_falsename0x280x290x20const(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anumpunct_byname0x3Cchar0x3E0x3A0x3Anumpunct_byname0x28char0x20const0x2A0x2C0x20unsigned0x20long0x29(w2c_rlbox*, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anumpunct_byname0x3Cchar0x3E0x3A0x3A_0x5Finit0x28char0x20const0x2A0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Achecked_string_to_char_convert0x28char0x260x2C0x20char0x20const0x2A0x2C0x20_0x5Flocale_struct0x2A0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anumpunct_byname0x3Cchar0x3E0x3A0x3Anumpunct_byname0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x2C0x20unsigned0x20long0x29(w2c_rlbox*, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anumpunct_byname0x3Cchar0x3E0x3A0x3A0x7Enumpunct_byname0x280x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anumpunct_byname0x3Cwchar_t0x3E0x3A0x3Anumpunct_byname0x28char0x20const0x2A0x2C0x20unsigned0x20long0x29(w2c_rlbox*, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anumpunct_byname0x3Cwchar_t0x3E0x3A0x3A_0x5Finit0x28char0x20const0x2A0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anumpunct_byname0x3Cwchar_t0x3E0x3A0x3Anumpunct_byname0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x2C0x20unsigned0x20long0x29(w2c_rlbox*, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anumpunct_byname0x3Cwchar_t0x3E0x3A0x3A0x7Enumpunct_byname0x280x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fnum_get_base0x3A0x3A_0x5Fget_base0x28std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fnum_put_base0x3A0x3A_0x5Fformat_int0x28char0x2A0x2C0x20char0x20const0x2A0x2C0x20bool0x2C0x20unsigned0x20int0x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fnum_put_base0x3A0x3A_0x5Fformat_float0x28char0x2A0x2C0x20char0x20const0x2A0x2C0x20unsigned0x20int0x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fnum_put_base0x3A0x3A_0x5Fidentify_padding0x28char0x2A0x2C0x20char0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x20const0x260x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Ftime_get_c_storage0x3Cchar0x3E0x3A0x3A_0x5Fweeks0x280x290x20const(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Ainit_weeks0x280x29(w2c_rlbox*);
static void w2c_rlbox_0x5F_cxx_global_array_dtor0x2E57(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Ftime_get_c_storage0x3Cwchar_t0x3E0x3A0x3A_0x5Fweeks0x280x290x20const(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Ainit_wweeks0x280x29(w2c_rlbox*);
static void w2c_rlbox_0x5F_cxx_global_array_dtor0x2E72(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Ftime_get_c_storage0x3Cchar0x3E0x3A0x3A_0x5Fmonths0x280x290x20const(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Ainit_months0x280x29(w2c_rlbox*);
static void w2c_rlbox_0x5F_cxx_global_array_dtor0x2E87(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Ftime_get_c_storage0x3Cwchar_t0x3E0x3A0x3A_0x5Fmonths0x280x290x20const(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Ainit_wmonths0x280x29(w2c_rlbox*);
static void w2c_rlbox_0x5F_cxx_global_array_dtor0x2E111(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Ftime_get_c_storage0x3Cchar0x3E0x3A0x3A_0x5Fam_pm0x280x290x20const(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Ainit_am_pm0x280x29(w2c_rlbox*);
static void w2c_rlbox_0x5F_cxx_global_array_dtor0x2E135(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Ftime_get_c_storage0x3Cwchar_t0x3E0x3A0x3A_0x5Fam_pm0x280x290x20const(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Ainit_wam_pm0x280x29(w2c_rlbox*);
static void w2c_rlbox_0x5F_cxx_global_array_dtor0x2E138(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Ftime_get_c_storage0x3Cchar0x3E0x3A0x3A_0x5Fx0x280x290x20const(w2c_rlbox*, u32);
static void w2c_rlbox_0x5F_cxx_global_array_dtor(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Ftime_get_c_storage0x3Cwchar_t0x3E0x3A0x3A_0x5Fx0x280x290x20const(w2c_rlbox*, u32);
static void w2c_rlbox_0x5F_cxx_global_array_dtor0x2E29(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Ftime_get_c_storage0x3Cchar0x3E0x3A0x3A_0x5FX0x280x290x20const(w2c_rlbox*, u32);
static void w2c_rlbox_0x5F_cxx_global_array_dtor0x2E30(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Ftime_get_c_storage0x3Cwchar_t0x3E0x3A0x3A_0x5FX0x280x290x20const(w2c_rlbox*, u32);
static void w2c_rlbox_0x5F_cxx_global_array_dtor0x2E32(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Ftime_get_c_storage0x3Cchar0x3E0x3A0x3A_0x5Fc0x280x290x20const(w2c_rlbox*, u32);
static void w2c_rlbox_0x5F_cxx_global_array_dtor0x2E34(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Ftime_get_c_storage0x3Cwchar_t0x3E0x3A0x3A_0x5Fc0x280x290x20const(w2c_rlbox*, u32);
static void w2c_rlbox_0x5F_cxx_global_array_dtor0x2E36(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Ftime_get_c_storage0x3Cchar0x3E0x3A0x3A_0x5Fr0x280x290x20const(w2c_rlbox*, u32);
static void w2c_rlbox_0x5F_cxx_global_array_dtor0x2E38(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Ftime_get_c_storage0x3Cwchar_t0x3E0x3A0x3A_0x5Fr0x280x290x20const(w2c_rlbox*, u32);
static void w2c_rlbox_0x5F_cxx_global_array_dtor0x2E40(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Ftime_get0x3A0x3A_0x5Ftime_get0x28char0x20const0x2A0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Ftime_get0x3A0x3A_0x5Ftime_get0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Ftime_get0x3A0x3A0x7E_0x5Ftime_get0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Ftime_get_storage0x3Cchar0x3E0x3A0x3A_0x5Fanalyze0x28char0x2C0x20std0x3A0x3A_0x5F20x3A0x3Actype0x3Cchar0x3E0x20const0x260x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2A0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fscan_keyword0x5Babi0x3Ann2101050x5D0x3Cchar0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Actype0x3Cchar0x3E0x3E0x28char0x2A0x260x2C0x20char0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Actype0x3Cchar0x3E0x20const0x260x2C0x20unsigned0x20int0x260x2C0x20bool0x29(w2c_rlbox*, u32, u32, u32, u32, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Ftime_get_storage0x3Cwchar_t0x3E0x3A0x3A_0x5Fanalyze0x28char0x2C0x20std0x3A0x3A_0x5F20x3A0x3Actype0x3Cwchar_t0x3E0x20const0x260x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cwchar_t0x3E0x3E0x2A0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fscan_keyword0x5Babi0x3Ann2101050x5D0x3Cwchar_t0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cwchar_t0x3E0x3E0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Actype0x3Cwchar_t0x3E0x3E0x28wchar_t0x2A0x260x2C0x20wchar_t0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cwchar_t0x3E0x3E0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cwchar_t0x3E0x3E0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Actype0x3Cwchar_t0x3E0x20const0x260x2C0x20unsigned0x20int0x260x2C0x20bool0x29(w2c_rlbox*, u32, u32, u32, u32, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Ftime_get_storage0x3Cchar0x3E0x3A0x3Ainit0x28std0x3A0x3A_0x5F20x3A0x3Actype0x3Cchar0x3E0x20const0x260x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Ftime_get_storage0x3Cwchar_t0x3E0x3A0x3Ainit0x28std0x3A0x3A_0x5F20x3A0x3Actype0x3Cwchar_t0x3E0x20const0x260x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cwchar_t0x3E0x3E0x3A0x3A_0x5Fassign_trivial0x5Babi0x3Ann2101050x5D0x3Cwchar_t0x2A0x2C0x20wchar_t0x2A0x3E0x28wchar_t0x2A0x2C0x20wchar_t0x2A0x2C0x20unsigned0x20long0x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Ftime_get_storage0x3Cchar0x3E0x3A0x3A_0x5Ftime_get_storage0x28char0x20const0x2A0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype_byname0x3Cchar0x3E0x3A0x3A0x7Ectype_byname0x280x290x2E1(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Ftime_get_storage0x3Cwchar_t0x3E0x3A0x3A_0x5Ftime_get_storage0x28char0x20const0x2A0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype_byname0x3Cwchar_t0x3E0x3A0x3A0x7Ectype_byname0x280x290x2E1(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Ftime_get_storage0x3Cchar0x3E0x3A0x3A_0x5Fdo_date_order0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Ftime_get_storage0x3Cwchar_t0x3E0x3A0x3A_0x5Fdo_date_order0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Ftime_put0x3A0x3A_0x5Ftime_put0x28char0x20const0x2A0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Ftime_put0x3A0x3A_0x5Ftime_put0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Ftime_put0x3A0x3A0x7E_0x5Ftime_put0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Finit_pat0x3Cchar0x3E0x28std0x3A0x3A_0x5F20x3A0x3Amoney_base0x3A0x3Apattern0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x260x2C0x20bool0x2C0x20char0x2C0x20char0x2C0x20char0x2C0x20char0x29(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3Aerase0x5Babi0x3Ann2101050x5D0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Cchar0x20const0x2A0x3E0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Finit_pat0x3Cwchar_t0x3E0x28std0x3A0x3A_0x5F20x3A0x3Amoney_base0x3A0x3Apattern0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cwchar_t0x3E0x3E0x260x2C0x20bool0x2C0x20char0x2C0x20char0x2C0x20char0x2C0x20wchar_t0x29(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cwchar_t0x3E0x3E0x3A0x3Aerase0x5Babi0x3Ann2101050x5D0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Cwchar_t0x20const0x2A0x3E0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf80x3Cwchar_t0x3E0x3A0x3A0x7E_0x5Fcodecvt_utf80x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf80x3Cchar16_t0x3E0x3A0x3A0x7E_0x5Fcodecvt_utf80x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf80x3Cchar32_t0x3E0x3A0x3A0x7E_0x5Fcodecvt_utf80x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf160x3Cwchar_t0x2C0x20false0x3E0x3A0x3A0x7E_0x5Fcodecvt_utf160x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf160x3Cwchar_t0x2C0x20true0x3E0x3A0x3A0x7E_0x5Fcodecvt_utf160x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf160x3Cchar16_t0x2C0x20false0x3E0x3A0x3A0x7E_0x5Fcodecvt_utf160x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf160x3Cchar16_t0x2C0x20true0x3E0x3A0x3A0x7E_0x5Fcodecvt_utf160x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf160x3Cchar32_t0x2C0x20false0x3E0x3A0x3A0x7E_0x5Fcodecvt_utf160x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf160x3Cchar32_t0x2C0x20true0x3E0x3A0x3A0x7E_0x5Fcodecvt_utf160x280x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cwchar_t0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3A0x7Ecodecvt0x280x290x2E1(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf8_utf160x3Cwchar_t0x3E0x3A0x3A0x7E_0x5Fcodecvt_utf8_utf160x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf8_utf160x3Cchar32_t0x3E0x3A0x3A0x7E_0x5Fcodecvt_utf8_utf160x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf8_utf160x3Cchar16_t0x3E0x3A0x3A0x7E_0x5Fcodecvt_utf8_utf160x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_get0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3A0x7Enum_get0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_get0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3A0x7Enum_get0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_put0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3A0x7Enum_put0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_put0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3A0x7Enum_put0x280x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Atime_get0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3A0x7Etime_get0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Atime_get0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3A0x7Etime_get0x280x290x2E1(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Atime_get0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3A0x7Etime_get0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Atime_get0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3A0x7Etime_get0x280x290x2E1(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Atime_get_byname0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3A0x7Etime_get_byname0x280x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Ftime_get_storage0x3Cchar0x3E0x3A0x3A0x7E_0x5Ftime_get_storage0x5Babi0x3Ann2101050x5D0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Atime_get_byname0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3A0x7Etime_get_byname0x280x290x2E1(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Atime_get_byname0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3Ado_date_order0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Atime_get_byname0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3A_0x5Fweeks0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Atime_get_byname0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3A_0x5Fmonths0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Atime_get_byname0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3A_0x5Fam_pm0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Atime_get_byname0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3A_0x5Fc0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Atime_get_byname0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3A_0x5Fr0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Atime_get_byname0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3A_0x5Fx0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Atime_get_byname0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3A_0x5FX0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_non0x2Dvirtual0x20thunk0x20to0x20std0x3A0x3A_0x5F20x3A0x3Atime_get_byname0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3A_0x5Fweeks0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_non0x2Dvirtual0x20thunk0x20to0x20std0x3A0x3A_0x5F20x3A0x3Atime_get_byname0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3A_0x5Fmonths0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_non0x2Dvirtual0x20thunk0x20to0x20std0x3A0x3A_0x5F20x3A0x3Atime_get_byname0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3A_0x5Fam_pm0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_non0x2Dvirtual0x20thunk0x20to0x20std0x3A0x3A_0x5F20x3A0x3Atime_get_byname0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3A_0x5Fc0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_non0x2Dvirtual0x20thunk0x20to0x20std0x3A0x3A_0x5F20x3A0x3Atime_get_byname0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3A_0x5Fr0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_non0x2Dvirtual0x20thunk0x20to0x20std0x3A0x3A_0x5F20x3A0x3Atime_get_byname0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3A_0x5Fx0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_non0x2Dvirtual0x20thunk0x20to0x20std0x3A0x3A_0x5F20x3A0x3Atime_get_byname0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3A_0x5FX0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Atime_get_byname0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3A0x7Etime_get_byname0x280x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Ftime_get_storage0x3Cwchar_t0x3E0x3A0x3A0x7E_0x5Ftime_get_storage0x5Babi0x3Ann2101050x5D0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Atime_get_byname0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3A0x7Etime_get_byname0x280x290x2E1(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Atime_get_byname0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3Ado_date_order0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Atime_get_byname0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3A_0x5Fweeks0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Atime_get_byname0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3A_0x5Fmonths0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Atime_get_byname0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3A_0x5Fam_pm0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Atime_get_byname0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3A_0x5Fc0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Atime_get_byname0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3A_0x5Fr0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Atime_get_byname0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3A_0x5Fx0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Atime_get_byname0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3A_0x5FX0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_non0x2Dvirtual0x20thunk0x20to0x20std0x3A0x3A_0x5F20x3A0x3Atime_get_byname0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3A_0x5Fweeks0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_non0x2Dvirtual0x20thunk0x20to0x20std0x3A0x3A_0x5F20x3A0x3Atime_get_byname0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3A_0x5Fmonths0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_non0x2Dvirtual0x20thunk0x20to0x20std0x3A0x3A_0x5F20x3A0x3Atime_get_byname0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3A_0x5Fam_pm0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_non0x2Dvirtual0x20thunk0x20to0x20std0x3A0x3A_0x5F20x3A0x3Atime_get_byname0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3A_0x5Fc0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_non0x2Dvirtual0x20thunk0x20to0x20std0x3A0x3A_0x5F20x3A0x3Atime_get_byname0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3A_0x5Fr0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_non0x2Dvirtual0x20thunk0x20to0x20std0x3A0x3A_0x5F20x3A0x3Atime_get_byname0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3A_0x5Fx0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_non0x2Dvirtual0x20thunk0x20to0x20std0x3A0x3A_0x5F20x3A0x3Atime_get_byname0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3A_0x5FX0x280x290x20const(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Atime_put0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3A0x7Etime_put0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Atime_put0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3A0x7Etime_put0x280x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Atime_put0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3A0x7Etime_put0x280x290x2E1(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Atime_put_byname0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3A0x7Etime_put_byname0x280x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Atime_put0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3A0x7Etime_put0x280x290x2E1(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Atime_put_byname0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3A0x7Etime_put_byname0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cchar0x2C0x20false0x3E0x3A0x3A0x7Emoneypunct0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cchar0x2C0x20true0x3E0x3A0x3A0x7Emoneypunct0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cwchar_t0x2C0x20false0x3E0x3A0x3A0x7Emoneypunct0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cwchar_t0x2C0x20true0x3E0x3A0x3A0x7Emoneypunct0x280x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cchar0x2C0x20false0x3E0x3A0x3A0x7Emoneypunct_byname0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cchar0x2C0x20false0x3E0x3A0x3A0x7Emoneypunct_byname0x280x290x2E1(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cchar0x2C0x20true0x3E0x3A0x3A0x7Emoneypunct_byname0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cchar0x2C0x20true0x3E0x3A0x3A0x7Emoneypunct_byname0x280x290x2E1(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cwchar_t0x2C0x20false0x3E0x3A0x3A0x7Emoneypunct_byname0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cwchar_t0x2C0x20false0x3E0x3A0x3A0x7Emoneypunct_byname0x280x290x2E1(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cwchar_t0x2C0x20true0x3E0x3A0x3A0x7Emoneypunct_byname0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cwchar_t0x2C0x20true0x3E0x3A0x3A0x7Emoneypunct_byname0x280x290x2E1(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoney_get0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3A0x7Emoney_get0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoney_get0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3A0x7Emoney_get0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoney_put0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3A0x7Emoney_put0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoney_put0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3A0x7Emoney_put0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amessages0x3Cchar0x3E0x3A0x3A0x7Emessages0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amessages0x3Cwchar_t0x3E0x3A0x3A0x7Emessages0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amessages_byname0x3Cchar0x3E0x3A0x3A0x7Emessages_byname0x280x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3A0x7Ecodecvt0x280x290x2E1(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amessages_byname0x3Cwchar_t0x3E0x3A0x3A0x7Emessages_byname0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Ftime_get_temp0x3Cchar0x3E0x3A0x3A0x7E_0x5Ftime_get_temp0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Ftime_get_temp0x3Cwchar_t0x3E0x3A0x3A0x7E_0x5Ftime_get_temp0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fto_chars_result0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fto_chars_integral0x5Babi0x3Ann2101050x5D0x3C2u0x2C0x20unsigned0x20long0x2C0x2000x3E0x28char0x2A0x2C0x20char0x2A0x2C0x20unsigned0x20long0x29(w2c_rlbox*, u32, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fto_chars_result0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fto_chars_integral0x5Babi0x3Ann2101050x5D0x3C8u0x2C0x20unsigned0x20long0x2C0x2000x3E0x28char0x2A0x2C0x20char0x2A0x2C0x20unsigned0x20long0x29(w2c_rlbox*, u32, u32, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fto_chars_result0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fto_chars_integral0x5Babi0x3Ann2101050x5D0x3C16u0x2C0x20unsigned0x20long0x2C0x2000x3E0x28char0x2A0x2C0x20char0x2A0x2C0x20unsigned0x20long0x29(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_int0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fto_chars_integral_width0x5Babi0x3Ann2101050x5D0x3Cunsigned0x20long0x3E0x28unsigned0x20long0x2C0x20unsigned0x20int0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fto_chars_result0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fto_chars_integral0x5Babi0x3Ann2101050x5D0x3C2u0x2C0x20unsigned0x20long0x20long0x2C0x2000x3E0x28char0x2A0x2C0x20char0x2A0x2C0x20unsigned0x20long0x20long0x29(w2c_rlbox*, u32, u32, u32, u64);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fto_chars_result0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fto_chars_integral0x5Babi0x3Ann2101050x5D0x3C8u0x2C0x20unsigned0x20long0x20long0x2C0x2000x3E0x28char0x2A0x2C0x20char0x2A0x2C0x20unsigned0x20long0x20long0x29(w2c_rlbox*, u32, u32, u32, u64);
static void w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fto_chars_result0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fto_chars_integral0x5Babi0x3Ann2101050x5D0x3C16u0x2C0x20unsigned0x20long0x20long0x2C0x2000x3E0x28char0x2A0x2C0x20char0x2A0x2C0x20unsigned0x20long0x20long0x29(w2c_rlbox*, u32, u32, u32, u64);
static u32 w2c_rlbox_int0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fto_chars_integral_width0x5Babi0x3Ann2101050x5D0x3Cunsigned0x20long0x20long0x3E0x28unsigned0x20long0x20long0x2C0x20unsigned0x20int0x29(w2c_rlbox*, u64, u32);
static u32 w2c_rlbox_std0x3A0x3Aset_unexpected0x28void0x200x280x2A0x290x280x290x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3Aset_terminate0x28void0x200x280x2A0x290x280x290x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3Aset_new_handler0x28void0x200x280x2A0x290x280x290x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3Aget_unexpected0x280x29(w2c_rlbox*);
static void w2c_rlbox_std0x3A0x3A_0x5Funexpected0x28void0x200x280x2A0x290x280x290x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3Aunexpected0x280x29(w2c_rlbox*);
static u32 w2c_rlbox_std0x3A0x3Aget_terminate0x280x29(w2c_rlbox*);
static void w2c_rlbox_std0x3A0x3A_0x5Fterminate0x28void0x200x280x2A0x290x280x290x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3Aterminate0x280x29(w2c_rlbox*);
static u32 w2c_rlbox_std0x3A0x3Aget_new_handler0x280x29(w2c_rlbox*);
static void w2c_rlbox_0x5F_cxa_pure_virtual_0(w2c_rlbox*);
static void w2c_rlbox_0x5F_cxa_deleted_virtual_0(w2c_rlbox*);
static u32 w2c_rlbox_std0x3A0x3Aexception0x3A0x3A0x7Eexception0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3Aexception0x3A0x3A0x7Eexception0x280x290x2E1(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3Aexception0x3A0x3Awhat0x280x290x20const(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3Abad_exception0x3A0x3A0x7Ebad_exception0x280x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3Abad_exception0x3A0x3Awhat0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3Abad_alloc0x3A0x3Abad_alloc0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3Abad_alloc0x3A0x3A0x7Ebad_alloc0x280x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3Abad_alloc0x3A0x3Awhat0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3Abad_array_new_length0x3A0x3Abad_array_new_length0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3Abad_array_new_length0x3A0x3A0x7Ebad_array_new_length0x280x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3Abad_array_new_length0x3A0x3Awhat0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3Alogic_error0x3A0x3A0x7Elogic_error0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3Alogic_error0x3A0x3A0x7Elogic_error0x280x290x2E1(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3Alogic_error0x3A0x3Awhat0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3Aruntime_error0x3A0x3A0x7Eruntime_error0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3Aruntime_error0x3A0x3A0x7Eruntime_error0x280x290x2E1(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3Aruntime_error0x3A0x3Awhat0x280x290x20const(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3Adomain_error0x3A0x3A0x7Edomain_error0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3Ainvalid_argument0x3A0x3A0x7Einvalid_argument0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3Alength_error0x3A0x3A0x7Elength_error0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3Aout_of_range0x3A0x3A0x7Eout_of_range0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3Arange_error0x3A0x3A0x7Erange_error0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3Aoverflow_error0x3A0x3A0x7Eoverflow_error0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3Aunderflow_error0x3A0x3A0x7Eunderflow_error0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_0x5F_abort_message_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_std0x3A0x3Atype_info0x3A0x3A0x7Etype_info0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3Atype_info0x3A0x3A0x7Etype_info0x280x290x2E1(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3Abad_cast0x3A0x3Abad_cast0x280x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3Abad_cast0x3A0x3A0x7Ebad_cast0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3Abad_cast0x3A0x3A0x7Ebad_cast0x280x290x2E1(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3Abad_cast0x3A0x3Awhat0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3Abad_typeid0x3A0x3Abad_typeid0x280x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3Abad_typeid0x3A0x3A0x7Ebad_typeid0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_std0x3A0x3Abad_typeid0x3A0x3A0x7Ebad_typeid0x280x290x2E1(w2c_rlbox*, u32);
static u32 w2c_rlbox_std0x3A0x3Abad_typeid0x3A0x3Awhat0x280x290x20const(w2c_rlbox*, u32);
static u32 w2c_rlbox_0x5F_cxxabiv10x3A0x3A_0x5Fshim_type_info0x3A0x3A0x7E_0x5Fshim_type_info0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_0x5F_cxxabiv10x3A0x3A_0x5Fshim_type_info0x3A0x3A0x7E_0x5Fshim_type_info0x280x290x2E1(w2c_rlbox*, u32);
static void w2c_rlbox_0x5F_cxxabiv10x3A0x3A_0x5Fshim_type_info0x3A0x3Anoop10x280x290x20const(w2c_rlbox*, u32);
static void w2c_rlbox_0x5F_cxxabiv10x3A0x3A_0x5Fshim_type_info0x3A0x3Anoop20x280x290x20const(w2c_rlbox*, u32);
static void w2c_rlbox_0x5F_cxxabiv10x3A0x3A_0x5Ffundamental_type_info0x3A0x3A0x7E_0x5Ffundamental_type_info0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_0x5F_cxxabiv10x3A0x3A_0x5Farray_type_info0x3A0x3A0x7E_0x5Farray_type_info0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_0x5F_cxxabiv10x3A0x3A_0x5Ffunction_type_info0x3A0x3A0x7E_0x5Ffunction_type_info0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_0x5F_cxxabiv10x3A0x3A_0x5Fenum_type_info0x3A0x3A0x7E_0x5Fenum_type_info0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_0x5F_cxxabiv10x3A0x3A_0x5Fclass_type_info0x3A0x3A0x7E_0x5Fclass_type_info0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_0x5F_cxxabiv10x3A0x3A_0x5Fsi_class_type_info0x3A0x3A0x7E_0x5Fsi_class_type_info0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_0x5F_cxxabiv10x3A0x3A_0x5Fvmi_class_type_info0x3A0x3A0x7E_0x5Fvmi_class_type_info0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_0x5F_cxxabiv10x3A0x3A_0x5Fpbase_type_info0x3A0x3A0x7E_0x5Fpbase_type_info0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_0x5F_cxxabiv10x3A0x3A_0x5Fpointer_type_info0x3A0x3A0x7E_0x5Fpointer_type_info0x280x29(w2c_rlbox*, u32);
static void w2c_rlbox_0x5F_cxxabiv10x3A0x3A_0x5Fpointer_to_member_type_info0x3A0x3A0x7E_0x5Fpointer_to_member_type_info0x280x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_0x5F_cxxabiv10x3A0x3A_0x5Ffundamental_type_info0x3A0x3Acan_catch0x28_0x5Fcxxabiv10x3A0x3A_0x5Fshim_type_info0x20const0x2A0x2C0x20void0x2A0x260x290x20const(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_0x5F_cxxabiv10x3A0x3A_0x5Farray_type_info0x3A0x3Acan_catch0x28_0x5Fcxxabiv10x3A0x3A_0x5Fshim_type_info0x20const0x2A0x2C0x20void0x2A0x260x290x20const(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_0x5F_cxxabiv10x3A0x3A_0x5Ffunction_type_info0x3A0x3Acan_catch0x28_0x5Fcxxabiv10x3A0x3A_0x5Fshim_type_info0x20const0x2A0x2C0x20void0x2A0x260x290x20const(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_0x5F_cxxabiv10x3A0x3A_0x5Fenum_type_info0x3A0x3Acan_catch0x28_0x5Fcxxabiv10x3A0x3A_0x5Fshim_type_info0x20const0x2A0x2C0x20void0x2A0x260x290x20const(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_0x5F_cxxabiv10x3A0x3A_0x5Fclass_type_info0x3A0x3Acan_catch0x28_0x5Fcxxabiv10x3A0x3A_0x5Fshim_type_info0x20const0x2A0x2C0x20void0x2A0x260x290x20const(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_0x5F_dynamic_cast_0(w2c_rlbox*, u32, u32, u32, u32);
static void w2c_rlbox_0x5F_cxxabiv10x3A0x3A_0x5Fclass_type_info0x3A0x3Aprocess_found_base_class0x28_0x5Fcxxabiv10x3A0x3A_0x5Fdynamic_cast_info0x2A0x2C0x20void0x2A0x2C0x20int0x290x20const(w2c_rlbox*, u32, u32, u32, u32);
static void w2c_rlbox_0x5F_cxxabiv10x3A0x3A_0x5Fclass_type_info0x3A0x3Ahas_unambiguous_public_base0x28_0x5Fcxxabiv10x3A0x3A_0x5Fdynamic_cast_info0x2A0x2C0x20void0x2A0x2C0x20int0x290x20const(w2c_rlbox*, u32, u32, u32, u32);
static void w2c_rlbox_0x5F_cxxabiv10x3A0x3A_0x5Fsi_class_type_info0x3A0x3Ahas_unambiguous_public_base0x28_0x5Fcxxabiv10x3A0x3A_0x5Fdynamic_cast_info0x2A0x2C0x20void0x2A0x2C0x20int0x290x20const(w2c_rlbox*, u32, u32, u32, u32);
static void w2c_rlbox_0x5F_cxxabiv10x3A0x3A_0x5Fbase_class_type_info0x3A0x3Ahas_unambiguous_public_base0x28_0x5Fcxxabiv10x3A0x3A_0x5Fdynamic_cast_info0x2A0x2C0x20void0x2A0x2C0x20int0x290x20const(w2c_rlbox*, u32, u32, u32, u32);
static void w2c_rlbox_0x5F_cxxabiv10x3A0x3A_0x5Fvmi_class_type_info0x3A0x3Ahas_unambiguous_public_base0x28_0x5Fcxxabiv10x3A0x3A_0x5Fdynamic_cast_info0x2A0x2C0x20void0x2A0x2C0x20int0x290x20const(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_0x5F_cxxabiv10x3A0x3A_0x5Fpbase_type_info0x3A0x3Acan_catch0x28_0x5Fcxxabiv10x3A0x3A_0x5Fshim_type_info0x20const0x2A0x2C0x20void0x2A0x260x290x20const(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_0x5F_cxxabiv10x3A0x3A_0x5Fpointer_type_info0x3A0x3Acan_catch0x28_0x5Fcxxabiv10x3A0x3A_0x5Fshim_type_info0x20const0x2A0x2C0x20void0x2A0x260x290x20const(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_0x5F_cxxabiv10x3A0x3A_0x5Fpointer_type_info0x3A0x3Acan_catch_nested0x28_0x5Fcxxabiv10x3A0x3A_0x5Fshim_type_info0x20const0x2A0x290x20const(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_0x5F_cxxabiv10x3A0x3A_0x5Fpointer_to_member_type_info0x3A0x3Acan_catch_nested0x28_0x5Fcxxabiv10x3A0x3A_0x5Fshim_type_info0x20const0x2A0x290x20const(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_0x5F_cxxabiv10x3A0x3A_0x5Fpointer_to_member_type_info0x3A0x3Acan_catch0x28_0x5Fcxxabiv10x3A0x3A_0x5Fshim_type_info0x20const0x2A0x2C0x20void0x2A0x260x290x20const(w2c_rlbox*, u32, u32, u32);
static void w2c_rlbox_0x5F_cxxabiv10x3A0x3A_0x5Fclass_type_info0x3A0x3Aprocess_static_type_above_dst0x28_0x5Fcxxabiv10x3A0x3A_0x5Fdynamic_cast_info0x2A0x2C0x20void0x20const0x2A0x2C0x20void0x20const0x2A0x2C0x20int0x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32);
static void w2c_rlbox_0x5F_cxxabiv10x3A0x3A_0x5Fclass_type_info0x3A0x3Aprocess_static_type_below_dst0x28_0x5Fcxxabiv10x3A0x3A_0x5Fdynamic_cast_info0x2A0x2C0x20void0x20const0x2A0x2C0x20int0x290x20const(w2c_rlbox*, u32, u32, u32, u32);
static void w2c_rlbox_0x5F_cxxabiv10x3A0x3A_0x5Fvmi_class_type_info0x3A0x3Asearch_below_dst0x28_0x5Fcxxabiv10x3A0x3A_0x5Fdynamic_cast_info0x2A0x2C0x20void0x20const0x2A0x2C0x20int0x2C0x20bool0x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32);
static void w2c_rlbox_0x5F_cxxabiv10x3A0x3A_0x5Fbase_class_type_info0x3A0x3Asearch_above_dst0x28_0x5Fcxxabiv10x3A0x3A_0x5Fdynamic_cast_info0x2A0x2C0x20void0x20const0x2A0x2C0x20void0x20const0x2A0x2C0x20int0x2C0x20bool0x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static void w2c_rlbox_0x5F_cxxabiv10x3A0x3A_0x5Fbase_class_type_info0x3A0x3Asearch_below_dst0x28_0x5Fcxxabiv10x3A0x3A_0x5Fdynamic_cast_info0x2A0x2C0x20void0x20const0x2A0x2C0x20int0x2C0x20bool0x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32);
static void w2c_rlbox_0x5F_cxxabiv10x3A0x3A_0x5Fsi_class_type_info0x3A0x3Asearch_below_dst0x28_0x5Fcxxabiv10x3A0x3A_0x5Fdynamic_cast_info0x2A0x2C0x20void0x20const0x2A0x2C0x20int0x2C0x20bool0x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32);
static void w2c_rlbox_0x5F_cxxabiv10x3A0x3A_0x5Fclass_type_info0x3A0x3Asearch_below_dst0x28_0x5Fcxxabiv10x3A0x3A_0x5Fdynamic_cast_info0x2A0x2C0x20void0x20const0x2A0x2C0x20int0x2C0x20bool0x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32);
static void w2c_rlbox_0x5F_cxxabiv10x3A0x3A_0x5Fvmi_class_type_info0x3A0x3Asearch_above_dst0x28_0x5Fcxxabiv10x3A0x3A_0x5Fdynamic_cast_info0x2A0x2C0x20void0x20const0x2A0x2C0x20void0x20const0x2A0x2C0x20int0x2C0x20bool0x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static void w2c_rlbox_0x5F_cxxabiv10x3A0x3A_0x5Fsi_class_type_info0x3A0x3Asearch_above_dst0x28_0x5Fcxxabiv10x3A0x3A_0x5Fdynamic_cast_info0x2A0x2C0x20void0x20const0x2A0x2C0x20void0x20const0x2A0x2C0x20int0x2C0x20bool0x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static void w2c_rlbox_0x5F_cxxabiv10x3A0x3A_0x5Fclass_type_info0x3A0x3Asearch_above_dst0x28_0x5Fcxxabiv10x3A0x3A_0x5Fdynamic_cast_info0x2A0x2C0x20void0x20const0x2A0x2C0x20void0x20const0x2A0x2C0x20int0x2C0x20bool0x290x20const(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_operator0x20new0x28unsigned0x20long0x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_operator0x20new0x28unsigned0x20long0x2C0x20std0x3A0x3Anothrow_t0x20const0x260x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_operator0x20new0x5B0x5D0x28unsigned0x20long0x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_operator0x20new0x5B0x5D0x28unsigned0x20long0x2C0x20std0x3A0x3Anothrow_t0x20const0x260x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_operator0x20delete0x28void0x2A0x29(w2c_rlbox*, u32);
static void w2c_rlbox_operator0x20delete0x28void0x2A0x2C0x20std0x3A0x3Anothrow_t0x20const0x260x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_operator0x20delete0x28void0x2A0x2C0x20unsigned0x20long0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_operator0x20delete0x5B0x5D0x28void0x2A0x29(w2c_rlbox*, u32);
static void w2c_rlbox_operator0x20delete0x5B0x5D0x28void0x2A0x2C0x20std0x3A0x3Anothrow_t0x20const0x260x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_operator0x20delete0x5B0x5D0x28void0x2A0x2C0x20unsigned0x20long0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_operator0x20new0x28unsigned0x20long0x2C0x20std0x3A0x3Aalign_val_t0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_operator0x20new0x28unsigned0x20long0x2C0x20std0x3A0x3Aalign_val_t0x2C0x20std0x3A0x3Anothrow_t0x20const0x260x29(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_operator0x20new0x5B0x5D0x28unsigned0x20long0x2C0x20std0x3A0x3Aalign_val_t0x29(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_operator0x20new0x5B0x5D0x28unsigned0x20long0x2C0x20std0x3A0x3Aalign_val_t0x2C0x20std0x3A0x3Anothrow_t0x20const0x260x29(w2c_rlbox*, u32, u32, u32);
static void w2c_rlbox_operator0x20delete0x28void0x2A0x2C0x20std0x3A0x3Aalign_val_t0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_operator0x20delete0x28void0x2A0x2C0x20std0x3A0x3Aalign_val_t0x2C0x20std0x3A0x3Anothrow_t0x20const0x260x29(w2c_rlbox*, u32, u32, u32);
static void w2c_rlbox_operator0x20delete0x28void0x2A0x2C0x20unsigned0x20long0x2C0x20std0x3A0x3Aalign_val_t0x29(w2c_rlbox*, u32, u32, u32);
static void w2c_rlbox_operator0x20delete0x5B0x5D0x28void0x2A0x2C0x20std0x3A0x3Aalign_val_t0x29(w2c_rlbox*, u32, u32);
static void w2c_rlbox_operator0x20delete0x5B0x5D0x28void0x2A0x2C0x20std0x3A0x3Aalign_val_t0x2C0x20std0x3A0x3Anothrow_t0x20const0x260x29(w2c_rlbox*, u32, u32, u32);
static void w2c_rlbox_operator0x20delete0x5B0x5D0x28void0x2A0x2C0x20unsigned0x20long0x2C0x20std0x3A0x3Aalign_val_t0x29(w2c_rlbox*, u32, u32, u32);
static void w2c_rlbox_0x5F_cxa_increment_exception_refcount_0(w2c_rlbox*, u32);
static void w2c_rlbox_0x5F_cxa_decrement_exception_refcount_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_0x5F_cxa_current_primary_exception_0(w2c_rlbox*);
static void w2c_rlbox_0x5F_cxa_rethrow_primary_exception_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_0x5F_cxa_uncaught_exception_0(w2c_rlbox*);
static u32 w2c_rlbox_0x5F_cxa_uncaught_exceptions_0(w2c_rlbox*);
static u64 w2c_rlbox_0x5F_cxxabiv10x3A0x3A_0x5FgetExceptionClass0x28_Unwind_Exception0x20const0x2A0x29(w2c_rlbox*, u32);
static void w2c_rlbox_0x5F_cxxabiv10x3A0x3A_0x5FsetExceptionClass0x28_Unwind_Exception0x2A0x2C0x20unsigned0x20long0x20long0x29(w2c_rlbox*, u32, u64);
static u32 w2c_rlbox_0x5F_cxxabiv10x3A0x3A_0x5FisOurExceptionClass0x28_Unwind_Exception0x20const0x2A0x29(w2c_rlbox*, u32);
static u32 w2c_rlbox_malloc_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_dlmalloc(w2c_rlbox*, u32);
static u32 w2c_rlbox_prepend_alloc(w2c_rlbox*, u32, u32, u32);
static void w2c_rlbox_free_0(w2c_rlbox*, u32);
static void w2c_rlbox_dlfree(w2c_rlbox*, u32);
static u32 w2c_rlbox_calloc_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_realloc_0(w2c_rlbox*, u32, u32);
static void w2c_rlbox_dispose_chunk(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_posix_memalign_0(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_internal_memalign(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_aligned_alloc_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_malloc_usable_size_0(w2c_rlbox*, u32);
static void w2c_rlbox_0x5FExit_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_0x5F_main_void_0(w2c_rlbox*);
static u32 w2c_rlbox_0x5F_wasi_args_get_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_0x5F_wasi_args_sizes_get_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_0x5F_wasi_environ_get_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_0x5F_wasi_environ_sizes_get_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_0x5F_wasi_clock_res_get_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_0x5F_wasi_clock_time_get_0(w2c_rlbox*, u32, u64, u32);
static u32 w2c_rlbox_0x5F_wasi_fd_advise_0(w2c_rlbox*, u32, u64, u64, u32);
static u32 w2c_rlbox_0x5F_wasi_fd_allocate_0(w2c_rlbox*, u32, u64, u64);
static u32 w2c_rlbox_0x5F_wasi_fd_close_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_0x5F_wasi_fd_datasync_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_0x5F_wasi_fd_fdstat_get_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_0x5F_wasi_fd_fdstat_set_flags_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_0x5F_wasi_fd_fdstat_set_rights_0(w2c_rlbox*, u32, u64, u64);
static u32 w2c_rlbox_0x5F_wasi_fd_filestat_get_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_0x5F_wasi_fd_filestat_set_size_0(w2c_rlbox*, u32, u64);
static u32 w2c_rlbox_0x5F_wasi_fd_filestat_set_times_0(w2c_rlbox*, u32, u64, u64, u32);
static u32 w2c_rlbox_0x5F_wasi_fd_pread_0(w2c_rlbox*, u32, u32, u32, u64, u32);
static u32 w2c_rlbox_0x5F_wasi_fd_prestat_get_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_0x5F_wasi_fd_prestat_dir_name_0(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_0x5F_wasi_fd_pwrite_0(w2c_rlbox*, u32, u32, u32, u64, u32);
static u32 w2c_rlbox_0x5F_wasi_fd_read_0(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_0x5F_wasi_fd_readdir_0(w2c_rlbox*, u32, u32, u32, u64, u32);
static u32 w2c_rlbox_0x5F_wasi_fd_renumber_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_0x5F_wasi_fd_seek_0(w2c_rlbox*, u32, u64, u32, u32);
static u32 w2c_rlbox_0x5F_wasi_fd_sync_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_0x5F_wasi_fd_tell_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_0x5F_wasi_fd_write_0(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_0x5F_wasi_path_create_directory_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_0x5F_wasi_path_filestat_get_0(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_0x5F_wasi_path_filestat_set_times_0(w2c_rlbox*, u32, u32, u32, u64, u64, u32);
static u32 w2c_rlbox_0x5F_wasi_path_link_0(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_0x5F_wasi_path_open_0(w2c_rlbox*, u32, u32, u32, u32, u64, u64, u32, u32);
static u32 w2c_rlbox_0x5F_wasi_path_readlink_0(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_0x5F_wasi_path_remove_directory_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_0x5F_wasi_path_rename_0(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_0x5F_wasi_path_symlink_0(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_0x5F_wasi_path_unlink_file_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_0x5F_wasi_poll_oneoff_0(w2c_rlbox*, u32, u32, u32, u32);
static void w2c_rlbox_0x5F_wasi_proc_exit_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_0x5F_wasi_sched_yield_0(w2c_rlbox*);
static u32 w2c_rlbox_0x5F_wasi_random_get_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_0x5F_wasi_sock_accept_0(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_0x5F_wasi_sock_recv_0(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_0x5F_wasi_sock_send_0(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_0x5F_wasi_sock_shutdown_0(w2c_rlbox*, u32, u32);
static void w2c_rlbox_abort_0(w2c_rlbox*);
static u32 w2c_rlbox_sbrk_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_0x5F_ctype_get_mb_cur_max_0(w2c_rlbox*);
static u32 w2c_rlbox_isalpha_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_0x5F_isalpha_l_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_isdigit_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_0x5F_isdigit_l_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_isspace_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_0x5F_isspace_l_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_iswalpha_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_0x5F_iswalpha_l_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_isblank_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_0x5F_isblank_l_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_iswblank_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_0x5F_iswblank_l_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_iswcntrl_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_0x5F_iswcntrl_l_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_iswdigit_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_0x5F_iswdigit_l_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_iswlower_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_0x5F_iswlower_l_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_iswprint_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_0x5F_iswprint_l_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_iswpunct_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_0x5F_iswpunct_l_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_iswspace_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_0x5F_iswspace_l_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_iswupper_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_0x5F_iswupper_l_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_iswxdigit_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_0x5F_iswxdigit_l_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_isxdigit_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_0x5F_isxdigit_l_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_tolower_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_0x5F_tolower_l_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_toupper_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_0x5F_toupper_l_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_towlower_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_casemap(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_towupper_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_0x5F_towupper_l_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_0x5F_towlower_l_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_0x5F_strerror_l_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_strerror_0(w2c_rlbox*, u32);
static void w2c_rlbox_0x5F_funcs_on_exit_0(w2c_rlbox*);
static void w2c_rlbox_0x5F_cxa_finalize_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_0x5F_cxa_atexit_0(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_atexit_0(w2c_rlbox*, u32);
static void w2c_rlbox_call(w2c_rlbox*, u32);
static void w2c_rlbox_0x5F_wasm_call_dtors_0(w2c_rlbox*);
static void w2c_rlbox_exit_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_0x5F_lctrans_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_0x5F_lctrans_cur_0(w2c_rlbox*, u32);
static void w2c_rlbox_freelocale_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_localeconv_0(w2c_rlbox*);
static u32 w2c_rlbox_0x5F_mo_lookup_0(w2c_rlbox*, u32, u32, u32);
static void w2c_rlbox_dummy(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_clearenv_0(w2c_rlbox*);
static void w2c_rlbox_0x5F_wasilibc_ensure_environ_0(w2c_rlbox*);
static void w2c_rlbox_0x5F_wasilibc_initialize_environ_0(w2c_rlbox*);
static void w2c_rlbox_0x5F_wasilibc_deinitialize_environ_0(w2c_rlbox*);
static void w2c_rlbox_0x5F_wasilibc_maybe_reinitialize_environ_eagerly_0(w2c_rlbox*);
static u32 w2c_rlbox_getenv_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_0x5F_lctrans_impl_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_0x5F_get_locale_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_0x5F_loc_is_allocated_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_0x5F_newlocale_0(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_setlocale_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_0x5F_strcoll_l_0(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_strcoll_0(w2c_rlbox*, u32, u32);
static f32 w2c_rlbox_strtof_l_0(w2c_rlbox*, u32, u32, u32);
static f64 w2c_rlbox_strtod_l_0(w2c_rlbox*, u32, u32, u32);
static void w2c_rlbox_strtold_l_0(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_0x5F_strxfrm_l_0(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_strxfrm_0(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_0x5F_uselocale_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_0x5F_wcscoll_l_0(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_wcscoll_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_0x5F_wcsxfrm_l_0(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_wcsxfrm_0(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_btowc_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_mbrlen_0(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_mbrtowc_0(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_mbsnrtowcs_0(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_mbsrtowcs_0(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_mbtowc_0(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_wcrtomb_0(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_wcsnrtombs_0(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_wctob_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_ntohl_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_ntohs_0(w2c_rlbox*, u32);
static void w2c_rlbox_dummy0x2E1(w2c_rlbox*, u32);
static u32 w2c_rlbox_fclose_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_fflush_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_0x5F_fmodeflags_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_0x5F_wasilibc_register_preopened_fd_0(w2c_rlbox*, u32, u32);
static void w2c_rlbox_0x5F_wasilibc_populate_preopens_0(w2c_rlbox*);
static u32 w2c_rlbox_internal_register_preopened_fd_unlocked(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_0x5F_wasilibc_find_relpath_0(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_0x5F_wasilibc_find_abspath_0(w2c_rlbox*, u32, u32, u32);
static void w2c_rlbox_0x5F_wasilibc_reset_preopens_0(w2c_rlbox*);
static u32 w2c_rlbox_0x5F_wasilibc_nocwd_openat_nomode_0(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_0x5F_wasilibc_nocwd_faccessat_0(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_0x5F_wasilibc_nocwd_readlinkat_0(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_0x5F_wasilibc_nocwd_fstatat_0(w2c_rlbox*, u32, u32, u32, u32);
static void w2c_rlbox_0x5F_muloti4_0(w2c_rlbox*, u32, u64, u64, u64, u64, u32);
static u32 w2c_rlbox_0x5F_wasilibc_nocwd_utimensat_0(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_0x5F_wasilibc_nocwd_0x5F_wasilibc_unlinkat_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_0x5F_wasilibc_nocwd_0x5F_wasilibc_rmdirat_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_0x5F_wasilibc_nocwd_mkdirat_nomode_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_fdopendir_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_0x5F_wasilibc_fd_renumber_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_close_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_0x5F_wasilibc_nocwd_opendirat_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_0x5F_wasilibc_nocwd_symlinkat_0(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_0x5F_wasilibc_nocwd_linkat_0(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_0x5F_wasilibc_nocwd_renameat_0(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_openat_0(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_symlinkat_0(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_readlinkat_0(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_mkdirat_0(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_opendirat_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_scandirat_0(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_faccessat_0(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_fstatat_0(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_utimensat_0(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_linkat_0(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_renameat_0(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_0x5F_wasilibc_unlinkat_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_0x5F_wasilibc_rmdirat_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_0x5F_wasilibc_iftodt_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_0x5F_wasilibc_dttoif_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_0x5F_wasilibc_nocwd_scandirat_0(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_sel_true(w2c_rlbox*, u32);
static u32 w2c_rlbox_open_0(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_0x5F_wasilibc_open_nomode_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_access_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_readlink_0(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_stat_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_lstat_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_utime_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_utimes_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_unlink_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_rmdir_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_remove_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_mkdir_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_opendir_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_scandir_0(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_symlink_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_link_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_rename_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_chmod_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_fchmod_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_fchmodat_0(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_statvfs_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_fstatvfs_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_0x5F_wasilibc_access_0(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_0x5F_wasilibc_utimens_0(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_0x5F_wasilibc_stat_0(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_0x5F_wasilibc_link_0(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_0x5F_wasilibc_link_oldat_0(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_0x5F_wasilibc_link_newat_0(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_0x5F_wasilibc_rename_oldat_0(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_0x5F_wasilibc_rename_newat_0(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_fcntl_0(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_0x5F_isatty_0(w2c_rlbox*, u32);
static u64 w2c_rlbox_0x5F_lseek_0(w2c_rlbox*, u32, u64, u32);
static u64 w2c_rlbox_0x5F_stdio_seek_0(w2c_rlbox*, u32, u64, u32);
static u32 w2c_rlbox_writev_0(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_0x5F_stdio_write_0(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_readv_0(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_read_0(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_0x5F_stdio_read_0(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_0x5F_stdio_close_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_0x5F_fdopen_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_fopen_0(w2c_rlbox*, u32, u32);
static void w2c_rlbox_0x5F_stdio_exit_0(w2c_rlbox*);
static u32 w2c_rlbox_0x5F_towrite_0(w2c_rlbox*, u32);
static void w2c_rlbox_0x5F_towrite_needs_stdio_exit_0(w2c_rlbox*);
static u32 w2c_rlbox_0x5F_overflow_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_fputc_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_0x5F_toread_0(w2c_rlbox*, u32);
static void w2c_rlbox_0x5F_toread_needs_stdio_exit_0(w2c_rlbox*);
static u32 w2c_rlbox_fread_0(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_0x5F_fseeko_unlocked_0(w2c_rlbox*, u32, u64, u32);
static u32 w2c_rlbox_0x5F_fseeko_0(w2c_rlbox*, u32, u64, u32);
static u32 w2c_rlbox_fseek_0(w2c_rlbox*, u32, u32, u32);
static u64 w2c_rlbox_0x5F_ftello_unlocked_0(w2c_rlbox*, u32);
static u64 w2c_rlbox_0x5F_ftello_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_ftell_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_0x5F_fwritex_0(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_fwrite_0(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_0x5F_ofl_lock_0(w2c_rlbox*);
static void w2c_rlbox_0x5F_ofl_unlock_0(w2c_rlbox*);
static u32 w2c_rlbox_0x5F_ofl_add_0(w2c_rlbox*, u32);
static void w2c_rlbox_setbuf_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_setvbuf_0(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_snprintf_0(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_sscanf_0(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_swprintf_0(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_vasprintf_0(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_wctomb_0(w2c_rlbox*, u32, u32);
static f64 w2c_rlbox_frexp_0(w2c_rlbox*, f64, u32);
static u32 w2c_rlbox_fputs_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_vfprintf_0(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_printf_core(w2c_rlbox*, u32, u32, u32, u32, u32);
static void w2c_rlbox_pop_arg(w2c_rlbox*, u32, u32, u32);
static void w2c_rlbox_pad(w2c_rlbox*, u32, u32, u32, u32, u32);
static void w2c_rlbox_long_double_not_supported(w2c_rlbox*);
static u32 w2c_rlbox_vsnprintf_0(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_sn_write(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_0x5F_uflow_0(w2c_rlbox*, u32);
static void w2c_rlbox_0x5F_shlim_0(w2c_rlbox*, u32, u64);
static u32 w2c_rlbox_0x5F_shgetc_0(w2c_rlbox*, u32);
static u64 w2c_rlbox_0x5F_intscan_0(w2c_rlbox*, u32, u32, u32, u64);
static f64 w2c_rlbox_scalbn_0(w2c_rlbox*, f64, u32);
static f64 w2c_rlbox_fmod_0(w2c_rlbox*, f64, f64);
static f64 w2c_rlbox_0x5F_floatscan_0(w2c_rlbox*, u32, u32, u32);
static f64 w2c_rlbox_hexfloat(w2c_rlbox*, u32, u32, u32, u32, u32);
static u64 w2c_rlbox_scanexp(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_mbsinit_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_vfscanf_0(w2c_rlbox*, u32, u32, u32);
static void w2c_rlbox_long_double_not_supported0x2E1(w2c_rlbox*);
static u32 w2c_rlbox_vsscanf_0(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_string_read(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_fwide_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_0x5F_fputwc_unlocked_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_fputwc_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_fprintf_0(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_vfwprintf_0(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_wprintf_core(w2c_rlbox*, u32, u32, u32, u32, u32);
static void w2c_rlbox_pop_arg0x2E1(w2c_rlbox*, u32, u32, u32);
static void w2c_rlbox_long_double_not_supported0x2E2(w2c_rlbox*);
static u32 w2c_rlbox_vswprintf_0(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_sw_write(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_atoi_0(w2c_rlbox*, u32);
static void w2c_rlbox_0x5F_qsort_r_0(w2c_rlbox*, u32, u32, u32, u32, u32);
static void w2c_rlbox_sift(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static void w2c_rlbox_trinkle(w2c_rlbox*, u32, u32, u32, u32, u32, u32, u32, u32);
static void w2c_rlbox_qsort_0(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_wrapper_cmp(w2c_rlbox*, u32, u32, u32);
static f32 w2c_rlbox_strtof_0(w2c_rlbox*, u32, u32);
static f64 w2c_rlbox_strtod_0(w2c_rlbox*, u32, u32);
static void w2c_rlbox_strtold_0(w2c_rlbox*, u32, u32, u32);
static void w2c_rlbox_long_double_not_supported0x2E3(w2c_rlbox*);
static u64 w2c_rlbox_strtoull_0(w2c_rlbox*, u32, u32, u32);
static u64 w2c_rlbox_strtoll_0(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_strtoul_0(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_strtol_0(w2c_rlbox*, u32, u32, u32);
static u64 w2c_rlbox_strtoimax_0(w2c_rlbox*, u32, u32, u32);
static u64 w2c_rlbox_strtoumax_0(w2c_rlbox*, u32, u32, u32);
static f32 w2c_rlbox_wcstof_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_do_read(w2c_rlbox*, u32, u32, u32);
static f64 w2c_rlbox_wcstod_0(w2c_rlbox*, u32, u32);
static void w2c_rlbox_wcstold_0(w2c_rlbox*, u32, u32, u32);
static void w2c_rlbox_long_double_not_supported0x2E4(w2c_rlbox*);
static u64 w2c_rlbox_wcstoull_0(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_do_read0x2E1(w2c_rlbox*, u32, u32, u32);
static u64 w2c_rlbox_wcstoll_0(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_wcstoul_0(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_wcstol_0(w2c_rlbox*, u32, u32, u32);
static u64 w2c_rlbox_wcstoimax_0(w2c_rlbox*, u32, u32, u32);
static u64 w2c_rlbox_wcstoumax_0(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_memchr_0(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_memcmp_0(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_strchr_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_0x5F_strchrnul_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_strcmp_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_0x5F_stpcpy_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_strcpy_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_strdup_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_strlen_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_strncmp_0(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_0x5F_stpncpy_0(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_strncpy_0(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_strnlen_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_strstr_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_fourbyte_strstr(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_twoway_strstr(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_wcschr_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_wcscmp_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_wcslen_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_wcsnlen_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_wmemchr_0(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_wmemcmp_0(w2c_rlbox*, u32, u32, u32);
static u32 w2c_rlbox_wmemcpy_0(w2c_rlbox*, u32, u32, u32);
static u64 w2c_rlbox_0x5F_year_to_secs_0(w2c_rlbox*, u64, u32);
static u32 w2c_rlbox_0x5F_month_to_secs_0(w2c_rlbox*, u32, u32);
static u64 w2c_rlbox_0x5F_tm_to_secs_0(w2c_rlbox*, u32);
static void w2c_rlbox_0x5F_secs_to_zone_0(w2c_rlbox*, u64, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_0x5F_tm_to_tzname_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_0x5F_nl_langinfo_l_0(w2c_rlbox*, u32, u32);
static u32 w2c_rlbox_0x5F_nl_langinfo_0(w2c_rlbox*, u32);
static u32 w2c_rlbox_0x5F_strftime_fmt_1_0(w2c_rlbox*, u32, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_week_num(w2c_rlbox*, u32);
static u32 w2c_rlbox_0x5F_strftime_l_0(w2c_rlbox*, u32, u32, u32, u32, u32);
static u32 w2c_rlbox_strftime_0(w2c_rlbox*, u32, u32, u32, u32);
static u32 w2c_rlbox_0x5F_letf2_0(w2c_rlbox*, u64, u64, u64, u64);
static u32 w2c_rlbox_0x5F_getf2_0(w2c_rlbox*, u64, u64, u64, u64);
static u32 w2c_rlbox_0x5F_unordtf2_0(w2c_rlbox*, u64, u64, u64, u64);
static void w2c_rlbox_0x5F_multi3_0(w2c_rlbox*, u32, u64, u64, u64, u64);
static void w2c_rlbox_0x5F_ashlti3_0(w2c_rlbox*, u32, u64, u64, u32);
static void w2c_rlbox_0x5F_udivmodti4_0(w2c_rlbox*, u32, u64, u64, u64, u64, u32);
static void w2c_rlbox_0x5F_udivti3_0(w2c_rlbox*, u32, u64, u64, u64, u64);

FUNC_TYPE_T(w2c_rlbox_t0) = "\x07\x80\x96\x7a\x42\xf7\x3e\xe6\x70\x5c\x2f\xac\x83\xf5\x67\xd2\xa2\xa0\x69\x41\x5f\xf8\xe7\x96\x7f\x23\xab\x00\x03\x5f\x4a\x3c";
FUNC_TYPE_T(w2c_rlbox_t1) = "\x92\xfb\x6a\xdf\x49\x07\x0a\x83\xbe\x08\x02\x68\xcd\xf6\x95\x27\x4a\xc2\xf3\xe5\xe4\x7d\x29\x49\xe8\xed\x42\x92\x6a\x9d\xda\xf0";
FUNC_TYPE_T(w2c_rlbox_t2) = "\x89\x3a\x3d\x2c\x8f\x4d\x7f\x6d\x6c\x9d\x62\x67\x29\xaf\x3d\x44\x39\x8e\xc3\xf3\xe8\x51\xc1\x99\xb9\xdd\x9f\xd5\x3d\x1f\xd3\xe4";
FUNC_TYPE_T(w2c_rlbox_t3) = "\x78\xde\x71\xb6\x49\x9a\x33\x9d\xd3\x70\x88\x4c\x50\xd4\xea\xdf\xe1\x2a\x18\x12\xf6\xf3\x64\xf7\xea\x4f\x94\x19\xa7\x20\x28\xe8";
FUNC_TYPE_T(w2c_rlbox_t4) = "\xcd\xad\x8f\x6a\xaf\x3e\xd0\x86\xf0\x9a\xd7\xf0\xc7\x0d\x48\x9f\x27\x59\xf3\x8d\x71\xa1\x81\xa8\xcc\x06\x53\x98\x62\x34\xaa\xf5";
FUNC_TYPE_T(w2c_rlbox_t5) = "\xf6\x98\x1b\xc6\x10\xda\xb7\xb2\x63\x37\xcd\xdc\x72\xca\xe9\x50\x00\x13\xba\x10\x6c\xde\x87\x27\x10\xf8\x86\x2f\xe3\xdb\x94\xe4";
FUNC_TYPE_T(w2c_rlbox_t6) = "\xff\x57\x1f\x83\x74\x67\x5d\x67\x2a\xc8\x0d\x92\x3d\xe8\x47\xa1\x1e\x73\xc7\x03\xa1\xee\x83\x72\x66\xa9\x1c\x9d\xe7\x8c\xdd\xfb";
FUNC_TYPE_T(w2c_rlbox_t7) = "\x81\x39\xe9\x80\x36\x86\x39\xf3\xbe\x5e\x29\xbf\x55\x64\xbe\x61\xa7\x82\x5c\x6d\x98\x51\xff\xf0\x20\x11\x16\xc8\x91\x9f\xb9\xb5";
FUNC_TYPE_T(w2c_rlbox_t8) = "\x10\x14\x42\x90\xbf\xa8\x37\x8c\xdc\x81\x9f\x4c\x63\x4e\x62\xb7\x11\x29\xaa\x09\x68\x89\x5f\x5e\x13\x9c\xcc\xe2\xcb\x51\x7a\x78";
FUNC_TYPE_T(w2c_rlbox_t9) = "\xfe\x25\x30\xe2\x9b\x00\xea\x69\xb9\xd5\x80\xfe\x99\x3b\x59\x29\x77\xcb\x00\x18\x3b\x9c\x72\x83\x2d\x2e\xac\x0a\x70\xf6\x32\x31";
FUNC_TYPE_T(w2c_rlbox_t10) = "\x9c\x4d\x07\x53\xeb\x6b\x2c\xa8\xcf\xd2\x77\xe8\x4d\x71\x93\xe9\xb0\x77\xff\x6e\x92\x8d\xa6\xe4\x33\x4b\x31\xac\x4d\xf2\xe2\xda";
FUNC_TYPE_T(w2c_rlbox_t11) = "\xba\xa5\xc9\x95\x73\x20\x33\x01\x21\x92\x2a\x4d\x71\x30\xec\x53\xa9\x35\x2b\xa7\x73\x00\x57\xe3\x3a\x04\x86\x40\xa9\xc5\xf4\xbe";
FUNC_TYPE_T(w2c_rlbox_t12) = "\x26\x10\x81\xe2\x21\x43\xd6\x01\x3e\x2d\x2f\x16\x17\x78\x6f\xba\xb3\x2f\x4d\x54\x9b\x8a\xa9\xdd\xbf\x53\x92\x3c\xd3\x71\xc6\xb2";
FUNC_TYPE_T(w2c_rlbox_t13) = "\xcf\xb5\x37\xa6\xae\x30\x78\x2f\x83\xa5\x5e\x4f\x92\x9e\x80\x85\xb4\x8d\x6c\x74\xb4\x37\xbc\x8c\x81\xe8\xcc\x78\x8a\x74\xd6\x28";
FUNC_TYPE_T(w2c_rlbox_t14) = "\xe3\xe1\xd3\x75\x5f\x41\x96\xa4\xe0\xe2\x50\x99\x37\x4f\xf5\x5e\xe1\x88\xd0\x58\xd1\x33\xdb\xb3\xac\xd6\x1a\x23\xbf\xd4\xc0\x31";
FUNC_TYPE_T(w2c_rlbox_t15) = "\xba\x44\x3c\xc8\xe3\xd6\x3a\x89\xdc\x0f\x28\x88\xc0\x0d\xab\x95\x20\xf6\xe0\xfb\xea\xc7\x65\xbc\xe5\x1b\x9e\x9a\xd1\x1e\xea\xde";
FUNC_TYPE_T(w2c_rlbox_t16) = "\x87\x63\x02\xad\x1e\x92\xa3\x49\x85\x27\x29\xca\x07\x0b\x6d\x07\xaa\x90\x25\x39\x2a\xbe\xd6\xb7\x36\x71\x93\xbe\xbe\x6f\x83\x63";
FUNC_TYPE_T(w2c_rlbox_t17) = "\xeb\x37\x5a\xb2\x0a\x41\x12\xfc\x79\x6a\x79\x4c\x31\xae\x2a\x0b\x11\x16\x8c\x73\x56\xf9\xee\xc0\x0d\xdc\xc9\x93\x84\x4e\x3a\x78";
FUNC_TYPE_T(w2c_rlbox_t18) = "\x9a\xa7\x24\x89\xd8\x1a\xd7\x88\x19\xe7\x6e\x74\x87\xd8\x51\xb6\x29\x78\x1d\xef\x64\x37\x80\x63\xfe\xbf\xd2\x63\x83\x36\xae\x01";
FUNC_TYPE_T(w2c_rlbox_t19) = "\xd4\x99\x85\x78\x64\x65\x9d\xdd\xc9\x5a\x22\xd7\xc9\x00\x34\xb0\x5b\x0f\xf0\x6e\xc9\x5c\xe5\x31\xe2\x1f\x61\x99\xd3\x8c\x37\x27";
FUNC_TYPE_T(w2c_rlbox_t20) = "\x1e\x50\xdc\xcf\x7e\xfa\x1a\xc1\x60\x2d\x95\x37\x07\x01\x3a\xe3\x24\x35\xc1\x7e\x9b\xe9\xae\x59\x29\xae\xc8\x96\x23\x1e\x25\x28";
FUNC_TYPE_T(w2c_rlbox_t21) = "\x36\xa9\xe7\xf1\xc9\x5b\x82\xff\xb9\x97\x43\xe0\xc5\xc4\xce\x95\xd8\x3c\x9a\x43\x0a\xac\x59\xf8\x4e\xf3\xcb\xfa\xb6\x14\x50\x68";
FUNC_TYPE_T(w2c_rlbox_t22) = "\x72\x95\xc9\x03\x14\x98\x9d\xfa\xa4\x71\xa5\x52\x41\xef\x01\x2b\x0c\x44\x92\x47\x2d\x6a\xf2\x42\x1b\x46\x76\x98\x74\x7e\x94\x3c";
FUNC_TYPE_T(w2c_rlbox_t23) = "\x16\x62\x73\x5a\x4c\xd9\x16\x37\xb0\x31\x49\x80\x8b\x55\x54\x52\x0f\x1a\x5d\x5f\x0f\x0e\x03\x34\xe2\xe0\x42\x9a\x12\xa6\xbb\x31";
FUNC_TYPE_T(w2c_rlbox_t24) = "\x39\x76\x1c\xc1\xf6\x8b\x63\xd1\x4f\x26\x9a\x9d\x2c\xd4\x2c\x21\x2a\x8f\x7f\xf2\xa5\xfd\xf4\x02\xf5\xb5\xe9\x92\x25\x47\x55\x60";
FUNC_TYPE_T(w2c_rlbox_t25) = "\x14\xc4\xea\xf1\xb5\xbd\x85\xb0\xb6\x57\x8b\x98\x9f\x3a\x34\xe6\xa2\x62\x23\x7e\xb1\x4a\x4f\x01\xe2\x30\x7a\x55\x18\x51\xba\xa7";
FUNC_TYPE_T(w2c_rlbox_t26) = "\xd6\x9b\x96\x20\xd5\x85\xd0\xbe\x78\x95\x77\x65\xc8\xf4\x4e\x73\x96\xed\xf8\x84\x48\xb3\x80\x16\x37\x37\x65\x94\xe1\xed\x5a\x69";
FUNC_TYPE_T(w2c_rlbox_t27) = "\x6c\x9c\x53\x1a\xdd\x7f\xe5\x69\x16\x4e\x66\x8f\xa2\x8f\x87\xd9\xf8\x67\x49\x93\xe3\x5b\x65\x89\xc6\xca\xf0\x41\x42\xb5\x6e\x82";
FUNC_TYPE_T(w2c_rlbox_t28) = "\x94\x12\x2b\x98\xca\x29\xf3\x2c\xff\x5f\xc8\x3f\xc2\x8f\xd7\x70\x9f\x6c\x7f\xc7\x68\x16\x42\xe0\x46\x64\xbb\x79\x3d\xbf\x91\x63";
FUNC_TYPE_T(w2c_rlbox_t29) = "\xf0\xcf\x3c\x13\x35\x18\x96\x31\xe2\x88\x8f\x72\xcd\x97\x45\xfe\x7c\x55\xf0\x67\x0a\xde\xf3\xd7\x66\xa6\x10\xb6\x69\x67\x6c\x55";
FUNC_TYPE_T(w2c_rlbox_t30) = "\xc8\xb4\x32\x7f\x30\xd6\x74\x1d\x89\x51\xbd\x55\x66\xa6\xfc\x17\x99\x53\xb1\x2b\xb7\x54\xd3\xed\xd0\x03\x38\xd2\x22\x94\xfa\x72";
FUNC_TYPE_T(w2c_rlbox_t31) = "\x72\xab\x00\xdf\x20\x3d\xce\xa1\xf2\x29\xc7\x9d\x13\x40\x7e\x98\xac\x7d\x41\x4a\x53\x2e\x42\x42\x61\x55\x2e\xaa\xeb\xbe\xc6\x35";
FUNC_TYPE_T(w2c_rlbox_t32) = "\x34\xdb\x83\x7a\x75\x3e\xc6\x13\xe5\xf4\xea\xd1\x67\xfb\xe4\x11\x01\x6b\xcf\x7c\xac\xb1\x84\x7b\xf9\xdf\x70\xfd\xb7\x70\x78\x1b";
FUNC_TYPE_T(w2c_rlbox_t33) = "\xa2\x2d\x22\x7e\xde\xdd\x67\xef\x14\x48\x0e\xdc\x93\xe0\xc7\xa7\x23\x4a\xa7\x18\xe7\x46\xa6\x78\xe8\xe9\x29\x8e\xc4\xe8\x7e\x3d";
FUNC_TYPE_T(w2c_rlbox_t34) = "\x3c\x4c\x4c\x8a\x96\xd8\x1e\x37\xa6\xb8\xdf\xc1\x62\x64\x57\x83\xfd\x1a\xb2\x33\xa0\xe6\x41\xf1\x85\x66\x6a\x0d\xef\x6b\x0d\xcc";
FUNC_TYPE_T(w2c_rlbox_t35) = "\xb6\x71\xac\xd8\xe8\xdd\x24\xc1\xa8\x77\xef\xa1\xa6\x32\xdd\x3f\xcd\x3b\xf8\xf0\x47\xa4\x1a\x8a\xbc\x8a\xbf\x5e\x8f\xc1\x65\x63";
FUNC_TYPE_T(w2c_rlbox_t36) = "\x02\x8f\x32\x6f\xc9\xb4\xfb\x6b\xd4\x6e\x5c\x53\xc6\xa7\x28\x64\xc5\xeb\xfa\xea\xc3\xf9\x08\x6b\x06\x66\x29\x52\xdf\x09\x92\xb4";
FUNC_TYPE_T(w2c_rlbox_t37) = "\x2f\xed\x3a\x40\x22\xde\x64\x53\x55\x89\xce\x0d\x1b\x24\x9f\xdc\xcf\xa2\xbc\xc4\x0d\x9a\x45\x23\x8a\x51\x17\x49\xa7\xaf\x9c\x9a";
FUNC_TYPE_T(w2c_rlbox_t38) = "\x8e\xea\x32\x5a\xfa\xcc\x51\xea\x7d\x93\x88\xb6\x64\x65\x37\x60\x0d\x89\xd5\xe8\xfa\xf1\x65\xaf\xda\xaf\xb3\x70\x8c\xde\xd9\x7e";
FUNC_TYPE_T(w2c_rlbox_t39) = "\x45\xef\xed\xd7\xfe\x28\x4c\x24\x06\x38\x61\xf4\xbd\xe9\xab\xa2\xa6\x71\x6b\x22\xc9\x6a\x25\xa3\x5d\x8d\x55\x58\x87\xf7\xcc\x47";
FUNC_TYPE_T(w2c_rlbox_t40) = "\x0d\x1e\xd3\x4d\x9b\x71\x8c\x10\x1e\xb6\x4b\x02\x2a\x6b\x7a\xf3\x7d\x4e\x0d\xad\xb7\x3d\xf4\x55\xbe\x8c\xcf\x54\xff\x90\x74\x6e";
FUNC_TYPE_T(w2c_rlbox_t41) = "\xcd\x55\x01\x97\xb0\xa0\xc4\x42\xfc\xbd\xe1\xab\x7f\x5d\x69\x20\xa2\x95\x3a\x90\xc5\x0b\x27\x21\x73\x9d\x06\xb4\x0b\x74\x75\xb2";
FUNC_TYPE_T(w2c_rlbox_t42) = "\x28\xa3\x2c\x85\xe7\xaf\x5c\xec\x07\x89\x8d\xca\x9c\xb1\x02\x66\x2c\x77\x09\x27\x34\x2d\x1e\xf9\x45\x05\xae\xe6\x56\x5d\x03\x41";
FUNC_TYPE_T(w2c_rlbox_t43) = "\x23\xba\x2b\xa1\x77\x70\xfd\x11\x22\x1a\x8e\x77\x91\x74\xf1\x56\x31\x90\x38\x85\x04\x37\x22\x49\x7e\xe8\x26\x58\x52\xd4\x92\x64";
FUNC_TYPE_T(w2c_rlbox_t44) = "\xb5\x0a\x9c\x42\x39\xa4\x23\x28\xd6\x71\x01\x63\xa1\x6b\xf9\xdd\xb0\xef\x80\x3e\xa1\xb5\x48\x3e\x68\xdc\x9e\x95\x44\x3b\x20\xf6";
FUNC_TYPE_T(w2c_rlbox_t45) = "\x85\x35\xaf\x3a\x24\xcc\xd9\x23\x22\x76\xb7\xc4\x40\x5a\x60\x68\xa2\x5f\xca\x5e\x8a\x2e\x22\x2d\x06\x53\x8c\xe3\x64\x11\x49\xc6";
FUNC_TYPE_T(w2c_rlbox_t46) = "\xbb\x34\x05\x18\x1c\xc9\x5b\x02\xee\x04\x28\x0f\x2b\x84\x66\x35\x1d\xca\x67\x7f\x96\x5c\x01\xa1\x98\x3e\xb7\xf5\x9d\xc1\x21\xd3";
FUNC_TYPE_T(w2c_rlbox_t47) = "\xa1\x06\x63\x7c\x16\xf0\x73\x0d\xea\xbc\x0c\x8d\x32\x1c\x27\xd7\x72\xb4\xde\x26\x91\x05\x9d\x41\x7f\x36\x47\x22\xde\x15\xb3\xf6";
FUNC_TYPE_T(w2c_rlbox_t48) = "\xbe\x68\xfe\x2f\x67\x12\x8f\xf2\xd6\xdc\xdb\x27\x2b\xc1\x6e\x14\x8b\x8d\x0b\x97\x15\x55\x96\x1b\xc3\x91\xc2\x55\xb6\x7e\xe5\x60";
FUNC_TYPE_T(w2c_rlbox_t49) = "\x84\x80\x6d\x9f\x89\xef\x6b\x7f\x36\x08\x95\x92\x7d\xba\x3d\x88\xa9\x3d\x20\xa0\x38\x2e\x9b\x82\x85\x87\x89\x9f\xa9\x93\xcf\x74";
FUNC_TYPE_T(w2c_rlbox_t50) = "\xf8\x6b\xf6\xf0\x16\xec\x29\x47\xfc\x38\xf2\x2f\x0d\xa6\x52\xa0\x80\xde\x88\xe0\xa4\x5f\x1d\x23\x14\xe5\x2d\xd2\x50\x56\x14\xe4";
FUNC_TYPE_T(w2c_rlbox_t51) = "\x19\xb8\xea\x58\x7b\x20\x23\x6d\x20\xce\x7c\x01\xc4\xa4\x31\x82\xce\x0f\x92\xd4\x67\xf2\x9c\x19\x14\x2c\x14\x4c\x72\xeb\xbc\x03";
FUNC_TYPE_T(w2c_rlbox_t52) = "\x9a\x1d\xec\x0a\xab\xde\x42\x5c\x53\x0f\x17\x40\x0c\x8b\x01\x2c\xe6\x0c\xe8\x21\x69\x5b\x25\x6a\xd0\x56\xe4\x00\x83\xd8\x2b\xea";
FUNC_TYPE_T(w2c_rlbox_t53) = "\xee\xd7\x52\x00\x2d\x2b\x7f\x91\x0e\x23\x41\x5a\xa1\xda\x6f\x4c\x11\x31\x43\x03\xcc\x16\x66\x0f\x65\x42\x9a\x91\x89\x54\x4f\xc1";
FUNC_TYPE_T(w2c_rlbox_t54) = "\x13\x7f\x59\x3e\x75\xe9\x6a\xb8\x75\x56\x17\xd4\xc1\x1d\x7e\x35\xd6\x19\x27\xee\x82\xe2\x15\x5e\x82\x83\x30\x8d\xe4\xe9\x27\x10";
FUNC_TYPE_T(w2c_rlbox_t55) = "\xdf\xbb\x30\x1f\x72\x01\xbd\x57\x36\x58\x68\x8f\xf8\xb4\x8e\x09\x1c\xd5\x1e\xb5\x36\xde\x2a\x37\xfe\x62\x39\x54\xb4\x81\x72\x61";
FUNC_TYPE_T(w2c_rlbox_t56) = "\x75\x3a\x59\x9c\xf9\xb7\x34\x14\x45\xf6\x77\x94\x3e\x8b\x2c\xf2\x68\x94\x2e\x6a\x59\x73\x3f\xb5\xf6\x09\xb3\x72\xfd\x4c\x9f\xe7";
FUNC_TYPE_T(w2c_rlbox_t57) = "\x68\xe1\x9d\x38\xdb\x89\x2e\x3f\xb9\xfd\x95\x7f\xe8\x3d\x6b\x20\x80\x4b\x3a\x8b\xae\xba\xb8\x28\x00\xf3\xd3\xb9\x01\xc8\xa7\xdf";
FUNC_TYPE_T(w2c_rlbox_t58) = "\xa6\x83\x1a\x14\xc3\x06\xed\xb0\xc1\xda\x87\x2f\x07\x53\x23\x00\xfd\x3d\xd0\x1d\x58\xab\xd8\xbf\xcf\x54\xdb\xc5\x02\xc8\x07\x27";
FUNC_TYPE_T(w2c_rlbox_t59) = "\x90\x8f\x81\x00\x2b\xca\x26\x3d\x5e\x4f\x40\xca\x14\xfd\x00\xb8\xf1\x65\x87\x21\x35\xe3\xfd\x4b\x84\x6b\x9f\xec\xd8\xfb\x54\x1d";
FUNC_TYPE_T(w2c_rlbox_t60) = "\x8e\x29\x53\x95\x14\x47\xee\xa5\x7d\xce\xae\x68\xc0\x6d\x4d\x58\x6f\x62\x92\x18\x70\xe8\xb1\x27\x00\xe8\xfa\xf5\xf0\xe0\x5e\xab";
FUNC_TYPE_T(w2c_rlbox_t61) = "\x84\xfd\x5f\x84\x9c\x91\xa6\x7a\x2c\xd5\x3d\x6f\x19\x1d\x56\xb8\x17\x40\x6a\xbe\x42\x02\x42\xef\xe7\x69\xc6\x68\xed\x82\xf1\x21";
FUNC_TYPE_T(w2c_rlbox_t62) = "\x7f\x47\x50\x5e\x2a\xc9\x8c\xbb\x0d\x5a\x44\xd7\xde\x46\xaf\xcd\x6f\xc9\x16\x0a\xf6\xcb\x4d\xa9\xa5\xa1\x1a\x60\x6a\x14\x3e\x9f";
FUNC_TYPE_T(w2c_rlbox_t63) = "\x98\x89\x5c\xbd\x28\xfd\x0e\x4d\xc5\xdc\x68\x2c\x7c\xee\x61\x09\x14\x19\x30\x62\xc2\x2f\x49\xc5\xb5\x81\x57\x55\x6b\xe7\xa5\xb9";
FUNC_TYPE_T(w2c_rlbox_t64) = "\xe4\x86\x49\x6b\x60\x0c\x7a\x58\xb1\x3b\x19\xea\x31\xd4\xe1\x7a\x30\x21\xd5\x4b\x6b\x69\xfc\x41\xc9\x51\x70\xf2\xf9\x17\x44\xed";
FUNC_TYPE_T(w2c_rlbox_t65) = "\xb6\x13\xe6\x8b\xc6\xb5\x1e\x69\x24\x54\x06\x70\x17\x9c\x39\x9e\x17\x5e\x90\x34\xc3\x8d\x28\xcf\xc3\xdb\x35\x05\x26\x4d\xe9\x8d";
FUNC_TYPE_T(w2c_rlbox_t66) = "\x7c\x41\x1d\xc1\xaf\x41\x20\xb6\x16\xc6\x51\xc2\x77\xf6\xed\x25\xe0\x19\xb4\xc5\xcf\x53\xe6\xc3\x47\xe1\xd2\xc0\x23\x4a\x02\x90";
FUNC_TYPE_T(w2c_rlbox_t67) = "\x4f\x3c\x9e\x1f\x9b\x0c\x08\x8e\xfc\x8a\x87\x95\xda\x69\x9b\x85\xe2\x1c\xc3\x6e\xe8\xae\x6c\x99\xd5\x0f\x2c\xb3\xb3\xba\x34\xf8";
FUNC_TYPE_T(w2c_rlbox_t68) = "\xa1\xde\xc2\xc3\x8b\xb4\xe9\xb0\xc2\xb5\xb7\x1f\x96\x5d\x28\x49\xed\x90\xe8\xbc\x74\x35\xca\x5a\xc8\x7e\x80\x1d\xce\x70\x55\xcf";
FUNC_TYPE_T(w2c_rlbox_t69) = "\x13\x31\x72\x0e\xad\x03\xaa\xbf\x66\xb7\x6a\xc7\x0c\x20\xcc\x82\xfa\x7a\xaa\x9c\x90\xf7\xd2\xd3\x54\x72\x95\xca\xa2\x6b\x5e\x7b";
FUNC_TYPE_T(w2c_rlbox_t70) = "\x46\x41\x67\x1c\xcf\xe0\xc3\x94\x09\xd9\x08\xe9\x78\x2d\x5a\x82\x12\x11\xf3\x8c\x3e\xf1\xe2\xa3\x27\xcb\x65\x9b\x88\x39\x56\x66";
FUNC_TYPE_T(w2c_rlbox_t71) = "\x0c\xb5\x5b\x56\xaf\x6d\x52\xf7\xb7\xf9\x7f\x12\xc2\xb3\xc1\x5c\x90\x0d\xa3\x3c\xcc\xa3\x24\x46\x3b\x42\xed\xc0\x4f\x2f\x73\x4b";
FUNC_TYPE_T(w2c_rlbox_t72) = "\xd6\xdf\xd3\x39\x7f\x5d\x5c\x42\x36\xd5\x80\x26\x47\x32\x3f\x8b\x2b\x31\x77\x79\xfa\xc6\x3f\x00\xf7\xed\x5e\xca\x9b\x26\xbf\x3b";
FUNC_TYPE_T(w2c_rlbox_t73) = "\xc1\x35\x64\x94\x2d\x55\x73\x56\xf4\xe1\x63\x0d\x0e\xe1\x22\x79\x32\x48\xe9\x1a\x10\x0b\x2b\x94\x08\xe2\xbe\x33\x0f\x6d\x15\x99";
FUNC_TYPE_T(w2c_rlbox_t74) = "\xfa\xc8\x6c\x10\xa2\x0c\x23\xd1\x5e\x62\x83\x60\x5d\x8f\xb0\xe4\x84\xd4\x26\x8a\xd3\x19\xe9\xf9\x99\xe9\xcb\x05\xc2\xdd\x25\x96";
FUNC_TYPE_T(w2c_rlbox_t75) = "\x56\x5c\xfc\x6d\xf4\xe5\xd5\x06\x01\x90\x7d\x20\x97\x74\xa1\x67\x3e\x00\x21\xa4\x0b\xc6\x06\x23\x7f\x60\xe5\xbf\x23\x2b\x7c\xe9";
FUNC_TYPE_T(w2c_rlbox_t76) = "\x99\xfc\x4f\x63\xef\x58\x3d\x74\x39\x4a\x47\x05\x19\x9c\xba\x43\x84\xb4\x02\xd2\xd3\xa4\x58\xf9\x58\xb8\x59\x39\x00\xac\xb0\xd8";
FUNC_TYPE_T(w2c_rlbox_t77) = "\xd8\x36\x07\x7a\x74\x6b\xa2\x54\x89\x0f\x61\xc1\x46\xaa\x2c\xc4\x33\x73\xf9\x6e\xd7\xd8\xfd\xc1\x85\x8e\xd3\xc6\x23\x44\x51\x81";
FUNC_TYPE_T(w2c_rlbox_t78) = "\xcb\x35\x33\x48\x99\xc7\xee\xd1\xbe\xa0\x97\x29\x0e\x3b\x53\x63\xfd\x8d\x79\x66\x0e\xa8\xd0\xa5\xac\x96\xb0\x15\x44\x8e\x99\xa8";
FUNC_TYPE_T(w2c_rlbox_t79) = "\x73\x63\xce\x9e\xfb\xa2\x69\x78\x11\xef\x02\x89\x3e\x76\x5a\x8b\xee\x81\xb0\x64\xce\x7e\xe5\x09\x26\x9c\x86\x84\xff\x5b\x30\xda";
FUNC_TYPE_T(w2c_rlbox_t80) = "\xb6\x3b\xb2\x62\x4c\x1e\xcd\x51\x72\xc5\xe7\x8f\x90\xbb\xf3\x60\x66\xb2\x0e\x8f\x5f\xa6\x1b\xc1\xa4\x65\x1b\x40\xb9\x77\x96\x12";
FUNC_TYPE_T(w2c_rlbox_t81) = "\x66\x05\x10\x6d\xd7\xb8\x16\xc1\x31\xe6\x0e\xca\xa2\x97\x7c\x25\x0b\xeb\xd2\x75\x15\x8d\x79\x6e\x20\x13\x2c\xbe\x14\x2d\xdf\xfc";
FUNC_TYPE_T(w2c_rlbox_t82) = "\x93\xdb\x38\xf2\x1c\xb7\x06\xd6\x56\xf2\x78\xe9\x62\xcd\xa0\xd0\xca\xf1\xfa\x24\x38\x6c\xc1\x81\x2e\xe3\x0a\xdc\xf2\x6d\xff\xc5";
FUNC_TYPE_T(w2c_rlbox_t83) = "\x7e\x60\x7c\x9b\xd4\xbd\x61\x6d\x36\xb7\xf6\xa9\xa6\x74\xef\xcf\xfd\x20\xc9\xcc\xdb\x60\x2b\x1b\x9c\x88\xbe\xd3\x04\xb9\x7b\xcb";
FUNC_TYPE_T(w2c_rlbox_t84) = "\x9c\x95\xd9\x78\xa6\xf5\xe0\x39\xaa\xdf\x8b\xfe\x20\xb6\x97\xf9\xc8\x20\x00\x0a\xbf\x68\x9a\x0d\x99\xc0\x93\xec\x10\xf6\x01\x66";
FUNC_TYPE_T(w2c_rlbox_t85) = "\x05\x4b\xc7\xd1\x05\x09\x86\x2a\x5e\x24\x7a\xb1\x76\x1f\x46\x3d\xc1\xad\x69\x4c\x72\xe2\x9f\xc3\xa8\xcb\x33\xc0\x6a\xd1\x29\xf0";
FUNC_TYPE_T(w2c_rlbox_t86) = "\x06\xa0\x0b\x63\xfa\xeb\x09\xff\x42\x9b\x64\x4d\x6e\xe1\x54\x74\x61\x55\x46\x67\x42\x5b\xa1\xca\xce\x16\x3f\xa0\x8b\x7c\x83\x31";
FUNC_TYPE_T(w2c_rlbox_t87) = "\x31\xb9\x04\x41\x13\xaa\xd0\x9c\x5d\xb8\xf9\x27\x88\x5b\xb5\x37\x0b\xb2\x9a\xae\x32\x6a\x9b\x73\xb7\x8c\x1b\xb7\xa9\xd2\x60\xfa";

static void wrap_w2c_rlbox_oggpack_write_0(void *instance, u32 var_0, u32 var_1, u32 var_2) {
  return w2c_rlbox_oggpack_write_0(instance, var_0, var_1, var_2);
}
static void wrap_w2c_rlbox_oggpackB_write_0(void *instance, u32 var_0, u32 var_1, u32 var_2) {
  return w2c_rlbox_oggpackB_write_0(instance, var_0, var_1, var_2);
}
static u32 wrap_w2c_rlbox_prologInitProcessor(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_prologInitProcessor(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_externalEntityInitProcessor(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_externalEntityInitProcessor(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_externalParEntInitProcessor(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_externalParEntInitProcessor(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_externalEntityInitProcessor2(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_externalEntityInitProcessor2(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_entityValueInitProcessor(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_entityValueInitProcessor(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_externalParEntProcessor(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_externalParEntProcessor(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_errorProcessor(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_errorProcessor(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_prologProcessor(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_prologProcessor(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_contentProcessor(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_contentProcessor(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_ignoreSectionProcessor(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_ignoreSectionProcessor(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_internalEntityProcessor(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_internalEntityProcessor(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_epilogProcessor(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_epilogProcessor(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_cdataSectionProcessor(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_cdataSectionProcessor(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_externalEntityContentProcessor(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_externalEntityContentProcessor(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_externalEntityInitProcessor3(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_externalEntityInitProcessor3(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_entityValueProcessor(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_entityValueProcessor(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_XmlInitUnknownEncoding_0(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_XmlInitUnknownEncoding_0(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_unknown_isInvalid(void *instance, u32 var_0, u32 var_1) {
  return w2c_rlbox_unknown_isInvalid(instance, var_0, var_1);
}
static u32 wrap_w2c_rlbox_unknown_isNmstrt(void *instance, u32 var_0, u32 var_1) {
  return w2c_rlbox_unknown_isNmstrt(instance, var_0, var_1);
}
static u32 wrap_w2c_rlbox_unknown_isName(void *instance, u32 var_0, u32 var_1) {
  return w2c_rlbox_unknown_isName(instance, var_0, var_1);
}
static u32 wrap_w2c_rlbox_unknown_toUtf16(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4) {
  return w2c_rlbox_unknown_toUtf16(instance, var_0, var_1, var_2, var_3, var_4);
}
static u32 wrap_w2c_rlbox_unknown_toUtf8(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4) {
  return w2c_rlbox_unknown_toUtf8(instance, var_0, var_1, var_2, var_3, var_4);
}
static u32 wrap_w2c_rlbox_XmlInitEncoding_0(void *instance, u32 var_0, u32 var_1, u32 var_2) {
  return w2c_rlbox_XmlInitEncoding_0(instance, var_0, var_1, var_2);
}
static void wrap_w2c_rlbox_initUpdatePosition(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_initUpdatePosition(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_initScanContent(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_initScanContent(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_initScanProlog(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_initScanProlog(instance, var_0, var_1, var_2, var_3);
}
static void wrap_w2c_rlbox_normal_updatePosition(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_normal_updatePosition(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_XmlParseXmlDecl_0(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4, u32 var_5, u32 var_6, u32 var_7, 
    u32 var_8, u32 var_9) {
  return w2c_rlbox_XmlParseXmlDecl_0(instance, var_0, var_1, var_2, var_3, var_4, var_5, var_6, var_7, 
      var_8, var_9);
}
static u32 wrap_w2c_rlbox_findEncoding(void *instance, u32 var_0, u32 var_1, u32 var_2) {
  return w2c_rlbox_findEncoding(instance, var_0, var_1, var_2);
}
static u32 wrap_w2c_rlbox_XmlInitEncodingNS_0(void *instance, u32 var_0, u32 var_1, u32 var_2) {
  return w2c_rlbox_XmlInitEncodingNS_0(instance, var_0, var_1, var_2);
}
static u32 wrap_w2c_rlbox_initScanContentNS(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_initScanContentNS(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_initScanPrologNS(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_initScanPrologNS(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_XmlParseXmlDeclNS_0(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4, u32 var_5, u32 var_6, u32 var_7, 
    u32 var_8, u32 var_9) {
  return w2c_rlbox_XmlParseXmlDeclNS_0(instance, var_0, var_1, var_2, var_3, var_4, var_5, var_6, var_7, 
      var_8, var_9);
}
static u32 wrap_w2c_rlbox_findEncodingNS(void *instance, u32 var_0, u32 var_1, u32 var_2) {
  return w2c_rlbox_findEncodingNS(instance, var_0, var_1, var_2);
}
static u32 wrap_w2c_rlbox_XmlInitUnknownEncodingNS_0(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_XmlInitUnknownEncodingNS_0(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_normal_prologTok(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_normal_prologTok(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_normal_contentTok(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_normal_contentTok(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_normal_cdataSectionTok(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_normal_cdataSectionTok(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_normal_ignoreSectionTok(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_normal_ignoreSectionTok(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_normal_attributeValueTok(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_normal_attributeValueTok(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_normal_entityValueTok(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_normal_entityValueTok(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_normal_nameMatchesAscii(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_normal_nameMatchesAscii(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_normal_nameLength(void *instance, u32 var_0, u32 var_1) {
  return w2c_rlbox_normal_nameLength(instance, var_0, var_1);
}
static u32 wrap_w2c_rlbox_normal_skipS(void *instance, u32 var_0, u32 var_1) {
  return w2c_rlbox_normal_skipS(instance, var_0, var_1);
}
static u32 wrap_w2c_rlbox_normal_getAtts(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_normal_getAtts(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_normal_charRefNumber(void *instance, u32 var_0, u32 var_1) {
  return w2c_rlbox_normal_charRefNumber(instance, var_0, var_1);
}
static u32 wrap_w2c_rlbox_normal_predefinedEntityName(void *instance, u32 var_0, u32 var_1, u32 var_2) {
  return w2c_rlbox_normal_predefinedEntityName(instance, var_0, var_1, var_2);
}
static u32 wrap_w2c_rlbox_normal_isPublicId(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_normal_isPublicId(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_latin1_toUtf8(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4) {
  return w2c_rlbox_latin1_toUtf8(instance, var_0, var_1, var_2, var_3, var_4);
}
static u32 wrap_w2c_rlbox_latin1_toUtf16(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4) {
  return w2c_rlbox_latin1_toUtf16(instance, var_0, var_1, var_2, var_3, var_4);
}
static u32 wrap_w2c_rlbox_utf8_toUtf8(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4) {
  return w2c_rlbox_utf8_toUtf8(instance, var_0, var_1, var_2, var_3, var_4);
}
static u32 wrap_w2c_rlbox_utf8_toUtf16(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4) {
  return w2c_rlbox_utf8_toUtf16(instance, var_0, var_1, var_2, var_3, var_4);
}
static u32 wrap_w2c_rlbox_utf8_isName2(void *instance, u32 var_0, u32 var_1) {
  return w2c_rlbox_utf8_isName2(instance, var_0, var_1);
}
static u32 wrap_w2c_rlbox_utf8_isName3(void *instance, u32 var_0, u32 var_1) {
  return w2c_rlbox_utf8_isName3(instance, var_0, var_1);
}
static u32 wrap_w2c_rlbox_isNever(void *instance, u32 var_0, u32 var_1) {
  return w2c_rlbox_isNever(instance, var_0, var_1);
}
static u32 wrap_w2c_rlbox_utf8_isNmstrt2(void *instance, u32 var_0, u32 var_1) {
  return w2c_rlbox_utf8_isNmstrt2(instance, var_0, var_1);
}
static u32 wrap_w2c_rlbox_utf8_isNmstrt3(void *instance, u32 var_0, u32 var_1) {
  return w2c_rlbox_utf8_isNmstrt3(instance, var_0, var_1);
}
static u32 wrap_w2c_rlbox_utf8_isInvalid2(void *instance, u32 var_0, u32 var_1) {
  return w2c_rlbox_utf8_isInvalid2(instance, var_0, var_1);
}
static u32 wrap_w2c_rlbox_utf8_isInvalid3(void *instance, u32 var_0, u32 var_1) {
  return w2c_rlbox_utf8_isInvalid3(instance, var_0, var_1);
}
static u32 wrap_w2c_rlbox_utf8_isInvalid4(void *instance, u32 var_0, u32 var_1) {
  return w2c_rlbox_utf8_isInvalid4(instance, var_0, var_1);
}
static u32 wrap_w2c_rlbox_little2_prologTok(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_little2_prologTok(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_little2_contentTok(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_little2_contentTok(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_little2_cdataSectionTok(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_little2_cdataSectionTok(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_little2_ignoreSectionTok(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_little2_ignoreSectionTok(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_little2_attributeValueTok(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_little2_attributeValueTok(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_little2_entityValueTok(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_little2_entityValueTok(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_little2_nameMatchesAscii(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_little2_nameMatchesAscii(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_little2_nameLength(void *instance, u32 var_0, u32 var_1) {
  return w2c_rlbox_little2_nameLength(instance, var_0, var_1);
}
static u32 wrap_w2c_rlbox_little2_skipS(void *instance, u32 var_0, u32 var_1) {
  return w2c_rlbox_little2_skipS(instance, var_0, var_1);
}
static u32 wrap_w2c_rlbox_little2_getAtts(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_little2_getAtts(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_little2_charRefNumber(void *instance, u32 var_0, u32 var_1) {
  return w2c_rlbox_little2_charRefNumber(instance, var_0, var_1);
}
static u32 wrap_w2c_rlbox_little2_predefinedEntityName(void *instance, u32 var_0, u32 var_1, u32 var_2) {
  return w2c_rlbox_little2_predefinedEntityName(instance, var_0, var_1, var_2);
}
static void wrap_w2c_rlbox_little2_updatePosition(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_little2_updatePosition(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_little2_isPublicId(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_little2_isPublicId(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_little2_toUtf8(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4) {
  return w2c_rlbox_little2_toUtf8(instance, var_0, var_1, var_2, var_3, var_4);
}
static u32 wrap_w2c_rlbox_little2_toUtf16(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4) {
  return w2c_rlbox_little2_toUtf16(instance, var_0, var_1, var_2, var_3, var_4);
}
static u32 wrap_w2c_rlbox_ascii_toUtf8(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4) {
  return w2c_rlbox_ascii_toUtf8(instance, var_0, var_1, var_2, var_3, var_4);
}
static u32 wrap_w2c_rlbox_big2_prologTok(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_big2_prologTok(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_big2_contentTok(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_big2_contentTok(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_big2_cdataSectionTok(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_big2_cdataSectionTok(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_big2_ignoreSectionTok(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_big2_ignoreSectionTok(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_big2_attributeValueTok(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_big2_attributeValueTok(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_big2_entityValueTok(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_big2_entityValueTok(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_big2_nameMatchesAscii(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_big2_nameMatchesAscii(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_big2_nameLength(void *instance, u32 var_0, u32 var_1) {
  return w2c_rlbox_big2_nameLength(instance, var_0, var_1);
}
static u32 wrap_w2c_rlbox_big2_skipS(void *instance, u32 var_0, u32 var_1) {
  return w2c_rlbox_big2_skipS(instance, var_0, var_1);
}
static u32 wrap_w2c_rlbox_big2_getAtts(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_big2_getAtts(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_big2_charRefNumber(void *instance, u32 var_0, u32 var_1) {
  return w2c_rlbox_big2_charRefNumber(instance, var_0, var_1);
}
static u32 wrap_w2c_rlbox_big2_predefinedEntityName(void *instance, u32 var_0, u32 var_1, u32 var_2) {
  return w2c_rlbox_big2_predefinedEntityName(instance, var_0, var_1, var_2);
}
static void wrap_w2c_rlbox_big2_updatePosition(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_big2_updatePosition(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_big2_isPublicId(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_big2_isPublicId(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_big2_toUtf8(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4) {
  return w2c_rlbox_big2_toUtf8(instance, var_0, var_1, var_2, var_3, var_4);
}
static u32 wrap_w2c_rlbox_big2_toUtf16(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4) {
  return w2c_rlbox_big2_toUtf16(instance, var_0, var_1, var_2, var_3, var_4);
}
static u32 wrap_w2c_rlbox_prolog0(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4) {
  return w2c_rlbox_prolog0(instance, var_0, var_1, var_2, var_3, var_4);
}
static u32 wrap_w2c_rlbox_prolog1(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4) {
  return w2c_rlbox_prolog1(instance, var_0, var_1, var_2, var_3, var_4);
}
static u32 wrap_w2c_rlbox_doctype0(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4) {
  return w2c_rlbox_doctype0(instance, var_0, var_1, var_2, var_3, var_4);
}
static u32 wrap_w2c_rlbox_error(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4) {
  return w2c_rlbox_error(instance, var_0, var_1, var_2, var_3, var_4);
}
static u32 wrap_w2c_rlbox_externalSubset0(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4) {
  return w2c_rlbox_externalSubset0(instance, var_0, var_1, var_2, var_3, var_4);
}
static u32 wrap_w2c_rlbox_externalSubset1(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4) {
  return w2c_rlbox_externalSubset1(instance, var_0, var_1, var_2, var_3, var_4);
}
static u32 wrap_w2c_rlbox_doctype1(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4) {
  return w2c_rlbox_doctype1(instance, var_0, var_1, var_2, var_3, var_4);
}
static u32 wrap_w2c_rlbox_internalSubset(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4) {
  return w2c_rlbox_internalSubset(instance, var_0, var_1, var_2, var_3, var_4);
}
static u32 wrap_w2c_rlbox_prolog2(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4) {
  return w2c_rlbox_prolog2(instance, var_0, var_1, var_2, var_3, var_4);
}
static u32 wrap_w2c_rlbox_doctype3(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4) {
  return w2c_rlbox_doctype3(instance, var_0, var_1, var_2, var_3, var_4);
}
static u32 wrap_w2c_rlbox_doctype2(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4) {
  return w2c_rlbox_doctype2(instance, var_0, var_1, var_2, var_3, var_4);
}
static u32 wrap_w2c_rlbox_entity0(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4) {
  return w2c_rlbox_entity0(instance, var_0, var_1, var_2, var_3, var_4);
}
static u32 wrap_w2c_rlbox_attlist0(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4) {
  return w2c_rlbox_attlist0(instance, var_0, var_1, var_2, var_3, var_4);
}
static u32 wrap_w2c_rlbox_element0(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4) {
  return w2c_rlbox_element0(instance, var_0, var_1, var_2, var_3, var_4);
}
static u32 wrap_w2c_rlbox_notation0(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4) {
  return w2c_rlbox_notation0(instance, var_0, var_1, var_2, var_3, var_4);
}
static u32 wrap_w2c_rlbox_doctype5(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4) {
  return w2c_rlbox_doctype5(instance, var_0, var_1, var_2, var_3, var_4);
}
static u32 wrap_w2c_rlbox_doctype4(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4) {
  return w2c_rlbox_doctype4(instance, var_0, var_1, var_2, var_3, var_4);
}
static u32 wrap_w2c_rlbox_entity1(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4) {
  return w2c_rlbox_entity1(instance, var_0, var_1, var_2, var_3, var_4);
}
static u32 wrap_w2c_rlbox_entity2(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4) {
  return w2c_rlbox_entity2(instance, var_0, var_1, var_2, var_3, var_4);
}
static u32 wrap_w2c_rlbox_attlist1(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4) {
  return w2c_rlbox_attlist1(instance, var_0, var_1, var_2, var_3, var_4);
}
static u32 wrap_w2c_rlbox_element1(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4) {
  return w2c_rlbox_element1(instance, var_0, var_1, var_2, var_3, var_4);
}
static u32 wrap_w2c_rlbox_notation1(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4) {
  return w2c_rlbox_notation1(instance, var_0, var_1, var_2, var_3, var_4);
}
static u32 wrap_w2c_rlbox_entity7(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4) {
  return w2c_rlbox_entity7(instance, var_0, var_1, var_2, var_3, var_4);
}
static u32 wrap_w2c_rlbox_entity4(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4) {
  return w2c_rlbox_entity4(instance, var_0, var_1, var_2, var_3, var_4);
}
static u32 wrap_w2c_rlbox_entity3(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4) {
  return w2c_rlbox_entity3(instance, var_0, var_1, var_2, var_3, var_4);
}
static u32 wrap_w2c_rlbox_declClose(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4) {
  return w2c_rlbox_declClose(instance, var_0, var_1, var_2, var_3, var_4);
}
static u32 wrap_w2c_rlbox_entity9(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4) {
  return w2c_rlbox_entity9(instance, var_0, var_1, var_2, var_3, var_4);
}
static u32 wrap_w2c_rlbox_entity8(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4) {
  return w2c_rlbox_entity8(instance, var_0, var_1, var_2, var_3, var_4);
}
static u32 wrap_w2c_rlbox_entity10(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4) {
  return w2c_rlbox_entity10(instance, var_0, var_1, var_2, var_3, var_4);
}
static u32 wrap_w2c_rlbox_condSect0(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4) {
  return w2c_rlbox_condSect0(instance, var_0, var_1, var_2, var_3, var_4);
}
static u32 wrap_w2c_rlbox_condSect1(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4) {
  return w2c_rlbox_condSect1(instance, var_0, var_1, var_2, var_3, var_4);
}
static u32 wrap_w2c_rlbox_condSect2(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4) {
  return w2c_rlbox_condSect2(instance, var_0, var_1, var_2, var_3, var_4);
}
static u32 wrap_w2c_rlbox_entity5(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4) {
  return w2c_rlbox_entity5(instance, var_0, var_1, var_2, var_3, var_4);
}
static u32 wrap_w2c_rlbox_entity6(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4) {
  return w2c_rlbox_entity6(instance, var_0, var_1, var_2, var_3, var_4);
}
static u32 wrap_w2c_rlbox_attlist2(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4) {
  return w2c_rlbox_attlist2(instance, var_0, var_1, var_2, var_3, var_4);
}
static u32 wrap_w2c_rlbox_attlist5(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4) {
  return w2c_rlbox_attlist5(instance, var_0, var_1, var_2, var_3, var_4);
}
static u32 wrap_w2c_rlbox_attlist8(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4) {
  return w2c_rlbox_attlist8(instance, var_0, var_1, var_2, var_3, var_4);
}
static u32 wrap_w2c_rlbox_attlist3(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4) {
  return w2c_rlbox_attlist3(instance, var_0, var_1, var_2, var_3, var_4);
}
static u32 wrap_w2c_rlbox_attlist9(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4) {
  return w2c_rlbox_attlist9(instance, var_0, var_1, var_2, var_3, var_4);
}
static u32 wrap_w2c_rlbox_attlist6(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4) {
  return w2c_rlbox_attlist6(instance, var_0, var_1, var_2, var_3, var_4);
}
static u32 wrap_w2c_rlbox_attlist4(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4) {
  return w2c_rlbox_attlist4(instance, var_0, var_1, var_2, var_3, var_4);
}
static u32 wrap_w2c_rlbox_attlist7(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4) {
  return w2c_rlbox_attlist7(instance, var_0, var_1, var_2, var_3, var_4);
}
static u32 wrap_w2c_rlbox_element2(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4) {
  return w2c_rlbox_element2(instance, var_0, var_1, var_2, var_3, var_4);
}
static u32 wrap_w2c_rlbox_element7(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4) {
  return w2c_rlbox_element7(instance, var_0, var_1, var_2, var_3, var_4);
}
static u32 wrap_w2c_rlbox_element3(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4) {
  return w2c_rlbox_element3(instance, var_0, var_1, var_2, var_3, var_4);
}
static u32 wrap_w2c_rlbox_element6(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4) {
  return w2c_rlbox_element6(instance, var_0, var_1, var_2, var_3, var_4);
}
static u32 wrap_w2c_rlbox_element4(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4) {
  return w2c_rlbox_element4(instance, var_0, var_1, var_2, var_3, var_4);
}
static u32 wrap_w2c_rlbox_element5(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4) {
  return w2c_rlbox_element5(instance, var_0, var_1, var_2, var_3, var_4);
}
static u32 wrap_w2c_rlbox_notation3(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4) {
  return w2c_rlbox_notation3(instance, var_0, var_1, var_2, var_3, var_4);
}
static u32 wrap_w2c_rlbox_notation2(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4) {
  return w2c_rlbox_notation2(instance, var_0, var_1, var_2, var_3, var_4);
}
static u32 wrap_w2c_rlbox_notation4(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4) {
  return w2c_rlbox_notation4(instance, var_0, var_1, var_2, var_3, var_4);
}
static void wrap_w2c_rlbox_AffEntry0x3A0x3A0x7EAffEntry0x280x29(void *instance, u32 var_0) {
  return w2c_rlbox_AffEntry0x3A0x3A0x7EAffEntry0x280x29(instance, var_0);
}
static u32 wrap_w2c_rlbox_AffEntry0x3A0x3A0x7EAffEntry0x280x290x2E1(void *instance, u32 var_0) {
  return w2c_rlbox_AffEntry0x3A0x3A0x7EAffEntry0x280x290x2E1(instance, var_0);
}
static void wrap_w2c_rlbox_PfxEntry0x3A0x3A0x7EPfxEntry0x280x29(void *instance, u32 var_0) {
  return w2c_rlbox_PfxEntry0x3A0x3A0x7EPfxEntry0x280x29(instance, var_0);
}
static u32 wrap_w2c_rlbox_SfxEntry0x3A0x3A0x7ESfxEntry0x280x29(void *instance, u32 var_0) {
  return w2c_rlbox_SfxEntry0x3A0x3A0x7ESfxEntry0x280x29(instance, var_0);
}
static void wrap_w2c_rlbox_SfxEntry0x3A0x3A0x7ESfxEntry0x280x290x2E1(void *instance, u32 var_0) {
  return w2c_rlbox_SfxEntry0x3A0x3A0x7ESfxEntry0x280x290x2E1(instance, var_0);
}
static u32 wrap_w2c_rlbox_graphite20x3A0x3ACachedCmap0x3A0x3A0x7ECachedCmap0x280x29(void *instance, u32 var_0) {
  return w2c_rlbox_graphite20x3A0x3ACachedCmap0x3A0x3A0x7ECachedCmap0x280x29(instance, var_0);
}
static void wrap_w2c_rlbox_graphite20x3A0x3ACachedCmap0x3A0x3A0x7ECachedCmap0x280x290x2E1(void *instance, u32 var_0) {
  return w2c_rlbox_graphite20x3A0x3ACachedCmap0x3A0x3A0x7ECachedCmap0x280x290x2E1(instance, var_0);
}
static u32 wrap_w2c_rlbox_graphite20x3A0x3ACachedCmap0x3A0x3Aoperator0x5B0x5D0x28unsigned0x20int0x290x20const(void *instance, u32 var_0, u32 var_1) {
  return w2c_rlbox_graphite20x3A0x3ACachedCmap0x3A0x3Aoperator0x5B0x5D0x28unsigned0x20int0x290x20const(instance, var_0, var_1);
}
static u32 wrap_w2c_rlbox_graphite20x3A0x3ACachedCmap0x3A0x3Aoperator0x20bool0x280x290x20const(void *instance, u32 var_0) {
  return w2c_rlbox_graphite20x3A0x3ACachedCmap0x3A0x3Aoperator0x20bool0x280x290x20const(instance, var_0);
}
static u32 wrap_w2c_rlbox_graphite20x3A0x3ADirectCmap0x3A0x3Aoperator0x5B0x5D0x28unsigned0x20int0x290x20const(void *instance, u32 var_0, u32 var_1) {
  return w2c_rlbox_graphite20x3A0x3ADirectCmap0x3A0x3Aoperator0x5B0x5D0x28unsigned0x20int0x290x20const(instance, var_0, var_1);
}
static u32 wrap_w2c_rlbox_graphite20x3A0x3ADirectCmap0x3A0x3Aoperator0x20bool0x280x290x20const(void *instance, u32 var_0) {
  return w2c_rlbox_graphite20x3A0x3ADirectCmap0x3A0x3Aoperator0x20bool0x280x290x20const(instance, var_0);
}
static u32 wrap_w2c_rlbox_graphite20x3A0x3ADirectCmap0x3A0x3A0x7EDirectCmap0x280x29(void *instance, u32 var_0) {
  return w2c_rlbox_graphite20x3A0x3ADirectCmap0x3A0x3A0x7EDirectCmap0x280x29(instance, var_0);
}
static void wrap_w2c_rlbox_graphite20x3A0x3ADirectCmap0x3A0x3A0x7EDirectCmap0x280x290x2E1(void *instance, u32 var_0) {
  return w2c_rlbox_graphite20x3A0x3ADirectCmap0x3A0x3A0x7EDirectCmap0x280x290x2E1(instance, var_0);
}
static u32 wrap_w2c_rlbox_graphite20x3A0x3AFace0x3A0x3A0x7EFace0x280x29(void *instance, u32 var_0) {
  return w2c_rlbox_graphite20x3A0x3AFace0x3A0x3A0x7EFace0x280x29(instance, var_0);
}
static void wrap_w2c_rlbox_graphite20x3A0x3AFace0x3A0x3A0x7EFace0x280x290x2E1(void *instance, u32 var_0) {
  return w2c_rlbox_graphite20x3A0x3AFace0x3A0x3A0x7EFace0x280x290x2E1(instance, var_0);
}
static f32 wrap_w2c_rlbox_graphite20x3A0x3AFace0x3A0x3Adefault_glyph_advance0x28void0x20const0x2A0x2C0x20unsigned0x20short0x29(void *instance, u32 var_0, u32 var_1) {
  return w2c_rlbox_graphite20x3A0x3AFace0x3A0x3Adefault_glyph_advance0x28void0x20const0x2A0x2C0x20unsigned0x20short0x29(instance, var_0, var_1);
}
static u32 wrap_w2c_rlbox_graphite20x3A0x3AFace0x3A0x3ArunGraphite0x28graphite20x3A0x3ASegment0x2A0x2C0x20graphite20x3A0x3ASilf0x20const0x2A0x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2) {
  return w2c_rlbox_graphite20x3A0x3AFace0x3A0x3ArunGraphite0x28graphite20x3A0x3ASegment0x2A0x2C0x20graphite20x3A0x3ASilf0x20const0x2A0x290x20const(instance, var_0, var_1, var_2);
}
static u32 wrap_w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3AcmpNameAndFeatures0x28void0x20const0x2A0x2C0x20void0x20const0x2A0x29(void *instance, u32 var_0, u32 var_1) {
  return w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3AcmpNameAndFeatures0x28void0x20const0x2A0x2C0x20void0x20const0x2A0x29(instance, var_0, var_1);
}
static u32 wrap_w2c_rlbox_graphite20x3A0x3AFont0x3A0x3A0x7EFont0x280x29(void *instance, u32 var_0) {
  return w2c_rlbox_graphite20x3A0x3AFont0x3A0x3A0x7EFont0x280x29(instance, var_0);
}
static void wrap_w2c_rlbox_graphite20x3A0x3AFont0x3A0x3A0x7EFont0x280x290x2E1(void *instance, u32 var_0) {
  return w2c_rlbox_graphite20x3A0x3AFont0x3A0x3A0x7EFont0x280x290x2E1(instance, var_0);
}
static u32 wrap_w2c_rlbox_cmpRuleEntry0x28void0x20const0x2A0x2C0x20void0x20const0x2A0x29(void *instance, u32 var_0, u32 var_1) {
  return w2c_rlbox_cmpRuleEntry0x28void0x20const0x2A0x2C0x20void0x20const0x2A0x29(instance, var_0, var_1);
}
static u32 wrap_w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Anop0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Anop0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Apush_byte0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Apush_byte0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Apush_byte_u0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Apush_byte_u0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Apush_short0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Apush_short0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Apush_short_u0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Apush_short_u0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Apush_long0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Apush_long0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Aadd0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Aadd0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Asub0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Asub0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Amul0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Amul0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Adiv_0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Adiv_0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Amin_0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Amin_0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Amax_0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Amax_0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Aneg0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Aneg0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Atrunc80x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Atrunc80x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Atrunc160x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Atrunc160x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Acond0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Acond0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Aand_0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Aand_0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Aor_0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Aor_0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Anot_0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Anot_0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Aequal0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Aequal0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Anot_eq_0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Anot_eq_0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Aless0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Aless0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Agtr0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Agtr0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Aless_eq0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Aless_eq0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Agtr_eq0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Agtr_eq0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Anext0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Anext0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Aput_glyph_8bit_obs0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Aput_glyph_8bit_obs0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Aput_subs_8bit_obs0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Aput_subs_8bit_obs0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Aput_copy0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Aput_copy0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Ainsert0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Ainsert0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Adelete_0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Adelete_0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Aassoc0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Aassoc0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Acntxt_item0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Acntxt_item0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Aattr_set0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Aattr_set0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Aattr_add0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Aattr_add0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Aattr_sub0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Aattr_sub0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Aattr_set_slot0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Aattr_set_slot0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Aiattr_set_slot0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Aiattr_set_slot0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Apush_slot_attr0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Apush_slot_attr0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Apush_glyph_attr_obs0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Apush_glyph_attr_obs0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Apush_glyph_metric0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Apush_glyph_metric0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Apush_feat0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Apush_feat0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Apush_att_to_gattr_obs0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Apush_att_to_gattr_obs0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Apush_att_to_glyph_metric0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Apush_att_to_glyph_metric0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Apush_islot_attr0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Apush_islot_attr0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Apop_ret0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Apop_ret0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Aret_zero0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Aret_zero0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Aret_true0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Aret_true0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Aiattr_set0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Aiattr_set0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Aiattr_add0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Aiattr_add0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Aiattr_sub0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Aiattr_sub0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Apush_proc_state0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Apush_proc_state0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Apush_version0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Apush_version0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Aput_subs0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Aput_subs0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Aput_glyph0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Aput_glyph0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Apush_glyph_attr0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Apush_glyph_attr0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Apush_att_to_glyph_attr0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Apush_att_to_glyph_attr0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Abor0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Abor0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Aband0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Aband0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Abnot0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Abnot0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Asetbits0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Asetbits0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Aset_feat0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Aset_feat0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Atemp_copy0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_0x28anonymous0x20namespace0x290x3A0x3Atemp_copy0x28unsigned0x20char0x20const0x2A0x260x2C0x20int0x2A0x260x2C0x20int0x2A0x2C0x20regbank0x260x29(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_woff20x3A0x3AWOFF2StringOut0x3A0x3AWrite0x28void0x20const0x2A0x2C0x20unsigned0x20long0x29(void *instance, u32 var_0, u32 var_1, u32 var_2) {
  return w2c_rlbox_woff20x3A0x3AWOFF2StringOut0x3A0x3AWrite0x28void0x20const0x2A0x2C0x20unsigned0x20long0x29(instance, var_0, var_1, var_2);
}
static u32 wrap_w2c_rlbox_woff20x3A0x3AWOFF2StringOut0x3A0x3AWrite0x28void0x20const0x2A0x2C0x20unsigned0x20long0x2C0x20unsigned0x20long0x29(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_woff20x3A0x3AWOFF2StringOut0x3A0x3AWrite0x28void0x20const0x2A0x2C0x20unsigned0x20long0x2C0x20unsigned0x20long0x29(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_woff20x3A0x3AWOFF2MemoryOut0x3A0x3AWrite0x28void0x20const0x2A0x2C0x20unsigned0x20long0x29(void *instance, u32 var_0, u32 var_1, u32 var_2) {
  return w2c_rlbox_woff20x3A0x3AWOFF2MemoryOut0x3A0x3AWrite0x28void0x20const0x2A0x2C0x20unsigned0x20long0x29(instance, var_0, var_1, var_2);
}
static u32 wrap_w2c_rlbox_woff20x3A0x3AWOFF2MemoryOut0x3A0x3AWrite0x28void0x20const0x2A0x2C0x20unsigned0x20long0x2C0x20unsigned0x20long0x29(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_woff20x3A0x3AWOFF2MemoryOut0x3A0x3AWrite0x28void0x20const0x2A0x2C0x20unsigned0x20long0x2C0x20unsigned0x20long0x29(instance, var_0, var_1, var_2, var_3);
}
static void wrap_w2c_rlbox_woff20x3A0x3AWOFF2StringOut0x3A0x3A0x7EWOFF2StringOut0x280x29(void *instance, u32 var_0) {
  return w2c_rlbox_woff20x3A0x3AWOFF2StringOut0x3A0x3A0x7EWOFF2StringOut0x280x29(instance, var_0);
}
static u32 wrap_w2c_rlbox_woff20x3A0x3AWOFF2StringOut0x3A0x3ASize0x280x29(void *instance, u32 var_0) {
  return w2c_rlbox_woff20x3A0x3AWOFF2StringOut0x3A0x3ASize0x280x29(instance, var_0);
}
static u32 wrap_w2c_rlbox_woff20x3A0x3AWOFF2Out0x3A0x3A0x7EWOFF2Out0x280x29(void *instance, u32 var_0) {
  return w2c_rlbox_woff20x3A0x3AWOFF2Out0x3A0x3A0x7EWOFF2Out0x280x29(instance, var_0);
}
static void wrap_w2c_rlbox_woff20x3A0x3AWOFF2MemoryOut0x3A0x3A0x7EWOFF2MemoryOut0x280x29(void *instance, u32 var_0) {
  return w2c_rlbox_woff20x3A0x3AWOFF2MemoryOut0x3A0x3A0x7EWOFF2MemoryOut0x280x29(instance, var_0);
}
static u32 wrap_w2c_rlbox_woff20x3A0x3AWOFF2MemoryOut0x3A0x3ASize0x280x29(void *instance, u32 var_0) {
  return w2c_rlbox_woff20x3A0x3AWOFF2MemoryOut0x3A0x3ASize0x280x29(instance, var_0);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Aerror_category0x3A0x3A0x7Eerror_category0x280x29(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Aerror_category0x3A0x3A0x7Eerror_category0x280x29(instance, var_0);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Aerror_category0x3A0x3A0x7Eerror_category0x280x290x2E1(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Aerror_category0x3A0x3A0x7Eerror_category0x280x290x2E1(instance, var_0);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Aerror_category0x3A0x3Adefault_error_condition0x28int0x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Aerror_category0x3A0x3Adefault_error_condition0x28int0x290x20const(instance, var_0, var_1, var_2);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Aerror_category0x3A0x3Aequivalent0x28int0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aerror_condition0x20const0x260x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Aerror_category0x3A0x3Aequivalent0x28int0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aerror_condition0x20const0x260x290x20const(instance, var_0, var_1, var_2);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Aerror_category0x3A0x3Aequivalent0x28std0x3A0x3A_0x5F20x3A0x3Aerror_code0x20const0x260x2C0x20int0x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Aerror_category0x3A0x3Aequivalent0x28std0x3A0x3A_0x5F20x3A0x3Aerror_code0x20const0x260x2C0x20int0x290x20const(instance, var_0, var_1, var_2);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fdo_message0x3A0x3Amessage0x28int0x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fdo_message0x3A0x3Amessage0x28int0x290x20const(instance, var_0, var_1, var_2);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fgeneric_error_category0x3A0x3Aname0x280x290x20const(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fgeneric_error_category0x3A0x3Aname0x280x290x20const(instance, var_0);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fgeneric_error_category0x3A0x3Amessage0x28int0x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fgeneric_error_category0x3A0x3Amessage0x28int0x290x20const(instance, var_0, var_1, var_2);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fsystem_error_category0x3A0x3Aname0x280x290x20const(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fsystem_error_category0x3A0x3Aname0x280x290x20const(instance, var_0);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fsystem_error_category0x3A0x3Amessage0x28int0x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fsystem_error_category0x3A0x3Amessage0x28int0x290x20const(instance, var_0, var_1, var_2);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fsystem_error_category0x3A0x3Adefault_error_condition0x28int0x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fsystem_error_category0x3A0x3Adefault_error_condition0x28int0x290x20const(instance, var_0, var_1, var_2);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Asystem_error0x3A0x3A0x7Esystem_error0x280x29(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Asystem_error0x3A0x3A0x7Esystem_error0x280x29(instance, var_0);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Asystem_error0x3A0x3A0x7Esystem_error0x280x290x2E1(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Asystem_error0x3A0x3A0x7Esystem_error0x280x290x2E1(instance, var_0);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fdo_message0x3A0x3A0x7E_0x5Fdo_message0x280x29(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fdo_message0x3A0x3A0x7E_0x5Fdo_message0x280x29(instance, var_0);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fgeneric_error_category0x3A0x3A0x7E_0x5Fgeneric_error_category0x280x29(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fgeneric_error_category0x3A0x3A0x7E_0x5Fgeneric_error_category0x280x29(instance, var_0);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fsystem_error_category0x3A0x3A0x7E_0x5Fsystem_error_category0x280x29(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fsystem_error_category0x3A0x3A0x7E_0x5Fsystem_error_category0x280x29(instance, var_0);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fiostream_category0x3A0x3Aname0x280x290x20const(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fiostream_category0x3A0x3Aname0x280x290x20const(instance, var_0);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fiostream_category0x3A0x3Amessage0x28int0x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fiostream_category0x3A0x3Amessage0x28int0x290x20const(instance, var_0, var_1, var_2);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Aios_base0x3A0x3Afailure0x3A0x3A0x7Efailure0x280x29(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Aios_base0x3A0x3Afailure0x3A0x3A0x7Efailure0x280x29(instance, var_0);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Aios_base0x3A0x3Afailure0x3A0x3A0x7Efailure0x280x290x2E1(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Aios_base0x3A0x3Afailure0x3A0x3A0x7Efailure0x280x290x2E1(instance, var_0);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Aios_base0x3A0x3A0x7Eios_base0x280x29(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Aios_base0x3A0x3A0x7Eios_base0x280x29(instance, var_0);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Aios_base0x3A0x3A0x7Eios_base0x280x290x2E1(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Aios_base0x3A0x3A0x7Eios_base0x280x290x2E1(instance, var_0);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fiostream_category0x3A0x3A0x7E_0x5Fiostream_category0x280x29(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fiostream_category0x3A0x3A0x7E_0x5Fiostream_category0x280x29(instance, var_0);
}
static u32 wrap_w2c_rlbox_std0x3A0x3Anested_exception0x3A0x3A0x7Enested_exception0x280x29(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3Anested_exception0x3A0x3A0x7Enested_exception0x280x29(instance, var_0);
}
static void wrap_w2c_rlbox_std0x3A0x3Anested_exception0x3A0x3A0x7Enested_exception0x280x290x2E1(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3Anested_exception0x3A0x3A0x7Enested_exception0x280x290x2E1(instance, var_0);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_ios0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_ios0x280x29(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_ios0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_ios0x280x29(instance, var_0);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_ios0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_ios0x280x290x2E1(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_ios0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_ios0x280x290x2E1(instance, var_0);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_streambuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_streambuf0x280x29(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_streambuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_streambuf0x280x29(instance, var_0);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_streambuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_streambuf0x280x290x2E1(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_streambuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_streambuf0x280x290x2E1(instance, var_0);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_streambuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Aimbue0x28std0x3A0x3A_0x5F20x3A0x3Alocale0x20const0x260x29(void *instance, u32 var_0, u32 var_1) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_streambuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Aimbue0x28std0x3A0x3A_0x5F20x3A0x3Alocale0x20const0x260x29(instance, var_0, var_1);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_streambuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Asetbuf0x28char0x2A0x2C0x20long0x29(void *instance, u32 var_0, u32 var_1, u32 var_2) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_streambuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Asetbuf0x28char0x2A0x2C0x20long0x29(instance, var_0, var_1, var_2);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_streambuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Aseekoff0x28long0x20long0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x3A0x3Aseekdir0x2C0x20unsigned0x20int0x29(void *instance, u32 var_0, u32 var_1, u64 var_2, u32 var_3, u32 var_4) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_streambuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Aseekoff0x28long0x20long0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x3A0x3Aseekdir0x2C0x20unsigned0x20int0x29(instance, var_0, var_1, var_2, var_3, var_4);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_streambuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Aseekpos0x28std0x3A0x3A_0x5F20x3A0x3Afpos0x3C_0x5Fmbstate_t0x3E0x2C0x20unsigned0x20int0x29(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_streambuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Aseekpos0x28std0x3A0x3A_0x5F20x3A0x3Afpos0x3C_0x5Fmbstate_t0x3E0x2C0x20unsigned0x20int0x29(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_streambuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Async0x280x29(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_streambuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Async0x280x29(instance, var_0);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_streambuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Ashowmanyc0x280x29(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_streambuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Ashowmanyc0x280x29(instance, var_0);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_streambuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Axsgetn0x28char0x2A0x2C0x20long0x29(void *instance, u32 var_0, u32 var_1, u32 var_2) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_streambuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Axsgetn0x28char0x2A0x2C0x20long0x29(instance, var_0, var_1, var_2);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_streambuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Aunderflow0x280x29(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_streambuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Aunderflow0x280x29(instance, var_0);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_streambuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Auflow0x280x29(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_streambuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Auflow0x280x29(instance, var_0);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_streambuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Apbackfail0x28int0x29(void *instance, u32 var_0, u32 var_1) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_streambuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Apbackfail0x28int0x29(instance, var_0, var_1);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_streambuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Axsputn0x28char0x20const0x2A0x2C0x20long0x29(void *instance, u32 var_0, u32 var_1, u32 var_2) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_streambuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Axsputn0x28char0x20const0x2A0x2C0x20long0x29(instance, var_0, var_1, var_2);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_streambuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Aoverflow0x28int0x29(void *instance, u32 var_0, u32 var_1) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_streambuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Aoverflow0x28int0x29(instance, var_0, var_1);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_istream0x280x290x2E1(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_istream0x280x290x2E1(instance, var_0);
}
static u32 wrap_w2c_rlbox_virtual0x20thunk0x20to0x20std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_istream0x280x29(void *instance, u32 var_0) {
  return w2c_rlbox_virtual0x20thunk0x20to0x20std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_istream0x280x29(instance, var_0);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_istream0x280x290x2E2(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_istream0x280x290x2E2(instance, var_0);
}
static void wrap_w2c_rlbox_virtual0x20thunk0x20to0x20std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_istream0x280x290x2E1(void *instance, u32 var_0) {
  return w2c_rlbox_virtual0x20thunk0x20to0x20std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_istream0x280x290x2E1(instance, var_0);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_ostream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_ostream0x280x290x2E1(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_ostream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_ostream0x280x290x2E1(instance, var_0);
}
static u32 wrap_w2c_rlbox_virtual0x20thunk0x20to0x20std0x3A0x3A_0x5F20x3A0x3Abasic_ostream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_ostream0x280x29(void *instance, u32 var_0) {
  return w2c_rlbox_virtual0x20thunk0x20to0x20std0x3A0x3A_0x5F20x3A0x3Abasic_ostream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_ostream0x280x29(instance, var_0);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_ostream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_ostream0x280x290x2E2(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_ostream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_ostream0x280x290x2E2(instance, var_0);
}
static void wrap_w2c_rlbox_virtual0x20thunk0x20to0x20std0x3A0x3A_0x5F20x3A0x3Abasic_ostream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_ostream0x280x290x2E1(void *instance, u32 var_0) {
  return w2c_rlbox_virtual0x20thunk0x20to0x20std0x3A0x3A_0x5F20x3A0x3Abasic_ostream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_ostream0x280x290x2E1(instance, var_0);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_iostream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_iostream0x280x290x2E1(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_iostream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_iostream0x280x290x2E1(instance, var_0);
}
static u32 wrap_w2c_rlbox_non0x2Dvirtual0x20thunk0x20to0x20std0x3A0x3A_0x5F20x3A0x3Abasic_iostream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_iostream0x280x29(void *instance, u32 var_0) {
  return w2c_rlbox_non0x2Dvirtual0x20thunk0x20to0x20std0x3A0x3A_0x5F20x3A0x3Abasic_iostream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_iostream0x280x29(instance, var_0);
}
static u32 wrap_w2c_rlbox_virtual0x20thunk0x20to0x20std0x3A0x3A_0x5F20x3A0x3Abasic_iostream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_iostream0x280x29(void *instance, u32 var_0) {
  return w2c_rlbox_virtual0x20thunk0x20to0x20std0x3A0x3A_0x5F20x3A0x3Abasic_iostream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_iostream0x280x29(instance, var_0);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_iostream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_iostream0x280x290x2E2(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_iostream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_iostream0x280x290x2E2(instance, var_0);
}
static void wrap_w2c_rlbox_non0x2Dvirtual0x20thunk0x20to0x20std0x3A0x3A_0x5F20x3A0x3Abasic_iostream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_iostream0x280x290x2E1(void *instance, u32 var_0) {
  return w2c_rlbox_non0x2Dvirtual0x20thunk0x20to0x20std0x3A0x3A_0x5F20x3A0x3Abasic_iostream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_iostream0x280x290x2E1(instance, var_0);
}
static void wrap_w2c_rlbox_virtual0x20thunk0x20to0x20std0x3A0x3A_0x5F20x3A0x3Abasic_iostream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_iostream0x280x290x2E1(void *instance, u32 var_0) {
  return w2c_rlbox_virtual0x20thunk0x20to0x20std0x3A0x3A_0x5F20x3A0x3Abasic_iostream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_iostream0x280x290x2E1(instance, var_0);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_ios0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3A0x7Ebasic_ios0x280x29(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_ios0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3A0x7Ebasic_ios0x280x29(instance, var_0);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_ios0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3A0x7Ebasic_ios0x280x290x2E1(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_ios0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3A0x7Ebasic_ios0x280x290x2E1(instance, var_0);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_streambuf0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3A0x7Ebasic_streambuf0x280x29(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_streambuf0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3A0x7Ebasic_streambuf0x280x29(instance, var_0);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_streambuf0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3A0x7Ebasic_streambuf0x280x290x2E1(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_streambuf0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3A0x7Ebasic_streambuf0x280x290x2E1(instance, var_0);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_streambuf0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3Aimbue0x28std0x3A0x3A_0x5F20x3A0x3Alocale0x20const0x260x29(void *instance, u32 var_0, u32 var_1) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_streambuf0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3Aimbue0x28std0x3A0x3A_0x5F20x3A0x3Alocale0x20const0x260x29(instance, var_0, var_1);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_streambuf0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3Asetbuf0x28wchar_t0x2A0x2C0x20long0x29(void *instance, u32 var_0, u32 var_1, u32 var_2) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_streambuf0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3Asetbuf0x28wchar_t0x2A0x2C0x20long0x29(instance, var_0, var_1, var_2);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_streambuf0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3Aseekoff0x28long0x20long0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x3A0x3Aseekdir0x2C0x20unsigned0x20int0x29(void *instance, u32 var_0, u32 var_1, u64 var_2, u32 var_3, u32 var_4) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_streambuf0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3Aseekoff0x28long0x20long0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x3A0x3Aseekdir0x2C0x20unsigned0x20int0x29(instance, var_0, var_1, var_2, var_3, var_4);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_streambuf0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3Aseekpos0x28std0x3A0x3A_0x5F20x3A0x3Afpos0x3C_0x5Fmbstate_t0x3E0x2C0x20unsigned0x20int0x29(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_streambuf0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3Aseekpos0x28std0x3A0x3A_0x5F20x3A0x3Afpos0x3C_0x5Fmbstate_t0x3E0x2C0x20unsigned0x20int0x29(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_streambuf0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3Async0x280x29(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_streambuf0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3Async0x280x29(instance, var_0);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_streambuf0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3Ashowmanyc0x280x29(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_streambuf0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3Ashowmanyc0x280x29(instance, var_0);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_streambuf0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3Axsgetn0x28wchar_t0x2A0x2C0x20long0x29(void *instance, u32 var_0, u32 var_1, u32 var_2) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_streambuf0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3Axsgetn0x28wchar_t0x2A0x2C0x20long0x29(instance, var_0, var_1, var_2);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_streambuf0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3Aunderflow0x280x29(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_streambuf0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3Aunderflow0x280x29(instance, var_0);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_streambuf0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3Auflow0x280x29(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_streambuf0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3Auflow0x280x29(instance, var_0);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_streambuf0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3Apbackfail0x28int0x29(void *instance, u32 var_0, u32 var_1) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_streambuf0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3Apbackfail0x28int0x29(instance, var_0, var_1);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_streambuf0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3Axsputn0x28wchar_t0x20const0x2A0x2C0x20long0x29(void *instance, u32 var_0, u32 var_1, u32 var_2) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_streambuf0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3Axsputn0x28wchar_t0x20const0x2A0x2C0x20long0x29(instance, var_0, var_1, var_2);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_streambuf0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3Aoverflow0x28int0x29(void *instance, u32 var_0, u32 var_1) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_streambuf0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3Aoverflow0x28int0x29(instance, var_0, var_1);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3A0x7Ebasic_istream0x280x290x2E1(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3A0x7Ebasic_istream0x280x290x2E1(instance, var_0);
}
static u32 wrap_w2c_rlbox_virtual0x20thunk0x20to0x20std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3A0x7Ebasic_istream0x280x29(void *instance, u32 var_0) {
  return w2c_rlbox_virtual0x20thunk0x20to0x20std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3A0x7Ebasic_istream0x280x29(instance, var_0);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3A0x7Ebasic_istream0x280x290x2E2(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3A0x7Ebasic_istream0x280x290x2E2(instance, var_0);
}
static void wrap_w2c_rlbox_virtual0x20thunk0x20to0x20std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3A0x7Ebasic_istream0x280x290x2E1(void *instance, u32 var_0) {
  return w2c_rlbox_virtual0x20thunk0x20to0x20std0x3A0x3A_0x5F20x3A0x3Abasic_istream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3A0x7Ebasic_istream0x280x290x2E1(instance, var_0);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_ostream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3A0x7Ebasic_ostream0x280x290x2E1(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_ostream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3A0x7Ebasic_ostream0x280x290x2E1(instance, var_0);
}
static u32 wrap_w2c_rlbox_virtual0x20thunk0x20to0x20std0x3A0x3A_0x5F20x3A0x3Abasic_ostream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3A0x7Ebasic_ostream0x280x29(void *instance, u32 var_0) {
  return w2c_rlbox_virtual0x20thunk0x20to0x20std0x3A0x3A_0x5F20x3A0x3Abasic_ostream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3A0x7Ebasic_ostream0x280x29(instance, var_0);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_ostream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3A0x7Ebasic_ostream0x280x290x2E2(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_ostream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3A0x7Ebasic_ostream0x280x290x2E2(instance, var_0);
}
static void wrap_w2c_rlbox_virtual0x20thunk0x20to0x20std0x3A0x3A_0x5F20x3A0x3Abasic_ostream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3A0x7Ebasic_ostream0x280x290x2E1(void *instance, u32 var_0) {
  return w2c_rlbox_virtual0x20thunk0x20to0x20std0x3A0x3A_0x5F20x3A0x3Abasic_ostream0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3A0x3A0x7Ebasic_ostream0x280x290x2E1(instance, var_0);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_stringbuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3Aunderflow0x280x29(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_stringbuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3Aunderflow0x280x29(instance, var_0);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_stringbuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3Apbackfail0x28int0x29(void *instance, u32 var_0, u32 var_1) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_stringbuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3Apbackfail0x28int0x29(instance, var_0, var_1);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_stringbuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3Aoverflow0x28int0x29(void *instance, u32 var_0, u32 var_1) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_stringbuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3Aoverflow0x28int0x29(instance, var_0, var_1);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_stringbuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3Aseekoff0x28long0x20long0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x3A0x3Aseekdir0x2C0x20unsigned0x20int0x29(void *instance, u32 var_0, u32 var_1, u64 var_2, u32 var_3, u32 var_4) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_stringbuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3Aseekoff0x28long0x20long0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x3A0x3Aseekdir0x2C0x20unsigned0x20int0x29(instance, var_0, var_1, var_2, var_3, var_4);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_filebuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_filebuf0x280x29(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_filebuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_filebuf0x280x29(instance, var_0);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_filebuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Async0x280x29(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_filebuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Async0x280x29(instance, var_0);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_filebuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_filebuf0x280x290x2E1(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_filebuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_filebuf0x280x290x2E1(instance, var_0);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_filebuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Aunderflow0x280x29(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_filebuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Aunderflow0x280x29(instance, var_0);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_filebuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Apbackfail0x28int0x29(void *instance, u32 var_0, u32 var_1) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_filebuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Apbackfail0x28int0x29(instance, var_0, var_1);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_filebuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Aoverflow0x28int0x29(void *instance, u32 var_0, u32 var_1) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_filebuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Aoverflow0x28int0x29(instance, var_0, var_1);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_filebuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Asetbuf0x28char0x2A0x2C0x20long0x29(void *instance, u32 var_0, u32 var_1, u32 var_2) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_filebuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Asetbuf0x28char0x2A0x2C0x20long0x29(instance, var_0, var_1, var_2);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_filebuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Aseekoff0x28long0x20long0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x3A0x3Aseekdir0x2C0x20unsigned0x20int0x29(void *instance, u32 var_0, u32 var_1, u64 var_2, u32 var_3, u32 var_4) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_filebuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Aseekoff0x28long0x20long0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x3A0x3Aseekdir0x2C0x20unsigned0x20int0x29(instance, var_0, var_1, var_2, var_3, var_4);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_filebuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Aseekpos0x28std0x3A0x3A_0x5F20x3A0x3Afpos0x3C_0x5Fmbstate_t0x3E0x2C0x20unsigned0x20int0x29(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_filebuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Aseekpos0x28std0x3A0x3A_0x5F20x3A0x3Afpos0x3C_0x5Fmbstate_t0x3E0x2C0x20unsigned0x20int0x29(instance, var_0, var_1, var_2, var_3);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_filebuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Aimbue0x28std0x3A0x3A_0x5F20x3A0x3Alocale0x20const0x260x29(void *instance, u32 var_0, u32 var_1) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_filebuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3Aimbue0x28std0x3A0x3A_0x5F20x3A0x3Alocale0x20const0x260x29(instance, var_0, var_1);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_stringbuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_stringbuf0x280x29(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_stringbuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_stringbuf0x280x29(instance, var_0);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_stringbuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_stringbuf0x280x290x2E1(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_stringbuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_stringbuf0x280x290x2E1(instance, var_0);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_stringbuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3Aseekpos0x28std0x3A0x3A_0x5F20x3A0x3Afpos0x3C_0x5Fmbstate_t0x3E0x2C0x20unsigned0x20int0x29(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_stringbuf0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3Aseekpos0x28std0x3A0x3A_0x5F20x3A0x3Afpos0x3C_0x5Fmbstate_t0x3E0x2C0x20unsigned0x20int0x29(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_stringstream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_stringstream0x280x29(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_stringstream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_stringstream0x280x29(instance, var_0);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_stringstream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_stringstream0x280x290x2E1(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_stringstream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_stringstream0x280x290x2E1(instance, var_0);
}
static u32 wrap_w2c_rlbox_non0x2Dvirtual0x20thunk0x20to0x20std0x3A0x3A_0x5F20x3A0x3Abasic_stringstream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_stringstream0x280x29(void *instance, u32 var_0) {
  return w2c_rlbox_non0x2Dvirtual0x20thunk0x20to0x20std0x3A0x3A_0x5F20x3A0x3Abasic_stringstream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_stringstream0x280x29(instance, var_0);
}
static void wrap_w2c_rlbox_non0x2Dvirtual0x20thunk0x20to0x20std0x3A0x3A_0x5F20x3A0x3Abasic_stringstream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_stringstream0x280x290x2E1(void *instance, u32 var_0) {
  return w2c_rlbox_non0x2Dvirtual0x20thunk0x20to0x20std0x3A0x3A_0x5F20x3A0x3Abasic_stringstream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_stringstream0x280x290x2E1(instance, var_0);
}
static u32 wrap_w2c_rlbox_virtual0x20thunk0x20to0x20std0x3A0x3A_0x5F20x3A0x3Abasic_stringstream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_stringstream0x280x29(void *instance, u32 var_0) {
  return w2c_rlbox_virtual0x20thunk0x20to0x20std0x3A0x3A_0x5F20x3A0x3Abasic_stringstream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_stringstream0x280x29(instance, var_0);
}
static void wrap_w2c_rlbox_virtual0x20thunk0x20to0x20std0x3A0x3A_0x5F20x3A0x3Abasic_stringstream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_stringstream0x280x290x2E1(void *instance, u32 var_0) {
  return w2c_rlbox_virtual0x20thunk0x20to0x20std0x3A0x3A_0x5F20x3A0x3Abasic_stringstream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_stringstream0x280x290x2E1(instance, var_0);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_ostringstream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_ostringstream0x280x29(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_ostringstream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_ostringstream0x280x29(instance, var_0);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_ostringstream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_ostringstream0x280x290x2E1(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_ostringstream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_ostringstream0x280x290x2E1(instance, var_0);
}
static u32 wrap_w2c_rlbox_virtual0x20thunk0x20to0x20std0x3A0x3A_0x5F20x3A0x3Abasic_ostringstream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_ostringstream0x280x29(void *instance, u32 var_0) {
  return w2c_rlbox_virtual0x20thunk0x20to0x20std0x3A0x3A_0x5F20x3A0x3Abasic_ostringstream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_ostringstream0x280x29(instance, var_0);
}
static void wrap_w2c_rlbox_virtual0x20thunk0x20to0x20std0x3A0x3A_0x5F20x3A0x3Abasic_ostringstream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_ostringstream0x280x290x2E1(void *instance, u32 var_0) {
  return w2c_rlbox_virtual0x20thunk0x20to0x20std0x3A0x3A_0x5F20x3A0x3Abasic_ostringstream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_ostringstream0x280x290x2E1(instance, var_0);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_istringstream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_istringstream0x280x29(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_istringstream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_istringstream0x280x29(instance, var_0);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_istringstream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_istringstream0x280x290x2E1(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_istringstream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_istringstream0x280x290x2E1(instance, var_0);
}
static u32 wrap_w2c_rlbox_virtual0x20thunk0x20to0x20std0x3A0x3A_0x5F20x3A0x3Abasic_istringstream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_istringstream0x280x29(void *instance, u32 var_0) {
  return w2c_rlbox_virtual0x20thunk0x20to0x20std0x3A0x3A_0x5F20x3A0x3Abasic_istringstream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_istringstream0x280x29(instance, var_0);
}
static void wrap_w2c_rlbox_virtual0x20thunk0x20to0x20std0x3A0x3A_0x5F20x3A0x3Abasic_istringstream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_istringstream0x280x290x2E1(void *instance, u32 var_0) {
  return w2c_rlbox_virtual0x20thunk0x20to0x20std0x3A0x3A_0x5F20x3A0x3Abasic_istringstream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_istringstream0x280x290x2E1(instance, var_0);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_ifstream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_ifstream0x280x29(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_ifstream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_ifstream0x280x29(instance, var_0);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_ifstream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_ifstream0x280x290x2E1(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_ifstream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_ifstream0x280x290x2E1(instance, var_0);
}
static u32 wrap_w2c_rlbox_virtual0x20thunk0x20to0x20std0x3A0x3A_0x5F20x3A0x3Abasic_ifstream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_ifstream0x280x29(void *instance, u32 var_0) {
  return w2c_rlbox_virtual0x20thunk0x20to0x20std0x3A0x3A_0x5F20x3A0x3Abasic_ifstream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_ifstream0x280x29(instance, var_0);
}
static void wrap_w2c_rlbox_virtual0x20thunk0x20to0x20std0x3A0x3A_0x5F20x3A0x3Abasic_ifstream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_ifstream0x280x290x2E1(void *instance, u32 var_0) {
  return w2c_rlbox_virtual0x20thunk0x20to0x20std0x3A0x3A_0x5F20x3A0x3Abasic_ifstream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_ifstream0x280x290x2E1(instance, var_0);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_ofstream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_ofstream0x280x29(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_ofstream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_ofstream0x280x29(instance, var_0);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_ofstream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_ofstream0x280x290x2E1(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abasic_ofstream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_ofstream0x280x290x2E1(instance, var_0);
}
static u32 wrap_w2c_rlbox_virtual0x20thunk0x20to0x20std0x3A0x3A_0x5F20x3A0x3Abasic_ofstream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_ofstream0x280x29(void *instance, u32 var_0) {
  return w2c_rlbox_virtual0x20thunk0x20to0x20std0x3A0x3A_0x5F20x3A0x3Abasic_ofstream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_ofstream0x280x29(instance, var_0);
}
static void wrap_w2c_rlbox_virtual0x20thunk0x20to0x20std0x3A0x3A_0x5F20x3A0x3Abasic_ofstream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_ofstream0x280x290x2E1(void *instance, u32 var_0) {
  return w2c_rlbox_virtual0x20thunk0x20to0x20std0x3A0x3A_0x5F20x3A0x3Abasic_ofstream0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_ofstream0x280x290x2E1(instance, var_0);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abad_weak_ptr0x3A0x3A0x7Ebad_weak_ptr0x280x29(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abad_weak_ptr0x3A0x3A0x7Ebad_weak_ptr0x280x29(instance, var_0);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abad_weak_ptr0x3A0x3A0x7Ebad_weak_ptr0x280x290x2E1(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abad_weak_ptr0x3A0x3A0x7Ebad_weak_ptr0x280x290x2E1(instance, var_0);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abad_weak_ptr0x3A0x3Awhat0x280x290x20const(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Abad_weak_ptr0x3A0x3Awhat0x280x290x20const(instance, var_0);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fshared_count0x3A0x3A0x7E_0x5Fshared_count0x280x29(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fshared_count0x3A0x3A0x7E_0x5Fshared_count0x280x29(instance, var_0);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fshared_count0x3A0x3A0x7E_0x5Fshared_count0x280x290x2E1(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fshared_count0x3A0x3A0x7E_0x5Fshared_count0x280x290x2E1(instance, var_0);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fshared_weak_count0x3A0x3A0x7E_0x5Fshared_weak_count0x280x29(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fshared_weak_count0x3A0x3A0x7E_0x5Fshared_weak_count0x280x29(instance, var_0);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fshared_weak_count0x3A0x3A_0x5Fget_deleter0x28std0x3A0x3Atype_info0x20const0x260x290x20const(void *instance, u32 var_0, u32 var_1) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fshared_weak_count0x3A0x3A_0x5Fget_deleter0x28std0x3A0x3Atype_info0x20const0x260x290x20const(instance, var_0, var_1);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acollate0x3Cchar0x3E0x3A0x3A0x7Ecollate0x280x29(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acollate0x3Cchar0x3E0x3A0x3A0x7Ecollate0x280x29(instance, var_0);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acollate0x3Cchar0x3E0x3A0x3A0x7Ecollate0x280x290x2E1(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acollate0x3Cchar0x3E0x3A0x3A0x7Ecollate0x280x290x2E1(instance, var_0);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acollate0x3Cchar0x3E0x3A0x3Ado_compare0x28char0x20const0x2A0x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acollate0x3Cchar0x3E0x3A0x3Ado_compare0x28char0x20const0x2A0x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x290x20const(instance, var_0, var_1, var_2, var_3, var_4);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acollate0x3Cchar0x3E0x3A0x3Ado_transform0x28char0x20const0x2A0x2C0x20char0x20const0x2A0x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acollate0x3Cchar0x3E0x3A0x3Ado_transform0x28char0x20const0x2A0x2C0x20char0x20const0x2A0x290x20const(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acollate0x3Cchar0x3E0x3A0x3Ado_hash0x28char0x20const0x2A0x2C0x20char0x20const0x2A0x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acollate0x3Cchar0x3E0x3A0x3Ado_hash0x28char0x20const0x2A0x2C0x20char0x20const0x2A0x290x20const(instance, var_0, var_1, var_2);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acollate0x3Cwchar_t0x3E0x3A0x3A0x7Ecollate0x280x29(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acollate0x3Cwchar_t0x3E0x3A0x3A0x7Ecollate0x280x29(instance, var_0);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acollate0x3Cwchar_t0x3E0x3A0x3A0x7Ecollate0x280x290x2E1(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acollate0x3Cwchar_t0x3E0x3A0x3A0x7Ecollate0x280x290x2E1(instance, var_0);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acollate0x3Cwchar_t0x3E0x3A0x3Ado_compare0x28wchar_t0x20const0x2A0x2C0x20wchar_t0x20const0x2A0x2C0x20wchar_t0x20const0x2A0x2C0x20wchar_t0x20const0x2A0x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acollate0x3Cwchar_t0x3E0x3A0x3Ado_compare0x28wchar_t0x20const0x2A0x2C0x20wchar_t0x20const0x2A0x2C0x20wchar_t0x20const0x2A0x2C0x20wchar_t0x20const0x2A0x290x20const(instance, var_0, var_1, var_2, var_3, var_4);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acollate0x3Cwchar_t0x3E0x3A0x3Ado_transform0x28wchar_t0x20const0x2A0x2C0x20wchar_t0x20const0x2A0x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acollate0x3Cwchar_t0x3E0x3A0x3Ado_transform0x28wchar_t0x20const0x2A0x2C0x20wchar_t0x20const0x2A0x290x20const(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acollate0x3Cwchar_t0x3E0x3A0x3Ado_hash0x28wchar_t0x20const0x2A0x2C0x20wchar_t0x20const0x2A0x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acollate0x3Cwchar_t0x3E0x3A0x3Ado_hash0x28wchar_t0x20const0x2A0x2C0x20wchar_t0x20const0x2A0x290x20const(instance, var_0, var_1, var_2);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_get0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3Ado_get0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20bool0x260x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4, u32 var_5) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_get0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3Ado_get0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20bool0x260x290x20const(instance, var_0, var_1, var_2, var_3, var_4, var_5);
}
static void wrap_w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fcall_once_proxy0x5Babi0x3Ann2101050x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3Atuple0x3Cstd0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3Aid0x3A0x3A_0x5Fget0x280x290x3A0x3A0x24_00x260x260x3E0x3E0x28void0x2A0x29(void *instance, u32 var_0) {
  return w2c_rlbox_void0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fcall_once_proxy0x5Babi0x3Ann2101050x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3Atuple0x3Cstd0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3Aid0x3A0x3A_0x5Fget0x280x290x3A0x3A0x24_00x260x260x3E0x3E0x28void0x2A0x29(instance, var_0);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_get0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3Ado_get0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20long0x260x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4, u32 var_5) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_get0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3Ado_get0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20long0x260x290x20const(instance, var_0, var_1, var_2, var_3, var_4, var_5);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_get0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3Ado_get0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20long0x20long0x260x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4, u32 var_5) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_get0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3Ado_get0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20long0x20long0x260x290x20const(instance, var_0, var_1, var_2, var_3, var_4, var_5);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_get0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3Ado_get0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20unsigned0x20short0x260x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4, u32 var_5) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_get0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3Ado_get0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20unsigned0x20short0x260x290x20const(instance, var_0, var_1, var_2, var_3, var_4, var_5);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_get0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3Ado_get0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20unsigned0x20int0x260x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4, u32 var_5) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_get0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3Ado_get0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20unsigned0x20int0x260x290x20const(instance, var_0, var_1, var_2, var_3, var_4, var_5);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_get0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3Ado_get0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20unsigned0x20long0x260x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4, u32 var_5) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_get0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3Ado_get0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20unsigned0x20long0x260x290x20const(instance, var_0, var_1, var_2, var_3, var_4, var_5);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_get0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3Ado_get0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20unsigned0x20long0x20long0x260x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4, u32 var_5) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_get0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3Ado_get0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20unsigned0x20long0x20long0x260x290x20const(instance, var_0, var_1, var_2, var_3, var_4, var_5);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_get0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3Ado_get0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20float0x260x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4, u32 var_5) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_get0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3Ado_get0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20float0x260x290x20const(instance, var_0, var_1, var_2, var_3, var_4, var_5);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_get0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3Ado_get0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20double0x260x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4, u32 var_5) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_get0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3Ado_get0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20double0x260x290x20const(instance, var_0, var_1, var_2, var_3, var_4, var_5);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_get0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3Ado_get0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20long0x20double0x260x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4, u32 var_5) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_get0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3Ado_get0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20long0x20double0x260x290x20const(instance, var_0, var_1, var_2, var_3, var_4, var_5);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_get0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3Ado_get0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20void0x2A0x260x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4, u32 var_5) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_get0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3Ado_get0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20void0x2A0x260x290x20const(instance, var_0, var_1, var_2, var_3, var_4, var_5);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_get0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3Ado_get0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20bool0x260x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4, u32 var_5) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_get0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3Ado_get0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20bool0x260x290x20const(instance, var_0, var_1, var_2, var_3, var_4, var_5);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_get0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3Ado_get0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20long0x260x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4, u32 var_5) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_get0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3Ado_get0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20long0x260x290x20const(instance, var_0, var_1, var_2, var_3, var_4, var_5);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_get0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3Ado_get0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20long0x20long0x260x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4, u32 var_5) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_get0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3Ado_get0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20long0x20long0x260x290x20const(instance, var_0, var_1, var_2, var_3, var_4, var_5);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_get0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3Ado_get0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20unsigned0x20short0x260x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4, u32 var_5) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_get0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3Ado_get0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20unsigned0x20short0x260x290x20const(instance, var_0, var_1, var_2, var_3, var_4, var_5);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_get0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3Ado_get0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20unsigned0x20int0x260x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4, u32 var_5) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_get0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3Ado_get0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20unsigned0x20int0x260x290x20const(instance, var_0, var_1, var_2, var_3, var_4, var_5);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_get0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3Ado_get0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20unsigned0x20long0x260x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4, u32 var_5) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_get0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3Ado_get0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20unsigned0x20long0x260x290x20const(instance, var_0, var_1, var_2, var_3, var_4, var_5);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_get0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3Ado_get0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20unsigned0x20long0x20long0x260x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4, u32 var_5) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_get0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3Ado_get0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20unsigned0x20long0x20long0x260x290x20const(instance, var_0, var_1, var_2, var_3, var_4, var_5);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_get0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3Ado_get0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20float0x260x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4, u32 var_5) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_get0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3Ado_get0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20float0x260x290x20const(instance, var_0, var_1, var_2, var_3, var_4, var_5);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_get0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3Ado_get0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20double0x260x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4, u32 var_5) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_get0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3Ado_get0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20double0x260x290x20const(instance, var_0, var_1, var_2, var_3, var_4, var_5);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_get0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3Ado_get0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20long0x20double0x260x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4, u32 var_5) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_get0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3Ado_get0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20long0x20double0x260x290x20const(instance, var_0, var_1, var_2, var_3, var_4, var_5);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_get0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3Ado_get0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20void0x2A0x260x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4, u32 var_5) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_get0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3Ado_get0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20void0x2A0x260x290x20const(instance, var_0, var_1, var_2, var_3, var_4, var_5);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_put0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3Ado_put0x28std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20char0x2C0x20bool0x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_put0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3Ado_put0x28std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20char0x2C0x20bool0x290x20const(instance, var_0, var_1, var_2, var_3, var_4);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_put0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3Ado_put0x28std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20char0x2C0x20long0x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_put0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3Ado_put0x28std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20char0x2C0x20long0x290x20const(instance, var_0, var_1, var_2, var_3, var_4);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_put0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3Ado_put0x28std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20char0x2C0x20long0x20long0x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u64 var_4) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_put0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3Ado_put0x28std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20char0x2C0x20long0x20long0x290x20const(instance, var_0, var_1, var_2, var_3, var_4);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_put0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3Ado_put0x28std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20char0x2C0x20unsigned0x20long0x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_put0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3Ado_put0x28std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20char0x2C0x20unsigned0x20long0x290x20const(instance, var_0, var_1, var_2, var_3, var_4);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_put0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3Ado_put0x28std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20char0x2C0x20unsigned0x20long0x20long0x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u64 var_4) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_put0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3Ado_put0x28std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20char0x2C0x20unsigned0x20long0x20long0x290x20const(instance, var_0, var_1, var_2, var_3, var_4);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_put0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3Ado_put0x28std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20char0x2C0x20double0x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, f64 var_4) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_put0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3Ado_put0x28std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20char0x2C0x20double0x290x20const(instance, var_0, var_1, var_2, var_3, var_4);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_put0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3Ado_put0x28std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20char0x2C0x20long0x20double0x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u64 var_4, u64 var_5) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_put0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3Ado_put0x28std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20char0x2C0x20long0x20double0x290x20const(instance, var_0, var_1, var_2, var_3, var_4, var_5);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_put0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3Ado_put0x28std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20char0x2C0x20void0x20const0x2A0x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_put0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3Ado_put0x28std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20char0x2C0x20void0x20const0x2A0x290x20const(instance, var_0, var_1, var_2, var_3, var_4);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_put0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3Ado_put0x28std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20wchar_t0x2C0x20bool0x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_put0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3Ado_put0x28std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20wchar_t0x2C0x20bool0x290x20const(instance, var_0, var_1, var_2, var_3, var_4);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_put0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3Ado_put0x28std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20wchar_t0x2C0x20long0x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_put0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3Ado_put0x28std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20wchar_t0x2C0x20long0x290x20const(instance, var_0, var_1, var_2, var_3, var_4);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_put0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3Ado_put0x28std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20wchar_t0x2C0x20long0x20long0x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u64 var_4) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_put0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3Ado_put0x28std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20wchar_t0x2C0x20long0x20long0x290x20const(instance, var_0, var_1, var_2, var_3, var_4);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_put0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3Ado_put0x28std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20wchar_t0x2C0x20unsigned0x20long0x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_put0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3Ado_put0x28std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20wchar_t0x2C0x20unsigned0x20long0x290x20const(instance, var_0, var_1, var_2, var_3, var_4);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_put0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3Ado_put0x28std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20wchar_t0x2C0x20unsigned0x20long0x20long0x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u64 var_4) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_put0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3Ado_put0x28std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20wchar_t0x2C0x20unsigned0x20long0x20long0x290x20const(instance, var_0, var_1, var_2, var_3, var_4);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_put0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3Ado_put0x28std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20wchar_t0x2C0x20double0x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, f64 var_4) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_put0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3Ado_put0x28std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20wchar_t0x2C0x20double0x290x20const(instance, var_0, var_1, var_2, var_3, var_4);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_put0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3Ado_put0x28std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20wchar_t0x2C0x20long0x20double0x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u64 var_4, u64 var_5) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_put0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3Ado_put0x28std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20wchar_t0x2C0x20long0x20double0x290x20const(instance, var_0, var_1, var_2, var_3, var_4, var_5);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_put0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3Ado_put0x28std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20wchar_t0x2C0x20void0x20const0x2A0x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Anum_put0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3Ado_put0x28std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20wchar_t0x2C0x20void0x20const0x2A0x290x20const(instance, var_0, var_1, var_2, var_3, var_4);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Atime_get0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3Ado_date_order0x280x290x20const(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Atime_get0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3Ado_date_order0x280x290x20const(instance, var_0);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Atime_get0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3Ado_get_time0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20tm0x2A0x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4, u32 var_5) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Atime_get0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3Ado_get_time0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20tm0x2A0x290x20const(instance, var_0, var_1, var_2, var_3, var_4, var_5);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Atime_get0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3Ado_get_date0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20tm0x2A0x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4, u32 var_5) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Atime_get0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3Ado_get_date0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20tm0x2A0x290x20const(instance, var_0, var_1, var_2, var_3, var_4, var_5);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Atime_get0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3Ado_get_weekday0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20tm0x2A0x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4, u32 var_5) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Atime_get0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3Ado_get_weekday0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20tm0x2A0x290x20const(instance, var_0, var_1, var_2, var_3, var_4, var_5);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Atime_get0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3Ado_get_monthname0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20tm0x2A0x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4, u32 var_5) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Atime_get0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3Ado_get_monthname0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20tm0x2A0x290x20const(instance, var_0, var_1, var_2, var_3, var_4, var_5);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Atime_get0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3Ado_get_year0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20tm0x2A0x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4, u32 var_5) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Atime_get0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3Ado_get_year0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20tm0x2A0x290x20const(instance, var_0, var_1, var_2, var_3, var_4, var_5);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Atime_get0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3Ado_get0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20tm0x2A0x2C0x20char0x2C0x20char0x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4, u32 var_5, u32 var_6, u32 var_7) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Atime_get0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3Ado_get0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20tm0x2A0x2C0x20char0x2C0x20char0x290x20const(instance, var_0, var_1, var_2, var_3, var_4, var_5, var_6, var_7);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Atime_get0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3Ado_date_order0x280x290x20const(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Atime_get0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3Ado_date_order0x280x290x20const(instance, var_0);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Atime_get0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3Ado_get_time0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20tm0x2A0x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4, u32 var_5) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Atime_get0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3Ado_get_time0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20tm0x2A0x290x20const(instance, var_0, var_1, var_2, var_3, var_4, var_5);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Atime_get0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3Ado_get_date0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20tm0x2A0x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4, u32 var_5) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Atime_get0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3Ado_get_date0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20tm0x2A0x290x20const(instance, var_0, var_1, var_2, var_3, var_4, var_5);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Atime_get0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3Ado_get_weekday0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20tm0x2A0x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4, u32 var_5) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Atime_get0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3Ado_get_weekday0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20tm0x2A0x290x20const(instance, var_0, var_1, var_2, var_3, var_4, var_5);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Atime_get0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3Ado_get_monthname0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20tm0x2A0x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4, u32 var_5) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Atime_get0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3Ado_get_monthname0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20tm0x2A0x290x20const(instance, var_0, var_1, var_2, var_3, var_4, var_5);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Atime_get0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3Ado_get_year0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20tm0x2A0x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4, u32 var_5) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Atime_get0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3Ado_get_year0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20tm0x2A0x290x20const(instance, var_0, var_1, var_2, var_3, var_4, var_5);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Atime_get0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3Ado_get0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20tm0x2A0x2C0x20char0x2C0x20char0x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4, u32 var_5, u32 var_6, u32 var_7) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Atime_get0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3Ado_get0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20tm0x2A0x2C0x20char0x2C0x20char0x290x20const(instance, var_0, var_1, var_2, var_3, var_4, var_5, var_6, var_7);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Atime_put0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3Ado_put0x28std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20char0x2C0x20tm0x20const0x2A0x2C0x20char0x2C0x20char0x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4, u32 var_5, u32 var_6) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Atime_put0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3Ado_put0x28std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20char0x2C0x20tm0x20const0x2A0x2C0x20char0x2C0x20char0x290x20const(instance, var_0, var_1, var_2, var_3, var_4, var_5, var_6);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Atime_put0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3Ado_put0x28std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20wchar_t0x2C0x20tm0x20const0x2A0x2C0x20char0x2C0x20char0x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4, u32 var_5, u32 var_6) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Atime_put0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3Ado_put0x28std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20wchar_t0x2C0x20tm0x20const0x2A0x2C0x20char0x2C0x20char0x290x20const(instance, var_0, var_1, var_2, var_3, var_4, var_5, var_6);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cchar0x2C0x20false0x3E0x3A0x3Ado_decimal_point0x280x290x20const(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cchar0x2C0x20false0x3E0x3A0x3Ado_decimal_point0x280x290x20const(instance, var_0);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cchar0x2C0x20false0x3E0x3A0x3Ado_thousands_sep0x280x290x20const(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cchar0x2C0x20false0x3E0x3A0x3Ado_thousands_sep0x280x290x20const(instance, var_0);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cchar0x2C0x20false0x3E0x3A0x3Ado_grouping0x280x290x20const(void *instance, u32 var_0, u32 var_1) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cchar0x2C0x20false0x3E0x3A0x3Ado_grouping0x280x290x20const(instance, var_0, var_1);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cchar0x2C0x20false0x3E0x3A0x3Ado_curr_symbol0x280x290x20const(void *instance, u32 var_0, u32 var_1) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cchar0x2C0x20false0x3E0x3A0x3Ado_curr_symbol0x280x290x20const(instance, var_0, var_1);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cchar0x2C0x20false0x3E0x3A0x3Ado_positive_sign0x280x290x20const(void *instance, u32 var_0, u32 var_1) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cchar0x2C0x20false0x3E0x3A0x3Ado_positive_sign0x280x290x20const(instance, var_0, var_1);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cchar0x2C0x20false0x3E0x3A0x3Ado_negative_sign0x280x290x20const(void *instance, u32 var_0, u32 var_1) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cchar0x2C0x20false0x3E0x3A0x3Ado_negative_sign0x280x290x20const(instance, var_0, var_1);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cchar0x2C0x20false0x3E0x3A0x3Ado_frac_digits0x280x290x20const(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cchar0x2C0x20false0x3E0x3A0x3Ado_frac_digits0x280x290x20const(instance, var_0);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cchar0x2C0x20false0x3E0x3A0x3Ado_pos_format0x280x290x20const(void *instance, u32 var_0, u32 var_1) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cchar0x2C0x20false0x3E0x3A0x3Ado_pos_format0x280x290x20const(instance, var_0, var_1);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cchar0x2C0x20false0x3E0x3A0x3Ado_neg_format0x280x290x20const(void *instance, u32 var_0, u32 var_1) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cchar0x2C0x20false0x3E0x3A0x3Ado_neg_format0x280x290x20const(instance, var_0, var_1);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cchar0x2C0x20true0x3E0x3A0x3Ado_decimal_point0x280x290x20const(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cchar0x2C0x20true0x3E0x3A0x3Ado_decimal_point0x280x290x20const(instance, var_0);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cchar0x2C0x20true0x3E0x3A0x3Ado_thousands_sep0x280x290x20const(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cchar0x2C0x20true0x3E0x3A0x3Ado_thousands_sep0x280x290x20const(instance, var_0);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cchar0x2C0x20true0x3E0x3A0x3Ado_grouping0x280x290x20const(void *instance, u32 var_0, u32 var_1) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cchar0x2C0x20true0x3E0x3A0x3Ado_grouping0x280x290x20const(instance, var_0, var_1);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cchar0x2C0x20true0x3E0x3A0x3Ado_curr_symbol0x280x290x20const(void *instance, u32 var_0, u32 var_1) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cchar0x2C0x20true0x3E0x3A0x3Ado_curr_symbol0x280x290x20const(instance, var_0, var_1);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cchar0x2C0x20true0x3E0x3A0x3Ado_positive_sign0x280x290x20const(void *instance, u32 var_0, u32 var_1) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cchar0x2C0x20true0x3E0x3A0x3Ado_positive_sign0x280x290x20const(instance, var_0, var_1);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cchar0x2C0x20true0x3E0x3A0x3Ado_negative_sign0x280x290x20const(void *instance, u32 var_0, u32 var_1) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cchar0x2C0x20true0x3E0x3A0x3Ado_negative_sign0x280x290x20const(instance, var_0, var_1);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cchar0x2C0x20true0x3E0x3A0x3Ado_frac_digits0x280x290x20const(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cchar0x2C0x20true0x3E0x3A0x3Ado_frac_digits0x280x290x20const(instance, var_0);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cchar0x2C0x20true0x3E0x3A0x3Ado_pos_format0x280x290x20const(void *instance, u32 var_0, u32 var_1) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cchar0x2C0x20true0x3E0x3A0x3Ado_pos_format0x280x290x20const(instance, var_0, var_1);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cchar0x2C0x20true0x3E0x3A0x3Ado_neg_format0x280x290x20const(void *instance, u32 var_0, u32 var_1) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cchar0x2C0x20true0x3E0x3A0x3Ado_neg_format0x280x290x20const(instance, var_0, var_1);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cwchar_t0x2C0x20false0x3E0x3A0x3Ado_decimal_point0x280x290x20const(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cwchar_t0x2C0x20false0x3E0x3A0x3Ado_decimal_point0x280x290x20const(instance, var_0);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cwchar_t0x2C0x20false0x3E0x3A0x3Ado_thousands_sep0x280x290x20const(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cwchar_t0x2C0x20false0x3E0x3A0x3Ado_thousands_sep0x280x290x20const(instance, var_0);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cwchar_t0x2C0x20false0x3E0x3A0x3Ado_grouping0x280x290x20const(void *instance, u32 var_0, u32 var_1) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cwchar_t0x2C0x20false0x3E0x3A0x3Ado_grouping0x280x290x20const(instance, var_0, var_1);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cwchar_t0x2C0x20false0x3E0x3A0x3Ado_curr_symbol0x280x290x20const(void *instance, u32 var_0, u32 var_1) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cwchar_t0x2C0x20false0x3E0x3A0x3Ado_curr_symbol0x280x290x20const(instance, var_0, var_1);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cwchar_t0x2C0x20false0x3E0x3A0x3Ado_positive_sign0x280x290x20const(void *instance, u32 var_0, u32 var_1) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cwchar_t0x2C0x20false0x3E0x3A0x3Ado_positive_sign0x280x290x20const(instance, var_0, var_1);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cwchar_t0x2C0x20false0x3E0x3A0x3Ado_negative_sign0x280x290x20const(void *instance, u32 var_0, u32 var_1) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cwchar_t0x2C0x20false0x3E0x3A0x3Ado_negative_sign0x280x290x20const(instance, var_0, var_1);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cwchar_t0x2C0x20false0x3E0x3A0x3Ado_frac_digits0x280x290x20const(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cwchar_t0x2C0x20false0x3E0x3A0x3Ado_frac_digits0x280x290x20const(instance, var_0);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cwchar_t0x2C0x20false0x3E0x3A0x3Ado_pos_format0x280x290x20const(void *instance, u32 var_0, u32 var_1) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cwchar_t0x2C0x20false0x3E0x3A0x3Ado_pos_format0x280x290x20const(instance, var_0, var_1);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cwchar_t0x2C0x20false0x3E0x3A0x3Ado_neg_format0x280x290x20const(void *instance, u32 var_0, u32 var_1) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cwchar_t0x2C0x20false0x3E0x3A0x3Ado_neg_format0x280x290x20const(instance, var_0, var_1);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cwchar_t0x2C0x20true0x3E0x3A0x3Ado_decimal_point0x280x290x20const(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cwchar_t0x2C0x20true0x3E0x3A0x3Ado_decimal_point0x280x290x20const(instance, var_0);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cwchar_t0x2C0x20true0x3E0x3A0x3Ado_thousands_sep0x280x290x20const(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cwchar_t0x2C0x20true0x3E0x3A0x3Ado_thousands_sep0x280x290x20const(instance, var_0);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cwchar_t0x2C0x20true0x3E0x3A0x3Ado_grouping0x280x290x20const(void *instance, u32 var_0, u32 var_1) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cwchar_t0x2C0x20true0x3E0x3A0x3Ado_grouping0x280x290x20const(instance, var_0, var_1);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cwchar_t0x2C0x20true0x3E0x3A0x3Ado_curr_symbol0x280x290x20const(void *instance, u32 var_0, u32 var_1) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cwchar_t0x2C0x20true0x3E0x3A0x3Ado_curr_symbol0x280x290x20const(instance, var_0, var_1);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cwchar_t0x2C0x20true0x3E0x3A0x3Ado_positive_sign0x280x290x20const(void *instance, u32 var_0, u32 var_1) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cwchar_t0x2C0x20true0x3E0x3A0x3Ado_positive_sign0x280x290x20const(instance, var_0, var_1);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cwchar_t0x2C0x20true0x3E0x3A0x3Ado_negative_sign0x280x290x20const(void *instance, u32 var_0, u32 var_1) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cwchar_t0x2C0x20true0x3E0x3A0x3Ado_negative_sign0x280x290x20const(instance, var_0, var_1);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cwchar_t0x2C0x20true0x3E0x3A0x3Ado_frac_digits0x280x290x20const(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cwchar_t0x2C0x20true0x3E0x3A0x3Ado_frac_digits0x280x290x20const(instance, var_0);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cwchar_t0x2C0x20true0x3E0x3A0x3Ado_pos_format0x280x290x20const(void *instance, u32 var_0, u32 var_1) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cwchar_t0x2C0x20true0x3E0x3A0x3Ado_pos_format0x280x290x20const(instance, var_0, var_1);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cwchar_t0x2C0x20true0x3E0x3A0x3Ado_neg_format0x280x290x20const(void *instance, u32 var_0, u32 var_1) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct0x3Cwchar_t0x2C0x20true0x3E0x3A0x3Ado_neg_format0x280x290x20const(instance, var_0, var_1);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cchar0x2C0x20false0x3E0x3A0x3Ado_decimal_point0x280x290x20const(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cchar0x2C0x20false0x3E0x3A0x3Ado_decimal_point0x280x290x20const(instance, var_0);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cchar0x2C0x20false0x3E0x3A0x3Ado_thousands_sep0x280x290x20const(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cchar0x2C0x20false0x3E0x3A0x3Ado_thousands_sep0x280x290x20const(instance, var_0);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cchar0x2C0x20false0x3E0x3A0x3Ado_grouping0x280x290x20const(void *instance, u32 var_0, u32 var_1) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cchar0x2C0x20false0x3E0x3A0x3Ado_grouping0x280x290x20const(instance, var_0, var_1);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cchar0x2C0x20false0x3E0x3A0x3Ado_curr_symbol0x280x290x20const(void *instance, u32 var_0, u32 var_1) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cchar0x2C0x20false0x3E0x3A0x3Ado_curr_symbol0x280x290x20const(instance, var_0, var_1);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cchar0x2C0x20false0x3E0x3A0x3Ado_positive_sign0x280x290x20const(void *instance, u32 var_0, u32 var_1) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cchar0x2C0x20false0x3E0x3A0x3Ado_positive_sign0x280x290x20const(instance, var_0, var_1);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cchar0x2C0x20false0x3E0x3A0x3Ado_negative_sign0x280x290x20const(void *instance, u32 var_0, u32 var_1) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cchar0x2C0x20false0x3E0x3A0x3Ado_negative_sign0x280x290x20const(instance, var_0, var_1);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cchar0x2C0x20false0x3E0x3A0x3Ado_frac_digits0x280x290x20const(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cchar0x2C0x20false0x3E0x3A0x3Ado_frac_digits0x280x290x20const(instance, var_0);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cchar0x2C0x20false0x3E0x3A0x3Ado_pos_format0x280x290x20const(void *instance, u32 var_0, u32 var_1) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cchar0x2C0x20false0x3E0x3A0x3Ado_pos_format0x280x290x20const(instance, var_0, var_1);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cchar0x2C0x20false0x3E0x3A0x3Ado_neg_format0x280x290x20const(void *instance, u32 var_0, u32 var_1) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cchar0x2C0x20false0x3E0x3A0x3Ado_neg_format0x280x290x20const(instance, var_0, var_1);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cchar0x2C0x20true0x3E0x3A0x3Ado_decimal_point0x280x290x20const(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cchar0x2C0x20true0x3E0x3A0x3Ado_decimal_point0x280x290x20const(instance, var_0);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cchar0x2C0x20true0x3E0x3A0x3Ado_thousands_sep0x280x290x20const(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cchar0x2C0x20true0x3E0x3A0x3Ado_thousands_sep0x280x290x20const(instance, var_0);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cchar0x2C0x20true0x3E0x3A0x3Ado_grouping0x280x290x20const(void *instance, u32 var_0, u32 var_1) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cchar0x2C0x20true0x3E0x3A0x3Ado_grouping0x280x290x20const(instance, var_0, var_1);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cchar0x2C0x20true0x3E0x3A0x3Ado_curr_symbol0x280x290x20const(void *instance, u32 var_0, u32 var_1) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cchar0x2C0x20true0x3E0x3A0x3Ado_curr_symbol0x280x290x20const(instance, var_0, var_1);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cchar0x2C0x20true0x3E0x3A0x3Ado_positive_sign0x280x290x20const(void *instance, u32 var_0, u32 var_1) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cchar0x2C0x20true0x3E0x3A0x3Ado_positive_sign0x280x290x20const(instance, var_0, var_1);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cchar0x2C0x20true0x3E0x3A0x3Ado_negative_sign0x280x290x20const(void *instance, u32 var_0, u32 var_1) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cchar0x2C0x20true0x3E0x3A0x3Ado_negative_sign0x280x290x20const(instance, var_0, var_1);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cchar0x2C0x20true0x3E0x3A0x3Ado_frac_digits0x280x290x20const(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cchar0x2C0x20true0x3E0x3A0x3Ado_frac_digits0x280x290x20const(instance, var_0);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cchar0x2C0x20true0x3E0x3A0x3Ado_pos_format0x280x290x20const(void *instance, u32 var_0, u32 var_1) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cchar0x2C0x20true0x3E0x3A0x3Ado_pos_format0x280x290x20const(instance, var_0, var_1);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cchar0x2C0x20true0x3E0x3A0x3Ado_neg_format0x280x290x20const(void *instance, u32 var_0, u32 var_1) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cchar0x2C0x20true0x3E0x3A0x3Ado_neg_format0x280x290x20const(instance, var_0, var_1);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cwchar_t0x2C0x20false0x3E0x3A0x3Ado_decimal_point0x280x290x20const(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cwchar_t0x2C0x20false0x3E0x3A0x3Ado_decimal_point0x280x290x20const(instance, var_0);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cwchar_t0x2C0x20false0x3E0x3A0x3Ado_thousands_sep0x280x290x20const(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cwchar_t0x2C0x20false0x3E0x3A0x3Ado_thousands_sep0x280x290x20const(instance, var_0);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cwchar_t0x2C0x20false0x3E0x3A0x3Ado_grouping0x280x290x20const(void *instance, u32 var_0, u32 var_1) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cwchar_t0x2C0x20false0x3E0x3A0x3Ado_grouping0x280x290x20const(instance, var_0, var_1);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cwchar_t0x2C0x20false0x3E0x3A0x3Ado_curr_symbol0x280x290x20const(void *instance, u32 var_0, u32 var_1) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cwchar_t0x2C0x20false0x3E0x3A0x3Ado_curr_symbol0x280x290x20const(instance, var_0, var_1);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cwchar_t0x2C0x20false0x3E0x3A0x3Ado_positive_sign0x280x290x20const(void *instance, u32 var_0, u32 var_1) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cwchar_t0x2C0x20false0x3E0x3A0x3Ado_positive_sign0x280x290x20const(instance, var_0, var_1);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cwchar_t0x2C0x20false0x3E0x3A0x3Ado_negative_sign0x280x290x20const(void *instance, u32 var_0, u32 var_1) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cwchar_t0x2C0x20false0x3E0x3A0x3Ado_negative_sign0x280x290x20const(instance, var_0, var_1);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cwchar_t0x2C0x20false0x3E0x3A0x3Ado_frac_digits0x280x290x20const(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cwchar_t0x2C0x20false0x3E0x3A0x3Ado_frac_digits0x280x290x20const(instance, var_0);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cwchar_t0x2C0x20false0x3E0x3A0x3Ado_pos_format0x280x290x20const(void *instance, u32 var_0, u32 var_1) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cwchar_t0x2C0x20false0x3E0x3A0x3Ado_pos_format0x280x290x20const(instance, var_0, var_1);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cwchar_t0x2C0x20false0x3E0x3A0x3Ado_neg_format0x280x290x20const(void *instance, u32 var_0, u32 var_1) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cwchar_t0x2C0x20false0x3E0x3A0x3Ado_neg_format0x280x290x20const(instance, var_0, var_1);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cwchar_t0x2C0x20true0x3E0x3A0x3Ado_decimal_point0x280x290x20const(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cwchar_t0x2C0x20true0x3E0x3A0x3Ado_decimal_point0x280x290x20const(instance, var_0);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cwchar_t0x2C0x20true0x3E0x3A0x3Ado_thousands_sep0x280x290x20const(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cwchar_t0x2C0x20true0x3E0x3A0x3Ado_thousands_sep0x280x290x20const(instance, var_0);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cwchar_t0x2C0x20true0x3E0x3A0x3Ado_grouping0x280x290x20const(void *instance, u32 var_0, u32 var_1) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cwchar_t0x2C0x20true0x3E0x3A0x3Ado_grouping0x280x290x20const(instance, var_0, var_1);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cwchar_t0x2C0x20true0x3E0x3A0x3Ado_curr_symbol0x280x290x20const(void *instance, u32 var_0, u32 var_1) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cwchar_t0x2C0x20true0x3E0x3A0x3Ado_curr_symbol0x280x290x20const(instance, var_0, var_1);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cwchar_t0x2C0x20true0x3E0x3A0x3Ado_positive_sign0x280x290x20const(void *instance, u32 var_0, u32 var_1) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cwchar_t0x2C0x20true0x3E0x3A0x3Ado_positive_sign0x280x290x20const(instance, var_0, var_1);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cwchar_t0x2C0x20true0x3E0x3A0x3Ado_negative_sign0x280x290x20const(void *instance, u32 var_0, u32 var_1) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cwchar_t0x2C0x20true0x3E0x3A0x3Ado_negative_sign0x280x290x20const(instance, var_0, var_1);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cwchar_t0x2C0x20true0x3E0x3A0x3Ado_frac_digits0x280x290x20const(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cwchar_t0x2C0x20true0x3E0x3A0x3Ado_frac_digits0x280x290x20const(instance, var_0);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cwchar_t0x2C0x20true0x3E0x3A0x3Ado_pos_format0x280x290x20const(void *instance, u32 var_0, u32 var_1) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cwchar_t0x2C0x20true0x3E0x3A0x3Ado_pos_format0x280x290x20const(instance, var_0, var_1);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cwchar_t0x2C0x20true0x3E0x3A0x3Ado_neg_format0x280x290x20const(void *instance, u32 var_0, u32 var_1) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoneypunct_byname0x3Cwchar_t0x2C0x20true0x3E0x3A0x3Ado_neg_format0x280x290x20const(instance, var_0, var_1);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoney_get0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3Ado_get0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20bool0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20long0x20double0x260x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4, u32 var_5, u32 var_6) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoney_get0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3Ado_get0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20bool0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20long0x20double0x260x290x20const(instance, var_0, var_1, var_2, var_3, var_4, var_5, var_6);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fdo_nothing0x28void0x2A0x29(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fdo_nothing0x28void0x2A0x29(instance, var_0);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoney_get0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3Ado_get0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20bool0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x260x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4, u32 var_5, u32 var_6) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoney_get0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3Ado_get0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20bool0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x260x290x20const(instance, var_0, var_1, var_2, var_3, var_4, var_5, var_6);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoney_get0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3Ado_get0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20bool0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20long0x20double0x260x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4, u32 var_5, u32 var_6) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoney_get0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3Ado_get0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20bool0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20long0x20double0x260x290x20const(instance, var_0, var_1, var_2, var_3, var_4, var_5, var_6);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoney_get0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3Ado_get0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20bool0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cwchar_t0x3E0x3E0x260x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4, u32 var_5, u32 var_6) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoney_get0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3Ado_get0x28std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aistreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20bool0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20unsigned0x20int0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cwchar_t0x3E0x3E0x260x290x20const(instance, var_0, var_1, var_2, var_3, var_4, var_5, var_6);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoney_put0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3Ado_put0x28std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20bool0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20char0x2C0x20long0x20double0x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4, u64 var_5, u64 var_6) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoney_put0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3Ado_put0x28std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20bool0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20char0x2C0x20long0x20double0x290x20const(instance, var_0, var_1, var_2, var_3, var_4, var_5, var_6);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoney_put0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3Ado_put0x28std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20bool0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20char0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4, u32 var_5) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoney_put0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x3E0x3A0x3Ado_put0x28std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3E0x2C0x20bool0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20char0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x290x20const(instance, var_0, var_1, var_2, var_3, var_4, var_5);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoney_put0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3Ado_put0x28std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20bool0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20wchar_t0x2C0x20long0x20double0x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4, u64 var_5, u64 var_6) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoney_put0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3Ado_put0x28std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20bool0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20wchar_t0x2C0x20long0x20double0x290x20const(instance, var_0, var_1, var_2, var_3, var_4, var_5, var_6);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoney_put0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3Ado_put0x28std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20bool0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20wchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cwchar_t0x3E0x3E0x20const0x260x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4, u32 var_5) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amoney_put0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x3E0x3A0x3Ado_put0x28std0x3A0x3A_0x5F20x3A0x3Aostreambuf_iterator0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x3E0x2C0x20bool0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aios_base0x260x2C0x20wchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cwchar_t0x3E0x3E0x20const0x260x290x20const(instance, var_0, var_1, var_2, var_3, var_4, var_5);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amessages0x3Cchar0x3E0x3A0x3Ado_open0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Alocale0x20const0x260x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amessages0x3Cchar0x3E0x3A0x3Ado_open0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Alocale0x20const0x260x290x20const(instance, var_0, var_1, var_2);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amessages0x3Cchar0x3E0x3A0x3Ado_get0x28long0x2C0x20int0x2C0x20int0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4, u32 var_5) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amessages0x3Cchar0x3E0x3A0x3Ado_get0x28long0x2C0x20int0x2C0x20int0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x290x20const(instance, var_0, var_1, var_2, var_3, var_4, var_5);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amessages0x3Cchar0x3E0x3A0x3Ado_close0x28long0x290x20const(void *instance, u32 var_0, u32 var_1) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amessages0x3Cchar0x3E0x3A0x3Ado_close0x28long0x290x20const(instance, var_0, var_1);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amessages0x3Cwchar_t0x3E0x3A0x3Ado_open0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Alocale0x20const0x260x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amessages0x3Cwchar_t0x3E0x3A0x3Ado_open0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Alocale0x20const0x260x290x20const(instance, var_0, var_1, var_2);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amessages0x3Cwchar_t0x3E0x3A0x3Ado_get0x28long0x2C0x20int0x2C0x20int0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cwchar_t0x3E0x3E0x20const0x260x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4, u32 var_5) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amessages0x3Cwchar_t0x3E0x3A0x3Ado_get0x28long0x2C0x20int0x2C0x20int0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cwchar_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cwchar_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cwchar_t0x3E0x3E0x20const0x260x290x20const(instance, var_0, var_1, var_2, var_3, var_4, var_5);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amessages0x3Cwchar_t0x3E0x3A0x3Ado_close0x28long0x290x20const(void *instance, u32 var_0, u32 var_1) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Amessages0x3Cwchar_t0x3E0x3A0x3Ado_close0x28long0x290x20const(instance, var_0, var_1);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt_byname0x3Cchar0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3A0x7Ecodecvt_byname0x280x29(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt_byname0x3Cchar0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3A0x7Ecodecvt_byname0x280x29(instance, var_0);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt_byname0x3Cchar0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3A0x7Ecodecvt_byname0x280x290x2E1(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt_byname0x3Cchar0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3A0x7Ecodecvt_byname0x280x290x2E1(instance, var_0);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt_byname0x3Cwchar_t0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3A0x7Ecodecvt_byname0x280x29(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt_byname0x3Cwchar_t0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3A0x7Ecodecvt_byname0x280x29(instance, var_0);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt_byname0x3Cwchar_t0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3A0x7Ecodecvt_byname0x280x290x2E1(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt_byname0x3Cwchar_t0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3A0x7Ecodecvt_byname0x280x290x2E1(instance, var_0);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt_byname0x3Cchar16_t0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3A0x7Ecodecvt_byname0x280x29(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt_byname0x3Cchar16_t0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3A0x7Ecodecvt_byname0x280x29(instance, var_0);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt_byname0x3Cchar16_t0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3A0x7Ecodecvt_byname0x280x290x2E1(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt_byname0x3Cchar16_t0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3A0x7Ecodecvt_byname0x280x290x2E1(instance, var_0);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt_byname0x3Cchar32_t0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3A0x7Ecodecvt_byname0x280x29(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt_byname0x3Cchar32_t0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3A0x7Ecodecvt_byname0x280x29(instance, var_0);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt_byname0x3Cchar32_t0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3A0x7Ecodecvt_byname0x280x290x2E1(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt_byname0x3Cchar32_t0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3A0x7Ecodecvt_byname0x280x290x2E1(instance, var_0);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt_byname0x3Cchar16_t0x2C0x20char8_t0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3A0x7Ecodecvt_byname0x280x29(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt_byname0x3Cchar16_t0x2C0x20char8_t0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3A0x7Ecodecvt_byname0x280x29(instance, var_0);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt_byname0x3Cchar16_t0x2C0x20char8_t0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3A0x7Ecodecvt_byname0x280x290x2E1(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt_byname0x3Cchar16_t0x2C0x20char8_t0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3A0x7Ecodecvt_byname0x280x290x2E1(instance, var_0);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt_byname0x3Cchar32_t0x2C0x20char8_t0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3A0x7Ecodecvt_byname0x280x29(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt_byname0x3Cchar32_t0x2C0x20char8_t0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3A0x7Ecodecvt_byname0x280x29(instance, var_0);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt_byname0x3Cchar32_t0x2C0x20char8_t0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3A0x7Ecodecvt_byname0x280x290x2E1(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt_byname0x3Cchar32_t0x2C0x20char8_t0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3A0x7Ecodecvt_byname0x280x290x2E1(instance, var_0);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x3A0x3A0x7E_0x5Fimp0x280x29(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x3A0x3A0x7E_0x5Fimp0x280x29(instance, var_0);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x3A0x3A0x7E_0x5Fimp0x280x290x2E1(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3A_0x5Fimp0x3A0x3A0x7E_0x5Fimp0x280x290x2E1(instance, var_0);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3Afacet0x3A0x3A0x7Efacet0x280x29(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3Afacet0x3A0x3A0x7Efacet0x280x29(instance, var_0);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3Afacet0x3A0x3A_0x5Fon_zero_shared0x280x29(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Alocale0x3A0x3Afacet0x3A0x3A_0x5Fon_zero_shared0x280x29(instance, var_0);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acollate_byname0x3Cchar0x3E0x3A0x3A0x7Ecollate_byname0x280x29(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acollate_byname0x3Cchar0x3E0x3A0x3A0x7Ecollate_byname0x280x29(instance, var_0);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acollate_byname0x3Cchar0x3E0x3A0x3A0x7Ecollate_byname0x280x290x2E1(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acollate_byname0x3Cchar0x3E0x3A0x3A0x7Ecollate_byname0x280x290x2E1(instance, var_0);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acollate_byname0x3Cchar0x3E0x3A0x3Ado_compare0x28char0x20const0x2A0x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acollate_byname0x3Cchar0x3E0x3A0x3Ado_compare0x28char0x20const0x2A0x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x290x20const(instance, var_0, var_1, var_2, var_3, var_4);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acollate_byname0x3Cchar0x3E0x3A0x3Ado_transform0x28char0x20const0x2A0x2C0x20char0x20const0x2A0x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acollate_byname0x3Cchar0x3E0x3A0x3Ado_transform0x28char0x20const0x2A0x2C0x20char0x20const0x2A0x290x20const(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acollate_byname0x3Cwchar_t0x3E0x3A0x3A0x7Ecollate_byname0x280x29(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acollate_byname0x3Cwchar_t0x3E0x3A0x3A0x7Ecollate_byname0x280x29(instance, var_0);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acollate_byname0x3Cwchar_t0x3E0x3A0x3A0x7Ecollate_byname0x280x290x2E1(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acollate_byname0x3Cwchar_t0x3E0x3A0x3A0x7Ecollate_byname0x280x290x2E1(instance, var_0);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acollate_byname0x3Cwchar_t0x3E0x3A0x3Ado_compare0x28wchar_t0x20const0x2A0x2C0x20wchar_t0x20const0x2A0x2C0x20wchar_t0x20const0x2A0x2C0x20wchar_t0x20const0x2A0x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acollate_byname0x3Cwchar_t0x3E0x3A0x3Ado_compare0x28wchar_t0x20const0x2A0x2C0x20wchar_t0x20const0x2A0x2C0x20wchar_t0x20const0x2A0x2C0x20wchar_t0x20const0x2A0x290x20const(instance, var_0, var_1, var_2, var_3, var_4);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acollate_byname0x3Cwchar_t0x3E0x3A0x3Ado_transform0x28wchar_t0x20const0x2A0x2C0x20wchar_t0x20const0x2A0x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acollate_byname0x3Cwchar_t0x3E0x3A0x3Ado_transform0x28wchar_t0x20const0x2A0x2C0x20wchar_t0x20const0x2A0x290x20const(instance, var_0, var_1, var_2, var_3);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype0x3Cwchar_t0x3E0x3A0x3A0x7Ectype0x280x29(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype0x3Cwchar_t0x3E0x3A0x3A0x7Ectype0x280x29(instance, var_0);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype0x3Cwchar_t0x3E0x3A0x3Ado_is0x28unsigned0x20long0x2C0x20wchar_t0x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype0x3Cwchar_t0x3E0x3A0x3Ado_is0x28unsigned0x20long0x2C0x20wchar_t0x290x20const(instance, var_0, var_1, var_2);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype0x3Cwchar_t0x3E0x3A0x3Ado_is0x28wchar_t0x20const0x2A0x2C0x20wchar_t0x20const0x2A0x2C0x20unsigned0x20long0x2A0x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype0x3Cwchar_t0x3E0x3A0x3Ado_is0x28wchar_t0x20const0x2A0x2C0x20wchar_t0x20const0x2A0x2C0x20unsigned0x20long0x2A0x290x20const(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype0x3Cwchar_t0x3E0x3A0x3Ado_scan_is0x28unsigned0x20long0x2C0x20wchar_t0x20const0x2A0x2C0x20wchar_t0x20const0x2A0x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype0x3Cwchar_t0x3E0x3A0x3Ado_scan_is0x28unsigned0x20long0x2C0x20wchar_t0x20const0x2A0x2C0x20wchar_t0x20const0x2A0x290x20const(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype0x3Cwchar_t0x3E0x3A0x3Ado_scan_not0x28unsigned0x20long0x2C0x20wchar_t0x20const0x2A0x2C0x20wchar_t0x20const0x2A0x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype0x3Cwchar_t0x3E0x3A0x3Ado_scan_not0x28unsigned0x20long0x2C0x20wchar_t0x20const0x2A0x2C0x20wchar_t0x20const0x2A0x290x20const(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype0x3Cwchar_t0x3E0x3A0x3Ado_toupper0x28wchar_t0x290x20const(void *instance, u32 var_0, u32 var_1) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype0x3Cwchar_t0x3E0x3A0x3Ado_toupper0x28wchar_t0x290x20const(instance, var_0, var_1);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype0x3Cwchar_t0x3E0x3A0x3Ado_toupper0x28wchar_t0x2A0x2C0x20wchar_t0x20const0x2A0x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype0x3Cwchar_t0x3E0x3A0x3Ado_toupper0x28wchar_t0x2A0x2C0x20wchar_t0x20const0x2A0x290x20const(instance, var_0, var_1, var_2);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype0x3Cwchar_t0x3E0x3A0x3Ado_tolower0x28wchar_t0x290x20const(void *instance, u32 var_0, u32 var_1) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype0x3Cwchar_t0x3E0x3A0x3Ado_tolower0x28wchar_t0x290x20const(instance, var_0, var_1);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype0x3Cwchar_t0x3E0x3A0x3Ado_tolower0x28wchar_t0x2A0x2C0x20wchar_t0x20const0x2A0x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype0x3Cwchar_t0x3E0x3A0x3Ado_tolower0x28wchar_t0x2A0x2C0x20wchar_t0x20const0x2A0x290x20const(instance, var_0, var_1, var_2);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype0x3Cwchar_t0x3E0x3A0x3Ado_widen0x28char0x290x20const(void *instance, u32 var_0, u32 var_1) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype0x3Cwchar_t0x3E0x3A0x3Ado_widen0x28char0x290x20const(instance, var_0, var_1);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype0x3Cwchar_t0x3E0x3A0x3Ado_widen0x28char0x20const0x2A0x2C0x20char0x20const0x2A0x2C0x20wchar_t0x2A0x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype0x3Cwchar_t0x3E0x3A0x3Ado_widen0x28char0x20const0x2A0x2C0x20char0x20const0x2A0x2C0x20wchar_t0x2A0x290x20const(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype0x3Cwchar_t0x3E0x3A0x3Ado_narrow0x28wchar_t0x2C0x20char0x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype0x3Cwchar_t0x3E0x3A0x3Ado_narrow0x28wchar_t0x2C0x20char0x290x20const(instance, var_0, var_1, var_2);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype0x3Cwchar_t0x3E0x3A0x3Ado_narrow0x28wchar_t0x20const0x2A0x2C0x20wchar_t0x20const0x2A0x2C0x20char0x2C0x20char0x2A0x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype0x3Cwchar_t0x3E0x3A0x3Ado_narrow0x28wchar_t0x20const0x2A0x2C0x20wchar_t0x20const0x2A0x2C0x20char0x2C0x20char0x2A0x290x20const(instance, var_0, var_1, var_2, var_3, var_4);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype0x3Cchar0x3E0x3A0x3A0x7Ectype0x280x29(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype0x3Cchar0x3E0x3A0x3A0x7Ectype0x280x29(instance, var_0);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype0x3Cchar0x3E0x3A0x3A0x7Ectype0x280x290x2E1(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype0x3Cchar0x3E0x3A0x3A0x7Ectype0x280x290x2E1(instance, var_0);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype0x3Cchar0x3E0x3A0x3Ado_toupper0x28char0x290x20const(void *instance, u32 var_0, u32 var_1) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype0x3Cchar0x3E0x3A0x3Ado_toupper0x28char0x290x20const(instance, var_0, var_1);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype0x3Cchar0x3E0x3A0x3Ado_toupper0x28char0x2A0x2C0x20char0x20const0x2A0x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype0x3Cchar0x3E0x3A0x3Ado_toupper0x28char0x2A0x2C0x20char0x20const0x2A0x290x20const(instance, var_0, var_1, var_2);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype0x3Cchar0x3E0x3A0x3Ado_tolower0x28char0x290x20const(void *instance, u32 var_0, u32 var_1) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype0x3Cchar0x3E0x3A0x3Ado_tolower0x28char0x290x20const(instance, var_0, var_1);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype0x3Cchar0x3E0x3A0x3Ado_tolower0x28char0x2A0x2C0x20char0x20const0x2A0x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype0x3Cchar0x3E0x3A0x3Ado_tolower0x28char0x2A0x2C0x20char0x20const0x2A0x290x20const(instance, var_0, var_1, var_2);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype0x3Cchar0x3E0x3A0x3Ado_widen0x28char0x290x20const(void *instance, u32 var_0, u32 var_1) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype0x3Cchar0x3E0x3A0x3Ado_widen0x28char0x290x20const(instance, var_0, var_1);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype0x3Cchar0x3E0x3A0x3Ado_widen0x28char0x20const0x2A0x2C0x20char0x20const0x2A0x2C0x20char0x2A0x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype0x3Cchar0x3E0x3A0x3Ado_widen0x28char0x20const0x2A0x2C0x20char0x20const0x2A0x2C0x20char0x2A0x290x20const(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype0x3Cchar0x3E0x3A0x3Ado_narrow0x28char0x2C0x20char0x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype0x3Cchar0x3E0x3A0x3Ado_narrow0x28char0x2C0x20char0x290x20const(instance, var_0, var_1, var_2);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype0x3Cchar0x3E0x3A0x3Ado_narrow0x28char0x20const0x2A0x2C0x20char0x20const0x2A0x2C0x20char0x2C0x20char0x2A0x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype0x3Cchar0x3E0x3A0x3Ado_narrow0x28char0x20const0x2A0x2C0x20char0x20const0x2A0x2C0x20char0x2C0x20char0x2A0x290x20const(instance, var_0, var_1, var_2, var_3, var_4);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype_byname0x3Cchar0x3E0x3A0x3A0x7Ectype_byname0x280x29(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype_byname0x3Cchar0x3E0x3A0x3A0x7Ectype_byname0x280x29(instance, var_0);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype_byname0x3Cchar0x3E0x3A0x3Ado_toupper0x28char0x290x20const(void *instance, u32 var_0, u32 var_1) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype_byname0x3Cchar0x3E0x3A0x3Ado_toupper0x28char0x290x20const(instance, var_0, var_1);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype_byname0x3Cchar0x3E0x3A0x3Ado_toupper0x28char0x2A0x2C0x20char0x20const0x2A0x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype_byname0x3Cchar0x3E0x3A0x3Ado_toupper0x28char0x2A0x2C0x20char0x20const0x2A0x290x20const(instance, var_0, var_1, var_2);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype_byname0x3Cchar0x3E0x3A0x3Ado_tolower0x28char0x290x20const(void *instance, u32 var_0, u32 var_1) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype_byname0x3Cchar0x3E0x3A0x3Ado_tolower0x28char0x290x20const(instance, var_0, var_1);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype_byname0x3Cchar0x3E0x3A0x3Ado_tolower0x28char0x2A0x2C0x20char0x20const0x2A0x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype_byname0x3Cchar0x3E0x3A0x3Ado_tolower0x28char0x2A0x2C0x20char0x20const0x2A0x290x20const(instance, var_0, var_1, var_2);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype_byname0x3Cwchar_t0x3E0x3A0x3A0x7Ectype_byname0x280x29(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype_byname0x3Cwchar_t0x3E0x3A0x3A0x7Ectype_byname0x280x29(instance, var_0);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype_byname0x3Cwchar_t0x3E0x3A0x3Ado_is0x28unsigned0x20long0x2C0x20wchar_t0x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype_byname0x3Cwchar_t0x3E0x3A0x3Ado_is0x28unsigned0x20long0x2C0x20wchar_t0x290x20const(instance, var_0, var_1, var_2);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype_byname0x3Cwchar_t0x3E0x3A0x3Ado_is0x28wchar_t0x20const0x2A0x2C0x20wchar_t0x20const0x2A0x2C0x20unsigned0x20long0x2A0x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype_byname0x3Cwchar_t0x3E0x3A0x3Ado_is0x28wchar_t0x20const0x2A0x2C0x20wchar_t0x20const0x2A0x2C0x20unsigned0x20long0x2A0x290x20const(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype_byname0x3Cwchar_t0x3E0x3A0x3Ado_scan_is0x28unsigned0x20long0x2C0x20wchar_t0x20const0x2A0x2C0x20wchar_t0x20const0x2A0x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype_byname0x3Cwchar_t0x3E0x3A0x3Ado_scan_is0x28unsigned0x20long0x2C0x20wchar_t0x20const0x2A0x2C0x20wchar_t0x20const0x2A0x290x20const(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype_byname0x3Cwchar_t0x3E0x3A0x3Ado_scan_not0x28unsigned0x20long0x2C0x20wchar_t0x20const0x2A0x2C0x20wchar_t0x20const0x2A0x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype_byname0x3Cwchar_t0x3E0x3A0x3Ado_scan_not0x28unsigned0x20long0x2C0x20wchar_t0x20const0x2A0x2C0x20wchar_t0x20const0x2A0x290x20const(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype_byname0x3Cwchar_t0x3E0x3A0x3Ado_toupper0x28wchar_t0x290x20const(void *instance, u32 var_0, u32 var_1) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype_byname0x3Cwchar_t0x3E0x3A0x3Ado_toupper0x28wchar_t0x290x20const(instance, var_0, var_1);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype_byname0x3Cwchar_t0x3E0x3A0x3Ado_toupper0x28wchar_t0x2A0x2C0x20wchar_t0x20const0x2A0x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype_byname0x3Cwchar_t0x3E0x3A0x3Ado_toupper0x28wchar_t0x2A0x2C0x20wchar_t0x20const0x2A0x290x20const(instance, var_0, var_1, var_2);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype_byname0x3Cwchar_t0x3E0x3A0x3Ado_tolower0x28wchar_t0x290x20const(void *instance, u32 var_0, u32 var_1) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype_byname0x3Cwchar_t0x3E0x3A0x3Ado_tolower0x28wchar_t0x290x20const(instance, var_0, var_1);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype_byname0x3Cwchar_t0x3E0x3A0x3Ado_tolower0x28wchar_t0x2A0x2C0x20wchar_t0x20const0x2A0x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype_byname0x3Cwchar_t0x3E0x3A0x3Ado_tolower0x28wchar_t0x2A0x2C0x20wchar_t0x20const0x2A0x290x20const(instance, var_0, var_1, var_2);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype_byname0x3Cwchar_t0x3E0x3A0x3Ado_widen0x28char0x290x20const(void *instance, u32 var_0, u32 var_1) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype_byname0x3Cwchar_t0x3E0x3A0x3Ado_widen0x28char0x290x20const(instance, var_0, var_1);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype_byname0x3Cwchar_t0x3E0x3A0x3Ado_widen0x28char0x20const0x2A0x2C0x20char0x20const0x2A0x2C0x20wchar_t0x2A0x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype_byname0x3Cwchar_t0x3E0x3A0x3Ado_widen0x28char0x20const0x2A0x2C0x20char0x20const0x2A0x2C0x20wchar_t0x2A0x290x20const(instance, var_0, var_1, var_2, var_3);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype_byname0x3Cwchar_t0x3E0x3A0x3Ado_narrow0x28wchar_t0x2C0x20char0x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype_byname0x3Cwchar_t0x3E0x3A0x3Ado_narrow0x28wchar_t0x2C0x20char0x290x20const(instance, var_0, var_1, var_2);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype_byname0x3Cwchar_t0x3E0x3A0x3Ado_narrow0x28wchar_t0x20const0x2A0x2C0x20wchar_t0x20const0x2A0x2C0x20char0x2C0x20char0x2A0x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Actype_byname0x3Cwchar_t0x3E0x3A0x3Ado_narrow0x28wchar_t0x20const0x2A0x2C0x20wchar_t0x20const0x2A0x2C0x20char0x2C0x20char0x2A0x290x20const(instance, var_0, var_1, var_2, var_3, var_4);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3A0x7Ecodecvt0x280x29(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3A0x7Ecodecvt0x280x29(instance, var_0);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_out0x28_0x5Fmbstate_t0x260x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x260x2C0x20char0x2A0x2C0x20char0x2A0x2C0x20char0x2A0x260x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4, u32 var_5, u32 var_6, u32 var_7) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_out0x28_0x5Fmbstate_t0x260x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x260x2C0x20char0x2A0x2C0x20char0x2A0x2C0x20char0x2A0x260x290x20const(instance, var_0, var_1, var_2, var_3, var_4, var_5, var_6, var_7);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_in0x28_0x5Fmbstate_t0x260x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x260x2C0x20char0x2A0x2C0x20char0x2A0x2C0x20char0x2A0x260x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4, u32 var_5, u32 var_6, u32 var_7) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_in0x28_0x5Fmbstate_t0x260x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x260x2C0x20char0x2A0x2C0x20char0x2A0x2C0x20char0x2A0x260x290x20const(instance, var_0, var_1, var_2, var_3, var_4, var_5, var_6, var_7);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_unshift0x28_0x5Fmbstate_t0x260x2C0x20char0x2A0x2C0x20char0x2A0x2C0x20char0x2A0x260x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_unshift0x28_0x5Fmbstate_t0x260x2C0x20char0x2A0x2C0x20char0x2A0x2C0x20char0x2A0x260x290x20const(instance, var_0, var_1, var_2, var_3, var_4);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_encoding0x280x290x20const(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_encoding0x280x290x20const(instance, var_0);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_always_noconv0x280x290x20const(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_always_noconv0x280x290x20const(instance, var_0);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_length0x28_0x5Fmbstate_t0x260x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x2C0x20unsigned0x20long0x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_length0x28_0x5Fmbstate_t0x260x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x2C0x20unsigned0x20long0x290x20const(instance, var_0, var_1, var_2, var_3, var_4);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_max_length0x280x290x20const(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_max_length0x280x290x20const(instance, var_0);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cwchar_t0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3A0x7Ecodecvt0x280x29(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cwchar_t0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3A0x7Ecodecvt0x280x29(instance, var_0);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cwchar_t0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_out0x28_0x5Fmbstate_t0x260x2C0x20wchar_t0x20const0x2A0x2C0x20wchar_t0x20const0x2A0x2C0x20wchar_t0x20const0x2A0x260x2C0x20char0x2A0x2C0x20char0x2A0x2C0x20char0x2A0x260x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4, u32 var_5, u32 var_6, u32 var_7) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cwchar_t0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_out0x28_0x5Fmbstate_t0x260x2C0x20wchar_t0x20const0x2A0x2C0x20wchar_t0x20const0x2A0x2C0x20wchar_t0x20const0x2A0x260x2C0x20char0x2A0x2C0x20char0x2A0x2C0x20char0x2A0x260x290x20const(instance, var_0, var_1, var_2, var_3, var_4, var_5, var_6, var_7);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cwchar_t0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_in0x28_0x5Fmbstate_t0x260x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x260x2C0x20wchar_t0x2A0x2C0x20wchar_t0x2A0x2C0x20wchar_t0x2A0x260x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4, u32 var_5, u32 var_6, u32 var_7) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cwchar_t0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_in0x28_0x5Fmbstate_t0x260x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x260x2C0x20wchar_t0x2A0x2C0x20wchar_t0x2A0x2C0x20wchar_t0x2A0x260x290x20const(instance, var_0, var_1, var_2, var_3, var_4, var_5, var_6, var_7);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cwchar_t0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_unshift0x28_0x5Fmbstate_t0x260x2C0x20char0x2A0x2C0x20char0x2A0x2C0x20char0x2A0x260x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cwchar_t0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_unshift0x28_0x5Fmbstate_t0x260x2C0x20char0x2A0x2C0x20char0x2A0x2C0x20char0x2A0x260x290x20const(instance, var_0, var_1, var_2, var_3, var_4);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cwchar_t0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_encoding0x280x290x20const(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cwchar_t0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_encoding0x280x290x20const(instance, var_0);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cwchar_t0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_always_noconv0x280x290x20const(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cwchar_t0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_always_noconv0x280x290x20const(instance, var_0);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cwchar_t0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_length0x28_0x5Fmbstate_t0x260x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x2C0x20unsigned0x20long0x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cwchar_t0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_length0x28_0x5Fmbstate_t0x260x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x2C0x20unsigned0x20long0x290x20const(instance, var_0, var_1, var_2, var_3, var_4);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cwchar_t0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_max_length0x280x290x20const(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cwchar_t0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_max_length0x280x290x20const(instance, var_0);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar16_t0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3A0x7Ecodecvt0x280x29(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar16_t0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3A0x7Ecodecvt0x280x29(instance, var_0);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar16_t0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_out0x28_0x5Fmbstate_t0x260x2C0x20char16_t0x20const0x2A0x2C0x20char16_t0x20const0x2A0x2C0x20char16_t0x20const0x2A0x260x2C0x20char0x2A0x2C0x20char0x2A0x2C0x20char0x2A0x260x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4, u32 var_5, u32 var_6, u32 var_7) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar16_t0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_out0x28_0x5Fmbstate_t0x260x2C0x20char16_t0x20const0x2A0x2C0x20char16_t0x20const0x2A0x2C0x20char16_t0x20const0x2A0x260x2C0x20char0x2A0x2C0x20char0x2A0x2C0x20char0x2A0x260x290x20const(instance, var_0, var_1, var_2, var_3, var_4, var_5, var_6, var_7);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar16_t0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_in0x28_0x5Fmbstate_t0x260x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x260x2C0x20char16_t0x2A0x2C0x20char16_t0x2A0x2C0x20char16_t0x2A0x260x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4, u32 var_5, u32 var_6, u32 var_7) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar16_t0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_in0x28_0x5Fmbstate_t0x260x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x260x2C0x20char16_t0x2A0x2C0x20char16_t0x2A0x2C0x20char16_t0x2A0x260x290x20const(instance, var_0, var_1, var_2, var_3, var_4, var_5, var_6, var_7);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar16_t0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_unshift0x28_0x5Fmbstate_t0x260x2C0x20char0x2A0x2C0x20char0x2A0x2C0x20char0x2A0x260x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar16_t0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_unshift0x28_0x5Fmbstate_t0x260x2C0x20char0x2A0x2C0x20char0x2A0x2C0x20char0x2A0x260x290x20const(instance, var_0, var_1, var_2, var_3, var_4);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar16_t0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_encoding0x280x290x20const(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar16_t0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_encoding0x280x290x20const(instance, var_0);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar16_t0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_always_noconv0x280x290x20const(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar16_t0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_always_noconv0x280x290x20const(instance, var_0);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar16_t0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_length0x28_0x5Fmbstate_t0x260x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x2C0x20unsigned0x20long0x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar16_t0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_length0x28_0x5Fmbstate_t0x260x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x2C0x20unsigned0x20long0x290x20const(instance, var_0, var_1, var_2, var_3, var_4);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar16_t0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_max_length0x280x290x20const(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar16_t0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_max_length0x280x290x20const(instance, var_0);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar16_t0x2C0x20char8_t0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3A0x7Ecodecvt0x280x29(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar16_t0x2C0x20char8_t0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3A0x7Ecodecvt0x280x29(instance, var_0);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar16_t0x2C0x20char8_t0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_out0x28_0x5Fmbstate_t0x260x2C0x20char16_t0x20const0x2A0x2C0x20char16_t0x20const0x2A0x2C0x20char16_t0x20const0x2A0x260x2C0x20char8_t0x2A0x2C0x20char8_t0x2A0x2C0x20char8_t0x2A0x260x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4, u32 var_5, u32 var_6, u32 var_7) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar16_t0x2C0x20char8_t0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_out0x28_0x5Fmbstate_t0x260x2C0x20char16_t0x20const0x2A0x2C0x20char16_t0x20const0x2A0x2C0x20char16_t0x20const0x2A0x260x2C0x20char8_t0x2A0x2C0x20char8_t0x2A0x2C0x20char8_t0x2A0x260x290x20const(instance, var_0, var_1, var_2, var_3, var_4, var_5, var_6, var_7);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar16_t0x2C0x20char8_t0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_in0x28_0x5Fmbstate_t0x260x2C0x20char8_t0x20const0x2A0x2C0x20char8_t0x20const0x2A0x2C0x20char8_t0x20const0x2A0x260x2C0x20char16_t0x2A0x2C0x20char16_t0x2A0x2C0x20char16_t0x2A0x260x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4, u32 var_5, u32 var_6, u32 var_7) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar16_t0x2C0x20char8_t0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_in0x28_0x5Fmbstate_t0x260x2C0x20char8_t0x20const0x2A0x2C0x20char8_t0x20const0x2A0x2C0x20char8_t0x20const0x2A0x260x2C0x20char16_t0x2A0x2C0x20char16_t0x2A0x2C0x20char16_t0x2A0x260x290x20const(instance, var_0, var_1, var_2, var_3, var_4, var_5, var_6, var_7);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar16_t0x2C0x20char8_t0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_unshift0x28_0x5Fmbstate_t0x260x2C0x20char8_t0x2A0x2C0x20char8_t0x2A0x2C0x20char8_t0x2A0x260x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar16_t0x2C0x20char8_t0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_unshift0x28_0x5Fmbstate_t0x260x2C0x20char8_t0x2A0x2C0x20char8_t0x2A0x2C0x20char8_t0x2A0x260x290x20const(instance, var_0, var_1, var_2, var_3, var_4);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar16_t0x2C0x20char8_t0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_encoding0x280x290x20const(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar16_t0x2C0x20char8_t0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_encoding0x280x290x20const(instance, var_0);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar16_t0x2C0x20char8_t0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_always_noconv0x280x290x20const(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar16_t0x2C0x20char8_t0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_always_noconv0x280x290x20const(instance, var_0);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar16_t0x2C0x20char8_t0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_length0x28_0x5Fmbstate_t0x260x2C0x20char8_t0x20const0x2A0x2C0x20char8_t0x20const0x2A0x2C0x20unsigned0x20long0x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar16_t0x2C0x20char8_t0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_length0x28_0x5Fmbstate_t0x260x2C0x20char8_t0x20const0x2A0x2C0x20char8_t0x20const0x2A0x2C0x20unsigned0x20long0x290x20const(instance, var_0, var_1, var_2, var_3, var_4);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar16_t0x2C0x20char8_t0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_max_length0x280x290x20const(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar16_t0x2C0x20char8_t0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_max_length0x280x290x20const(instance, var_0);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar32_t0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3A0x7Ecodecvt0x280x29(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar32_t0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3A0x7Ecodecvt0x280x29(instance, var_0);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar32_t0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_out0x28_0x5Fmbstate_t0x260x2C0x20char32_t0x20const0x2A0x2C0x20char32_t0x20const0x2A0x2C0x20char32_t0x20const0x2A0x260x2C0x20char0x2A0x2C0x20char0x2A0x2C0x20char0x2A0x260x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4, u32 var_5, u32 var_6, u32 var_7) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar32_t0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_out0x28_0x5Fmbstate_t0x260x2C0x20char32_t0x20const0x2A0x2C0x20char32_t0x20const0x2A0x2C0x20char32_t0x20const0x2A0x260x2C0x20char0x2A0x2C0x20char0x2A0x2C0x20char0x2A0x260x290x20const(instance, var_0, var_1, var_2, var_3, var_4, var_5, var_6, var_7);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar32_t0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_in0x28_0x5Fmbstate_t0x260x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x260x2C0x20char32_t0x2A0x2C0x20char32_t0x2A0x2C0x20char32_t0x2A0x260x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4, u32 var_5, u32 var_6, u32 var_7) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar32_t0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_in0x28_0x5Fmbstate_t0x260x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x260x2C0x20char32_t0x2A0x2C0x20char32_t0x2A0x2C0x20char32_t0x2A0x260x290x20const(instance, var_0, var_1, var_2, var_3, var_4, var_5, var_6, var_7);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar32_t0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_unshift0x28_0x5Fmbstate_t0x260x2C0x20char0x2A0x2C0x20char0x2A0x2C0x20char0x2A0x260x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar32_t0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_unshift0x28_0x5Fmbstate_t0x260x2C0x20char0x2A0x2C0x20char0x2A0x2C0x20char0x2A0x260x290x20const(instance, var_0, var_1, var_2, var_3, var_4);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar32_t0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_encoding0x280x290x20const(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar32_t0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_encoding0x280x290x20const(instance, var_0);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar32_t0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_always_noconv0x280x290x20const(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar32_t0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_always_noconv0x280x290x20const(instance, var_0);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar32_t0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_length0x28_0x5Fmbstate_t0x260x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x2C0x20unsigned0x20long0x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar32_t0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_length0x28_0x5Fmbstate_t0x260x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x2C0x20unsigned0x20long0x290x20const(instance, var_0, var_1, var_2, var_3, var_4);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar32_t0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_max_length0x280x290x20const(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar32_t0x2C0x20char0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_max_length0x280x290x20const(instance, var_0);
}
static void wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar32_t0x2C0x20char8_t0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3A0x7Ecodecvt0x280x29(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar32_t0x2C0x20char8_t0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3A0x7Ecodecvt0x280x29(instance, var_0);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar32_t0x2C0x20char8_t0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_out0x28_0x5Fmbstate_t0x260x2C0x20char32_t0x20const0x2A0x2C0x20char32_t0x20const0x2A0x2C0x20char32_t0x20const0x2A0x260x2C0x20char8_t0x2A0x2C0x20char8_t0x2A0x2C0x20char8_t0x2A0x260x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4, u32 var_5, u32 var_6, u32 var_7) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar32_t0x2C0x20char8_t0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_out0x28_0x5Fmbstate_t0x260x2C0x20char32_t0x20const0x2A0x2C0x20char32_t0x20const0x2A0x2C0x20char32_t0x20const0x2A0x260x2C0x20char8_t0x2A0x2C0x20char8_t0x2A0x2C0x20char8_t0x2A0x260x290x20const(instance, var_0, var_1, var_2, var_3, var_4, var_5, var_6, var_7);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar32_t0x2C0x20char8_t0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_in0x28_0x5Fmbstate_t0x260x2C0x20char8_t0x20const0x2A0x2C0x20char8_t0x20const0x2A0x2C0x20char8_t0x20const0x2A0x260x2C0x20char32_t0x2A0x2C0x20char32_t0x2A0x2C0x20char32_t0x2A0x260x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4, u32 var_5, u32 var_6, u32 var_7) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar32_t0x2C0x20char8_t0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_in0x28_0x5Fmbstate_t0x260x2C0x20char8_t0x20const0x2A0x2C0x20char8_t0x20const0x2A0x2C0x20char8_t0x20const0x2A0x260x2C0x20char32_t0x2A0x2C0x20char32_t0x2A0x2C0x20char32_t0x2A0x260x290x20const(instance, var_0, var_1, var_2, var_3, var_4, var_5, var_6, var_7);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar32_t0x2C0x20char8_t0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_unshift0x28_0x5Fmbstate_t0x260x2C0x20char8_t0x2A0x2C0x20char8_t0x2A0x2C0x20char8_t0x2A0x260x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar32_t0x2C0x20char8_t0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_unshift0x28_0x5Fmbstate_t0x260x2C0x20char8_t0x2A0x2C0x20char8_t0x2A0x2C0x20char8_t0x2A0x260x290x20const(instance, var_0, var_1, var_2, var_3, var_4);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar32_t0x2C0x20char8_t0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_encoding0x280x290x20const(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar32_t0x2C0x20char8_t0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_encoding0x280x290x20const(instance, var_0);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar32_t0x2C0x20char8_t0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_always_noconv0x280x290x20const(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar32_t0x2C0x20char8_t0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_always_noconv0x280x290x20const(instance, var_0);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar32_t0x2C0x20char8_t0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_length0x28_0x5Fmbstate_t0x260x2C0x20char8_t0x20const0x2A0x2C0x20char8_t0x20const0x2A0x2C0x20unsigned0x20long0x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar32_t0x2C0x20char8_t0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_length0x28_0x5Fmbstate_t0x260x2C0x20char8_t0x20const0x2A0x2C0x20char8_t0x20const0x2A0x2C0x20unsigned0x20long0x290x20const(instance, var_0, var_1, var_2, var_3, var_4);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar32_t0x2C0x20char8_t0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_max_length0x280x290x20const(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3Acodecvt0x3Cchar32_t0x2C0x20char8_t0x2C0x20_0x5Fmbstate_t0x3E0x3A0x3Ado_max_length0x280x290x20const(instance, var_0);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf80x3Cwchar_t0x3E0x3A0x3Ado_out0x28_0x5Fmbstate_t0x260x2C0x20wchar_t0x20const0x2A0x2C0x20wchar_t0x20const0x2A0x2C0x20wchar_t0x20const0x2A0x260x2C0x20char0x2A0x2C0x20char0x2A0x2C0x20char0x2A0x260x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4, u32 var_5, u32 var_6, u32 var_7) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf80x3Cwchar_t0x3E0x3A0x3Ado_out0x28_0x5Fmbstate_t0x260x2C0x20wchar_t0x20const0x2A0x2C0x20wchar_t0x20const0x2A0x2C0x20wchar_t0x20const0x2A0x260x2C0x20char0x2A0x2C0x20char0x2A0x2C0x20char0x2A0x260x290x20const(instance, var_0, var_1, var_2, var_3, var_4, var_5, var_6, var_7);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf80x3Cwchar_t0x3E0x3A0x3Ado_in0x28_0x5Fmbstate_t0x260x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x260x2C0x20wchar_t0x2A0x2C0x20wchar_t0x2A0x2C0x20wchar_t0x2A0x260x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4, u32 var_5, u32 var_6, u32 var_7) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf80x3Cwchar_t0x3E0x3A0x3Ado_in0x28_0x5Fmbstate_t0x260x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x260x2C0x20wchar_t0x2A0x2C0x20wchar_t0x2A0x2C0x20wchar_t0x2A0x260x290x20const(instance, var_0, var_1, var_2, var_3, var_4, var_5, var_6, var_7);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf80x3Cwchar_t0x3E0x3A0x3Ado_unshift0x28_0x5Fmbstate_t0x260x2C0x20char0x2A0x2C0x20char0x2A0x2C0x20char0x2A0x260x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf80x3Cwchar_t0x3E0x3A0x3Ado_unshift0x28_0x5Fmbstate_t0x260x2C0x20char0x2A0x2C0x20char0x2A0x2C0x20char0x2A0x260x290x20const(instance, var_0, var_1, var_2, var_3, var_4);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf80x3Cwchar_t0x3E0x3A0x3Ado_encoding0x280x290x20const(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf80x3Cwchar_t0x3E0x3A0x3Ado_encoding0x280x290x20const(instance, var_0);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf80x3Cwchar_t0x3E0x3A0x3Ado_always_noconv0x280x290x20const(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf80x3Cwchar_t0x3E0x3A0x3Ado_always_noconv0x280x290x20const(instance, var_0);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf80x3Cwchar_t0x3E0x3A0x3Ado_length0x28_0x5Fmbstate_t0x260x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x2C0x20unsigned0x20long0x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf80x3Cwchar_t0x3E0x3A0x3Ado_length0x28_0x5Fmbstate_t0x260x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x2C0x20unsigned0x20long0x290x20const(instance, var_0, var_1, var_2, var_3, var_4);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf80x3Cwchar_t0x3E0x3A0x3Ado_max_length0x280x290x20const(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf80x3Cwchar_t0x3E0x3A0x3Ado_max_length0x280x290x20const(instance, var_0);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf80x3Cchar16_t0x3E0x3A0x3Ado_out0x28_0x5Fmbstate_t0x260x2C0x20char16_t0x20const0x2A0x2C0x20char16_t0x20const0x2A0x2C0x20char16_t0x20const0x2A0x260x2C0x20char0x2A0x2C0x20char0x2A0x2C0x20char0x2A0x260x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4, u32 var_5, u32 var_6, u32 var_7) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf80x3Cchar16_t0x3E0x3A0x3Ado_out0x28_0x5Fmbstate_t0x260x2C0x20char16_t0x20const0x2A0x2C0x20char16_t0x20const0x2A0x2C0x20char16_t0x20const0x2A0x260x2C0x20char0x2A0x2C0x20char0x2A0x2C0x20char0x2A0x260x290x20const(instance, var_0, var_1, var_2, var_3, var_4, var_5, var_6, var_7);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf80x3Cchar16_t0x3E0x3A0x3Ado_in0x28_0x5Fmbstate_t0x260x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x260x2C0x20char16_t0x2A0x2C0x20char16_t0x2A0x2C0x20char16_t0x2A0x260x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4, u32 var_5, u32 var_6, u32 var_7) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf80x3Cchar16_t0x3E0x3A0x3Ado_in0x28_0x5Fmbstate_t0x260x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x260x2C0x20char16_t0x2A0x2C0x20char16_t0x2A0x2C0x20char16_t0x2A0x260x290x20const(instance, var_0, var_1, var_2, var_3, var_4, var_5, var_6, var_7);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf80x3Cchar16_t0x3E0x3A0x3Ado_unshift0x28_0x5Fmbstate_t0x260x2C0x20char0x2A0x2C0x20char0x2A0x2C0x20char0x2A0x260x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf80x3Cchar16_t0x3E0x3A0x3Ado_unshift0x28_0x5Fmbstate_t0x260x2C0x20char0x2A0x2C0x20char0x2A0x2C0x20char0x2A0x260x290x20const(instance, var_0, var_1, var_2, var_3, var_4);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf80x3Cchar16_t0x3E0x3A0x3Ado_encoding0x280x290x20const(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf80x3Cchar16_t0x3E0x3A0x3Ado_encoding0x280x290x20const(instance, var_0);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf80x3Cchar16_t0x3E0x3A0x3Ado_always_noconv0x280x290x20const(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf80x3Cchar16_t0x3E0x3A0x3Ado_always_noconv0x280x290x20const(instance, var_0);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf80x3Cchar16_t0x3E0x3A0x3Ado_length0x28_0x5Fmbstate_t0x260x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x2C0x20unsigned0x20long0x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf80x3Cchar16_t0x3E0x3A0x3Ado_length0x28_0x5Fmbstate_t0x260x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x2C0x20unsigned0x20long0x290x20const(instance, var_0, var_1, var_2, var_3, var_4);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf80x3Cchar16_t0x3E0x3A0x3Ado_max_length0x280x290x20const(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf80x3Cchar16_t0x3E0x3A0x3Ado_max_length0x280x290x20const(instance, var_0);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf80x3Cchar32_t0x3E0x3A0x3Ado_out0x28_0x5Fmbstate_t0x260x2C0x20char32_t0x20const0x2A0x2C0x20char32_t0x20const0x2A0x2C0x20char32_t0x20const0x2A0x260x2C0x20char0x2A0x2C0x20char0x2A0x2C0x20char0x2A0x260x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4, u32 var_5, u32 var_6, u32 var_7) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf80x3Cchar32_t0x3E0x3A0x3Ado_out0x28_0x5Fmbstate_t0x260x2C0x20char32_t0x20const0x2A0x2C0x20char32_t0x20const0x2A0x2C0x20char32_t0x20const0x2A0x260x2C0x20char0x2A0x2C0x20char0x2A0x2C0x20char0x2A0x260x290x20const(instance, var_0, var_1, var_2, var_3, var_4, var_5, var_6, var_7);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf80x3Cchar32_t0x3E0x3A0x3Ado_in0x28_0x5Fmbstate_t0x260x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x260x2C0x20char32_t0x2A0x2C0x20char32_t0x2A0x2C0x20char32_t0x2A0x260x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4, u32 var_5, u32 var_6, u32 var_7) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf80x3Cchar32_t0x3E0x3A0x3Ado_in0x28_0x5Fmbstate_t0x260x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x260x2C0x20char32_t0x2A0x2C0x20char32_t0x2A0x2C0x20char32_t0x2A0x260x290x20const(instance, var_0, var_1, var_2, var_3, var_4, var_5, var_6, var_7);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf80x3Cchar32_t0x3E0x3A0x3Ado_unshift0x28_0x5Fmbstate_t0x260x2C0x20char0x2A0x2C0x20char0x2A0x2C0x20char0x2A0x260x290x20const(void *instance, u32 var_0, u32 var_1, u32 var_2, u32 var_3, u32 var_4) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf80x3Cchar32_t0x3E0x3A0x3Ado_unshift0x28_0x5Fmbstate_t0x260x2C0x20char0x2A0x2C0x20char0x2A0x2C0x20char0x2A0x260x290x20const(instance, var_0, var_1, var_2, var_3, var_4);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf80x3Cchar32_t0x3E0x3A0x3Ado_encoding0x280x290x20const(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf80x3Cchar32_t0x3E0x3A0x3Ado_encoding0x280x290x20const(instance, var_0);
}
static u32 wrap_w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf80x3Cchar32_t0x3E0x3A0x3Ado_always_noconv0x280x290x20const(void *instance, u32 var_0) {
  return w2c_rlbox_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcodecvt_utf80x3Cchar32_t0x3E0x3A0x3Ado_a