/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim:set ts=2 sw=2 sts=2 et cindent: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/* THIS FILE IS AUTOGENERATED FROM PluginCrashedEvent.webidl BY Codegen.py - DO NOT EDIT */

#include "EventBinding.h"
#include "PluginCrashedEvent.h"
#include "PluginCrashedEventBinding.h"
#include "js/GCAPI.h"
#include "mozilla/HoldDropJSObjects.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PluginCrashedEvent.h"
#include "mozilla/dom/PrimitiveConversions.h"

namespace mozilla::dom {


PluginCrashedEvent::PluginCrashedEvent(mozilla::dom::EventTarget* aOwner)
  : Event(aOwner, nullptr, nullptr)
{
}

PluginCrashedEvent::~PluginCrashedEvent()
{
}

PluginCrashedEvent*
PluginCrashedEvent::AsPluginCrashedEvent()
{
  return this;
}

JSObject*
PluginCrashedEvent::WrapObjectInternal(JSContext* aCx, JS::Handle<JSObject*> aGivenProto)
{
  return PluginCrashedEvent_Binding::Wrap(aCx, this, aGivenProto);
}

already_AddRefed<PluginCrashedEvent>
PluginCrashedEvent::Constructor(mozilla::dom::EventTarget* aOwner, const nsAString& aType, const PluginCrashedEventInit& aEventInitDict)
{
  RefPtr<PluginCrashedEvent> e = new PluginCrashedEvent(aOwner);
  bool trusted = e->Init(aOwner);
  e->InitEvent(aType, aEventInitDict.mBubbles, aEventInitDict.mCancelable);
  e->mPluginID = aEventInitDict.mPluginID;
  e->mPluginDumpID = aEventInitDict.mPluginDumpID;
  e->mPluginName = aEventInitDict.mPluginName;
  e->mPluginFilename = aEventInitDict.mPluginFilename;
  e->mSubmittedCrashReport = aEventInitDict.mSubmittedCrashReport;
  e->mGmpPlugin = aEventInitDict.mGmpPlugin;
  e->SetTrusted(trusted);
  e->SetComposed(aEventInitDict.mComposed);
  return e.forget();
}

already_AddRefed<PluginCrashedEvent>
PluginCrashedEvent::Constructor(const GlobalObject& aGlobal, const nsAString& aType, const PluginCrashedEventInit& aEventInitDict)
{
  nsCOMPtr<mozilla::dom::EventTarget> owner = do_QueryInterface(aGlobal.GetAsSupports());
  return Constructor(owner, aType, aEventInitDict);
}

uint32_t
PluginCrashedEvent::PluginID() const
{
  return mPluginID;
}

void
PluginCrashedEvent::GetPluginDumpID(nsString& aRetVal) const
{
  aRetVal = mPluginDumpID;
}

void
PluginCrashedEvent::GetPluginName(nsString& aRetVal) const
{
  aRetVal = mPluginName;
}

void
PluginCrashedEvent::GetPluginFilename(nsString& aRetVal) const
{
  aRetVal = mPluginFilename;
}

bool
PluginCrashedEvent::SubmittedCrashReport() const
{
  return mSubmittedCrashReport;
}

bool
PluginCrashedEvent::GmpPlugin() const
{
  return mGmpPlugin;
}


} // namespace mozilla::dom
