/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

// AllowedRoutesApplyConfiguration represents a declarative configuration of the AllowedRoutes type for use
// with apply.
type AllowedRoutesApplyConfiguration struct {
	Namespaces *RouteNamespacesApplyConfiguration `json:"namespaces,omitempty"`
	Kinds      []RouteGroupKindApplyConfiguration `json:"kinds,omitempty"`
}

// AllowedRoutesApplyConfiguration constructs a declarative configuration of the AllowedRoutes type for use with
// apply.
func AllowedRoutes() *AllowedRoutesApplyConfiguration {
	return &AllowedRoutesApplyConfiguration{}
}

// WithNamespaces sets the Namespaces field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Namespaces field is set to the value of the last call.
func (b *AllowedRoutesApplyConfiguration) WithNamespaces(value *RouteNamespacesApplyConfiguration) *AllowedRoutesApplyConfiguration {
	b.Namespaces = value
	return b
}

// WithKinds adds the given value to the Kinds field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Kinds field.
func (b *AllowedRoutesApplyConfiguration) WithKinds(values ...*RouteGroupKindApplyConfiguration) *AllowedRoutesApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithKinds")
		}
		b.Kinds = append(b.Kinds, *values[i])
	}
	return b
}
