/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1alpha3

import (
	labels "k8s.io/apimachinery/pkg/labels"
	listers "k8s.io/client-go/listers"
	cache "k8s.io/client-go/tools/cache"
	apisv1alpha3 "sigs.k8s.io/gateway-api/apis/v1alpha3"
)

// TLSRouteLister helps list TLSRoutes.
// All objects returned here must be treated as read-only.
type TLSRouteLister interface {
	// List lists all TLSRoutes in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*apisv1alpha3.TLSRoute, err error)
	// TLSRoutes returns an object that can list and get TLSRoutes.
	TLSRoutes(namespace string) TLSRouteNamespaceLister
	TLSRouteListerExpansion
}

// tLSRouteLister implements the TLSRouteLister interface.
type tLSRouteLister struct {
	listers.ResourceIndexer[*apisv1alpha3.TLSRoute]
}

// NewTLSRouteLister returns a new TLSRouteLister.
func NewTLSRouteLister(indexer cache.Indexer) TLSRouteLister {
	return &tLSRouteLister{listers.New[*apisv1alpha3.TLSRoute](indexer, apisv1alpha3.Resource("tlsroute"))}
}

// TLSRoutes returns an object that can list and get TLSRoutes.
func (s *tLSRouteLister) TLSRoutes(namespace string) TLSRouteNamespaceLister {
	return tLSRouteNamespaceLister{listers.NewNamespaced[*apisv1alpha3.TLSRoute](s.ResourceIndexer, namespace)}
}

// TLSRouteNamespaceLister helps list and get TLSRoutes.
// All objects returned here must be treated as read-only.
type TLSRouteNamespaceLister interface {
	// List lists all TLSRoutes in the indexer for a given namespace.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*apisv1alpha3.TLSRoute, err error)
	// Get retrieves the TLSRoute from the indexer for a given namespace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*apisv1alpha3.TLSRoute, error)
	TLSRouteNamespaceListerExpansion
}

// tLSRouteNamespaceLister implements the TLSRouteNamespaceLister
// interface.
type tLSRouteNamespaceLister struct {
	listers.ResourceIndexer[*apisv1alpha3.TLSRoute]
}
