//
// Copyright 2023 Pixar
//
// Licensed under the terms set forth in the LICENSE.txt file available at
// https://openusd.org/license.
//
////////////////////////////////////////////////////////////////////////

/* ************************************************************************** */
/* **                                                                      ** */
/* ** This file is generated by a script.                                  ** */
/* **                                                                      ** */
/* ** Do not edit it directly (unless it is within a CUSTOM CODE section)! ** */
/* ** Edit hdSchemaDefs.py instead to make changes.                        ** */
/* **                                                                      ** */
/* ************************************************************************** */

#include "pxr/imaging/hd/planeSchema.h"

#include "pxr/imaging/hd/retainedDataSource.h"

#include "pxr/base/trace/trace.h"

// --(BEGIN CUSTOM CODE: Includes)--
// --(END CUSTOM CODE: Includes)--

PXR_NAMESPACE_OPEN_SCOPE

TF_DEFINE_PUBLIC_TOKENS(HdPlaneSchemaTokens,
    HD_PLANE_SCHEMA_TOKENS);

// --(BEGIN CUSTOM CODE: Schema Methods)--
// --(END CUSTOM CODE: Schema Methods)--

HdBoolDataSourceHandle
HdPlaneSchema::GetDoubleSided() const
{
    return _GetTypedDataSource<HdBoolDataSource>(
        HdPlaneSchemaTokens->doubleSided);
}

HdTokenDataSourceHandle
HdPlaneSchema::GetAxis() const
{
    return _GetTypedDataSource<HdTokenDataSource>(
        HdPlaneSchemaTokens->axis);
}

HdDoubleDataSourceHandle
HdPlaneSchema::GetLength() const
{
    return _GetTypedDataSource<HdDoubleDataSource>(
        HdPlaneSchemaTokens->length);
}

HdDoubleDataSourceHandle
HdPlaneSchema::GetWidth() const
{
    return _GetTypedDataSource<HdDoubleDataSource>(
        HdPlaneSchemaTokens->width);
}

/*static*/
HdContainerDataSourceHandle
HdPlaneSchema::BuildRetained(
        const HdBoolDataSourceHandle &doubleSided,
        const HdTokenDataSourceHandle &axis,
        const HdDoubleDataSourceHandle &length,
        const HdDoubleDataSourceHandle &width
)
{
    TfToken _names[4];
    HdDataSourceBaseHandle _values[4];

    size_t _count = 0;

    if (doubleSided) {
        _names[_count] = HdPlaneSchemaTokens->doubleSided;
        _values[_count++] = doubleSided;
    }

    if (axis) {
        _names[_count] = HdPlaneSchemaTokens->axis;
        _values[_count++] = axis;
    }

    if (length) {
        _names[_count] = HdPlaneSchemaTokens->length;
        _values[_count++] = length;
    }

    if (width) {
        _names[_count] = HdPlaneSchemaTokens->width;
        _values[_count++] = width;
    }
    return HdRetainedContainerDataSource::New(_count, _names, _values);
}

HdPlaneSchema::Builder &
HdPlaneSchema::Builder::SetDoubleSided(
    const HdBoolDataSourceHandle &doubleSided)
{
    _doubleSided = doubleSided;
    return *this;
}

HdPlaneSchema::Builder &
HdPlaneSchema::Builder::SetAxis(
    const HdTokenDataSourceHandle &axis)
{
    _axis = axis;
    return *this;
}

HdPlaneSchema::Builder &
HdPlaneSchema::Builder::SetLength(
    const HdDoubleDataSourceHandle &length)
{
    _length = length;
    return *this;
}

HdPlaneSchema::Builder &
HdPlaneSchema::Builder::SetWidth(
    const HdDoubleDataSourceHandle &width)
{
    _width = width;
    return *this;
}

HdContainerDataSourceHandle
HdPlaneSchema::Builder::Build()
{
    return HdPlaneSchema::BuildRetained(
        _doubleSided,
        _axis,
        _length,
        _width
    );
}

/*static*/
HdPlaneSchema
HdPlaneSchema::GetFromParent(
        const HdContainerDataSourceHandle &fromParentContainer)
{
    return HdPlaneSchema(
        fromParentContainer
        ? HdContainerDataSource::Cast(fromParentContainer->Get(
                HdPlaneSchemaTokens->plane))
        : nullptr);
}

/*static*/
const TfToken &
HdPlaneSchema::GetSchemaToken()
{
    return HdPlaneSchemaTokens->plane;
}

/*static*/
const HdDataSourceLocator &
HdPlaneSchema::GetDefaultLocator()
{
    static const HdDataSourceLocator locator(GetSchemaToken());
    return locator;
}

/*static*/
HdTokenDataSourceHandle
HdPlaneSchema::BuildAxisDataSource(
    const TfToken &axis)
{

    if (axis == HdPlaneSchemaTokens->X) {
        static const HdRetainedTypedSampledDataSource<TfToken>::Handle ds =
            HdRetainedTypedSampledDataSource<TfToken>::New(axis);
        return ds;
    }
    if (axis == HdPlaneSchemaTokens->Y) {
        static const HdRetainedTypedSampledDataSource<TfToken>::Handle ds =
            HdRetainedTypedSampledDataSource<TfToken>::New(axis);
        return ds;
    }
    if (axis == HdPlaneSchemaTokens->Z) {
        static const HdRetainedTypedSampledDataSource<TfToken>::Handle ds =
            HdRetainedTypedSampledDataSource<TfToken>::New(axis);
        return ds;
    }
    // fallback for unknown token
    return HdRetainedTypedSampledDataSource<TfToken>::New(axis);
} 

PXR_NAMESPACE_CLOSE_SCOPE