/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(FULLSCREEN_API)

#include "JSFullscreenOptions.h"

#include "JSDOMConvertOptional.h"
#include "ScriptExecutionContext.h"
#include "Settings.h"
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/NeverDestroyed.h>
#include <wtf/SortedArrayMap.h>



namespace WebCore {
using namespace JSC;

#if ENABLE(FULLSCREEN_API)

template<> ConversionResult<IDLDictionary<FullscreenOptions>> convertDictionary<FullscreenOptions>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (!isNullOrUndefined && !object) [[unlikely]] {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    FullscreenOptions result;
    if (jsCast<JSDOMGlobalObject*>(&lexicalGlobalObject)->scriptExecutionContext()->settingsValues().fullScreenKeyboardLock) {
        JSValue keyboardLockValue;
        if (isNullOrUndefined)
            keyboardLockValue = jsUndefined();
        else {
            keyboardLockValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "keyboardLock"_s));
            RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
        }
        auto keyboardLockConversionResult = convertOptionalWithDefault<IDLEnumeration<FullscreenOptions::KeyboardLock>>(lexicalGlobalObject, keyboardLockValue, [&]() -> ConversionResult<IDLEnumeration<FullscreenOptions::KeyboardLock>> { return Converter<IDLEnumeration<FullscreenOptions::KeyboardLock>>::ReturnType { FullscreenOptions::KeyboardLock::None }; });
        if (keyboardLockConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.keyboardLock = keyboardLockConversionResult.releaseReturnValue();
    }
    JSValue navigationUIValue;
    if (isNullOrUndefined)
        navigationUIValue = jsUndefined();
    else {
        navigationUIValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "navigationUI"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto navigationUIConversionResult = convertOptionalWithDefault<IDLEnumeration<FullscreenOptions::NavigationUI>>(lexicalGlobalObject, navigationUIValue, [&]() -> ConversionResult<IDLEnumeration<FullscreenOptions::NavigationUI>> { return Converter<IDLEnumeration<FullscreenOptions::NavigationUI>>::ReturnType { FullscreenOptions::NavigationUI::Auto }; });
    if (navigationUIConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.navigationUI = navigationUIConversionResult.releaseReturnValue();
    return result;
}

#endif

#if ENABLE(FULLSCREEN_API)

String convertEnumerationToString(FullscreenOptions::NavigationUI enumerationValue)
{
    static const std::array<NeverDestroyed<String>, 3> values {
        MAKE_STATIC_STRING_IMPL("auto"),
        MAKE_STATIC_STRING_IMPL("show"),
        MAKE_STATIC_STRING_IMPL("hide"),
    };
    static_assert(static_cast<size_t>(FullscreenOptions::NavigationUI::Auto) == 0, "FullscreenOptions::NavigationUI::Auto is not 0 as expected");
    static_assert(static_cast<size_t>(FullscreenOptions::NavigationUI::Show) == 1, "FullscreenOptions::NavigationUI::Show is not 1 as expected");
    static_assert(static_cast<size_t>(FullscreenOptions::NavigationUI::Hide) == 2, "FullscreenOptions::NavigationUI::Hide is not 2 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, FullscreenOptions::NavigationUI enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<FullscreenOptions::NavigationUI> parseEnumerationFromString<FullscreenOptions::NavigationUI>(const String& stringValue)
{
    static constexpr std::array<std::pair<ComparableASCIILiteral, FullscreenOptions::NavigationUI>, 3> mappings {
        std::pair<ComparableASCIILiteral, FullscreenOptions::NavigationUI> { "auto"_s, FullscreenOptions::NavigationUI::Auto },
        std::pair<ComparableASCIILiteral, FullscreenOptions::NavigationUI> { "hide"_s, FullscreenOptions::NavigationUI::Hide },
        std::pair<ComparableASCIILiteral, FullscreenOptions::NavigationUI> { "show"_s, FullscreenOptions::NavigationUI::Show },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); enumerationValue) [[likely]]
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<FullscreenOptions::NavigationUI> parseEnumeration<FullscreenOptions::NavigationUI>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<FullscreenOptions::NavigationUI>(value.toWTFString(&lexicalGlobalObject));
}

template<> ASCIILiteral expectedEnumerationValues<FullscreenOptions::NavigationUI>()
{
    return "\"auto\", \"show\", \"hide\""_s;
}

#endif

#if ENABLE(FULLSCREEN_API)

String convertEnumerationToString(FullscreenOptions::KeyboardLock enumerationValue)
{
    static const std::array<NeverDestroyed<String>, 3> values {
        MAKE_STATIC_STRING_IMPL("none"),
        MAKE_STATIC_STRING_IMPL("browser"),
        MAKE_STATIC_STRING_IMPL("system"),
    };
    static_assert(static_cast<size_t>(FullscreenOptions::KeyboardLock::None) == 0, "FullscreenOptions::KeyboardLock::None is not 0 as expected");
    static_assert(static_cast<size_t>(FullscreenOptions::KeyboardLock::Browser) == 1, "FullscreenOptions::KeyboardLock::Browser is not 1 as expected");
    static_assert(static_cast<size_t>(FullscreenOptions::KeyboardLock::System) == 2, "FullscreenOptions::KeyboardLock::System is not 2 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, FullscreenOptions::KeyboardLock enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<FullscreenOptions::KeyboardLock> parseEnumerationFromString<FullscreenOptions::KeyboardLock>(const String& stringValue)
{
    static constexpr std::array<std::pair<ComparableASCIILiteral, FullscreenOptions::KeyboardLock>, 3> mappings {
        std::pair<ComparableASCIILiteral, FullscreenOptions::KeyboardLock> { "browser"_s, FullscreenOptions::KeyboardLock::Browser },
        std::pair<ComparableASCIILiteral, FullscreenOptions::KeyboardLock> { "none"_s, FullscreenOptions::KeyboardLock::None },
        std::pair<ComparableASCIILiteral, FullscreenOptions::KeyboardLock> { "system"_s, FullscreenOptions::KeyboardLock::System },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); enumerationValue) [[likely]]
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<FullscreenOptions::KeyboardLock> parseEnumeration<FullscreenOptions::KeyboardLock>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<FullscreenOptions::KeyboardLock>(value.toWTFString(&lexicalGlobalObject));
}

template<> ASCIILiteral expectedEnumerationValues<FullscreenOptions::KeyboardLock>()
{
    return "\"none\", \"browser\", \"system\""_s;
}

#endif

} // namespace WebCore


#endif // ENABLE(FULLSCREEN_API)
