﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/workspaces-instances/WorkspacesInstances_EXPORTS.h>
#include <aws/workspaces-instances/model/BillingMode.h>
#include <aws/workspaces-instances/model/InstanceConfigurationTenancyEnum.h>
#include <aws/workspaces-instances/model/PlatformTypeEnum.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace WorkspacesInstances {
namespace Model {

/**
 * <p>Defines filtering criteria for WorkSpace Instance type searches. Combines
 * multiple filter conditions including billing mode, platform type, and tenancy to
 * help customers find instance types that meet their specific
 * requirements.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/workspaces-instances-2022-07-26/InstanceConfigurationFilter">AWS
 * API Reference</a></p>
 */
class InstanceConfigurationFilter {
 public:
  AWS_WORKSPACESINSTANCES_API InstanceConfigurationFilter() = default;
  AWS_WORKSPACESINSTANCES_API InstanceConfigurationFilter(Aws::Utils::Json::JsonView jsonValue);
  AWS_WORKSPACESINSTANCES_API InstanceConfigurationFilter& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_WORKSPACESINSTANCES_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>Filters WorkSpace Instance types based on supported billing modes. Allows
   * customers to search for instance types that support their preferred billing
   * model, such as HOURLY or MONTHLY billing.</p>
   */
  inline BillingMode GetBillingMode() const { return m_billingMode; }
  inline bool BillingModeHasBeenSet() const { return m_billingModeHasBeenSet; }
  inline void SetBillingMode(BillingMode value) {
    m_billingModeHasBeenSet = true;
    m_billingMode = value;
  }
  inline InstanceConfigurationFilter& WithBillingMode(BillingMode value) {
    SetBillingMode(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Filters WorkSpace Instance types by operating system platform. Allows
   * customers to find instances that support their desired OS, such as Windows,
   * Linux/UNIX, Ubuntu Pro, RHEL, or SUSE.</p>
   */
  inline PlatformTypeEnum GetPlatformType() const { return m_platformType; }
  inline bool PlatformTypeHasBeenSet() const { return m_platformTypeHasBeenSet; }
  inline void SetPlatformType(PlatformTypeEnum value) {
    m_platformTypeHasBeenSet = true;
    m_platformType = value;
  }
  inline InstanceConfigurationFilter& WithPlatformType(PlatformTypeEnum value) {
    SetPlatformType(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Filters WorkSpace Instance types by tenancy model. Allows customers to find
   * instances that match their tenancy requirements, such as SHARED or
   * DEDICATED.</p>
   */
  inline InstanceConfigurationTenancyEnum GetTenancy() const { return m_tenancy; }
  inline bool TenancyHasBeenSet() const { return m_tenancyHasBeenSet; }
  inline void SetTenancy(InstanceConfigurationTenancyEnum value) {
    m_tenancyHasBeenSet = true;
    m_tenancy = value;
  }
  inline InstanceConfigurationFilter& WithTenancy(InstanceConfigurationTenancyEnum value) {
    SetTenancy(value);
    return *this;
  }
  ///@}
 private:
  BillingMode m_billingMode{BillingMode::NOT_SET};

  PlatformTypeEnum m_platformType{PlatformTypeEnum::NOT_SET};

  InstanceConfigurationTenancyEnum m_tenancy{InstanceConfigurationTenancyEnum::NOT_SET};
  bool m_billingModeHasBeenSet = false;
  bool m_platformTypeHasBeenSet = false;
  bool m_tenancyHasBeenSet = false;
};

}  // namespace Model
}  // namespace WorkspacesInstances
}  // namespace Aws
