# --------------------------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
#
# Code generated by aaz-dev-tools
# --------------------------------------------------------------------------------------------

# pylint: skip-file
# flake8: noqa

from azure.cli.core.aaz import *


@register_command(
    "servicebus topic subscription rule show",
)
class Show(AAZCommand):
    """Get the description for the specified rule.
    """

    _aaz_info = {
        "version": "2022-10-01-preview",
        "resources": [
            ["mgmt-plane", "/subscriptions/{}/resourcegroups/{}/providers/microsoft.servicebus/namespaces/{}/topics/{}/subscriptions/{}/rules/{}", "2022-10-01-preview"],
        ]
    }

    def _handler(self, command_args):
        super()._handler(command_args)
        self._execute_operations()
        return self._output()

    _args_schema = None

    @classmethod
    def _build_arguments_schema(cls, *args, **kwargs):
        if cls._args_schema is not None:
            return cls._args_schema
        cls._args_schema = super()._build_arguments_schema(*args, **kwargs)

        # define Arg Group ""

        _args_schema = cls._args_schema
        _args_schema.namespace_name = AAZStrArg(
            options=["--namespace-name"],
            help="The namespace name",
            required=True,
            id_part="name",
            fmt=AAZStrArgFormat(
                max_length=50,
                min_length=6,
            ),
        )
        _args_schema.resource_group = AAZResourceGroupNameArg(
            required=True,
        )
        _args_schema.rule_name = AAZStrArg(
            options=["-n", "--name", "--rule-name"],
            help="The rule name.",
            required=True,
            id_part="child_name_3",
            fmt=AAZStrArgFormat(
                max_length=50,
                min_length=1,
            ),
        )
        _args_schema.subscription_name = AAZStrArg(
            options=["--subscription-name"],
            help="The subscription name.",
            required=True,
            id_part="child_name_2",
            fmt=AAZStrArgFormat(
                max_length=50,
                min_length=1,
            ),
        )
        _args_schema.topic_name = AAZStrArg(
            options=["--topic-name"],
            help="The topic name.",
            required=True,
            id_part="child_name_1",
            fmt=AAZStrArgFormat(
                min_length=1,
            ),
        )
        return cls._args_schema

    def _execute_operations(self):
        self.pre_operations()
        self.RulesGet(ctx=self.ctx)()
        self.post_operations()

    @register_callback
    def pre_operations(self):
        pass

    @register_callback
    def post_operations(self):
        pass

    def _output(self, *args, **kwargs):
        result = self.deserialize_output(self.ctx.vars.instance, client_flatten=True)
        return result

    class RulesGet(AAZHttpOperation):
        CLIENT_TYPE = "MgmtClient"

        def __call__(self, *args, **kwargs):
            request = self.make_request()
            session = self.client.send_request(request=request, stream=False, **kwargs)
            if session.http_response.status_code in [200]:
                return self.on_200(session)

            return self.on_error(session.http_response)

        @property
        def url(self):
            return self.client.format_url(
                "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/topics/{topicName}/subscriptions/{subscriptionName}/rules/{ruleName}",
                **self.url_parameters
            )

        @property
        def method(self):
            return "GET"

        @property
        def error_format(self):
            return "MgmtErrorFormat"

        @property
        def url_parameters(self):
            parameters = {
                **self.serialize_url_param(
                    "namespaceName", self.ctx.args.namespace_name,
                    required=True,
                ),
                **self.serialize_url_param(
                    "resourceGroupName", self.ctx.args.resource_group,
                    required=True,
                ),
                **self.serialize_url_param(
                    "ruleName", self.ctx.args.rule_name,
                    required=True,
                ),
                **self.serialize_url_param(
                    "subscriptionId", self.ctx.subscription_id,
                    required=True,
                ),
                **self.serialize_url_param(
                    "subscriptionName", self.ctx.args.subscription_name,
                    required=True,
                ),
                **self.serialize_url_param(
                    "topicName", self.ctx.args.topic_name,
                    required=True,
                ),
            }
            return parameters

        @property
        def query_parameters(self):
            parameters = {
                **self.serialize_query_param(
                    "api-version", "2022-10-01-preview",
                    required=True,
                ),
            }
            return parameters

        @property
        def header_parameters(self):
            parameters = {
                **self.serialize_header_param(
                    "Accept", "application/json",
                ),
            }
            return parameters

        def on_200(self, session):
            data = self.deserialize_http_content(session)
            self.ctx.set_var(
                "instance",
                data,
                schema_builder=self._build_schema_on_200
            )

        _schema_on_200 = None

        @classmethod
        def _build_schema_on_200(cls):
            if cls._schema_on_200 is not None:
                return cls._schema_on_200

            cls._schema_on_200 = AAZObjectType()

            _schema_on_200 = cls._schema_on_200
            _schema_on_200.id = AAZStrType(
                flags={"read_only": True},
            )
            _schema_on_200.location = AAZStrType(
                flags={"read_only": True},
            )
            _schema_on_200.name = AAZStrType(
                flags={"read_only": True},
            )
            _schema_on_200.properties = AAZObjectType(
                flags={"client_flatten": True},
            )
            _schema_on_200.system_data = AAZObjectType(
                serialized_name="systemData",
                flags={"read_only": True},
            )
            _schema_on_200.type = AAZStrType(
                flags={"read_only": True},
            )

            properties = cls._schema_on_200.properties
            properties.action = AAZObjectType()
            properties.correlation_filter = AAZObjectType(
                serialized_name="correlationFilter",
            )
            properties.filter_type = AAZStrType(
                serialized_name="filterType",
            )
            properties.sql_filter = AAZObjectType(
                serialized_name="sqlFilter",
            )

            action = cls._schema_on_200.properties.action
            action.compatibility_level = AAZIntType(
                serialized_name="compatibilityLevel",
            )
            action.requires_preprocessing = AAZBoolType(
                serialized_name="requiresPreprocessing",
            )
            action.sql_expression = AAZStrType(
                serialized_name="sqlExpression",
            )

            correlation_filter = cls._schema_on_200.properties.correlation_filter
            correlation_filter.content_type = AAZStrType(
                serialized_name="contentType",
            )
            correlation_filter.correlation_id = AAZStrType(
                serialized_name="correlationId",
            )
            correlation_filter.label = AAZStrType()
            correlation_filter.message_id = AAZStrType(
                serialized_name="messageId",
            )
            correlation_filter.properties = AAZDictType()
            correlation_filter.reply_to = AAZStrType(
                serialized_name="replyTo",
            )
            correlation_filter.reply_to_session_id = AAZStrType(
                serialized_name="replyToSessionId",
            )
            correlation_filter.requires_preprocessing = AAZBoolType(
                serialized_name="requiresPreprocessing",
            )
            correlation_filter.session_id = AAZStrType(
                serialized_name="sessionId",
            )
            correlation_filter.to = AAZStrType()

            properties = cls._schema_on_200.properties.correlation_filter.properties
            properties.Element = AAZStrType()

            sql_filter = cls._schema_on_200.properties.sql_filter
            sql_filter.compatibility_level = AAZIntType(
                serialized_name="compatibilityLevel",
            )
            sql_filter.requires_preprocessing = AAZBoolType(
                serialized_name="requiresPreprocessing",
            )
            sql_filter.sql_expression = AAZStrType(
                serialized_name="sqlExpression",
            )

            system_data = cls._schema_on_200.system_data
            system_data.created_at = AAZStrType(
                serialized_name="createdAt",
            )
            system_data.created_by = AAZStrType(
                serialized_name="createdBy",
            )
            system_data.created_by_type = AAZStrType(
                serialized_name="createdByType",
            )
            system_data.last_modified_at = AAZStrType(
                serialized_name="lastModifiedAt",
            )
            system_data.last_modified_by = AAZStrType(
                serialized_name="lastModifiedBy",
            )
            system_data.last_modified_by_type = AAZStrType(
                serialized_name="lastModifiedByType",
            )

            return cls._schema_on_200


class _ShowHelper:
    """Helper class for Show"""


__all__ = ["Show"]
