/* http://keith-wood.name/svg.html
   SVG graphing extension for jQuery v1.4.5.
   Written by Keith Wood (kbwood{at}iinet.com.au) August 2007.
   Dual licensed under the GPL (http://dev.jquery.com/browser/trunk/jquery/GPL-LICENSE.txt) and
   MIT (http://dev.jquery.com/browser/trunk/jquery/MIT-LICENSE.txt) licenses.
   Please attribute the author if you use it. */
(function($){$.svg.addExtension('graph',SVGGraph);$.svg.graphing=new SVGGraphing();function SVGGraphing(){this.regional=[];this.regional['']={percentageText:'Percentage'};this.region=this.regional['']}$.extend(SVGGraphing.prototype,{_chartTypes:[],addChartType:function(a,b){this._chartTypes[a]=b},chartTypes:function(){return this._chartTypes}});function SVGGraph(a){this._wrapper=a;this._drawNow=false;for(var b in $.svg.graphing._chartTypes){this._chartType=$.svg.graphing._chartTypes[b];break}this._chartOptions={};this._title={value:'',offset:25,settings:{textAnchor:'middle'}};this._area=[0.1,0.1,0.8,0.9];this._chartFormat={fill:'none',stroke:'black'};this._gridlines=[];this._series=[];this._onstatus=null;this._chartCont=this._wrapper.svg(0,0,0,0,{class_:'svg-graph'});this.xAxis=new SVGGraphAxis(this);this.xAxis.title('',40);this.yAxis=new SVGGraphAxis(this);this.yAxis.title('',40);this.x2Axis=null;this.y2Axis=null;this.legend=new SVGGraphLegend(this);this._drawNow=true}$.extend(SVGGraph.prototype,{X:0,Y:1,W:2,H:3,L:0,T:1,R:2,B:3,_percentageAxis:new SVGGraphAxis(this,$.svg.graphing.region.percentageText,0,100,10,0),container:function(a){if(arguments.length==0){return this._chartCont}this._chartCont=a;return this},chartType:function(a,b){return(arguments.length==0?this.type():this.type(a,b))},type:function(a,b){if(arguments.length==0){return this._chartType}var c=$.svg.graphing._chartTypes[a];if(c){this._chartType=c;this._chartOptions=$.extend({},b||{})}this._drawGraph();return this},chartOptions:function(a){return(arguments.length==0?this.options():this.options(a))},options:function(a){if(arguments.length==0){return this._chartOptions}this._chartOptions=$.extend({},a);this._drawGraph();return this},chartFormat:function(a,b,c){return(arguments.length==0?this.format():this.format(a,b,c))},format:function(a,b,c){if(arguments.length==0){return this._chartFormat}if(typeof b=='object'){c=b;b=null}this._chartFormat=$.extend({fill:a},(b?{stroke:b}:{}),c||{});this._drawGraph();return this},chartArea:function(a,b,c,d){return(arguments.length==0?this.area():this.area(a,b,c,d))},area:function(a,b,c,d){if(arguments.length==0){return this._area}this._area=(isArray(a)?a:[a,b,c,d]);this._drawGraph();return this},gridlines:function(a,b){if(arguments.length==0){return this._gridlines}this._gridlines=[(typeof a=='string'?{stroke:a}:a),(typeof b=='string'?{stroke:b}:b)];if(this._gridlines[0]==null&&this._gridlines[1]==null){this._gridlines=[]}this._drawGraph();return this},title:function(a,b,c,d){if(arguments.length==0){return this._title}if(typeof b!='number'){d=c;c=b;b=null}if(typeof c!='string'){d=c;c=null}this._title={value:a,offset:b||this._title.offset,settings:$.extend({textAnchor:'middle'},(c?{fill:c}:{}),d||{})};this._drawGraph();return this},addSeries:function(a,b,c,d,e,f){this._series.push(new SVGGraphSeries(this,a,b,c,d,e,f));this._drawGraph();return this},series:function(i){return(arguments.length>0?this._series[i]:null)||this._series},noDraw:function(){this._drawNow=false;return this},redraw:function(){this._drawNow=true;this._drawGraph();return this},status:function(a){this._onstatus=a;return this},_drawGraph:function(){if(!this._drawNow){return}while(this._chartCont.firstChild){this._chartCont.removeChild(this._chartCont.firstChild)}if(!this._chartCont.parent){this._wrapper._svg.appendChild(this._chartCont)}if(!this._chartCont.width){this._chartCont.setAttribute('width',parseInt(this._chartCont.getAttribute('width'),10)||this._wrapper._width())}else if(this._chartCont.width.baseVal){this._chartCont.width.baseVal.value=this._chartCont.width.baseVal.value||this._wrapper._width()}else{this._chartCont.width=this._chartCont.width||this._wrapper._width()}if(!this._chartCont.height){this._chartCont.setAttribute('height',parseInt(this._chartCont.getAttribute('height'),10)||this._wrapper._height())}else if(this._chartCont.height.baseVal){this._chartCont.height.baseVal.value=this._chartCont.height.baseVal.value||this._wrapper._height()}else{this._chartCont.height=this._chartCont.height||this._wrapper._height()}this._chartType.drawGraph(this)},_getValue:function(a,b){return(!a[b]?parseInt(a.getAttribute(b),10):(a[b].baseVal?a[b].baseVal.value:a[b]))},_drawTitle:function(){this._wrapper.text(this._chartCont,this._getValue(this._chartCont,'width')/2,this._title.offset,this._title.value,this._title.settings)},_getDims:function(a){a=a||this._area;var b=this._getValue(this._chartCont,'width');var c=this._getValue(this._chartCont,'height');var d=(a[this.L]>1?a[this.L]:b*a[this.L]);var e=(a[this.T]>1?a[this.T]:c*a[this.T]);var f=(a[this.R]>1?a[this.R]:b*a[this.R])-d;var g=(a[this.B]>1?a[this.B]:c*a[this.B])-e;return[d,e,f,g]},_drawChartBackground:function(a,b){var c=this._wrapper.group(this._chartCont,{class_:'background'});var d=this._getDims();this._wrapper.rect(c,d[this.X],d[this.Y],d[this.W],d[this.H],this._chartFormat);if(this._gridlines[0]&&this.yAxis._ticks.major&&!b){this._drawGridlines(c,this.yAxis,true,d,this._gridlines[0])}if(this._gridlines[1]&&this.xAxis._ticks.major&&!a){this._drawGridlines(c,this.xAxis,false,d,this._gridlines[1])}return c},_drawGridlines:function(a,b,c,d,e){var g=this._wrapper.group(a,e);var f=(c?d[this.H]:d[this.W])/(b._scale.max-b._scale.min);var h=Math.floor(b._scale.min/b._ticks.major)*b._ticks.major;h=(h<b._scale.min?h+b._ticks.major:h);while(h<=b._scale.max){var v=(c?b._scale.max-h:h-b._scale.min)*f+(c?d[this.Y]:d[this.X]);this._wrapper.line(g,(c?d[this.X]:v),(c?v:d[this.Y]),(c?d[this.X]+d[this.W]:v),(c?v:d[this.Y]+d[this.H]));h+=b._ticks.major}},_drawAxes:function(a){var b=this._getDims();if(this.xAxis&&!a){if(this.xAxis._title){this._wrapper.text(this._chartCont,b[this.X]+b[this.W]/2,b[this.Y]+b[this.H]+this.xAxis._titleOffset,this.xAxis._title,this.xAxis._titleFormat)}this._drawAxis(this.xAxis,'xAxis',b[this.X],b[this.Y]+b[this.H],b[this.X]+b[this.W],b[this.Y]+b[this.H])}if(this.yAxis){if(this.yAxis._title){this._wrapper.text(this._chartCont,0,0,this.yAxis._title,$.extend({textAnchor:'middle',transform:'translate('+(b[this.X]-this.yAxis._titleOffset)+','+(b[this.Y]+b[this.H]/2)+') rotate(-90)'},this.yAxis._titleFormat||{}))}this._drawAxis(this.yAxis,'yAxis',b[this.X],b[this.Y],b[this.X],b[this.Y]+b[this.H])}if(this.x2Axis&&!a){if(this.x2Axis._title){this._wrapper.text(this._chartCont,b[this.X]+b[this.W]/2,b[this.X]-this.x2Axis._titleOffset,this.x2Axis._title,this.x2Axis._titleFormat)}this._drawAxis(this.x2Axis,'x2Axis',b[this.X],b[this.Y],b[this.X]+b[this.W],b[this.Y])}if(this.y2Axis){if(this.y2Axis._title){this._wrapper.text(this._chartCont,0,0,this.y2Axis._title,$.extend({textAnchor:'middle',transform:'translate('+(b[this.X]+b[this.W]+this.y2Axis._titleOffset)+','+(b[this.Y]+b[this.H]/2)+') rotate(-90)'},this.y2Axis._titleFormat||{}))}this._drawAxis(this.y2Axis,'y2Axis',b[this.X]+b[this.W],b[this.Y],b[this.X]+b[this.W],b[this.Y]+b[this.H])}},_drawAxis:function(a,b,c,d,e,f){var g=(d==f);var h=this._wrapper.group(this._chartCont,$.extend({class_:b},a._lineFormat));var i=this._wrapper.group(this._chartCont,$.extend({class_:b+'Labels',textAnchor:(g?'middle':'end')},a._labelFormat));this._wrapper.line(h,c,d,e,f);if(a._ticks.major){var j=(e>(this._getValue(this._chartCont,'width')/2)&&f>(this._getValue(this._chartCont,'height')/2));var k=(g?e-c:f-d)/(a._scale.max-a._scale.min);var l=a._ticks.size;var m=Math.floor(a._scale.min/a._ticks.major)*a._ticks.major;m=(m<a._scale.min?m+a._ticks.major:m);var n=(!a._ticks.minor?a._scale.max+1:Math.floor(a._scale.min/a._ticks.minor)*a._ticks.minor);n=(n<a._scale.min?n+a._ticks.minor:n);var o=this._getTickOffsets(a,j);var p=0;while(m<=a._scale.max||n<=a._scale.max){var q=Math.min(m,n);var r=(q==m?l:l/2);var v=(g?c:d)+(g?q-a._scale.min:a._scale.max-q)*k;this._wrapper.line(h,(g?v:c+r*o[0]),(g?d+r*o[0]:v),(g?v:c+r*o[1]),(g?d+r*o[1]:v));if(q==m){this._wrapper.text(i,(g?v:c-l),(g?d+2*l:v),(a._labels?a._labels[p++]:''+q))}m+=(q==m?a._ticks.major:0);n+=(q==n?a._ticks.minor:0)}}},_getTickOffsets:function(a,b){return[(a._ticks.position==(b?'in':'out')||a._ticks.position=='both'?-1:0),(a._ticks.position==(b?'out':'in')||a._ticks.position=='both'?+1:0),]},_getPercentageAxis:function(){this._percentageAxis._title=$.svg.graphing.region.percentageText;return this._percentageAxis},_getTotals:function(){var a=[];var b=(this._series.length?this._series[0]._values.length:0);for(var i=0;i<b;i++){a[i]=0;for(var j=0;j<this._series.length;j++){a[i]+=this._series[j]._values[i]}}return a},_drawLegend:function(){if(!this.legend._show){return}var g=this._wrapper.group(this._chartCont,{class_:'legend'});var a=this._getDims(this.legend._area);this._wrapper.rect(g,a[this.X],a[this.Y],a[this.W],a[this.H],this.legend._bgSettings);var b=a[this.W]>a[this.H];var c=this._series.length;var d=(b?a[this.W]:a[this.H])/c;var e=a[this.X]+5;var f=a[this.Y]+((b?a[this.H]:d)+this.legend._sampleSize)/2;for(var i=0;i<c;i++){var h=this._series[i];this._wrapper.rect(g,e+(b?i*d:0),f+(b?0:i*d)-this.legend._sampleSize,this.legend._sampleSize,this.legend._sampleSize,{fill:h._fill,stroke:h._stroke,strokeWidth:1});this._wrapper.text(g,e+(b?i*d:0)+this.legend._sampleSize+5,f+(b?0:i*d),h._name,this.legend._textSettings)}},_showStatus:function(a,b,c){var d=this._onstatus;if(this._onstatus){$(a).hover(function(){d.apply(this,[b,c])},function(){d.apply(this,['',0])})}}});function SVGGraphSeries(a,b,c,d,e,f,g){if(typeof b!='string'){g=f;f=e;e=d;d=c;c=b;b=null}if(typeof e!='string'){g=f;f=e;e=null}if(typeof f!='number'){g=f;f=null}this._graph=a;this._name=b||'';this._values=c||[];this._axis=1;this._fill=d||'green';this._stroke=e||'black';this._strokeWidth=f||1;this._settings=g||{}}$.extend(SVGGraphSeries.prototype,{name:function(a){if(arguments.length==0){return this._name}this._name=a;this._graph._drawGraph();return this},values:function(a,b){if(arguments.length==0){return this._values}if(isArray(a)){b=a;a=null}this._name=a||this._name;this._values=b;this._graph._drawGraph();return this},format:function(a,b,c,d){if(arguments.length==0){return $.extend({fill:this._fill,stroke:this._stroke,strokeWidth:this._strokeWidth},this._settings)}if(typeof b!='string'){d=c;c=b;b=null}if(typeof c!='number'){d=c;c=null}this._fill=a||this._fill;this._stroke=b||this._stroke;this._strokeWidth=c||this._strokeWidth;$.extend(this._settings,d||{});this._graph._drawGraph();return this},end:function(){return this._graph}});function SVGGraphAxis(a,b,c,d,e,f){this._graph=a;this._title=b||'';this._titleFormat={};this._titleOffset=0;this._labels=null;this._labelFormat={};this._lineFormat={stroke:'black',strokeWidth:1};this._ticks={major:e||10,minor:f||0,size:10,position:'out'};this._scale={min:c||0,max:d||100};this._crossAt=0}$.extend(SVGGraphAxis.prototype,{scale:function(a,b){if(arguments.length==0){return this._scale}this._scale.min=a;this._scale.max=b;this._graph._drawGraph();return this},ticks:function(a,b,c,d){if(arguments.length==0){return this._ticks}if(typeof c=='string'){d=c;c=null}this._ticks.major=a;this._ticks.minor=b;this._ticks.size=c||this._ticks.size;this._ticks.position=d||this._ticks.position;this._graph._drawGraph();return this},title:function(a,b,c,d){if(arguments.length==0){return{title:this._title,offset:this._titleOffset,format:this._titleFormat}}if(typeof b!='number'){d=c;c=b;b=null}if(typeof c!='string'){d=c;c=null}this._title=a;this._titleOffset=(b!=null?b:this._titleOffset);if(c||d){this._titleFormat=$.extend(d||{},(c?{fill:c}:{}))}this._graph._drawGraph();return this},labels:function(a,b,c){if(arguments.length==0){return{labels:this._labels,format:this._labelFormat}}if(typeof b!='string'){c=b;b=null}this._labels=a;if(b||c){this._labelFormat=$.extend(c||{},(b?{fill:b}:{}))}this._graph._drawGraph();return this},line:function(a,b,c){if(arguments.length==0){return this._lineFormat}if(typeof b=='object'){c=b;b=null}$.extend(this._lineFormat,{stroke:a},(b?{strokeWidth:b}:{}),c||{});this._graph._drawGraph();return this},end:function(){return this._graph}});function SVGGraphLegend(a,b,c){this._graph=a;this._show=true;this._area=[0.9,0.1,1.0,0.9];this._sampleSize=15;this._bgSettings=b||{stroke:'gray'};this._textSettings=c||{}}$.extend(SVGGraphLegend.prototype,{show:function(a){if(arguments.length==0){return this._show}this._show=a;this._graph._drawGraph();return this},area:function(a,b,c,d){if(arguments.length==0){return this._area}this._area=(isArray(a)?a:[a,b,c,d]);this._graph._drawGraph();return this},settings:function(a,b,c){if(arguments.length==0){return{sampleSize:this._sampleSize,bgSettings:this._bgSettings,textSettings:this._textSettings}}if(typeof a!='number'){c=b;b=a;a=null}this._sampleSize=a||this._sampleSize;this._bgSettings=b;this._textSettings=c||this._textSettings;this._graph._drawGraph();return this},end:function(){return this._graph}});function roundNumber(a,b){return Math.round(a*Math.pow(10,b))/Math.pow(10,b)}var B=['barWidth (number) - the width of each bar','barGap (number) - the gap between sets of bars'];function SVGColumnChart(){}$.extend(SVGColumnChart.prototype,{title:function(){return'Basic column chart'},description:function(){return'Compare sets of values as vertical bars with grouped categories.'},options:function(){return B},drawGraph:function(a){a._drawChartBackground(true);var b=a._chartOptions.barWidth||10;var c=a._chartOptions.barGap||10;var d=a._series.length;var e=(d?(a._series[0])._values.length:0);var f=a._getDims();var g=f[a.W]/((d*b+c)*e+c);var h=f[a.H]/(a.yAxis._scale.max-a.yAxis._scale.min);this._chart=a._wrapper.group(a._chartCont,{class_:'chart'});for(var i=0;i<d;i++){this._drawSeries(a,i,d,b,c,f,g,h)}a._drawTitle();a._drawAxes(true);this._drawXAxis(a,d,e,b,c,f,g);a._drawLegend()},_drawSeries:function(a,b,c,d,e,f,h,j){var k=a._series[b];var g=a._wrapper.group(this._chart,$.extend({class_:'series'+b,fill:k._fill,stroke:k._stroke,strokeWidth:k._strokeWidth},k._settings||{}));for(var i=0;i<k._values.length;i++){var r=a._wrapper.rect(g,f[a.X]+h*(e+i*(c*d+e)+(b*d)),f[a.Y]+j*(a.yAxis._scale.max-k._values[i]),h*d,j*k._values[i]);a._showStatus(r,k._name,k._values[i])}},_drawXAxis:function(a,b,c,d,e,f,g){var h=a.xAxis;if(h._title){a._wrapper.text(a._chartCont,f[a.X]+f[a.W]/2,f[a.Y]+f[a.H]+h._titleOffset,h._title,$.extend({textAnchor:'middle'},h._titleFormat||{}))}var j=a._wrapper.group(a._chartCont,$.extend({class_:'xAxis'},h._lineFormat));var k=a._wrapper.group(a._chartCont,$.extend({class_:'xAxisLabels',textAnchor:'middle'},h._labelFormat));a._wrapper.line(j,f[a.X],f[a.Y]+f[a.H],f[a.X]+f[a.W],f[a.Y]+f[a.H]);if(h._ticks.major){var l=a._getTickOffsets(h,true);for(var i=1;i<c;i++){var x=f[a.X]+g*(e/2+i*(b*d+e));a._wrapper.line(j,x,f[a.Y]+f[a.H]+l[0]*h._ticks.size,x,f[a.Y]+f[a.H]+l[1]*h._ticks.size)}for(var i=0;i<c;i++){var x=f[a.X]+g*(e/2+(i+0.5)*(b*d+e));a._wrapper.text(k,x,f[a.Y]+f[a.H]+2*h._ticks.size,(h._labels?h._labels[i]:''+i))}}}});function SVGStackedColumnChart(){}$.extend(SVGStackedColumnChart.prototype,{title:function(){return'Stacked column chart'},description:function(){return'Compare sets of values as vertical bars showing '+'relative contributions to the whole for each category.'},options:function(){return B},drawGraph:function(a){var b=a._drawChartBackground(true,true);var c=a._getDims();if(a._gridlines[0]&&a.xAxis._ticks.major){a._drawGridlines(b,a._getPercentageAxis(),true,c,a._gridlines[0])}var d=a._chartOptions.barWidth||10;var e=a._chartOptions.barGap||10;var f=a._series.length;var g=(f?(a._series[0])._values.length:0);var h=c[a.W]/((d+e)*g+e);var i=c[a.H];this._chart=a._wrapper.group(a._chartCont,{class_:'chart'});this._drawColumns(a,f,g,d,e,c,h,i);a._drawTitle();a._wrapper.text(a._chartCont,0,0,$.svg.graphing.region.percentageText,$.extend({textAnchor:'middle',transform:'translate('+(c[a.X]-a.yAxis._titleOffset)+','+(c[a.Y]+c[a.H]/2)+') rotate(-90)'},a.yAxis._titleFormat||{}));var j=$.extend({},a._getPercentageAxis());$.extend(j._labelFormat,a.yAxis._labelFormat||{});a._drawAxis(j,'yAxis',c[a.X],c[a.Y],c[a.X],c[a.Y]+c[a.H]);this._drawXAxis(a,g,d,e,c,h);a._drawLegend()},_drawColumns:function(a,b,c,d,e,f,h,j){var k=a._getTotals();var l=[];for(var i=0;i<c;i++){l[i]=0}for(var s=0;s<b;s++){var m=a._series[s];var g=a._wrapper.group(this._chart,$.extend({class_:'series'+s,fill:m._fill,stroke:m._stroke,strokeWidth:m._strokeWidth},m._settings||{}));for(var i=0;i<m._values.length;i++){l[i]+=m._values[i];var r=a._wrapper.rect(g,f[a.X]+h*(e+i*(d+e)),f[a.Y]+j*(k[i]-l[i])/k[i],h*d,j*m._values[i]/k[i]);a._showStatus(r,m._name,roundNumber(m._values[i]/k[i]*100,2))}}},_drawXAxis:function(a,b,c,d,e,f){var g=a.xAxis;if(g._title){a._wrapper.text(a._chartCont,e[a.X]+e[a.W]/2,e[a.Y]+e[a.H]+g._titleOffset,g._title,$.extend({textAnchor:'middle'},g._titleFormat||{}))}var h=a._wrapper.group(a._chartCont,$.extend({class_:'xAxis'},g._lineFormat));var j=a._wrapper.group(a._chartCont,$.extend({class_:'xAxisLabels',textAnchor:'middle'},g._labelFormat));a._wrapper.line(h,e[a.X],e[a.Y]+e[a.H],e[a.X]+e[a.W],e[a.Y]+e[a.H]);if(g._ticks.major){var k=a._getTickOffsets(g,true);for(var i=1;i<b;i++){var x=e[a.X]+f*(d/2+i*(c+d));a._wrapper.line(h,x,e[a.Y]+e[a.H]+k[0]*g._ticks.size,x,e[a.Y]+e[a.H]+k[1]*g._ticks.size)}for(var i=0;i<b;i++){var x=e[a.X]+f*(d/2+(i+0.5)*(c+d));a._wrapper.text(j,x,e[a.Y]+e[a.H]+2*g._ticks.size,(g._labels?g._labels[i]:''+i))}}}});function SVGRowChart(){}$.extend(SVGRowChart.prototype,{title:function(){return'Basic row chart'},description:function(){return'Compare sets of values as horizontal rows with grouped categories.'},options:function(){return B},drawGraph:function(a){var b=a._drawChartBackground(true,true);var c=a._getDims();a._drawGridlines(b,a.yAxis,false,c,a._gridlines[0]);var d=a._chartOptions.barWidth||10;var e=a._chartOptions.barGap||10;var f=a._series.length;var g=(f?(a._series[0])._values.length:0);var h=c[a.W]/(a.yAxis._scale.max-a.yAxis._scale.min);var j=c[a.H]/((f*d+e)*g+e);this._chart=a._wrapper.group(a._chartCont,{class_:'chart'});for(var i=0;i<f;i++){this._drawSeries(a,i,f,d,e,c,h,j)}a._drawTitle();this._drawAxes(a,f,g,d,e,c,j);a._drawLegend()},_drawSeries:function(a,b,c,d,e,f,h,j){var k=a._series[b];var g=a._wrapper.group(this._chart,$.extend({class_:'series'+b,fill:k._fill,stroke:k._stroke,strokeWidth:k._strokeWidth},k._settings||{}));for(var i=0;i<k._values.length;i++){var r=a._wrapper.rect(g,f[a.X]+h*(0-a.yAxis._scale.min),f[a.Y]+j*(e+i*(c*d+e)+(b*d)),h*k._values[i],j*d);a._showStatus(r,k._name,k._values[i])}},_drawAxes:function(a,b,c,d,e,f,g){var h=a.yAxis;if(h){if(h._title){a._wrapper.text(a._chartCont,f[a.X]+f[a.W]/2,f[a.Y]+f[a.H]+h._titleOffset,h._title,h._titleFormat)}a._drawAxis(h,'xAxis',f[a.X],f[a.Y]+f[a.H],f[a.X]+f[a.W],f[a.Y]+f[a.H])}var h=a.xAxis;if(h._title){a._wrapper.text(a._chartCont,0,0,h._title,$.extend({textAnchor:'middle',transform:'translate('+(f[a.X]-h._titleOffset)+','+(f[a.Y]+f[a.H]/2)+') rotate(-90)'},h._titleFormat||{}))}var j=a._wrapper.group(a._chartCont,$.extend({class_:'yAxis'},h._lineFormat));var k=a._wrapper.group(a._chartCont,$.extend({class_:'yAxisLabels',textAnchor:'end'},h._labelFormat));a._wrapper.line(j,f[a.X],f[a.Y],f[a.X],f[a.Y]+f[a.H]);if(h._ticks.major){var l=a._getTickOffsets(h,false);for(var i=1;i<c;i++){var y=f[a.Y]+g*(e/2+i*(b*d+e));a._wrapper.line(j,f[a.X]+l[0]*h._ticks.size,y,f[a.X]+l[1]*h._ticks.size,y)}for(var i=0;i<c;i++){var y=f[a.Y]+g*(e/2+(i+0.5)*(b*d+e));a._wrapper.text(k,f[a.X]-h._ticks.size,y,(h._labels?h._labels[i]:''+i))}}}});function SVGStackedRowChart(){}$.extend(SVGStackedRowChart.prototype,{title:function(){return'Stacked row chart'},description:function(){return'Compare sets of values as horizontal bars showing '+'relative contributions to the whole for each category.'},options:function(){return B},drawGraph:function(a){var b=a._drawChartBackground(true,true);var c=a._getDims();if(a._gridlines[0]&&a.xAxis._ticks.major){a._drawGridlines(b,a._getPercentageAxis(),false,c,a._gridlines[0])}var d=a._chartOptions.barWidth||10;var e=a._chartOptions.barGap||10;var f=a._series.length;var g=(f?(a._series[0])._values.length:0);var h=c[a.W];var i=c[a.H]/((d+e)*g+e);this._chart=a._wrapper.group(a._chartCont,{class_:'chart'});this._drawRows(a,f,g,d,e,c,h,i);a._drawTitle();a._wrapper.text(a._chartCont,c[a.X]+c[a.W]/2,c[a.Y]+c[a.H]+a.xAxis._titleOffset,$.svg.graphing.region.percentageText,$.extend({textAnchor:'middle'},a.yAxis._titleFormat||{}));var j=$.extend({},a._getPercentageAxis());$.extend(j._labelFormat,a.yAxis._labelFormat||{});a._drawAxis(j,'xAxis',c[a.X],c[a.Y]+c[a.H],c[a.X]+c[a.W],c[a.Y]+c[a.H]);this._drawYAxis(a,g,d,e,c,i);a._drawLegend()},_drawRows:function(a,b,c,d,e,f,h,j){var k=a._getTotals();var l=[];for(var i=0;i<c;i++){l[i]=0}for(var s=0;s<b;s++){var m=a._series[s];var g=a._wrapper.group(this._chart,$.extend({class_:'series'+s,fill:m._fill,stroke:m._stroke,strokeWidth:m._strokeWidth},m._settings||{}));for(var i=0;i<m._values.length;i++){var r=a._wrapper.rect(g,f[a.X]+h*l[i]/k[i],f[a.Y]+j*(e+i*(d+e)),h*m._values[i]/k[i],j*d);a._showStatus(r,m._name,roundNumber(m._values[i]/k[i]*100,2));l[i]+=m._values[i]}}},_drawYAxis:function(a,b,c,d,e,f){var g=a.xAxis;if(g._title){a._wrapper.text(a._chartCont,0,0,g._title,$.extend({textAnchor:'middle',transform:'translate('+(e[a.X]-g._titleOffset)+','+(e[a.Y]+e[a.H]/2)+') rotate(-90)'},g._titleFormat||{}))}var h=a._wrapper.group(a._chartCont,$.extend({class_:'yAxis'},g._lineFormat));var j=a._wrapper.group(a._chartCont,$.extend({class_:'yAxisLabels',textAnchor:'end'},g._labelFormat));a._wrapper.line(h,e[a.X],e[a.Y],e[a.X],e[a.Y]+e[a.H]);if(g._ticks.major){var k=a._getTickOffsets(g,false);for(var i=1;i<b;i++){var y=e[a.Y]+f*(d/2+i*(c+d));a._wrapper.line(h,e[a.X]+k[0]*g._ticks.size,y,e[a.X]+k[1]*g._ticks.size,y)}for(var i=0;i<b;i++){var y=e[a.Y]+f*(d/2+(i+0.5)*(c+d));a._wrapper.text(j,e[a.X]-g._ticks.size,y,(g._labels?g._labels[i]:''+i))}}}});function SVGLineChart(){}$.extend(SVGLineChart.prototype,{title:function(){return'Basic line chart'},description:function(){return'Compare sets of values as continuous lines.'},options:function(){return[]},drawGraph:function(a){a._drawChartBackground();var b=a._getDims();var c=b[a.W]/(a.xAxis._scale.max-a.xAxis._scale.min);var d=b[a.H]/(a.yAxis._scale.max-a.yAxis._scale.min);this._chart=a._wrapper.group(a._chartCont,{class_:'chart'});for(var i=0;i<a._series.length;i++){this._drawSeries(a,i,b,c,d)}a._drawTitle();a._drawAxes();a._drawLegend()},_drawSeries:function(a,b,c,d,e){var f=a._series[b];var g=a._wrapper.createPath();for(var i=0;i<f._values.length;i++){var x=c[a.X]+i*d;var y=c[a.Y]+(a.yAxis._scale.max-f._values[i])*e;if(i==0){g.move(x,y)}else{g.line(x,y)}}var p=a._wrapper.path(this._chart,g,$.extend({id:'series'+b,fill:'none',stroke:f._stroke,strokeWidth:f._strokeWidth},f._settings||{}));a._showStatus(p,f._name,0)}});function SVGPieChart(){}$.extend(SVGPieChart.prototype,{_options:['explode (number or number[]) - indexes of sections to explode out of the pie','explodeDist (number) - the distance to move an exploded section','pieGap (number) - the distance between pies for multiple values'],title:function(){return'Pie chart'},description:function(){return'Compare relative sizes of values as contributions to the whole.'},options:function(){return this._options},drawGraph:function(a){a._drawChartBackground(true,true);this._chart=a._wrapper.group(a._chartCont,{class_:'chart'});var b=a._getDims();this._drawSeries(a,b);a._drawTitle();a._drawLegend()},_drawSeries:function(a,b){var c=a._getTotals();var d=a._series.length;var e=(d?(a._series[0])._values.length:0);var f=a._wrapper.createPath();var g=a._chartOptions.explode||[];g=(isArray(g)?g:[g]);var h=a._chartOptions.explodeDist||10;var l=(e<=1?0:a._chartOptions.pieGap||10);var m=(b[a.W]-(e*l)-l)/e/2;var n=b[a.H]/2;var o=Math.min(m,n)-(g.length>0?h:0);var q=a._wrapper.group(a._chartCont,$.extend({class_:'xAxisLabels',textAnchor:'middle'},a.xAxis._labelFormat));var r=[];for(var i=0;i<e;i++){var s=b[a.X]+m+(i*(2*Math.min(m,n)+l))+l;var t=b[a.Y]+n;var u=0;for(var j=0;j<d;j++){var v=a._series[j];if(i==0){r[j]=a._wrapper.group(this._chart,$.extend({class_:'series'+j,fill:v._fill,stroke:v._stroke,strokeWidth:v._strokeWidth},v._settings||{}))}if(v._values[i]==0){continue}var w=(u/c[i])*2*Math.PI;u+=v._values[i];var z=(u/c[i])*2*Math.PI;var A=false;for(var k=0;k<g.length;k++){if(g[k]==j){A=true;break}}var x=s+(A?h*Math.cos((w+z)/2):0);var y=t+(A?h*Math.sin((w+z)/2):0);var p=a._wrapper.path(r[j],f.reset().move(x,y).line(x+o*Math.cos(w),y+o*Math.sin(w)).arc(o,o,0,(z-w<Math.PI?0:1),1,x+o*Math.cos(z),y+o*Math.sin(z)).close());a._showStatus(p,v._name,roundNumber((z-w)/2/Math.PI*100,2))}if(a.xAxis){a._wrapper.text(q,s,b[a.Y]+b[a.H]+a.xAxis._titleOffset,a.xAxis._labels[i])}}}});function isArray(a){return(a&&a.constructor==Array)}$.svg.graphing.addChartType('column',new SVGColumnChart());$.svg.graphing.addChartType('stackedColumn',new SVGStackedColumnChart());$.svg.graphing.addChartType('row',new SVGRowChart());$.svg.graphing.addChartType('stackedRow',new SVGStackedRowChart());$.svg.graphing.addChartType('line',new SVGLineChart());$.svg.graphing.addChartType('pie',new SVGPieChart())})(jQuery)