/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.collect;

import java.util.Map;
import java.util.function.BiFunction;
import javax.annotation.CheckReturnValue;
import org.gradle.internal.collect.PersistentMap0;
import org.gradle.internal.collect.PersistentMap1;
import org.gradle.internal.collect.Preconditions;
import org.jspecify.annotations.Nullable;

public interface PersistentMap<K, V>
extends Iterable<Map.Entry<K, V>> {
    public static <K, V> PersistentMap<K, V> of() {
        return PersistentMap0.INSTANCE;
    }

    public static <K, V> PersistentMap<K, V> of(K key, V value) {
        Preconditions.entryCannotBeNull(key, value);
        return new PersistentMap1<K, V>(key, value);
    }

    public static <K, V> PersistentMap<K, V> copyOf(Iterable<Map.Entry<K, V>> entries) {
        if (entries instanceof PersistentMap) {
            return (PersistentMap)entries;
        }
        PersistentMap<K, V> copy = PersistentMap.of();
        for (Map.Entry<K, V> entry : entries) {
            copy = copy.assoc(entry.getKey(), entry.getValue());
        }
        return copy;
    }

    @CheckReturnValue
    public PersistentMap<K, V> assoc(K var1, V var2);

    @CheckReturnValue
    public PersistentMap<K, V> dissoc(K var1);

    @CheckReturnValue
    public PersistentMap<K, V> modify(K var1, BiFunction<? super K, ? super @Nullable V, ? extends @Nullable V> var2);

    public @Nullable V get(K var1);

    public V getOrDefault(K var1, V var2);

    public boolean containsKey(K var1);

    public int size();

    public boolean isEmpty();
}

