/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.internal;

import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.reporting.components.ComponentReport;
import org.gradle.api.reporting.dependents.DependentComponentsReport;
import org.jspecify.annotations.NullMarked;

@NullMarked
public abstract class ComponentReportingTasksPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        project.getTasks().register("components", ComponentReport.class, (Action)new ComponentReportAction(project.toString()));
        project.getTasks().register("dependentComponents", DependentComponentsReport.class, (Action)new DependentComponentsReportAction(project.toString()));
    }

    private static class ComponentReportAction
    implements Action<ComponentReport> {
        private final String projectName;

        public ComponentReportAction(String projectName) {
            this.projectName = projectName;
        }

        public void execute(ComponentReport task) {
            task.setDescription("Displays the components produced by " + this.projectName + ". [deprecated]");
            task.setImpliesSubProjects(true);
        }
    }

    private static class DependentComponentsReportAction
    implements Action<DependentComponentsReport> {
        private final String projectName;

        public DependentComponentsReportAction(String projectName) {
            this.projectName = projectName;
        }

        public void execute(DependentComponentsReport task) {
            task.setDescription("Displays the dependent components of components in " + this.projectName + ". [deprecated]");
            task.setImpliesSubProjects(true);
        }
    }
}

