/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transport.http;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.utils.HttpClientUtils;
import org.gradle.internal.resource.transport.http.HttpClient;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class ApacheHttpResponse
implements HttpClient.Response {
    private final String method;
    private final URI effectiveUri;
    private final CloseableHttpResponse httpResponse;
    private boolean closed;

    ApacheHttpResponse(String method, URI effectiveUri, CloseableHttpResponse httpResponse) {
        this.method = method;
        this.effectiveUri = effectiveUri;
        this.httpResponse = httpResponse;
    }

    @Override
    public @Nullable String getHeader(String name) {
        Header header = this.httpResponse.getFirstHeader(name);
        return header == null ? null : header.getValue();
    }

    @Override
    public InputStream getContent() throws IOException {
        HttpEntity entity = this.httpResponse.getEntity();
        if (entity == null) {
            throw new IOException(String.format("Response %d: %s has no content!", this.getStatusCode(), this.getStatusReason()));
        }
        return entity.getContent();
    }

    @Override
    public int getStatusCode() {
        return this.httpResponse.getStatusLine().getStatusCode();
    }

    @Override
    public String getStatusReason() {
        return this.httpResponse.getStatusLine().getReasonPhrase();
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
            HttpClientUtils.closeQuietly((CloseableHttpResponse)this.httpResponse);
        }
    }

    @Override
    public String getMethod() {
        return this.method;
    }

    @Override
    public URI getEffectiveUri() {
        return this.effectiveUri;
    }
}

