/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.checker;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.types.FlexibleTypeBoundsChecker;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeProjection;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0006R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/types/checker/CapturedArguments;", "", "capturedArguments", "", "Lorg/jetbrains/kotlin/types/TypeProjection;", "originalType", "Lorg/jetbrains/kotlin/types/KotlinType;", "<init>", "(Ljava/util/List;Lorg/jetbrains/kotlin/types/KotlinType;)V", "getCapturedArguments", "()Ljava/util/List;", "isSuitableForType", "", "type", "descriptors"})
@SourceDebugExtension(value={"SMAP\nNewCapturedType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NewCapturedType.kt\norg/jetbrains/kotlin/types/checker/CapturedArguments\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,290:1\n1786#2,3:291\n*S KotlinDebug\n*F\n+ 1 NewCapturedType.kt\norg/jetbrains/kotlin/types/checker/CapturedArguments\n*L\n36#1:291,3\n*E\n"})
final class CapturedArguments {
    @NotNull
    private final List<TypeProjection> capturedArguments;
    @NotNull
    private final KotlinType originalType;

    public CapturedArguments(@NotNull List<? extends TypeProjection> capturedArguments, @NotNull KotlinType originalType) {
        Intrinsics.checkNotNullParameter(capturedArguments, (String)"capturedArguments");
        Intrinsics.checkNotNullParameter((Object)originalType, (String)"originalType");
        this.capturedArguments = capturedArguments;
        this.originalType = originalType;
    }

    @NotNull
    public final List<TypeProjection> getCapturedArguments() {
        return this.capturedArguments;
    }

    public final boolean isSuitableForType(@NotNull KotlinType type) {
        boolean areConstructorsMatched;
        boolean areArgumentsMatched;
        block4: {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Iterable $this$all$iv = CollectionsKt.withIndex((Iterable)type.getArguments());
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    IndexedValue indexedValue = (IndexedValue)element$iv;
                    boolean bl2 = false;
                    int i2 = indexedValue.component1();
                    TypeProjection typeArgumentsType = (TypeProjection)indexedValue.component2();
                    if (this.originalType.getArguments().size() > i2 && Intrinsics.areEqual((Object)typeArgumentsType, (Object)this.originalType.getArguments().get(i2))) continue;
                    bl = false;
                    break block4;
                }
                bl = areArgumentsMatched = true;
            }
        }
        if (!areArgumentsMatched) {
            return false;
        }
        boolean bl = areConstructorsMatched = Intrinsics.areEqual((Object)this.originalType.getConstructor(), (Object)type.getConstructor()) || FlexibleTypeBoundsChecker.INSTANCE.areTypesMayBeLowerAndUpperBoundsOfSameFlexibleTypeByMutability(this.originalType, type);
        return areConstructorsMatched;
    }
}

