/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.report.generic;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimaps;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.gradle.api.Action;
import org.gradle.api.internal.tasks.testing.junit.result.TestClassResult;
import org.gradle.api.internal.tasks.testing.junit.result.TestMethodResult;
import org.gradle.api.internal.tasks.testing.junit.result.TestResultsProvider;
import org.gradle.api.internal.tasks.testing.report.generic.PerRootInfo;
import org.gradle.api.internal.tasks.testing.report.generic.TestTreeModel;
import org.gradle.api.internal.tasks.testing.results.serializable.OutputEntry;
import org.gradle.api.internal.tasks.testing.results.serializable.SerializableFailure;
import org.gradle.api.internal.tasks.testing.results.serializable.SerializableTestResult;
import org.gradle.api.internal.tasks.testing.results.serializable.SerializableTestResultStore;
import org.gradle.api.internal.tasks.testing.results.serializable.TestOutputReader;
import org.gradle.api.internal.tasks.testing.worker.TestEventSerializer;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.testing.TestMetadataEvent;
import org.gradle.api.tasks.testing.TestOutputEvent;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.io.IoConsumer;
import org.gradle.internal.serialize.Serializer;
import org.jspecify.annotations.Nullable;

public final class TestTreeModelResultsProvider
implements TestResultsProvider {
    private static final Logger LOGGER = Logging.getLogger(TestTreeModelResultsProvider.class);
    private static final Comparator<PerRootInfo> PER_ROOT_INFO_BY_START_TIME = Comparator.comparing(leaf -> leaf.getResults().get(0).getStartTime());
    private final Map<Long, ClassNode> classesById;
    private final TestOutputReader outputReader;

    public static void useResultsFrom(Path resultsDir, Consumer<TestTreeModelResultsProvider> resultsConsumer) {
        SerializableTestResultStore resultsStore = new SerializableTestResultStore(resultsDir);
        Serializer testOutputEventSerializer = TestEventSerializer.create().build(TestOutputEvent.class);
        try {
            TestTreeModel root = TestTreeModel.loadModelFromStores(Collections.singletonList(resultsStore));
            TestTreeModelResultsProvider resultsProvider = new TestTreeModelResultsProvider(root, resultsStore.createOutputReader((Serializer<TestOutputEvent>)testOutputEventSerializer));
            resultsConsumer.accept(resultsProvider);
        }
        catch (Exception e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    private static Map<Long, ClassNode> createClasses(TestTreeModel root) {
        Map<org.gradle.util.Path, TestTreeModel> parentOfPath = TestTreeModelResultsProvider.buildParentOfPathMap(root);
        LinkedListMultimap leavesByGroupingNode = LinkedListMultimap.create();
        TestTreeModelResultsProvider.walkLeaves(parentOfPath, root, arg_0 -> TestTreeModelResultsProvider.lambda$createClasses$1(parentOfPath, (ListMultimap)leavesByGroupingNode, arg_0));
        ImmutableMap.Builder classesById = ImmutableMap.builderWithExpectedSize((int)leavesByGroupingNode.keySet().size());
        long nextClassId = 1L;
        for (Map.Entry entry : Multimaps.asMap((ListMultimap)leavesByGroupingNode).entrySet()) {
            TestTreeModel groupingNode = (TestTreeModel)entry.getKey();
            ArrayList<PerRootInfo> leaves = new ArrayList<PerRootInfo>((Collection)entry.getValue());
            leaves.sort(PER_ROOT_INFO_BY_START_TIME);
            ImmutableMap.Builder methodOutputEntries = ImmutableMap.builder();
            TestClassResult classResult = TestTreeModelResultsProvider.buildClassResult(groupingNode, leaves, nextClassId, (ImmutableMap.Builder<Long, OutputEntry>)methodOutputEntries);
            ++nextClassId;
            ImmutableList.Builder outputEntries = ImmutableList.builder();
            groupingNode.walkDepthFirst(node -> {
                if (node.getChildren().isEmpty()) {
                    return;
                }
                for (PerRootInfo perRootInfo : node.getPerRootInfo().get(0)) {
                    for (OutputEntry outputEntry : perRootInfo.getOutputEntries()) {
                        if (!outputEntry.getOutputRanges().hasOutput()) continue;
                        outputEntries.add((Object)outputEntry);
                    }
                }
            });
            classesById.put((Object)classResult.getId(), (Object)new ClassNode(classResult, (ImmutableList<OutputEntry>)outputEntries.build(), (ImmutableMap<Long, OutputEntry>)methodOutputEntries.build()));
        }
        return classesById.build();
    }

    private static Map<org.gradle.util.Path, TestTreeModel> buildParentOfPathMap(TestTreeModel root) {
        ImmutableMap.Builder parentOfPath = ImmutableMap.builder();
        TestTreeModelResultsProvider.addToParentOfPathMap(root, (ImmutableMap.Builder<org.gradle.util.Path, TestTreeModel>)parentOfPath);
        return parentOfPath.build();
    }

    private static void addToParentOfPathMap(TestTreeModel node, ImmutableMap.Builder<org.gradle.util.Path, TestTreeModel> parentOfPath) {
        for (TestTreeModel child : node.getChildren()) {
            parentOfPath.put((Object)child.getPath(), (Object)node);
            TestTreeModelResultsProvider.addToParentOfPathMap(child, parentOfPath);
        }
    }

    private static TestClassResult buildClassResult(TestTreeModel groupingNode, List<PerRootInfo> leaves, long nextClassId, ImmutableMap.Builder<Long, OutputEntry> methodOutputEntries) {
        TestClassResult classResult = TestTreeModelResultsProvider.createEmptyClassResult(groupingNode, nextClassId);
        for (PerRootInfo leaf : leaves) {
            classResult.add(TestTreeModelResultsProvider.buildMethodResult(leaf));
            OutputEntry outputEntry = leaf.getOutputEntries().get(0);
            if (!outputEntry.getOutputRanges().hasOutput()) continue;
            methodOutputEntries.put((Object)leaf.getId(), (Object)outputEntry);
        }
        return classResult;
    }

    private static TestClassResult createEmptyClassResult(TestTreeModel groupingNode, long nextClassId) {
        List<PerRootInfo> perRootInfos = groupingNode.getPerRootInfo().get(0);
        if (perRootInfos.size() != 1) {
            throw new IllegalStateException("Expected exactly one run for grouping node " + groupingNode.getPath() + " but found: " + perRootInfos.size());
        }
        PerRootInfo perRootInfo = perRootInfos.get(0);
        List<SerializableTestResult> results = perRootInfo.getResults();
        String name = results.get(0).getName();
        String displayName = results.get(0).getDisplayName();
        long earliestStartTime = results.get(0).getStartTime();
        for (int i = 1; i < results.size(); ++i) {
            SerializableTestResult result = results.get(i);
            if (!result.getName().equals(name)) {
                throw new IllegalStateException("Expected all results for grouping node " + groupingNode.getPath() + " to have the same name, but found: " + name + " and " + result.getName());
            }
            if (!result.getDisplayName().equals(displayName)) {
                LOGGER.warn("Expected all results for grouping node {} to have the same display name, but found: {} and {}", new Object[]{groupingNode.getPath(), displayName, result.getDisplayName()});
            }
            if (result.getStartTime() >= earliestStartTime) continue;
            earliestStartTime = result.getStartTime();
        }
        return new TestClassResult(nextClassId, name, displayName, earliestStartTime, (List<TestMetadataEvent>)ImmutableList.copyOf(perRootInfo.getMetadatas()));
    }

    private static TestMethodResult buildMethodResult(PerRootInfo leaf) {
        SerializableTestResult result = leaf.getResults().get(0);
        TestMethodResult methodResult = new TestMethodResult(leaf.getId(), result.getName(), result.getDisplayName(), result.getResultType(), result.getDuration(), result.getEndTime(), (List<TestMetadataEvent>)ImmutableList.copyOf(leaf.getMetadatas()));
        methodResult.getFailures().addAll((Collection<SerializableFailure>)result.getFailures());
        if (result.getAssumptionFailure() != null) {
            SerializableFailure assumptionFailure = result.getAssumptionFailure();
            methodResult.setAssumptionFailure(assumptionFailure.getMessage(), assumptionFailure.getStackTrace(), assumptionFailure.getExceptionType());
        }
        return methodResult;
    }

    private static TestTreeModel findGroupingNode(Map<org.gradle.util.Path, TestTreeModel> parentOfPath, TestTreeModel leaf, @Nullable String className) {
        TestTreeModel parent;
        TestTreeModel current = leaf;
        while ((parent = parentOfPath.get(current.getPath())) != null) {
            org.gradle.util.Path parentPath = parent.getPath();
            if (className != null && className.equals(parentPath.getName())) {
                return parent;
            }
            boolean parentHasParent = parentOfPath.containsKey(parentPath);
            if (!parentHasParent && current != leaf) {
                return current;
            }
            current = parent;
        }
        return current;
    }

    private static void walkLeaves(Map<org.gradle.util.Path, TestTreeModel> parentOfPath, TestTreeModel base, Consumer<TestTreeModel> leafConsumer) {
        base.walkDepthFirst(node -> {
            boolean hasParent;
            if (node.getChildren().isEmpty() && (hasParent = parentOfPath.containsKey(node.getPath()))) {
                leafConsumer.accept((TestTreeModel)node);
            }
        });
    }

    public TestTreeModelResultsProvider(TestTreeModel root, TestOutputReader outputReader) {
        this.classesById = TestTreeModelResultsProvider.createClasses(root);
        this.outputReader = outputReader;
    }

    @Override
    public void visitClasses(Action<? super TestClassResult> visitor) {
        for (ClassNode value : this.classesById.values()) {
            visitor.execute((Object)value.result);
        }
    }

    @Override
    public void writeAllOutput(long classId, TestOutputEvent.Destination destination, Writer writer) {
        ClassNode classNode = this.classesById.get(classId);
        if (classNode == null) {
            throw new IllegalArgumentException("No class with id " + classId);
        }
        try {
            this.outputReader.useTestOutputEvents(Iterables.concat(classNode.outputEntries, (Iterable)classNode.methodOutputEntries.values()), destination, (IoConsumer<TestOutputEvent>)((IoConsumer)event -> writer.write(event.getMessage())));
        }
        catch (IOException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    @Override
    public void writeNonTestOutput(long classId, TestOutputEvent.Destination destination, Writer writer) {
        ClassNode classNode = this.classesById.get(classId);
        if (classNode == null) {
            throw new IllegalArgumentException("No class with id " + classId);
        }
        try {
            this.outputReader.useTestOutputEvents((Iterable<OutputEntry>)classNode.outputEntries, destination, (IoConsumer<TestOutputEvent>)((IoConsumer)event -> writer.write(event.getMessage())));
        }
        catch (IOException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    @Override
    public void writeTestOutput(long classId, long testId, TestOutputEvent.Destination destination, Writer writer) {
        ClassNode classNode = this.classesById.get(classId);
        if (classNode == null) {
            throw new IllegalArgumentException("No class with id " + classId);
        }
        OutputEntry testEntry = (OutputEntry)classNode.methodOutputEntries.get((Object)testId);
        if (testEntry == null) {
            throw new IllegalArgumentException("No test with id " + testId + " in class with id " + classId);
        }
        try {
            this.outputReader.useTestOutputEvents(testEntry, destination, (IoConsumer<TestOutputEvent>)((IoConsumer)event -> writer.write(event.getMessage())));
        }
        catch (IOException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    @Override
    public boolean hasOutput(long classId, long testId, TestOutputEvent.Destination destination) {
        OutputEntry entry;
        ClassNode model = this.classesById.get(classId);
        if (model != null && (entry = (OutputEntry)model.methodOutputEntries.get((Object)testId)) != null) {
            return this.outputReader.hasOutput(entry, destination);
        }
        return false;
    }

    @Override
    public void close() throws IOException {
        this.outputReader.close();
    }

    private static /* synthetic */ void lambda$createClasses$1(Map parentOfPath, ListMultimap leavesByGroupingNode, TestTreeModel leaf) {
        for (PerRootInfo perRootInfo : leaf.getPerRootInfo().get(0)) {
            if (perRootInfo.getResults().size() > 1) {
                throw new IllegalStateException("Expected exactly one result for leaf node " + leaf.getPath() + " but found: " + perRootInfo.getResults().size());
            }
            TestTreeModel groupingNode = TestTreeModelResultsProvider.findGroupingNode(parentOfPath, leaf, perRootInfo.getResults().get(0).getClassName());
            leavesByGroupingNode.put((Object)groupingNode, (Object)perRootInfo);
        }
    }

    private static final class ClassNode {
        final TestClassResult result;
        final ImmutableList<OutputEntry> outputEntries;
        final ImmutableMap<Long, OutputEntry> methodOutputEntries;

        ClassNode(TestClassResult result, ImmutableList<OutputEntry> outputEntries, ImmutableMap<Long, OutputEntry> methodOutputEntries) {
            this.result = result;
            this.outputEntries = outputEntries;
            this.methodOutputEntries = methodOutputEntries;
        }
    }
}

