/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider.runner;

import org.gradle.internal.buildtree.BuildActionRunner;
import org.gradle.internal.buildtree.BuildTreeLifecycleController;
import org.gradle.internal.buildtree.BuildTreeModelAction;
import org.gradle.internal.buildtree.BuildTreeModelController;
import org.gradle.internal.buildtree.BuildTreeModelTarget;
import org.gradle.internal.buildtree.ToolingModelRequestContext;
import org.gradle.internal.invocation.BuildAction;
import org.gradle.tooling.internal.protocol.InternalUnsupportedModelException;
import org.gradle.tooling.internal.provider.action.BuildModelAction;
import org.gradle.tooling.internal.provider.serialization.PayloadSerializer;
import org.gradle.tooling.internal.provider.serialization.SerializedPayload;
import org.gradle.tooling.provider.model.UnknownModelException;
import org.gradle.tooling.provider.model.internal.ToolingModelBuilderResultInternal;
import org.jspecify.annotations.Nullable;

public class BuildModelActionRunner
implements BuildActionRunner {
    private final PayloadSerializer payloadSerializer;

    public BuildModelActionRunner(PayloadSerializer payloadSerializer) {
        this.payloadSerializer = payloadSerializer;
    }

    public BuildActionRunner.Result run(BuildAction action, BuildTreeLifecycleController buildController) {
        if (!(action instanceof BuildModelAction)) {
            return BuildActionRunner.Result.nothing();
        }
        BuildModelAction buildModelAction = (BuildModelAction)action;
        ModelCreateAction createAction = new ModelCreateAction(buildModelAction);
        try {
            if (buildModelAction.isCreateModel()) {
                ToolingModelBuilderResultInternal result = (ToolingModelBuilderResultInternal)buildController.fromBuildModel(buildModelAction.isRunTasks(), (BuildTreeModelAction)createAction);
                SerializedPayload serializedResult = this.payloadSerializer.serialize(result.getModel());
                return BuildActionRunner.Result.of((Object)serializedResult);
            }
            buildController.scheduleAndRunTasks();
            return BuildActionRunner.Result.of(null);
        }
        catch (RuntimeException e) {
            RuntimeException clientFailure = e;
            if (createAction.modelLookupFailure != null) {
                clientFailure = (RuntimeException)new InternalUnsupportedModelException().initCause((Throwable)createAction.modelLookupFailure);
            }
            return BuildActionRunner.Result.failed((Throwable)e, (RuntimeException)clientFailure);
        }
    }

    private static class ModelCreateAction
    implements BuildTreeModelAction<ToolingModelBuilderResultInternal> {
        private final BuildModelAction buildModelAction;
        private UnknownModelException modelLookupFailure;

        public ModelCreateAction(BuildModelAction buildModelAction) {
            this.buildModelAction = buildModelAction;
        }

        public void beforeTasks(BuildTreeModelController controller) {
        }

        public @Nullable ToolingModelBuilderResultInternal fromBuildModel(BuildTreeModelController controller) {
            String modelName = this.buildModelAction.getModelName();
            try {
                ToolingModelRequestContext modelRequestContext = new ToolingModelRequestContext(modelName, null, false);
                return controller.getModel((BuildTreeModelTarget)BuildTreeModelTarget.ofDefault(), modelRequestContext);
            }
            catch (UnknownModelException e) {
                this.modelLookupFailure = e;
                throw e;
            }
        }
    }
}

