/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.plugins;

import java.io.File;
import java.util.Collection;
import java.util.Set;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Incubating;
import org.gradle.api.NamedDomainObjectFactory;
import org.gradle.api.Namer;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.repositories.ArtifactRepository;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.CollectionCallbackActionDecorator;
import org.gradle.api.internal.DefaultPolymorphicDomainObjectContainer;
import org.gradle.api.internal.collections.DomainObjectCollectionFactory;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.resolve.ProjectModelResolver;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.internal.Cast;
import org.gradle.internal.build.BuildProjectRegistry;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.language.base.LanguageSourceSet;
import org.gradle.language.base.internal.LanguageSourceSetInternal;
import org.gradle.language.base.internal.SourceTransformTaskConfig;
import org.gradle.language.base.internal.registry.LanguageTransformContainer;
import org.gradle.language.base.plugins.ComponentModelBasePlugin;
import org.gradle.language.nativeplatform.DependentSourceSet;
import org.gradle.language.nativeplatform.HeaderExportingSourceSet;
import org.gradle.language.nativeplatform.internal.DependentSourceSetInternal;
import org.gradle.model.Defaults;
import org.gradle.model.Each;
import org.gradle.model.Finalize;
import org.gradle.model.Model;
import org.gradle.model.ModelMap;
import org.gradle.model.Mutate;
import org.gradle.model.Path;
import org.gradle.model.RuleSource;
import org.gradle.nativeplatform.BuildType;
import org.gradle.nativeplatform.BuildTypeContainer;
import org.gradle.nativeplatform.Flavor;
import org.gradle.nativeplatform.FlavorContainer;
import org.gradle.nativeplatform.NativeComponentSpec;
import org.gradle.nativeplatform.NativeDependencySet;
import org.gradle.nativeplatform.NativeExecutableBinarySpec;
import org.gradle.nativeplatform.NativeExecutableSpec;
import org.gradle.nativeplatform.NativeLibrarySpec;
import org.gradle.nativeplatform.PrebuiltLibraries;
import org.gradle.nativeplatform.PrebuiltLibrary;
import org.gradle.nativeplatform.Repositories;
import org.gradle.nativeplatform.SharedLibraryBinarySpec;
import org.gradle.nativeplatform.StaticLibraryBinarySpec;
import org.gradle.nativeplatform.TargetedNativeComponent;
import org.gradle.nativeplatform.internal.DefaultBuildTypeContainer;
import org.gradle.nativeplatform.internal.DefaultFlavorContainer;
import org.gradle.nativeplatform.internal.DefaultNativeExecutableBinarySpec;
import org.gradle.nativeplatform.internal.DefaultNativeExecutableSpec;
import org.gradle.nativeplatform.internal.DefaultNativeLibrarySpec;
import org.gradle.nativeplatform.internal.DefaultSharedLibraryBinarySpec;
import org.gradle.nativeplatform.internal.DefaultStaticLibraryBinarySpec;
import org.gradle.nativeplatform.internal.NativeBinarySpecInternal;
import org.gradle.nativeplatform.internal.NativeComponents;
import org.gradle.nativeplatform.internal.NativeDependentBinariesResolutionStrategy;
import org.gradle.nativeplatform.internal.NativeExecutableBinarySpecInternal;
import org.gradle.nativeplatform.internal.NativePlatformResolver;
import org.gradle.nativeplatform.internal.SharedLibraryBinarySpecInternal;
import org.gradle.nativeplatform.internal.StaticLibraryBinarySpecInternal;
import org.gradle.nativeplatform.internal.TargetedNativeComponentInternal;
import org.gradle.nativeplatform.internal.configure.NativeComponentRules;
import org.gradle.nativeplatform.internal.pch.PchEnabledLanguageTransform;
import org.gradle.nativeplatform.internal.prebuilt.DefaultPrebuiltLibraries;
import org.gradle.nativeplatform.internal.prebuilt.PrebuiltLibraryInitializer;
import org.gradle.nativeplatform.internal.resolve.NativeDependencyResolver;
import org.gradle.nativeplatform.platform.NativePlatform;
import org.gradle.nativeplatform.platform.internal.DefaultNativePlatform;
import org.gradle.nativeplatform.platform.internal.NativePlatforms;
import org.gradle.nativeplatform.plugins.NativeComponentPlugin;
import org.gradle.nativeplatform.tasks.CreateStaticLibrary;
import org.gradle.nativeplatform.tasks.LinkSharedLibrary;
import org.gradle.nativeplatform.tasks.PrefixHeaderFileGenerateTask;
import org.gradle.nativeplatform.toolchain.NativeToolChainRegistry;
import org.gradle.nativeplatform.toolchain.internal.NativeToolChainRegistryInternal;
import org.gradle.nativeplatform.toolchain.internal.plugins.StandardToolChainsPlugin;
import org.gradle.platform.base.BinaryContainer;
import org.gradle.platform.base.BinarySpec;
import org.gradle.platform.base.BinaryTasks;
import org.gradle.platform.base.ComponentSpecContainer;
import org.gradle.platform.base.ComponentType;
import org.gradle.platform.base.Platform;
import org.gradle.platform.base.PlatformContainer;
import org.gradle.platform.base.SourceComponentSpec;
import org.gradle.platform.base.TypeBuilder;
import org.gradle.platform.base.internal.HasIntermediateOutputsComponentSpec;
import org.gradle.platform.base.internal.PlatformResolver;
import org.gradle.platform.base.internal.PlatformResolvers;
import org.gradle.platform.base.internal.dependents.DependentBinariesResolutionStrategy;
import org.gradle.platform.base.internal.dependents.DependentBinariesResolver;

@Incubating
public abstract class NativeComponentModelPlugin
implements Plugin<Project> {
    @Inject
    public NativeComponentModelPlugin(Instantiator instantiator, CollectionCallbackActionDecorator collectionCallbackActionDecorator) {
    }

    public void apply(Project project) {
        project.getPluginManager().apply(ComponentModelBasePlugin.class);
        project.getPluginManager().apply(NativeComponentPlugin.class);
        project.getPluginManager().apply(StandardToolChainsPlugin.class);
        project.getExtensions().create(BuildTypeContainer.class, "buildTypes", DefaultBuildTypeContainer.class, new Object[0]);
        project.getExtensions().create(FlavorContainer.class, "flavors", DefaultFlavorContainer.class, new Object[0]);
    }

    private static class ArtifactRepositoryNamer
    implements Namer<ArtifactRepository> {
        private ArtifactRepositoryNamer() {
        }

        public String determineName(ArtifactRepository object) {
            return object.getName();
        }
    }

    private static class DefaultRepositories
    extends DefaultPolymorphicDomainObjectContainer<ArtifactRepository>
    implements Repositories {
        private DefaultRepositories(final Instantiator instantiator, final ObjectFactory objectFactory, final Action<PrebuiltLibrary> binaryFactory, final CollectionCallbackActionDecorator collectionCallbackActionDecorator, final DomainObjectCollectionFactory domainObjectCollectionFactory) {
            super(ArtifactRepository.class, instantiator, (Namer)new ArtifactRepositoryNamer(), collectionCallbackActionDecorator);
            this.registerFactory(PrebuiltLibraries.class, (NamedDomainObjectFactory)new NamedDomainObjectFactory<PrebuiltLibraries>(){

                public PrebuiltLibraries create(String name) {
                    return (PrebuiltLibraries)instantiator.newInstance(DefaultPrebuiltLibraries.class, new Object[]{name, instantiator, objectFactory, binaryFactory, collectionCallbackActionDecorator, domainObjectCollectionFactory});
                }
            });
        }
    }

    static class Rules
    extends RuleSource {
        Rules() {
        }

        @ComponentType
        void nativeExecutable(TypeBuilder<NativeExecutableSpec> builder) {
            builder.defaultImplementation(DefaultNativeExecutableSpec.class);
        }

        @ComponentType
        void nativeLibrary(TypeBuilder<NativeLibrarySpec> builder) {
            builder.defaultImplementation(DefaultNativeLibrarySpec.class);
        }

        @ComponentType
        void registerTargetedNativeComponent(TypeBuilder<TargetedNativeComponent> builder) {
            builder.internalView(TargetedNativeComponentInternal.class);
        }

        @ComponentType
        void registerNativeComponent(TypeBuilder<NativeComponentSpec> builder) {
            builder.internalView(HasIntermediateOutputsComponentSpec.class);
        }

        @Model
        Repositories repositories(ServiceRegistry serviceRegistry, FlavorContainer flavors, PlatformContainer platforms, BuildTypeContainer buildTypes, CollectionCallbackActionDecorator callbackActionDecorator) {
            Instantiator instantiator = (Instantiator)serviceRegistry.get(Instantiator.class);
            ObjectFactory sourceDirectorySetFactory = (ObjectFactory)serviceRegistry.get(ObjectFactory.class);
            NativePlatforms nativePlatforms = (NativePlatforms)serviceRegistry.get(NativePlatforms.class);
            FileCollectionFactory fileCollectionFactory = (FileCollectionFactory)serviceRegistry.get(FileCollectionFactory.class);
            PrebuiltLibraryInitializer initializer = new PrebuiltLibraryInitializer(instantiator, fileCollectionFactory, nativePlatforms, (Collection<? extends NativePlatform>)platforms.withType(NativePlatform.class), (Collection<? extends BuildType>)((Object)buildTypes), (Collection<? extends Flavor>)((Object)flavors));
            DomainObjectCollectionFactory domainObjectCollectionFactory = (DomainObjectCollectionFactory)serviceRegistry.get(DomainObjectCollectionFactory.class);
            return new DefaultRepositories(instantiator, sourceDirectorySetFactory, initializer, callbackActionDecorator, domainObjectCollectionFactory);
        }

        @Model
        NativeToolChainRegistryInternal toolChains(ExtensionContainer extensionContainer) {
            return (NativeToolChainRegistryInternal)Cast.cast(NativeToolChainRegistryInternal.class, (Object)((NativeToolChainRegistry)extensionContainer.getByType(NativeToolChainRegistry.class)));
        }

        @Model
        BuildTypeContainer buildTypes(ExtensionContainer extensionContainer) {
            return (BuildTypeContainer)extensionContainer.getByType(BuildTypeContainer.class);
        }

        @Model
        FlavorContainer flavors(ExtensionContainer extensionContainer) {
            return (FlavorContainer)extensionContainer.getByType(FlavorContainer.class);
        }

        @Mutate
        public void registerNativePlatformResolver(PlatformResolvers resolvers, ServiceRegistry serviceRegistry) {
            resolvers.register((PlatformResolver)serviceRegistry.get(NativePlatformResolver.class));
        }

        @Defaults
        public void registerFactoryForCustomNativePlatforms(PlatformContainer platforms, final Instantiator instantiator) {
            NamedDomainObjectFactory<NativePlatform> nativePlatformFactory = new NamedDomainObjectFactory<NativePlatform>(){

                public NativePlatform create(String name) {
                    return (NativePlatform)instantiator.newInstance(DefaultNativePlatform.class, new Object[]{name});
                }
            };
            platforms.registerFactory(NativePlatform.class, (NamedDomainObjectFactory)nativePlatformFactory);
            platforms.registerFactory(Platform.class, (NamedDomainObjectFactory)nativePlatformFactory);
        }

        @ComponentType
        void registerSharedLibraryBinaryType(TypeBuilder<SharedLibraryBinarySpec> builder) {
            builder.defaultImplementation(DefaultSharedLibraryBinarySpec.class);
            builder.internalView(SharedLibraryBinarySpecInternal.class);
        }

        @ComponentType
        void registerStaticLibraryBinaryType(TypeBuilder<StaticLibraryBinarySpec> builder) {
            builder.defaultImplementation(DefaultStaticLibraryBinarySpec.class);
            builder.internalView(StaticLibraryBinarySpecInternal.class);
        }

        @ComponentType
        void registerNativeExecutableBinaryType(TypeBuilder<NativeExecutableBinarySpec> builder) {
            builder.defaultImplementation(DefaultNativeExecutableBinarySpec.class);
            builder.internalView(NativeExecutableBinarySpecInternal.class);
        }

        @Finalize
        public void createDefaultBuildTypes(BuildTypeContainer buildTypes) {
            if (buildTypes.isEmpty()) {
                buildTypes.create("debug");
            }
        }

        @Finalize
        public void createDefaultFlavor(FlavorContainer flavors) {
            if (flavors.isEmpty()) {
                flavors.create("default");
            }
        }

        @Finalize
        void configureGeneratedSourceSets(@Each LanguageSourceSetInternal languageSourceSet) {
            Task generatorTask = languageSourceSet.getGeneratorTask();
            if (generatorTask != null) {
                languageSourceSet.builtBy(new Object[]{generatorTask});
                this.maybeSetSourceDir(languageSourceSet.getSource(), generatorTask, "sourceDir");
                if (languageSourceSet instanceof HeaderExportingSourceSet) {
                    this.maybeSetSourceDir(((HeaderExportingSourceSet)languageSourceSet).getExportedHeaders(), generatorTask, "headerDir");
                }
            }
        }

        @Defaults
        void configurePrefixHeaderFiles(final @Each SourceComponentSpec componentSpec, final @Path(value="buildDir") File buildDir) {
            componentSpec.getSources().withType(DependentSourceSetInternal.class).afterEach((Action)new Action<DependentSourceSetInternal>(){

                public void execute(DependentSourceSetInternal dependentSourceSet) {
                    if (dependentSourceSet.getPreCompiledHeader() != null) {
                        String prefixHeaderDirName = "tmp/" + componentSpec.getName() + "/" + dependentSourceSet.getName() + "/prefixHeaders";
                        File prefixHeaderDir = new File(buildDir, prefixHeaderDirName);
                        File prefixHeaderFile = new File(prefixHeaderDir, "prefix-headers.h");
                        dependentSourceSet.setPrefixHeaderFile(prefixHeaderFile);
                    }
                }
            });
        }

        @Mutate
        void configurePrefixHeaderGenerationTasks(TaskContainer tasks, ComponentSpecContainer components) {
            for (SourceComponentSpec nativeComponentSpec : components.withType(SourceComponentSpec.class).values()) {
                for (final DependentSourceSetInternal dependentSourceSet : nativeComponentSpec.getSources().withType(DependentSourceSetInternal.class).values()) {
                    if (dependentSourceSet.getPrefixHeaderFile() == null) continue;
                    String taskName = "generate" + StringUtils.capitalize((String)nativeComponentSpec.getName()) + StringUtils.capitalize((String)dependentSourceSet.getName()) + "PrefixHeaderFile";
                    tasks.create(taskName, PrefixHeaderFileGenerateTask.class, (Action)new Action<PrefixHeaderFileGenerateTask>(){

                        public void execute(PrefixHeaderFileGenerateTask prefixHeaderFileGenerateTask) {
                            prefixHeaderFileGenerateTask.setPrefixHeaderFile(dependentSourceSet.getPrefixHeaderFile());
                            prefixHeaderFileGenerateTask.setHeader(dependentSourceSet.getPreCompiledHeader());
                        }
                    });
                }
            }
        }

        @Mutate
        void configurePreCompiledHeaderCompileTasks(final TaskContainer tasks, BinaryContainer binaries, LanguageTransformContainer languageTransforms, final ServiceRegistry serviceRegistry) {
            for (final NativeBinarySpecInternal nativeBinarySpec : binaries.withType(NativeBinarySpecInternal.class)) {
                for (final PchEnabledLanguageTransform transform : languageTransforms.withType(PchEnabledLanguageTransform.class)) {
                    nativeBinarySpec.getInputs().withType(transform.getSourceSetType(), (Action)new Action<LanguageSourceSet>(){

                        public void execute(LanguageSourceSet languageSourceSet) {
                            final DependentSourceSet dependentSourceSet = (DependentSourceSet)languageSourceSet;
                            if (dependentSourceSet.getPreCompiledHeader() != null) {
                                nativeBinarySpec.addPreCompiledHeaderFor(dependentSourceSet);
                                final SourceTransformTaskConfig pchTransformTaskConfig = transform.getPchTransformTask();
                                String pchTaskName = pchTransformTaskConfig.getTaskPrefix() + StringUtils.capitalize((String)nativeBinarySpec.getProjectScopedName()) + StringUtils.capitalize((String)dependentSourceSet.getName()) + "PreCompiledHeader";
                                Task pchTask = tasks.create(pchTaskName, pchTransformTaskConfig.getTaskType(), (Action)new Action<DefaultTask>(){

                                    public void execute(DefaultTask task) {
                                        pchTransformTaskConfig.configureTask((Task)task, (BinarySpec)nativeBinarySpec, (LanguageSourceSet)dependentSourceSet, serviceRegistry);
                                    }
                                });
                                nativeBinarySpec.getTasks().add((Object)pchTask);
                            }
                        }
                    });
                }
            }
        }

        private void maybeSetSourceDir(SourceDirectorySet sourceSet, Task task, String propertyName) {
            Object value = task.property(propertyName);
            if (value != null) {
                sourceSet.srcDir(value);
            }
        }

        @BinaryTasks
        public void sharedLibraryTasks(ModelMap<Task> tasks, final SharedLibraryBinarySpecInternal binary) {
            String taskName = binary.getNamingScheme().getTaskName("link");
            tasks.create(taskName, LinkSharedLibrary.class, (Action)new Action<LinkSharedLibrary>(){

                public void execute(LinkSharedLibrary linkTask) {
                    linkTask.setDescription("Links " + binary.getDisplayName());
                    linkTask.getToolChain().set((Object)binary.getToolChain());
                    linkTask.getTargetPlatform().set((Object)binary.getTargetPlatform());
                    linkTask.getLinkedFile().set(binary.getSharedLibraryFile());
                    linkTask.getInstallName().set((Object)binary.getSharedLibraryFile().getName());
                    linkTask.getLinkerArgs().set(binary.getLinker().getArgs());
                    linkTask.getImportLibrary().set(binary.getSharedLibraryLinkFile());
                    linkTask.lib(new NativeComponents.BinaryLibs(binary){

                        @Override
                        protected FileCollection getFiles(NativeDependencySet nativeDependencySet) {
                            return nativeDependencySet.getLinkFiles();
                        }
                    });
                }
            });
        }

        @BinaryTasks
        public void staticLibraryTasks(ModelMap<Task> tasks, final StaticLibraryBinarySpecInternal binary) {
            String taskName = binary.getNamingScheme().getTaskName("create");
            tasks.create(taskName, CreateStaticLibrary.class, (Action)new Action<CreateStaticLibrary>(){

                public void execute(CreateStaticLibrary task) {
                    task.setDescription("Creates " + binary.getDisplayName());
                    task.getToolChain().set((Object)binary.getToolChain());
                    task.getTargetPlatform().set((Object)binary.getTargetPlatform());
                    task.getOutputFile().set(binary.getStaticLibraryFile());
                    task.getStaticLibArgs().set(binary.getStaticLibArchiver().getArgs());
                }
            });
        }

        @BinaryTasks
        public void executableTasks(ModelMap<Task> tasks, NativeExecutableBinarySpecInternal executableBinary) {
            NativeComponents.createExecutableTask(executableBinary, executableBinary.getExecutable().getFile());
        }

        @Defaults
        public void createBuildDependentComponentsTasks(ModelMap<Task> tasks, ComponentSpecContainer components, BinaryContainer binaries) {
            NativeComponents.createBuildDependentComponentsTasks(tasks, components);
        }

        @BinaryTasks
        public void createBuildDependentBinariesTasks(ModelMap<Task> tasks, NativeBinarySpecInternal nativeBinary) {
            NativeComponents.createBuildDependentBinariesTasks(nativeBinary, nativeBinary.getNamingScheme());
        }

        @Finalize
        public void wireBuildDependentTasks(ModelMap<Task> tasks, BinaryContainer binaries, DependentBinariesResolver dependentsResolver, ServiceRegistry serviceRegistry) {
            NativeComponents.wireBuildDependentTasks(tasks, binaries, dependentsResolver, (ProjectModelResolver)serviceRegistry.get(ProjectModelResolver.class));
        }

        @Defaults
        void createInstallTasks(ModelMap<Task> tasks, BinaryContainer binaries) {
            for (NativeExecutableBinarySpecInternal binary : binaries.withType(NativeExecutableBinarySpecInternal.class).values()) {
                NativeComponents.createInstallTask(binary, binary.getInstallation(), binary.getExecutable(), binary.getNamingScheme());
            }
        }

        @Finalize
        void applyHeaderSourceSetConventions(@Each HeaderExportingSourceSet headerSourceSet) {
            if (headerSourceSet.getExportedHeaders().getSourceDirectories().isEmpty()) {
                headerSourceSet.getExportedHeaders().srcDir((Object)("src/" + headerSourceSet.getParentName() + "/headers"));
            }
            headerSourceSet.getImplicitHeaders().setSrcDirs((Iterable)headerSourceSet.getSource().getSourceDirectories());
            headerSourceSet.getImplicitHeaders().include(new String[]{"**/*.h"});
        }

        @Finalize
        void createBinaries(@Each TargetedNativeComponentInternal nativeComponent, PlatformResolvers platforms, BuildTypeContainer buildTypes, FlavorContainer flavors, ServiceRegistry serviceRegistry) {
            NativePlatforms nativePlatforms = (NativePlatforms)serviceRegistry.get(NativePlatforms.class);
            NativeDependencyResolver nativeDependencyResolver = (NativeDependencyResolver)serviceRegistry.get(NativeDependencyResolver.class);
            FileCollectionFactory fileCollectionFactory = (FileCollectionFactory)serviceRegistry.get(FileCollectionFactory.class);
            NativeComponentRules.createBinariesImpl(nativeComponent, platforms, (Set<? extends BuildType>)((Object)buildTypes), (Set<? extends Flavor>)((Object)flavors), nativePlatforms, nativeDependencyResolver, fileCollectionFactory);
        }

        @Defaults
        void registerNativeDependentBinariesResolutionStrategy(DependentBinariesResolver resolver, ServiceRegistry serviceRegistry) {
            BuildProjectRegistry projectRegistry = ((BuildState)serviceRegistry.get(BuildState.class)).getProjects();
            ProjectModelResolver projectModelResolver = (ProjectModelResolver)serviceRegistry.get(ProjectModelResolver.class);
            resolver.register((DependentBinariesResolutionStrategy)new NativeDependentBinariesResolutionStrategy(projectRegistry, projectModelResolver));
        }
    }
}

