/*
 * Decompiled with CFR 0.152.
 */
package com.jediterm.terminal.ui.input;

import com.jediterm.core.input.MouseEvent;
import java.awt.event.MouseWheelEvent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public final class AwtMouseEvent
extends MouseEvent {
    private final java.awt.event.MouseEvent myAwtMouseEvent;

    public AwtMouseEvent(@NotNull java.awt.event.MouseEvent awtMouseEvent) {
        super(AwtMouseEvent.createButtonCode(awtMouseEvent), AwtMouseEvent.getModifierKeys(awtMouseEvent));
        this.myAwtMouseEvent = awtMouseEvent;
    }

    public String toString() {
        return this.myAwtMouseEvent.toString();
    }

    static int createButtonCode(@NotNull java.awt.event.MouseEvent awtMouseEvent) {
        if (SwingUtilities.isLeftMouseButton(awtMouseEvent)) {
            return 0;
        }
        if (SwingUtilities.isMiddleMouseButton(awtMouseEvent)) {
            return 1;
        }
        if (SwingUtilities.isRightMouseButton(awtMouseEvent)) {
            return -1;
        }
        if (awtMouseEvent instanceof MouseWheelEvent) {
            int rotation = ((MouseWheelEvent)awtMouseEvent).getWheelRotation();
            if (rotation > 0) {
                return 5;
            }
            if (rotation < 0) {
                return 4;
            }
            return -1;
        }
        return -1;
    }

    static int getModifierKeys(@NotNull java.awt.event.MouseEvent awtMouseEvent) {
        int modifier = 0;
        if (awtMouseEvent.isControlDown()) {
            modifier |= 0x10;
        }
        if (awtMouseEvent.isShiftDown()) {
            modifier |= 4;
        }
        if (awtMouseEvent.isMetaDown()) {
            modifier |= 8;
        }
        return modifier;
    }
}

