/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation;

import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.rt.coverage.util.ErrorReporter;
import com.intellij.rt.coverage.util.MethodCaller;
import com.intellij.rt.coverage.util.OptionsUtil;
import com.intellij.rt.coverage.util.TestTrackingCallback;

public class CoverageRuntime {
    public static final String COVERAGE_RUNTIME_OWNER = "com/intellij/rt/coverage/instrumentation/CoverageRuntime";
    private static final MethodCaller GET_HITS_METHOD = new MethodCaller("getHits", new Class[]{String.class});
    private static final MethodCaller GET_HITS_CACHED_METHOD = new MethodCaller("getHitsCached", new Class[]{String.class});
    private static final MethodCaller GET_HITS_MASK_METHOD = new MethodCaller("getHitsMask", new Class[]{String.class});
    private static final MethodCaller GET_HITS_MASK_CACHED_METHOD = new MethodCaller("getHitsMaskCached", new Class[]{String.class});
    private static final MethodCaller GET_TRACE_MASK_METHOD = new MethodCaller("getTraceMask", new Class[]{String.class});
    private static final MethodCaller LOAD_CLASS_DATA_METHOD = new MethodCaller("loadClassData", new Class[]{String.class});
    private static final MethodCaller LOAD_CLASS_DATA_CACHED_METHOD = new MethodCaller("loadClassDataCached", new Class[]{String.class});
    private static final MethodCaller REGISTER_CLASS_FOR_TRACE_METHOD = new MethodCaller("registerClassForTrace", new Class[]{Object.class});
    private static final MethodCaller TRACE_LINE_METHOD = new MethodCaller("traceLine", new Class[]{Object.class, Integer.TYPE});
    private static Object ourRuntimeObject;
    public static CoverageRuntime ourRuntime;
    public final ProjectData myProjectData;
    private ClassesMap myClassesMap;

    /*
     * WARNING - void declaration
     */
    private CoverageRuntime(ProjectData projectData) {
        void var1_1;
        this.myProjectData = var1_1;
    }

    public static void installRuntime(ProjectData projectData) {
        ProjectData projectData2;
        ourRuntime = new CoverageRuntime(projectData);
        ProjectData.ourProjectData = projectData2;
    }

    /*
     * WARNING - void declaration
     */
    private ClassesMap getClassesMap() {
        void var1_1;
        ClassesMap map = this.myClassesMap;
        if (map == null) {
            CoverageRuntime coverageRuntime = this;
            synchronized (coverageRuntime) {
                map = this.myClassesMap;
                if (map == null) {
                    this.myClassesMap = map = new ClassesMap();
                }
            }
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static void traceLine(Object classData, int line) {
        if (ourRuntime != null) {
            TestTrackingCallback callback = CoverageRuntime.ourRuntime.myProjectData.myTestTrackingCallback;
            if (callback != null) {
                callback.traceLineByTest(classData, line);
            }
            return;
        }
        try {
            void var1_1;
            Object runtimeObject = CoverageRuntime.getRuntimeObject();
            TRACE_LINE_METHOD.invoke(runtimeObject, new Object[]{classData, (int)var1_1});
            return;
        }
        catch (Exception e) {
            void var2_4;
            Object object;
            ErrorReporter.error("Error during test tracking in class " + object.toString(), (Throwable)var2_4);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void checkRegister(boolean[] trace, Object classData) {
        if (!trace[0]) {
            void var1_1;
            CoverageRuntime.registerClassForTrace(var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void registerClassForTrace(Object classData) {
        if (ourRuntime != null) {
            TestTrackingCallback callback = CoverageRuntime.ourRuntime.myProjectData.myTestTrackingCallback;
            if (callback != null) {
                callback.registerForTrace(classData);
            }
            return;
        }
        try {
            Object runtimeObject = CoverageRuntime.getRuntimeObject();
            REGISTER_CLASS_FOR_TRACE_METHOD.invoke(runtimeObject, new Object[]{classData});
            return;
        }
        catch (Exception e) {
            void var1_3;
            Object object;
            ErrorReporter.error("Error during test tracking in class " + object.toString(), (Throwable)var1_3);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static int[] getHits(String className) {
        CoverageRuntime runtime = ourRuntime;
        if (runtime != null) {
            return (int[])runtime.myProjectData.getClassData(className).getHitsMask();
        }
        try {
            Object runtimeObject = CoverageRuntime.getRuntimeObject();
            return (int[])GET_HITS_METHOD.invoke(runtimeObject, new Object[]{className});
        }
        catch (Exception e) {
            void var1_2;
            String string;
            ErrorReporter.error("Error in class data access: " + string, (Throwable)var1_2);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static int[] getHitsCached(String className) {
        CoverageRuntime runtime = ourRuntime;
        if (runtime != null) {
            return (int[])runtime.getClassesMap().get(className, runtime.myProjectData).getHitsMask();
        }
        try {
            Object runtimeObject = CoverageRuntime.getRuntimeObject();
            return (int[])GET_HITS_CACHED_METHOD.invoke(runtimeObject, new Object[]{className});
        }
        catch (Exception e) {
            void var1_2;
            String string;
            ErrorReporter.error("Error in class data access: " + string, (Throwable)var1_2);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static boolean[] getHitsMask(String className) {
        CoverageRuntime runtime = ourRuntime;
        if (runtime != null) {
            return (boolean[])runtime.myProjectData.getClassData(className).getHitsMask();
        }
        try {
            Object runtimeObject = CoverageRuntime.getRuntimeObject();
            return (boolean[])GET_HITS_MASK_METHOD.invoke(runtimeObject, new Object[]{className});
        }
        catch (Exception e) {
            void var1_2;
            String string;
            ErrorReporter.error("Error in class data access: " + string, (Throwable)var1_2);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static boolean[] getHitsMaskCached(String className) {
        CoverageRuntime runtime = ourRuntime;
        if (runtime != null) {
            return (boolean[])runtime.getClassesMap().get(className, runtime.myProjectData).getHitsMask();
        }
        try {
            Object runtimeObject = CoverageRuntime.getRuntimeObject();
            return (boolean[])GET_HITS_MASK_CACHED_METHOD.invoke(runtimeObject, new Object[]{className});
        }
        catch (Exception e) {
            void var1_2;
            String string;
            ErrorReporter.error("Error in class data access: " + string, (Throwable)var1_2);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static boolean[] getTraceMask(String className) {
        CoverageRuntime runtime = ourRuntime;
        if (runtime != null) {
            return runtime.myProjectData.getClassData(className).getTraceMask();
        }
        try {
            Object runtimeObject = CoverageRuntime.getRuntimeObject();
            return (boolean[])GET_TRACE_MASK_METHOD.invoke(runtimeObject, new Object[]{className});
        }
        catch (Exception e) {
            void var1_2;
            String string;
            ErrorReporter.error("Error in class data access: " + string, (Throwable)var1_2);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static Object loadClassData(String className) {
        CoverageRuntime runtime = ourRuntime;
        if (runtime != null) {
            return runtime.myProjectData.getClassData(className);
        }
        try {
            Object runtimeObject = CoverageRuntime.getRuntimeObject();
            return LOAD_CLASS_DATA_METHOD.invoke(runtimeObject, new Object[]{className});
        }
        catch (Exception e) {
            void var1_2;
            String string;
            ErrorReporter.error("Error in class data loading: " + string, (Throwable)var1_2);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static Object loadClassDataCached(String className) {
        CoverageRuntime runtime = ourRuntime;
        if (runtime != null) {
            return runtime.getClassesMap().get(className, runtime.myProjectData);
        }
        try {
            Object runtimeObject = CoverageRuntime.getRuntimeObject();
            return LOAD_CLASS_DATA_CACHED_METHOD.invoke(runtimeObject, new Object[]{className});
        }
        catch (Exception e) {
            void var1_2;
            String string;
            ErrorReporter.error("Error in class data loading: " + string, (Throwable)var1_2);
            return null;
        }
    }

    private static Object getRuntimeObject() throws ClassNotFoundException, IllegalAccessException, NoSuchFieldException {
        if (ourRuntimeObject == null) {
            Class<?> clazz;
            ClassLoader classLoader = OptionsUtil.USE_SYSTEM_CLASS_LOADER ? ClassLoader.getSystemClassLoader() : null;
            clazz = Class.forName(CoverageRuntime.class.getName(), false, (ClassLoader)((Object)clazz));
            ourRuntimeObject = clazz.getDeclaredField("ourRuntime").get(null);
        }
        return ourRuntimeObject;
    }

    private static class IdentityClassData {
        private final String myClassName;
        private final ClassData myClassData;

        /*
         * WARNING - void declaration
         */
        private IdentityClassData(String className, ClassData classData) {
            void var2_2;
            void var1_1;
            this.myClassName = var1_1;
            this.myClassData = var2_2;
        }

        public ClassData getClassData(String name) {
            if (name == this.myClassName) {
                return this.myClassData;
            }
            return null;
        }
    }

    private static class ClassesMap {
        private final IdentityClassData[] myIdentityArray = new IdentityClassData[1024];

        private ClassesMap() {
        }

        /*
         * WARNING - void declaration
         */
        public ClassData get(String name, ProjectData projectData) {
            void var1_1;
            void var2_2;
            ClassData data;
            int idx = name.hashCode() & 0x3FF;
            IdentityClassData lastClassData = this.myIdentityArray[idx];
            if (lastClassData != null && (data = lastClassData.getClassData(name)) != null) {
                return data;
            }
            data = var2_2.getClassData(name);
            this.myIdentityArray[var3_3] = new IdentityClassData((String)var1_1, data);
            return data;
        }
    }
}

