/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.structure;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KProperty1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirSession;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirSessionCacheStorage;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirSourcesSession;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.structure.LLSessionStatisticsCalculator;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.structure.LLSessionStructureGraph;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.structure.LLSessionStructureGraphBuilder;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.structure.LLSessionStructureGraphNode;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.structure.UtilsKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\u001c\u0010\u000b\u001a\u00020\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J\u0016\u0010\u0010\u001a\u00020\f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000f0\tH\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/structure/LLSessionStructureGraphBuilder;", "", "<init>", "()V", "buildGraph", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/structure/LLSessionStructureGraph;", "storage", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSessionCacheStorage;", "analysisRoots", "", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSession;", "assignDependencies", "", "nodesBySession", "", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/structure/LLSessionStructureGraphNode;", "assignDistancesFromAnalysisRoots", "analysisRootNodes", "low-level-api-fir"})
@SourceDebugExtension(value={"SMAP\nLLSessionStructureGraphBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LLSessionStructureGraphBuilder.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/structure/LLSessionStructureGraphBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,82:1\n1596#2:83\n1629#2,4:84\n1220#2,2:88\n1249#2,4:90\n1642#2,10:94\n1915#2:104\n1916#2:106\n1652#2:107\n1915#2:108\n1642#2,10:109\n1915#2:119\n1916#2:121\n1652#2:122\n1916#2:123\n1915#2,2:124\n1915#2,2:126\n1#3:105\n1#3:120\n*S KotlinDebug\n*F\n+ 1 LLSessionStructureGraphBuilder.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/structure/LLSessionStructureGraphBuilder\n*L\n26#1:83\n26#1:84,4\n33#1:88,2\n33#1:90,4\n39#1:94,10\n39#1:104\n39#1:106\n39#1:107\n46#1:108\n53#1:109,10\n53#1:119\n53#1:121\n53#1:122\n46#1:123\n61#1:124,2\n71#1:126,2\n39#1:105\n53#1:120\n*E\n"})
public final class LLSessionStructureGraphBuilder {
    @NotNull
    public static final LLSessionStructureGraphBuilder INSTANCE = new LLSessionStructureGraphBuilder();

    private LLSessionStructureGraphBuilder() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final LLSessionStructureGraph buildGraph(@NotNull LLFirSessionCacheStorage storage, @NotNull List<? extends LLFirSession> analysisRoots) {
        void $this$mapNotNullTo$iv$iv;
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        Object object;
        void $this$mapIndexedTo$iv$iv;
        Iterable $this$mapIndexed$iv;
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        Intrinsics.checkNotNullParameter(analysisRoots, (String)"analysisRoots");
        Collection<LLFirSession> sourceSessions = storage.getSourceCache().getValues();
        Collection<LLFirSession> librarySessions = storage.getBinaryCache().getValues();
        List sessions = CollectionsKt.plus(sourceSessions, (Iterable)librarySessions);
        Iterable iterable = sessions;
        boolean $i$f$mapIndexed = false;
        void var9_9 = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void session2;
            void index2;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            LLFirSession lLFirSession = (LLFirSession)((Object)item$iv$iv);
            int n2 = n;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(new LLSessionStructureGraphNode((int)index2, (LLFirSession)session2, LLSessionStatisticsCalculator.INSTANCE.calculateSessionStatistics((LLFirSession)session2)));
        }
        $this$mapIndexed$iv = (List)destination$iv$iv;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associateBy$iv;
        Object destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            LLSessionStructureGraphNode lLSessionStructureGraphNode = (LLSessionStructureGraphNode)element$iv$iv;
            object = destination$iv$iv2;
            boolean bl = false;
            object.put(it.getSession(), element$iv$iv);
        }
        Map nodesBySession = destination$iv$iv2;
        this.assignDependencies(nodesBySession);
        LLSessionStructureGraph graph = new LLSessionStructureGraph(nodesBySession);
        Iterable $this$mapNotNull$iv = analysisRoots;
        boolean $i$f$mapNotNull = false;
        destination$iv$iv2 = $this$mapNotNull$iv;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            LLSessionStructureGraphNode it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            LLFirSession it = (LLFirSession)((Object)element$iv$iv);
            boolean bl2 = false;
            if ((LLSessionStructureGraphNode)nodesBySession.get((Object)it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv3.add(it$iv$iv);
        }
        List analysisRootNodes = (List)destination$iv$iv3;
        this.assignDistancesFromAnalysisRoots(analysisRootNodes);
        return graph;
    }

    /*
     * WARNING - void declaration
     */
    private final void assignDependencies(Map<LLFirSession, LLSessionStructureGraphNode> nodesBySession) {
        Iterable $this$forEach$iv = nodesBySession.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            LLSessionStructureGraphNode node = (LLSessionStructureGraphNode)element$iv;
            boolean bl = false;
            LLFirSession session2 = node.getSession();
            if (!(session2 instanceof LLFirSourcesSession) || !UtilsKt.isLazyInitialized((KProperty1)assignDependencies.1.1.INSTANCE, session2)) continue;
            Iterable iterable = ((LLFirSourcesSession)session2).getDependencies();
            LLSessionStructureGraphNode lLSessionStructureGraphNode = node;
            boolean $i$f$mapNotNull = false;
            void var12_12 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach2 = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                LLSessionStructureGraphNode it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl2 = false;
                LLFirSession p0 = (LLFirSession)((Object)element$iv$iv);
                boolean bl3 = false;
                if (nodesBySession.get((Object)p0) == null) continue;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            lLSessionStructureGraphNode.setDependencies((List)destination$iv$iv);
        }
    }

    private final void assignDistancesFromAnalysisRoots(List<LLSessionStructureGraphNode> analysisRootNodes) {
        ArrayDeque queue = new ArrayDeque();
        Iterable $this$forEach$iv = analysisRootNodes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LLSessionStructureGraphNode rootNode = (LLSessionStructureGraphNode)element$iv;
            boolean bl = false;
            rootNode.setAnalysisRootDistance(0);
            queue.add((Object)rootNode);
        }
        while (!((Collection)queue).isEmpty()) {
            LLSessionStructureGraphNode currentNode = (LLSessionStructureGraphNode)queue.removeFirst();
            Integer n = currentNode.getAnalysisRootDistance();
            int currentDistance = n != null ? n : 0;
            int newDistance = currentDistance + 1;
            Iterable $this$forEach$iv2 = currentNode.getDependencies();
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                LLSessionStructureGraphNode dependency = (LLSessionStructureGraphNode)element$iv;
                boolean bl = false;
                Integer currentDependencyDistance = dependency.getAnalysisRootDistance();
                if (currentDependencyDistance != null && currentDependencyDistance <= newDistance) continue;
                dependency.setAnalysisRootDistance(newDistance);
                queue.add((Object)dependency);
            }
        }
    }
}

