/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.caches.resolve;

import com.intellij.openapi.projectRoots.Sdk;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analyzer.ModuleInfo;
import org.jetbrains.kotlin.analyzer.PlatformAnalysisParameters;
import org.jetbrains.kotlin.analyzer.ResolverForModuleFactory;
import org.jetbrains.kotlin.analyzer.ResolverForProject;
import org.jetbrains.kotlin.builtins.DefaultBuiltIns;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.jvm.JvmBuiltIns;
import org.jetbrains.kotlin.caches.resolve.IdePlatformKindResolution;
import org.jetbrains.kotlin.caches.resolve.JvmPlatformKindResolutionKt;
import org.jetbrains.kotlin.context.ProjectContext;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.impl.ModuleDescriptorImpl;
import org.jetbrains.kotlin.idea.base.projectStructure.IdeBuiltInsLoadingState;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.IdeaModuleInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.LibraryInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.SdkInfo;
import org.jetbrains.kotlin.idea.caches.resolve.BuiltInsCacheKey;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.impl.JvmIdePlatformKind;
import org.jetbrains.kotlin.resolve.TargetEnvironment;
import org.jetbrains.kotlin.resolve.jvm.JvmPlatformParameters;
import org.jetbrains.kotlin.resolve.jvm.JvmResolverForModuleFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001$B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J$\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J:\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001a0\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u00152\b\u0010 \u001a\u0004\u0018\u00010\u0017H\u0016J.\u0010!\u001a\u00020\"2\u0006\u0010\u0012\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001a0\u001e2\u0006\u0010\u001f\u001a\u00020\u0015H\u0002J6\u0010#\u001a\u00020\"2\u0006\u0010\u0012\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001a0\u001e2\u0006\u0010\u001f\u001a\u00020\u00152\u0006\u0010 \u001a\u00020\u0017H\u0002R\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/caches/resolve/JvmPlatformKindResolution;", "Lorg/jetbrains/kotlin/caches/resolve/IdePlatformKindResolution;", "<init>", "()V", "createResolverForModuleFactory", "Lorg/jetbrains/kotlin/analyzer/ResolverForModuleFactory;", "settings", "Lorg/jetbrains/kotlin/analyzer/PlatformAnalysisParameters;", "environment", "Lorg/jetbrains/kotlin/resolve/TargetEnvironment;", "platform", "Lorg/jetbrains/kotlin/platform/TargetPlatform;", "kind", "Lorg/jetbrains/kotlin/platform/impl/JvmIdePlatformKind;", "getKind", "()Lorg/jetbrains/kotlin/platform/impl/JvmIdePlatformKind;", "getKeyForBuiltIns", "Lorg/jetbrains/kotlin/idea/caches/resolve/BuiltInsCacheKey;", "moduleInfo", "Lorg/jetbrains/kotlin/analyzer/ModuleInfo;", "sdkInfo", "Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/SdkInfo;", "stdlibInfo", "Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/LibraryInfo;", "createBuiltIns", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/IdeaModuleInfo;", "projectContext", "Lorg/jetbrains/kotlin/context/ProjectContext;", "resolverForProject", "Lorg/jetbrains/kotlin/analyzer/ResolverForProject;", "sdkDependency", "stdlibDependency", "createBuiltInsFromClassLoader", "Lorg/jetbrains/kotlin/builtins/jvm/JvmBuiltIns;", "createBuiltinsFromModuleDependencies", "CacheKeyByBuiltInsDependencies", "kotlin.base.fe10.analysis"})
public final class JvmPlatformKindResolution
implements IdePlatformKindResolution {
    @Override
    @NotNull
    public ResolverForModuleFactory createResolverForModuleFactory(@NotNull PlatformAnalysisParameters settings2, @NotNull TargetEnvironment environment, @NotNull TargetPlatform platform) {
        Intrinsics.checkNotNullParameter((Object)settings2, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
        return (ResolverForModuleFactory)new JvmResolverForModuleFactory((JvmPlatformParameters)settings2, environment, platform);
    }

    @NotNull
    public JvmIdePlatformKind getKind() {
        return JvmIdePlatformKind.INSTANCE;
    }

    @Override
    @NotNull
    public BuiltInsCacheKey getKeyForBuiltIns(@NotNull ModuleInfo moduleInfo, @Nullable SdkInfo sdkInfo, @Nullable LibraryInfo stdlibInfo) {
        Intrinsics.checkNotNullParameter((Object)moduleInfo, (String)"moduleInfo");
        if (IdeBuiltInsLoadingState.INSTANCE.isFromClassLoader() && stdlibInfo != null) {
            JvmPlatformKindResolutionKt.access$getLOG$p().error("Standard library " + stdlibInfo.getDisplayedName() + " provided for built-ins, but loading from dependencies is disabled");
        }
        return sdkInfo != null ? (BuiltInsCacheKey)new CacheKeyByBuiltInsDependencies(sdkInfo.getSdk(), stdlibInfo) : (BuiltInsCacheKey)BuiltInsCacheKey.DefaultBuiltInsKey.INSTANCE;
    }

    @Override
    @NotNull
    public KotlinBuiltIns createBuiltIns(@NotNull IdeaModuleInfo moduleInfo, @NotNull ProjectContext projectContext, @NotNull ResolverForProject<IdeaModuleInfo> resolverForProject, @Nullable SdkInfo sdkDependency, @Nullable LibraryInfo stdlibDependency) {
        Intrinsics.checkNotNullParameter((Object)moduleInfo, (String)"moduleInfo");
        Intrinsics.checkNotNullParameter((Object)projectContext, (String)"projectContext");
        Intrinsics.checkNotNullParameter(resolverForProject, (String)"resolverForProject");
        return sdkDependency == null ? (KotlinBuiltIns)DefaultBuiltIns.Companion.getInstance() : (stdlibDependency == null || moduleInfo instanceof SdkInfo ? (KotlinBuiltIns)this.createBuiltInsFromClassLoader(moduleInfo, projectContext, resolverForProject, sdkDependency) : (KotlinBuiltIns)this.createBuiltinsFromModuleDependencies(moduleInfo, projectContext, resolverForProject, sdkDependency, stdlibDependency));
    }

    private final JvmBuiltIns createBuiltInsFromClassLoader(IdeaModuleInfo moduleInfo, ProjectContext projectContext, ResolverForProject<IdeaModuleInfo> resolverForProject, SdkInfo sdkDependency) {
        JvmBuiltIns jvmBuiltIns;
        JvmBuiltIns $this$createBuiltInsFromClassLoader_u24lambda_u240 = jvmBuiltIns = new JvmBuiltIns(projectContext.getStorageManager(), JvmBuiltIns.Kind.FROM_CLASS_LOADER);
        boolean bl = false;
        $this$createBuiltInsFromClassLoader_u24lambda_u240.setPostponedSettingsComputation(() -> JvmPlatformKindResolution.createBuiltInsFromClassLoader$lambda$0$0(resolverForProject, sdkDependency));
        return jvmBuiltIns;
    }

    private final JvmBuiltIns createBuiltinsFromModuleDependencies(IdeaModuleInfo moduleInfo, ProjectContext projectContext, ResolverForProject<IdeaModuleInfo> resolverForProject, SdkInfo sdkDependency, LibraryInfo stdlibDependency) {
        JvmBuiltIns jvmBuiltIns;
        if (IdeBuiltInsLoadingState.INSTANCE.isFromClassLoader()) {
            JvmPlatformKindResolutionKt.access$getLOG$p().error("Incorrect attempt to create built-ins from module dependencies");
        }
        JvmBuiltIns $this$createBuiltinsFromModuleDependencies_u24lambda_u240 = jvmBuiltIns = new JvmBuiltIns(projectContext.getStorageManager(), JvmBuiltIns.Kind.FROM_DEPENDENCIES);
        boolean bl = false;
        $this$createBuiltinsFromModuleDependencies_u24lambda_u240.setPostponedBuiltinsModuleComputation(() -> JvmPlatformKindResolution.createBuiltinsFromModuleDependencies$lambda$0$0(resolverForProject, stdlibDependency));
        $this$createBuiltinsFromModuleDependencies_u24lambda_u240.setPostponedSettingsComputation(() -> JvmPlatformKindResolution.createBuiltinsFromModuleDependencies$lambda$0$1(resolverForProject, sdkDependency));
        return jvmBuiltIns;
    }

    private static final JvmBuiltIns.Settings createBuiltInsFromClassLoader$lambda$0$0(ResolverForProject $resolverForProject, SdkInfo $sdkDependency) {
        ModuleDescriptor sdkDescriptor = $resolverForProject.descriptorForModule((ModuleInfo)$sdkDependency);
        return new JvmBuiltIns.Settings(sdkDescriptor, true);
    }

    private static final ModuleDescriptorImpl createBuiltinsFromModuleDependencies$lambda$0$0(ResolverForProject $resolverForProject, LibraryInfo $stdlibDependency) {
        ModuleDescriptor stdlibDescriptor = $resolverForProject.descriptorForModule((ModuleInfo)$stdlibDependency);
        Intrinsics.checkNotNull((Object)stdlibDescriptor, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.impl.ModuleDescriptorImpl");
        return (ModuleDescriptorImpl)stdlibDescriptor;
    }

    private static final JvmBuiltIns.Settings createBuiltinsFromModuleDependencies$lambda$0$1(ResolverForProject $resolverForProject, SdkInfo $sdkDependency) {
        ModuleDescriptor sdkDescriptor = $resolverForProject.descriptorForModule((ModuleInfo)$sdkDependency);
        return new JvmBuiltIns.Settings(sdkDescriptor, true);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\r\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u001f\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/caches/resolve/JvmPlatformKindResolution$CacheKeyByBuiltInsDependencies;", "Lorg/jetbrains/kotlin/idea/caches/resolve/BuiltInsCacheKey;", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "stdlib", "Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/LibraryInfo;", "<init>", "(Lcom/intellij/openapi/projectRoots/Sdk;Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/LibraryInfo;)V", "getSdk", "()Lcom/intellij/openapi/projectRoots/Sdk;", "getStdlib", "()Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/LibraryInfo;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "kotlin.base.fe10.analysis"})
    public static final class CacheKeyByBuiltInsDependencies
    implements BuiltInsCacheKey {
        @NotNull
        private final Sdk sdk;
        @Nullable
        private final LibraryInfo stdlib;

        public CacheKeyByBuiltInsDependencies(@NotNull Sdk sdk2, @Nullable LibraryInfo stdlib) {
            Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
            this.sdk = sdk2;
            this.stdlib = stdlib;
        }

        @NotNull
        public final Sdk getSdk() {
            return this.sdk;
        }

        @Nullable
        public final LibraryInfo getStdlib() {
            return this.stdlib;
        }

        @NotNull
        public final Sdk component1() {
            return this.sdk;
        }

        @Nullable
        public final LibraryInfo component2() {
            return this.stdlib;
        }

        @NotNull
        public final CacheKeyByBuiltInsDependencies copy(@NotNull Sdk sdk2, @Nullable LibraryInfo stdlib) {
            Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
            return new CacheKeyByBuiltInsDependencies(sdk2, stdlib);
        }

        public static /* synthetic */ CacheKeyByBuiltInsDependencies copy$default(CacheKeyByBuiltInsDependencies cacheKeyByBuiltInsDependencies, Sdk sdk2, LibraryInfo libraryInfo, int n, Object object) {
            if ((n & 1) != 0) {
                sdk2 = cacheKeyByBuiltInsDependencies.sdk;
            }
            if ((n & 2) != 0) {
                libraryInfo = cacheKeyByBuiltInsDependencies.stdlib;
            }
            return cacheKeyByBuiltInsDependencies.copy(sdk2, libraryInfo);
        }

        @NotNull
        public String toString() {
            return "CacheKeyByBuiltInsDependencies(sdk=" + this.sdk + ", stdlib=" + this.stdlib + ")";
        }

        public int hashCode() {
            int result2 = this.sdk.hashCode();
            result2 = result2 * 31 + (this.stdlib == null ? 0 : this.stdlib.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CacheKeyByBuiltInsDependencies)) {
                return false;
            }
            CacheKeyByBuiltInsDependencies cacheKeyByBuiltInsDependencies = (CacheKeyByBuiltInsDependencies)other;
            if (!Intrinsics.areEqual((Object)this.sdk, (Object)cacheKeyByBuiltInsDependencies.sdk)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.stdlib, (Object)cacheKeyByBuiltInsDependencies.stdlib);
        }
    }
}

