/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration;

import com.intellij.idea.ActionsBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.changes.Change;
import java.awt.Desktop;
import java.net.URI;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinInProjectUtilsKt;
import org.jetbrains.kotlin.idea.configuration.KotlinProjectConfigurationService;
import org.jetbrains.kotlin.idea.configuration.KotlinProjectConfigurator;
import org.jetbrains.kotlin.idea.configuration.KotlinSetupEnvironmentNotificationProvider;
import org.jetbrains.kotlin.idea.configuration.ui.changes.KotlinConfiguratorChangesDialog;
import org.jetbrains.kotlin.idea.projectConfiguration.KotlinProjectConfigurationBundle;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u00002\u00020\u0001:\u0001&B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u000e\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000fJ\u0010\u0010\u0016\u001a\u00020\u000b2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018J\u0010\u0010\u0019\u001a\u00020\u000b2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018J\u0006\u0010\u001c\u001a\u00020\u000bJ\u0015\u0010\u001f\u001a\u00070\u0015\u00a2\u0006\u0002\b 2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u001b\u0010!\u001a\u00070\u0015\u00a2\u0006\u0002\b 2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J\u0010\u0010\"\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0015\u0010#\u001a\u00070\u0015\u00a2\u0006\u0002\b 2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\b\u0010$\u001a\u00020\u000bH\u0002J\b\u0010%\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0011\u001a\u00020\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001d\u001a\u00020\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0013\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/KotlinAutoConfigurationNotificationHolder;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "shownNotification", "Lcom/intellij/notification/Notification;", "notificationData", "Lorg/jetbrains/kotlin/idea/configuration/KotlinAutoConfigurationNotificationHolder$NotificationData;", "showAutoConfiguredNotification", "", "moduleName", "", "changes", "", "Lcom/intellij/openapi/vcs/changes/Change;", "buildSystemDocumentationUrl", "getBuildSystemDocumentationUrl", "()Ljava/lang/String;", "browseBuildSystemConfigurationDocumentation", "Lcom/intellij/notification/NotificationAction;", "showAutoConfigurationUndoneNotification", "module", "Lcom/intellij/openapi/module/Module;", "reshowAutoConfiguredNotification", "manualConfigurationStarted", "", "onManualConfigurationCompleted", "buildSystemName", "getBuildSystemName", "configureKotlinManuallyAction", "Lorg/jetbrains/annotations/NotNull;", "viewAppliedChangesAction", "showUndoErrorMessage", "undoAction", "expireShownNotification", "dispose", "NotificationData", "intellij.kotlin.projectConfiguration"})
public abstract class KotlinAutoConfigurationNotificationHolder
implements Disposable {
    @NotNull
    private final Project project;
    @Nullable
    private Notification shownNotification;
    @Nullable
    private NotificationData notificationData;
    @NotNull
    private final NotificationAction browseBuildSystemConfigurationDocumentation;
    private boolean manualConfigurationStarted;

    public KotlinAutoConfigurationNotificationHolder(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        NotificationAction notificationAction = NotificationAction.create((String)KotlinProjectConfigurationBundle.message("auto.configure.kotlin.documentation.open", new Object[0]), (arg_0, arg_1) -> KotlinAutoConfigurationNotificationHolder.browseBuildSystemConfigurationDocumentation$lambda$1((arg_0, arg_1) -> KotlinAutoConfigurationNotificationHolder.browseBuildSystemConfigurationDocumentation$lambda$0(this, arg_0, arg_1), arg_0, arg_1));
        Intrinsics.checkNotNullExpressionValue((Object)notificationAction, (String)"create(...)");
        this.browseBuildSystemConfigurationDocumentation = notificationAction;
    }

    public final void showAutoConfiguredNotification(@Nullable String moduleName, @Nullable List<? extends Change> changes) {
        String string;
        Notification notification = this.shownNotification;
        if (notification != null) {
            notification.expire();
        }
        this.notificationData = moduleName != null && changes != null ? new NotificationData(changes) : null;
        if (moduleName != null) {
            Object[] objectArray = new Object[]{moduleName};
            string = KotlinProjectConfigurationBundle.message("auto.configure.kotlin.notification", objectArray);
        } else {
            string = KotlinProjectConfigurationBundle.message("auto.configure.kotlin.notification.no-module", new Object[0]);
        }
        String notificationText = string;
        Notification notification2 = NotificationGroupManager.getInstance().getNotificationGroup("Configure Kotlin").createNotification(KotlinProjectConfigurationBundle.message("auto.configure.kotlin", new Object[0]), notificationText, NotificationType.INFORMATION);
        notification2.addAction((AnAction)this.undoAction(this.project));
        if (changes != null) {
            notification2.addAction((AnAction)this.viewAppliedChangesAction(changes));
        }
        notification2.notify(this.project);
        this.shownNotification = notification2;
    }

    @NotNull
    public abstract String getBuildSystemDocumentationUrl();

    public final void showAutoConfigurationUndoneNotification(@Nullable Module module) {
        NotificationData existingNotificationData = this.notificationData;
        Notification notification = this.shownNotification;
        if (notification != null) {
            notification.expire();
        }
        Notification notification2 = NotificationGroupManager.getInstance().getNotificationGroup("Configure Kotlin").createNotification(KotlinProjectConfigurationBundle.message("auto.configure.kotlin.undone", new Object[0]), "", NotificationType.INFORMATION);
        Module module2 = module;
        if (module2 != null) {
            Module it = module2;
            boolean bl = false;
            notification2.addAction((AnAction)this.configureKotlinManuallyAction(it));
        }
        notification2.addAction((AnAction)this.browseBuildSystemConfigurationDocumentation);
        notification2.notify(this.project);
        this.shownNotification = notification2;
        this.notificationData = existingNotificationData;
    }

    public final void reshowAutoConfiguredNotification(@Nullable Module module) {
        NotificationData existingNotificationData = this.notificationData;
        Notification notification = this.shownNotification;
        if (notification != null) {
            notification.expire();
        }
        Module module2 = module;
        NotificationData notificationData = existingNotificationData;
        this.showAutoConfiguredNotification(module2 != null ? module2.getName() : null, notificationData != null ? notificationData.getChanges() : null);
    }

    public final void onManualConfigurationCompleted() {
        this.manualConfigurationStarted = true;
    }

    @NotNull
    public abstract String getBuildSystemName();

    private final NotificationAction configureKotlinManuallyAction(Module module) {
        NotificationAction notificationAction = NotificationAction.create((String)KotlinProjectConfigurationBundle.message("configure.kotlin.manually", new Object[0]), (arg_0, arg_1) -> KotlinAutoConfigurationNotificationHolder.configureKotlinManuallyAction$lambda$1((arg_0, arg_1) -> KotlinAutoConfigurationNotificationHolder.configureKotlinManuallyAction$lambda$0(this, module, arg_0, arg_1), arg_0, arg_1));
        Intrinsics.checkNotNullExpressionValue((Object)notificationAction, (String)"create(...)");
        return notificationAction;
    }

    private final NotificationAction viewAppliedChangesAction(List<? extends Change> changes) {
        NotificationAction notificationAction = NotificationAction.create((String)KotlinProjectConfigurationBundle.message("view.code.differences.action", new Object[0]), (arg_0, arg_1) -> KotlinAutoConfigurationNotificationHolder.viewAppliedChangesAction$lambda$1((arg_0, arg_1) -> KotlinAutoConfigurationNotificationHolder.viewAppliedChangesAction$lambda$0(this, changes, arg_0, arg_1), arg_0, arg_1));
        Intrinsics.checkNotNullExpressionValue((Object)notificationAction, (String)"create(...)");
        return notificationAction;
    }

    private final void showUndoErrorMessage(Project project) {
        Messages.showErrorDialog((Project)project, (String)KotlinProjectConfigurationBundle.message("auto.configure.kotlin.undo.not-possible.content", new Object[0]), (String)KotlinProjectConfigurationBundle.message("auto.configure.kotlin.undo.not-possible.title", new Object[0]));
    }

    private final NotificationAction undoAction(Project project) {
        NotificationAction notificationAction = NotificationAction.create((String)KotlinProjectConfigurationBundle.message("undo.configuration.action", new Object[0]), (arg_0, arg_1) -> KotlinAutoConfigurationNotificationHolder.undoAction$lambda$1((arg_0, arg_1) -> KotlinAutoConfigurationNotificationHolder.undoAction$lambda$0(project, this, arg_0, arg_1), arg_0, arg_1));
        Intrinsics.checkNotNullExpressionValue((Object)notificationAction, (String)"create(...)");
        return notificationAction;
    }

    private final void expireShownNotification() {
        Notification notification = this.shownNotification;
        if (notification != null) {
            notification.expire();
        }
        this.shownNotification = null;
        this.notificationData = null;
    }

    public void dispose() {
        this.expireShownNotification();
    }

    private static final Unit browseBuildSystemConfigurationDocumentation$lambda$0(KotlinAutoConfigurationNotificationHolder this$0, AnActionEvent anActionEvent, Notification notification) {
        if (Desktop.isDesktopSupported()) {
            String url = this$0.getBuildSystemDocumentationUrl();
            Desktop.getDesktop().browse(new URI(url));
        }
        return Unit.INSTANCE;
    }

    private static final void browseBuildSystemConfigurationDocumentation$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final Unit configureKotlinManuallyAction$lambda$0(KotlinAutoConfigurationNotificationHolder this$0, Module $module, AnActionEvent e, Notification notification) {
        if (KotlinProjectConfigurationService.Companion.getInstance(this$0.project).isSyncInProgress()) {
            Object[] objectArray = new Object[]{this$0.getBuildSystemName()};
            String string = KotlinProjectConfigurationBundle.message("auto.configure.kotlin.wait.build.system.sync.finished", objectArray);
            objectArray = new Object[]{this$0.getBuildSystemName()};
            Messages.showWarningDialog((Project)this$0.project, (String)string, (String)KotlinProjectConfigurationBundle.message("auto.configure.kotlin.wait.build.system.sync.finished.title", objectArray));
            return Unit.INSTANCE;
        }
        List configurators = CollectionsKt.toList((Iterable)ConfigureKotlinInProjectUtilsKt.getAbleToRunConfigurators($module));
        this$0.manualConfigurationStarted = false;
        if (configurators.size() > 1) {
            KotlinSetupEnvironmentNotificationProvider.Companion.createConfiguratorsPopup(this$0.project, configurators, (Function1<? super KotlinProjectConfigurator, Unit>)((Function1)arg_0 -> KotlinAutoConfigurationNotificationHolder.configureKotlinManuallyAction$lambda$0$0(this$0, notification, arg_0))).showInBestPositionFor(e.getDataContext());
        } else if (configurators.size() == 1) {
            ((KotlinProjectConfigurator)CollectionsKt.first((List)configurators)).configure(this$0.project, CollectionsKt.emptyList());
        }
        KotlinAutoConfigurationNotificationHolder.configureKotlinManuallyAction$lambda$0$expireNotificationIfConfigured(this$0, notification);
        return Unit.INSTANCE;
    }

    private static final void configureKotlinManuallyAction$lambda$0$expireNotificationIfConfigured(KotlinAutoConfigurationNotificationHolder this$0, Notification $notification) {
        if (this$0.manualConfigurationStarted) {
            $notification.expire();
        }
    }

    private static final Unit configureKotlinManuallyAction$lambda$0$0(KotlinAutoConfigurationNotificationHolder this$0, Notification $notification, KotlinProjectConfigurator it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        KotlinAutoConfigurationNotificationHolder.configureKotlinManuallyAction$lambda$0$expireNotificationIfConfigured(this$0, $notification);
        return Unit.INSTANCE;
    }

    private static final void configureKotlinManuallyAction$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final Unit viewAppliedChangesAction$lambda$0(KotlinAutoConfigurationNotificationHolder this$0, List $changes, AnActionEvent anActionEvent, Notification notification) {
        new KotlinConfiguratorChangesDialog(this$0.project, $changes);
        return Unit.INSTANCE;
    }

    private static final void viewAppliedChangesAction$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final Unit undoAction$lambda$0(Project $project, KotlinAutoConfigurationNotificationHolder this$0, AnActionEvent anActionEvent, Notification notification) {
        UndoManager undoManager = UndoManager.getInstance((Project)$project);
        if (undoManager.isUndoAvailable(null)) {
            String undoActionName = (String)undoManager.getUndoActionNameAndDescription(null).first;
            Object[] objectArray = new Object[]{KotlinProjectConfigurationBundle.message("command.name.configure.kotlin.automatically", new Object[0])};
            String undoAutoconfigureKotlinName = ActionsBundle.message((String)"action.undo.text", (Object[])objectArray);
            if (Intrinsics.areEqual((Object)undoActionName, (Object)undoAutoconfigureKotlinName)) {
                undoManager.undo(null);
            } else {
                this$0.showUndoErrorMessage($project);
            }
        } else {
            this$0.showUndoErrorMessage($project);
        }
        return Unit.INSTANCE;
    }

    private static final void undoAction$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/KotlinAutoConfigurationNotificationHolder$NotificationData;", "", "changes", "", "Lcom/intellij/openapi/vcs/changes/Change;", "<init>", "(Ljava/util/List;)V", "getChanges", "()Ljava/util/List;", "intellij.kotlin.projectConfiguration"})
    private static final class NotificationData {
        @NotNull
        private final List<Change> changes;

        public NotificationData(@NotNull List<? extends Change> changes) {
            Intrinsics.checkNotNullParameter(changes, (String)"changes");
            this.changes = changes;
        }

        @NotNull
        public final List<Change> getChanges() {
            return this.changes;
        }
    }
}

