/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.core.breakpoints;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.impl.PositionUtil;
import com.intellij.debugger.ui.breakpoints.MethodBreakpoint;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiMethod;
import com.intellij.util.ApplicationKt;
import com.intellij.util.DocumentUtil;
import java.util.concurrent.Callable;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.session.KaSessionProvider;
import org.jetbrains.kotlin.analysis.api.symbols.KaCallableSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaConstructorSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaDeclarationSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaFunctionSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaNamedClassSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.markers.KaDeclarationContainerSymbol;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.idea.debugger.core.JvmNameUtilKt;
import org.jetbrains.kotlin.idea.debugger.core.KotlinDebuggerLegacyFacade;
import org.jetbrains.kotlin.idea.debugger.core.breakpoints.ActualDeclarationProvider;
import org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto.KotlinSmartStepTargetFiltererKt;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0014\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\"\u0010\u0005\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u001a\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0002H\u0002\u001a \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\"\u0010\u000e\u001a\u0004\u0018\u00010\u00012\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u001e\u0010\u000e\u001a\u0004\u0018\u00010\u0001*\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\nH\u0002\u001a\u000e\u0010\u0010\u001a\u0004\u0018\u00010\n*\u00020\nH\u0002\u00a8\u0006\u0011"}, d2={"getMethodDescriptor", "Lcom/intellij/debugger/ui/breakpoints/MethodBreakpoint$MethodDescriptor;", "Lcom/intellij/debugger/SourcePosition;", "project", "Lcom/intellij/openapi/project/Project;", "getMethodDescriptorInReadActionInSmartMode", "sourcePosition", "document", "Lcom/intellij/openapi/editor/Document;", "findDeclaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "isValidDeclaration", "", "declaration", "createMethodDescriptor", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "getActualJvmDeclaration", "intellij.kotlin.jvm.debugger.core"})
@SourceDebugExtension(value={"SMAP\nKotlinFunctionBreakpoint.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinFunctionBreakpoint.kt\norg/jetbrains/kotlin/idea/debugger/core/breakpoints/KotlinFunctionBreakpointKt\n+ 2 analyseUtils.kt\norg/jetbrains/kotlin/idea/debugger/base/util/AnalyseUtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 5 analyze.kt\norg/jetbrains/kotlin/analysis/api/AnalyzeKt\n+ 6 KaSessionProvider.kt\norg/jetbrains/kotlin/analysis/api/session/KaSessionProvider\n+ 7 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,136:1\n65#2,8:137\n46#2,7:145\n53#2,2:153\n1#3:152\n23#4,2:155\n30#5,2:157\n36#6,15:159\n183#7,2:174\n*S KotlinDebug\n*F\n+ 1 KotlinFunctionBreakpoint.kt\norg/jetbrains/kotlin/idea/debugger/core/breakpoints/KotlinFunctionBreakpointKt\n*L\n80#1:137,8\n80#1:145,7\n80#1:153,2\n95#1:155,2\n116#1:157,2\n116#1:159,15\n124#1:174,2\n*E\n"})
public final class KotlinFunctionBreakpointKt {
    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final MethodBreakpoint.MethodDescriptor getMethodDescriptor(@NotNull SourcePosition $this$getMethodDescriptor, @NotNull Project project) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$getMethodDescriptor, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Project project2 = project;
        MethodBreakpoint.MethodDescriptor default$iv = null;
        boolean $i$f$runSmartReadActionIfUnderProgressElseDumb = false;
        boolean isCancellableSection$iv = DebuggerManagerThreadImpl.Companion.hasNonDefaultProgressIndicator();
        if (isCancellableSection$iv && !ApplicationKt.getApplication().isReadAccessAllowed()) {
            object = ReadAction.nonBlocking((Callable)new Callable(project, $this$getMethodDescriptor){
                final /* synthetic */ Project $project$inlined;
                final /* synthetic */ SourcePosition $this_getMethodDescriptor$inlined;
                {
                    this.$project$inlined = project;
                    this.$this_getMethodDescriptor$inlined = sourcePosition;
                }

                public final MethodBreakpoint.MethodDescriptor call() {
                    Object object;
                    boolean bl = false;
                    Document document = PsiDocumentManager.getInstance((Project)this.$project$inlined).getDocument(this.$this_getMethodDescriptor$inlined.getFile());
                    if (document == null) {
                        object = null;
                    } else {
                        MethodBreakpoint.MethodDescriptor descriptor2;
                        Document document2 = document;
                        MethodBreakpoint.MethodDescriptor methodDescriptor = descriptor2 = KotlinFunctionBreakpointKt.access$getMethodDescriptorInReadActionInSmartMode(this.$project$inlined, this.$this_getMethodDescriptor$inlined, document2);
                        if (methodDescriptor != null) {
                            MethodBreakpoint.MethodDescriptor methodDescriptor2;
                            MethodBreakpoint.MethodDescriptor it = methodDescriptor2 = methodDescriptor;
                            boolean bl2 = false;
                            object = it.methodName != null && it.methodSignature != null ? methodDescriptor2 : null;
                        } else {
                            object = null;
                        }
                    }
                    return object;
                }
            }).inSmartMode((Project)project$iv).executeSynchronously();
        } else {
            void project$iv$iv;
            void var6_6 = project$iv;
            MethodBreakpoint.MethodDescriptor fallback$iv$iv = default$iv;
            boolean $i$f$runDumbAction = false;
            MethodBreakpoint.MethodDescriptor fallback$iv$iv$iv = fallback$iv$iv;
            boolean $i$f$internalDumbAction = false;
            boolean bl = false;
            if (((Boolean)ActionsKt.runReadAction((Function0)((Function0)new Function0<Boolean>((Project)project$iv$iv){
                final /* synthetic */ Project $project;
                {
                    this.$project = $project;
                }

                public final Boolean invoke() {
                    return DumbService.Companion.isDumb(this.$project);
                }
            }))).booleanValue()) {
                object = fallback$iv$iv$iv;
            } else {
                MethodBreakpoint.MethodDescriptor methodDescriptor;
                try {
                    Object object2;
                    boolean bl2 = false;
                    Document document = PsiDocumentManager.getInstance((Project)project).getDocument($this$getMethodDescriptor.getFile());
                    if (document == null) {
                        object2 = null;
                    } else {
                        MethodBreakpoint.MethodDescriptor descriptor2;
                        Document document2 = document;
                        MethodBreakpoint.MethodDescriptor methodDescriptor2 = descriptor2 = KotlinFunctionBreakpointKt.getMethodDescriptorInReadActionInSmartMode(project, $this$getMethodDescriptor, document2);
                        if (methodDescriptor2 != null) {
                            MethodBreakpoint.MethodDescriptor methodDescriptor3;
                            MethodBreakpoint.MethodDescriptor it = methodDescriptor3 = methodDescriptor2;
                            boolean bl3 = false;
                            object2 = it.methodName != null && it.methodSignature != null ? methodDescriptor3 : null;
                        } else {
                            object2 = null;
                        }
                    }
                    methodDescriptor = object2;
                }
                catch (IndexNotReadyException indexNotReadyException) {
                    methodDescriptor = fallback$iv$iv$iv;
                }
                object = methodDescriptor;
            }
        }
        return (MethodBreakpoint.MethodDescriptor)object;
    }

    private static final MethodBreakpoint.MethodDescriptor getMethodDescriptorInReadActionInSmartMode(Project project, SourcePosition sourcePosition, Document document) {
        Object v1;
        block4: {
            KtDeclaration ktDeclaration = KotlinFunctionBreakpointKt.findDeclaration(project, sourcePosition);
            if (ktDeclaration == null) {
                return null;
            }
            KtDeclaration declaration = ktDeclaration;
            MethodBreakpoint.MethodDescriptor methodDescriptor = KotlinFunctionBreakpointKt.createMethodDescriptor(declaration, sourcePosition, document);
            if (methodDescriptor != null) {
                MethodBreakpoint.MethodDescriptor it = methodDescriptor;
                boolean bl = false;
                return it;
            }
            Iterable $this$firstIsInstanceOrNull$iv = LightClassUtilsKt.toLightElements((KtElement)((KtElement)declaration));
            boolean $i$f$firstIsInstanceOrNull = false;
            for (Object element$iv : $this$firstIsInstanceOrNull$iv) {
                if (!(element$iv instanceof PsiMethod)) continue;
                v1 = element$iv;
                break block4;
            }
            v1 = null;
        }
        PsiMethod psiMethod = v1;
        if (psiMethod == null) {
            return null;
        }
        PsiMethod psiMethod2 = psiMethod;
        return MethodBreakpoint.getMethodDescriptor((SourcePosition)sourcePosition, (PsiMethod)psiMethod2, (Document)document);
    }

    private static final KtDeclaration findDeclaration(Project project, SourcePosition sourcePosition) {
        KtDeclaration ktDeclaration = (KtDeclaration)PositionUtil.getPsiElementAt((Project)project, KtDeclaration.class, (SourcePosition)sourcePosition);
        if (ktDeclaration == null) {
            return null;
        }
        KtDeclaration declaration = ktDeclaration;
        if (KtPsiUtilKt.isExpectDeclaration((KtDeclaration)declaration)) {
            KtDeclaration ktDeclaration2 = KotlinFunctionBreakpointKt.getActualJvmDeclaration(declaration);
            if (ktDeclaration2 == null) {
                return null;
            }
            declaration = ktDeclaration2;
        }
        return declaration;
    }

    private static final boolean isValidDeclaration(KtDeclaration declaration, SourcePosition sourcePosition, Document document) {
        int offset = declaration.getTextOffset();
        return DocumentUtil.isValidOffset((int)offset, (Document)document) && document.getLineNumber(offset) >= sourcePosition.getLine();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final MethodBreakpoint.MethodDescriptor createMethodDescriptor(KtDeclaration declaration, SourcePosition sourcePosition, Document document) {
        MethodBreakpoint.MethodDescriptor methodDescriptor;
        void this_$iv$iv;
        if (!KotlinFunctionBreakpointKt.isValidDeclaration(declaration, sourcePosition, document)) {
            return null;
        }
        KtElement useSiteElement$iv = (KtElement)declaration;
        boolean $i$f$analyze = false;
        Project project = useSiteElement$iv.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KaSessionProvider kaSessionProvider = KaSessionProvider.Companion.getInstance(project);
        KtElement useSiteElement$iv$iv = useSiteElement$iv;
        boolean $i$f$analyze2 = false;
        KaSession analysisSession$iv$iv = this_$iv$iv.getAnalysisSession(useSiteElement$iv$iv);
        this_$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv, useSiteElement$iv$iv);
        try {
            MethodBreakpoint.MethodDescriptor methodDescriptor2;
            Object lock$iv$iv;
            Object object = lock$iv$iv = new Object();
            synchronized (object) {
                boolean bl = false;
                KaSession $this$createMethodDescriptor_u24lambda_u240 = analysisSession$iv$iv;
                boolean bl2 = false;
                methodDescriptor2 = KotlinFunctionBreakpointKt.createMethodDescriptor($this$createMethodDescriptor_u24lambda_u240, document, declaration);
            }
            methodDescriptor = methodDescriptor2;
        }
        catch (Throwable throwable$iv$iv) {
            this_$iv$iv.handleAnalysisException(throwable$iv$iv, analysisSession$iv$iv, useSiteElement$iv$iv);
            throw new KotlinNothingValueException();
        }
        finally {
            this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, useSiteElement$iv$iv);
        }
        return methodDescriptor;
    }

    private static final MethodBreakpoint.MethodDescriptor createMethodDescriptor(KaSession $this$createMethodDescriptor, Document document, KtDeclaration declaration) {
        KaDeclarationSymbol symbol = $this$createMethodDescriptor.getSymbol(declaration);
        int lineNumber = document.getLineNumber(declaration.getTextOffset());
        if (symbol instanceof KaNamedClassSymbol) {
            Object v0;
            block6: {
                Sequence<KaConstructorSymbol> $this$firstOrNull$iv = $this$createMethodDescriptor.getDeclaredMemberScope((KaDeclarationContainerSymbol)((Object)symbol)).getConstructors();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    KaConstructorSymbol it = (KaConstructorSymbol)element$iv;
                    boolean bl = false;
                    if (!it.isPrimary()) continue;
                    v0 = element$iv;
                    break block6;
                }
                v0 = null;
            }
            KaConstructorSymbol kaConstructorSymbol = v0;
            if (kaConstructorSymbol == null) {
                return null;
            }
            symbol = kaConstructorSymbol;
        }
        if (!(symbol instanceof KaFunctionSymbol)) {
            return null;
        }
        String string = KotlinSmartStepTargetFiltererKt.getJvmSignature($this$createMethodDescriptor, (KaCallableSymbol)symbol, symbol instanceof KaConstructorSymbol);
        if (string == null) {
            return null;
        }
        String jvmSignature = string;
        String string2 = JvmNameUtilKt.methodName($this$createMethodDescriptor, (KaFunctionSymbol)symbol);
        if (string2 == null) {
            return null;
        }
        String methodName = string2;
        return new MethodBreakpoint.MethodDescriptor(methodName, jvmSignature, false, lineNumber);
    }

    private static final KtDeclaration getActualJvmDeclaration(KtDeclaration $this$getActualJvmDeclaration) {
        ActualDeclarationProvider actualDeclarationProvider;
        KotlinDebuggerLegacyFacade kotlinDebuggerLegacyFacade = KotlinDebuggerLegacyFacade.Companion.getInstance();
        return kotlinDebuggerLegacyFacade != null && (actualDeclarationProvider = kotlinDebuggerLegacyFacade.getActualDeclarationProvider()) != null ? actualDeclarationProvider.getActualJvmDeclaration($this$getActualJvmDeclaration) : null;
    }

    public static final /* synthetic */ KtDeclaration access$getActualJvmDeclaration(KtDeclaration $receiver) {
        return KotlinFunctionBreakpointKt.getActualJvmDeclaration($receiver);
    }
}

