/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.coroutine.proxy.mirror;

import com.intellij.openapi.diagnostic.Logger;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Type;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.base.util.evaluate.DefaultExecutionContext;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.mirror.MirrorProvider;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.mirror.ReferenceTypeProvider;
import org.jetbrains.kotlin.idea.debugger.coroutine.util.CoroutineUtilsKt;
import org.jetbrains.kotlin.idea.debugger.coroutine.util.ProvidersKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\u0004\b\u0001\u0010\u00032\u00020\u00042\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u0005B\u0017\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u0016\u001a\u00020\u0015H\u0016J\u0017\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010\u001aJ!\u0010\u001b\u001a\u0004\u0018\u00018\u00012\b\u0010\u0019\u001a\u0004\u0018\u00018\u00002\u0006\u0010\b\u001a\u00020\tH\u0016\u00a2\u0006\u0002\u0010\u001cJ\u001f\u0010\u001d\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0019\u001a\u00028\u00002\u0006\u0010\b\u001a\u00020\tH$\u00a2\u0006\u0002\u0010\u001cR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001b\u0010\u000e\u001a\u00020\u000f8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/mirror/BaseMirror;", "T", "Lcom/sun/jdi/ObjectReference;", "F", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/mirror/ReferenceTypeProvider;", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/mirror/MirrorProvider;", "name", "", "context", "Lorg/jetbrains/kotlin/idea/debugger/base/util/evaluate/DefaultExecutionContext;", "<init>", "(Ljava/lang/String;Lorg/jetbrains/kotlin/idea/debugger/base/util/evaluate/DefaultExecutionContext;)V", "getName", "()Ljava/lang/String;", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "getLog", "()Lcom/intellij/openapi/diagnostic/Logger;", "log$delegate", "Lkotlin/properties/ReadOnlyProperty;", "cls", "Lcom/sun/jdi/ReferenceType;", "getCls", "isCompatible", "", "value", "(Lcom/sun/jdi/ObjectReference;)Z", "mirror", "(Lcom/sun/jdi/ObjectReference;Lorg/jetbrains/kotlin/idea/debugger/base/util/evaluate/DefaultExecutionContext;)Ljava/lang/Object;", "fetchMirror", "intellij.kotlin.jvm.debugger.coroutines"})
public abstract class BaseMirror<T extends ObjectReference, F>
implements ReferenceTypeProvider,
MirrorProvider<T, F> {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final String name;
    @NotNull
    private final ReadOnlyProperty log$delegate;
    @NotNull
    private final ReferenceType cls;

    public BaseMirror(@NotNull String name2, @NotNull DefaultExecutionContext context2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.name = name2;
        this.log$delegate = ProvidersKt.getLogger();
        ReferenceType referenceType = context2.findReferenceTypeSafe(this.name);
        if (referenceType == null) {
            throw new IllegalStateException("coroutine-debugger: class " + this.name + " not found.");
        }
        this.cls = referenceType;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final Logger getLog() {
        return (Logger)this.log$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    @Override
    @NotNull
    public ReferenceType getCls() {
        return this.cls;
    }

    @Override
    public boolean isCompatible(@Nullable T value) {
        T t = value;
        return t != null && (t = t.referenceType()) != null ? CoroutineUtilsKt.isSubTypeOrSame((Type)t, this.name) : false;
    }

    @Override
    @Nullable
    public F mirror(@Nullable T value, @NotNull DefaultExecutionContext context2) {
        F f;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (value == null) {
            return null;
        }
        if (!this.isCompatible(value)) {
            this.getLog().trace("Value " + value.referenceType() + " is not compatible with " + this.name + ".");
            f = null;
        } else {
            f = this.fetchMirror(value, context2);
        }
        return f;
    }

    @Nullable
    protected abstract F fetchMirror(@NotNull T var1, @NotNull DefaultExecutionContext var2);

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(BaseMirror.class, "log", "getLog()Lcom/intellij/openapi/diagnostic/Logger;", 0)))};
        $$delegatedProperties = kPropertyArray;
    }
}

