/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.evaluate;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassNotPreparedException;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InconsistentDebugInfoException;
import com.sun.jdi.InternalException;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.VMDisconnectedException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinEvaluator;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.CodeFragmentParameter;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.CompilationResult;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.CompiledCodeFragmentData;
import org.jetbrains.kotlin.idea.util.application.KotlinExceptionUtils;
import org.jetbrains.kotlin.psi.KtCodeFragment;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000J\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0002\b\u0003\u001a\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a.\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\bH\u0002\u001a\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0006\u001a\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0010\u001a\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\b\"\u0019\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u001b"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "isSpecialException", "", "th", "", "reportError", "", "codeFragment", "Lorg/jetbrains/kotlin/psi/KtCodeFragment;", "position", "Lcom/intellij/debugger/SourcePosition;", "message", "", "throwable", "createCompiledDataDescriptor", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CompiledCodeFragmentData;", "result", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CompilationResult;", "canBeCached", "evaluationException", "", "msg", "e", "kotlin.jvm-debugger.evaluation"})
@SourceDebugExtension(value={"SMAP\nKotlinEvaluatorBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinEvaluatorBuilder.kt\norg/jetbrains/kotlin/idea/debugger/evaluate/KotlinEvaluatorBuilderKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,613:1\n1#2:614\n*E\n"})
public final class KotlinEvaluatorBuilderKt {
    @NotNull
    private static final Logger LOG;

    @NotNull
    public static final Logger getLOG() {
        return LOG;
    }

    private static final boolean isSpecialException(Throwable th) {
        Throwable throwable = th;
        return throwable instanceof ClassNotPreparedException || throwable instanceof InternalException || throwable instanceof AbsentInformationException || throwable instanceof ClassNotLoadedException || throwable instanceof IncompatibleThreadStateException || throwable instanceof InconsistentDebugInfoException || throwable instanceof ObjectCollectedException || throwable instanceof VMDisconnectedException;
    }

    private static final void reportError(KtCodeFragment codeFragment, SourcePosition position, String message2, Throwable throwable) {
        ActionsKt.runReadAction(() -> KotlinEvaluatorBuilderKt.reportError$lambda$0(codeFragment, position, message2, throwable));
    }

    static /* synthetic */ void reportError$default(KtCodeFragment ktCodeFragment, SourcePosition sourcePosition, String string, Throwable throwable, int n, Object object) {
        if ((n & 8) != 0) {
            throwable = null;
        }
        KotlinEvaluatorBuilderKt.reportError(ktCodeFragment, sourcePosition, string, throwable);
    }

    @NotNull
    public static final CompiledCodeFragmentData createCompiledDataDescriptor(@NotNull CompilationResult result2, boolean canBeCached) {
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        Map<CodeFragmentParameter.Dumb, String> localFunctionSuffixes = result2.getLocalFunctionSuffixes();
        ArrayList dumbParameters = new ArrayList(result2.getParameterInfo().getParameters().size());
        for (CodeFragmentParameter.Dumb dumb : result2.getParameterInfo().getParameters()) {
            String suffix2;
            if (dumb.getKind() == CodeFragmentParameter.Kind.LOCAL_FUNCTION && (suffix2 = localFunctionSuffixes.get(dumb)) != null) {
                ((Collection)dumbParameters).add(CodeFragmentParameter.Dumb.copy$default(dumb, null, dumb.getName() + suffix2, 0, null, 13, null));
                continue;
            }
            ((Collection)dumbParameters).add(dumb);
        }
        return new CompiledCodeFragmentData(result2.getClasses(), dumbParameters, result2.getParameterInfo().getCrossingBounds(), result2.getMainMethodSignature(), result2.getCompilerType(), false, canBeCached);
    }

    @NotNull
    public static final Void evaluationException(@NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        EvaluateException evaluateException = EvaluateExceptionUtil.createEvaluateException((String)msg);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)evaluateException), (String)"createEvaluateException(...)");
        throw (Throwable)evaluateException;
    }

    @NotNull
    public static final Void evaluationException(@NotNull Throwable e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        EvaluateException evaluateException = EvaluateExceptionUtil.createEvaluateException((Throwable)e);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)evaluateException), (String)"createEvaluateException(...)");
        throw (Throwable)evaluateException;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit reportError$lambda$0(KtCodeFragment $codeFragment, SourcePosition $position, String $message, Throwable $throwable) {
        Object object;
        String string;
        Object object2;
        Attachment[] attachmentArray;
        PsiElement psiElement = $codeFragment.getContext();
        PsiFile contextFile = psiElement != null ? psiElement.getContainingFile() : null;
        Object[] objectArray = new Attachment[4];
        objectArray[0] = KotlinExceptionUtils.attachmentByPsiFile(contextFile);
        objectArray[1] = KotlinExceptionUtils.attachmentByPsiFile((PsiFile)$codeFragment);
        Object[] objectArray2 = objectArray;
        int n = 2;
        String string2 = "breakpoint.info";
        if ($position != null) {
            void $this$reportError_u24lambda_u240_u240;
            attachmentArray = $position;
            String string3 = string2;
            int n2 = n;
            object2 = objectArray2;
            boolean bl = false;
            String string4 = $this$reportError_u24lambda_u240_u240.getFile().getName() + ":" + $this$reportError_u24lambda_u240_u240.getLine();
            objectArray2 = object2;
            n = n2;
            string2 = string3;
            string = string4;
        } else {
            string = null;
        }
        String string5 = "Position: " + string;
        String string6 = string2;
        objectArray2[n] = new Attachment(string6, string5);
        objectArray[3] = new Attachment("context.info", (String)ActionsKt.runReadAction(() -> KotlinEvaluatorBuilderKt.reportError$lambda$0$1($codeFragment)));
        List attachments = CollectionsKt.listOfNotNull((Object[])objectArray);
        Attachment[] attachmentArray2 = $message;
        if (((CharSequence)attachmentArray2).length() > 0) {
            void it;
            char $this$reportError_u24lambda_u240_u240 = attachmentArray2.charAt(0);
            object2 = new StringBuilder();
            boolean bl = false;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            StringBuilder stringBuilder = ((StringBuilder)object2).append((Object)CharsKt.lowercase((char)it, (Locale)locale));
            attachmentArray = attachmentArray2;
            int n3 = 1;
            String string7 = attachmentArray.substring(n3);
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"substring(...)");
            object = stringBuilder.append(string7).toString();
        } else {
            object = attachmentArray2;
        }
        Attachment[] decapitalizedMessage = object;
        attachmentArray2 = new Attachment[]{KotlinExceptionUtils.merge(attachments)};
        LOG.error("Cannot evaluate a code fragment of type " + $codeFragment.getClass() + ": " + (String)decapitalizedMessage, $throwable, attachmentArray2);
        return Unit.INSTANCE;
    }

    private static final String reportError$lambda$0$1(KtCodeFragment $codeFragment) {
        Object object = $codeFragment.getContext();
        if (object == null || (object = object.getText()) == null) {
            object = "null";
        }
        return object;
    }

    public static final /* synthetic */ boolean access$isSpecialException(Throwable th) {
        return KotlinEvaluatorBuilderKt.isSpecialException(th);
    }

    public static final /* synthetic */ void access$reportError(KtCodeFragment codeFragment, SourcePosition position, String message2, Throwable throwable) {
        KotlinEvaluatorBuilderKt.reportError(codeFragment, position, message2, throwable);
    }

    static {
        Logger logger = Logger.getInstance(KotlinEvaluator.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

