/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter.markers;

import com.intellij.ide.util.PsiClassListCellRenderer;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.PsiElementProcessorAdapter;
import com.intellij.util.AdapterProcessor;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import java.util.Collection;
import java.util.Comparator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.highlighter.markers.KotlinGutterTooltipHelper;
import org.jetbrains.kotlin.idea.search.declarationsSearch.OverridersSearchKt;
import org.jetbrains.kotlin.idea.search.declarationsSearch.OverridersSearchUtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtDeclarationWithInitializer;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\u0010\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0003\u00a8\u0006\u0007"}, d2={"getOverriddenPropertyTooltip", "", "property", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "isImplemented", "", "declaration", "kotlin.idea"})
public final class OverridenPropertyMarkerKt {
    @Nullable
    public static final String getOverriddenPropertyTooltip(@NotNull KtNamedDeclaration property) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        PsiElementProcessor.CollectElementsWithLimit overriddenInClassesProcessor = new PsiElementProcessor.CollectElementsWithLimit(5);
        AdapterProcessor consumer = new AdapterProcessor((Processor)new CommonProcessors.UniqueProcessor((Processor)new PsiElementProcessorAdapter((PsiElementProcessor)overriddenInClassesProcessor)), OverridenPropertyMarkerKt::getOverriddenPropertyTooltip$lambda$0);
        for (PsiMethod method : OverridersSearchKt.toPossiblyFakeLightMethods((PsiElement)property)) {
            if (overriddenInClassesProcessor.isOverflow()) continue;
            OverridersSearchUtilsKt.forEachOverridingMethod$default(method, null, (Function1)new Function1<PsiMethod, Boolean>((Object)consumer){

                public final Boolean invoke(PsiMethod p0) {
                    return ((AdapterProcessor)this.receiver).process((Object)p0);
                }
            }, 1, null);
        }
        boolean isImplemented = OverridenPropertyMarkerKt.isImplemented(property);
        if (overriddenInClassesProcessor.isOverflow()) {
            return isImplemented ? KotlinBundle.message((String)"overridden.marker.implementations.multiple", (Object[])new Object[0]) : KotlinBundle.message((String)"overridden.marker.overrides.multiple", (Object[])new Object[0]);
        }
        Collection collection = overriddenInClassesProcessor.getCollection();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getCollection(...)");
        Collection collectedClasses = collection;
        if (collectedClasses.isEmpty()) {
            return null;
        }
        String start2 = isImplemented ? KotlinBundle.message((String)"overridden.marker.implementation", (Object[])new Object[0]) : KotlinBundle.message((String)"overridden.marker.overrides", (Object[])new Object[0]);
        Iterable iterable = collectedClasses;
        Comparator comparator = new PsiClassListCellRenderer().getComparator();
        Intrinsics.checkNotNullExpressionValue((Object)comparator, (String)"getComparator(...)");
        return KotlinGutterTooltipHelper.INSTANCE.buildTooltipText(CollectionsKt.sortedWith((Iterable)iterable, (Comparator)comparator), start2, true, "GotoImplementation");
    }

    public static final boolean isImplemented(@NotNull KtNamedDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (declaration.hasModifier(KtTokens.ABSTRACT_KEYWORD)) {
            return true;
        }
        PsiElement parent = declaration.getParent();
        PsiElement psiElement = parent = parent instanceof KtClassBody ? ((KtClassBody)parent).getParent() : parent;
        if (!(parent instanceof KtClass)) {
            return false;
        }
        return !(!((KtClass)parent).isInterface() || declaration instanceof KtDeclarationWithBody && ((KtDeclarationWithBody)declaration).hasBody() || declaration instanceof KtDeclarationWithInitializer && ((KtDeclarationWithInitializer)declaration).hasInitializer());
    }

    private static final PsiClass getOverriddenPropertyTooltip$lambda$0(PsiMethod method) {
        PsiMethod psiMethod = method;
        return psiMethod != null ? psiMethod.getContainingClass() : null;
    }
}

