/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointersKt;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.utils.EditorUtilsKt;
import org.jetbrains.kotlin.idea.inspections.UnusedSymbolInspectionKt;
import org.jetbrains.kotlin.idea.quickfix.RemoveUnusedFunctionParameterFix;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\u0007H\u0016J\u0012\u0010\t\u001a\f0\u0007\u00a2\u0006\u0002\b\n\u00a2\u0006\u0002\b\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0010\u0010\u0006\u001a\u00020\u00078\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/SafeDeleteFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "<init>", "(Lorg/jetbrains/kotlin/psi/KtDeclaration;)V", "name", "", "getName", "getFamilyName", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "startInWriteAction", "", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nUnusedSymbolInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnusedSymbolInspection.kt\norg/jetbrains/kotlin/idea/inspections/SafeDeleteFix\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,748:1\n249#2:749\n1#3:750\n*S KotlinDebug\n*F\n+ 1 UnusedSymbolInspection.kt\norg/jetbrains/kotlin/idea/inspections/SafeDeleteFix\n*L\n732#1:749\n*E\n"})
public final class SafeDeleteFix
implements LocalQuickFix {
    @Nls
    @NotNull
    private final String name;

    public SafeDeleteFix(@NotNull KtDeclaration declaration) {
        String string;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (declaration instanceof KtConstructor) {
            string = KotlinBundle.message((String)"safe.delete.constructor", (Object[])new Object[0]);
        } else {
            Object[] objectArray = new Object[]{declaration.getName()};
            String string2 = QuickFixBundle.message((String)"safe.delete.text", (Object[])objectArray);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        }
        this.name = string;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message((String)"safe.delete.family", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public boolean startInWriteAction() {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        PsiElement psiElement = descriptor2.getPsiElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getPsiElement(...)");
        PsiElement $this$getStrictParentOfType$iv = psiElement;
        boolean $i$f$getStrictParentOfType = false;
        KtDeclaration ktDeclaration = (KtDeclaration)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtDeclaration.class, (boolean)true);
        if (ktDeclaration == null) {
            return;
        }
        KtDeclaration declaration = ktDeclaration;
        if (!FileModificationService.getInstance().prepareFileForWrite(declaration.getContainingFile())) {
            return;
        }
        if (declaration instanceof KtParameter && ((KtParameter)declaration).getParent() instanceof KtParameterList) {
            PsiElement psiElement2 = ((KtParameter)declaration).getParent();
            if ((psiElement2 != null ? psiElement2.getParent() : null) instanceof KtFunction) {
                RemoveUnusedFunctionParameterFix removeUnusedFunctionParameterFix = new RemoveUnusedFunctionParameterFix((KtParameter)declaration, false, 2, null);
                Editor editor = EditorUtilsKt.findExistingEditor((PsiElement)declaration);
                KtFile ktFile2 = ((KtParameter)declaration).getContainingKtFile();
                Intrinsics.checkNotNullExpressionValue((Object)ktFile2, (String)"getContainingKtFile(...)");
                removeUnusedFunctionParameterFix.invoke(project, editor, (PsiFile)ktFile2);
                return;
            }
        }
        SmartPsiElementPointer declarationPointer = SmartPointersKt.createSmartPointer((PsiElement)((PsiElement)declaration));
        ActionsKt.invokeLater$default(null, () -> SafeDeleteFix.applyFix$lambda$0(declarationPointer, project), (int)1, null);
    }

    private static final Unit applyFix$lambda$0(SmartPsiElementPointer $declarationPointer, Project $project) {
        block0: {
            KtDeclaration ktDeclaration = (KtDeclaration)$declarationPointer.getElement();
            if (ktDeclaration == null) break block0;
            KtDeclaration it = ktDeclaration;
            boolean bl = false;
            UnusedSymbolInspectionKt.access$safeDelete($project, (PsiElement)it);
        }
        return Unit.INSTANCE;
    }
}

