/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.introduce.extractClass;

import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.RefactoringBundle;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractClass.ExtractSuperInfo;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractClass.KotlinExtractSuperHandlerBase;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractClass.KotlinExtractSuperRefactoring;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractClass.ui.KotlinExtractSuperDialogBase;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractClass.ui.KotlinExtractSuperclassDialog;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0014R\u0011\u0010\u0004\u001a\u00020\u00058G\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/introduce/extractClass/KotlinExtractSuperclassHandler;", "Lorg/jetbrains/kotlin/idea/refactoring/introduce/extractClass/KotlinExtractSuperHandlerBase;", "<init>", "()V", "REFACTORING_NAME", "", "getREFACTORING_NAME", "()Ljava/lang/String;", "getErrorMessage", "klass", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "createDialog", "Lorg/jetbrains/kotlin/idea/refactoring/introduce/extractClass/ui/KotlinExtractSuperclassDialog;", "targetParent", "Lcom/intellij/psi/PsiElement;", "kotlin.refactorings.common"})
@ApiStatus.Internal
public final class KotlinExtractSuperclassHandler
extends KotlinExtractSuperHandlerBase {
    @NotNull
    public static final KotlinExtractSuperclassHandler INSTANCE = new KotlinExtractSuperclassHandler();

    private KotlinExtractSuperclassHandler() {
        super(false);
    }

    @Nls
    @NotNull
    public final String getREFACTORING_NAME() {
        return KotlinBundle.message((String)"text.extract.superclass", (Object[])new Object[0]);
    }

    @Override
    @Nullable
    public String getErrorMessage(@NotNull KtClassOrObject klass) {
        String superMessage;
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        String string = superMessage = super.getErrorMessage(klass);
        if (string != null) {
            return string;
        }
        if (klass instanceof KtClass) {
            if (((KtClass)klass).isInterface()) {
                return RefactoringBundle.message((String)"superclass.cannot.be.extracted.from.an.interface");
            }
            if (((KtClass)klass).isEnum()) {
                return JavaRefactoringBundle.message((String)"superclass.cannot.be.extracted.from.an.enum", (Object[])new Object[0]);
            }
            if (klass.isAnnotation()) {
                return KotlinBundle.message((String)"error.text.superclass.cannot.be.extracted.from.an.annotation.class", (Object[])new Object[0]);
            }
        }
        return null;
    }

    @Override
    @NotNull
    protected KotlinExtractSuperclassDialog createDialog(@NotNull KtClassOrObject klass, @NotNull PsiElement targetParent) {
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        Intrinsics.checkNotNullParameter((Object)targetParent, (String)"targetParent");
        return new KotlinExtractSuperclassDialog(klass, targetParent, (Function1<? super KotlinExtractSuperDialogBase, Boolean>)((Function1)arg_0 -> KotlinExtractSuperclassHandler.createDialog$lambda$0(klass, arg_0)), (Function1<? super ExtractSuperInfo, Unit>)((Function1)KotlinExtractSuperclassHandler::createDialog$lambda$1));
    }

    private static final boolean createDialog$lambda$0(KtClassOrObject $klass, KotlinExtractSuperDialogBase it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        return INSTANCE.checkConflicts($klass, it);
    }

    private static final Unit createDialog$lambda$1(ExtractSuperInfo it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        KotlinExtractSuperRefactoring.Companion.getInstance().performRefactoring(it);
        return Unit.INSTANCE;
    }
}

