/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.xml;

import com.intellij.codeInsight.unwrap.Unwrapper;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.DocumentUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.XmlBundle;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class XmlEnclosingTagUnwrapper
implements Unwrapper {
    public boolean isApplicableTo(@NotNull PsiElement e) {
        if (e == null) {
            XmlEnclosingTagUnwrapper.$$$reportNull$$$0(0);
        }
        return true;
    }

    public void collectElementsToIgnore(@NotNull PsiElement element, @NotNull Set<PsiElement> result) {
        if (element == null) {
            XmlEnclosingTagUnwrapper.$$$reportNull$$$0(1);
        }
        if (result == null) {
            XmlEnclosingTagUnwrapper.$$$reportNull$$$0(2);
        }
    }

    @NotNull
    public String getDescription(@NotNull PsiElement e) {
        if (e == null) {
            XmlEnclosingTagUnwrapper.$$$reportNull$$$0(3);
        }
        String string = XmlBundle.message("xml.action.unwrap.enclosing.tag.name.description", ((XmlTag)e).getName());
        if (string == null) {
            XmlEnclosingTagUnwrapper.$$$reportNull$$$0(4);
        }
        return string;
    }

    public PsiElement collectAffectedElements(@NotNull PsiElement element, @NotNull List<? super PsiElement> toExtract) {
        if (element == null) {
            XmlEnclosingTagUnwrapper.$$$reportNull$$$0(5);
        }
        if (toExtract == null) {
            XmlEnclosingTagUnwrapper.$$$reportNull$$$0(6);
        }
        TextRange range = element.getTextRange();
        ASTNode startTagNameEnd = XmlChildRole.START_TAG_END_FINDER.findChild(element.getNode());
        ASTNode endTagNameStart = XmlChildRole.CLOSING_TAG_START_FINDER.findChild(element.getNode());
        int start = startTagNameEnd != null ? startTagNameEnd.getTextRange().getEndOffset() : range.getStartOffset();
        int end = endTagNameStart != null ? endTagNameStart.getTextRange().getStartOffset() : range.getEndOffset();
        for (PsiElement child : element.getChildren()) {
            TextRange childRange = child.getTextRange();
            if (childRange.getStartOffset() < start || childRange.getEndOffset() > end) continue;
            toExtract.add((PsiElement)child);
        }
        return element;
    }

    @NotNull
    public List<PsiElement> unwrap(@NotNull Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (editor == null) {
            XmlEnclosingTagUnwrapper.$$$reportNull$$$0(7);
        }
        if (element == null) {
            XmlEnclosingTagUnwrapper.$$$reportNull$$$0(8);
        }
        TextRange range = element.getTextRange();
        ASTNode startTagNameEnd = XmlChildRole.START_TAG_END_FINDER.findChild(element.getNode());
        ASTNode endTagNameStart = XmlChildRole.CLOSING_TAG_START_FINDER.findChild(element.getNode());
        Project project = element.getProject();
        PsiFile file = element.getContainingFile();
        Document document = editor.getDocument();
        RangeMarker marker = document.createRangeMarker(range);
        if (endTagNameStart != null) {
            document.deleteString(endTagNameStart.getTextRange().getStartOffset(), range.getEndOffset());
            document.deleteString(range.getStartOffset(), startTagNameEnd.getTextRange().getEndOffset());
        } else {
            document.replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)"");
        }
        this.deleteEmptyLine(document, marker.getStartOffset());
        this.deleteEmptyLine(document, marker.getEndOffset());
        PsiDocumentManager.getInstance((Project)project).commitDocument(document);
        CodeStyleManager.getInstance((Project)project).adjustLineIndent(file, marker.getTextRange());
        List<PsiElement> list = Collections.emptyList();
        if (list == null) {
            XmlEnclosingTagUnwrapper.$$$reportNull$$$0(9);
        }
        return list;
    }

    protected void deleteEmptyLine(Document document, int offset) {
        int line;
        int n = line = offset < document.getTextLength() ? document.getLineNumber(offset) : -1;
        if (line > 0 && DocumentUtil.isLineEmpty((Document)document, (int)line)) {
            int start = document.getLineStartOffset(line);
            int end = Math.min(document.getLineEndOffset(line) + 1, document.getTextLength() - 1);
            if (end == document.getTextLength() - 1) {
                document.deleteString(start - 1, end);
            } else if (start < end) {
                document.deleteString(start, end);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/xml/XmlEnclosingTagUnwrapper";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toExtract";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/xml/XmlEnclosingTagUnwrapper";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "unwrap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isApplicableTo";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "collectElementsToIgnore";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getDescription";
                break;
            }
            case 4: 
            case 9: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "collectAffectedElements";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "unwrap";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 9 -> new IllegalStateException(string);
        };
    }
}

