/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.metrics.stats;

import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.internals.MetricsUtils;
import org.apache.kafka.common.metrics.stats.SampledStat;
import org.apache.kafka.common.metrics.stats.WindowedSum;

public class Rate
implements MeasurableStat {
    protected final TimeUnit unit;
    protected final SampledStat stat;
    protected final long timeWindowMs;

    public Rate() {
        this(TimeUnit.SECONDS);
    }

    public Rate(TimeUnit unit) {
        this(unit, new WindowedSum());
    }

    public Rate(SampledStat stat) {
        this(TimeUnit.SECONDS, stat);
    }

    public Rate(TimeUnit unit, SampledStat stat) {
        this(unit, stat, -1L);
    }

    public Rate(TimeUnit unit, SampledStat stat, long window) {
        this.unit = unit;
        this.stat = stat;
        if (window > 0L) {
            this.timeWindowMs = TimeUnit.MILLISECONDS.convert(window, unit);
            this.stat.withTimeWindow(window, unit);
        } else {
            this.timeWindowMs = -1L;
        }
    }

    public String unitName() {
        return this.unit.name().substring(0, this.unit.name().length() - 2).toLowerCase(Locale.ROOT);
    }

    @Override
    public void record(MetricConfig config, double value, long timeMs) {
        this.stat.record(config, value, timeMs);
    }

    @Override
    public double measure(MetricConfig config, long now) {
        double value = this.stat.measure(config, now);
        return value / MetricsUtils.convert(this.windowSize(config, now), this.unit);
    }

    public long windowSize(MetricConfig config, long now) {
        this.stat.purgeObsoleteSamples(config, now);
        long totalElapsedTimeMs = now - this.stat.oldest((long)now).startTimeMs;
        long windowMs = this.timeWindowMs > 0L ? this.timeWindowMs : config.timeWindowMs();
        int numFullWindows = (int)(totalElapsedTimeMs / windowMs);
        int minFullWindows = config.samples() - 1;
        if (numFullWindows < minFullWindows) {
            totalElapsedTimeMs += (long)(minFullWindows - numFullWindows) * windowMs;
        }
        return Math.max(totalElapsedTimeMs, 1L);
    }

    public String toString() {
        return "Rate(unit=" + String.valueOf((Object)this.unit) + ", stat=" + String.valueOf(this.stat) + ")";
    }
}

