/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.ConfigValue;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.connect.runtime.ConnectorConfig;
import org.apache.kafka.connect.runtime.WorkerConfig;
import org.apache.kafka.connect.runtime.isolation.Plugins;
import org.apache.kafka.connect.transforms.util.RegexValidator;

public class SinkConnectorConfig
extends ConnectorConfig {
    public static final String TOPICS_CONFIG = "topics";
    private static final String TOPICS_DOC = "List of topics to consume, separated by commas";
    public static final List<String> TOPICS_DEFAULT = List.of();
    private static final String TOPICS_DISPLAY = "Topics";
    public static final String TOPICS_REGEX_CONFIG = "topics.regex";
    private static final String TOPICS_REGEX_DOC = "Regular expression giving topics to consume. Under the hood, the regex is compiled to a <code>java.util.regex.Pattern</code>. Only one of topics or topics.regex should be specified.";
    public static final String TOPICS_REGEX_DEFAULT = "";
    private static final String TOPICS_REGEX_DISPLAY = "Topics regex";
    public static final String DLQ_PREFIX = "errors.deadletterqueue.";
    public static final String DLQ_TOPIC_NAME_CONFIG = "errors.deadletterqueue.topic.name";
    public static final String DLQ_TOPIC_NAME_DOC = "The name of the topic to be used as the dead letter queue (DLQ) for messages that result in an error when processed by this sink connector, or its transformations or converters. The topic name is blank by default, which means that no messages are to be recorded in the DLQ.";
    public static final String DLQ_TOPIC_DEFAULT = "";
    private static final String DLQ_TOPIC_DISPLAY = "Dead Letter Queue Topic Name";
    public static final String DLQ_TOPIC_REPLICATION_FACTOR_CONFIG = "errors.deadletterqueue.topic.replication.factor";
    private static final String DLQ_TOPIC_REPLICATION_FACTOR_CONFIG_DOC = "Replication factor used to create the dead letter queue topic when it doesn't already exist.";
    public static final short DLQ_TOPIC_REPLICATION_FACTOR_CONFIG_DEFAULT = 3;
    private static final String DLQ_TOPIC_REPLICATION_FACTOR_CONFIG_DISPLAY = "Dead Letter Queue Topic Replication Factor";
    public static final String DLQ_CONTEXT_HEADERS_ENABLE_CONFIG = "errors.deadletterqueue.context.headers.enable";
    public static final boolean DLQ_CONTEXT_HEADERS_ENABLE_DEFAULT = false;
    public static final String DLQ_CONTEXT_HEADERS_ENABLE_DOC = "If true, add headers containing error context to the messages written to the dead letter queue. To avoid clashing with headers from the original record, all error context header keys, all error context header keys will start with <code>__connect.errors.</code>";
    private static final String DLQ_CONTEXT_HEADERS_ENABLE_DISPLAY = "Enable Error Context Headers";

    private static ConfigDef configDef(ConfigDef baseConfigs) {
        return baseConfigs.define(TOPICS_CONFIG, ConfigDef.Type.LIST, TOPICS_DEFAULT, (ConfigDef.Validator)ConfigDef.ValidList.anyNonDuplicateValues((boolean)true, (boolean)false), ConfigDef.Importance.HIGH, TOPICS_DOC, "Common", 4, ConfigDef.Width.LONG, TOPICS_DISPLAY).define(TOPICS_REGEX_CONFIG, ConfigDef.Type.STRING, (Object)"", (ConfigDef.Validator)new RegexValidator(), ConfigDef.Importance.HIGH, TOPICS_REGEX_DOC, "Common", 4, ConfigDef.Width.LONG, TOPICS_REGEX_DISPLAY).define(DLQ_TOPIC_NAME_CONFIG, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.MEDIUM, DLQ_TOPIC_NAME_DOC, "Error Handling", 6, ConfigDef.Width.MEDIUM, DLQ_TOPIC_DISPLAY).define(DLQ_TOPIC_REPLICATION_FACTOR_CONFIG, ConfigDef.Type.SHORT, (Object)3, ConfigDef.Importance.MEDIUM, DLQ_TOPIC_REPLICATION_FACTOR_CONFIG_DOC, "Error Handling", 7, ConfigDef.Width.MEDIUM, DLQ_TOPIC_REPLICATION_FACTOR_CONFIG_DISPLAY).define(DLQ_CONTEXT_HEADERS_ENABLE_CONFIG, ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.MEDIUM, DLQ_CONTEXT_HEADERS_ENABLE_DOC, "Error Handling", 8, ConfigDef.Width.MEDIUM, DLQ_CONTEXT_HEADERS_ENABLE_DISPLAY);
    }

    public static ConfigDef configDef() {
        return SinkConnectorConfig.configDef(ConnectorConfig.configDef());
    }

    public static ConfigDef enrichedConfigDef(Plugins plugins, Map<String, String> connProps, WorkerConfig workerConfig) {
        return SinkConnectorConfig.configDef(ConnectorConfig.enrichedConfigDef(plugins, connProps, workerConfig));
    }

    public static ConfigDef enrichedConfigDef(Plugins plugins, String connectorClass) {
        return SinkConnectorConfig.configDef(ConnectorConfig.enrichedConfigDef(plugins, connectorClass));
    }

    public SinkConnectorConfig(Plugins plugins, Map<String, String> props) {
        super(plugins, SinkConnectorConfig.configDef(), props);
    }

    public static void validate(Map<String, String> props) {
        LinkedHashMap<String, ConfigValue> validatedConfig = new LinkedHashMap<String, ConfigValue>();
        SinkConnectorConfig.validate(props, validatedConfig);
        validatedConfig.values().stream().filter(configValue -> !configValue.errorMessages().isEmpty()).findFirst().ifPresent(configValue -> {
            throw new ConfigException(configValue.name(), configValue.value(), (String)configValue.errorMessages().get(0));
        });
    }

    public static void validate(Map<String, String> props, Map<String, ConfigValue> validatedConfig) {
        String errorMessage;
        boolean hasDlqTopicConfig;
        String topicsList = props.get(TOPICS_CONFIG);
        String topicsRegex = props.get(TOPICS_REGEX_CONFIG);
        String dlqTopic = props.getOrDefault(DLQ_TOPIC_NAME_CONFIG, "").trim();
        boolean hasTopicsConfig = !Utils.isBlank((String)topicsList);
        boolean hasTopicsRegexConfig = !Utils.isBlank((String)topicsRegex);
        boolean bl = hasDlqTopicConfig = !Utils.isBlank((String)dlqTopic);
        if (hasTopicsConfig && hasTopicsRegexConfig) {
            errorMessage = "topics and topics.regex are mutually exclusive options, but both are set.";
            SinkConnectorConfig.addErrorMessage(validatedConfig, TOPICS_CONFIG, topicsList, errorMessage);
            SinkConnectorConfig.addErrorMessage(validatedConfig, TOPICS_REGEX_CONFIG, topicsRegex, errorMessage);
        }
        if (!hasTopicsConfig && !hasTopicsRegexConfig) {
            errorMessage = "Must configure one of topics or topics.regex";
            SinkConnectorConfig.addErrorMessage(validatedConfig, TOPICS_CONFIG, topicsList, errorMessage);
            SinkConnectorConfig.addErrorMessage(validatedConfig, TOPICS_REGEX_CONFIG, topicsRegex, errorMessage);
        }
        if (hasDlqTopicConfig) {
            Pattern pattern;
            String errorMessage2;
            List<String> topics;
            if (hasTopicsConfig && (topics = SinkConnectorConfig.parseTopicsList(props)).contains(dlqTopic)) {
                errorMessage2 = String.format("The DLQ topic '%s' may not be included in the list of topics ('%s=%s') consumed by the connector", dlqTopic, TOPICS_CONFIG, topics);
                SinkConnectorConfig.addErrorMessage(validatedConfig, TOPICS_CONFIG, topicsList, errorMessage2);
            }
            if (hasTopicsRegexConfig && (pattern = Pattern.compile(topicsRegex)).matcher(dlqTopic).matches()) {
                errorMessage2 = String.format("The DLQ topic '%s' may not be matched by the regex for the topics ('%s=%s') consumed by the connector", dlqTopic, TOPICS_REGEX_CONFIG, topicsRegex);
                SinkConnectorConfig.addErrorMessage(validatedConfig, TOPICS_REGEX_CONFIG, topicsRegex, errorMessage2);
            }
        }
    }

    private static void addErrorMessage(Map<String, ConfigValue> validatedConfig, String name, String value, String errorMessage) {
        validatedConfig.computeIfAbsent(name, p -> new ConfigValue(name, (Object)value, List.of(), new ArrayList())).addErrorMessage(errorMessage);
    }

    public static boolean hasTopicsConfig(Map<String, String> props) {
        String topicsStr = props.get(TOPICS_CONFIG);
        return !Utils.isBlank((String)topicsStr);
    }

    public static boolean hasDlqTopicConfig(Map<String, String> props) {
        String dqlTopicStr = props.get(DLQ_TOPIC_NAME_CONFIG);
        return !Utils.isBlank((String)dqlTopicStr);
    }

    public static List<String> parseTopicsList(Map<String, String> props) {
        List topics = (List)ConfigDef.parseType((String)TOPICS_CONFIG, (Object)props.get(TOPICS_CONFIG), (ConfigDef.Type)ConfigDef.Type.LIST);
        if (topics == null) {
            return List.of();
        }
        return topics.stream().filter(topic -> !topic.isEmpty()).distinct().collect(Collectors.toList());
    }

    public String dlqTopicName() {
        return this.getString(DLQ_TOPIC_NAME_CONFIG);
    }

    public short dlqTopicReplicationFactor() {
        return this.getShort(DLQ_TOPIC_REPLICATION_FACTOR_CONFIG);
    }

    public boolean isDlqContextHeadersEnabled() {
        return this.getBoolean(DLQ_CONTEXT_HEADERS_ENABLE_CONFIG);
    }

    public boolean enableErrantRecordReporter() {
        String dqlTopic = this.dlqTopicName();
        return !dqlTopic.isEmpty() || this.enableErrorLog();
    }

    public static void main(String[] args) {
        System.out.println(SinkConnectorConfig.configDef().toHtml(4, config -> "sinkconnectorconfigs_" + config));
    }
}

