function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) { ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) { o = n[r], -1 === t.indexOf(o) && {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) { if ({}.hasOwnProperty.call(r, n)) { if (-1 !== e.indexOf(n)) continue; t[n] = r[n]; } } return t; }
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import React from 'react';
import PropTypes from "prop-types";
import classNames from 'classnames';
import { OuiButtonIcon } from '../button';
export var OuiResizableCollapseButton = function OuiResizableCollapseButton(_ref) {
  var className = _ref.className,
    externalPosition = _ref.externalPosition,
    _ref$internalPosition = _ref.internalPosition,
    internalPosition = _ref$internalPosition === void 0 ? 'middle' : _ref$internalPosition,
    _ref$direction = _ref.direction,
    direction = _ref$direction === void 0 ? 'horizontal' : _ref$direction,
    isVisible = _ref.isVisible,
    isCollapsed = _ref.isCollapsed,
    rest = _objectWithoutProperties(_ref, ["className", "externalPosition", "internalPosition", "direction", "isVisible", "isCollapsed"]);
  var isHorizontal = direction === 'horizontal';
  var classes = classNames('ouiResizableToggleButton', "ouiResizableToggleButton--".concat(direction), "ouiResizableToggleButton--".concat(externalPosition), "ouiResizableToggleButton--".concat(internalPosition), {
    'ouiResizableToggleButton-isVisible': isVisible,
    'ouiResizableToggleButton-isCollapsed': isCollapsed
  }, className);

  // Default to simiple grab icon in case there is no externalPosition specified
  var COLLAPSED_ICON = isHorizontal ? 'grab' : 'grabHorizontal';
  var NOT_COLLAPSED_ICON = isHorizontal ? 'grab' : 'grabHorizontal';
  switch (externalPosition) {
    case 'before':
      COLLAPSED_ICON = isHorizontal ? 'menuLeft' : 'menuUp';
      NOT_COLLAPSED_ICON = isHorizontal ? 'menuRight' : 'menuDown';
      break;
    case 'after':
      COLLAPSED_ICON = isHorizontal ? 'menuRight' : 'menuDown';
      NOT_COLLAPSED_ICON = isHorizontal ? 'menuLeft' : 'menuUp';
      break;
  }
  return /*#__PURE__*/React.createElement(OuiButtonIcon, _extends({
    display: isCollapsed ? 'empty' : 'fill',
    color: isCollapsed ? 'text' : 'ghost'
  }, rest, {
    className: classes,
    iconType: isCollapsed ? COLLAPSED_ICON : NOT_COLLAPSED_ICON
  }));
};

/* OUI -> EUI Aliases: Build-Time */
OuiResizableCollapseButton.propTypes = {
  /**
     * Position of the toggle button.
     * Enums based on the `direction` of the OuiResizableContainer
     */
  internalPosition: PropTypes.oneOf(["top", "middle", "bottom", "left", "right"]),
  /**
     * Position of the toggle button.
     * Enums based on the `direction` of the OuiResizableContainer
     */
  externalPosition: PropTypes.oneOf(["before", "after"]),
  /**
     * Same direction derived from OuiResizableContainer
     */
  direction: PropTypes.oneOf(["vertical", "horizontal"]),
  /**
     *
     */
  isVisible: PropTypes.bool,
  isCollapsed: PropTypes.bool
};
/* OUI -> EUI Aliases: Build-Time */export { EuiResizableCollapseButton } from '../../eui_components/resizable_container/resizable_collapse_button';