/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.renderers;

import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.NestedTable;
import com.intellij.database.datagrid.ResultView;
import com.intellij.database.datagrid.ViewIndex;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.grid.renderers.DefaultTextRendererFactory;
import com.intellij.database.run.ui.grid.renderers.GridCellRenderer;
import com.intellij.database.run.ui.grid.renderers.GridCellRendererFactory;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.EditorTextFieldCellRenderer;
import com.intellij.ui.hover.TableHoverListener;
import com.intellij.util.ui.JBEmptyBorder;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NestedTableCellRendererFactory
implements GridCellRendererFactory {
    private final DataGrid myGrid;
    NestedTableTextRenderer textRenderer;

    public NestedTableCellRendererFactory(@NotNull DataGrid grid) {
        if (grid == null) {
            NestedTableCellRendererFactory.$$$reportNull$$$0(0);
        }
        this.myGrid = grid;
    }

    @Override
    public boolean supports(@NotNull ModelIndex<GridRow> row, @NotNull ModelIndex<GridColumn> column) {
        if (row == null) {
            NestedTableCellRendererFactory.$$$reportNull$$$0(1);
        }
        if (column == null) {
            NestedTableCellRendererFactory.$$$reportNull$$$0(2);
        }
        Object cellValue = this.myGrid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getValueAt(row, column);
        return cellValue instanceof NestedTable;
    }

    @Override
    @NotNull
    public GridCellRenderer getOrCreateRenderer(@NotNull ModelIndex<GridRow> row, @NotNull ModelIndex<GridColumn> column) {
        if (row == null) {
            NestedTableCellRendererFactory.$$$reportNull$$$0(3);
        }
        if (column == null) {
            NestedTableCellRendererFactory.$$$reportNull$$$0(4);
        }
        if (this.textRenderer == null) {
            this.textRenderer = new NestedTableTextRenderer(this.myGrid);
            Disposer.register((Disposable)this.myGrid, (Disposable)this.textRenderer);
        }
        NestedTableTextRenderer nestedTableTextRenderer = this.textRenderer;
        if (nestedTableTextRenderer == null) {
            NestedTableCellRendererFactory.$$$reportNull$$$0(5);
        }
        return nestedTableTextRenderer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/grid/renderers/NestedTableCellRendererFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/grid/renderers/NestedTableCellRendererFactory";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateRenderer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "supports";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateRenderer";
                break;
            }
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }

    public static class NestedTableTextRenderer
    extends DefaultTextRendererFactory.TextRenderer {
        public NestedTableTextRenderer(@NotNull DataGrid grid) {
            if (grid == null) {
                NestedTableTextRenderer.$$$reportNull$$$0(0);
            }
            super(grid, (Border)new JBEmptyBorder(0, 1, 0, 3));
        }

        @Override
        @NotNull
        public JComponent getComponent(@NotNull ViewIndex<GridRow> rowIdx, @NotNull ViewIndex<GridColumn> columnIdx, @Nullable Object value, @NotNull ModelIndex<GridColumn> modelColumn) {
            if (rowIdx == null) {
                NestedTableTextRenderer.$$$reportNull$$$0(1);
            }
            if (columnIdx == null) {
                NestedTableTextRenderer.$$$reportNull$$$0(2);
            }
            if (modelColumn == null) {
                NestedTableTextRenderer.$$$reportNull$$$0(3);
            }
            EditorTextFieldCellRenderer.AbbreviatingRendererComponent component = (EditorTextFieldCellRenderer.AbbreviatingRendererComponent)super.getComponent(rowIdx, columnIdx, value, modelColumn);
            ResultView resultView = this.myGrid.getResultView();
            if (!(resultView instanceof JTable)) {
                EditorTextFieldCellRenderer.AbbreviatingRendererComponent abbreviatingRendererComponent = component;
                if (abbreviatingRendererComponent == null) {
                    NestedTableTextRenderer.$$$reportNull$$$0(4);
                }
                return abbreviatingRendererComponent;
            }
            JTable tableView = (JTable)((Object)resultView);
            int hoveredRowIdx = TableHoverListener.getHoveredRow((JTable)tableView);
            boolean isHoveredRow = hoveredRowIdx == rowIdx.asInteger();
            component.setText(NestedTableTextRenderer.getValueText(value, isHoveredRow));
            EditorTextFieldCellRenderer.AbbreviatingRendererComponent abbreviatingRendererComponent = component;
            if (abbreviatingRendererComponent == null) {
                NestedTableTextRenderer.$$$reportNull$$$0(5);
            }
            return abbreviatingRendererComponent;
        }

        private static String getValueText(@Nullable Object value, boolean isHovered) {
            if (value == null) {
                return "";
            }
            NestedTable nestedTable = (NestedTable)value;
            List columns = nestedTable.getColumnsHierarchy().getChildren();
            String valueText = columns.isEmpty() || nestedTable.getRowsNum() == 0 ? "[empty]" : String.format("[%d rows x %d columns]", nestedTable.getTotalRowsNum(), columns.size());
            return isHovered ? valueText + "\u2798" : valueText + " ";
        }

        @Override
        @NotNull
        protected String getValueText(@NotNull ModelIndex<GridColumn> columnIdx, @NotNull Object value) {
            if (columnIdx == null) {
                NestedTableTextRenderer.$$$reportNull$$$0(6);
            }
            if (value == null) {
                NestedTableTextRenderer.$$$reportNull$$$0(7);
            }
            return "";
        }

        @Override
        public int getSuitability(@NotNull ModelIndex<GridRow> row, @NotNull ModelIndex<GridColumn> column) {
            Object cellValue;
            if (row == null) {
                NestedTableTextRenderer.$$$reportNull$$$0(8);
            }
            if (column == null) {
                NestedTableTextRenderer.$$$reportNull$$$0(9);
            }
            return (cellValue = this.myGrid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getValueAt(row, column)) instanceof NestedTable ? 2 : 0;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "grid";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rowIdx";
                    break;
                }
                case 2: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "columnIdx";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "modelColumn";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/ui/grid/renderers/NestedTableCellRendererFactory$NestedTableTextRenderer";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "row";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "column";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/ui/grid/renderers/NestedTableCellRendererFactory$NestedTableTextRenderer";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getComponent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getComponent";
                    break;
                }
                case 4: 
                case 5: {
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "getValueText";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "getSuitability";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4, 5 -> new IllegalStateException(string);
            };
        }
    }
}

