/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.ide;

import com.intellij.ide.PasteProvider;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.image.BufferedImage;
import java.awt.image.MultiResolutionImage;
import java.awt.image.RenderedImage;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.images.ImagesBundle;
import org.intellij.images.ide.ImagePasteProviderKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tJ\u0018\u0010\u000e\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lorg/intellij/images/ide/ImagePasteProvider;", "Lcom/intellij/ide/PasteProvider;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "isPastePossible", "", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "isPasteEnabled", "isEnabledForDataContext", "performPaste", "", "imageFilePasted", "imageFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.platform.images"})
@SourceDebugExtension(value={"SMAP\nImagePasteProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImagePasteProvider.kt\norg/intellij/images/ide/ImagePasteProvider\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,127:1\n14#2:128\n*S KotlinDebug\n*F\n+ 1 ImagePasteProvider.kt\norg/intellij/images/ide/ImagePasteProvider\n*L\n45#1:128\n*E\n"})
public class ImagePasteProvider
implements PasteProvider {
    @NotNull
    public final ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public final boolean isPastePossible(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        return true;
    }

    public final boolean isPasteEnabled(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        DataFlavor[] dataFlavorArray = new DataFlavor[]{DataFlavor.imageFlavor};
        return CopyPasteManager.getInstance().areDataFlavorsAvailable(dataFlavorArray) && dataContext.getData(CommonDataKeys.VIRTUAL_FILE) != null && this.isEnabledForDataContext(dataContext);
    }

    public boolean isEnabledForDataContext(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        return true;
    }

    public final void performPaste(@NotNull DataContext dataContext) {
        BufferedImage imageToPaste;
        BufferedImage bufferedImage;
        Object object;
        VirtualFile newFileParent;
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        VirtualFile virtualFile = (VirtualFile)dataContext.getData(CommonDataKeys.VIRTUAL_FILE);
        if (virtualFile == null) {
            return;
        }
        VirtualFile currentFile = virtualFile;
        Transferable transferable = CopyPasteManager.getInstance().getContents();
        if (transferable == null) {
            return;
        }
        Transferable pasteContents = transferable;
        VirtualFile virtualFile2 = newFileParent = currentFile.isDirectory() ? currentFile : currentFile.getParent();
        if (newFileParent == null || !newFileParent.isDirectory()) {
            return;
        }
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ImagePasteProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        Logger logger2 = logger;
        try {
            object = pasteContents.getTransferData(DataFlavor.imageFlavor);
        }
        catch (IOException ioException) {
            logger2.error("Failed to get data from the clipboard. Data is no longer available. Aborting operation.", (Throwable)ioException);
            return;
        }
        Object it = object;
        boolean bl = false;
        Object object2 = it;
        if (object2 instanceof MultiResolutionImage) {
            List<Image> list = ((MultiResolutionImage)it).getResolutionVariants();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getResolutionVariants(...)");
            Image image = (Image)CollectionsKt.firstOrNull(list);
            bufferedImage = image != null ? ImagePasteProviderKt.access$toBufferedImage(image) : null;
        } else {
            bufferedImage = object2 instanceof BufferedImage ? (BufferedImage)it : (object2 instanceof Image ? ImagePasteProviderKt.access$toBufferedImage((Image)it) : null);
        }
        if ((imageToPaste = bufferedImage) == null) {
            logger2.error("Failed to get data from the clipboard. Nothing to paste. Aborting operation.");
            return;
        }
        String string = VfsUtil.getNextAvailableName((VirtualFile)newFileParent, (String)"img", (String)"png");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getNextAvailableName(...)");
        String fileName = string;
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        Object[] objectArray = new Object[]{fileName};
        CommandProcessor.getInstance().executeCommand(project, () -> ImagePasteProvider.performPaste$lambda$3(newFileParent, this, fileName, logger2, dataContext, imageToPaste), ImagesBundle.message("paste.image.command.name", objectArray), null, UndoConfirmationPolicy.REQUEST_CONFIRMATION);
    }

    public void imageFilePasted(@NotNull DataContext dataContext, @NotNull VirtualFile imageFile) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        Intrinsics.checkNotNullParameter((Object)imageFile, (String)"imageFile");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit performPaste$lambda$3$lambda$2(VirtualFile $newFileParent, ImagePasteProvider this$0, String $fileName, Logger $logger, DataContext $dataContext, BufferedImage $imageToPaste) {
        Object object;
        try {
            object = $newFileParent.createChildData((Object)this$0, $fileName);
        }
        catch (IOException ioException) {
            $logger.error("Failed to create a pasted image file due to I/O error. Aborting operation.", (Throwable)ioException);
            object = null;
        }
        VirtualFile virtualFile = object;
        if (virtualFile == null) {
            return Unit.INSTANCE;
        }
        VirtualFile imageFile = virtualFile;
        try {
            Closeable closeable = imageFile.getOutputStream((Object)this$0);
            object = null;
            try {
                OutputStream it = (OutputStream)closeable;
                boolean bl = false;
                boolean bl2 = ImageIO.write((RenderedImage)$imageToPaste, "png", it);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
            }
        }
        catch (IOException ioException) {
            $logger.error("Failed to save a pasted image to a file due to I/O error. Aborting operation", (Throwable)ioException);
            try {
                imageFile.delete((Object)this$0);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return Unit.INSTANCE;
        }
        this$0.imageFilePasted($dataContext, imageFile);
        return Unit.INSTANCE;
    }

    private static final void performPaste$lambda$3(VirtualFile $newFileParent, ImagePasteProvider this$0, String $fileName, Logger $logger, DataContext $dataContext, BufferedImage $imageToPaste) {
        ActionsKt.runWriteAction(() -> ImagePasteProvider.performPaste$lambda$3$lambda$2($newFileParent, this$0, $fileName, $logger, $dataContext, $imageToPaste));
    }
}

