/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.remote;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParamsGroup;
import com.intellij.remote.RemoteFile;
import com.intellij.remote.RemoteProcessUtil;
import com.intellij.remote.RemoteSdkProperties;
import com.intellij.util.PathMapper;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyCommandLineStateUtil {
    private static final String PY_STUFF_TO_RUN = "PY_STUFF_TO_RUN";

    private PyCommandLineStateUtil() {
    }

    public static void remap(@NotNull RemoteSdkProperties sdkProperties, @NotNull GeneralCommandLine commandLine, @NotNull PathMapper pathMapper) {
        if (sdkProperties == null) {
            PyCommandLineStateUtil.$$$reportNull$$$0(0);
        }
        if (commandLine == null) {
            PyCommandLineStateUtil.$$$reportNull$$$0(1);
        }
        if (pathMapper == null) {
            PyCommandLineStateUtil.$$$reportNull$$$0(2);
        }
        PyCommandLineStateUtil.remap(sdkProperties.getInterpreterPath(), commandLine, pathMapper);
    }

    public static void remap(@NotNull String interpreterPath, @NotNull GeneralCommandLine commandLine, @NotNull PathMapper pathMapper) {
        if (interpreterPath == null) {
            PyCommandLineStateUtil.$$$reportNull$$$0(3);
        }
        if (commandLine == null) {
            PyCommandLineStateUtil.$$$reportNull$$$0(4);
        }
        if (pathMapper == null) {
            PyCommandLineStateUtil.$$$reportNull$$$0(5);
        }
        ParamsGroup paramsGroup = commandLine.getParametersList().getParamsGroup("Script");
        PyCommandLineStateUtil.remapParameters(interpreterPath, pathMapper, paramsGroup, commandLine.getWorkDirectory());
        PyCommandLineStateUtil.remapEnvPaths(commandLine.getEnvironment(), pathMapper, interpreterPath, "PYTHONPATH");
        PyCommandLineStateUtil.remapEnvPaths(commandLine.getEnvironment(), pathMapper, interpreterPath, "IDE_PROJECT_ROOTS");
        PyCommandLineStateUtil.remapEnvStuffPaths(commandLine.getEnvironment(), pathMapper, interpreterPath, PY_STUFF_TO_RUN);
    }

    public static void remapParameters(@NotNull String interpreterPath, @NotNull PathMapper pathMapper, @Nullable ParamsGroup paramsGroup, @Nullable File workDirectory) {
        if (interpreterPath == null) {
            PyCommandLineStateUtil.$$$reportNull$$$0(6);
        }
        if (pathMapper == null) {
            PyCommandLineStateUtil.$$$reportNull$$$0(7);
        }
        if (paramsGroup != null) {
            if (!paramsGroup.getParameters().isEmpty()) {
                PyCommandLineStateUtil.makeParamAbsoluteIfRelative(paramsGroup, 0, workDirectory);
            }
            int i = 0;
            boolean isWin = RemoteFile.isWindowsPath((String)interpreterPath);
            for (String param : paramsGroup.getParameters()) {
                if (!pathMapper.canReplaceLocal(param)) continue;
                paramsGroup.getParametersList().set(i++, RemoteFile.createRemoteFile((String)pathMapper.convertToRemote(param), (boolean)isWin).getPath());
            }
        }
    }

    private static void makeParamAbsoluteIfRelative(ParamsGroup paramsGroup, int paramIndex, @Nullable File workDirectory) {
        File paramFile;
        String param = (String)paramsGroup.getParameters().get(paramIndex);
        if (!new File(param).isAbsolute() && workDirectory != null && (paramFile = new File(workDirectory, param)).exists()) {
            paramsGroup.getParametersList().set(paramIndex, paramFile.getPath());
        }
    }

    private static void remapEnvPaths(Map<String, String> env, PathMapper pathMapper, String interpreterPath, String envKey) {
        if (env.isEmpty()) {
            return;
        }
        String envPaths = env.get(envKey);
        if (envPaths != null) {
            env.put(envKey, RemoteProcessUtil.remapPathsList((String)envPaths, (PathMapper)pathMapper, (String)interpreterPath));
        }
    }

    private static void remapEnvStuffPaths(Map<String, String> env, PathMapper pathMapper, String interpreterPath, String envKey) {
        String envPaths = env.get(envKey);
        if (envPaths != null) {
            env.put(envKey, PyCommandLineStateUtil.remapStuffPathsList(envPaths, pathMapper, interpreterPath));
        }
    }

    @NotNull
    public static String remapStuffPathsList(@NotNull String pathsValue, @NotNull PathMapper pathMapper, @NotNull String interpreterPath) {
        if (pathsValue == null) {
            PyCommandLineStateUtil.$$$reportNull$$$0(8);
        }
        if (pathMapper == null) {
            PyCommandLineStateUtil.$$$reportNull$$$0(9);
        }
        if (interpreterPath == null) {
            PyCommandLineStateUtil.$$$reportNull$$$0(10);
        }
        boolean isWin = RemoteFile.isWindowsPath((String)interpreterPath);
        ArrayList<String> mappedPaths = new ArrayList<String>();
        for (String path2 : pathsValue.split(Pattern.quote("|"))) {
            mappedPaths.add(RemoteFile.createRemoteFile((String)pathMapper.convertToRemote(path2), (boolean)isWin).getPath());
        }
        String string = String.join((CharSequence)"|", mappedPaths);
        if (string == null) {
            PyCommandLineStateUtil.$$$reportNull$$$0(11);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkProperties";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathMapper";
                break;
            }
            case 3: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterPath";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathsValue";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/remote/PyCommandLineStateUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/remote/PyCommandLineStateUtil";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "remapStuffPathsList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "remap";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "remapParameters";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "remapStuffPathsList";
                break;
            }
            case 11: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 11 -> new IllegalStateException(string);
        };
    }
}

