/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.rollover;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jdesktop.swingx.rollover.RolloverController;
import org.jdesktop.swingx.rollover.RolloverRenderer;

public class ListRolloverController<T extends JList>
extends RolloverController<T> {
    private Cursor oldCursor;

    @Override
    protected void rollover(Point oldLocation, Point newLocation) {
        Rectangle r2;
        if (oldLocation != null && (r2 = ((JList)this.component).getCellBounds(oldLocation.y, oldLocation.y)) != null) {
            ((JList)this.component).repaint(r2);
        }
        if (newLocation != null && (r2 = ((JList)this.component).getCellBounds(newLocation.y, newLocation.y)) != null) {
            ((JList)this.component).repaint(r2);
        }
        this.setRolloverCursor(newLocation);
    }

    private void setRolloverCursor(Point location) {
        if (this.hasRollover(location)) {
            if (this.oldCursor == null) {
                this.oldCursor = ((JList)this.component).getCursor();
                ((JList)this.component).setCursor(Cursor.getPredefinedCursor(12));
            }
        } else if (this.oldCursor != null) {
            ((JList)this.component).setCursor(this.oldCursor);
            this.oldCursor = null;
        }
    }

    @Override
    protected RolloverRenderer getRolloverRenderer(Point location, boolean prepare) {
        RolloverRenderer rollover;
        ListCellRenderer renderer = ((JList)this.component).getCellRenderer();
        RolloverRenderer rolloverRenderer = rollover = renderer instanceof RolloverRenderer ? (RolloverRenderer)((Object)renderer) : null;
        if (rollover != null && !rollover.isEnabled()) {
            rollover = null;
        }
        if (rollover != null && prepare) {
            Object element = ((JList)this.component).getModel().getElementAt(location.y);
            renderer.getListCellRendererComponent((JList)this.component, element, location.y, false, true);
        }
        return rollover;
    }

    @Override
    protected Point getFocusedCell() {
        int leadRow = ((JList)this.component).getLeadSelectionIndex();
        if (leadRow < 0) {
            return null;
        }
        return new Point(0, leadRow);
    }
}

