/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.pydev.transport;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.io.BaseOutputReader;
import com.jetbrains.python.debugger.pydev.RemoteDebugger;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;

public abstract class BaseDebuggerReader
extends BaseOutputReader {
    private static final Logger LOG = Logger.getInstance(BaseDebuggerReader.class);
    @NotNull
    private final RemoteDebugger myDebugger;
    @NotNull
    private StringBuilder myTextBuilder;

    public BaseDebuggerReader(@NotNull InputStream inputStream, @NotNull Charset charset, @NotNull RemoteDebugger debugger) {
        if (inputStream == null) {
            BaseDebuggerReader.$$$reportNull$$$0(0);
        }
        if (charset == null) {
            BaseDebuggerReader.$$$reportNull$$$0(1);
        }
        if (debugger == null) {
            BaseDebuggerReader.$$$reportNull$$$0(2);
        }
        super(inputStream, charset);
        this.myTextBuilder = new StringBuilder();
        this.myDebugger = debugger;
    }

    @NotNull
    protected RemoteDebugger getDebugger() {
        RemoteDebugger remoteDebugger = this.myDebugger;
        if (remoteDebugger == null) {
            BaseDebuggerReader.$$$reportNull$$$0(3);
        }
        return remoteDebugger;
    }

    protected void doRun() {
        try {
            boolean read;
            while (read = this.readAvailableBlocking()) {
                if (this.isStopped) {
                    break;
                }
                TimeoutUtil.sleep((long)this.mySleepingPolicy.getTimeToSleep(true));
            }
        }
        catch (Exception e) {
            this.onCommunicationError();
        }
        finally {
            this.close();
            this.onExit();
        }
    }

    protected abstract void onExit();

    protected abstract void onCommunicationError();

    @NotNull
    protected Future<?> executeOnPooledThread(@NotNull Runnable runnable) {
        if (runnable == null) {
            BaseDebuggerReader.$$$reportNull$$$0(4);
        }
        Future future = ApplicationManager.getApplication().executeOnPooledThread(runnable);
        if (future == null) {
            BaseDebuggerReader.$$$reportNull$$$0(5);
        }
        return future;
    }

    protected void close() {
        try {
            super.close();
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    public void stop() {
        super.stop();
        this.close();
    }

    protected void onTextAvailable(@NotNull String text) {
        if (text == null) {
            BaseDebuggerReader.$$$reportNull$$$0(6);
        }
        this.myTextBuilder.append(text);
        if (text.contains("\n")) {
            String[] lines = this.myTextBuilder.toString().split("\n");
            this.myTextBuilder = new StringBuilder();
            if (!text.endsWith("\n")) {
                this.myTextBuilder.append(lines[lines.length - 1]);
                lines = Arrays.copyOf(lines, lines.length - 1);
            }
            for (String line : lines) {
                this.myDebugger.processResponse(line + "\n");
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charset";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugger";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/debugger/pydev/transport/BaseDebuggerReader";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/debugger/pydev/transport/BaseDebuggerReader";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDebugger";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "executeOnPooledThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "executeOnPooledThread";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "onTextAvailable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5 -> new IllegalStateException(string);
        };
    }
}

