/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json;

import com.intellij.json.JsonElementTypes;
import com.intellij.json.JsonFileElementTypesKt;
import com.intellij.json.JsonLanguage;
import com.intellij.json.JsonLexer;
import com.intellij.json.JsonTokenSets;
import com.intellij.json.psi.impl.JsonFileImpl;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiParser;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.TokenSet;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J\u0012\u0010\b\u001a\u00020\t2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\rH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u001c\u0010\u0017\u001a\u00020\u00182\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0019\u001a\u0004\u0018\u00010\u0012H\u0016\u00a8\u0006\u001a"}, d2={"Lcom/intellij/json/JsonParserDefinition;", "Lcom/intellij/lang/ParserDefinition;", "<init>", "()V", "createLexer", "Lcom/intellij/lexer/Lexer;", "project", "Lcom/intellij/openapi/project/Project;", "createParser", "Lcom/intellij/lang/PsiParser;", "getFileNodeType", "Lcom/intellij/psi/tree/IFileElementType;", "getCommentTokens", "Lcom/intellij/psi/tree/TokenSet;", "getStringLiteralElements", "createElement", "Lcom/intellij/psi/PsiElement;", "astNode", "Lcom/intellij/lang/ASTNode;", "createFile", "Lcom/intellij/psi/PsiFile;", "fileViewProvider", "Lcom/intellij/psi/FileViewProvider;", "spaceExistenceTypeBetweenTokens", "Lcom/intellij/lang/ParserDefinition$SpaceRequirements;", "astNode2", "intellij.json"})
public class JsonParserDefinition
implements ParserDefinition {
    @NotNull
    public Lexer createLexer(@Nullable Project project) {
        return (Lexer)new JsonLexer();
    }

    @NotNull
    public PsiParser createParser(@Nullable Project project) {
        throw new UnsupportedOperationException("Should not be called directly. If you didn't call directly, check your IFileElementType implementation \u2014 it should implement com.intellij.platform.syntax.psi.SyntaxFileElementType.SyntaxFileElementType");
    }

    @NotNull
    public IFileElementType getFileNodeType() {
        return JsonFileElementTypesKt.JSON_FILE;
    }

    @NotNull
    public TokenSet getCommentTokens() {
        TokenSet tokenSet = JsonTokenSets.JSON_COMMENTARIES;
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"JSON_COMMENTARIES");
        return tokenSet;
    }

    @NotNull
    public TokenSet getStringLiteralElements() {
        TokenSet tokenSet = JsonTokenSets.STRING_LITERALS;
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"STRING_LITERALS");
        return tokenSet;
    }

    @NotNull
    public PsiElement createElement(@NotNull ASTNode astNode) {
        Intrinsics.checkNotNullParameter((Object)astNode, (String)"astNode");
        PsiElement psiElement = JsonElementTypes.Factory.createElement(astNode);
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"createElement(...)");
        return psiElement;
    }

    @NotNull
    public PsiFile createFile(@NotNull FileViewProvider fileViewProvider) {
        Intrinsics.checkNotNullParameter((Object)fileViewProvider, (String)"fileViewProvider");
        return new JsonFileImpl(fileViewProvider, JsonLanguage.INSTANCE);
    }

    @NotNull
    public ParserDefinition.SpaceRequirements spaceExistenceTypeBetweenTokens(@Nullable ASTNode astNode, @Nullable ASTNode astNode2) {
        return ParserDefinition.SpaceRequirements.MAY;
    }
}

