from chardet.enums import CharacterCategory, SequenceLikelihood
from chardet.sbcharsetprober import SingleByteCharSetModel

BELARUSIAN_LANG_MODEL = {
    65: {  # 'ʼ'
        65: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ё'
        48: SequenceLikelihood.NEGATIVE,  # 'І'
        62: SequenceLikelihood.NEGATIVE,  # 'Ў'
        33: SequenceLikelihood.NEGATIVE,  # 'А'
        36: SequenceLikelihood.NEGATIVE,  # 'Б'
        40: SequenceLikelihood.NEGATIVE,  # 'В'
        43: SequenceLikelihood.NEGATIVE,  # 'Г'
        45: SequenceLikelihood.NEGATIVE,  # 'Д'
        56: SequenceLikelihood.NEGATIVE,  # 'Е'
        57: SequenceLikelihood.NEGATIVE,  # 'Ж'
        46: SequenceLikelihood.NEGATIVE,  # 'З'
        63: SequenceLikelihood.NEGATIVE,  # 'Й'
        37: SequenceLikelihood.NEGATIVE,  # 'К'
        44: SequenceLikelihood.NEGATIVE,  # 'Л'
        38: SequenceLikelihood.NEGATIVE,  # 'М'
        42: SequenceLikelihood.NEGATIVE,  # 'Н'
        58: SequenceLikelihood.NEGATIVE,  # 'О'
        32: SequenceLikelihood.NEGATIVE,  # 'П'
        41: SequenceLikelihood.NEGATIVE,  # 'Р'
        31: SequenceLikelihood.NEGATIVE,  # 'С'
        47: SequenceLikelihood.NEGATIVE,  # 'Т'
        39: SequenceLikelihood.NEGATIVE,  # 'У'
        49: SequenceLikelihood.NEGATIVE,  # 'Ф'
        53: SequenceLikelihood.NEGATIVE,  # 'Х'
        55: SequenceLikelihood.NEGATIVE,  # 'Ц'
        54: SequenceLikelihood.NEGATIVE,  # 'Ч'
        52: SequenceLikelihood.NEGATIVE,  # 'Ш'
        61: SequenceLikelihood.NEGATIVE,  # 'Ы'
        64: SequenceLikelihood.NEGATIVE,  # 'Ь'
        51: SequenceLikelihood.NEGATIVE,  # 'Э'
        59: SequenceLikelihood.NEGATIVE,  # 'Ю'
        50: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.NEGATIVE,  # 'а'
        22: SequenceLikelihood.NEGATIVE,  # 'б'
        14: SequenceLikelihood.NEGATIVE,  # 'в'
        21: SequenceLikelihood.NEGATIVE,  # 'г'
        13: SequenceLikelihood.NEGATIVE,  # 'д'
        9: SequenceLikelihood.UNLIKELY,  # 'е'
        29: SequenceLikelihood.NEGATIVE,  # 'ж'
        18: SequenceLikelihood.NEGATIVE,  # 'з'
        25: SequenceLikelihood.NEGATIVE,  # 'й'
        7: SequenceLikelihood.NEGATIVE,  # 'к'
        8: SequenceLikelihood.NEGATIVE,  # 'л'
        15: SequenceLikelihood.NEGATIVE,  # 'м'
        2: SequenceLikelihood.NEGATIVE,  # 'н'
        12: SequenceLikelihood.NEGATIVE,  # 'о'
        17: SequenceLikelihood.NEGATIVE,  # 'п'
        4: SequenceLikelihood.NEGATIVE,  # 'р'
        5: SequenceLikelihood.NEGATIVE,  # 'с'
        10: SequenceLikelihood.NEGATIVE,  # 'т'
        16: SequenceLikelihood.NEGATIVE,  # 'у'
        34: SequenceLikelihood.NEGATIVE,  # 'ф'
        27: SequenceLikelihood.NEGATIVE,  # 'х'
        20: SequenceLikelihood.NEGATIVE,  # 'ц'
        23: SequenceLikelihood.NEGATIVE,  # 'ч'
        28: SequenceLikelihood.NEGATIVE,  # 'ш'
        6: SequenceLikelihood.NEGATIVE,  # 'ы'
        26: SequenceLikelihood.NEGATIVE,  # 'ь'
        24: SequenceLikelihood.NEGATIVE,  # 'э'
        30: SequenceLikelihood.NEGATIVE,  # 'ю'
        11: SequenceLikelihood.UNLIKELY,  # 'я'
        35: SequenceLikelihood.NEGATIVE,  # 'ё'
        3: SequenceLikelihood.NEGATIVE,  # 'і'
        19: SequenceLikelihood.NEGATIVE,  # 'ў'
    },
    60: {  # 'Ё'
        65: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ё'
        48: SequenceLikelihood.NEGATIVE,  # 'І'
        62: SequenceLikelihood.NEGATIVE,  # 'Ў'
        33: SequenceLikelihood.NEGATIVE,  # 'А'
        36: SequenceLikelihood.NEGATIVE,  # 'Б'
        40: SequenceLikelihood.UNLIKELY,  # 'В'
        43: SequenceLikelihood.NEGATIVE,  # 'Г'
        45: SequenceLikelihood.NEGATIVE,  # 'Д'
        56: SequenceLikelihood.NEGATIVE,  # 'Е'
        57: SequenceLikelihood.NEGATIVE,  # 'Ж'
        46: SequenceLikelihood.NEGATIVE,  # 'З'
        63: SequenceLikelihood.NEGATIVE,  # 'Й'
        37: SequenceLikelihood.UNLIKELY,  # 'К'
        44: SequenceLikelihood.UNLIKELY,  # 'Л'
        38: SequenceLikelihood.NEGATIVE,  # 'М'
        42: SequenceLikelihood.UNLIKELY,  # 'Н'
        58: SequenceLikelihood.NEGATIVE,  # 'О'
        32: SequenceLikelihood.NEGATIVE,  # 'П'
        41: SequenceLikelihood.UNLIKELY,  # 'Р'
        31: SequenceLikelihood.NEGATIVE,  # 'С'
        47: SequenceLikelihood.NEGATIVE,  # 'Т'
        39: SequenceLikelihood.NEGATIVE,  # 'У'
        49: SequenceLikelihood.NEGATIVE,  # 'Ф'
        53: SequenceLikelihood.NEGATIVE,  # 'Х'
        55: SequenceLikelihood.NEGATIVE,  # 'Ц'
        54: SequenceLikelihood.NEGATIVE,  # 'Ч'
        52: SequenceLikelihood.NEGATIVE,  # 'Ш'
        61: SequenceLikelihood.NEGATIVE,  # 'Ы'
        64: SequenceLikelihood.NEGATIVE,  # 'Ь'
        51: SequenceLikelihood.NEGATIVE,  # 'Э'
        59: SequenceLikelihood.NEGATIVE,  # 'Ю'
        50: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.UNLIKELY,  # 'а'
        22: SequenceLikelihood.UNLIKELY,  # 'б'
        14: SequenceLikelihood.UNLIKELY,  # 'в'
        21: SequenceLikelihood.UNLIKELY,  # 'г'
        13: SequenceLikelihood.UNLIKELY,  # 'д'
        9: SequenceLikelihood.NEGATIVE,  # 'е'
        29: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        25: SequenceLikelihood.UNLIKELY,  # 'й'
        7: SequenceLikelihood.UNLIKELY,  # 'к'
        8: SequenceLikelihood.UNLIKELY,  # 'л'
        15: SequenceLikelihood.UNLIKELY,  # 'м'
        2: SequenceLikelihood.LIKELY,  # 'н'
        12: SequenceLikelihood.UNLIKELY,  # 'о'
        17: SequenceLikelihood.UNLIKELY,  # 'п'
        4: SequenceLikelihood.LIKELY,  # 'р'
        5: SequenceLikelihood.LIKELY,  # 'с'
        10: SequenceLikelihood.UNLIKELY,  # 'т'
        16: SequenceLikelihood.NEGATIVE,  # 'у'
        34: SequenceLikelihood.UNLIKELY,  # 'ф'
        27: SequenceLikelihood.UNLIKELY,  # 'х'
        20: SequenceLikelihood.NEGATIVE,  # 'ц'
        23: SequenceLikelihood.NEGATIVE,  # 'ч'
        28: SequenceLikelihood.UNLIKELY,  # 'ш'
        6: SequenceLikelihood.NEGATIVE,  # 'ы'
        26: SequenceLikelihood.NEGATIVE,  # 'ь'
        24: SequenceLikelihood.NEGATIVE,  # 'э'
        30: SequenceLikelihood.UNLIKELY,  # 'ю'
        11: SequenceLikelihood.NEGATIVE,  # 'я'
        35: SequenceLikelihood.NEGATIVE,  # 'ё'
        3: SequenceLikelihood.UNLIKELY,  # 'і'
        19: SequenceLikelihood.UNLIKELY,  # 'ў'
    },
    48: {  # 'І'
        65: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ё'
        48: SequenceLikelihood.LIKELY,  # 'І'
        62: SequenceLikelihood.UNLIKELY,  # 'Ў'
        33: SequenceLikelihood.UNLIKELY,  # 'А'
        36: SequenceLikelihood.UNLIKELY,  # 'Б'
        40: SequenceLikelihood.UNLIKELY,  # 'В'
        43: SequenceLikelihood.UNLIKELY,  # 'Г'
        45: SequenceLikelihood.UNLIKELY,  # 'Д'
        56: SequenceLikelihood.UNLIKELY,  # 'Е'
        57: SequenceLikelihood.UNLIKELY,  # 'Ж'
        46: SequenceLikelihood.UNLIKELY,  # 'З'
        63: SequenceLikelihood.UNLIKELY,  # 'Й'
        37: SequenceLikelihood.UNLIKELY,  # 'К'
        44: SequenceLikelihood.UNLIKELY,  # 'Л'
        38: SequenceLikelihood.UNLIKELY,  # 'М'
        42: SequenceLikelihood.UNLIKELY,  # 'Н'
        58: SequenceLikelihood.UNLIKELY,  # 'О'
        32: SequenceLikelihood.UNLIKELY,  # 'П'
        41: SequenceLikelihood.UNLIKELY,  # 'Р'
        31: SequenceLikelihood.UNLIKELY,  # 'С'
        47: SequenceLikelihood.UNLIKELY,  # 'Т'
        39: SequenceLikelihood.UNLIKELY,  # 'У'
        49: SequenceLikelihood.UNLIKELY,  # 'Ф'
        53: SequenceLikelihood.LIKELY,  # 'Х'
        55: SequenceLikelihood.UNLIKELY,  # 'Ц'
        54: SequenceLikelihood.UNLIKELY,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        61: SequenceLikelihood.NEGATIVE,  # 'Ы'
        64: SequenceLikelihood.NEGATIVE,  # 'Ь'
        51: SequenceLikelihood.UNLIKELY,  # 'Э'
        59: SequenceLikelihood.UNLIKELY,  # 'Ю'
        50: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.LIKELY,  # 'а'
        22: SequenceLikelihood.UNLIKELY,  # 'б'
        14: SequenceLikelihood.LIKELY,  # 'в'
        21: SequenceLikelihood.LIKELY,  # 'г'
        13: SequenceLikelihood.LIKELY,  # 'д'
        9: SequenceLikelihood.LIKELY,  # 'е'
        29: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.LIKELY,  # 'з'
        25: SequenceLikelihood.NEGATIVE,  # 'й'
        7: SequenceLikelihood.UNLIKELY,  # 'к'
        8: SequenceLikelihood.LIKELY,  # 'л'
        15: SequenceLikelihood.LIKELY,  # 'м'
        2: SequenceLikelihood.POSITIVE,  # 'н'
        12: SequenceLikelihood.LIKELY,  # 'о'
        17: SequenceLikelihood.UNLIKELY,  # 'п'
        4: SequenceLikelihood.LIKELY,  # 'р'
        5: SequenceLikelihood.LIKELY,  # 'с'
        10: SequenceLikelihood.LIKELY,  # 'т'
        16: SequenceLikelihood.UNLIKELY,  # 'у'
        34: SequenceLikelihood.UNLIKELY,  # 'ф'
        27: SequenceLikelihood.LIKELY,  # 'х'
        20: SequenceLikelihood.UNLIKELY,  # 'ц'
        23: SequenceLikelihood.UNLIKELY,  # 'ч'
        28: SequenceLikelihood.UNLIKELY,  # 'ш'
        6: SequenceLikelihood.NEGATIVE,  # 'ы'
        26: SequenceLikelihood.NEGATIVE,  # 'ь'
        24: SequenceLikelihood.UNLIKELY,  # 'э'
        30: SequenceLikelihood.NEGATIVE,  # 'ю'
        11: SequenceLikelihood.UNLIKELY,  # 'я'
        35: SequenceLikelihood.UNLIKELY,  # 'ё'
        3: SequenceLikelihood.UNLIKELY,  # 'і'
        19: SequenceLikelihood.LIKELY,  # 'ў'
    },
    62: {  # 'Ў'
        65: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ё'
        48: SequenceLikelihood.NEGATIVE,  # 'І'
        62: SequenceLikelihood.NEGATIVE,  # 'Ў'
        33: SequenceLikelihood.NEGATIVE,  # 'А'
        36: SequenceLikelihood.NEGATIVE,  # 'Б'
        40: SequenceLikelihood.NEGATIVE,  # 'В'
        43: SequenceLikelihood.NEGATIVE,  # 'Г'
        45: SequenceLikelihood.UNLIKELY,  # 'Д'
        56: SequenceLikelihood.NEGATIVE,  # 'Е'
        57: SequenceLikelihood.NEGATIVE,  # 'Ж'
        46: SequenceLikelihood.NEGATIVE,  # 'З'
        63: SequenceLikelihood.NEGATIVE,  # 'Й'
        37: SequenceLikelihood.UNLIKELY,  # 'К'
        44: SequenceLikelihood.UNLIKELY,  # 'Л'
        38: SequenceLikelihood.UNLIKELY,  # 'М'
        42: SequenceLikelihood.UNLIKELY,  # 'Н'
        58: SequenceLikelihood.NEGATIVE,  # 'О'
        32: SequenceLikelihood.NEGATIVE,  # 'П'
        41: SequenceLikelihood.UNLIKELY,  # 'Р'
        31: SequenceLikelihood.UNLIKELY,  # 'С'
        47: SequenceLikelihood.UNLIKELY,  # 'Т'
        39: SequenceLikelihood.NEGATIVE,  # 'У'
        49: SequenceLikelihood.NEGATIVE,  # 'Ф'
        53: SequenceLikelihood.NEGATIVE,  # 'Х'
        55: SequenceLikelihood.UNLIKELY,  # 'Ц'
        54: SequenceLikelihood.NEGATIVE,  # 'Ч'
        52: SequenceLikelihood.NEGATIVE,  # 'Ш'
        61: SequenceLikelihood.NEGATIVE,  # 'Ы'
        64: SequenceLikelihood.NEGATIVE,  # 'Ь'
        51: SequenceLikelihood.NEGATIVE,  # 'Э'
        59: SequenceLikelihood.NEGATIVE,  # 'Ю'
        50: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.UNLIKELY,  # 'а'
        22: SequenceLikelihood.NEGATIVE,  # 'б'
        14: SequenceLikelihood.UNLIKELY,  # 'в'
        21: SequenceLikelihood.NEGATIVE,  # 'г'
        13: SequenceLikelihood.NEGATIVE,  # 'д'
        9: SequenceLikelihood.NEGATIVE,  # 'е'
        29: SequenceLikelihood.NEGATIVE,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        25: SequenceLikelihood.NEGATIVE,  # 'й'
        7: SequenceLikelihood.UNLIKELY,  # 'к'
        8: SequenceLikelihood.UNLIKELY,  # 'л'
        15: SequenceLikelihood.NEGATIVE,  # 'м'
        2: SequenceLikelihood.UNLIKELY,  # 'н'
        12: SequenceLikelihood.UNLIKELY,  # 'о'
        17: SequenceLikelihood.UNLIKELY,  # 'п'
        4: SequenceLikelihood.UNLIKELY,  # 'р'
        5: SequenceLikelihood.UNLIKELY,  # 'с'
        10: SequenceLikelihood.UNLIKELY,  # 'т'
        16: SequenceLikelihood.NEGATIVE,  # 'у'
        34: SequenceLikelihood.NEGATIVE,  # 'ф'
        27: SequenceLikelihood.NEGATIVE,  # 'х'
        20: SequenceLikelihood.NEGATIVE,  # 'ц'
        23: SequenceLikelihood.UNLIKELY,  # 'ч'
        28: SequenceLikelihood.NEGATIVE,  # 'ш'
        6: SequenceLikelihood.NEGATIVE,  # 'ы'
        26: SequenceLikelihood.NEGATIVE,  # 'ь'
        24: SequenceLikelihood.UNLIKELY,  # 'э'
        30: SequenceLikelihood.NEGATIVE,  # 'ю'
        11: SequenceLikelihood.UNLIKELY,  # 'я'
        35: SequenceLikelihood.NEGATIVE,  # 'ё'
        3: SequenceLikelihood.UNLIKELY,  # 'і'
        19: SequenceLikelihood.UNLIKELY,  # 'ў'
    },
    33: {  # 'А'
        65: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ё'
        48: SequenceLikelihood.UNLIKELY,  # 'І'
        62: SequenceLikelihood.UNLIKELY,  # 'Ў'
        33: SequenceLikelihood.LIKELY,  # 'А'
        36: SequenceLikelihood.UNLIKELY,  # 'Б'
        40: SequenceLikelihood.UNLIKELY,  # 'В'
        43: SequenceLikelihood.UNLIKELY,  # 'Г'
        45: SequenceLikelihood.LIKELY,  # 'Д'
        56: SequenceLikelihood.UNLIKELY,  # 'Е'
        57: SequenceLikelihood.UNLIKELY,  # 'Ж'
        46: SequenceLikelihood.LIKELY,  # 'З'
        63: SequenceLikelihood.UNLIKELY,  # 'Й'
        37: SequenceLikelihood.UNLIKELY,  # 'К'
        44: SequenceLikelihood.UNLIKELY,  # 'Л'
        38: SequenceLikelihood.LIKELY,  # 'М'
        42: SequenceLikelihood.LIKELY,  # 'Н'
        58: SequenceLikelihood.UNLIKELY,  # 'О'
        32: SequenceLikelihood.LIKELY,  # 'П'
        41: SequenceLikelihood.LIKELY,  # 'Р'
        31: SequenceLikelihood.LIKELY,  # 'С'
        47: SequenceLikelihood.LIKELY,  # 'Т'
        39: SequenceLikelihood.UNLIKELY,  # 'У'
        49: SequenceLikelihood.UNLIKELY,  # 'Ф'
        53: SequenceLikelihood.UNLIKELY,  # 'Х'
        55: SequenceLikelihood.UNLIKELY,  # 'Ц'
        54: SequenceLikelihood.UNLIKELY,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        61: SequenceLikelihood.NEGATIVE,  # 'Ы'
        64: SequenceLikelihood.NEGATIVE,  # 'Ь'
        51: SequenceLikelihood.LIKELY,  # 'Э'
        59: SequenceLikelihood.UNLIKELY,  # 'Ю'
        50: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.UNLIKELY,  # 'а'
        22: SequenceLikelihood.LIKELY,  # 'б'
        14: SequenceLikelihood.LIKELY,  # 'в'
        21: SequenceLikelihood.LIKELY,  # 'г'
        13: SequenceLikelihood.POSITIVE,  # 'д'
        9: SequenceLikelihood.UNLIKELY,  # 'е'
        29: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.LIKELY,  # 'з'
        25: SequenceLikelihood.LIKELY,  # 'й'
        7: SequenceLikelihood.LIKELY,  # 'к'
        8: SequenceLikelihood.POSITIVE,  # 'л'
        15: SequenceLikelihood.LIKELY,  # 'м'
        2: SequenceLikelihood.POSITIVE,  # 'н'
        12: SequenceLikelihood.UNLIKELY,  # 'о'
        17: SequenceLikelihood.LIKELY,  # 'п'
        4: SequenceLikelihood.POSITIVE,  # 'р'
        5: SequenceLikelihood.POSITIVE,  # 'с'
        10: SequenceLikelihood.LIKELY,  # 'т'
        16: SequenceLikelihood.UNLIKELY,  # 'у'
        34: SequenceLikelihood.LIKELY,  # 'ф'
        27: SequenceLikelihood.LIKELY,  # 'х'
        20: SequenceLikelihood.UNLIKELY,  # 'ц'
        23: SequenceLikelihood.UNLIKELY,  # 'ч'
        28: SequenceLikelihood.LIKELY,  # 'ш'
        6: SequenceLikelihood.NEGATIVE,  # 'ы'
        26: SequenceLikelihood.NEGATIVE,  # 'ь'
        24: SequenceLikelihood.UNLIKELY,  # 'э'
        30: SequenceLikelihood.UNLIKELY,  # 'ю'
        11: SequenceLikelihood.UNLIKELY,  # 'я'
        35: SequenceLikelihood.UNLIKELY,  # 'ё'
        3: SequenceLikelihood.UNLIKELY,  # 'і'
        19: SequenceLikelihood.LIKELY,  # 'ў'
    },
    36: {  # 'Б'
        65: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ё'
        48: SequenceLikelihood.UNLIKELY,  # 'І'
        62: SequenceLikelihood.NEGATIVE,  # 'Ў'
        33: SequenceLikelihood.LIKELY,  # 'А'
        36: SequenceLikelihood.UNLIKELY,  # 'Б'
        40: SequenceLikelihood.UNLIKELY,  # 'В'
        43: SequenceLikelihood.UNLIKELY,  # 'Г'
        45: SequenceLikelihood.LIKELY,  # 'Д'
        56: SequenceLikelihood.UNLIKELY,  # 'Е'
        57: SequenceLikelihood.NEGATIVE,  # 'Ж'
        46: SequenceLikelihood.UNLIKELY,  # 'З'
        63: SequenceLikelihood.NEGATIVE,  # 'Й'
        37: SequenceLikelihood.UNLIKELY,  # 'К'
        44: SequenceLikelihood.UNLIKELY,  # 'Л'
        38: SequenceLikelihood.LIKELY,  # 'М'
        42: SequenceLikelihood.LIKELY,  # 'Н'
        58: SequenceLikelihood.UNLIKELY,  # 'О'
        32: SequenceLikelihood.LIKELY,  # 'П'
        41: SequenceLikelihood.UNLIKELY,  # 'Р'
        31: SequenceLikelihood.LIKELY,  # 'С'
        47: SequenceLikelihood.UNLIKELY,  # 'Т'
        39: SequenceLikelihood.UNLIKELY,  # 'У'
        49: SequenceLikelihood.UNLIKELY,  # 'Ф'
        53: SequenceLikelihood.UNLIKELY,  # 'Х'
        55: SequenceLikelihood.UNLIKELY,  # 'Ц'
        54: SequenceLikelihood.UNLIKELY,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        61: SequenceLikelihood.UNLIKELY,  # 'Ы'
        64: SequenceLikelihood.NEGATIVE,  # 'Ь'
        51: SequenceLikelihood.UNLIKELY,  # 'Э'
        59: SequenceLikelihood.UNLIKELY,  # 'Ю'
        50: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        22: SequenceLikelihood.UNLIKELY,  # 'б'
        14: SequenceLikelihood.UNLIKELY,  # 'в'
        21: SequenceLikelihood.UNLIKELY,  # 'г'
        13: SequenceLikelihood.UNLIKELY,  # 'д'
        9: SequenceLikelihood.POSITIVE,  # 'е'
        29: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        25: SequenceLikelihood.NEGATIVE,  # 'й'
        7: SequenceLikelihood.UNLIKELY,  # 'к'
        8: SequenceLikelihood.LIKELY,  # 'л'
        15: SequenceLikelihood.NEGATIVE,  # 'м'
        2: SequenceLikelihood.UNLIKELY,  # 'н'
        12: SequenceLikelihood.LIKELY,  # 'о'
        17: SequenceLikelihood.NEGATIVE,  # 'п'
        4: SequenceLikelihood.POSITIVE,  # 'р'
        5: SequenceLikelihood.NEGATIVE,  # 'с'
        10: SequenceLikelihood.NEGATIVE,  # 'т'
        16: SequenceLikelihood.LIKELY,  # 'у'
        34: SequenceLikelihood.NEGATIVE,  # 'ф'
        27: SequenceLikelihood.UNLIKELY,  # 'х'
        20: SequenceLikelihood.NEGATIVE,  # 'ц'
        23: SequenceLikelihood.UNLIKELY,  # 'ч'
        28: SequenceLikelihood.NEGATIVE,  # 'ш'
        6: SequenceLikelihood.LIKELY,  # 'ы'
        26: SequenceLikelihood.UNLIKELY,  # 'ь'
        24: SequenceLikelihood.LIKELY,  # 'э'
        30: SequenceLikelihood.UNLIKELY,  # 'ю'
        11: SequenceLikelihood.LIKELY,  # 'я'
        35: SequenceLikelihood.UNLIKELY,  # 'ё'
        3: SequenceLikelihood.LIKELY,  # 'і'
        19: SequenceLikelihood.NEGATIVE,  # 'ў'
    },
    40: {  # 'В'
        65: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        60: SequenceLikelihood.UNLIKELY,  # 'Ё'
        48: SequenceLikelihood.UNLIKELY,  # 'І'
        62: SequenceLikelihood.NEGATIVE,  # 'Ў'
        33: SequenceLikelihood.UNLIKELY,  # 'А'
        36: SequenceLikelihood.UNLIKELY,  # 'Б'
        40: SequenceLikelihood.UNLIKELY,  # 'В'
        43: SequenceLikelihood.UNLIKELY,  # 'Г'
        45: SequenceLikelihood.UNLIKELY,  # 'Д'
        56: SequenceLikelihood.UNLIKELY,  # 'Е'
        57: SequenceLikelihood.UNLIKELY,  # 'Ж'
        46: SequenceLikelihood.UNLIKELY,  # 'З'
        63: SequenceLikelihood.NEGATIVE,  # 'Й'
        37: SequenceLikelihood.LIKELY,  # 'К'
        44: SequenceLikelihood.UNLIKELY,  # 'Л'
        38: SequenceLikelihood.UNLIKELY,  # 'М'
        42: SequenceLikelihood.UNLIKELY,  # 'Н'
        58: SequenceLikelihood.UNLIKELY,  # 'О'
        32: SequenceLikelihood.UNLIKELY,  # 'П'
        41: SequenceLikelihood.UNLIKELY,  # 'Р'
        31: SequenceLikelihood.UNLIKELY,  # 'С'
        47: SequenceLikelihood.UNLIKELY,  # 'Т'
        39: SequenceLikelihood.LIKELY,  # 'У'
        49: SequenceLikelihood.UNLIKELY,  # 'Ф'
        53: SequenceLikelihood.UNLIKELY,  # 'Х'
        55: SequenceLikelihood.UNLIKELY,  # 'Ц'
        54: SequenceLikelihood.UNLIKELY,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        61: SequenceLikelihood.UNLIKELY,  # 'Ы'
        64: SequenceLikelihood.NEGATIVE,  # 'Ь'
        51: SequenceLikelihood.UNLIKELY,  # 'Э'
        59: SequenceLikelihood.NEGATIVE,  # 'Ю'
        50: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        22: SequenceLikelihood.NEGATIVE,  # 'б'
        14: SequenceLikelihood.UNLIKELY,  # 'в'
        21: SequenceLikelihood.NEGATIVE,  # 'г'
        13: SequenceLikelihood.UNLIKELY,  # 'д'
        9: SequenceLikelihood.POSITIVE,  # 'е'
        29: SequenceLikelihood.NEGATIVE,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        25: SequenceLikelihood.NEGATIVE,  # 'й'
        7: SequenceLikelihood.UNLIKELY,  # 'к'
        8: SequenceLikelihood.UNLIKELY,  # 'л'
        15: SequenceLikelihood.UNLIKELY,  # 'м'
        2: SequenceLikelihood.UNLIKELY,  # 'н'
        12: SequenceLikelihood.LIKELY,  # 'о'
        17: SequenceLikelihood.UNLIKELY,  # 'п'
        4: SequenceLikelihood.UNLIKELY,  # 'р'
        5: SequenceLikelihood.UNLIKELY,  # 'с'
        10: SequenceLikelihood.UNLIKELY,  # 'т'
        16: SequenceLikelihood.LIKELY,  # 'у'
        34: SequenceLikelihood.NEGATIVE,  # 'ф'
        27: SequenceLikelihood.NEGATIVE,  # 'х'
        20: SequenceLikelihood.NEGATIVE,  # 'ц'
        23: SequenceLikelihood.UNLIKELY,  # 'ч'
        28: SequenceLikelihood.NEGATIVE,  # 'ш'
        6: SequenceLikelihood.POSITIVE,  # 'ы'
        26: SequenceLikelihood.UNLIKELY,  # 'ь'
        24: SequenceLikelihood.LIKELY,  # 'э'
        30: SequenceLikelihood.UNLIKELY,  # 'ю'
        11: SequenceLikelihood.POSITIVE,  # 'я'
        35: SequenceLikelihood.UNLIKELY,  # 'ё'
        3: SequenceLikelihood.POSITIVE,  # 'і'
        19: SequenceLikelihood.NEGATIVE,  # 'ў'
    },
    43: {  # 'Г'
        65: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ё'
        48: SequenceLikelihood.UNLIKELY,  # 'І'
        62: SequenceLikelihood.NEGATIVE,  # 'Ў'
        33: SequenceLikelihood.UNLIKELY,  # 'А'
        36: SequenceLikelihood.UNLIKELY,  # 'Б'
        40: SequenceLikelihood.UNLIKELY,  # 'В'
        43: SequenceLikelihood.UNLIKELY,  # 'Г'
        45: SequenceLikelihood.UNLIKELY,  # 'Д'
        56: SequenceLikelihood.UNLIKELY,  # 'Е'
        57: SequenceLikelihood.NEGATIVE,  # 'Ж'
        46: SequenceLikelihood.UNLIKELY,  # 'З'
        63: SequenceLikelihood.NEGATIVE,  # 'Й'
        37: SequenceLikelihood.UNLIKELY,  # 'К'
        44: SequenceLikelihood.UNLIKELY,  # 'Л'
        38: SequenceLikelihood.UNLIKELY,  # 'М'
        42: SequenceLikelihood.UNLIKELY,  # 'Н'
        58: SequenceLikelihood.UNLIKELY,  # 'О'
        32: SequenceLikelihood.UNLIKELY,  # 'П'
        41: SequenceLikelihood.UNLIKELY,  # 'Р'
        31: SequenceLikelihood.UNLIKELY,  # 'С'
        47: SequenceLikelihood.UNLIKELY,  # 'Т'
        39: SequenceLikelihood.UNLIKELY,  # 'У'
        49: SequenceLikelihood.UNLIKELY,  # 'Ф'
        53: SequenceLikelihood.NEGATIVE,  # 'Х'
        55: SequenceLikelihood.UNLIKELY,  # 'Ц'
        54: SequenceLikelihood.UNLIKELY,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        61: SequenceLikelihood.NEGATIVE,  # 'Ы'
        64: SequenceLikelihood.NEGATIVE,  # 'Ь'
        51: SequenceLikelihood.UNLIKELY,  # 'Э'
        59: SequenceLikelihood.NEGATIVE,  # 'Ю'
        50: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        22: SequenceLikelihood.UNLIKELY,  # 'б'
        14: SequenceLikelihood.LIKELY,  # 'в'
        21: SequenceLikelihood.NEGATIVE,  # 'г'
        13: SequenceLikelihood.UNLIKELY,  # 'д'
        9: SequenceLikelihood.POSITIVE,  # 'е'
        29: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        25: SequenceLikelihood.NEGATIVE,  # 'й'
        7: SequenceLikelihood.NEGATIVE,  # 'к'
        8: SequenceLikelihood.LIKELY,  # 'л'
        15: SequenceLikelihood.UNLIKELY,  # 'м'
        2: SequenceLikelihood.UNLIKELY,  # 'н'
        12: SequenceLikelihood.POSITIVE,  # 'о'
        17: SequenceLikelihood.NEGATIVE,  # 'п'
        4: SequenceLikelihood.POSITIVE,  # 'р'
        5: SequenceLikelihood.NEGATIVE,  # 'с'
        10: SequenceLikelihood.NEGATIVE,  # 'т'
        16: SequenceLikelihood.LIKELY,  # 'у'
        34: SequenceLikelihood.NEGATIVE,  # 'ф'
        27: SequenceLikelihood.UNLIKELY,  # 'х'
        20: SequenceLikelihood.UNLIKELY,  # 'ц'
        23: SequenceLikelihood.NEGATIVE,  # 'ч'
        28: SequenceLikelihood.NEGATIVE,  # 'ш'
        6: SequenceLikelihood.UNLIKELY,  # 'ы'
        26: SequenceLikelihood.NEGATIVE,  # 'ь'
        24: SequenceLikelihood.LIKELY,  # 'э'
        30: SequenceLikelihood.UNLIKELY,  # 'ю'
        11: SequenceLikelihood.UNLIKELY,  # 'я'
        35: SequenceLikelihood.UNLIKELY,  # 'ё'
        3: SequenceLikelihood.POSITIVE,  # 'і'
        19: SequenceLikelihood.NEGATIVE,  # 'ў'
    },
    45: {  # 'Д'
        65: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ё'
        48: SequenceLikelihood.UNLIKELY,  # 'І'
        62: SequenceLikelihood.NEGATIVE,  # 'Ў'
        33: SequenceLikelihood.LIKELY,  # 'А'
        36: SequenceLikelihood.UNLIKELY,  # 'Б'
        40: SequenceLikelihood.UNLIKELY,  # 'В'
        43: SequenceLikelihood.UNLIKELY,  # 'Г'
        45: SequenceLikelihood.UNLIKELY,  # 'Д'
        56: SequenceLikelihood.UNLIKELY,  # 'Е'
        57: SequenceLikelihood.UNLIKELY,  # 'Ж'
        46: SequenceLikelihood.UNLIKELY,  # 'З'
        63: SequenceLikelihood.NEGATIVE,  # 'Й'
        37: SequenceLikelihood.UNLIKELY,  # 'К'
        44: SequenceLikelihood.UNLIKELY,  # 'Л'
        38: SequenceLikelihood.UNLIKELY,  # 'М'
        42: SequenceLikelihood.LIKELY,  # 'Н'
        58: SequenceLikelihood.UNLIKELY,  # 'О'
        32: SequenceLikelihood.UNLIKELY,  # 'П'
        41: SequenceLikelihood.LIKELY,  # 'Р'
        31: SequenceLikelihood.UNLIKELY,  # 'С'
        47: SequenceLikelihood.UNLIKELY,  # 'Т'
        39: SequenceLikelihood.LIKELY,  # 'У'
        49: SequenceLikelihood.UNLIKELY,  # 'Ф'
        53: SequenceLikelihood.UNLIKELY,  # 'Х'
        55: SequenceLikelihood.UNLIKELY,  # 'Ц'
        54: SequenceLikelihood.UNLIKELY,  # 'Ч'
        52: SequenceLikelihood.NEGATIVE,  # 'Ш'
        61: SequenceLikelihood.UNLIKELY,  # 'Ы'
        64: SequenceLikelihood.UNLIKELY,  # 'Ь'
        51: SequenceLikelihood.UNLIKELY,  # 'Э'
        59: SequenceLikelihood.UNLIKELY,  # 'Ю'
        50: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        22: SequenceLikelihood.UNLIKELY,  # 'б'
        14: SequenceLikelihood.LIKELY,  # 'в'
        21: SequenceLikelihood.NEGATIVE,  # 'г'
        13: SequenceLikelihood.UNLIKELY,  # 'д'
        9: SequenceLikelihood.UNLIKELY,  # 'е'
        29: SequenceLikelihood.LIKELY,  # 'ж'
        18: SequenceLikelihood.POSITIVE,  # 'з'
        25: SequenceLikelihood.NEGATIVE,  # 'й'
        7: SequenceLikelihood.NEGATIVE,  # 'к'
        8: SequenceLikelihood.LIKELY,  # 'л'
        15: SequenceLikelihood.UNLIKELY,  # 'м'
        2: SequenceLikelihood.LIKELY,  # 'н'
        12: SequenceLikelihood.LIKELY,  # 'о'
        17: SequenceLikelihood.NEGATIVE,  # 'п'
        4: SequenceLikelihood.LIKELY,  # 'р'
        5: SequenceLikelihood.NEGATIVE,  # 'с'
        10: SequenceLikelihood.NEGATIVE,  # 'т'
        16: SequenceLikelihood.LIKELY,  # 'у'
        34: SequenceLikelihood.NEGATIVE,  # 'ф'
        27: SequenceLikelihood.UNLIKELY,  # 'х'
        20: SequenceLikelihood.NEGATIVE,  # 'ц'
        23: SequenceLikelihood.NEGATIVE,  # 'ч'
        28: SequenceLikelihood.NEGATIVE,  # 'ш'
        6: SequenceLikelihood.LIKELY,  # 'ы'
        26: SequenceLikelihood.UNLIKELY,  # 'ь'
        24: SequenceLikelihood.LIKELY,  # 'э'
        30: SequenceLikelihood.UNLIKELY,  # 'ю'
        11: SequenceLikelihood.UNLIKELY,  # 'я'
        35: SequenceLikelihood.UNLIKELY,  # 'ё'
        3: SequenceLikelihood.UNLIKELY,  # 'і'
        19: SequenceLikelihood.NEGATIVE,  # 'ў'
    },
    56: {  # 'Е'
        65: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ё'
        48: SequenceLikelihood.UNLIKELY,  # 'І'
        62: SequenceLikelihood.UNLIKELY,  # 'Ў'
        33: SequenceLikelihood.UNLIKELY,  # 'А'
        36: SequenceLikelihood.UNLIKELY,  # 'Б'
        40: SequenceLikelihood.UNLIKELY,  # 'В'
        43: SequenceLikelihood.UNLIKELY,  # 'Г'
        45: SequenceLikelihood.UNLIKELY,  # 'Д'
        56: SequenceLikelihood.UNLIKELY,  # 'Е'
        57: SequenceLikelihood.UNLIKELY,  # 'Ж'
        46: SequenceLikelihood.UNLIKELY,  # 'З'
        63: SequenceLikelihood.UNLIKELY,  # 'Й'
        37: SequenceLikelihood.UNLIKELY,  # 'К'
        44: SequenceLikelihood.UNLIKELY,  # 'Л'
        38: SequenceLikelihood.UNLIKELY,  # 'М'
        42: SequenceLikelihood.UNLIKELY,  # 'Н'
        58: SequenceLikelihood.UNLIKELY,  # 'О'
        32: SequenceLikelihood.UNLIKELY,  # 'П'
        41: SequenceLikelihood.UNLIKELY,  # 'Р'
        31: SequenceLikelihood.LIKELY,  # 'С'
        47: SequenceLikelihood.UNLIKELY,  # 'Т'
        39: SequenceLikelihood.NEGATIVE,  # 'У'
        49: SequenceLikelihood.UNLIKELY,  # 'Ф'
        53: SequenceLikelihood.UNLIKELY,  # 'Х'
        55: SequenceLikelihood.UNLIKELY,  # 'Ц'
        54: SequenceLikelihood.UNLIKELY,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        61: SequenceLikelihood.NEGATIVE,  # 'Ы'
        64: SequenceLikelihood.NEGATIVE,  # 'Ь'
        51: SequenceLikelihood.UNLIKELY,  # 'Э'
        59: SequenceLikelihood.NEGATIVE,  # 'Ю'
        50: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.NEGATIVE,  # 'а'
        22: SequenceLikelihood.NEGATIVE,  # 'б'
        14: SequenceLikelihood.LIKELY,  # 'в'
        21: SequenceLikelihood.LIKELY,  # 'г'
        13: SequenceLikelihood.UNLIKELY,  # 'д'
        9: SequenceLikelihood.UNLIKELY,  # 'е'
        29: SequenceLikelihood.LIKELY,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        25: SequenceLikelihood.UNLIKELY,  # 'й'
        7: SequenceLikelihood.UNLIKELY,  # 'к'
        8: SequenceLikelihood.LIKELY,  # 'л'
        15: SequenceLikelihood.UNLIKELY,  # 'м'
        2: SequenceLikelihood.UNLIKELY,  # 'н'
        12: SequenceLikelihood.NEGATIVE,  # 'о'
        17: SequenceLikelihood.UNLIKELY,  # 'п'
        4: SequenceLikelihood.LIKELY,  # 'р'
        5: SequenceLikelihood.UNLIKELY,  # 'с'
        10: SequenceLikelihood.UNLIKELY,  # 'т'
        16: SequenceLikelihood.UNLIKELY,  # 'у'
        34: SequenceLikelihood.LIKELY,  # 'ф'
        27: SequenceLikelihood.UNLIKELY,  # 'х'
        20: SequenceLikelihood.UNLIKELY,  # 'ц'
        23: SequenceLikelihood.NEGATIVE,  # 'ч'
        28: SequenceLikelihood.UNLIKELY,  # 'ш'
        6: SequenceLikelihood.NEGATIVE,  # 'ы'
        26: SequenceLikelihood.NEGATIVE,  # 'ь'
        24: SequenceLikelihood.NEGATIVE,  # 'э'
        30: SequenceLikelihood.NEGATIVE,  # 'ю'
        11: SequenceLikelihood.NEGATIVE,  # 'я'
        35: SequenceLikelihood.NEGATIVE,  # 'ё'
        3: SequenceLikelihood.NEGATIVE,  # 'і'
        19: SequenceLikelihood.POSITIVE,  # 'ў'
    },
    57: {  # 'Ж'
        65: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ё'
        48: SequenceLikelihood.NEGATIVE,  # 'І'
        62: SequenceLikelihood.NEGATIVE,  # 'Ў'
        33: SequenceLikelihood.UNLIKELY,  # 'А'
        36: SequenceLikelihood.UNLIKELY,  # 'Б'
        40: SequenceLikelihood.NEGATIVE,  # 'В'
        43: SequenceLikelihood.NEGATIVE,  # 'Г'
        45: SequenceLikelihood.UNLIKELY,  # 'Д'
        56: SequenceLikelihood.UNLIKELY,  # 'Е'
        57: SequenceLikelihood.UNLIKELY,  # 'Ж'
        46: SequenceLikelihood.UNLIKELY,  # 'З'
        63: SequenceLikelihood.NEGATIVE,  # 'Й'
        37: SequenceLikelihood.UNLIKELY,  # 'К'
        44: SequenceLikelihood.UNLIKELY,  # 'Л'
        38: SequenceLikelihood.NEGATIVE,  # 'М'
        42: SequenceLikelihood.UNLIKELY,  # 'Н'
        58: SequenceLikelihood.NEGATIVE,  # 'О'
        32: SequenceLikelihood.NEGATIVE,  # 'П'
        41: SequenceLikelihood.UNLIKELY,  # 'Р'
        31: SequenceLikelihood.NEGATIVE,  # 'С'
        47: SequenceLikelihood.UNLIKELY,  # 'Т'
        39: SequenceLikelihood.NEGATIVE,  # 'У'
        49: SequenceLikelihood.NEGATIVE,  # 'Ф'
        53: SequenceLikelihood.NEGATIVE,  # 'Х'
        55: SequenceLikelihood.NEGATIVE,  # 'Ц'
        54: SequenceLikelihood.UNLIKELY,  # 'Ч'
        52: SequenceLikelihood.NEGATIVE,  # 'Ш'
        61: SequenceLikelihood.UNLIKELY,  # 'Ы'
        64: SequenceLikelihood.NEGATIVE,  # 'Ь'
        51: SequenceLikelihood.NEGATIVE,  # 'Э'
        59: SequenceLikelihood.NEGATIVE,  # 'Ю'
        50: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.LIKELY,  # 'а'
        22: SequenceLikelihood.UNLIKELY,  # 'б'
        14: SequenceLikelihood.UNLIKELY,  # 'в'
        21: SequenceLikelihood.UNLIKELY,  # 'г'
        13: SequenceLikelihood.UNLIKELY,  # 'д'
        9: SequenceLikelihood.UNLIKELY,  # 'е'
        29: SequenceLikelihood.NEGATIVE,  # 'ж'
        18: SequenceLikelihood.NEGATIVE,  # 'з'
        25: SequenceLikelihood.NEGATIVE,  # 'й'
        7: SequenceLikelihood.NEGATIVE,  # 'к'
        8: SequenceLikelihood.UNLIKELY,  # 'л'
        15: SequenceLikelihood.UNLIKELY,  # 'м'
        2: SequenceLikelihood.UNLIKELY,  # 'н'
        12: SequenceLikelihood.LIKELY,  # 'о'
        17: SequenceLikelihood.NEGATIVE,  # 'п'
        4: SequenceLikelihood.UNLIKELY,  # 'р'
        5: SequenceLikelihood.NEGATIVE,  # 'с'
        10: SequenceLikelihood.NEGATIVE,  # 'т'
        16: SequenceLikelihood.LIKELY,  # 'у'
        34: SequenceLikelihood.NEGATIVE,  # 'ф'
        27: SequenceLikelihood.NEGATIVE,  # 'х'
        20: SequenceLikelihood.NEGATIVE,  # 'ц'
        23: SequenceLikelihood.NEGATIVE,  # 'ч'
        28: SequenceLikelihood.NEGATIVE,  # 'ш'
        6: SequenceLikelihood.LIKELY,  # 'ы'
        26: SequenceLikelihood.NEGATIVE,  # 'ь'
        24: SequenceLikelihood.LIKELY,  # 'э'
        30: SequenceLikelihood.UNLIKELY,  # 'ю'
        11: SequenceLikelihood.UNLIKELY,  # 'я'
        35: SequenceLikelihood.UNLIKELY,  # 'ё'
        3: SequenceLikelihood.UNLIKELY,  # 'і'
        19: SequenceLikelihood.NEGATIVE,  # 'ў'
    },
    46: {  # 'З'
        65: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        60: SequenceLikelihood.UNLIKELY,  # 'Ё'
        48: SequenceLikelihood.UNLIKELY,  # 'І'
        62: SequenceLikelihood.NEGATIVE,  # 'Ў'
        33: SequenceLikelihood.UNLIKELY,  # 'А'
        36: SequenceLikelihood.UNLIKELY,  # 'Б'
        40: SequenceLikelihood.UNLIKELY,  # 'В'
        43: SequenceLikelihood.NEGATIVE,  # 'Г'
        45: SequenceLikelihood.UNLIKELY,  # 'Д'
        56: SequenceLikelihood.UNLIKELY,  # 'Е'
        57: SequenceLikelihood.NEGATIVE,  # 'Ж'
        46: SequenceLikelihood.NEGATIVE,  # 'З'
        63: SequenceLikelihood.NEGATIVE,  # 'Й'
        37: SequenceLikelihood.UNLIKELY,  # 'К'
        44: SequenceLikelihood.UNLIKELY,  # 'Л'
        38: SequenceLikelihood.UNLIKELY,  # 'М'
        42: SequenceLikelihood.UNLIKELY,  # 'Н'
        58: SequenceLikelihood.UNLIKELY,  # 'О'
        32: SequenceLikelihood.UNLIKELY,  # 'П'
        41: SequenceLikelihood.UNLIKELY,  # 'Р'
        31: SequenceLikelihood.UNLIKELY,  # 'С'
        47: SequenceLikelihood.UNLIKELY,  # 'Т'
        39: SequenceLikelihood.UNLIKELY,  # 'У'
        49: SequenceLikelihood.NEGATIVE,  # 'Ф'
        53: SequenceLikelihood.UNLIKELY,  # 'Х'
        55: SequenceLikelihood.NEGATIVE,  # 'Ц'
        54: SequenceLikelihood.NEGATIVE,  # 'Ч'
        52: SequenceLikelihood.LIKELY,  # 'Ш'
        61: SequenceLikelihood.NEGATIVE,  # 'Ы'
        64: SequenceLikelihood.NEGATIVE,  # 'Ь'
        51: SequenceLikelihood.UNLIKELY,  # 'Э'
        59: SequenceLikelihood.UNLIKELY,  # 'Ю'
        50: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        22: SequenceLikelihood.LIKELY,  # 'б'
        14: SequenceLikelihood.LIKELY,  # 'в'
        21: SequenceLikelihood.LIKELY,  # 'г'
        13: SequenceLikelihood.LIKELY,  # 'д'
        9: SequenceLikelihood.LIKELY,  # 'е'
        29: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        25: SequenceLikelihood.NEGATIVE,  # 'й'
        7: SequenceLikelihood.UNLIKELY,  # 'к'
        8: SequenceLikelihood.LIKELY,  # 'л'
        15: SequenceLikelihood.LIKELY,  # 'м'
        2: SequenceLikelihood.POSITIVE,  # 'н'
        12: SequenceLikelihood.LIKELY,  # 'о'
        17: SequenceLikelihood.NEGATIVE,  # 'п'
        4: SequenceLikelihood.UNLIKELY,  # 'р'
        5: SequenceLikelihood.UNLIKELY,  # 'с'
        10: SequenceLikelihood.NEGATIVE,  # 'т'
        16: SequenceLikelihood.LIKELY,  # 'у'
        34: SequenceLikelihood.NEGATIVE,  # 'ф'
        27: SequenceLikelihood.UNLIKELY,  # 'х'
        20: SequenceLikelihood.NEGATIVE,  # 'ц'
        23: SequenceLikelihood.NEGATIVE,  # 'ч'
        28: SequenceLikelihood.NEGATIVE,  # 'ш'
        6: SequenceLikelihood.UNLIKELY,  # 'ы'
        26: SequenceLikelihood.UNLIKELY,  # 'ь'
        24: SequenceLikelihood.UNLIKELY,  # 'э'
        30: SequenceLikelihood.UNLIKELY,  # 'ю'
        11: SequenceLikelihood.LIKELY,  # 'я'
        35: SequenceLikelihood.UNLIKELY,  # 'ё'
        3: SequenceLikelihood.LIKELY,  # 'і'
        19: SequenceLikelihood.NEGATIVE,  # 'ў'
    },
    63: {  # 'Й'
        65: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ё'
        48: SequenceLikelihood.NEGATIVE,  # 'І'
        62: SequenceLikelihood.NEGATIVE,  # 'Ў'
        33: SequenceLikelihood.NEGATIVE,  # 'А'
        36: SequenceLikelihood.UNLIKELY,  # 'Б'
        40: SequenceLikelihood.NEGATIVE,  # 'В'
        43: SequenceLikelihood.NEGATIVE,  # 'Г'
        45: SequenceLikelihood.NEGATIVE,  # 'Д'
        56: SequenceLikelihood.NEGATIVE,  # 'Е'
        57: SequenceLikelihood.NEGATIVE,  # 'Ж'
        46: SequenceLikelihood.NEGATIVE,  # 'З'
        63: SequenceLikelihood.NEGATIVE,  # 'Й'
        37: SequenceLikelihood.UNLIKELY,  # 'К'
        44: SequenceLikelihood.NEGATIVE,  # 'Л'
        38: SequenceLikelihood.NEGATIVE,  # 'М'
        42: SequenceLikelihood.UNLIKELY,  # 'Н'
        58: SequenceLikelihood.UNLIKELY,  # 'О'
        32: SequenceLikelihood.UNLIKELY,  # 'П'
        41: SequenceLikelihood.UNLIKELY,  # 'Р'
        31: SequenceLikelihood.UNLIKELY,  # 'С'
        47: SequenceLikelihood.UNLIKELY,  # 'Т'
        39: SequenceLikelihood.NEGATIVE,  # 'У'
        49: SequenceLikelihood.NEGATIVE,  # 'Ф'
        53: SequenceLikelihood.NEGATIVE,  # 'Х'
        55: SequenceLikelihood.UNLIKELY,  # 'Ц'
        54: SequenceLikelihood.UNLIKELY,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        61: SequenceLikelihood.NEGATIVE,  # 'Ы'
        64: SequenceLikelihood.NEGATIVE,  # 'Ь'
        51: SequenceLikelihood.NEGATIVE,  # 'Э'
        59: SequenceLikelihood.NEGATIVE,  # 'Ю'
        50: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.UNLIKELY,  # 'а'
        22: SequenceLikelihood.NEGATIVE,  # 'б'
        14: SequenceLikelihood.NEGATIVE,  # 'в'
        21: SequenceLikelihood.NEGATIVE,  # 'г'
        13: SequenceLikelihood.NEGATIVE,  # 'д'
        9: SequenceLikelihood.UNLIKELY,  # 'е'
        29: SequenceLikelihood.NEGATIVE,  # 'ж'
        18: SequenceLikelihood.NEGATIVE,  # 'з'
        25: SequenceLikelihood.NEGATIVE,  # 'й'
        7: SequenceLikelihood.NEGATIVE,  # 'к'
        8: SequenceLikelihood.NEGATIVE,  # 'л'
        15: SequenceLikelihood.NEGATIVE,  # 'м'
        2: SequenceLikelihood.NEGATIVE,  # 'н'
        12: SequenceLikelihood.UNLIKELY,  # 'о'
        17: SequenceLikelihood.NEGATIVE,  # 'п'
        4: SequenceLikelihood.NEGATIVE,  # 'р'
        5: SequenceLikelihood.NEGATIVE,  # 'с'
        10: SequenceLikelihood.NEGATIVE,  # 'т'
        16: SequenceLikelihood.UNLIKELY,  # 'у'
        34: SequenceLikelihood.NEGATIVE,  # 'ф'
        27: SequenceLikelihood.NEGATIVE,  # 'х'
        20: SequenceLikelihood.NEGATIVE,  # 'ц'
        23: SequenceLikelihood.NEGATIVE,  # 'ч'
        28: SequenceLikelihood.NEGATIVE,  # 'ш'
        6: SequenceLikelihood.UNLIKELY,  # 'ы'
        26: SequenceLikelihood.NEGATIVE,  # 'ь'
        24: SequenceLikelihood.NEGATIVE,  # 'э'
        30: SequenceLikelihood.NEGATIVE,  # 'ю'
        11: SequenceLikelihood.NEGATIVE,  # 'я'
        35: SequenceLikelihood.NEGATIVE,  # 'ё'
        3: SequenceLikelihood.UNLIKELY,  # 'і'
        19: SequenceLikelihood.NEGATIVE,  # 'ў'
    },
    37: {  # 'К'
        65: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        60: SequenceLikelihood.UNLIKELY,  # 'Ё'
        48: SequenceLikelihood.UNLIKELY,  # 'І'
        62: SequenceLikelihood.NEGATIVE,  # 'Ў'
        33: SequenceLikelihood.LIKELY,  # 'А'
        36: SequenceLikelihood.UNLIKELY,  # 'Б'
        40: SequenceLikelihood.UNLIKELY,  # 'В'
        43: SequenceLikelihood.UNLIKELY,  # 'Г'
        45: SequenceLikelihood.UNLIKELY,  # 'Д'
        56: SequenceLikelihood.UNLIKELY,  # 'Е'
        57: SequenceLikelihood.NEGATIVE,  # 'Ж'
        46: SequenceLikelihood.UNLIKELY,  # 'З'
        63: SequenceLikelihood.NEGATIVE,  # 'Й'
        37: SequenceLikelihood.UNLIKELY,  # 'К'
        44: SequenceLikelihood.LIKELY,  # 'Л'
        38: SequenceLikelihood.UNLIKELY,  # 'М'
        42: SequenceLikelihood.UNLIKELY,  # 'Н'
        58: SequenceLikelihood.UNLIKELY,  # 'О'
        32: SequenceLikelihood.LIKELY,  # 'П'
        41: SequenceLikelihood.UNLIKELY,  # 'Р'
        31: SequenceLikelihood.UNLIKELY,  # 'С'
        47: SequenceLikelihood.UNLIKELY,  # 'Т'
        39: SequenceLikelihood.UNLIKELY,  # 'У'
        49: SequenceLikelihood.UNLIKELY,  # 'Ф'
        53: SequenceLikelihood.UNLIKELY,  # 'Х'
        55: SequenceLikelihood.UNLIKELY,  # 'Ц'
        54: SequenceLikelihood.UNLIKELY,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        61: SequenceLikelihood.NEGATIVE,  # 'Ы'
        64: SequenceLikelihood.NEGATIVE,  # 'Ь'
        51: SequenceLikelihood.UNLIKELY,  # 'Э'
        59: SequenceLikelihood.UNLIKELY,  # 'Ю'
        50: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        22: SequenceLikelihood.UNLIKELY,  # 'б'
        14: SequenceLikelihood.LIKELY,  # 'в'
        21: SequenceLikelihood.UNLIKELY,  # 'г'
        13: SequenceLikelihood.UNLIKELY,  # 'д'
        9: SequenceLikelihood.LIKELY,  # 'е'
        29: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        25: SequenceLikelihood.NEGATIVE,  # 'й'
        7: SequenceLikelihood.NEGATIVE,  # 'к'
        8: SequenceLikelihood.LIKELY,  # 'л'
        15: SequenceLikelihood.UNLIKELY,  # 'м'
        2: SequenceLikelihood.LIKELY,  # 'н'
        12: SequenceLikelihood.POSITIVE,  # 'о'
        17: SequenceLikelihood.NEGATIVE,  # 'п'
        4: SequenceLikelihood.POSITIVE,  # 'р'
        5: SequenceLikelihood.UNLIKELY,  # 'с'
        10: SequenceLikelihood.UNLIKELY,  # 'т'
        16: SequenceLikelihood.POSITIVE,  # 'у'
        34: SequenceLikelihood.UNLIKELY,  # 'ф'
        27: SequenceLikelihood.UNLIKELY,  # 'х'
        20: SequenceLikelihood.UNLIKELY,  # 'ц'
        23: SequenceLikelihood.NEGATIVE,  # 'ч'
        28: SequenceLikelihood.UNLIKELY,  # 'ш'
        6: SequenceLikelihood.UNLIKELY,  # 'ы'
        26: SequenceLikelihood.UNLIKELY,  # 'ь'
        24: SequenceLikelihood.UNLIKELY,  # 'э'
        30: SequenceLikelihood.UNLIKELY,  # 'ю'
        11: SequenceLikelihood.UNLIKELY,  # 'я'
        35: SequenceLikelihood.LIKELY,  # 'ё'
        3: SequenceLikelihood.POSITIVE,  # 'і'
        19: SequenceLikelihood.NEGATIVE,  # 'ў'
    },
    44: {  # 'Л'
        65: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        60: SequenceLikelihood.UNLIKELY,  # 'Ё'
        48: SequenceLikelihood.UNLIKELY,  # 'І'
        62: SequenceLikelihood.NEGATIVE,  # 'Ў'
        33: SequenceLikelihood.UNLIKELY,  # 'А'
        36: SequenceLikelihood.UNLIKELY,  # 'Б'
        40: SequenceLikelihood.UNLIKELY,  # 'В'
        43: SequenceLikelihood.UNLIKELY,  # 'Г'
        45: SequenceLikelihood.UNLIKELY,  # 'Д'
        56: SequenceLikelihood.UNLIKELY,  # 'Е'
        57: SequenceLikelihood.UNLIKELY,  # 'Ж'
        46: SequenceLikelihood.NEGATIVE,  # 'З'
        63: SequenceLikelihood.NEGATIVE,  # 'Й'
        37: SequenceLikelihood.UNLIKELY,  # 'К'
        44: SequenceLikelihood.UNLIKELY,  # 'Л'
        38: SequenceLikelihood.UNLIKELY,  # 'М'
        42: SequenceLikelihood.UNLIKELY,  # 'Н'
        58: SequenceLikelihood.UNLIKELY,  # 'О'
        32: SequenceLikelihood.UNLIKELY,  # 'П'
        41: SequenceLikelihood.UNLIKELY,  # 'Р'
        31: SequenceLikelihood.UNLIKELY,  # 'С'
        47: SequenceLikelihood.UNLIKELY,  # 'Т'
        39: SequenceLikelihood.UNLIKELY,  # 'У'
        49: SequenceLikelihood.UNLIKELY,  # 'Ф'
        53: SequenceLikelihood.UNLIKELY,  # 'Х'
        55: SequenceLikelihood.UNLIKELY,  # 'Ц'
        54: SequenceLikelihood.NEGATIVE,  # 'Ч'
        52: SequenceLikelihood.NEGATIVE,  # 'Ш'
        61: SequenceLikelihood.UNLIKELY,  # 'Ы'
        64: SequenceLikelihood.UNLIKELY,  # 'Ь'
        51: SequenceLikelihood.UNLIKELY,  # 'Э'
        59: SequenceLikelihood.UNLIKELY,  # 'Ю'
        50: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        22: SequenceLikelihood.NEGATIVE,  # 'б'
        14: SequenceLikelihood.UNLIKELY,  # 'в'
        21: SequenceLikelihood.UNLIKELY,  # 'г'
        13: SequenceLikelihood.NEGATIVE,  # 'д'
        9: SequenceLikelihood.POSITIVE,  # 'е'
        29: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.NEGATIVE,  # 'з'
        25: SequenceLikelihood.NEGATIVE,  # 'й'
        7: SequenceLikelihood.UNLIKELY,  # 'к'
        8: SequenceLikelihood.UNLIKELY,  # 'л'
        15: SequenceLikelihood.NEGATIVE,  # 'м'
        2: SequenceLikelihood.UNLIKELY,  # 'н'
        12: SequenceLikelihood.LIKELY,  # 'о'
        17: SequenceLikelihood.UNLIKELY,  # 'п'
        4: SequenceLikelihood.NEGATIVE,  # 'р'
        5: SequenceLikelihood.NEGATIVE,  # 'с'
        10: SequenceLikelihood.UNLIKELY,  # 'т'
        16: SequenceLikelihood.LIKELY,  # 'у'
        34: SequenceLikelihood.NEGATIVE,  # 'ф'
        27: SequenceLikelihood.UNLIKELY,  # 'х'
        20: SequenceLikelihood.UNLIKELY,  # 'ц'
        23: SequenceLikelihood.NEGATIVE,  # 'ч'
        28: SequenceLikelihood.NEGATIVE,  # 'ш'
        6: SequenceLikelihood.LIKELY,  # 'ы'
        26: SequenceLikelihood.LIKELY,  # 'ь'
        24: SequenceLikelihood.UNLIKELY,  # 'э'
        30: SequenceLikelihood.LIKELY,  # 'ю'
        11: SequenceLikelihood.LIKELY,  # 'я'
        35: SequenceLikelihood.LIKELY,  # 'ё'
        3: SequenceLikelihood.POSITIVE,  # 'і'
        19: SequenceLikelihood.NEGATIVE,  # 'ў'
    },
    38: {  # 'М'
        65: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ё'
        48: SequenceLikelihood.LIKELY,  # 'І'
        62: SequenceLikelihood.NEGATIVE,  # 'Ў'
        33: SequenceLikelihood.LIKELY,  # 'А'
        36: SequenceLikelihood.UNLIKELY,  # 'Б'
        40: SequenceLikelihood.UNLIKELY,  # 'В'
        43: SequenceLikelihood.UNLIKELY,  # 'Г'
        45: SequenceLikelihood.UNLIKELY,  # 'Д'
        56: SequenceLikelihood.UNLIKELY,  # 'Е'
        57: SequenceLikelihood.NEGATIVE,  # 'Ж'
        46: SequenceLikelihood.UNLIKELY,  # 'З'
        63: SequenceLikelihood.NEGATIVE,  # 'Й'
        37: SequenceLikelihood.UNLIKELY,  # 'К'
        44: SequenceLikelihood.UNLIKELY,  # 'Л'
        38: SequenceLikelihood.UNLIKELY,  # 'М'
        42: SequenceLikelihood.UNLIKELY,  # 'Н'
        58: SequenceLikelihood.UNLIKELY,  # 'О'
        32: SequenceLikelihood.UNLIKELY,  # 'П'
        41: SequenceLikelihood.UNLIKELY,  # 'Р'
        31: SequenceLikelihood.UNLIKELY,  # 'С'
        47: SequenceLikelihood.UNLIKELY,  # 'Т'
        39: SequenceLikelihood.UNLIKELY,  # 'У'
        49: SequenceLikelihood.UNLIKELY,  # 'Ф'
        53: SequenceLikelihood.UNLIKELY,  # 'Х'
        55: SequenceLikelihood.UNLIKELY,  # 'Ц'
        54: SequenceLikelihood.UNLIKELY,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        61: SequenceLikelihood.UNLIKELY,  # 'Ы'
        64: SequenceLikelihood.UNLIKELY,  # 'Ь'
        51: SequenceLikelihood.UNLIKELY,  # 'Э'
        59: SequenceLikelihood.NEGATIVE,  # 'Ю'
        50: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        22: SequenceLikelihood.UNLIKELY,  # 'б'
        14: SequenceLikelihood.UNLIKELY,  # 'в'
        21: SequenceLikelihood.UNLIKELY,  # 'г'
        13: SequenceLikelihood.UNLIKELY,  # 'д'
        9: SequenceLikelihood.POSITIVE,  # 'е'
        29: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.NEGATIVE,  # 'з'
        25: SequenceLikelihood.NEGATIVE,  # 'й'
        7: SequenceLikelihood.UNLIKELY,  # 'к'
        8: SequenceLikelihood.UNLIKELY,  # 'л'
        15: SequenceLikelihood.NEGATIVE,  # 'м'
        2: SequenceLikelihood.POSITIVE,  # 'н'
        12: SequenceLikelihood.LIKELY,  # 'о'
        17: SequenceLikelihood.UNLIKELY,  # 'п'
        4: SequenceLikelihood.UNLIKELY,  # 'р'
        5: SequenceLikelihood.LIKELY,  # 'с'
        10: SequenceLikelihood.UNLIKELY,  # 'т'
        16: SequenceLikelihood.LIKELY,  # 'у'
        34: SequenceLikelihood.UNLIKELY,  # 'ф'
        27: SequenceLikelihood.NEGATIVE,  # 'х'
        20: SequenceLikelihood.UNLIKELY,  # 'ц'
        23: SequenceLikelihood.UNLIKELY,  # 'ч'
        28: SequenceLikelihood.UNLIKELY,  # 'ш'
        6: SequenceLikelihood.LIKELY,  # 'ы'
        26: SequenceLikelihood.UNLIKELY,  # 'ь'
        24: SequenceLikelihood.LIKELY,  # 'э'
        30: SequenceLikelihood.LIKELY,  # 'ю'
        11: SequenceLikelihood.LIKELY,  # 'я'
        35: SequenceLikelihood.UNLIKELY,  # 'ё'
        3: SequenceLikelihood.POSITIVE,  # 'і'
        19: SequenceLikelihood.NEGATIVE,  # 'ў'
    },
    42: {  # 'Н'
        65: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ё'
        48: SequenceLikelihood.UNLIKELY,  # 'І'
        62: SequenceLikelihood.NEGATIVE,  # 'Ў'
        33: SequenceLikelihood.LIKELY,  # 'А'
        36: SequenceLikelihood.UNLIKELY,  # 'Б'
        40: SequenceLikelihood.UNLIKELY,  # 'В'
        43: SequenceLikelihood.UNLIKELY,  # 'Г'
        45: SequenceLikelihood.LIKELY,  # 'Д'
        56: SequenceLikelihood.UNLIKELY,  # 'Е'
        57: SequenceLikelihood.NEGATIVE,  # 'Ж'
        46: SequenceLikelihood.UNLIKELY,  # 'З'
        63: SequenceLikelihood.NEGATIVE,  # 'Й'
        37: SequenceLikelihood.LIKELY,  # 'К'
        44: SequenceLikelihood.UNLIKELY,  # 'Л'
        38: SequenceLikelihood.UNLIKELY,  # 'М'
        42: SequenceLikelihood.UNLIKELY,  # 'Н'
        58: SequenceLikelihood.UNLIKELY,  # 'О'
        32: SequenceLikelihood.UNLIKELY,  # 'П'
        41: SequenceLikelihood.LIKELY,  # 'Р'
        31: SequenceLikelihood.UNLIKELY,  # 'С'
        47: SequenceLikelihood.UNLIKELY,  # 'Т'
        39: SequenceLikelihood.UNLIKELY,  # 'У'
        49: SequenceLikelihood.LIKELY,  # 'Ф'
        53: SequenceLikelihood.UNLIKELY,  # 'Х'
        55: SequenceLikelihood.UNLIKELY,  # 'Ц'
        54: SequenceLikelihood.UNLIKELY,  # 'Ч'
        52: SequenceLikelihood.NEGATIVE,  # 'Ш'
        61: SequenceLikelihood.UNLIKELY,  # 'Ы'
        64: SequenceLikelihood.NEGATIVE,  # 'Ь'
        51: SequenceLikelihood.UNLIKELY,  # 'Э'
        59: SequenceLikelihood.UNLIKELY,  # 'Ю'
        50: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        22: SequenceLikelihood.UNLIKELY,  # 'б'
        14: SequenceLikelihood.NEGATIVE,  # 'в'
        21: SequenceLikelihood.UNLIKELY,  # 'г'
        13: SequenceLikelihood.UNLIKELY,  # 'д'
        9: SequenceLikelihood.POSITIVE,  # 'е'
        29: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        25: SequenceLikelihood.NEGATIVE,  # 'й'
        7: SequenceLikelihood.UNLIKELY,  # 'к'
        8: SequenceLikelihood.NEGATIVE,  # 'л'
        15: SequenceLikelihood.NEGATIVE,  # 'м'
        2: SequenceLikelihood.NEGATIVE,  # 'н'
        12: SequenceLikelihood.POSITIVE,  # 'о'
        17: SequenceLikelihood.UNLIKELY,  # 'п'
        4: SequenceLikelihood.NEGATIVE,  # 'р'
        5: SequenceLikelihood.UNLIKELY,  # 'с'
        10: SequenceLikelihood.UNLIKELY,  # 'т'
        16: SequenceLikelihood.LIKELY,  # 'у'
        34: SequenceLikelihood.NEGATIVE,  # 'ф'
        27: SequenceLikelihood.UNLIKELY,  # 'х'
        20: SequenceLikelihood.NEGATIVE,  # 'ц'
        23: SequenceLikelihood.UNLIKELY,  # 'ч'
        28: SequenceLikelihood.NEGATIVE,  # 'ш'
        6: SequenceLikelihood.UNLIKELY,  # 'ы'
        26: SequenceLikelihood.LIKELY,  # 'ь'
        24: SequenceLikelihood.UNLIKELY,  # 'э'
        30: SequenceLikelihood.UNLIKELY,  # 'ю'
        11: SequenceLikelihood.LIKELY,  # 'я'
        35: SequenceLikelihood.LIKELY,  # 'ё'
        3: SequenceLikelihood.LIKELY,  # 'і'
        19: SequenceLikelihood.NEGATIVE,  # 'ў'
    },
    58: {  # 'О'
        65: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ё'
        48: SequenceLikelihood.UNLIKELY,  # 'І'
        62: SequenceLikelihood.UNLIKELY,  # 'Ў'
        33: SequenceLikelihood.UNLIKELY,  # 'А'
        36: SequenceLikelihood.UNLIKELY,  # 'Б'
        40: SequenceLikelihood.UNLIKELY,  # 'В'
        43: SequenceLikelihood.UNLIKELY,  # 'Г'
        45: SequenceLikelihood.UNLIKELY,  # 'Д'
        56: SequenceLikelihood.UNLIKELY,  # 'Е'
        57: SequenceLikelihood.UNLIKELY,  # 'Ж'
        46: SequenceLikelihood.UNLIKELY,  # 'З'
        63: SequenceLikelihood.UNLIKELY,  # 'Й'
        37: SequenceLikelihood.UNLIKELY,  # 'К'
        44: SequenceLikelihood.UNLIKELY,  # 'Л'
        38: SequenceLikelihood.UNLIKELY,  # 'М'
        42: SequenceLikelihood.UNLIKELY,  # 'Н'
        58: SequenceLikelihood.LIKELY,  # 'О'
        32: SequenceLikelihood.UNLIKELY,  # 'П'
        41: SequenceLikelihood.UNLIKELY,  # 'Р'
        31: SequenceLikelihood.UNLIKELY,  # 'С'
        47: SequenceLikelihood.UNLIKELY,  # 'Т'
        39: SequenceLikelihood.UNLIKELY,  # 'У'
        49: SequenceLikelihood.UNLIKELY,  # 'Ф'
        53: SequenceLikelihood.UNLIKELY,  # 'Х'
        55: SequenceLikelihood.NEGATIVE,  # 'Ц'
        54: SequenceLikelihood.UNLIKELY,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        61: SequenceLikelihood.NEGATIVE,  # 'Ы'
        64: SequenceLikelihood.NEGATIVE,  # 'Ь'
        51: SequenceLikelihood.UNLIKELY,  # 'Э'
        59: SequenceLikelihood.NEGATIVE,  # 'Ю'
        50: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.UNLIKELY,  # 'а'
        22: SequenceLikelihood.LIKELY,  # 'б'
        14: SequenceLikelihood.UNLIKELY,  # 'в'
        21: SequenceLikelihood.UNLIKELY,  # 'г'
        13: SequenceLikelihood.UNLIKELY,  # 'д'
        9: SequenceLikelihood.NEGATIVE,  # 'е'
        29: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        25: SequenceLikelihood.UNLIKELY,  # 'й'
        7: SequenceLikelihood.UNLIKELY,  # 'к'
        8: SequenceLikelihood.LIKELY,  # 'л'
        15: SequenceLikelihood.UNLIKELY,  # 'м'
        2: SequenceLikelihood.UNLIKELY,  # 'н'
        12: SequenceLikelihood.NEGATIVE,  # 'о'
        17: SequenceLikelihood.UNLIKELY,  # 'п'
        4: SequenceLikelihood.LIKELY,  # 'р'
        5: SequenceLikelihood.LIKELY,  # 'с'
        10: SequenceLikelihood.LIKELY,  # 'т'
        16: SequenceLikelihood.UNLIKELY,  # 'у'
        34: SequenceLikelihood.UNLIKELY,  # 'ф'
        27: SequenceLikelihood.UNLIKELY,  # 'х'
        20: SequenceLikelihood.UNLIKELY,  # 'ц'
        23: SequenceLikelihood.UNLIKELY,  # 'ч'
        28: SequenceLikelihood.UNLIKELY,  # 'ш'
        6: SequenceLikelihood.NEGATIVE,  # 'ы'
        26: SequenceLikelihood.NEGATIVE,  # 'ь'
        24: SequenceLikelihood.UNLIKELY,  # 'э'
        30: SequenceLikelihood.NEGATIVE,  # 'ю'
        11: SequenceLikelihood.UNLIKELY,  # 'я'
        35: SequenceLikelihood.UNLIKELY,  # 'ё'
        3: SequenceLikelihood.UNLIKELY,  # 'і'
        19: SequenceLikelihood.UNLIKELY,  # 'ў'
    },
    32: {  # 'П'
        65: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ё'
        48: SequenceLikelihood.UNLIKELY,  # 'І'
        62: SequenceLikelihood.NEGATIVE,  # 'Ў'
        33: SequenceLikelihood.LIKELY,  # 'А'
        36: SequenceLikelihood.UNLIKELY,  # 'Б'
        40: SequenceLikelihood.UNLIKELY,  # 'В'
        43: SequenceLikelihood.UNLIKELY,  # 'Г'
        45: SequenceLikelihood.UNLIKELY,  # 'Д'
        56: SequenceLikelihood.UNLIKELY,  # 'Е'
        57: SequenceLikelihood.NEGATIVE,  # 'Ж'
        46: SequenceLikelihood.UNLIKELY,  # 'З'
        63: SequenceLikelihood.NEGATIVE,  # 'Й'
        37: SequenceLikelihood.UNLIKELY,  # 'К'
        44: SequenceLikelihood.UNLIKELY,  # 'Л'
        38: SequenceLikelihood.UNLIKELY,  # 'М'
        42: SequenceLikelihood.UNLIKELY,  # 'Н'
        58: SequenceLikelihood.UNLIKELY,  # 'О'
        32: SequenceLikelihood.UNLIKELY,  # 'П'
        41: SequenceLikelihood.UNLIKELY,  # 'Р'
        31: SequenceLikelihood.LIKELY,  # 'С'
        47: SequenceLikelihood.UNLIKELY,  # 'Т'
        39: SequenceLikelihood.UNLIKELY,  # 'У'
        49: SequenceLikelihood.UNLIKELY,  # 'Ф'
        53: SequenceLikelihood.UNLIKELY,  # 'Х'
        55: SequenceLikelihood.UNLIKELY,  # 'Ц'
        54: SequenceLikelihood.UNLIKELY,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        61: SequenceLikelihood.UNLIKELY,  # 'Ы'
        64: SequenceLikelihood.NEGATIVE,  # 'Ь'
        51: SequenceLikelihood.UNLIKELY,  # 'Э'
        59: SequenceLikelihood.NEGATIVE,  # 'Ю'
        50: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        22: SequenceLikelihood.LIKELY,  # 'б'
        14: SequenceLikelihood.NEGATIVE,  # 'в'
        21: SequenceLikelihood.UNLIKELY,  # 'г'
        13: SequenceLikelihood.UNLIKELY,  # 'д'
        9: SequenceLikelihood.POSITIVE,  # 'е'
        29: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.NEGATIVE,  # 'з'
        25: SequenceLikelihood.UNLIKELY,  # 'й'
        7: SequenceLikelihood.NEGATIVE,  # 'к'
        8: SequenceLikelihood.LIKELY,  # 'л'
        15: SequenceLikelihood.NEGATIVE,  # 'м'
        2: SequenceLikelihood.UNLIKELY,  # 'н'
        12: SequenceLikelihood.POSITIVE,  # 'о'
        17: SequenceLikelihood.NEGATIVE,  # 'п'
        4: SequenceLikelihood.POSITIVE,  # 'р'
        5: SequenceLikelihood.LIKELY,  # 'с'
        10: SequenceLikelihood.UNLIKELY,  # 'т'
        16: SequenceLikelihood.LIKELY,  # 'у'
        34: SequenceLikelihood.UNLIKELY,  # 'ф'
        27: SequenceLikelihood.UNLIKELY,  # 'х'
        20: SequenceLikelihood.UNLIKELY,  # 'ц'
        23: SequenceLikelihood.UNLIKELY,  # 'ч'
        28: SequenceLikelihood.UNLIKELY,  # 'ш'
        6: SequenceLikelihood.UNLIKELY,  # 'ы'
        26: SequenceLikelihood.UNLIKELY,  # 'ь'
        24: SequenceLikelihood.UNLIKELY,  # 'э'
        30: SequenceLikelihood.UNLIKELY,  # 'ю'
        11: SequenceLikelihood.LIKELY,  # 'я'
        35: SequenceLikelihood.LIKELY,  # 'ё'
        3: SequenceLikelihood.LIKELY,  # 'і'
        19: SequenceLikelihood.NEGATIVE,  # 'ў'
    },
    41: {  # 'Р'
        65: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ё'
        48: SequenceLikelihood.UNLIKELY,  # 'І'
        62: SequenceLikelihood.NEGATIVE,  # 'Ў'
        33: SequenceLikelihood.UNLIKELY,  # 'А'
        36: SequenceLikelihood.LIKELY,  # 'Б'
        40: SequenceLikelihood.UNLIKELY,  # 'В'
        43: SequenceLikelihood.UNLIKELY,  # 'Г'
        45: SequenceLikelihood.UNLIKELY,  # 'Д'
        56: SequenceLikelihood.UNLIKELY,  # 'Е'
        57: SequenceLikelihood.UNLIKELY,  # 'Ж'
        46: SequenceLikelihood.UNLIKELY,  # 'З'
        63: SequenceLikelihood.NEGATIVE,  # 'Й'
        37: SequenceLikelihood.LIKELY,  # 'К'
        44: SequenceLikelihood.UNLIKELY,  # 'Л'
        38: SequenceLikelihood.UNLIKELY,  # 'М'
        42: SequenceLikelihood.LIKELY,  # 'Н'
        58: SequenceLikelihood.UNLIKELY,  # 'О'
        32: SequenceLikelihood.LIKELY,  # 'П'
        41: SequenceLikelihood.UNLIKELY,  # 'Р'
        31: SequenceLikelihood.LIKELY,  # 'С'
        47: SequenceLikelihood.UNLIKELY,  # 'Т'
        39: SequenceLikelihood.UNLIKELY,  # 'У'
        49: SequenceLikelihood.UNLIKELY,  # 'Ф'
        53: SequenceLikelihood.UNLIKELY,  # 'Х'
        55: SequenceLikelihood.UNLIKELY,  # 'Ц'
        54: SequenceLikelihood.UNLIKELY,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        61: SequenceLikelihood.UNLIKELY,  # 'Ы'
        64: SequenceLikelihood.UNLIKELY,  # 'Ь'
        51: SequenceLikelihood.UNLIKELY,  # 'Э'
        59: SequenceLikelihood.UNLIKELY,  # 'Ю'
        50: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        22: SequenceLikelihood.UNLIKELY,  # 'б'
        14: SequenceLikelihood.UNLIKELY,  # 'в'
        21: SequenceLikelihood.NEGATIVE,  # 'г'
        13: SequenceLikelihood.UNLIKELY,  # 'д'
        9: SequenceLikelihood.LIKELY,  # 'е'
        29: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.NEGATIVE,  # 'з'
        25: SequenceLikelihood.NEGATIVE,  # 'й'
        7: SequenceLikelihood.NEGATIVE,  # 'к'
        8: SequenceLikelihood.NEGATIVE,  # 'л'
        15: SequenceLikelihood.NEGATIVE,  # 'м'
        2: SequenceLikelihood.NEGATIVE,  # 'н'
        12: SequenceLikelihood.LIKELY,  # 'о'
        17: SequenceLikelihood.NEGATIVE,  # 'п'
        4: SequenceLikelihood.UNLIKELY,  # 'р'
        5: SequenceLikelihood.UNLIKELY,  # 'с'
        10: SequenceLikelihood.UNLIKELY,  # 'т'
        16: SequenceLikelihood.POSITIVE,  # 'у'
        34: SequenceLikelihood.NEGATIVE,  # 'ф'
        27: SequenceLikelihood.NEGATIVE,  # 'х'
        20: SequenceLikelihood.UNLIKELY,  # 'ц'
        23: SequenceLikelihood.NEGATIVE,  # 'ч'
        28: SequenceLikelihood.UNLIKELY,  # 'ш'
        6: SequenceLikelihood.POSITIVE,  # 'ы'
        26: SequenceLikelihood.NEGATIVE,  # 'ь'
        24: SequenceLikelihood.POSITIVE,  # 'э'
        30: SequenceLikelihood.UNLIKELY,  # 'ю'
        11: SequenceLikelihood.UNLIKELY,  # 'я'
        35: SequenceLikelihood.UNLIKELY,  # 'ё'
        3: SequenceLikelihood.UNLIKELY,  # 'і'
        19: SequenceLikelihood.NEGATIVE,  # 'ў'
    },
    31: {  # 'С'
        65: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        60: SequenceLikelihood.UNLIKELY,  # 'Ё'
        48: SequenceLikelihood.UNLIKELY,  # 'І'
        62: SequenceLikelihood.NEGATIVE,  # 'Ў'
        33: SequenceLikelihood.UNLIKELY,  # 'А'
        36: SequenceLikelihood.UNLIKELY,  # 'Б'
        40: SequenceLikelihood.UNLIKELY,  # 'В'
        43: SequenceLikelihood.LIKELY,  # 'Г'
        45: SequenceLikelihood.LIKELY,  # 'Д'
        56: SequenceLikelihood.UNLIKELY,  # 'Е'
        57: SequenceLikelihood.UNLIKELY,  # 'Ж'
        46: SequenceLikelihood.UNLIKELY,  # 'З'
        63: SequenceLikelihood.NEGATIVE,  # 'Й'
        37: SequenceLikelihood.LIKELY,  # 'К'
        44: SequenceLikelihood.UNLIKELY,  # 'Л'
        38: SequenceLikelihood.LIKELY,  # 'М'
        42: SequenceLikelihood.LIKELY,  # 'Н'
        58: SequenceLikelihood.UNLIKELY,  # 'О'
        32: SequenceLikelihood.LIKELY,  # 'П'
        41: SequenceLikelihood.POSITIVE,  # 'Р'
        31: SequenceLikelihood.POSITIVE,  # 'С'
        47: SequenceLikelihood.UNLIKELY,  # 'Т'
        39: SequenceLikelihood.UNLIKELY,  # 'У'
        49: SequenceLikelihood.LIKELY,  # 'Ф'
        53: SequenceLikelihood.UNLIKELY,  # 'Х'
        55: SequenceLikelihood.UNLIKELY,  # 'Ц'
        54: SequenceLikelihood.UNLIKELY,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        61: SequenceLikelihood.UNLIKELY,  # 'Ы'
        64: SequenceLikelihood.UNLIKELY,  # 'Ь'
        51: SequenceLikelihood.UNLIKELY,  # 'Э'
        59: SequenceLikelihood.NEGATIVE,  # 'Ю'
        50: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        22: SequenceLikelihood.UNLIKELY,  # 'б'
        14: SequenceLikelihood.POSITIVE,  # 'в'
        21: SequenceLikelihood.UNLIKELY,  # 'г'
        13: SequenceLikelihood.UNLIKELY,  # 'д'
        9: SequenceLikelihood.POSITIVE,  # 'е'
        29: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.NEGATIVE,  # 'з'
        25: SequenceLikelihood.NEGATIVE,  # 'й'
        7: SequenceLikelihood.LIKELY,  # 'к'
        8: SequenceLikelihood.POSITIVE,  # 'л'
        15: SequenceLikelihood.LIKELY,  # 'м'
        2: SequenceLikelihood.LIKELY,  # 'н'
        12: SequenceLikelihood.LIKELY,  # 'о'
        17: SequenceLikelihood.POSITIVE,  # 'п'
        4: SequenceLikelihood.UNLIKELY,  # 'р'
        5: SequenceLikelihood.UNLIKELY,  # 'с'
        10: SequenceLikelihood.POSITIVE,  # 'т'
        16: SequenceLikelihood.POSITIVE,  # 'у'
        34: SequenceLikelihood.LIKELY,  # 'ф'
        27: SequenceLikelihood.UNLIKELY,  # 'х'
        20: SequenceLikelihood.LIKELY,  # 'ц'
        23: SequenceLikelihood.UNLIKELY,  # 'ч'
        28: SequenceLikelihood.UNLIKELY,  # 'ш'
        6: SequenceLikelihood.LIKELY,  # 'ы'
        26: SequenceLikelihood.UNLIKELY,  # 'ь'
        24: SequenceLikelihood.LIKELY,  # 'э'
        30: SequenceLikelihood.UNLIKELY,  # 'ю'
        11: SequenceLikelihood.POSITIVE,  # 'я'
        35: SequenceLikelihood.LIKELY,  # 'ё'
        3: SequenceLikelihood.POSITIVE,  # 'і'
        19: SequenceLikelihood.UNLIKELY,  # 'ў'
    },
    47: {  # 'Т'
        65: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ё'
        48: SequenceLikelihood.UNLIKELY,  # 'І'
        62: SequenceLikelihood.NEGATIVE,  # 'Ў'
        33: SequenceLikelihood.LIKELY,  # 'А'
        36: SequenceLikelihood.LIKELY,  # 'Б'
        40: SequenceLikelihood.UNLIKELY,  # 'В'
        43: SequenceLikelihood.UNLIKELY,  # 'Г'
        45: SequenceLikelihood.UNLIKELY,  # 'Д'
        56: SequenceLikelihood.UNLIKELY,  # 'Е'
        57: SequenceLikelihood.NEGATIVE,  # 'Ж'
        46: SequenceLikelihood.UNLIKELY,  # 'З'
        63: SequenceLikelihood.NEGATIVE,  # 'Й'
        37: SequenceLikelihood.UNLIKELY,  # 'К'
        44: SequenceLikelihood.UNLIKELY,  # 'Л'
        38: SequenceLikelihood.UNLIKELY,  # 'М'
        42: SequenceLikelihood.UNLIKELY,  # 'Н'
        58: SequenceLikelihood.UNLIKELY,  # 'О'
        32: SequenceLikelihood.UNLIKELY,  # 'П'
        41: SequenceLikelihood.UNLIKELY,  # 'Р'
        31: SequenceLikelihood.UNLIKELY,  # 'С'
        47: SequenceLikelihood.UNLIKELY,  # 'Т'
        39: SequenceLikelihood.UNLIKELY,  # 'У'
        49: SequenceLikelihood.UNLIKELY,  # 'Ф'
        53: SequenceLikelihood.UNLIKELY,  # 'Х'
        55: SequenceLikelihood.UNLIKELY,  # 'Ц'
        54: SequenceLikelihood.UNLIKELY,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        61: SequenceLikelihood.UNLIKELY,  # 'Ы'
        64: SequenceLikelihood.UNLIKELY,  # 'Ь'
        51: SequenceLikelihood.UNLIKELY,  # 'Э'
        59: SequenceLikelihood.UNLIKELY,  # 'Ю'
        50: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        22: SequenceLikelihood.UNLIKELY,  # 'б'
        14: SequenceLikelihood.LIKELY,  # 'в'
        21: SequenceLikelihood.UNLIKELY,  # 'г'
        13: SequenceLikelihood.NEGATIVE,  # 'д'
        9: SequenceLikelihood.UNLIKELY,  # 'е'
        29: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.NEGATIVE,  # 'з'
        25: SequenceLikelihood.NEGATIVE,  # 'й'
        7: SequenceLikelihood.UNLIKELY,  # 'к'
        8: SequenceLikelihood.UNLIKELY,  # 'л'
        15: SequenceLikelihood.UNLIKELY,  # 'м'
        2: SequenceLikelihood.NEGATIVE,  # 'н'
        12: SequenceLikelihood.LIKELY,  # 'о'
        17: SequenceLikelihood.UNLIKELY,  # 'п'
        4: SequenceLikelihood.POSITIVE,  # 'р'
        5: SequenceLikelihood.UNLIKELY,  # 'с'
        10: SequenceLikelihood.UNLIKELY,  # 'т'
        16: SequenceLikelihood.LIKELY,  # 'у'
        34: SequenceLikelihood.UNLIKELY,  # 'ф'
        27: SequenceLikelihood.UNLIKELY,  # 'х'
        20: SequenceLikelihood.UNLIKELY,  # 'ц'
        23: SequenceLikelihood.UNLIKELY,  # 'ч'
        28: SequenceLikelihood.UNLIKELY,  # 'ш'
        6: SequenceLikelihood.LIKELY,  # 'ы'
        26: SequenceLikelihood.NEGATIVE,  # 'ь'
        24: SequenceLikelihood.LIKELY,  # 'э'
        30: SequenceLikelihood.UNLIKELY,  # 'ю'
        11: SequenceLikelihood.UNLIKELY,  # 'я'
        35: SequenceLikelihood.UNLIKELY,  # 'ё'
        3: SequenceLikelihood.UNLIKELY,  # 'і'
        19: SequenceLikelihood.NEGATIVE,  # 'ў'
    },
    39: {  # 'У'
        65: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ё'
        48: SequenceLikelihood.UNLIKELY,  # 'І'
        62: SequenceLikelihood.NEGATIVE,  # 'Ў'
        33: SequenceLikelihood.UNLIKELY,  # 'А'
        36: SequenceLikelihood.UNLIKELY,  # 'Б'
        40: SequenceLikelihood.UNLIKELY,  # 'В'
        43: SequenceLikelihood.UNLIKELY,  # 'Г'
        45: SequenceLikelihood.UNLIKELY,  # 'Д'
        56: SequenceLikelihood.UNLIKELY,  # 'Е'
        57: SequenceLikelihood.UNLIKELY,  # 'Ж'
        46: SequenceLikelihood.UNLIKELY,  # 'З'
        63: SequenceLikelihood.UNLIKELY,  # 'Й'
        37: SequenceLikelihood.UNLIKELY,  # 'К'
        44: SequenceLikelihood.UNLIKELY,  # 'Л'
        38: SequenceLikelihood.UNLIKELY,  # 'М'
        42: SequenceLikelihood.UNLIKELY,  # 'Н'
        58: SequenceLikelihood.UNLIKELY,  # 'О'
        32: SequenceLikelihood.LIKELY,  # 'П'
        41: SequenceLikelihood.UNLIKELY,  # 'Р'
        31: SequenceLikelihood.LIKELY,  # 'С'
        47: SequenceLikelihood.UNLIKELY,  # 'Т'
        39: SequenceLikelihood.UNLIKELY,  # 'У'
        49: SequenceLikelihood.UNLIKELY,  # 'Ф'
        53: SequenceLikelihood.UNLIKELY,  # 'Х'
        55: SequenceLikelihood.UNLIKELY,  # 'Ц'
        54: SequenceLikelihood.UNLIKELY,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        61: SequenceLikelihood.NEGATIVE,  # 'Ы'
        64: SequenceLikelihood.NEGATIVE,  # 'Ь'
        51: SequenceLikelihood.UNLIKELY,  # 'Э'
        59: SequenceLikelihood.NEGATIVE,  # 'Ю'
        50: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.UNLIKELY,  # 'а'
        22: SequenceLikelihood.UNLIKELY,  # 'б'
        14: SequenceLikelihood.LIKELY,  # 'в'
        21: SequenceLikelihood.LIKELY,  # 'г'
        13: SequenceLikelihood.LIKELY,  # 'д'
        9: SequenceLikelihood.UNLIKELY,  # 'е'
        29: SequenceLikelihood.LIKELY,  # 'ж'
        18: SequenceLikelihood.LIKELY,  # 'з'
        25: SequenceLikelihood.UNLIKELY,  # 'й'
        7: SequenceLikelihood.LIKELY,  # 'к'
        8: SequenceLikelihood.LIKELY,  # 'л'
        15: SequenceLikelihood.LIKELY,  # 'м'
        2: SequenceLikelihood.LIKELY,  # 'н'
        12: SequenceLikelihood.LIKELY,  # 'о'
        17: SequenceLikelihood.LIKELY,  # 'п'
        4: SequenceLikelihood.LIKELY,  # 'р'
        5: SequenceLikelihood.POSITIVE,  # 'с'
        10: SequenceLikelihood.LIKELY,  # 'т'
        16: SequenceLikelihood.UNLIKELY,  # 'у'
        34: SequenceLikelihood.UNLIKELY,  # 'ф'
        27: SequenceLikelihood.UNLIKELY,  # 'х'
        20: SequenceLikelihood.UNLIKELY,  # 'ц'
        23: SequenceLikelihood.UNLIKELY,  # 'ч'
        28: SequenceLikelihood.LIKELY,  # 'ш'
        6: SequenceLikelihood.NEGATIVE,  # 'ы'
        26: SequenceLikelihood.NEGATIVE,  # 'ь'
        24: SequenceLikelihood.LIKELY,  # 'э'
        30: SequenceLikelihood.UNLIKELY,  # 'ю'
        11: SequenceLikelihood.UNLIKELY,  # 'я'
        35: SequenceLikelihood.NEGATIVE,  # 'ё'
        3: SequenceLikelihood.LIKELY,  # 'і'
        19: SequenceLikelihood.UNLIKELY,  # 'ў'
    },
    49: {  # 'Ф'
        65: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ё'
        48: SequenceLikelihood.UNLIKELY,  # 'І'
        62: SequenceLikelihood.NEGATIVE,  # 'Ў'
        33: SequenceLikelihood.LIKELY,  # 'А'
        36: SequenceLikelihood.UNLIKELY,  # 'Б'
        40: SequenceLikelihood.UNLIKELY,  # 'В'
        43: SequenceLikelihood.UNLIKELY,  # 'Г'
        45: SequenceLikelihood.UNLIKELY,  # 'Д'
        56: SequenceLikelihood.UNLIKELY,  # 'Е'
        57: SequenceLikelihood.NEGATIVE,  # 'Ж'
        46: SequenceLikelihood.UNLIKELY,  # 'З'
        63: SequenceLikelihood.NEGATIVE,  # 'Й'
        37: SequenceLikelihood.LIKELY,  # 'К'
        44: SequenceLikelihood.UNLIKELY,  # 'Л'
        38: SequenceLikelihood.UNLIKELY,  # 'М'
        42: SequenceLikelihood.UNLIKELY,  # 'Н'
        58: SequenceLikelihood.UNLIKELY,  # 'О'
        32: SequenceLikelihood.UNLIKELY,  # 'П'
        41: SequenceLikelihood.UNLIKELY,  # 'Р'
        31: SequenceLikelihood.LIKELY,  # 'С'
        47: SequenceLikelihood.UNLIKELY,  # 'Т'
        39: SequenceLikelihood.UNLIKELY,  # 'У'
        49: SequenceLikelihood.UNLIKELY,  # 'Ф'
        53: SequenceLikelihood.UNLIKELY,  # 'Х'
        55: SequenceLikelihood.UNLIKELY,  # 'Ц'
        54: SequenceLikelihood.NEGATIVE,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        61: SequenceLikelihood.NEGATIVE,  # 'Ы'
        64: SequenceLikelihood.NEGATIVE,  # 'Ь'
        51: SequenceLikelihood.UNLIKELY,  # 'Э'
        59: SequenceLikelihood.NEGATIVE,  # 'Ю'
        50: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.LIKELY,  # 'а'
        22: SequenceLikelihood.NEGATIVE,  # 'б'
        14: SequenceLikelihood.NEGATIVE,  # 'в'
        21: SequenceLikelihood.NEGATIVE,  # 'г'
        13: SequenceLikelihood.NEGATIVE,  # 'д'
        9: SequenceLikelihood.LIKELY,  # 'е'
        29: SequenceLikelihood.NEGATIVE,  # 'ж'
        18: SequenceLikelihood.NEGATIVE,  # 'з'
        25: SequenceLikelihood.NEGATIVE,  # 'й'
        7: SequenceLikelihood.NEGATIVE,  # 'к'
        8: SequenceLikelihood.LIKELY,  # 'л'
        15: SequenceLikelihood.NEGATIVE,  # 'м'
        2: SequenceLikelihood.UNLIKELY,  # 'н'
        12: SequenceLikelihood.LIKELY,  # 'о'
        17: SequenceLikelihood.NEGATIVE,  # 'п'
        4: SequenceLikelihood.POSITIVE,  # 'р'
        5: SequenceLikelihood.NEGATIVE,  # 'с'
        10: SequenceLikelihood.NEGATIVE,  # 'т'
        16: SequenceLikelihood.LIKELY,  # 'у'
        34: SequenceLikelihood.NEGATIVE,  # 'ф'
        27: SequenceLikelihood.NEGATIVE,  # 'х'
        20: SequenceLikelihood.UNLIKELY,  # 'ц'
        23: SequenceLikelihood.NEGATIVE,  # 'ч'
        28: SequenceLikelihood.NEGATIVE,  # 'ш'
        6: SequenceLikelihood.UNLIKELY,  # 'ы'
        26: SequenceLikelihood.UNLIKELY,  # 'ь'
        24: SequenceLikelihood.UNLIKELY,  # 'э'
        30: SequenceLikelihood.UNLIKELY,  # 'ю'
        11: SequenceLikelihood.UNLIKELY,  # 'я'
        35: SequenceLikelihood.LIKELY,  # 'ё'
        3: SequenceLikelihood.LIKELY,  # 'і'
        19: SequenceLikelihood.NEGATIVE,  # 'ў'
    },
    53: {  # 'Х'
        65: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ё'
        48: SequenceLikelihood.LIKELY,  # 'І'
        62: SequenceLikelihood.NEGATIVE,  # 'Ў'
        33: SequenceLikelihood.UNLIKELY,  # 'А'
        36: SequenceLikelihood.UNLIKELY,  # 'Б'
        40: SequenceLikelihood.UNLIKELY,  # 'В'
        43: SequenceLikelihood.UNLIKELY,  # 'Г'
        45: SequenceLikelihood.UNLIKELY,  # 'Д'
        56: SequenceLikelihood.NEGATIVE,  # 'Е'
        57: SequenceLikelihood.NEGATIVE,  # 'Ж'
        46: SequenceLikelihood.UNLIKELY,  # 'З'
        63: SequenceLikelihood.NEGATIVE,  # 'Й'
        37: SequenceLikelihood.UNLIKELY,  # 'К'
        44: SequenceLikelihood.UNLIKELY,  # 'Л'
        38: SequenceLikelihood.UNLIKELY,  # 'М'
        42: SequenceLikelihood.UNLIKELY,  # 'Н'
        58: SequenceLikelihood.UNLIKELY,  # 'О'
        32: SequenceLikelihood.UNLIKELY,  # 'П'
        41: SequenceLikelihood.UNLIKELY,  # 'Р'
        31: SequenceLikelihood.UNLIKELY,  # 'С'
        47: SequenceLikelihood.UNLIKELY,  # 'Т'
        39: SequenceLikelihood.UNLIKELY,  # 'У'
        49: SequenceLikelihood.UNLIKELY,  # 'Ф'
        53: SequenceLikelihood.LIKELY,  # 'Х'
        55: SequenceLikelihood.NEGATIVE,  # 'Ц'
        54: SequenceLikelihood.NEGATIVE,  # 'Ч'
        52: SequenceLikelihood.NEGATIVE,  # 'Ш'
        61: SequenceLikelihood.NEGATIVE,  # 'Ы'
        64: SequenceLikelihood.NEGATIVE,  # 'Ь'
        51: SequenceLikelihood.NEGATIVE,  # 'Э'
        59: SequenceLikelihood.NEGATIVE,  # 'Ю'
        50: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.LIKELY,  # 'а'
        22: SequenceLikelihood.NEGATIVE,  # 'б'
        14: SequenceLikelihood.LIKELY,  # 'в'
        21: SequenceLikelihood.NEGATIVE,  # 'г'
        13: SequenceLikelihood.NEGATIVE,  # 'д'
        9: SequenceLikelihood.LIKELY,  # 'е'
        29: SequenceLikelihood.NEGATIVE,  # 'ж'
        18: SequenceLikelihood.NEGATIVE,  # 'з'
        25: SequenceLikelihood.NEGATIVE,  # 'й'
        7: SequenceLikelihood.NEGATIVE,  # 'к'
        8: SequenceLikelihood.UNLIKELY,  # 'л'
        15: SequenceLikelihood.UNLIKELY,  # 'м'
        2: SequenceLikelihood.NEGATIVE,  # 'н'
        12: SequenceLikelihood.LIKELY,  # 'о'
        17: SequenceLikelihood.NEGATIVE,  # 'п'
        4: SequenceLikelihood.LIKELY,  # 'р'
        5: SequenceLikelihood.NEGATIVE,  # 'с'
        10: SequenceLikelihood.UNLIKELY,  # 'т'
        16: SequenceLikelihood.LIKELY,  # 'у'
        34: SequenceLikelihood.NEGATIVE,  # 'ф'
        27: SequenceLikelihood.NEGATIVE,  # 'х'
        20: SequenceLikelihood.UNLIKELY,  # 'ц'
        23: SequenceLikelihood.NEGATIVE,  # 'ч'
        28: SequenceLikelihood.UNLIKELY,  # 'ш'
        6: SequenceLikelihood.UNLIKELY,  # 'ы'
        26: SequenceLikelihood.UNLIKELY,  # 'ь'
        24: SequenceLikelihood.UNLIKELY,  # 'э'
        30: SequenceLikelihood.UNLIKELY,  # 'ю'
        11: SequenceLikelihood.UNLIKELY,  # 'я'
        35: SequenceLikelihood.UNLIKELY,  # 'ё'
        3: SequenceLikelihood.LIKELY,  # 'і'
        19: SequenceLikelihood.NEGATIVE,  # 'ў'
    },
    55: {  # 'Ц'
        65: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        60: SequenceLikelihood.UNLIKELY,  # 'Ё'
        48: SequenceLikelihood.UNLIKELY,  # 'І'
        62: SequenceLikelihood.NEGATIVE,  # 'Ў'
        33: SequenceLikelihood.UNLIKELY,  # 'А'
        36: SequenceLikelihood.UNLIKELY,  # 'Б'
        40: SequenceLikelihood.LIKELY,  # 'В'
        43: SequenceLikelihood.UNLIKELY,  # 'Г'
        45: SequenceLikelihood.UNLIKELY,  # 'Д'
        56: SequenceLikelihood.UNLIKELY,  # 'Е'
        57: SequenceLikelihood.NEGATIVE,  # 'Ж'
        46: SequenceLikelihood.UNLIKELY,  # 'З'
        63: SequenceLikelihood.NEGATIVE,  # 'Й'
        37: SequenceLikelihood.LIKELY,  # 'К'
        44: SequenceLikelihood.NEGATIVE,  # 'Л'
        38: SequenceLikelihood.UNLIKELY,  # 'М'
        42: SequenceLikelihood.UNLIKELY,  # 'Н'
        58: SequenceLikelihood.UNLIKELY,  # 'О'
        32: SequenceLikelihood.UNLIKELY,  # 'П'
        41: SequenceLikelihood.UNLIKELY,  # 'Р'
        31: SequenceLikelihood.UNLIKELY,  # 'С'
        47: SequenceLikelihood.UNLIKELY,  # 'Т'
        39: SequenceLikelihood.UNLIKELY,  # 'У'
        49: SequenceLikelihood.UNLIKELY,  # 'Ф'
        53: SequenceLikelihood.NEGATIVE,  # 'Х'
        55: SequenceLikelihood.UNLIKELY,  # 'Ц'
        54: SequenceLikelihood.NEGATIVE,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        61: SequenceLikelihood.UNLIKELY,  # 'Ы'
        64: SequenceLikelihood.UNLIKELY,  # 'Ь'
        51: SequenceLikelihood.UNLIKELY,  # 'Э'
        59: SequenceLikelihood.UNLIKELY,  # 'Ю'
        50: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.LIKELY,  # 'а'
        22: SequenceLikelihood.NEGATIVE,  # 'б'
        14: SequenceLikelihood.LIKELY,  # 'в'
        21: SequenceLikelihood.NEGATIVE,  # 'г'
        13: SequenceLikelihood.NEGATIVE,  # 'д'
        9: SequenceLikelihood.LIKELY,  # 'е'
        29: SequenceLikelihood.NEGATIVE,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        25: SequenceLikelihood.NEGATIVE,  # 'й'
        7: SequenceLikelihood.UNLIKELY,  # 'к'
        8: SequenceLikelihood.UNLIKELY,  # 'л'
        15: SequenceLikelihood.UNLIKELY,  # 'м'
        2: SequenceLikelihood.UNLIKELY,  # 'н'
        12: SequenceLikelihood.UNLIKELY,  # 'о'
        17: SequenceLikelihood.NEGATIVE,  # 'п'
        4: SequenceLikelihood.UNLIKELY,  # 'р'
        5: SequenceLikelihood.NEGATIVE,  # 'с'
        10: SequenceLikelihood.NEGATIVE,  # 'т'
        16: SequenceLikelihood.UNLIKELY,  # 'у'
        34: SequenceLikelihood.UNLIKELY,  # 'ф'
        27: SequenceLikelihood.UNLIKELY,  # 'х'
        20: SequenceLikelihood.NEGATIVE,  # 'ц'
        23: SequenceLikelihood.NEGATIVE,  # 'ч'
        28: SequenceLikelihood.NEGATIVE,  # 'ш'
        6: SequenceLikelihood.LIKELY,  # 'ы'
        26: SequenceLikelihood.UNLIKELY,  # 'ь'
        24: SequenceLikelihood.LIKELY,  # 'э'
        30: SequenceLikelihood.UNLIKELY,  # 'ю'
        11: SequenceLikelihood.LIKELY,  # 'я'
        35: SequenceLikelihood.UNLIKELY,  # 'ё'
        3: SequenceLikelihood.LIKELY,  # 'і'
        19: SequenceLikelihood.NEGATIVE,  # 'ў'
    },
    54: {  # 'Ч'
        65: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        60: SequenceLikelihood.UNLIKELY,  # 'Ё'
        48: SequenceLikelihood.UNLIKELY,  # 'І'
        62: SequenceLikelihood.NEGATIVE,  # 'Ў'
        33: SequenceLikelihood.UNLIKELY,  # 'А'
        36: SequenceLikelihood.UNLIKELY,  # 'Б'
        40: SequenceLikelihood.NEGATIVE,  # 'В'
        43: SequenceLikelihood.NEGATIVE,  # 'Г'
        45: SequenceLikelihood.UNLIKELY,  # 'Д'
        56: SequenceLikelihood.UNLIKELY,  # 'Е'
        57: SequenceLikelihood.NEGATIVE,  # 'Ж'
        46: SequenceLikelihood.NEGATIVE,  # 'З'
        63: SequenceLikelihood.NEGATIVE,  # 'Й'
        37: SequenceLikelihood.UNLIKELY,  # 'К'
        44: SequenceLikelihood.NEGATIVE,  # 'Л'
        38: SequenceLikelihood.UNLIKELY,  # 'М'
        42: SequenceLikelihood.UNLIKELY,  # 'Н'
        58: SequenceLikelihood.UNLIKELY,  # 'О'
        32: SequenceLikelihood.UNLIKELY,  # 'П'
        41: SequenceLikelihood.UNLIKELY,  # 'Р'
        31: SequenceLikelihood.UNLIKELY,  # 'С'
        47: SequenceLikelihood.UNLIKELY,  # 'Т'
        39: SequenceLikelihood.UNLIKELY,  # 'У'
        49: SequenceLikelihood.NEGATIVE,  # 'Ф'
        53: SequenceLikelihood.NEGATIVE,  # 'Х'
        55: SequenceLikelihood.NEGATIVE,  # 'Ц'
        54: SequenceLikelihood.NEGATIVE,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        61: SequenceLikelihood.UNLIKELY,  # 'Ы'
        64: SequenceLikelihood.NEGATIVE,  # 'Ь'
        51: SequenceLikelihood.UNLIKELY,  # 'Э'
        59: SequenceLikelihood.NEGATIVE,  # 'Ю'
        50: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        22: SequenceLikelihood.NEGATIVE,  # 'б'
        14: SequenceLikelihood.UNLIKELY,  # 'в'
        21: SequenceLikelihood.NEGATIVE,  # 'г'
        13: SequenceLikelihood.NEGATIVE,  # 'д'
        9: SequenceLikelihood.UNLIKELY,  # 'е'
        29: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.NEGATIVE,  # 'з'
        25: SequenceLikelihood.NEGATIVE,  # 'й'
        7: SequenceLikelihood.UNLIKELY,  # 'к'
        8: SequenceLikelihood.LIKELY,  # 'л'
        15: SequenceLikelihood.UNLIKELY,  # 'м'
        2: SequenceLikelihood.NEGATIVE,  # 'н'
        12: SequenceLikelihood.LIKELY,  # 'о'
        17: SequenceLikelihood.NEGATIVE,  # 'п'
        4: SequenceLikelihood.UNLIKELY,  # 'р'
        5: SequenceLikelihood.NEGATIVE,  # 'с'
        10: SequenceLikelihood.UNLIKELY,  # 'т'
        16: SequenceLikelihood.LIKELY,  # 'у'
        34: SequenceLikelihood.NEGATIVE,  # 'ф'
        27: SequenceLikelihood.UNLIKELY,  # 'х'
        20: SequenceLikelihood.UNLIKELY,  # 'ц'
        23: SequenceLikelihood.NEGATIVE,  # 'ч'
        28: SequenceLikelihood.NEGATIVE,  # 'ш'
        6: SequenceLikelihood.LIKELY,  # 'ы'
        26: SequenceLikelihood.NEGATIVE,  # 'ь'
        24: SequenceLikelihood.LIKELY,  # 'э'
        30: SequenceLikelihood.NEGATIVE,  # 'ю'
        11: SequenceLikelihood.NEGATIVE,  # 'я'
        35: SequenceLikelihood.UNLIKELY,  # 'ё'
        3: SequenceLikelihood.UNLIKELY,  # 'і'
        19: SequenceLikelihood.NEGATIVE,  # 'ў'
    },
    52: {  # 'Ш'
        65: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ё'
        48: SequenceLikelihood.UNLIKELY,  # 'І'
        62: SequenceLikelihood.NEGATIVE,  # 'Ў'
        33: SequenceLikelihood.LIKELY,  # 'А'
        36: SequenceLikelihood.UNLIKELY,  # 'Б'
        40: SequenceLikelihood.UNLIKELY,  # 'В'
        43: SequenceLikelihood.UNLIKELY,  # 'Г'
        45: SequenceLikelihood.UNLIKELY,  # 'Д'
        56: SequenceLikelihood.UNLIKELY,  # 'Е'
        57: SequenceLikelihood.NEGATIVE,  # 'Ж'
        46: SequenceLikelihood.UNLIKELY,  # 'З'
        63: SequenceLikelihood.NEGATIVE,  # 'Й'
        37: SequenceLikelihood.UNLIKELY,  # 'К'
        44: SequenceLikelihood.UNLIKELY,  # 'Л'
        38: SequenceLikelihood.UNLIKELY,  # 'М'
        42: SequenceLikelihood.UNLIKELY,  # 'Н'
        58: SequenceLikelihood.UNLIKELY,  # 'О'
        32: SequenceLikelihood.UNLIKELY,  # 'П'
        41: SequenceLikelihood.NEGATIVE,  # 'Р'
        31: SequenceLikelihood.UNLIKELY,  # 'С'
        47: SequenceLikelihood.UNLIKELY,  # 'Т'
        39: SequenceLikelihood.UNLIKELY,  # 'У'
        49: SequenceLikelihood.NEGATIVE,  # 'Ф'
        53: SequenceLikelihood.NEGATIVE,  # 'Х'
        55: SequenceLikelihood.NEGATIVE,  # 'Ц'
        54: SequenceLikelihood.NEGATIVE,  # 'Ч'
        52: SequenceLikelihood.NEGATIVE,  # 'Ш'
        61: SequenceLikelihood.UNLIKELY,  # 'Ы'
        64: SequenceLikelihood.NEGATIVE,  # 'Ь'
        51: SequenceLikelihood.UNLIKELY,  # 'Э'
        59: SequenceLikelihood.NEGATIVE,  # 'Ю'
        50: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.LIKELY,  # 'а'
        22: SequenceLikelihood.NEGATIVE,  # 'б'
        14: SequenceLikelihood.LIKELY,  # 'в'
        21: SequenceLikelihood.NEGATIVE,  # 'г'
        13: SequenceLikelihood.NEGATIVE,  # 'д'
        9: SequenceLikelihood.UNLIKELY,  # 'е'
        29: SequenceLikelihood.NEGATIVE,  # 'ж'
        18: SequenceLikelihood.NEGATIVE,  # 'з'
        25: SequenceLikelihood.NEGATIVE,  # 'й'
        7: SequenceLikelihood.LIKELY,  # 'к'
        8: SequenceLikelihood.LIKELY,  # 'л'
        15: SequenceLikelihood.LIKELY,  # 'м'
        2: SequenceLikelihood.UNLIKELY,  # 'н'
        12: SequenceLikelihood.UNLIKELY,  # 'о'
        17: SequenceLikelihood.UNLIKELY,  # 'п'
        4: SequenceLikelihood.UNLIKELY,  # 'р'
        5: SequenceLikelihood.NEGATIVE,  # 'с'
        10: SequenceLikelihood.LIKELY,  # 'т'
        16: SequenceLikelihood.LIKELY,  # 'у'
        34: SequenceLikelihood.NEGATIVE,  # 'ф'
        27: SequenceLikelihood.UNLIKELY,  # 'х'
        20: SequenceLikelihood.UNLIKELY,  # 'ц'
        23: SequenceLikelihood.LIKELY,  # 'ч'
        28: SequenceLikelihood.NEGATIVE,  # 'ш'
        6: SequenceLikelihood.LIKELY,  # 'ы'
        26: SequenceLikelihood.NEGATIVE,  # 'ь'
        24: SequenceLikelihood.LIKELY,  # 'э'
        30: SequenceLikelihood.UNLIKELY,  # 'ю'
        11: SequenceLikelihood.UNLIKELY,  # 'я'
        35: SequenceLikelihood.NEGATIVE,  # 'ё'
        3: SequenceLikelihood.NEGATIVE,  # 'і'
        19: SequenceLikelihood.NEGATIVE,  # 'ў'
    },
    61: {  # 'Ы'
        65: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ё'
        48: SequenceLikelihood.UNLIKELY,  # 'І'
        62: SequenceLikelihood.UNLIKELY,  # 'Ў'
        33: SequenceLikelihood.UNLIKELY,  # 'А'
        36: SequenceLikelihood.UNLIKELY,  # 'Б'
        40: SequenceLikelihood.UNLIKELY,  # 'В'
        43: SequenceLikelihood.UNLIKELY,  # 'Г'
        45: SequenceLikelihood.UNLIKELY,  # 'Д'
        56: SequenceLikelihood.UNLIKELY,  # 'Е'
        57: SequenceLikelihood.NEGATIVE,  # 'Ж'
        46: SequenceLikelihood.UNLIKELY,  # 'З'
        63: SequenceLikelihood.UNLIKELY,  # 'Й'
        37: SequenceLikelihood.UNLIKELY,  # 'К'
        44: SequenceLikelihood.UNLIKELY,  # 'Л'
        38: SequenceLikelihood.UNLIKELY,  # 'М'
        42: SequenceLikelihood.UNLIKELY,  # 'Н'
        58: SequenceLikelihood.UNLIKELY,  # 'О'
        32: SequenceLikelihood.UNLIKELY,  # 'П'
        41: SequenceLikelihood.UNLIKELY,  # 'Р'
        31: SequenceLikelihood.UNLIKELY,  # 'С'
        47: SequenceLikelihood.UNLIKELY,  # 'Т'
        39: SequenceLikelihood.NEGATIVE,  # 'У'
        49: SequenceLikelihood.NEGATIVE,  # 'Ф'
        53: SequenceLikelihood.UNLIKELY,  # 'Х'
        55: SequenceLikelihood.UNLIKELY,  # 'Ц'
        54: SequenceLikelihood.UNLIKELY,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        61: SequenceLikelihood.NEGATIVE,  # 'Ы'
        64: SequenceLikelihood.NEGATIVE,  # 'Ь'
        51: SequenceLikelihood.NEGATIVE,  # 'Э'
        59: SequenceLikelihood.NEGATIVE,  # 'Ю'
        50: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.NEGATIVE,  # 'а'
        22: SequenceLikelihood.NEGATIVE,  # 'б'
        14: SequenceLikelihood.NEGATIVE,  # 'в'
        21: SequenceLikelihood.NEGATIVE,  # 'г'
        13: SequenceLikelihood.NEGATIVE,  # 'д'
        9: SequenceLikelihood.NEGATIVE,  # 'е'
        29: SequenceLikelihood.NEGATIVE,  # 'ж'
        18: SequenceLikelihood.NEGATIVE,  # 'з'
        25: SequenceLikelihood.UNLIKELY,  # 'й'
        7: SequenceLikelihood.NEGATIVE,  # 'к'
        8: SequenceLikelihood.UNLIKELY,  # 'л'
        15: SequenceLikelihood.NEGATIVE,  # 'м'
        2: SequenceLikelihood.UNLIKELY,  # 'н'
        12: SequenceLikelihood.NEGATIVE,  # 'о'
        17: SequenceLikelihood.NEGATIVE,  # 'п'
        4: SequenceLikelihood.NEGATIVE,  # 'р'
        5: SequenceLikelihood.NEGATIVE,  # 'с'
        10: SequenceLikelihood.UNLIKELY,  # 'т'
        16: SequenceLikelihood.NEGATIVE,  # 'у'
        34: SequenceLikelihood.NEGATIVE,  # 'ф'
        27: SequenceLikelihood.NEGATIVE,  # 'х'
        20: SequenceLikelihood.NEGATIVE,  # 'ц'
        23: SequenceLikelihood.NEGATIVE,  # 'ч'
        28: SequenceLikelihood.NEGATIVE,  # 'ш'
        6: SequenceLikelihood.NEGATIVE,  # 'ы'
        26: SequenceLikelihood.NEGATIVE,  # 'ь'
        24: SequenceLikelihood.NEGATIVE,  # 'э'
        30: SequenceLikelihood.NEGATIVE,  # 'ю'
        11: SequenceLikelihood.NEGATIVE,  # 'я'
        35: SequenceLikelihood.NEGATIVE,  # 'ё'
        3: SequenceLikelihood.NEGATIVE,  # 'і'
        19: SequenceLikelihood.UNLIKELY,  # 'ў'
    },
    64: {  # 'Ь'
        65: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ё'
        48: SequenceLikelihood.NEGATIVE,  # 'І'
        62: SequenceLikelihood.NEGATIVE,  # 'Ў'
        33: SequenceLikelihood.NEGATIVE,  # 'А'
        36: SequenceLikelihood.UNLIKELY,  # 'Б'
        40: SequenceLikelihood.UNLIKELY,  # 'В'
        43: SequenceLikelihood.UNLIKELY,  # 'Г'
        45: SequenceLikelihood.UNLIKELY,  # 'Д'
        56: SequenceLikelihood.UNLIKELY,  # 'Е'
        57: SequenceLikelihood.NEGATIVE,  # 'Ж'
        46: SequenceLikelihood.NEGATIVE,  # 'З'
        63: SequenceLikelihood.NEGATIVE,  # 'Й'
        37: SequenceLikelihood.UNLIKELY,  # 'К'
        44: SequenceLikelihood.NEGATIVE,  # 'Л'
        38: SequenceLikelihood.UNLIKELY,  # 'М'
        42: SequenceLikelihood.UNLIKELY,  # 'Н'
        58: SequenceLikelihood.NEGATIVE,  # 'О'
        32: SequenceLikelihood.NEGATIVE,  # 'П'
        41: SequenceLikelihood.NEGATIVE,  # 'Р'
        31: SequenceLikelihood.UNLIKELY,  # 'С'
        47: SequenceLikelihood.UNLIKELY,  # 'Т'
        39: SequenceLikelihood.NEGATIVE,  # 'У'
        49: SequenceLikelihood.NEGATIVE,  # 'Ф'
        53: SequenceLikelihood.NEGATIVE,  # 'Х'
        55: SequenceLikelihood.UNLIKELY,  # 'Ц'
        54: SequenceLikelihood.UNLIKELY,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        61: SequenceLikelihood.NEGATIVE,  # 'Ы'
        64: SequenceLikelihood.NEGATIVE,  # 'Ь'
        51: SequenceLikelihood.NEGATIVE,  # 'Э'
        59: SequenceLikelihood.NEGATIVE,  # 'Ю'
        50: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.NEGATIVE,  # 'а'
        22: SequenceLikelihood.NEGATIVE,  # 'б'
        14: SequenceLikelihood.NEGATIVE,  # 'в'
        21: SequenceLikelihood.NEGATIVE,  # 'г'
        13: SequenceLikelihood.NEGATIVE,  # 'д'
        9: SequenceLikelihood.NEGATIVE,  # 'е'
        29: SequenceLikelihood.NEGATIVE,  # 'ж'
        18: SequenceLikelihood.NEGATIVE,  # 'з'
        25: SequenceLikelihood.NEGATIVE,  # 'й'
        7: SequenceLikelihood.NEGATIVE,  # 'к'
        8: SequenceLikelihood.NEGATIVE,  # 'л'
        15: SequenceLikelihood.NEGATIVE,  # 'м'
        2: SequenceLikelihood.NEGATIVE,  # 'н'
        12: SequenceLikelihood.NEGATIVE,  # 'о'
        17: SequenceLikelihood.NEGATIVE,  # 'п'
        4: SequenceLikelihood.NEGATIVE,  # 'р'
        5: SequenceLikelihood.NEGATIVE,  # 'с'
        10: SequenceLikelihood.NEGATIVE,  # 'т'
        16: SequenceLikelihood.NEGATIVE,  # 'у'
        34: SequenceLikelihood.NEGATIVE,  # 'ф'
        27: SequenceLikelihood.NEGATIVE,  # 'х'
        20: SequenceLikelihood.NEGATIVE,  # 'ц'
        23: SequenceLikelihood.NEGATIVE,  # 'ч'
        28: SequenceLikelihood.NEGATIVE,  # 'ш'
        6: SequenceLikelihood.NEGATIVE,  # 'ы'
        26: SequenceLikelihood.NEGATIVE,  # 'ь'
        24: SequenceLikelihood.NEGATIVE,  # 'э'
        30: SequenceLikelihood.NEGATIVE,  # 'ю'
        11: SequenceLikelihood.NEGATIVE,  # 'я'
        35: SequenceLikelihood.NEGATIVE,  # 'ё'
        3: SequenceLikelihood.NEGATIVE,  # 'і'
        19: SequenceLikelihood.NEGATIVE,  # 'ў'
    },
    51: {  # 'Э'
        65: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ё'
        48: SequenceLikelihood.NEGATIVE,  # 'І'
        62: SequenceLikelihood.UNLIKELY,  # 'Ў'
        33: SequenceLikelihood.UNLIKELY,  # 'А'
        36: SequenceLikelihood.UNLIKELY,  # 'Б'
        40: SequenceLikelihood.UNLIKELY,  # 'В'
        43: SequenceLikelihood.UNLIKELY,  # 'Г'
        45: SequenceLikelihood.UNLIKELY,  # 'Д'
        56: SequenceLikelihood.NEGATIVE,  # 'Е'
        57: SequenceLikelihood.NEGATIVE,  # 'Ж'
        46: SequenceLikelihood.UNLIKELY,  # 'З'
        63: SequenceLikelihood.UNLIKELY,  # 'Й'
        37: SequenceLikelihood.UNLIKELY,  # 'К'
        44: SequenceLikelihood.UNLIKELY,  # 'Л'
        38: SequenceLikelihood.UNLIKELY,  # 'М'
        42: SequenceLikelihood.UNLIKELY,  # 'Н'
        58: SequenceLikelihood.UNLIKELY,  # 'О'
        32: SequenceLikelihood.UNLIKELY,  # 'П'
        41: SequenceLikelihood.UNLIKELY,  # 'Р'
        31: SequenceLikelihood.LIKELY,  # 'С'
        47: SequenceLikelihood.UNLIKELY,  # 'Т'
        39: SequenceLikelihood.UNLIKELY,  # 'У'
        49: SequenceLikelihood.UNLIKELY,  # 'Ф'
        53: SequenceLikelihood.UNLIKELY,  # 'Х'
        55: SequenceLikelihood.UNLIKELY,  # 'Ц'
        54: SequenceLikelihood.UNLIKELY,  # 'Ч'
        52: SequenceLikelihood.NEGATIVE,  # 'Ш'
        61: SequenceLikelihood.NEGATIVE,  # 'Ы'
        64: SequenceLikelihood.NEGATIVE,  # 'Ь'
        51: SequenceLikelihood.NEGATIVE,  # 'Э'
        59: SequenceLikelihood.NEGATIVE,  # 'Ю'
        50: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.UNLIKELY,  # 'а'
        22: SequenceLikelihood.UNLIKELY,  # 'б'
        14: SequenceLikelihood.UNLIKELY,  # 'в'
        21: SequenceLikelihood.UNLIKELY,  # 'г'
        13: SequenceLikelihood.LIKELY,  # 'д'
        9: SequenceLikelihood.UNLIKELY,  # 'е'
        29: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        25: SequenceLikelihood.LIKELY,  # 'й'
        7: SequenceLikelihood.LIKELY,  # 'к'
        8: SequenceLikelihood.LIKELY,  # 'л'
        15: SequenceLikelihood.LIKELY,  # 'м'
        2: SequenceLikelihood.POSITIVE,  # 'н'
        12: SequenceLikelihood.UNLIKELY,  # 'о'
        17: SequenceLikelihood.UNLIKELY,  # 'п'
        4: SequenceLikelihood.LIKELY,  # 'р'
        5: SequenceLikelihood.LIKELY,  # 'с'
        10: SequenceLikelihood.LIKELY,  # 'т'
        16: SequenceLikelihood.UNLIKELY,  # 'у'
        34: SequenceLikelihood.LIKELY,  # 'ф'
        27: SequenceLikelihood.UNLIKELY,  # 'х'
        20: SequenceLikelihood.UNLIKELY,  # 'ц'
        23: SequenceLikelihood.UNLIKELY,  # 'ч'
        28: SequenceLikelihood.UNLIKELY,  # 'ш'
        6: SequenceLikelihood.NEGATIVE,  # 'ы'
        26: SequenceLikelihood.NEGATIVE,  # 'ь'
        24: SequenceLikelihood.UNLIKELY,  # 'э'
        30: SequenceLikelihood.UNLIKELY,  # 'ю'
        11: SequenceLikelihood.UNLIKELY,  # 'я'
        35: SequenceLikelihood.UNLIKELY,  # 'ё'
        3: SequenceLikelihood.UNLIKELY,  # 'і'
        19: SequenceLikelihood.UNLIKELY,  # 'ў'
    },
    59: {  # 'Ю'
        65: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ё'
        48: SequenceLikelihood.NEGATIVE,  # 'І'
        62: SequenceLikelihood.NEGATIVE,  # 'Ў'
        33: SequenceLikelihood.UNLIKELY,  # 'А'
        36: SequenceLikelihood.UNLIKELY,  # 'Б'
        40: SequenceLikelihood.UNLIKELY,  # 'В'
        43: SequenceLikelihood.UNLIKELY,  # 'Г'
        45: SequenceLikelihood.UNLIKELY,  # 'Д'
        56: SequenceLikelihood.UNLIKELY,  # 'Е'
        57: SequenceLikelihood.NEGATIVE,  # 'Ж'
        46: SequenceLikelihood.UNLIKELY,  # 'З'
        63: SequenceLikelihood.NEGATIVE,  # 'Й'
        37: SequenceLikelihood.UNLIKELY,  # 'К'
        44: SequenceLikelihood.UNLIKELY,  # 'Л'
        38: SequenceLikelihood.UNLIKELY,  # 'М'
        42: SequenceLikelihood.UNLIKELY,  # 'Н'
        58: SequenceLikelihood.NEGATIVE,  # 'О'
        32: SequenceLikelihood.UNLIKELY,  # 'П'
        41: SequenceLikelihood.UNLIKELY,  # 'Р'
        31: SequenceLikelihood.UNLIKELY,  # 'С'
        47: SequenceLikelihood.NEGATIVE,  # 'Т'
        39: SequenceLikelihood.NEGATIVE,  # 'У'
        49: SequenceLikelihood.NEGATIVE,  # 'Ф'
        53: SequenceLikelihood.UNLIKELY,  # 'Х'
        55: SequenceLikelihood.UNLIKELY,  # 'Ц'
        54: SequenceLikelihood.UNLIKELY,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        61: SequenceLikelihood.NEGATIVE,  # 'Ы'
        64: SequenceLikelihood.NEGATIVE,  # 'Ь'
        51: SequenceLikelihood.NEGATIVE,  # 'Э'
        59: SequenceLikelihood.NEGATIVE,  # 'Ю'
        50: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.UNLIKELY,  # 'а'
        22: SequenceLikelihood.UNLIKELY,  # 'б'
        14: SequenceLikelihood.UNLIKELY,  # 'в'
        21: SequenceLikelihood.UNLIKELY,  # 'г'
        13: SequenceLikelihood.UNLIKELY,  # 'д'
        9: SequenceLikelihood.UNLIKELY,  # 'е'
        29: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.LIKELY,  # 'з'
        25: SequenceLikelihood.UNLIKELY,  # 'й'
        7: SequenceLikelihood.UNLIKELY,  # 'к'
        8: SequenceLikelihood.LIKELY,  # 'л'
        15: SequenceLikelihood.UNLIKELY,  # 'м'
        2: SequenceLikelihood.LIKELY,  # 'н'
        12: SequenceLikelihood.UNLIKELY,  # 'о'
        17: SequenceLikelihood.LIKELY,  # 'п'
        4: SequenceLikelihood.LIKELY,  # 'р'
        5: SequenceLikelihood.UNLIKELY,  # 'с'
        10: SequenceLikelihood.UNLIKELY,  # 'т'
        16: SequenceLikelihood.NEGATIVE,  # 'у'
        34: SequenceLikelihood.UNLIKELY,  # 'ф'
        27: SequenceLikelihood.UNLIKELY,  # 'х'
        20: SequenceLikelihood.UNLIKELY,  # 'ц'
        23: SequenceLikelihood.UNLIKELY,  # 'ч'
        28: SequenceLikelihood.UNLIKELY,  # 'ш'
        6: SequenceLikelihood.NEGATIVE,  # 'ы'
        26: SequenceLikelihood.NEGATIVE,  # 'ь'
        24: SequenceLikelihood.UNLIKELY,  # 'э'
        30: SequenceLikelihood.UNLIKELY,  # 'ю'
        11: SequenceLikelihood.NEGATIVE,  # 'я'
        35: SequenceLikelihood.NEGATIVE,  # 'ё'
        3: SequenceLikelihood.UNLIKELY,  # 'і'
        19: SequenceLikelihood.NEGATIVE,  # 'ў'
    },
    50: {  # 'Я'
        65: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ё'
        48: SequenceLikelihood.NEGATIVE,  # 'І'
        62: SequenceLikelihood.UNLIKELY,  # 'Ў'
        33: SequenceLikelihood.UNLIKELY,  # 'А'
        36: SequenceLikelihood.UNLIKELY,  # 'Б'
        40: SequenceLikelihood.UNLIKELY,  # 'В'
        43: SequenceLikelihood.UNLIKELY,  # 'Г'
        45: SequenceLikelihood.UNLIKELY,  # 'Д'
        56: SequenceLikelihood.UNLIKELY,  # 'Е'
        57: SequenceLikelihood.UNLIKELY,  # 'Ж'
        46: SequenceLikelihood.UNLIKELY,  # 'З'
        63: SequenceLikelihood.NEGATIVE,  # 'Й'
        37: SequenceLikelihood.UNLIKELY,  # 'К'
        44: SequenceLikelihood.UNLIKELY,  # 'Л'
        38: SequenceLikelihood.UNLIKELY,  # 'М'
        42: SequenceLikelihood.UNLIKELY,  # 'Н'
        58: SequenceLikelihood.NEGATIVE,  # 'О'
        32: SequenceLikelihood.UNLIKELY,  # 'П'
        41: SequenceLikelihood.UNLIKELY,  # 'Р'
        31: SequenceLikelihood.UNLIKELY,  # 'С'
        47: SequenceLikelihood.UNLIKELY,  # 'Т'
        39: SequenceLikelihood.NEGATIVE,  # 'У'
        49: SequenceLikelihood.NEGATIVE,  # 'Ф'
        53: SequenceLikelihood.NEGATIVE,  # 'Х'
        55: SequenceLikelihood.UNLIKELY,  # 'Ц'
        54: SequenceLikelihood.NEGATIVE,  # 'Ч'
        52: SequenceLikelihood.NEGATIVE,  # 'Ш'
        61: SequenceLikelihood.NEGATIVE,  # 'Ы'
        64: SequenceLikelihood.NEGATIVE,  # 'Ь'
        51: SequenceLikelihood.UNLIKELY,  # 'Э'
        59: SequenceLikelihood.NEGATIVE,  # 'Ю'
        50: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.UNLIKELY,  # 'а'
        22: SequenceLikelihood.UNLIKELY,  # 'б'
        14: SequenceLikelihood.UNLIKELY,  # 'в'
        21: SequenceLikelihood.LIKELY,  # 'г'
        13: SequenceLikelihood.LIKELY,  # 'д'
        9: SequenceLikelihood.LIKELY,  # 'е'
        29: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.LIKELY,  # 'з'
        25: SequenceLikelihood.UNLIKELY,  # 'й'
        7: SequenceLikelihood.LIKELY,  # 'к'
        8: SequenceLikelihood.UNLIKELY,  # 'л'
        15: SequenceLikelihood.LIKELY,  # 'м'
        2: SequenceLikelihood.POSITIVE,  # 'н'
        12: SequenceLikelihood.NEGATIVE,  # 'о'
        17: SequenceLikelihood.LIKELY,  # 'п'
        4: SequenceLikelihood.LIKELY,  # 'р'
        5: SequenceLikelihood.LIKELY,  # 'с'
        10: SequenceLikelihood.UNLIKELY,  # 'т'
        16: SequenceLikelihood.UNLIKELY,  # 'у'
        34: SequenceLikelihood.UNLIKELY,  # 'ф'
        27: SequenceLikelihood.UNLIKELY,  # 'х'
        20: SequenceLikelihood.LIKELY,  # 'ц'
        23: SequenceLikelihood.UNLIKELY,  # 'ч'
        28: SequenceLikelihood.LIKELY,  # 'ш'
        6: SequenceLikelihood.NEGATIVE,  # 'ы'
        26: SequenceLikelihood.NEGATIVE,  # 'ь'
        24: SequenceLikelihood.NEGATIVE,  # 'э'
        30: SequenceLikelihood.NEGATIVE,  # 'ю'
        11: SequenceLikelihood.UNLIKELY,  # 'я'
        35: SequenceLikelihood.UNLIKELY,  # 'ё'
        3: SequenceLikelihood.UNLIKELY,  # 'і'
        19: SequenceLikelihood.LIKELY,  # 'ў'
    },
    1: {  # 'а'
        65: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ё'
        48: SequenceLikelihood.UNLIKELY,  # 'І'
        62: SequenceLikelihood.NEGATIVE,  # 'Ў'
        33: SequenceLikelihood.UNLIKELY,  # 'А'
        36: SequenceLikelihood.UNLIKELY,  # 'Б'
        40: SequenceLikelihood.UNLIKELY,  # 'В'
        43: SequenceLikelihood.UNLIKELY,  # 'Г'
        45: SequenceLikelihood.UNLIKELY,  # 'Д'
        56: SequenceLikelihood.NEGATIVE,  # 'Е'
        57: SequenceLikelihood.NEGATIVE,  # 'Ж'
        46: SequenceLikelihood.UNLIKELY,  # 'З'
        63: SequenceLikelihood.NEGATIVE,  # 'Й'
        37: SequenceLikelihood.UNLIKELY,  # 'К'
        44: SequenceLikelihood.NEGATIVE,  # 'Л'
        38: SequenceLikelihood.UNLIKELY,  # 'М'
        42: SequenceLikelihood.UNLIKELY,  # 'Н'
        58: SequenceLikelihood.NEGATIVE,  # 'О'
        32: SequenceLikelihood.UNLIKELY,  # 'П'
        41: SequenceLikelihood.UNLIKELY,  # 'Р'
        31: SequenceLikelihood.UNLIKELY,  # 'С'
        47: SequenceLikelihood.UNLIKELY,  # 'Т'
        39: SequenceLikelihood.NEGATIVE,  # 'У'
        49: SequenceLikelihood.NEGATIVE,  # 'Ф'
        53: SequenceLikelihood.UNLIKELY,  # 'Х'
        55: SequenceLikelihood.NEGATIVE,  # 'Ц'
        54: SequenceLikelihood.NEGATIVE,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        61: SequenceLikelihood.NEGATIVE,  # 'Ы'
        64: SequenceLikelihood.NEGATIVE,  # 'Ь'
        51: SequenceLikelihood.NEGATIVE,  # 'Э'
        59: SequenceLikelihood.NEGATIVE,  # 'Ю'
        50: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        22: SequenceLikelihood.POSITIVE,  # 'б'
        14: SequenceLikelihood.POSITIVE,  # 'в'
        21: SequenceLikelihood.POSITIVE,  # 'г'
        13: SequenceLikelihood.POSITIVE,  # 'д'
        9: SequenceLikelihood.POSITIVE,  # 'е'
        29: SequenceLikelihood.POSITIVE,  # 'ж'
        18: SequenceLikelihood.POSITIVE,  # 'з'
        25: SequenceLikelihood.POSITIVE,  # 'й'
        7: SequenceLikelihood.POSITIVE,  # 'к'
        8: SequenceLikelihood.POSITIVE,  # 'л'
        15: SequenceLikelihood.POSITIVE,  # 'м'
        2: SequenceLikelihood.POSITIVE,  # 'н'
        12: SequenceLikelihood.LIKELY,  # 'о'
        17: SequenceLikelihood.POSITIVE,  # 'п'
        4: SequenceLikelihood.POSITIVE,  # 'р'
        5: SequenceLikelihood.POSITIVE,  # 'с'
        10: SequenceLikelihood.POSITIVE,  # 'т'
        16: SequenceLikelihood.LIKELY,  # 'у'
        34: SequenceLikelihood.POSITIVE,  # 'ф'
        27: SequenceLikelihood.POSITIVE,  # 'х'
        20: SequenceLikelihood.POSITIVE,  # 'ц'
        23: SequenceLikelihood.POSITIVE,  # 'ч'
        28: SequenceLikelihood.POSITIVE,  # 'ш'
        6: SequenceLikelihood.UNLIKELY,  # 'ы'
        26: SequenceLikelihood.UNLIKELY,  # 'ь'
        24: SequenceLikelihood.POSITIVE,  # 'э'
        30: SequenceLikelihood.POSITIVE,  # 'ю'
        11: SequenceLikelihood.POSITIVE,  # 'я'
        35: SequenceLikelihood.POSITIVE,  # 'ё'
        3: SequenceLikelihood.POSITIVE,  # 'і'
        19: SequenceLikelihood.POSITIVE,  # 'ў'
    },
    22: {  # 'б'
        65: SequenceLikelihood.UNLIKELY,  # 'ʼ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ё'
        48: SequenceLikelihood.NEGATIVE,  # 'І'
        62: SequenceLikelihood.NEGATIVE,  # 'Ў'
        33: SequenceLikelihood.NEGATIVE,  # 'А'
        36: SequenceLikelihood.NEGATIVE,  # 'Б'
        40: SequenceLikelihood.UNLIKELY,  # 'В'
        43: SequenceLikelihood.UNLIKELY,  # 'Г'
        45: SequenceLikelihood.NEGATIVE,  # 'Д'
        56: SequenceLikelihood.NEGATIVE,  # 'Е'
        57: SequenceLikelihood.NEGATIVE,  # 'Ж'
        46: SequenceLikelihood.NEGATIVE,  # 'З'
        63: SequenceLikelihood.NEGATIVE,  # 'Й'
        37: SequenceLikelihood.NEGATIVE,  # 'К'
        44: SequenceLikelihood.NEGATIVE,  # 'Л'
        38: SequenceLikelihood.UNLIKELY,  # 'М'
        42: SequenceLikelihood.UNLIKELY,  # 'Н'
        58: SequenceLikelihood.NEGATIVE,  # 'О'
        32: SequenceLikelihood.NEGATIVE,  # 'П'
        41: SequenceLikelihood.NEGATIVE,  # 'Р'
        31: SequenceLikelihood.UNLIKELY,  # 'С'
        47: SequenceLikelihood.NEGATIVE,  # 'Т'
        39: SequenceLikelihood.NEGATIVE,  # 'У'
        49: SequenceLikelihood.UNLIKELY,  # 'Ф'
        53: SequenceLikelihood.NEGATIVE,  # 'Х'
        55: SequenceLikelihood.NEGATIVE,  # 'Ц'
        54: SequenceLikelihood.NEGATIVE,  # 'Ч'
        52: SequenceLikelihood.NEGATIVE,  # 'Ш'
        61: SequenceLikelihood.NEGATIVE,  # 'Ы'
        64: SequenceLikelihood.NEGATIVE,  # 'Ь'
        51: SequenceLikelihood.NEGATIVE,  # 'Э'
        59: SequenceLikelihood.NEGATIVE,  # 'Ю'
        50: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        22: SequenceLikelihood.UNLIKELY,  # 'б'
        14: SequenceLikelihood.LIKELY,  # 'в'
        21: SequenceLikelihood.LIKELY,  # 'г'
        13: SequenceLikelihood.LIKELY,  # 'д'
        9: SequenceLikelihood.POSITIVE,  # 'е'
        29: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        25: SequenceLikelihood.NEGATIVE,  # 'й'
        7: SequenceLikelihood.LIKELY,  # 'к'
        8: SequenceLikelihood.POSITIVE,  # 'л'
        15: SequenceLikelihood.LIKELY,  # 'м'
        2: SequenceLikelihood.POSITIVE,  # 'н'
        12: SequenceLikelihood.POSITIVE,  # 'о'
        17: SequenceLikelihood.UNLIKELY,  # 'п'
        4: SequenceLikelihood.POSITIVE,  # 'р'
        5: SequenceLikelihood.POSITIVE,  # 'с'
        10: SequenceLikelihood.LIKELY,  # 'т'
        16: SequenceLikelihood.POSITIVE,  # 'у'
        34: SequenceLikelihood.UNLIKELY,  # 'ф'
        27: SequenceLikelihood.LIKELY,  # 'х'
        20: SequenceLikelihood.LIKELY,  # 'ц'
        23: SequenceLikelihood.LIKELY,  # 'ч'
        28: SequenceLikelihood.LIKELY,  # 'ш'
        6: SequenceLikelihood.POSITIVE,  # 'ы'
        26: SequenceLikelihood.UNLIKELY,  # 'ь'
        24: SequenceLikelihood.LIKELY,  # 'э'
        30: SequenceLikelihood.LIKELY,  # 'ю'
        11: SequenceLikelihood.POSITIVE,  # 'я'
        35: SequenceLikelihood.UNLIKELY,  # 'ё'
        3: SequenceLikelihood.POSITIVE,  # 'і'
        19: SequenceLikelihood.NEGATIVE,  # 'ў'
    },
    14: {  # 'в'
        65: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ё'
        48: SequenceLikelihood.NEGATIVE,  # 'І'
        62: SequenceLikelihood.NEGATIVE,  # 'Ў'
        33: SequenceLikelihood.NEGATIVE,  # 'А'
        36: SequenceLikelihood.UNLIKELY,  # 'Б'
        40: SequenceLikelihood.NEGATIVE,  # 'В'
        43: SequenceLikelihood.UNLIKELY,  # 'Г'
        45: SequenceLikelihood.UNLIKELY,  # 'Д'
        56: SequenceLikelihood.NEGATIVE,  # 'Е'
        57: SequenceLikelihood.NEGATIVE,  # 'Ж'
        46: SequenceLikelihood.NEGATIVE,  # 'З'
        63: SequenceLikelihood.NEGATIVE,  # 'Й'
        37: SequenceLikelihood.NEGATIVE,  # 'К'
        44: SequenceLikelihood.NEGATIVE,  # 'Л'
        38: SequenceLikelihood.NEGATIVE,  # 'М'
        42: SequenceLikelihood.NEGATIVE,  # 'Н'
        58: SequenceLikelihood.NEGATIVE,  # 'О'
        32: SequenceLikelihood.UNLIKELY,  # 'П'
        41: SequenceLikelihood.NEGATIVE,  # 'Р'
        31: SequenceLikelihood.UNLIKELY,  # 'С'
        47: SequenceLikelihood.NEGATIVE,  # 'Т'
        39: SequenceLikelihood.NEGATIVE,  # 'У'
        49: SequenceLikelihood.NEGATIVE,  # 'Ф'
        53: SequenceLikelihood.NEGATIVE,  # 'Х'
        55: SequenceLikelihood.NEGATIVE,  # 'Ц'
        54: SequenceLikelihood.NEGATIVE,  # 'Ч'
        52: SequenceLikelihood.NEGATIVE,  # 'Ш'
        61: SequenceLikelihood.NEGATIVE,  # 'Ы'
        64: SequenceLikelihood.NEGATIVE,  # 'Ь'
        51: SequenceLikelihood.NEGATIVE,  # 'Э'
        59: SequenceLikelihood.NEGATIVE,  # 'Ю'
        50: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        22: SequenceLikelihood.UNLIKELY,  # 'б'
        14: SequenceLikelihood.UNLIKELY,  # 'в'
        21: SequenceLikelihood.UNLIKELY,  # 'г'
        13: SequenceLikelihood.UNLIKELY,  # 'д'
        9: SequenceLikelihood.POSITIVE,  # 'е'
        29: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        25: SequenceLikelihood.UNLIKELY,  # 'й'
        7: SequenceLikelihood.UNLIKELY,  # 'к'
        8: SequenceLikelihood.LIKELY,  # 'л'
        15: SequenceLikelihood.UNLIKELY,  # 'м'
        2: SequenceLikelihood.LIKELY,  # 'н'
        12: SequenceLikelihood.POSITIVE,  # 'о'
        17: SequenceLikelihood.UNLIKELY,  # 'п'
        4: SequenceLikelihood.LIKELY,  # 'р'
        5: SequenceLikelihood.LIKELY,  # 'с'
        10: SequenceLikelihood.UNLIKELY,  # 'т'
        16: SequenceLikelihood.POSITIVE,  # 'у'
        34: SequenceLikelihood.UNLIKELY,  # 'ф'
        27: SequenceLikelihood.UNLIKELY,  # 'х'
        20: SequenceLikelihood.UNLIKELY,  # 'ц'
        23: SequenceLikelihood.UNLIKELY,  # 'ч'
        28: SequenceLikelihood.UNLIKELY,  # 'ш'
        6: SequenceLikelihood.POSITIVE,  # 'ы'
        26: SequenceLikelihood.UNLIKELY,  # 'ь'
        24: SequenceLikelihood.LIKELY,  # 'э'
        30: SequenceLikelihood.LIKELY,  # 'ю'
        11: SequenceLikelihood.POSITIVE,  # 'я'
        35: SequenceLikelihood.POSITIVE,  # 'ё'
        3: SequenceLikelihood.POSITIVE,  # 'і'
        19: SequenceLikelihood.UNLIKELY,  # 'ў'
    },
    21: {  # 'г'
        65: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ё'
        48: SequenceLikelihood.NEGATIVE,  # 'І'
        62: SequenceLikelihood.NEGATIVE,  # 'Ў'
        33: SequenceLikelihood.NEGATIVE,  # 'А'
        36: SequenceLikelihood.NEGATIVE,  # 'Б'
        40: SequenceLikelihood.NEGATIVE,  # 'В'
        43: SequenceLikelihood.NEGATIVE,  # 'Г'
        45: SequenceLikelihood.NEGATIVE,  # 'Д'
        56: SequenceLikelihood.NEGATIVE,  # 'Е'
        57: SequenceLikelihood.NEGATIVE,  # 'Ж'
        46: SequenceLikelihood.NEGATIVE,  # 'З'
        63: SequenceLikelihood.NEGATIVE,  # 'Й'
        37: SequenceLikelihood.NEGATIVE,  # 'К'
        44: SequenceLikelihood.NEGATIVE,  # 'Л'
        38: SequenceLikelihood.NEGATIVE,  # 'М'
        42: SequenceLikelihood.NEGATIVE,  # 'Н'
        58: SequenceLikelihood.NEGATIVE,  # 'О'
        32: SequenceLikelihood.UNLIKELY,  # 'П'
        41: SequenceLikelihood.UNLIKELY,  # 'Р'
        31: SequenceLikelihood.NEGATIVE,  # 'С'
        47: SequenceLikelihood.NEGATIVE,  # 'Т'
        39: SequenceLikelihood.NEGATIVE,  # 'У'
        49: SequenceLikelihood.NEGATIVE,  # 'Ф'
        53: SequenceLikelihood.NEGATIVE,  # 'Х'
        55: SequenceLikelihood.UNLIKELY,  # 'Ц'
        54: SequenceLikelihood.NEGATIVE,  # 'Ч'
        52: SequenceLikelihood.NEGATIVE,  # 'Ш'
        61: SequenceLikelihood.NEGATIVE,  # 'Ы'
        64: SequenceLikelihood.NEGATIVE,  # 'Ь'
        51: SequenceLikelihood.NEGATIVE,  # 'Э'
        59: SequenceLikelihood.NEGATIVE,  # 'Ю'
        50: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        22: SequenceLikelihood.UNLIKELY,  # 'б'
        14: SequenceLikelihood.LIKELY,  # 'в'
        21: SequenceLikelihood.LIKELY,  # 'г'
        13: SequenceLikelihood.LIKELY,  # 'д'
        9: SequenceLikelihood.POSITIVE,  # 'е'
        29: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        25: SequenceLikelihood.UNLIKELY,  # 'й'
        7: SequenceLikelihood.LIKELY,  # 'к'
        8: SequenceLikelihood.POSITIVE,  # 'л'
        15: SequenceLikelihood.LIKELY,  # 'м'
        2: SequenceLikelihood.POSITIVE,  # 'н'
        12: SequenceLikelihood.POSITIVE,  # 'о'
        17: SequenceLikelihood.UNLIKELY,  # 'п'
        4: SequenceLikelihood.POSITIVE,  # 'р'
        5: SequenceLikelihood.LIKELY,  # 'с'
        10: SequenceLikelihood.LIKELY,  # 'т'
        16: SequenceLikelihood.POSITIVE,  # 'у'
        34: SequenceLikelihood.UNLIKELY,  # 'ф'
        27: SequenceLikelihood.UNLIKELY,  # 'х'
        20: SequenceLikelihood.UNLIKELY,  # 'ц'
        23: SequenceLikelihood.LIKELY,  # 'ч'
        28: SequenceLikelihood.UNLIKELY,  # 'ш'
        6: SequenceLikelihood.UNLIKELY,  # 'ы'
        26: SequenceLikelihood.UNLIKELY,  # 'ь'
        24: SequenceLikelihood.POSITIVE,  # 'э'
        30: SequenceLikelihood.UNLIKELY,  # 'ю'
        11: SequenceLikelihood.UNLIKELY,  # 'я'
        35: SequenceLikelihood.UNLIKELY,  # 'ё'
        3: SequenceLikelihood.POSITIVE,  # 'і'
        19: SequenceLikelihood.UNLIKELY,  # 'ў'
    },
    13: {  # 'д'
        65: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ё'
        48: SequenceLikelihood.NEGATIVE,  # 'І'
        62: SequenceLikelihood.NEGATIVE,  # 'Ў'
        33: SequenceLikelihood.UNLIKELY,  # 'А'
        36: SequenceLikelihood.UNLIKELY,  # 'Б'
        40: SequenceLikelihood.NEGATIVE,  # 'В'
        43: SequenceLikelihood.UNLIKELY,  # 'Г'
        45: SequenceLikelihood.NEGATIVE,  # 'Д'
        56: SequenceLikelihood.NEGATIVE,  # 'Е'
        57: SequenceLikelihood.NEGATIVE,  # 'Ж'
        46: SequenceLikelihood.NEGATIVE,  # 'З'
        63: SequenceLikelihood.NEGATIVE,  # 'Й'
        37: SequenceLikelihood.NEGATIVE,  # 'К'
        44: SequenceLikelihood.NEGATIVE,  # 'Л'
        38: SequenceLikelihood.NEGATIVE,  # 'М'
        42: SequenceLikelihood.NEGATIVE,  # 'Н'
        58: SequenceLikelihood.NEGATIVE,  # 'О'
        32: SequenceLikelihood.NEGATIVE,  # 'П'
        41: SequenceLikelihood.NEGATIVE,  # 'Р'
        31: SequenceLikelihood.NEGATIVE,  # 'С'
        47: SequenceLikelihood.NEGATIVE,  # 'Т'
        39: SequenceLikelihood.NEGATIVE,  # 'У'
        49: SequenceLikelihood.NEGATIVE,  # 'Ф'
        53: SequenceLikelihood.NEGATIVE,  # 'Х'
        55: SequenceLikelihood.NEGATIVE,  # 'Ц'
        54: SequenceLikelihood.NEGATIVE,  # 'Ч'
        52: SequenceLikelihood.NEGATIVE,  # 'Ш'
        61: SequenceLikelihood.NEGATIVE,  # 'Ы'
        64: SequenceLikelihood.NEGATIVE,  # 'Ь'
        51: SequenceLikelihood.NEGATIVE,  # 'Э'
        59: SequenceLikelihood.NEGATIVE,  # 'Ю'
        50: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        22: SequenceLikelihood.POSITIVE,  # 'б'
        14: SequenceLikelihood.POSITIVE,  # 'в'
        21: SequenceLikelihood.LIKELY,  # 'г'
        13: SequenceLikelihood.POSITIVE,  # 'д'
        9: SequenceLikelihood.LIKELY,  # 'е'
        29: SequenceLikelihood.POSITIVE,  # 'ж'
        18: SequenceLikelihood.POSITIVE,  # 'з'
        25: SequenceLikelihood.NEGATIVE,  # 'й'
        7: SequenceLikelihood.POSITIVE,  # 'к'
        8: SequenceLikelihood.POSITIVE,  # 'л'
        15: SequenceLikelihood.POSITIVE,  # 'м'
        2: SequenceLikelihood.POSITIVE,  # 'н'
        12: SequenceLikelihood.POSITIVE,  # 'о'
        17: SequenceLikelihood.POSITIVE,  # 'п'
        4: SequenceLikelihood.POSITIVE,  # 'р'
        5: SequenceLikelihood.POSITIVE,  # 'с'
        10: SequenceLikelihood.LIKELY,  # 'т'
        16: SequenceLikelihood.POSITIVE,  # 'у'
        34: SequenceLikelihood.UNLIKELY,  # 'ф'
        27: SequenceLikelihood.LIKELY,  # 'х'
        20: SequenceLikelihood.LIKELY,  # 'ц'
        23: SequenceLikelihood.POSITIVE,  # 'ч'
        28: SequenceLikelihood.LIKELY,  # 'ш'
        6: SequenceLikelihood.POSITIVE,  # 'ы'
        26: SequenceLikelihood.UNLIKELY,  # 'ь'
        24: SequenceLikelihood.POSITIVE,  # 'э'
        30: SequenceLikelihood.UNLIKELY,  # 'ю'
        11: SequenceLikelihood.UNLIKELY,  # 'я'
        35: SequenceLikelihood.UNLIKELY,  # 'ё'
        3: SequenceLikelihood.UNLIKELY,  # 'і'
        19: SequenceLikelihood.UNLIKELY,  # 'ў'
    },
    9: {  # 'е'
        65: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ё'
        48: SequenceLikelihood.NEGATIVE,  # 'І'
        62: SequenceLikelihood.NEGATIVE,  # 'Ў'
        33: SequenceLikelihood.UNLIKELY,  # 'А'
        36: SequenceLikelihood.NEGATIVE,  # 'Б'
        40: SequenceLikelihood.UNLIKELY,  # 'В'
        43: SequenceLikelihood.NEGATIVE,  # 'Г'
        45: SequenceLikelihood.UNLIKELY,  # 'Д'
        56: SequenceLikelihood.NEGATIVE,  # 'Е'
        57: SequenceLikelihood.NEGATIVE,  # 'Ж'
        46: SequenceLikelihood.NEGATIVE,  # 'З'
        63: SequenceLikelihood.NEGATIVE,  # 'Й'
        37: SequenceLikelihood.NEGATIVE,  # 'К'
        44: SequenceLikelihood.NEGATIVE,  # 'Л'
        38: SequenceLikelihood.UNLIKELY,  # 'М'
        42: SequenceLikelihood.NEGATIVE,  # 'Н'
        58: SequenceLikelihood.NEGATIVE,  # 'О'
        32: SequenceLikelihood.NEGATIVE,  # 'П'
        41: SequenceLikelihood.UNLIKELY,  # 'Р'
        31: SequenceLikelihood.UNLIKELY,  # 'С'
        47: SequenceLikelihood.NEGATIVE,  # 'Т'
        39: SequenceLikelihood.NEGATIVE,  # 'У'
        49: SequenceLikelihood.UNLIKELY,  # 'Ф'
        53: SequenceLikelihood.NEGATIVE,  # 'Х'
        55: SequenceLikelihood.NEGATIVE,  # 'Ц'
        54: SequenceLikelihood.NEGATIVE,  # 'Ч'
        52: SequenceLikelihood.NEGATIVE,  # 'Ш'
        61: SequenceLikelihood.NEGATIVE,  # 'Ы'
        64: SequenceLikelihood.NEGATIVE,  # 'Ь'
        51: SequenceLikelihood.NEGATIVE,  # 'Э'
        59: SequenceLikelihood.NEGATIVE,  # 'Ю'
        50: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        22: SequenceLikelihood.POSITIVE,  # 'б'
        14: SequenceLikelihood.POSITIVE,  # 'в'
        21: SequenceLikelihood.POSITIVE,  # 'г'
        13: SequenceLikelihood.POSITIVE,  # 'д'
        9: SequenceLikelihood.LIKELY,  # 'е'
        29: SequenceLikelihood.POSITIVE,  # 'ж'
        18: SequenceLikelihood.POSITIVE,  # 'з'
        25: SequenceLikelihood.POSITIVE,  # 'й'
        7: SequenceLikelihood.POSITIVE,  # 'к'
        8: SequenceLikelihood.POSITIVE,  # 'л'
        15: SequenceLikelihood.POSITIVE,  # 'м'
        2: SequenceLikelihood.POSITIVE,  # 'н'
        12: SequenceLikelihood.LIKELY,  # 'о'
        17: SequenceLikelihood.POSITIVE,  # 'п'
        4: SequenceLikelihood.POSITIVE,  # 'р'
        5: SequenceLikelihood.POSITIVE,  # 'с'
        10: SequenceLikelihood.POSITIVE,  # 'т'
        16: SequenceLikelihood.UNLIKELY,  # 'у'
        34: SequenceLikelihood.LIKELY,  # 'ф'
        27: SequenceLikelihood.LIKELY,  # 'х'
        20: SequenceLikelihood.POSITIVE,  # 'ц'
        23: SequenceLikelihood.POSITIVE,  # 'ч'
        28: SequenceLikelihood.POSITIVE,  # 'ш'
        6: SequenceLikelihood.UNLIKELY,  # 'ы'
        26: SequenceLikelihood.NEGATIVE,  # 'ь'
        24: SequenceLikelihood.UNLIKELY,  # 'э'
        30: SequenceLikelihood.LIKELY,  # 'ю'
        11: SequenceLikelihood.POSITIVE,  # 'я'
        35: SequenceLikelihood.UNLIKELY,  # 'ё'
        3: SequenceLikelihood.LIKELY,  # 'і'
        19: SequenceLikelihood.POSITIVE,  # 'ў'
    },
    29: {  # 'ж'
        65: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ё'
        48: SequenceLikelihood.NEGATIVE,  # 'І'
        62: SequenceLikelihood.NEGATIVE,  # 'Ў'
        33: SequenceLikelihood.NEGATIVE,  # 'А'
        36: SequenceLikelihood.NEGATIVE,  # 'Б'
        40: SequenceLikelihood.NEGATIVE,  # 'В'
        43: SequenceLikelihood.NEGATIVE,  # 'Г'
        45: SequenceLikelihood.NEGATIVE,  # 'Д'
        56: SequenceLikelihood.NEGATIVE,  # 'Е'
        57: SequenceLikelihood.NEGATIVE,  # 'Ж'
        46: SequenceLikelihood.NEGATIVE,  # 'З'
        63: SequenceLikelihood.NEGATIVE,  # 'Й'
        37: SequenceLikelihood.NEGATIVE,  # 'К'
        44: SequenceLikelihood.NEGATIVE,  # 'Л'
        38: SequenceLikelihood.NEGATIVE,  # 'М'
        42: SequenceLikelihood.NEGATIVE,  # 'Н'
        58: SequenceLikelihood.NEGATIVE,  # 'О'
        32: SequenceLikelihood.NEGATIVE,  # 'П'
        41: SequenceLikelihood.NEGATIVE,  # 'Р'
        31: SequenceLikelihood.NEGATIVE,  # 'С'
        47: SequenceLikelihood.NEGATIVE,  # 'Т'
        39: SequenceLikelihood.NEGATIVE,  # 'У'
        49: SequenceLikelihood.NEGATIVE,  # 'Ф'
        53: SequenceLikelihood.NEGATIVE,  # 'Х'
        55: SequenceLikelihood.NEGATIVE,  # 'Ц'
        54: SequenceLikelihood.NEGATIVE,  # 'Ч'
        52: SequenceLikelihood.NEGATIVE,  # 'Ш'
        61: SequenceLikelihood.NEGATIVE,  # 'Ы'
        64: SequenceLikelihood.NEGATIVE,  # 'Ь'
        51: SequenceLikelihood.NEGATIVE,  # 'Э'
        59: SequenceLikelihood.NEGATIVE,  # 'Ю'
        50: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        22: SequenceLikelihood.LIKELY,  # 'б'
        14: SequenceLikelihood.LIKELY,  # 'в'
        21: SequenceLikelihood.UNLIKELY,  # 'г'
        13: SequenceLikelihood.LIKELY,  # 'д'
        9: SequenceLikelihood.LIKELY,  # 'е'
        29: SequenceLikelihood.LIKELY,  # 'ж'
        18: SequenceLikelihood.LIKELY,  # 'з'
        25: SequenceLikelihood.NEGATIVE,  # 'й'
        7: SequenceLikelihood.LIKELY,  # 'к'
        8: SequenceLikelihood.LIKELY,  # 'л'
        15: SequenceLikelihood.UNLIKELY,  # 'м'
        2: SequenceLikelihood.POSITIVE,  # 'н'
        12: SequenceLikelihood.POSITIVE,  # 'о'
        17: SequenceLikelihood.UNLIKELY,  # 'п'
        4: SequenceLikelihood.UNLIKELY,  # 'р'
        5: SequenceLikelihood.LIKELY,  # 'с'
        10: SequenceLikelihood.UNLIKELY,  # 'т'
        16: SequenceLikelihood.LIKELY,  # 'у'
        34: SequenceLikelihood.UNLIKELY,  # 'ф'
        27: SequenceLikelihood.UNLIKELY,  # 'х'
        20: SequenceLikelihood.LIKELY,  # 'ц'
        23: SequenceLikelihood.LIKELY,  # 'ч'
        28: SequenceLikelihood.UNLIKELY,  # 'ш'
        6: SequenceLikelihood.POSITIVE,  # 'ы'
        26: SequenceLikelihood.UNLIKELY,  # 'ь'
        24: SequenceLikelihood.POSITIVE,  # 'э'
        30: SequenceLikelihood.UNLIKELY,  # 'ю'
        11: SequenceLikelihood.UNLIKELY,  # 'я'
        35: SequenceLikelihood.UNLIKELY,  # 'ё'
        3: SequenceLikelihood.UNLIKELY,  # 'і'
        19: SequenceLikelihood.NEGATIVE,  # 'ў'
    },
    18: {  # 'з'
        65: SequenceLikelihood.UNLIKELY,  # 'ʼ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ё'
        48: SequenceLikelihood.UNLIKELY,  # 'І'
        62: SequenceLikelihood.NEGATIVE,  # 'Ў'
        33: SequenceLikelihood.UNLIKELY,  # 'А'
        36: SequenceLikelihood.UNLIKELY,  # 'Б'
        40: SequenceLikelihood.NEGATIVE,  # 'В'
        43: SequenceLikelihood.UNLIKELY,  # 'Г'
        45: SequenceLikelihood.NEGATIVE,  # 'Д'
        56: SequenceLikelihood.NEGATIVE,  # 'Е'
        57: SequenceLikelihood.NEGATIVE,  # 'Ж'
        46: SequenceLikelihood.NEGATIVE,  # 'З'
        63: SequenceLikelihood.NEGATIVE,  # 'Й'
        37: SequenceLikelihood.NEGATIVE,  # 'К'
        44: SequenceLikelihood.NEGATIVE,  # 'Л'
        38: SequenceLikelihood.NEGATIVE,  # 'М'
        42: SequenceLikelihood.NEGATIVE,  # 'Н'
        58: SequenceLikelihood.NEGATIVE,  # 'О'
        32: SequenceLikelihood.NEGATIVE,  # 'П'
        41: SequenceLikelihood.NEGATIVE,  # 'Р'
        31: SequenceLikelihood.NEGATIVE,  # 'С'
        47: SequenceLikelihood.NEGATIVE,  # 'Т'
        39: SequenceLikelihood.NEGATIVE,  # 'У'
        49: SequenceLikelihood.NEGATIVE,  # 'Ф'
        53: SequenceLikelihood.NEGATIVE,  # 'Х'
        55: SequenceLikelihood.NEGATIVE,  # 'Ц'
        54: SequenceLikelihood.NEGATIVE,  # 'Ч'
        52: SequenceLikelihood.NEGATIVE,  # 'Ш'
        61: SequenceLikelihood.NEGATIVE,  # 'Ы'
        64: SequenceLikelihood.NEGATIVE,  # 'Ь'
        51: SequenceLikelihood.UNLIKELY,  # 'Э'
        59: SequenceLikelihood.NEGATIVE,  # 'Ю'
        50: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        22: SequenceLikelihood.POSITIVE,  # 'б'
        14: SequenceLikelihood.POSITIVE,  # 'в'
        21: SequenceLikelihood.POSITIVE,  # 'г'
        13: SequenceLikelihood.POSITIVE,  # 'д'
        9: SequenceLikelihood.POSITIVE,  # 'е'
        29: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.LIKELY,  # 'з'
        25: SequenceLikelihood.NEGATIVE,  # 'й'
        7: SequenceLikelihood.POSITIVE,  # 'к'
        8: SequenceLikelihood.POSITIVE,  # 'л'
        15: SequenceLikelihood.POSITIVE,  # 'м'
        2: SequenceLikelihood.POSITIVE,  # 'н'
        12: SequenceLikelihood.POSITIVE,  # 'о'
        17: SequenceLikelihood.UNLIKELY,  # 'п'
        4: SequenceLikelihood.POSITIVE,  # 'р'
        5: SequenceLikelihood.LIKELY,  # 'с'
        10: SequenceLikelihood.UNLIKELY,  # 'т'
        16: SequenceLikelihood.POSITIVE,  # 'у'
        34: SequenceLikelihood.UNLIKELY,  # 'ф'
        27: SequenceLikelihood.UNLIKELY,  # 'х'
        20: SequenceLikelihood.UNLIKELY,  # 'ц'
        23: SequenceLikelihood.LIKELY,  # 'ч'
        28: SequenceLikelihood.UNLIKELY,  # 'ш'
        6: SequenceLikelihood.POSITIVE,  # 'ы'
        26: SequenceLikelihood.POSITIVE,  # 'ь'
        24: SequenceLikelihood.LIKELY,  # 'э'
        30: SequenceLikelihood.LIKELY,  # 'ю'
        11: SequenceLikelihood.POSITIVE,  # 'я'
        35: SequenceLikelihood.LIKELY,  # 'ё'
        3: SequenceLikelihood.POSITIVE,  # 'і'
        19: SequenceLikelihood.UNLIKELY,  # 'ў'
    },
    25: {  # 'й'
        65: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ё'
        48: SequenceLikelihood.NEGATIVE,  # 'І'
        62: SequenceLikelihood.NEGATIVE,  # 'Ў'
        33: SequenceLikelihood.UNLIKELY,  # 'А'
        36: SequenceLikelihood.NEGATIVE,  # 'Б'
        40: SequenceLikelihood.NEGATIVE,  # 'В'
        43: SequenceLikelihood.NEGATIVE,  # 'Г'
        45: SequenceLikelihood.NEGATIVE,  # 'Д'
        56: SequenceLikelihood.NEGATIVE,  # 'Е'
        57: SequenceLikelihood.NEGATIVE,  # 'Ж'
        46: SequenceLikelihood.NEGATIVE,  # 'З'
        63: SequenceLikelihood.UNLIKELY,  # 'Й'
        37: SequenceLikelihood.NEGATIVE,  # 'К'
        44: SequenceLikelihood.NEGATIVE,  # 'Л'
        38: SequenceLikelihood.NEGATIVE,  # 'М'
        42: SequenceLikelihood.UNLIKELY,  # 'Н'
        58: SequenceLikelihood.NEGATIVE,  # 'О'
        32: SequenceLikelihood.UNLIKELY,  # 'П'
        41: SequenceLikelihood.UNLIKELY,  # 'Р'
        31: SequenceLikelihood.NEGATIVE,  # 'С'
        47: SequenceLikelihood.NEGATIVE,  # 'Т'
        39: SequenceLikelihood.NEGATIVE,  # 'У'
        49: SequenceLikelihood.NEGATIVE,  # 'Ф'
        53: SequenceLikelihood.NEGATIVE,  # 'Х'
        55: SequenceLikelihood.NEGATIVE,  # 'Ц'
        54: SequenceLikelihood.NEGATIVE,  # 'Ч'
        52: SequenceLikelihood.NEGATIVE,  # 'Ш'
        61: SequenceLikelihood.NEGATIVE,  # 'Ы'
        64: SequenceLikelihood.NEGATIVE,  # 'Ь'
        51: SequenceLikelihood.NEGATIVE,  # 'Э'
        59: SequenceLikelihood.NEGATIVE,  # 'Ю'
        50: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.UNLIKELY,  # 'а'
        22: SequenceLikelihood.POSITIVE,  # 'б'
        14: SequenceLikelihood.LIKELY,  # 'в'
        21: SequenceLikelihood.LIKELY,  # 'г'
        13: SequenceLikelihood.LIKELY,  # 'д'
        9: SequenceLikelihood.UNLIKELY,  # 'е'
        29: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.LIKELY,  # 'з'
        25: SequenceLikelihood.UNLIKELY,  # 'й'
        7: SequenceLikelihood.LIKELY,  # 'к'
        8: SequenceLikelihood.POSITIVE,  # 'л'
        15: SequenceLikelihood.POSITIVE,  # 'м'
        2: SequenceLikelihood.POSITIVE,  # 'н'
        12: SequenceLikelihood.UNLIKELY,  # 'о'
        17: SequenceLikelihood.LIKELY,  # 'п'
        4: SequenceLikelihood.LIKELY,  # 'р'
        5: SequenceLikelihood.POSITIVE,  # 'с'
        10: SequenceLikelihood.LIKELY,  # 'т'
        16: SequenceLikelihood.UNLIKELY,  # 'у'
        34: SequenceLikelihood.UNLIKELY,  # 'ф'
        27: SequenceLikelihood.LIKELY,  # 'х'
        20: SequenceLikelihood.POSITIVE,  # 'ц'
        23: SequenceLikelihood.LIKELY,  # 'ч'
        28: SequenceLikelihood.POSITIVE,  # 'ш'
        6: SequenceLikelihood.UNLIKELY,  # 'ы'
        26: SequenceLikelihood.NEGATIVE,  # 'ь'
        24: SequenceLikelihood.UNLIKELY,  # 'э'
        30: SequenceLikelihood.UNLIKELY,  # 'ю'
        11: SequenceLikelihood.UNLIKELY,  # 'я'
        35: SequenceLikelihood.UNLIKELY,  # 'ё'
        3: SequenceLikelihood.UNLIKELY,  # 'і'
        19: SequenceLikelihood.NEGATIVE,  # 'ў'
    },
    7: {  # 'к'
        65: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ё'
        48: SequenceLikelihood.NEGATIVE,  # 'І'
        62: SequenceLikelihood.NEGATIVE,  # 'Ў'
        33: SequenceLikelihood.UNLIKELY,  # 'А'
        36: SequenceLikelihood.UNLIKELY,  # 'Б'
        40: SequenceLikelihood.UNLIKELY,  # 'В'
        43: SequenceLikelihood.UNLIKELY,  # 'Г'
        45: SequenceLikelihood.UNLIKELY,  # 'Д'
        56: SequenceLikelihood.NEGATIVE,  # 'Е'
        57: SequenceLikelihood.NEGATIVE,  # 'Ж'
        46: SequenceLikelihood.NEGATIVE,  # 'З'
        63: SequenceLikelihood.NEGATIVE,  # 'Й'
        37: SequenceLikelihood.UNLIKELY,  # 'К'
        44: SequenceLikelihood.NEGATIVE,  # 'Л'
        38: SequenceLikelihood.NEGATIVE,  # 'М'
        42: SequenceLikelihood.UNLIKELY,  # 'Н'
        58: SequenceLikelihood.NEGATIVE,  # 'О'
        32: SequenceLikelihood.UNLIKELY,  # 'П'
        41: SequenceLikelihood.NEGATIVE,  # 'Р'
        31: SequenceLikelihood.NEGATIVE,  # 'С'
        47: SequenceLikelihood.UNLIKELY,  # 'Т'
        39: SequenceLikelihood.NEGATIVE,  # 'У'
        49: SequenceLikelihood.UNLIKELY,  # 'Ф'
        53: SequenceLikelihood.NEGATIVE,  # 'Х'
        55: SequenceLikelihood.NEGATIVE,  # 'Ц'
        54: SequenceLikelihood.NEGATIVE,  # 'Ч'
        52: SequenceLikelihood.NEGATIVE,  # 'Ш'
        61: SequenceLikelihood.NEGATIVE,  # 'Ы'
        64: SequenceLikelihood.NEGATIVE,  # 'Ь'
        51: SequenceLikelihood.NEGATIVE,  # 'Э'
        59: SequenceLikelihood.NEGATIVE,  # 'Ю'
        50: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        22: SequenceLikelihood.UNLIKELY,  # 'б'
        14: SequenceLikelihood.POSITIVE,  # 'в'
        21: SequenceLikelihood.LIKELY,  # 'г'
        13: SequenceLikelihood.UNLIKELY,  # 'д'
        9: SequenceLikelihood.POSITIVE,  # 'е'
        29: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.LIKELY,  # 'з'
        25: SequenceLikelihood.UNLIKELY,  # 'й'
        7: SequenceLikelihood.LIKELY,  # 'к'
        8: SequenceLikelihood.POSITIVE,  # 'л'
        15: SequenceLikelihood.POSITIVE,  # 'м'
        2: SequenceLikelihood.POSITIVE,  # 'н'
        12: SequenceLikelihood.POSITIVE,  # 'о'
        17: SequenceLikelihood.UNLIKELY,  # 'п'
        4: SequenceLikelihood.POSITIVE,  # 'р'
        5: SequenceLikelihood.POSITIVE,  # 'с'
        10: SequenceLikelihood.POSITIVE,  # 'т'
        16: SequenceLikelihood.POSITIVE,  # 'у'
        34: SequenceLikelihood.UNLIKELY,  # 'ф'
        27: SequenceLikelihood.UNLIKELY,  # 'х'
        20: SequenceLikelihood.POSITIVE,  # 'ц'
        23: SequenceLikelihood.UNLIKELY,  # 'ч'
        28: SequenceLikelihood.LIKELY,  # 'ш'
        6: SequenceLikelihood.UNLIKELY,  # 'ы'
        26: SequenceLikelihood.UNLIKELY,  # 'ь'
        24: SequenceLikelihood.UNLIKELY,  # 'э'
        30: SequenceLikelihood.UNLIKELY,  # 'ю'
        11: SequenceLikelihood.UNLIKELY,  # 'я'
        35: SequenceLikelihood.UNLIKELY,  # 'ё'
        3: SequenceLikelihood.POSITIVE,  # 'і'
        19: SequenceLikelihood.UNLIKELY,  # 'ў'
    },
    8: {  # 'л'
        65: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ё'
        48: SequenceLikelihood.UNLIKELY,  # 'І'
        62: SequenceLikelihood.NEGATIVE,  # 'Ў'
        33: SequenceLikelihood.UNLIKELY,  # 'А'
        36: SequenceLikelihood.NEGATIVE,  # 'Б'
        40: SequenceLikelihood.UNLIKELY,  # 'В'
        43: SequenceLikelihood.UNLIKELY,  # 'Г'
        45: SequenceLikelihood.UNLIKELY,  # 'Д'
        56: SequenceLikelihood.NEGATIVE,  # 'Е'
        57: SequenceLikelihood.NEGATIVE,  # 'Ж'
        46: SequenceLikelihood.NEGATIVE,  # 'З'
        63: SequenceLikelihood.NEGATIVE,  # 'Й'
        37: SequenceLikelihood.UNLIKELY,  # 'К'
        44: SequenceLikelihood.NEGATIVE,  # 'Л'
        38: SequenceLikelihood.NEGATIVE,  # 'М'
        42: SequenceLikelihood.UNLIKELY,  # 'Н'
        58: SequenceLikelihood.UNLIKELY,  # 'О'
        32: SequenceLikelihood.UNLIKELY,  # 'П'
        41: SequenceLikelihood.UNLIKELY,  # 'Р'
        31: SequenceLikelihood.UNLIKELY,  # 'С'
        47: SequenceLikelihood.UNLIKELY,  # 'Т'
        39: SequenceLikelihood.NEGATIVE,  # 'У'
        49: SequenceLikelihood.UNLIKELY,  # 'Ф'
        53: SequenceLikelihood.NEGATIVE,  # 'Х'
        55: SequenceLikelihood.NEGATIVE,  # 'Ц'
        54: SequenceLikelihood.NEGATIVE,  # 'Ч'
        52: SequenceLikelihood.NEGATIVE,  # 'Ш'
        61: SequenceLikelihood.NEGATIVE,  # 'Ы'
        64: SequenceLikelihood.NEGATIVE,  # 'Ь'
        51: SequenceLikelihood.LIKELY,  # 'Э'
        59: SequenceLikelihood.NEGATIVE,  # 'Ю'
        50: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        22: SequenceLikelihood.LIKELY,  # 'б'
        14: SequenceLikelihood.LIKELY,  # 'в'
        21: SequenceLikelihood.LIKELY,  # 'г'
        13: SequenceLikelihood.LIKELY,  # 'д'
        9: SequenceLikelihood.POSITIVE,  # 'е'
        29: SequenceLikelihood.LIKELY,  # 'ж'
        18: SequenceLikelihood.LIKELY,  # 'з'
        25: SequenceLikelihood.UNLIKELY,  # 'й'
        7: SequenceLikelihood.POSITIVE,  # 'к'
        8: SequenceLikelihood.LIKELY,  # 'л'
        15: SequenceLikelihood.LIKELY,  # 'м'
        2: SequenceLikelihood.LIKELY,  # 'н'
        12: SequenceLikelihood.POSITIVE,  # 'о'
        17: SequenceLikelihood.UNLIKELY,  # 'п'
        4: SequenceLikelihood.LIKELY,  # 'р'
        5: SequenceLikelihood.LIKELY,  # 'с'
        10: SequenceLikelihood.LIKELY,  # 'т'
        16: SequenceLikelihood.POSITIVE,  # 'у'
        34: SequenceLikelihood.LIKELY,  # 'ф'
        27: SequenceLikelihood.UNLIKELY,  # 'х'
        20: SequenceLikelihood.LIKELY,  # 'ц'
        23: SequenceLikelihood.LIKELY,  # 'ч'
        28: SequenceLikelihood.UNLIKELY,  # 'ш'
        6: SequenceLikelihood.POSITIVE,  # 'ы'
        26: SequenceLikelihood.POSITIVE,  # 'ь'
        24: SequenceLikelihood.LIKELY,  # 'э'
        30: SequenceLikelihood.POSITIVE,  # 'ю'
        11: SequenceLikelihood.POSITIVE,  # 'я'
        35: SequenceLikelihood.POSITIVE,  # 'ё'
        3: SequenceLikelihood.POSITIVE,  # 'і'
        19: SequenceLikelihood.NEGATIVE,  # 'ў'
    },
    15: {  # 'м'
        65: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ё'
        48: SequenceLikelihood.NEGATIVE,  # 'І'
        62: SequenceLikelihood.NEGATIVE,  # 'Ў'
        33: SequenceLikelihood.UNLIKELY,  # 'А'
        36: SequenceLikelihood.NEGATIVE,  # 'Б'
        40: SequenceLikelihood.UNLIKELY,  # 'В'
        43: SequenceLikelihood.UNLIKELY,  # 'Г'
        45: SequenceLikelihood.UNLIKELY,  # 'Д'
        56: SequenceLikelihood.NEGATIVE,  # 'Е'
        57: SequenceLikelihood.NEGATIVE,  # 'Ж'
        46: SequenceLikelihood.NEGATIVE,  # 'З'
        63: SequenceLikelihood.NEGATIVE,  # 'Й'
        37: SequenceLikelihood.NEGATIVE,  # 'К'
        44: SequenceLikelihood.NEGATIVE,  # 'Л'
        38: SequenceLikelihood.NEGATIVE,  # 'М'
        42: SequenceLikelihood.NEGATIVE,  # 'Н'
        58: SequenceLikelihood.NEGATIVE,  # 'О'
        32: SequenceLikelihood.NEGATIVE,  # 'П'
        41: SequenceLikelihood.UNLIKELY,  # 'Р'
        31: SequenceLikelihood.NEGATIVE,  # 'С'
        47: SequenceLikelihood.NEGATIVE,  # 'Т'
        39: SequenceLikelihood.NEGATIVE,  # 'У'
        49: SequenceLikelihood.NEGATIVE,  # 'Ф'
        53: SequenceLikelihood.NEGATIVE,  # 'Х'
        55: SequenceLikelihood.NEGATIVE,  # 'Ц'
        54: SequenceLikelihood.NEGATIVE,  # 'Ч'
        52: SequenceLikelihood.NEGATIVE,  # 'Ш'
        61: SequenceLikelihood.NEGATIVE,  # 'Ы'
        64: SequenceLikelihood.NEGATIVE,  # 'Ь'
        51: SequenceLikelihood.NEGATIVE,  # 'Э'
        59: SequenceLikelihood.NEGATIVE,  # 'Ю'
        50: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        22: SequenceLikelihood.POSITIVE,  # 'б'
        14: SequenceLikelihood.LIKELY,  # 'в'
        21: SequenceLikelihood.UNLIKELY,  # 'г'
        13: SequenceLikelihood.UNLIKELY,  # 'д'
        9: SequenceLikelihood.POSITIVE,  # 'е'
        29: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        25: SequenceLikelihood.UNLIKELY,  # 'й'
        7: SequenceLikelihood.POSITIVE,  # 'к'
        8: SequenceLikelihood.POSITIVE,  # 'л'
        15: SequenceLikelihood.LIKELY,  # 'м'
        2: SequenceLikelihood.POSITIVE,  # 'н'
        12: SequenceLikelihood.POSITIVE,  # 'о'
        17: SequenceLikelihood.POSITIVE,  # 'п'
        4: SequenceLikelihood.LIKELY,  # 'р'
        5: SequenceLikelihood.POSITIVE,  # 'с'
        10: SequenceLikelihood.UNLIKELY,  # 'т'
        16: SequenceLikelihood.POSITIVE,  # 'у'
        34: SequenceLikelihood.LIKELY,  # 'ф'
        27: SequenceLikelihood.UNLIKELY,  # 'х'
        20: SequenceLikelihood.LIKELY,  # 'ц'
        23: SequenceLikelihood.LIKELY,  # 'ч'
        28: SequenceLikelihood.LIKELY,  # 'ш'
        6: SequenceLikelihood.POSITIVE,  # 'ы'
        26: SequenceLikelihood.UNLIKELY,  # 'ь'
        24: SequenceLikelihood.LIKELY,  # 'э'
        30: SequenceLikelihood.LIKELY,  # 'ю'
        11: SequenceLikelihood.POSITIVE,  # 'я'
        35: SequenceLikelihood.LIKELY,  # 'ё'
        3: SequenceLikelihood.POSITIVE,  # 'і'
        19: SequenceLikelihood.UNLIKELY,  # 'ў'
    },
    2: {  # 'н'
        65: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ё'
        48: SequenceLikelihood.NEGATIVE,  # 'І'
        62: SequenceLikelihood.NEGATIVE,  # 'Ў'
        33: SequenceLikelihood.NEGATIVE,  # 'А'
        36: SequenceLikelihood.UNLIKELY,  # 'Б'
        40: SequenceLikelihood.NEGATIVE,  # 'В'
        43: SequenceLikelihood.UNLIKELY,  # 'Г'
        45: SequenceLikelihood.UNLIKELY,  # 'Д'
        56: SequenceLikelihood.UNLIKELY,  # 'Е'
        57: SequenceLikelihood.UNLIKELY,  # 'Ж'
        46: SequenceLikelihood.NEGATIVE,  # 'З'
        63: SequenceLikelihood.NEGATIVE,  # 'Й'
        37: SequenceLikelihood.NEGATIVE,  # 'К'
        44: SequenceLikelihood.NEGATIVE,  # 'Л'
        38: SequenceLikelihood.UNLIKELY,  # 'М'
        42: SequenceLikelihood.NEGATIVE,  # 'Н'
        58: SequenceLikelihood.NEGATIVE,  # 'О'
        32: SequenceLikelihood.NEGATIVE,  # 'П'
        41: SequenceLikelihood.UNLIKELY,  # 'Р'
        31: SequenceLikelihood.NEGATIVE,  # 'С'
        47: SequenceLikelihood.UNLIKELY,  # 'Т'
        39: SequenceLikelihood.UNLIKELY,  # 'У'
        49: SequenceLikelihood.NEGATIVE,  # 'Ф'
        53: SequenceLikelihood.NEGATIVE,  # 'Х'
        55: SequenceLikelihood.NEGATIVE,  # 'Ц'
        54: SequenceLikelihood.NEGATIVE,  # 'Ч'
        52: SequenceLikelihood.NEGATIVE,  # 'Ш'
        61: SequenceLikelihood.NEGATIVE,  # 'Ы'
        64: SequenceLikelihood.NEGATIVE,  # 'Ь'
        51: SequenceLikelihood.NEGATIVE,  # 'Э'
        59: SequenceLikelihood.NEGATIVE,  # 'Ю'
        50: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        22: SequenceLikelihood.LIKELY,  # 'б'
        14: SequenceLikelihood.LIKELY,  # 'в'
        21: SequenceLikelihood.POSITIVE,  # 'г'
        13: SequenceLikelihood.POSITIVE,  # 'д'
        9: SequenceLikelihood.POSITIVE,  # 'е'
        29: SequenceLikelihood.LIKELY,  # 'ж'
        18: SequenceLikelihood.LIKELY,  # 'з'
        25: SequenceLikelihood.UNLIKELY,  # 'й'
        7: SequenceLikelihood.POSITIVE,  # 'к'
        8: SequenceLikelihood.LIKELY,  # 'л'
        15: SequenceLikelihood.UNLIKELY,  # 'м'
        2: SequenceLikelihood.POSITIVE,  # 'н'
        12: SequenceLikelihood.POSITIVE,  # 'о'
        17: SequenceLikelihood.UNLIKELY,  # 'п'
        4: SequenceLikelihood.LIKELY,  # 'р'
        5: SequenceLikelihood.POSITIVE,  # 'с'
        10: SequenceLikelihood.POSITIVE,  # 'т'
        16: SequenceLikelihood.POSITIVE,  # 'у'
        34: SequenceLikelihood.POSITIVE,  # 'ф'
        27: SequenceLikelihood.LIKELY,  # 'х'
        20: SequenceLikelihood.POSITIVE,  # 'ц'
        23: SequenceLikelihood.POSITIVE,  # 'ч'
        28: SequenceLikelihood.POSITIVE,  # 'ш'
        6: SequenceLikelihood.POSITIVE,  # 'ы'
        26: SequenceLikelihood.POSITIVE,  # 'ь'
        24: SequenceLikelihood.LIKELY,  # 'э'
        30: SequenceLikelihood.POSITIVE,  # 'ю'
        11: SequenceLikelihood.POSITIVE,  # 'я'
        35: SequenceLikelihood.POSITIVE,  # 'ё'
        3: SequenceLikelihood.POSITIVE,  # 'і'
        19: SequenceLikelihood.UNLIKELY,  # 'ў'
    },
    12: {  # 'о'
        65: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ё'
        48: SequenceLikelihood.NEGATIVE,  # 'І'
        62: SequenceLikelihood.NEGATIVE,  # 'Ў'
        33: SequenceLikelihood.UNLIKELY,  # 'А'
        36: SequenceLikelihood.NEGATIVE,  # 'Б'
        40: SequenceLikelihood.UNLIKELY,  # 'В'
        43: SequenceLikelihood.NEGATIVE,  # 'Г'
        45: SequenceLikelihood.NEGATIVE,  # 'Д'
        56: SequenceLikelihood.NEGATIVE,  # 'Е'
        57: SequenceLikelihood.NEGATIVE,  # 'Ж'
        46: SequenceLikelihood.NEGATIVE,  # 'З'
        63: SequenceLikelihood.NEGATIVE,  # 'Й'
        37: SequenceLikelihood.UNLIKELY,  # 'К'
        44: SequenceLikelihood.UNLIKELY,  # 'Л'
        38: SequenceLikelihood.UNLIKELY,  # 'М'
        42: SequenceLikelihood.NEGATIVE,  # 'Н'
        58: SequenceLikelihood.NEGATIVE,  # 'О'
        32: SequenceLikelihood.UNLIKELY,  # 'П'
        41: SequenceLikelihood.NEGATIVE,  # 'Р'
        31: SequenceLikelihood.NEGATIVE,  # 'С'
        47: SequenceLikelihood.NEGATIVE,  # 'Т'
        39: SequenceLikelihood.NEGATIVE,  # 'У'
        49: SequenceLikelihood.NEGATIVE,  # 'Ф'
        53: SequenceLikelihood.NEGATIVE,  # 'Х'
        55: SequenceLikelihood.NEGATIVE,  # 'Ц'
        54: SequenceLikelihood.NEGATIVE,  # 'Ч'
        52: SequenceLikelihood.NEGATIVE,  # 'Ш'
        61: SequenceLikelihood.NEGATIVE,  # 'Ы'
        64: SequenceLikelihood.NEGATIVE,  # 'Ь'
        51: SequenceLikelihood.NEGATIVE,  # 'Э'
        59: SequenceLikelihood.NEGATIVE,  # 'Ю'
        50: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.LIKELY,  # 'а'
        22: SequenceLikelihood.POSITIVE,  # 'б'
        14: SequenceLikelihood.POSITIVE,  # 'в'
        21: SequenceLikelihood.POSITIVE,  # 'г'
        13: SequenceLikelihood.POSITIVE,  # 'д'
        9: SequenceLikelihood.POSITIVE,  # 'е'
        29: SequenceLikelihood.POSITIVE,  # 'ж'
        18: SequenceLikelihood.POSITIVE,  # 'з'
        25: SequenceLikelihood.POSITIVE,  # 'й'
        7: SequenceLikelihood.POSITIVE,  # 'к'
        8: SequenceLikelihood.POSITIVE,  # 'л'
        15: SequenceLikelihood.POSITIVE,  # 'м'
        2: SequenceLikelihood.POSITIVE,  # 'н'
        12: SequenceLikelihood.UNLIKELY,  # 'о'
        17: SequenceLikelihood.POSITIVE,  # 'п'
        4: SequenceLikelihood.POSITIVE,  # 'р'
        5: SequenceLikelihood.POSITIVE,  # 'с'
        10: SequenceLikelihood.POSITIVE,  # 'т'
        16: SequenceLikelihood.LIKELY,  # 'у'
        34: SequenceLikelihood.LIKELY,  # 'ф'
        27: SequenceLikelihood.LIKELY,  # 'х'
        20: SequenceLikelihood.POSITIVE,  # 'ц'
        23: SequenceLikelihood.POSITIVE,  # 'ч'
        28: SequenceLikelihood.POSITIVE,  # 'ш'
        6: SequenceLikelihood.UNLIKELY,  # 'ы'
        26: SequenceLikelihood.UNLIKELY,  # 'ь'
        24: SequenceLikelihood.UNLIKELY,  # 'э'
        30: SequenceLikelihood.LIKELY,  # 'ю'
        11: SequenceLikelihood.LIKELY,  # 'я'
        35: SequenceLikelihood.UNLIKELY,  # 'ё'
        3: SequenceLikelihood.LIKELY,  # 'і'
        19: SequenceLikelihood.POSITIVE,  # 'ў'
    },
    17: {  # 'п'
        65: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ё'
        48: SequenceLikelihood.NEGATIVE,  # 'І'
        62: SequenceLikelihood.NEGATIVE,  # 'Ў'
        33: SequenceLikelihood.UNLIKELY,  # 'А'
        36: SequenceLikelihood.NEGATIVE,  # 'Б'
        40: SequenceLikelihood.NEGATIVE,  # 'В'
        43: SequenceLikelihood.NEGATIVE,  # 'Г'
        45: SequenceLikelihood.NEGATIVE,  # 'Д'
        56: SequenceLikelihood.NEGATIVE,  # 'Е'
        57: SequenceLikelihood.NEGATIVE,  # 'Ж'
        46: SequenceLikelihood.NEGATIVE,  # 'З'
        63: SequenceLikelihood.NEGATIVE,  # 'Й'
        37: SequenceLikelihood.UNLIKELY,  # 'К'
        44: SequenceLikelihood.NEGATIVE,  # 'Л'
        38: SequenceLikelihood.NEGATIVE,  # 'М'
        42: SequenceLikelihood.NEGATIVE,  # 'Н'
        58: SequenceLikelihood.NEGATIVE,  # 'О'
        32: SequenceLikelihood.UNLIKELY,  # 'П'
        41: SequenceLikelihood.UNLIKELY,  # 'Р'
        31: SequenceLikelihood.NEGATIVE,  # 'С'
        47: SequenceLikelihood.NEGATIVE,  # 'Т'
        39: SequenceLikelihood.NEGATIVE,  # 'У'
        49: SequenceLikelihood.NEGATIVE,  # 'Ф'
        53: SequenceLikelihood.NEGATIVE,  # 'Х'
        55: SequenceLikelihood.NEGATIVE,  # 'Ц'
        54: SequenceLikelihood.NEGATIVE,  # 'Ч'
        52: SequenceLikelihood.NEGATIVE,  # 'Ш'
        61: SequenceLikelihood.NEGATIVE,  # 'Ы'
        64: SequenceLikelihood.NEGATIVE,  # 'Ь'
        51: SequenceLikelihood.NEGATIVE,  # 'Э'
        59: SequenceLikelihood.NEGATIVE,  # 'Ю'
        50: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        22: SequenceLikelihood.UNLIKELY,  # 'б'
        14: SequenceLikelihood.UNLIKELY,  # 'в'
        21: SequenceLikelihood.UNLIKELY,  # 'г'
        13: SequenceLikelihood.UNLIKELY,  # 'д'
        9: SequenceLikelihood.POSITIVE,  # 'е'
        29: SequenceLikelihood.NEGATIVE,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        25: SequenceLikelihood.NEGATIVE,  # 'й'
        7: SequenceLikelihood.LIKELY,  # 'к'
        8: SequenceLikelihood.POSITIVE,  # 'л'
        15: SequenceLikelihood.UNLIKELY,  # 'м'
        2: SequenceLikelihood.POSITIVE,  # 'н'
        12: SequenceLikelihood.POSITIVE,  # 'о'
        17: SequenceLikelihood.UNLIKELY,  # 'п'
        4: SequenceLikelihood.POSITIVE,  # 'р'
        5: SequenceLikelihood.LIKELY,  # 'с'
        10: SequenceLikelihood.LIKELY,  # 'т'
        16: SequenceLikelihood.POSITIVE,  # 'у'
        34: SequenceLikelihood.UNLIKELY,  # 'ф'
        27: SequenceLikelihood.UNLIKELY,  # 'х'
        20: SequenceLikelihood.LIKELY,  # 'ц'
        23: SequenceLikelihood.LIKELY,  # 'ч'
        28: SequenceLikelihood.LIKELY,  # 'ш'
        6: SequenceLikelihood.POSITIVE,  # 'ы'
        26: SequenceLikelihood.UNLIKELY,  # 'ь'
        24: SequenceLikelihood.LIKELY,  # 'э'
        30: SequenceLikelihood.UNLIKELY,  # 'ю'
        11: SequenceLikelihood.POSITIVE,  # 'я'
        35: SequenceLikelihood.UNLIKELY,  # 'ё'
        3: SequenceLikelihood.POSITIVE,  # 'і'
        19: SequenceLikelihood.NEGATIVE,  # 'ў'
    },
    4: {  # 'р'
        65: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ё'
        48: SequenceLikelihood.NEGATIVE,  # 'І'
        62: SequenceLikelihood.NEGATIVE,  # 'Ў'
        33: SequenceLikelihood.UNLIKELY,  # 'А'
        36: SequenceLikelihood.UNLIKELY,  # 'Б'
        40: SequenceLikelihood.UNLIKELY,  # 'В'
        43: SequenceLikelihood.UNLIKELY,  # 'Г'
        45: SequenceLikelihood.UNLIKELY,  # 'Д'
        56: SequenceLikelihood.NEGATIVE,  # 'Е'
        57: SequenceLikelihood.NEGATIVE,  # 'Ж'
        46: SequenceLikelihood.UNLIKELY,  # 'З'
        63: SequenceLikelihood.NEGATIVE,  # 'Й'
        37: SequenceLikelihood.UNLIKELY,  # 'К'
        44: SequenceLikelihood.UNLIKELY,  # 'Л'
        38: SequenceLikelihood.UNLIKELY,  # 'М'
        42: SequenceLikelihood.UNLIKELY,  # 'Н'
        58: SequenceLikelihood.NEGATIVE,  # 'О'
        32: SequenceLikelihood.NEGATIVE,  # 'П'
        41: SequenceLikelihood.UNLIKELY,  # 'Р'
        31: SequenceLikelihood.UNLIKELY,  # 'С'
        47: SequenceLikelihood.NEGATIVE,  # 'Т'
        39: SequenceLikelihood.NEGATIVE,  # 'У'
        49: SequenceLikelihood.NEGATIVE,  # 'Ф'
        53: SequenceLikelihood.NEGATIVE,  # 'Х'
        55: SequenceLikelihood.NEGATIVE,  # 'Ц'
        54: SequenceLikelihood.NEGATIVE,  # 'Ч'
        52: SequenceLikelihood.NEGATIVE,  # 'Ш'
        61: SequenceLikelihood.UNLIKELY,  # 'Ы'
        64: SequenceLikelihood.NEGATIVE,  # 'Ь'
        51: SequenceLikelihood.UNLIKELY,  # 'Э'
        59: SequenceLikelihood.NEGATIVE,  # 'Ю'
        50: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        22: SequenceLikelihood.POSITIVE,  # 'б'
        14: SequenceLikelihood.POSITIVE,  # 'в'
        21: SequenceLikelihood.POSITIVE,  # 'г'
        13: SequenceLikelihood.POSITIVE,  # 'д'
        9: SequenceLikelihood.POSITIVE,  # 'е'
        29: SequenceLikelihood.POSITIVE,  # 'ж'
        18: SequenceLikelihood.LIKELY,  # 'з'
        25: SequenceLikelihood.UNLIKELY,  # 'й'
        7: SequenceLikelihood.POSITIVE,  # 'к'
        8: SequenceLikelihood.POSITIVE,  # 'л'
        15: SequenceLikelihood.POSITIVE,  # 'м'
        2: SequenceLikelihood.POSITIVE,  # 'н'
        12: SequenceLikelihood.POSITIVE,  # 'о'
        17: SequenceLikelihood.LIKELY,  # 'п'
        4: SequenceLikelihood.LIKELY,  # 'р'
        5: SequenceLikelihood.POSITIVE,  # 'с'
        10: SequenceLikelihood.POSITIVE,  # 'т'
        16: SequenceLikelihood.POSITIVE,  # 'у'
        34: SequenceLikelihood.LIKELY,  # 'ф'
        27: SequenceLikelihood.POSITIVE,  # 'х'
        20: SequenceLikelihood.POSITIVE,  # 'ц'
        23: SequenceLikelihood.POSITIVE,  # 'ч'
        28: SequenceLikelihood.POSITIVE,  # 'ш'
        6: SequenceLikelihood.POSITIVE,  # 'ы'
        26: SequenceLikelihood.LIKELY,  # 'ь'
        24: SequenceLikelihood.POSITIVE,  # 'э'
        30: SequenceLikelihood.UNLIKELY,  # 'ю'
        11: SequenceLikelihood.LIKELY,  # 'я'
        35: SequenceLikelihood.UNLIKELY,  # 'ё'
        3: SequenceLikelihood.UNLIKELY,  # 'і'
        19: SequenceLikelihood.UNLIKELY,  # 'ў'
    },
    5: {  # 'с'
        65: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ё'
        48: SequenceLikelihood.NEGATIVE,  # 'І'
        62: SequenceLikelihood.NEGATIVE,  # 'Ў'
        33: SequenceLikelihood.UNLIKELY,  # 'А'
        36: SequenceLikelihood.UNLIKELY,  # 'Б'
        40: SequenceLikelihood.UNLIKELY,  # 'В'
        43: SequenceLikelihood.UNLIKELY,  # 'Г'
        45: SequenceLikelihood.UNLIKELY,  # 'Д'
        56: SequenceLikelihood.NEGATIVE,  # 'Е'
        57: SequenceLikelihood.UNLIKELY,  # 'Ж'
        46: SequenceLikelihood.NEGATIVE,  # 'З'
        63: SequenceLikelihood.NEGATIVE,  # 'Й'
        37: SequenceLikelihood.NEGATIVE,  # 'К'
        44: SequenceLikelihood.NEGATIVE,  # 'Л'
        38: SequenceLikelihood.NEGATIVE,  # 'М'
        42: SequenceLikelihood.NEGATIVE,  # 'Н'
        58: SequenceLikelihood.NEGATIVE,  # 'О'
        32: SequenceLikelihood.UNLIKELY,  # 'П'
        41: SequenceLikelihood.NEGATIVE,  # 'Р'
        31: SequenceLikelihood.NEGATIVE,  # 'С'
        47: SequenceLikelihood.UNLIKELY,  # 'Т'
        39: SequenceLikelihood.UNLIKELY,  # 'У'
        49: SequenceLikelihood.NEGATIVE,  # 'Ф'
        53: SequenceLikelihood.NEGATIVE,  # 'Х'
        55: SequenceLikelihood.NEGATIVE,  # 'Ц'
        54: SequenceLikelihood.NEGATIVE,  # 'Ч'
        52: SequenceLikelihood.NEGATIVE,  # 'Ш'
        61: SequenceLikelihood.NEGATIVE,  # 'Ы'
        64: SequenceLikelihood.NEGATIVE,  # 'Ь'
        51: SequenceLikelihood.NEGATIVE,  # 'Э'
        59: SequenceLikelihood.NEGATIVE,  # 'Ю'
        50: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        22: SequenceLikelihood.LIKELY,  # 'б'
        14: SequenceLikelihood.POSITIVE,  # 'в'
        21: SequenceLikelihood.UNLIKELY,  # 'г'
        13: SequenceLikelihood.LIKELY,  # 'д'
        9: SequenceLikelihood.POSITIVE,  # 'е'
        29: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        25: SequenceLikelihood.UNLIKELY,  # 'й'
        7: SequenceLikelihood.POSITIVE,  # 'к'
        8: SequenceLikelihood.POSITIVE,  # 'л'
        15: SequenceLikelihood.POSITIVE,  # 'м'
        2: SequenceLikelihood.POSITIVE,  # 'н'
        12: SequenceLikelihood.POSITIVE,  # 'о'
        17: SequenceLikelihood.POSITIVE,  # 'п'
        4: SequenceLikelihood.LIKELY,  # 'р'
        5: SequenceLikelihood.POSITIVE,  # 'с'
        10: SequenceLikelihood.POSITIVE,  # 'т'
        16: SequenceLikelihood.POSITIVE,  # 'у'
        34: SequenceLikelihood.LIKELY,  # 'ф'
        27: SequenceLikelihood.POSITIVE,  # 'х'
        20: SequenceLikelihood.POSITIVE,  # 'ц'
        23: SequenceLikelihood.LIKELY,  # 'ч'
        28: SequenceLikelihood.LIKELY,  # 'ш'
        6: SequenceLikelihood.POSITIVE,  # 'ы'
        26: SequenceLikelihood.POSITIVE,  # 'ь'
        24: SequenceLikelihood.LIKELY,  # 'э'
        30: SequenceLikelihood.LIKELY,  # 'ю'
        11: SequenceLikelihood.POSITIVE,  # 'я'
        35: SequenceLikelihood.POSITIVE,  # 'ё'
        3: SequenceLikelihood.POSITIVE,  # 'і'
        19: SequenceLikelihood.UNLIKELY,  # 'ў'
    },
    10: {  # 'т'
        65: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ё'
        48: SequenceLikelihood.UNLIKELY,  # 'І'
        62: SequenceLikelihood.NEGATIVE,  # 'Ў'
        33: SequenceLikelihood.UNLIKELY,  # 'А'
        36: SequenceLikelihood.UNLIKELY,  # 'Б'
        40: SequenceLikelihood.NEGATIVE,  # 'В'
        43: SequenceLikelihood.UNLIKELY,  # 'Г'
        45: SequenceLikelihood.UNLIKELY,  # 'Д'
        56: SequenceLikelihood.NEGATIVE,  # 'Е'
        57: SequenceLikelihood.NEGATIVE,  # 'Ж'
        46: SequenceLikelihood.NEGATIVE,  # 'З'
        63: SequenceLikelihood.NEGATIVE,  # 'Й'
        37: SequenceLikelihood.UNLIKELY,  # 'К'
        44: SequenceLikelihood.UNLIKELY,  # 'Л'
        38: SequenceLikelihood.NEGATIVE,  # 'М'
        42: SequenceLikelihood.UNLIKELY,  # 'Н'
        58: SequenceLikelihood.NEGATIVE,  # 'О'
        32: SequenceLikelihood.NEGATIVE,  # 'П'
        41: SequenceLikelihood.UNLIKELY,  # 'Р'
        31: SequenceLikelihood.UNLIKELY,  # 'С'
        47: SequenceLikelihood.NEGATIVE,  # 'Т'
        39: SequenceLikelihood.NEGATIVE,  # 'У'
        49: SequenceLikelihood.NEGATIVE,  # 'Ф'
        53: SequenceLikelihood.NEGATIVE,  # 'Х'
        55: SequenceLikelihood.NEGATIVE,  # 'Ц'
        54: SequenceLikelihood.NEGATIVE,  # 'Ч'
        52: SequenceLikelihood.NEGATIVE,  # 'Ш'
        61: SequenceLikelihood.NEGATIVE,  # 'Ы'
        64: SequenceLikelihood.NEGATIVE,  # 'Ь'
        51: SequenceLikelihood.NEGATIVE,  # 'Э'
        59: SequenceLikelihood.NEGATIVE,  # 'Ю'
        50: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        22: SequenceLikelihood.LIKELY,  # 'б'
        14: SequenceLikelihood.POSITIVE,  # 'в'
        21: SequenceLikelihood.LIKELY,  # 'г'
        13: SequenceLikelihood.UNLIKELY,  # 'д'
        9: SequenceLikelihood.LIKELY,  # 'е'
        29: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        25: SequenceLikelihood.UNLIKELY,  # 'й'
        7: SequenceLikelihood.POSITIVE,  # 'к'
        8: SequenceLikelihood.POSITIVE,  # 'л'
        15: SequenceLikelihood.LIKELY,  # 'м'
        2: SequenceLikelihood.POSITIVE,  # 'н'
        12: SequenceLikelihood.POSITIVE,  # 'о'
        17: SequenceLikelihood.UNLIKELY,  # 'п'
        4: SequenceLikelihood.POSITIVE,  # 'р'
        5: SequenceLikelihood.LIKELY,  # 'с'
        10: SequenceLikelihood.UNLIKELY,  # 'т'
        16: SequenceLikelihood.POSITIVE,  # 'у'
        34: SequenceLikelihood.LIKELY,  # 'ф'
        27: SequenceLikelihood.LIKELY,  # 'х'
        20: SequenceLikelihood.LIKELY,  # 'ц'
        23: SequenceLikelihood.LIKELY,  # 'ч'
        28: SequenceLikelihood.UNLIKELY,  # 'ш'
        6: SequenceLikelihood.POSITIVE,  # 'ы'
        26: SequenceLikelihood.LIKELY,  # 'ь'
        24: SequenceLikelihood.POSITIVE,  # 'э'
        30: SequenceLikelihood.UNLIKELY,  # 'ю'
        11: SequenceLikelihood.UNLIKELY,  # 'я'
        35: SequenceLikelihood.UNLIKELY,  # 'ё'
        3: SequenceLikelihood.UNLIKELY,  # 'і'
        19: SequenceLikelihood.NEGATIVE,  # 'ў'
    },
    16: {  # 'у'
        65: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ё'
        48: SequenceLikelihood.NEGATIVE,  # 'І'
        62: SequenceLikelihood.NEGATIVE,  # 'Ў'
        33: SequenceLikelihood.UNLIKELY,  # 'А'
        36: SequenceLikelihood.NEGATIVE,  # 'Б'
        40: SequenceLikelihood.NEGATIVE,  # 'В'
        43: SequenceLikelihood.NEGATIVE,  # 'Г'
        45: SequenceLikelihood.NEGATIVE,  # 'Д'
        56: SequenceLikelihood.NEGATIVE,  # 'Е'
        57: SequenceLikelihood.NEGATIVE,  # 'Ж'
        46: SequenceLikelihood.NEGATIVE,  # 'З'
        63: SequenceLikelihood.NEGATIVE,  # 'Й'
        37: SequenceLikelihood.UNLIKELY,  # 'К'
        44: SequenceLikelihood.UNLIKELY,  # 'Л'
        38: SequenceLikelihood.NEGATIVE,  # 'М'
        42: SequenceLikelihood.NEGATIVE,  # 'Н'
        58: SequenceLikelihood.NEGATIVE,  # 'О'
        32: SequenceLikelihood.NEGATIVE,  # 'П'
        41: SequenceLikelihood.NEGATIVE,  # 'Р'
        31: SequenceLikelihood.NEGATIVE,  # 'С'
        47: SequenceLikelihood.NEGATIVE,  # 'Т'
        39: SequenceLikelihood.NEGATIVE,  # 'У'
        49: SequenceLikelihood.NEGATIVE,  # 'Ф'
        53: SequenceLikelihood.NEGATIVE,  # 'Х'
        55: SequenceLikelihood.NEGATIVE,  # 'Ц'
        54: SequenceLikelihood.NEGATIVE,  # 'Ч'
        52: SequenceLikelihood.NEGATIVE,  # 'Ш'
        61: SequenceLikelihood.NEGATIVE,  # 'Ы'
        64: SequenceLikelihood.NEGATIVE,  # 'Ь'
        51: SequenceLikelihood.NEGATIVE,  # 'Э'
        59: SequenceLikelihood.NEGATIVE,  # 'Ю'
        50: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        22: SequenceLikelihood.POSITIVE,  # 'б'
        14: SequenceLikelihood.POSITIVE,  # 'в'
        21: SequenceLikelihood.POSITIVE,  # 'г'
        13: SequenceLikelihood.POSITIVE,  # 'д'
        9: SequenceLikelihood.POSITIVE,  # 'е'
        29: SequenceLikelihood.POSITIVE,  # 'ж'
        18: SequenceLikelihood.POSITIVE,  # 'з'
        25: SequenceLikelihood.POSITIVE,  # 'й'
        7: SequenceLikelihood.POSITIVE,  # 'к'
        8: SequenceLikelihood.POSITIVE,  # 'л'
        15: SequenceLikelihood.POSITIVE,  # 'м'
        2: SequenceLikelihood.POSITIVE,  # 'н'
        12: SequenceLikelihood.UNLIKELY,  # 'о'
        17: SequenceLikelihood.POSITIVE,  # 'п'
        4: SequenceLikelihood.POSITIVE,  # 'р'
        5: SequenceLikelihood.POSITIVE,  # 'с'
        10: SequenceLikelihood.POSITIVE,  # 'т'
        16: SequenceLikelihood.UNLIKELY,  # 'у'
        34: SequenceLikelihood.LIKELY,  # 'ф'
        27: SequenceLikelihood.POSITIVE,  # 'х'
        20: SequenceLikelihood.POSITIVE,  # 'ц'
        23: SequenceLikelihood.POSITIVE,  # 'ч'
        28: SequenceLikelihood.POSITIVE,  # 'ш'
        6: SequenceLikelihood.UNLIKELY,  # 'ы'
        26: SequenceLikelihood.NEGATIVE,  # 'ь'
        24: SequenceLikelihood.LIKELY,  # 'э'
        30: SequenceLikelihood.POSITIVE,  # 'ю'
        11: SequenceLikelihood.LIKELY,  # 'я'
        35: SequenceLikelihood.UNLIKELY,  # 'ё'
        3: SequenceLikelihood.LIKELY,  # 'і'
        19: SequenceLikelihood.LIKELY,  # 'ў'
    },
    34: {  # 'ф'
        65: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ё'
        48: SequenceLikelihood.NEGATIVE,  # 'І'
        62: SequenceLikelihood.NEGATIVE,  # 'Ў'
        33: SequenceLikelihood.UNLIKELY,  # 'А'
        36: SequenceLikelihood.NEGATIVE,  # 'Б'
        40: SequenceLikelihood.NEGATIVE,  # 'В'
        43: SequenceLikelihood.NEGATIVE,  # 'Г'
        45: SequenceLikelihood.NEGATIVE,  # 'Д'
        56: SequenceLikelihood.NEGATIVE,  # 'Е'
        57: SequenceLikelihood.NEGATIVE,  # 'Ж'
        46: SequenceLikelihood.NEGATIVE,  # 'З'
        63: SequenceLikelihood.NEGATIVE,  # 'Й'
        37: SequenceLikelihood.UNLIKELY,  # 'К'
        44: SequenceLikelihood.NEGATIVE,  # 'Л'
        38: SequenceLikelihood.UNLIKELY,  # 'М'
        42: SequenceLikelihood.NEGATIVE,  # 'Н'
        58: SequenceLikelihood.UNLIKELY,  # 'О'
        32: SequenceLikelihood.NEGATIVE,  # 'П'
        41: SequenceLikelihood.NEGATIVE,  # 'Р'
        31: SequenceLikelihood.NEGATIVE,  # 'С'
        47: SequenceLikelihood.NEGATIVE,  # 'Т'
        39: SequenceLikelihood.NEGATIVE,  # 'У'
        49: SequenceLikelihood.NEGATIVE,  # 'Ф'
        53: SequenceLikelihood.NEGATIVE,  # 'Х'
        55: SequenceLikelihood.NEGATIVE,  # 'Ц'
        54: SequenceLikelihood.NEGATIVE,  # 'Ч'
        52: SequenceLikelihood.NEGATIVE,  # 'Ш'
        61: SequenceLikelihood.NEGATIVE,  # 'Ы'
        64: SequenceLikelihood.NEGATIVE,  # 'Ь'
        51: SequenceLikelihood.NEGATIVE,  # 'Э'
        59: SequenceLikelihood.NEGATIVE,  # 'Ю'
        50: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        22: SequenceLikelihood.UNLIKELY,  # 'б'
        14: SequenceLikelihood.UNLIKELY,  # 'в'
        21: SequenceLikelihood.LIKELY,  # 'г'
        13: SequenceLikelihood.UNLIKELY,  # 'д'
        9: SequenceLikelihood.POSITIVE,  # 'е'
        29: SequenceLikelihood.NEGATIVE,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        25: SequenceLikelihood.NEGATIVE,  # 'й'
        7: SequenceLikelihood.UNLIKELY,  # 'к'
        8: SequenceLikelihood.LIKELY,  # 'л'
        15: SequenceLikelihood.UNLIKELY,  # 'м'
        2: SequenceLikelihood.LIKELY,  # 'н'
        12: SequenceLikelihood.POSITIVE,  # 'о'
        17: SequenceLikelihood.UNLIKELY,  # 'п'
        4: SequenceLikelihood.POSITIVE,  # 'р'
        5: SequenceLikelihood.LIKELY,  # 'с'
        10: SequenceLikelihood.LIKELY,  # 'т'
        16: SequenceLikelihood.POSITIVE,  # 'у'
        34: SequenceLikelihood.UNLIKELY,  # 'ф'
        27: SequenceLikelihood.UNLIKELY,  # 'х'
        20: SequenceLikelihood.UNLIKELY,  # 'ц'
        23: SequenceLikelihood.NEGATIVE,  # 'ч'
        28: SequenceLikelihood.UNLIKELY,  # 'ш'
        6: SequenceLikelihood.LIKELY,  # 'ы'
        26: SequenceLikelihood.UNLIKELY,  # 'ь'
        24: SequenceLikelihood.LIKELY,  # 'э'
        30: SequenceLikelihood.UNLIKELY,  # 'ю'
        11: SequenceLikelihood.UNLIKELY,  # 'я'
        35: SequenceLikelihood.UNLIKELY,  # 'ё'
        3: SequenceLikelihood.POSITIVE,  # 'і'
        19: SequenceLikelihood.NEGATIVE,  # 'ў'
    },
    27: {  # 'х'
        65: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ё'
        48: SequenceLikelihood.NEGATIVE,  # 'І'
        62: SequenceLikelihood.NEGATIVE,  # 'Ў'
        33: SequenceLikelihood.NEGATIVE,  # 'А'
        36: SequenceLikelihood.NEGATIVE,  # 'Б'
        40: SequenceLikelihood.NEGATIVE,  # 'В'
        43: SequenceLikelihood.UNLIKELY,  # 'Г'
        45: SequenceLikelihood.NEGATIVE,  # 'Д'
        56: SequenceLikelihood.NEGATIVE,  # 'Е'
        57: SequenceLikelihood.NEGATIVE,  # 'Ж'
        46: SequenceLikelihood.NEGATIVE,  # 'З'
        63: SequenceLikelihood.NEGATIVE,  # 'Й'
        37: SequenceLikelihood.NEGATIVE,  # 'К'
        44: SequenceLikelihood.NEGATIVE,  # 'Л'
        38: SequenceLikelihood.NEGATIVE,  # 'М'
        42: SequenceLikelihood.NEGATIVE,  # 'Н'
        58: SequenceLikelihood.NEGATIVE,  # 'О'
        32: SequenceLikelihood.NEGATIVE,  # 'П'
        41: SequenceLikelihood.NEGATIVE,  # 'Р'
        31: SequenceLikelihood.NEGATIVE,  # 'С'
        47: SequenceLikelihood.NEGATIVE,  # 'Т'
        39: SequenceLikelihood.NEGATIVE,  # 'У'
        49: SequenceLikelihood.NEGATIVE,  # 'Ф'
        53: SequenceLikelihood.NEGATIVE,  # 'Х'
        55: SequenceLikelihood.NEGATIVE,  # 'Ц'
        54: SequenceLikelihood.NEGATIVE,  # 'Ч'
        52: SequenceLikelihood.NEGATIVE,  # 'Ш'
        61: SequenceLikelihood.NEGATIVE,  # 'Ы'
        64: SequenceLikelihood.NEGATIVE,  # 'Ь'
        51: SequenceLikelihood.NEGATIVE,  # 'Э'
        59: SequenceLikelihood.NEGATIVE,  # 'Ю'
        50: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        22: SequenceLikelihood.UNLIKELY,  # 'б'
        14: SequenceLikelihood.POSITIVE,  # 'в'
        21: SequenceLikelihood.LIKELY,  # 'г'
        13: SequenceLikelihood.UNLIKELY,  # 'д'
        9: SequenceLikelihood.LIKELY,  # 'е'
        29: SequenceLikelihood.NEGATIVE,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        25: SequenceLikelihood.NEGATIVE,  # 'й'
        7: SequenceLikelihood.UNLIKELY,  # 'к'
        8: SequenceLikelihood.LIKELY,  # 'л'
        15: SequenceLikelihood.LIKELY,  # 'м'
        2: SequenceLikelihood.POSITIVE,  # 'н'
        12: SequenceLikelihood.POSITIVE,  # 'о'
        17: SequenceLikelihood.UNLIKELY,  # 'п'
        4: SequenceLikelihood.POSITIVE,  # 'р'
        5: SequenceLikelihood.LIKELY,  # 'с'
        10: SequenceLikelihood.POSITIVE,  # 'т'
        16: SequenceLikelihood.POSITIVE,  # 'у'
        34: SequenceLikelihood.UNLIKELY,  # 'ф'
        27: SequenceLikelihood.UNLIKELY,  # 'х'
        20: SequenceLikelihood.LIKELY,  # 'ц'
        23: SequenceLikelihood.UNLIKELY,  # 'ч'
        28: SequenceLikelihood.UNLIKELY,  # 'ш'
        6: SequenceLikelihood.UNLIKELY,  # 'ы'
        26: SequenceLikelihood.UNLIKELY,  # 'ь'
        24: SequenceLikelihood.UNLIKELY,  # 'э'
        30: SequenceLikelihood.UNLIKELY,  # 'ю'
        11: SequenceLikelihood.UNLIKELY,  # 'я'
        35: SequenceLikelihood.UNLIKELY,  # 'ё'
        3: SequenceLikelihood.POSITIVE,  # 'і'
        19: SequenceLikelihood.NEGATIVE,  # 'ў'
    },
    20: {  # 'ц'
        65: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ё'
        48: SequenceLikelihood.NEGATIVE,  # 'І'
        62: SequenceLikelihood.NEGATIVE,  # 'Ў'
        33: SequenceLikelihood.UNLIKELY,  # 'А'
        36: SequenceLikelihood.NEGATIVE,  # 'Б'
        40: SequenceLikelihood.UNLIKELY,  # 'В'
        43: SequenceLikelihood.NEGATIVE,  # 'Г'
        45: SequenceLikelihood.NEGATIVE,  # 'Д'
        56: SequenceLikelihood.NEGATIVE,  # 'Е'
        57: SequenceLikelihood.NEGATIVE,  # 'Ж'
        46: SequenceLikelihood.NEGATIVE,  # 'З'
        63: SequenceLikelihood.NEGATIVE,  # 'Й'
        37: SequenceLikelihood.NEGATIVE,  # 'К'
        44: SequenceLikelihood.NEGATIVE,  # 'Л'
        38: SequenceLikelihood.NEGATIVE,  # 'М'
        42: SequenceLikelihood.NEGATIVE,  # 'Н'
        58: SequenceLikelihood.NEGATIVE,  # 'О'
        32: SequenceLikelihood.NEGATIVE,  # 'П'
        41: SequenceLikelihood.NEGATIVE,  # 'Р'
        31: SequenceLikelihood.NEGATIVE,  # 'С'
        47: SequenceLikelihood.NEGATIVE,  # 'Т'
        39: SequenceLikelihood.NEGATIVE,  # 'У'
        49: SequenceLikelihood.NEGATIVE,  # 'Ф'
        53: SequenceLikelihood.NEGATIVE,  # 'Х'
        55: SequenceLikelihood.NEGATIVE,  # 'Ц'
        54: SequenceLikelihood.NEGATIVE,  # 'Ч'
        52: SequenceLikelihood.NEGATIVE,  # 'Ш'
        61: SequenceLikelihood.NEGATIVE,  # 'Ы'
        64: SequenceLikelihood.NEGATIVE,  # 'Ь'
        51: SequenceLikelihood.NEGATIVE,  # 'Э'
        59: SequenceLikelihood.NEGATIVE,  # 'Ю'
        50: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        22: SequenceLikelihood.UNLIKELY,  # 'б'
        14: SequenceLikelihood.POSITIVE,  # 'в'
        21: SequenceLikelihood.UNLIKELY,  # 'г'
        13: SequenceLikelihood.UNLIKELY,  # 'д'
        9: SequenceLikelihood.POSITIVE,  # 'е'
        29: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        25: SequenceLikelihood.UNLIKELY,  # 'й'
        7: SequenceLikelihood.POSITIVE,  # 'к'
        8: SequenceLikelihood.LIKELY,  # 'л'
        15: SequenceLikelihood.UNLIKELY,  # 'м'
        2: SequenceLikelihood.LIKELY,  # 'н'
        12: SequenceLikelihood.POSITIVE,  # 'о'
        17: SequenceLikelihood.UNLIKELY,  # 'п'
        4: SequenceLikelihood.UNLIKELY,  # 'р'
        5: SequenceLikelihood.UNLIKELY,  # 'с'
        10: SequenceLikelihood.POSITIVE,  # 'т'
        16: SequenceLikelihood.POSITIVE,  # 'у'
        34: SequenceLikelihood.UNLIKELY,  # 'ф'
        27: SequenceLikelihood.UNLIKELY,  # 'х'
        20: SequenceLikelihood.POSITIVE,  # 'ц'
        23: SequenceLikelihood.NEGATIVE,  # 'ч'
        28: SequenceLikelihood.UNLIKELY,  # 'ш'
        6: SequenceLikelihood.POSITIVE,  # 'ы'
        26: SequenceLikelihood.POSITIVE,  # 'ь'
        24: SequenceLikelihood.POSITIVE,  # 'э'
        30: SequenceLikelihood.POSITIVE,  # 'ю'
        11: SequenceLikelihood.POSITIVE,  # 'я'
        35: SequenceLikelihood.POSITIVE,  # 'ё'
        3: SequenceLikelihood.POSITIVE,  # 'і'
        19: SequenceLikelihood.UNLIKELY,  # 'ў'
    },
    23: {  # 'ч'
        65: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ё'
        48: SequenceLikelihood.NEGATIVE,  # 'І'
        62: SequenceLikelihood.NEGATIVE,  # 'Ў'
        33: SequenceLikelihood.NEGATIVE,  # 'А'
        36: SequenceLikelihood.NEGATIVE,  # 'Б'
        40: SequenceLikelihood.NEGATIVE,  # 'В'
        43: SequenceLikelihood.NEGATIVE,  # 'Г'
        45: SequenceLikelihood.NEGATIVE,  # 'Д'
        56: SequenceLikelihood.NEGATIVE,  # 'Е'
        57: SequenceLikelihood.NEGATIVE,  # 'Ж'
        46: SequenceLikelihood.NEGATIVE,  # 'З'
        63: SequenceLikelihood.NEGATIVE,  # 'Й'
        37: SequenceLikelihood.NEGATIVE,  # 'К'
        44: SequenceLikelihood.NEGATIVE,  # 'Л'
        38: SequenceLikelihood.NEGATIVE,  # 'М'
        42: SequenceLikelihood.NEGATIVE,  # 'Н'
        58: SequenceLikelihood.NEGATIVE,  # 'О'
        32: SequenceLikelihood.UNLIKELY,  # 'П'
        41: SequenceLikelihood.NEGATIVE,  # 'Р'
        31: SequenceLikelihood.NEGATIVE,  # 'С'
        47: SequenceLikelihood.NEGATIVE,  # 'Т'
        39: SequenceLikelihood.NEGATIVE,  # 'У'
        49: SequenceLikelihood.NEGATIVE,  # 'Ф'
        53: SequenceLikelihood.NEGATIVE,  # 'Х'
        55: SequenceLikelihood.NEGATIVE,  # 'Ц'
        54: SequenceLikelihood.NEGATIVE,  # 'Ч'
        52: SequenceLikelihood.NEGATIVE,  # 'Ш'
        61: SequenceLikelihood.NEGATIVE,  # 'Ы'
        64: SequenceLikelihood.NEGATIVE,  # 'Ь'
        51: SequenceLikelihood.NEGATIVE,  # 'Э'
        59: SequenceLikelihood.NEGATIVE,  # 'Ю'
        50: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        22: SequenceLikelihood.LIKELY,  # 'б'
        14: SequenceLikelihood.LIKELY,  # 'в'
        21: SequenceLikelihood.UNLIKELY,  # 'г'
        13: SequenceLikelihood.UNLIKELY,  # 'д'
        9: SequenceLikelihood.LIKELY,  # 'е'
        29: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        25: SequenceLikelihood.NEGATIVE,  # 'й'
        7: SequenceLikelihood.POSITIVE,  # 'к'
        8: SequenceLikelihood.LIKELY,  # 'л'
        15: SequenceLikelihood.UNLIKELY,  # 'м'
        2: SequenceLikelihood.POSITIVE,  # 'н'
        12: SequenceLikelihood.POSITIVE,  # 'о'
        17: SequenceLikelihood.UNLIKELY,  # 'п'
        4: SequenceLikelihood.UNLIKELY,  # 'р'
        5: SequenceLikelihood.UNLIKELY,  # 'с'
        10: SequenceLikelihood.UNLIKELY,  # 'т'
        16: SequenceLikelihood.POSITIVE,  # 'у'
        34: SequenceLikelihood.UNLIKELY,  # 'ф'
        27: SequenceLikelihood.UNLIKELY,  # 'х'
        20: SequenceLikelihood.UNLIKELY,  # 'ц'
        23: SequenceLikelihood.LIKELY,  # 'ч'
        28: SequenceLikelihood.UNLIKELY,  # 'ш'
        6: SequenceLikelihood.POSITIVE,  # 'ы'
        26: SequenceLikelihood.UNLIKELY,  # 'ь'
        24: SequenceLikelihood.POSITIVE,  # 'э'
        30: SequenceLikelihood.UNLIKELY,  # 'ю'
        11: SequenceLikelihood.UNLIKELY,  # 'я'
        35: SequenceLikelihood.UNLIKELY,  # 'ё'
        3: SequenceLikelihood.UNLIKELY,  # 'і'
        19: SequenceLikelihood.NEGATIVE,  # 'ў'
    },
    28: {  # 'ш'
        65: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ё'
        48: SequenceLikelihood.NEGATIVE,  # 'І'
        62: SequenceLikelihood.NEGATIVE,  # 'Ў'
        33: SequenceLikelihood.NEGATIVE,  # 'А'
        36: SequenceLikelihood.NEGATIVE,  # 'Б'
        40: SequenceLikelihood.NEGATIVE,  # 'В'
        43: SequenceLikelihood.NEGATIVE,  # 'Г'
        45: SequenceLikelihood.NEGATIVE,  # 'Д'
        56: SequenceLikelihood.NEGATIVE,  # 'Е'
        57: SequenceLikelihood.NEGATIVE,  # 'Ж'
        46: SequenceLikelihood.NEGATIVE,  # 'З'
        63: SequenceLikelihood.NEGATIVE,  # 'Й'
        37: SequenceLikelihood.NEGATIVE,  # 'К'
        44: SequenceLikelihood.NEGATIVE,  # 'Л'
        38: SequenceLikelihood.NEGATIVE,  # 'М'
        42: SequenceLikelihood.NEGATIVE,  # 'Н'
        58: SequenceLikelihood.NEGATIVE,  # 'О'
        32: SequenceLikelihood.NEGATIVE,  # 'П'
        41: SequenceLikelihood.NEGATIVE,  # 'Р'
        31: SequenceLikelihood.NEGATIVE,  # 'С'
        47: SequenceLikelihood.NEGATIVE,  # 'Т'
        39: SequenceLikelihood.NEGATIVE,  # 'У'
        49: SequenceLikelihood.NEGATIVE,  # 'Ф'
        53: SequenceLikelihood.NEGATIVE,  # 'Х'
        55: SequenceLikelihood.NEGATIVE,  # 'Ц'
        54: SequenceLikelihood.NEGATIVE,  # 'Ч'
        52: SequenceLikelihood.NEGATIVE,  # 'Ш'
        61: SequenceLikelihood.NEGATIVE,  # 'Ы'
        64: SequenceLikelihood.NEGATIVE,  # 'Ь'
        51: SequenceLikelihood.NEGATIVE,  # 'Э'
        59: SequenceLikelihood.NEGATIVE,  # 'Ю'
        50: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        22: SequenceLikelihood.UNLIKELY,  # 'б'
        14: SequenceLikelihood.LIKELY,  # 'в'
        21: SequenceLikelihood.UNLIKELY,  # 'г'
        13: SequenceLikelihood.UNLIKELY,  # 'д'
        9: SequenceLikelihood.LIKELY,  # 'е'
        29: SequenceLikelihood.NEGATIVE,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        25: SequenceLikelihood.UNLIKELY,  # 'й'
        7: SequenceLikelihood.POSITIVE,  # 'к'
        8: SequenceLikelihood.POSITIVE,  # 'л'
        15: SequenceLikelihood.LIKELY,  # 'м'
        2: SequenceLikelihood.POSITIVE,  # 'н'
        12: SequenceLikelihood.LIKELY,  # 'о'
        17: SequenceLikelihood.LIKELY,  # 'п'
        4: SequenceLikelihood.LIKELY,  # 'р'
        5: SequenceLikelihood.LIKELY,  # 'с'
        10: SequenceLikelihood.POSITIVE,  # 'т'
        16: SequenceLikelihood.POSITIVE,  # 'у'
        34: SequenceLikelihood.UNLIKELY,  # 'ф'
        27: SequenceLikelihood.UNLIKELY,  # 'х'
        20: SequenceLikelihood.LIKELY,  # 'ц'
        23: SequenceLikelihood.POSITIVE,  # 'ч'
        28: SequenceLikelihood.LIKELY,  # 'ш'
        6: SequenceLikelihood.POSITIVE,  # 'ы'
        26: SequenceLikelihood.UNLIKELY,  # 'ь'
        24: SequenceLikelihood.POSITIVE,  # 'э'
        30: SequenceLikelihood.UNLIKELY,  # 'ю'
        11: SequenceLikelihood.UNLIKELY,  # 'я'
        35: SequenceLikelihood.UNLIKELY,  # 'ё'
        3: SequenceLikelihood.UNLIKELY,  # 'і'
        19: SequenceLikelihood.NEGATIVE,  # 'ў'
    },
    6: {  # 'ы'
        65: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ё'
        48: SequenceLikelihood.NEGATIVE,  # 'І'
        62: SequenceLikelihood.NEGATIVE,  # 'Ў'
        33: SequenceLikelihood.UNLIKELY,  # 'А'
        36: SequenceLikelihood.UNLIKELY,  # 'Б'
        40: SequenceLikelihood.NEGATIVE,  # 'В'
        43: SequenceLikelihood.NEGATIVE,  # 'Г'
        45: SequenceLikelihood.NEGATIVE,  # 'Д'
        56: SequenceLikelihood.NEGATIVE,  # 'Е'
        57: SequenceLikelihood.NEGATIVE,  # 'Ж'
        46: SequenceLikelihood.NEGATIVE,  # 'З'
        63: SequenceLikelihood.NEGATIVE,  # 'Й'
        37: SequenceLikelihood.UNLIKELY,  # 'К'
        44: SequenceLikelihood.NEGATIVE,  # 'Л'
        38: SequenceLikelihood.NEGATIVE,  # 'М'
        42: SequenceLikelihood.NEGATIVE,  # 'Н'
        58: SequenceLikelihood.NEGATIVE,  # 'О'
        32: SequenceLikelihood.NEGATIVE,  # 'П'
        41: SequenceLikelihood.NEGATIVE,  # 'Р'
        31: SequenceLikelihood.UNLIKELY,  # 'С'
        47: SequenceLikelihood.NEGATIVE,  # 'Т'
        39: SequenceLikelihood.NEGATIVE,  # 'У'
        49: SequenceLikelihood.NEGATIVE,  # 'Ф'
        53: SequenceLikelihood.NEGATIVE,  # 'Х'
        55: SequenceLikelihood.NEGATIVE,  # 'Ц'
        54: SequenceLikelihood.NEGATIVE,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        61: SequenceLikelihood.NEGATIVE,  # 'Ы'
        64: SequenceLikelihood.NEGATIVE,  # 'Ь'
        51: SequenceLikelihood.NEGATIVE,  # 'Э'
        59: SequenceLikelihood.NEGATIVE,  # 'Ю'
        50: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.LIKELY,  # 'а'
        22: SequenceLikelihood.POSITIVE,  # 'б'
        14: SequenceLikelihood.POSITIVE,  # 'в'
        21: SequenceLikelihood.POSITIVE,  # 'г'
        13: SequenceLikelihood.POSITIVE,  # 'д'
        9: SequenceLikelihood.POSITIVE,  # 'е'
        29: SequenceLikelihood.LIKELY,  # 'ж'
        18: SequenceLikelihood.POSITIVE,  # 'з'
        25: SequenceLikelihood.POSITIVE,  # 'й'
        7: SequenceLikelihood.POSITIVE,  # 'к'
        8: SequenceLikelihood.POSITIVE,  # 'л'
        15: SequenceLikelihood.POSITIVE,  # 'м'
        2: SequenceLikelihood.POSITIVE,  # 'н'
        12: SequenceLikelihood.UNLIKELY,  # 'о'
        17: SequenceLikelihood.POSITIVE,  # 'п'
        4: SequenceLikelihood.POSITIVE,  # 'р'
        5: SequenceLikelihood.POSITIVE,  # 'с'
        10: SequenceLikelihood.POSITIVE,  # 'т'
        16: SequenceLikelihood.LIKELY,  # 'у'
        34: SequenceLikelihood.LIKELY,  # 'ф'
        27: SequenceLikelihood.POSITIVE,  # 'х'
        20: SequenceLikelihood.POSITIVE,  # 'ц'
        23: SequenceLikelihood.POSITIVE,  # 'ч'
        28: SequenceLikelihood.POSITIVE,  # 'ш'
        6: SequenceLikelihood.UNLIKELY,  # 'ы'
        26: SequenceLikelihood.UNLIKELY,  # 'ь'
        24: SequenceLikelihood.UNLIKELY,  # 'э'
        30: SequenceLikelihood.POSITIVE,  # 'ю'
        11: SequenceLikelihood.POSITIVE,  # 'я'
        35: SequenceLikelihood.LIKELY,  # 'ё'
        3: SequenceLikelihood.POSITIVE,  # 'і'
        19: SequenceLikelihood.POSITIVE,  # 'ў'
    },
    26: {  # 'ь'
        65: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ё'
        48: SequenceLikelihood.NEGATIVE,  # 'І'
        62: SequenceLikelihood.NEGATIVE,  # 'Ў'
        33: SequenceLikelihood.UNLIKELY,  # 'А'
        36: SequenceLikelihood.NEGATIVE,  # 'Б'
        40: SequenceLikelihood.NEGATIVE,  # 'В'
        43: SequenceLikelihood.NEGATIVE,  # 'Г'
        45: SequenceLikelihood.NEGATIVE,  # 'Д'
        56: SequenceLikelihood.NEGATIVE,  # 'Е'
        57: SequenceLikelihood.NEGATIVE,  # 'Ж'
        46: SequenceLikelihood.NEGATIVE,  # 'З'
        63: SequenceLikelihood.NEGATIVE,  # 'Й'
        37: SequenceLikelihood.NEGATIVE,  # 'К'
        44: SequenceLikelihood.NEGATIVE,  # 'Л'
        38: SequenceLikelihood.NEGATIVE,  # 'М'
        42: SequenceLikelihood.NEGATIVE,  # 'Н'
        58: SequenceLikelihood.NEGATIVE,  # 'О'
        32: SequenceLikelihood.NEGATIVE,  # 'П'
        41: SequenceLikelihood.NEGATIVE,  # 'Р'
        31: SequenceLikelihood.NEGATIVE,  # 'С'
        47: SequenceLikelihood.NEGATIVE,  # 'Т'
        39: SequenceLikelihood.NEGATIVE,  # 'У'
        49: SequenceLikelihood.NEGATIVE,  # 'Ф'
        53: SequenceLikelihood.NEGATIVE,  # 'Х'
        55: SequenceLikelihood.NEGATIVE,  # 'Ц'
        54: SequenceLikelihood.NEGATIVE,  # 'Ч'
        52: SequenceLikelihood.NEGATIVE,  # 'Ш'
        61: SequenceLikelihood.NEGATIVE,  # 'Ы'
        64: SequenceLikelihood.NEGATIVE,  # 'Ь'
        51: SequenceLikelihood.NEGATIVE,  # 'Э'
        59: SequenceLikelihood.NEGATIVE,  # 'Ю'
        50: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.UNLIKELY,  # 'а'
        22: SequenceLikelihood.POSITIVE,  # 'б'
        14: SequenceLikelihood.LIKELY,  # 'в'
        21: SequenceLikelihood.LIKELY,  # 'г'
        13: SequenceLikelihood.LIKELY,  # 'д'
        9: SequenceLikelihood.LIKELY,  # 'е'
        29: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        25: SequenceLikelihood.UNLIKELY,  # 'й'
        7: SequenceLikelihood.POSITIVE,  # 'к'
        8: SequenceLikelihood.UNLIKELY,  # 'л'
        15: SequenceLikelihood.POSITIVE,  # 'м'
        2: SequenceLikelihood.POSITIVE,  # 'н'
        12: SequenceLikelihood.UNLIKELY,  # 'о'
        17: SequenceLikelihood.LIKELY,  # 'п'
        4: SequenceLikelihood.UNLIKELY,  # 'р'
        5: SequenceLikelihood.POSITIVE,  # 'с'
        10: SequenceLikelihood.POSITIVE,  # 'т'
        16: SequenceLikelihood.UNLIKELY,  # 'у'
        34: SequenceLikelihood.LIKELY,  # 'ф'
        27: SequenceLikelihood.LIKELY,  # 'х'
        20: SequenceLikelihood.LIKELY,  # 'ц'
        23: SequenceLikelihood.LIKELY,  # 'ч'
        28: SequenceLikelihood.POSITIVE,  # 'ш'
        6: SequenceLikelihood.UNLIKELY,  # 'ы'
        26: SequenceLikelihood.UNLIKELY,  # 'ь'
        24: SequenceLikelihood.UNLIKELY,  # 'э'
        30: SequenceLikelihood.LIKELY,  # 'ю'
        11: SequenceLikelihood.LIKELY,  # 'я'
        35: SequenceLikelihood.LIKELY,  # 'ё'
        3: SequenceLikelihood.LIKELY,  # 'і'
        19: SequenceLikelihood.UNLIKELY,  # 'ў'
    },
    24: {  # 'э'
        65: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ё'
        48: SequenceLikelihood.NEGATIVE,  # 'І'
        62: SequenceLikelihood.NEGATIVE,  # 'Ў'
        33: SequenceLikelihood.NEGATIVE,  # 'А'
        36: SequenceLikelihood.UNLIKELY,  # 'Б'
        40: SequenceLikelihood.UNLIKELY,  # 'В'
        43: SequenceLikelihood.NEGATIVE,  # 'Г'
        45: SequenceLikelihood.NEGATIVE,  # 'Д'
        56: SequenceLikelihood.NEGATIVE,  # 'Е'
        57: SequenceLikelihood.NEGATIVE,  # 'Ж'
        46: SequenceLikelihood.NEGATIVE,  # 'З'
        63: SequenceLikelihood.NEGATIVE,  # 'Й'
        37: SequenceLikelihood.NEGATIVE,  # 'К'
        44: SequenceLikelihood.NEGATIVE,  # 'Л'
        38: SequenceLikelihood.NEGATIVE,  # 'М'
        42: SequenceLikelihood.NEGATIVE,  # 'Н'
        58: SequenceLikelihood.NEGATIVE,  # 'О'
        32: SequenceLikelihood.NEGATIVE,  # 'П'
        41: SequenceLikelihood.NEGATIVE,  # 'Р'
        31: SequenceLikelihood.NEGATIVE,  # 'С'
        47: SequenceLikelihood.NEGATIVE,  # 'Т'
        39: SequenceLikelihood.NEGATIVE,  # 'У'
        49: SequenceLikelihood.NEGATIVE,  # 'Ф'
        53: SequenceLikelihood.NEGATIVE,  # 'Х'
        55: SequenceLikelihood.NEGATIVE,  # 'Ц'
        54: SequenceLikelihood.NEGATIVE,  # 'Ч'
        52: SequenceLikelihood.NEGATIVE,  # 'Ш'
        61: SequenceLikelihood.NEGATIVE,  # 'Ы'
        64: SequenceLikelihood.NEGATIVE,  # 'Ь'
        51: SequenceLikelihood.NEGATIVE,  # 'Э'
        59: SequenceLikelihood.NEGATIVE,  # 'Ю'
        50: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        22: SequenceLikelihood.LIKELY,  # 'б'
        14: SequenceLikelihood.POSITIVE,  # 'в'
        21: SequenceLikelihood.POSITIVE,  # 'г'
        13: SequenceLikelihood.POSITIVE,  # 'д'
        9: SequenceLikelihood.LIKELY,  # 'е'
        29: SequenceLikelihood.LIKELY,  # 'ж'
        18: SequenceLikelihood.POSITIVE,  # 'з'
        25: SequenceLikelihood.POSITIVE,  # 'й'
        7: SequenceLikelihood.POSITIVE,  # 'к'
        8: SequenceLikelihood.POSITIVE,  # 'л'
        15: SequenceLikelihood.POSITIVE,  # 'м'
        2: SequenceLikelihood.POSITIVE,  # 'н'
        12: SequenceLikelihood.LIKELY,  # 'о'
        17: SequenceLikelihood.POSITIVE,  # 'п'
        4: SequenceLikelihood.POSITIVE,  # 'р'
        5: SequenceLikelihood.POSITIVE,  # 'с'
        10: SequenceLikelihood.POSITIVE,  # 'т'
        16: SequenceLikelihood.UNLIKELY,  # 'у'
        34: SequenceLikelihood.POSITIVE,  # 'ф'
        27: SequenceLikelihood.LIKELY,  # 'х'
        20: SequenceLikelihood.POSITIVE,  # 'ц'
        23: SequenceLikelihood.POSITIVE,  # 'ч'
        28: SequenceLikelihood.LIKELY,  # 'ш'
        6: SequenceLikelihood.NEGATIVE,  # 'ы'
        26: SequenceLikelihood.UNLIKELY,  # 'ь'
        24: SequenceLikelihood.UNLIKELY,  # 'э'
        30: SequenceLikelihood.LIKELY,  # 'ю'
        11: SequenceLikelihood.LIKELY,  # 'я'
        35: SequenceLikelihood.UNLIKELY,  # 'ё'
        3: SequenceLikelihood.LIKELY,  # 'і'
        19: SequenceLikelihood.POSITIVE,  # 'ў'
    },
    30: {  # 'ю'
        65: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ё'
        48: SequenceLikelihood.NEGATIVE,  # 'І'
        62: SequenceLikelihood.NEGATIVE,  # 'Ў'
        33: SequenceLikelihood.NEGATIVE,  # 'А'
        36: SequenceLikelihood.NEGATIVE,  # 'Б'
        40: SequenceLikelihood.NEGATIVE,  # 'В'
        43: SequenceLikelihood.NEGATIVE,  # 'Г'
        45: SequenceLikelihood.NEGATIVE,  # 'Д'
        56: SequenceLikelihood.NEGATIVE,  # 'Е'
        57: SequenceLikelihood.NEGATIVE,  # 'Ж'
        46: SequenceLikelihood.NEGATIVE,  # 'З'
        63: SequenceLikelihood.NEGATIVE,  # 'Й'
        37: SequenceLikelihood.UNLIKELY,  # 'К'
        44: SequenceLikelihood.NEGATIVE,  # 'Л'
        38: SequenceLikelihood.NEGATIVE,  # 'М'
        42: SequenceLikelihood.NEGATIVE,  # 'Н'
        58: SequenceLikelihood.NEGATIVE,  # 'О'
        32: SequenceLikelihood.NEGATIVE,  # 'П'
        41: SequenceLikelihood.NEGATIVE,  # 'Р'
        31: SequenceLikelihood.NEGATIVE,  # 'С'
        47: SequenceLikelihood.NEGATIVE,  # 'Т'
        39: SequenceLikelihood.NEGATIVE,  # 'У'
        49: SequenceLikelihood.NEGATIVE,  # 'Ф'
        53: SequenceLikelihood.NEGATIVE,  # 'Х'
        55: SequenceLikelihood.NEGATIVE,  # 'Ц'
        54: SequenceLikelihood.NEGATIVE,  # 'Ч'
        52: SequenceLikelihood.NEGATIVE,  # 'Ш'
        61: SequenceLikelihood.NEGATIVE,  # 'Ы'
        64: SequenceLikelihood.NEGATIVE,  # 'Ь'
        51: SequenceLikelihood.NEGATIVE,  # 'Э'
        59: SequenceLikelihood.NEGATIVE,  # 'Ю'
        50: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.UNLIKELY,  # 'а'
        22: SequenceLikelihood.LIKELY,  # 'б'
        14: SequenceLikelihood.LIKELY,  # 'в'
        21: SequenceLikelihood.UNLIKELY,  # 'г'
        13: SequenceLikelihood.POSITIVE,  # 'д'
        9: SequenceLikelihood.LIKELY,  # 'е'
        29: SequenceLikelihood.LIKELY,  # 'ж'
        18: SequenceLikelihood.POSITIVE,  # 'з'
        25: SequenceLikelihood.UNLIKELY,  # 'й'
        7: SequenceLikelihood.LIKELY,  # 'к'
        8: SequenceLikelihood.LIKELY,  # 'л'
        15: SequenceLikelihood.LIKELY,  # 'м'
        2: SequenceLikelihood.LIKELY,  # 'н'
        12: SequenceLikelihood.UNLIKELY,  # 'о'
        17: SequenceLikelihood.UNLIKELY,  # 'п'
        4: SequenceLikelihood.LIKELY,  # 'р'
        5: SequenceLikelihood.LIKELY,  # 'с'
        10: SequenceLikelihood.POSITIVE,  # 'т'
        16: SequenceLikelihood.UNLIKELY,  # 'у'
        34: SequenceLikelihood.UNLIKELY,  # 'ф'
        27: SequenceLikelihood.LIKELY,  # 'х'
        20: SequenceLikelihood.POSITIVE,  # 'ц'
        23: SequenceLikelihood.POSITIVE,  # 'ч'
        28: SequenceLikelihood.LIKELY,  # 'ш'
        6: SequenceLikelihood.NEGATIVE,  # 'ы'
        26: SequenceLikelihood.NEGATIVE,  # 'ь'
        24: SequenceLikelihood.UNLIKELY,  # 'э'
        30: SequenceLikelihood.LIKELY,  # 'ю'
        11: SequenceLikelihood.UNLIKELY,  # 'я'
        35: SequenceLikelihood.UNLIKELY,  # 'ё'
        3: SequenceLikelihood.UNLIKELY,  # 'і'
        19: SequenceLikelihood.UNLIKELY,  # 'ў'
    },
    11: {  # 'я'
        65: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ё'
        48: SequenceLikelihood.NEGATIVE,  # 'І'
        62: SequenceLikelihood.NEGATIVE,  # 'Ў'
        33: SequenceLikelihood.NEGATIVE,  # 'А'
        36: SequenceLikelihood.NEGATIVE,  # 'Б'
        40: SequenceLikelihood.NEGATIVE,  # 'В'
        43: SequenceLikelihood.NEGATIVE,  # 'Г'
        45: SequenceLikelihood.NEGATIVE,  # 'Д'
        56: SequenceLikelihood.UNLIKELY,  # 'Е'
        57: SequenceLikelihood.NEGATIVE,  # 'Ж'
        46: SequenceLikelihood.NEGATIVE,  # 'З'
        63: SequenceLikelihood.NEGATIVE,  # 'Й'
        37: SequenceLikelihood.NEGATIVE,  # 'К'
        44: SequenceLikelihood.NEGATIVE,  # 'Л'
        38: SequenceLikelihood.NEGATIVE,  # 'М'
        42: SequenceLikelihood.UNLIKELY,  # 'Н'
        58: SequenceLikelihood.NEGATIVE,  # 'О'
        32: SequenceLikelihood.NEGATIVE,  # 'П'
        41: SequenceLikelihood.UNLIKELY,  # 'Р'
        31: SequenceLikelihood.NEGATIVE,  # 'С'
        47: SequenceLikelihood.NEGATIVE,  # 'Т'
        39: SequenceLikelihood.NEGATIVE,  # 'У'
        49: SequenceLikelihood.NEGATIVE,  # 'Ф'
        53: SequenceLikelihood.NEGATIVE,  # 'Х'
        55: SequenceLikelihood.NEGATIVE,  # 'Ц'
        54: SequenceLikelihood.NEGATIVE,  # 'Ч'
        52: SequenceLikelihood.NEGATIVE,  # 'Ш'
        61: SequenceLikelihood.NEGATIVE,  # 'Ы'
        64: SequenceLikelihood.NEGATIVE,  # 'Ь'
        51: SequenceLikelihood.UNLIKELY,  # 'Э'
        59: SequenceLikelihood.NEGATIVE,  # 'Ю'
        50: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.UNLIKELY,  # 'а'
        22: SequenceLikelihood.LIKELY,  # 'б'
        14: SequenceLikelihood.POSITIVE,  # 'в'
        21: SequenceLikelihood.POSITIVE,  # 'г'
        13: SequenceLikelihood.POSITIVE,  # 'д'
        9: SequenceLikelihood.POSITIVE,  # 'е'
        29: SequenceLikelihood.POSITIVE,  # 'ж'
        18: SequenceLikelihood.POSITIVE,  # 'з'
        25: SequenceLikelihood.POSITIVE,  # 'й'
        7: SequenceLikelihood.POSITIVE,  # 'к'
        8: SequenceLikelihood.POSITIVE,  # 'л'
        15: SequenceLikelihood.POSITIVE,  # 'м'
        2: SequenceLikelihood.POSITIVE,  # 'н'
        12: SequenceLikelihood.UNLIKELY,  # 'о'
        17: SequenceLikelihood.POSITIVE,  # 'п'
        4: SequenceLikelihood.POSITIVE,  # 'р'
        5: SequenceLikelihood.POSITIVE,  # 'с'
        10: SequenceLikelihood.POSITIVE,  # 'т'
        16: SequenceLikelihood.UNLIKELY,  # 'у'
        34: SequenceLikelihood.LIKELY,  # 'ф'
        27: SequenceLikelihood.POSITIVE,  # 'х'
        20: SequenceLikelihood.POSITIVE,  # 'ц'
        23: SequenceLikelihood.POSITIVE,  # 'ч'
        28: SequenceLikelihood.POSITIVE,  # 'ш'
        6: SequenceLikelihood.UNLIKELY,  # 'ы'
        26: SequenceLikelihood.NEGATIVE,  # 'ь'
        24: SequenceLikelihood.UNLIKELY,  # 'э'
        30: SequenceLikelihood.POSITIVE,  # 'ю'
        11: SequenceLikelihood.LIKELY,  # 'я'
        35: SequenceLikelihood.UNLIKELY,  # 'ё'
        3: SequenceLikelihood.UNLIKELY,  # 'і'
        19: SequenceLikelihood.POSITIVE,  # 'ў'
    },
    35: {  # 'ё'
        65: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ё'
        48: SequenceLikelihood.NEGATIVE,  # 'І'
        62: SequenceLikelihood.NEGATIVE,  # 'Ў'
        33: SequenceLikelihood.NEGATIVE,  # 'А'
        36: SequenceLikelihood.NEGATIVE,  # 'Б'
        40: SequenceLikelihood.NEGATIVE,  # 'В'
        43: SequenceLikelihood.NEGATIVE,  # 'Г'
        45: SequenceLikelihood.NEGATIVE,  # 'Д'
        56: SequenceLikelihood.NEGATIVE,  # 'Е'
        57: SequenceLikelihood.NEGATIVE,  # 'Ж'
        46: SequenceLikelihood.NEGATIVE,  # 'З'
        63: SequenceLikelihood.NEGATIVE,  # 'Й'
        37: SequenceLikelihood.NEGATIVE,  # 'К'
        44: SequenceLikelihood.NEGATIVE,  # 'Л'
        38: SequenceLikelihood.NEGATIVE,  # 'М'
        42: SequenceLikelihood.NEGATIVE,  # 'Н'
        58: SequenceLikelihood.NEGATIVE,  # 'О'
        32: SequenceLikelihood.NEGATIVE,  # 'П'
        41: SequenceLikelihood.NEGATIVE,  # 'Р'
        31: SequenceLikelihood.NEGATIVE,  # 'С'
        47: SequenceLikelihood.UNLIKELY,  # 'Т'
        39: SequenceLikelihood.NEGATIVE,  # 'У'
        49: SequenceLikelihood.NEGATIVE,  # 'Ф'
        53: SequenceLikelihood.NEGATIVE,  # 'Х'
        55: SequenceLikelihood.NEGATIVE,  # 'Ц'
        54: SequenceLikelihood.NEGATIVE,  # 'Ч'
        52: SequenceLikelihood.NEGATIVE,  # 'Ш'
        61: SequenceLikelihood.NEGATIVE,  # 'Ы'
        64: SequenceLikelihood.NEGATIVE,  # 'Ь'
        51: SequenceLikelihood.NEGATIVE,  # 'Э'
        59: SequenceLikelihood.NEGATIVE,  # 'Ю'
        50: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.UNLIKELY,  # 'а'
        22: SequenceLikelihood.UNLIKELY,  # 'б'
        14: SequenceLikelihood.POSITIVE,  # 'в'
        21: SequenceLikelihood.LIKELY,  # 'г'
        13: SequenceLikelihood.LIKELY,  # 'д'
        9: SequenceLikelihood.UNLIKELY,  # 'е'
        29: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.LIKELY,  # 'з'
        25: SequenceLikelihood.POSITIVE,  # 'й'
        7: SequenceLikelihood.LIKELY,  # 'к'
        8: SequenceLikelihood.POSITIVE,  # 'л'
        15: SequenceLikelihood.POSITIVE,  # 'м'
        2: SequenceLikelihood.POSITIVE,  # 'н'
        12: SequenceLikelihood.UNLIKELY,  # 'о'
        17: SequenceLikelihood.LIKELY,  # 'п'
        4: SequenceLikelihood.POSITIVE,  # 'р'
        5: SequenceLikelihood.POSITIVE,  # 'с'
        10: SequenceLikelihood.LIKELY,  # 'т'
        16: SequenceLikelihood.NEGATIVE,  # 'у'
        34: SequenceLikelihood.UNLIKELY,  # 'ф'
        27: SequenceLikelihood.UNLIKELY,  # 'х'
        20: SequenceLikelihood.UNLIKELY,  # 'ц'
        23: SequenceLikelihood.UNLIKELY,  # 'ч'
        28: SequenceLikelihood.UNLIKELY,  # 'ш'
        6: SequenceLikelihood.UNLIKELY,  # 'ы'
        26: SequenceLikelihood.NEGATIVE,  # 'ь'
        24: SequenceLikelihood.UNLIKELY,  # 'э'
        30: SequenceLikelihood.LIKELY,  # 'ю'
        11: SequenceLikelihood.UNLIKELY,  # 'я'
        35: SequenceLikelihood.UNLIKELY,  # 'ё'
        3: SequenceLikelihood.UNLIKELY,  # 'і'
        19: SequenceLikelihood.POSITIVE,  # 'ў'
    },
    3: {  # 'і'
        65: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ё'
        48: SequenceLikelihood.NEGATIVE,  # 'І'
        62: SequenceLikelihood.NEGATIVE,  # 'Ў'
        33: SequenceLikelihood.UNLIKELY,  # 'А'
        36: SequenceLikelihood.UNLIKELY,  # 'Б'
        40: SequenceLikelihood.UNLIKELY,  # 'В'
        43: SequenceLikelihood.UNLIKELY,  # 'Г'
        45: SequenceLikelihood.NEGATIVE,  # 'Д'
        56: SequenceLikelihood.NEGATIVE,  # 'Е'
        57: SequenceLikelihood.NEGATIVE,  # 'Ж'
        46: SequenceLikelihood.UNLIKELY,  # 'З'
        63: SequenceLikelihood.NEGATIVE,  # 'Й'
        37: SequenceLikelihood.UNLIKELY,  # 'К'
        44: SequenceLikelihood.UNLIKELY,  # 'Л'
        38: SequenceLikelihood.UNLIKELY,  # 'М'
        42: SequenceLikelihood.UNLIKELY,  # 'Н'
        58: SequenceLikelihood.NEGATIVE,  # 'О'
        32: SequenceLikelihood.UNLIKELY,  # 'П'
        41: SequenceLikelihood.UNLIKELY,  # 'Р'
        31: SequenceLikelihood.UNLIKELY,  # 'С'
        47: SequenceLikelihood.NEGATIVE,  # 'Т'
        39: SequenceLikelihood.UNLIKELY,  # 'У'
        49: SequenceLikelihood.NEGATIVE,  # 'Ф'
        53: SequenceLikelihood.NEGATIVE,  # 'Х'
        55: SequenceLikelihood.UNLIKELY,  # 'Ц'
        54: SequenceLikelihood.NEGATIVE,  # 'Ч'
        52: SequenceLikelihood.NEGATIVE,  # 'Ш'
        61: SequenceLikelihood.NEGATIVE,  # 'Ы'
        64: SequenceLikelihood.NEGATIVE,  # 'Ь'
        51: SequenceLikelihood.NEGATIVE,  # 'Э'
        59: SequenceLikelihood.NEGATIVE,  # 'Ю'
        50: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.LIKELY,  # 'а'
        22: SequenceLikelihood.POSITIVE,  # 'б'
        14: SequenceLikelihood.POSITIVE,  # 'в'
        21: SequenceLikelihood.POSITIVE,  # 'г'
        13: SequenceLikelihood.POSITIVE,  # 'д'
        9: SequenceLikelihood.LIKELY,  # 'е'
        29: SequenceLikelihood.POSITIVE,  # 'ж'
        18: SequenceLikelihood.POSITIVE,  # 'з'
        25: SequenceLikelihood.POSITIVE,  # 'й'
        7: SequenceLikelihood.POSITIVE,  # 'к'
        8: SequenceLikelihood.POSITIVE,  # 'л'
        15: SequenceLikelihood.POSITIVE,  # 'м'
        2: SequenceLikelihood.POSITIVE,  # 'н'
        12: SequenceLikelihood.LIKELY,  # 'о'
        17: SequenceLikelihood.POSITIVE,  # 'п'
        4: SequenceLikelihood.POSITIVE,  # 'р'
        5: SequenceLikelihood.POSITIVE,  # 'с'
        10: SequenceLikelihood.POSITIVE,  # 'т'
        16: SequenceLikelihood.LIKELY,  # 'у'
        34: SequenceLikelihood.LIKELY,  # 'ф'
        27: SequenceLikelihood.POSITIVE,  # 'х'
        20: SequenceLikelihood.POSITIVE,  # 'ц'
        23: SequenceLikelihood.POSITIVE,  # 'ч'
        28: SequenceLikelihood.POSITIVE,  # 'ш'
        6: SequenceLikelihood.UNLIKELY,  # 'ы'
        26: SequenceLikelihood.UNLIKELY,  # 'ь'
        24: SequenceLikelihood.UNLIKELY,  # 'э'
        30: SequenceLikelihood.POSITIVE,  # 'ю'
        11: SequenceLikelihood.POSITIVE,  # 'я'
        35: SequenceLikelihood.POSITIVE,  # 'ё'
        3: SequenceLikelihood.POSITIVE,  # 'і'
        19: SequenceLikelihood.POSITIVE,  # 'ў'
    },
    19: {  # 'ў'
        65: SequenceLikelihood.NEGATIVE,  # 'ʼ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ё'
        48: SequenceLikelihood.NEGATIVE,  # 'І'
        62: SequenceLikelihood.NEGATIVE,  # 'Ў'
        33: SequenceLikelihood.UNLIKELY,  # 'А'
        36: SequenceLikelihood.NEGATIVE,  # 'Б'
        40: SequenceLikelihood.NEGATIVE,  # 'В'
        43: SequenceLikelihood.NEGATIVE,  # 'Г'
        45: SequenceLikelihood.NEGATIVE,  # 'Д'
        56: SequenceLikelihood.NEGATIVE,  # 'Е'
        57: SequenceLikelihood.NEGATIVE,  # 'Ж'
        46: SequenceLikelihood.NEGATIVE,  # 'З'
        63: SequenceLikelihood.NEGATIVE,  # 'Й'
        37: SequenceLikelihood.NEGATIVE,  # 'К'
        44: SequenceLikelihood.NEGATIVE,  # 'Л'
        38: SequenceLikelihood.NEGATIVE,  # 'М'
        42: SequenceLikelihood.NEGATIVE,  # 'Н'
        58: SequenceLikelihood.NEGATIVE,  # 'О'
        32: SequenceLikelihood.UNLIKELY,  # 'П'
        41: SequenceLikelihood.NEGATIVE,  # 'Р'
        31: SequenceLikelihood.NEGATIVE,  # 'С'
        47: SequenceLikelihood.NEGATIVE,  # 'Т'
        39: SequenceLikelihood.NEGATIVE,  # 'У'
        49: SequenceLikelihood.NEGATIVE,  # 'Ф'
        53: SequenceLikelihood.NEGATIVE,  # 'Х'
        55: SequenceLikelihood.NEGATIVE,  # 'Ц'
        54: SequenceLikelihood.NEGATIVE,  # 'Ч'
        52: SequenceLikelihood.NEGATIVE,  # 'Ш'
        61: SequenceLikelihood.NEGATIVE,  # 'Ы'
        64: SequenceLikelihood.NEGATIVE,  # 'Ь'
        51: SequenceLikelihood.NEGATIVE,  # 'Э'
        59: SequenceLikelihood.NEGATIVE,  # 'Ю'
        50: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.UNLIKELY,  # 'а'
        22: SequenceLikelihood.LIKELY,  # 'б'
        14: SequenceLikelihood.POSITIVE,  # 'в'
        21: SequenceLikelihood.POSITIVE,  # 'г'
        13: SequenceLikelihood.POSITIVE,  # 'д'
        9: SequenceLikelihood.LIKELY,  # 'е'
        29: SequenceLikelihood.POSITIVE,  # 'ж'
        18: SequenceLikelihood.POSITIVE,  # 'з'
        25: SequenceLikelihood.UNLIKELY,  # 'й'
        7: SequenceLikelihood.POSITIVE,  # 'к'
        8: SequenceLikelihood.POSITIVE,  # 'л'
        15: SequenceLikelihood.LIKELY,  # 'м'
        2: SequenceLikelihood.POSITIVE,  # 'н'
        12: SequenceLikelihood.UNLIKELY,  # 'о'
        17: SequenceLikelihood.LIKELY,  # 'п'
        4: SequenceLikelihood.POSITIVE,  # 'р'
        5: SequenceLikelihood.POSITIVE,  # 'с'
        10: SequenceLikelihood.POSITIVE,  # 'т'
        16: SequenceLikelihood.UNLIKELY,  # 'у'
        34: SequenceLikelihood.LIKELY,  # 'ф'
        27: SequenceLikelihood.LIKELY,  # 'х'
        20: SequenceLikelihood.POSITIVE,  # 'ц'
        23: SequenceLikelihood.LIKELY,  # 'ч'
        28: SequenceLikelihood.POSITIVE,  # 'ш'
        6: SequenceLikelihood.UNLIKELY,  # 'ы'
        26: SequenceLikelihood.NEGATIVE,  # 'ь'
        24: SequenceLikelihood.UNLIKELY,  # 'э'
        30: SequenceLikelihood.UNLIKELY,  # 'ю'
        11: SequenceLikelihood.LIKELY,  # 'я'
        35: SequenceLikelihood.UNLIKELY,  # 'ё'
        3: SequenceLikelihood.LIKELY,  # 'і'
        19: SequenceLikelihood.NEGATIVE,  # 'ў'
    },
}

# Character Mapping Table(s):
ISO_8859_5_BELARUSIAN_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 0,  # 'A'
    66: 0,  # 'B'
    67: 0,  # 'C'
    68: 0,  # 'D'
    69: 0,  # 'E'
    70: 0,  # 'F'
    71: 0,  # 'G'
    72: 0,  # 'H'
    73: 0,  # 'I'
    74: 0,  # 'J'
    75: 0,  # 'K'
    76: 0,  # 'L'
    77: 0,  # 'M'
    78: 0,  # 'N'
    79: 0,  # 'O'
    80: 0,  # 'P'
    81: 0,  # 'Q'
    82: 0,  # 'R'
    83: 0,  # 'S'
    84: 0,  # 'T'
    85: 0,  # 'U'
    86: 0,  # 'V'
    87: 0,  # 'W'
    88: 0,  # 'X'
    89: 0,  # 'Y'
    90: 0,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 0,  # 'a'
    98: 0,  # 'b'
    99: 0,  # 'c'
    100: 0,  # 'd'
    101: 0,  # 'e'
    102: 0,  # 'f'
    103: 0,  # 'g'
    104: 0,  # 'h'
    105: 0,  # 'i'
    106: 0,  # 'j'
    107: 0,  # 'k'
    108: 0,  # 'l'
    109: 0,  # 'm'
    110: 0,  # 'n'
    111: 0,  # 'o'
    112: 0,  # 'p'
    113: 0,  # 'q'
    114: 0,  # 'r'
    115: 0,  # 's'
    116: 0,  # 't'
    117: 0,  # 'u'
    118: 0,  # 'v'
    119: 0,  # 'w'
    120: 0,  # 'x'
    121: 0,  # 'y'
    122: 0,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: CharacterCategory.CONTROL,  # '\x80'
    129: CharacterCategory.CONTROL,  # '\x81'
    130: CharacterCategory.CONTROL,  # '\x82'
    131: CharacterCategory.CONTROL,  # '\x83'
    132: CharacterCategory.CONTROL,  # '\x84'
    133: CharacterCategory.CONTROL,  # '\x85'
    134: CharacterCategory.CONTROL,  # '\x86'
    135: CharacterCategory.CONTROL,  # '\x87'
    136: CharacterCategory.CONTROL,  # '\x88'
    137: CharacterCategory.CONTROL,  # '\x89'
    138: CharacterCategory.CONTROL,  # '\x8a'
    139: CharacterCategory.CONTROL,  # '\x8b'
    140: CharacterCategory.CONTROL,  # '\x8c'
    141: CharacterCategory.CONTROL,  # '\x8d'
    142: CharacterCategory.CONTROL,  # '\x8e'
    143: CharacterCategory.CONTROL,  # '\x8f'
    144: CharacterCategory.CONTROL,  # '\x90'
    145: CharacterCategory.CONTROL,  # '\x91'
    146: CharacterCategory.CONTROL,  # '\x92'
    147: CharacterCategory.CONTROL,  # '\x93'
    148: CharacterCategory.CONTROL,  # '\x94'
    149: CharacterCategory.CONTROL,  # '\x95'
    150: CharacterCategory.CONTROL,  # '\x96'
    151: CharacterCategory.CONTROL,  # '\x97'
    152: CharacterCategory.CONTROL,  # '\x98'
    153: CharacterCategory.CONTROL,  # '\x99'
    154: CharacterCategory.CONTROL,  # '\x9a'
    155: CharacterCategory.CONTROL,  # '\x9b'
    156: CharacterCategory.CONTROL,  # '\x9c'
    157: CharacterCategory.CONTROL,  # '\x9d'
    158: CharacterCategory.CONTROL,  # '\x9e'
    159: CharacterCategory.CONTROL,  # '\x9f'
    160: CharacterCategory.CONTROL,  # '\xa0'
    161: 60,  # 'Ё'
    162: 0,  # 'Ђ'
    163: 0,  # 'Ѓ'
    164: 0,  # 'Є'
    165: 0,  # 'Ѕ'
    166: 48,  # 'І'
    167: 0,  # 'Ї'
    168: 0,  # 'Ј'
    169: 0,  # 'Љ'
    170: 0,  # 'Њ'
    171: 0,  # 'Ћ'
    172: 0,  # 'Ќ'
    173: CharacterCategory.CONTROL,  # '\xad'
    174: 62,  # 'Ў'
    175: 0,  # 'Џ'
    176: 33,  # 'А'
    177: 36,  # 'Б'
    178: 40,  # 'В'
    179: 43,  # 'Г'
    180: 45,  # 'Д'
    181: 56,  # 'Е'
    182: 57,  # 'Ж'
    183: 46,  # 'З'
    184: 0,  # 'И'
    185: 63,  # 'Й'
    186: 37,  # 'К'
    187: 44,  # 'Л'
    188: 38,  # 'М'
    189: 42,  # 'Н'
    190: 58,  # 'О'
    191: 32,  # 'П'
    192: 41,  # 'Р'
    193: 31,  # 'С'
    194: 47,  # 'Т'
    195: 39,  # 'У'
    196: 49,  # 'Ф'
    197: 53,  # 'Х'
    198: 55,  # 'Ц'
    199: 54,  # 'Ч'
    200: 52,  # 'Ш'
    201: 0,  # 'Щ'
    202: 0,  # 'Ъ'
    203: 61,  # 'Ы'
    204: 64,  # 'Ь'
    205: 51,  # 'Э'
    206: 59,  # 'Ю'
    207: 50,  # 'Я'
    208: 1,  # 'а'
    209: 22,  # 'б'
    210: 14,  # 'в'
    211: 21,  # 'г'
    212: 13,  # 'д'
    213: 9,  # 'е'
    214: 29,  # 'ж'
    215: 18,  # 'з'
    216: 0,  # 'и'
    217: 25,  # 'й'
    218: 7,  # 'к'
    219: 8,  # 'л'
    220: 15,  # 'м'
    221: 2,  # 'н'
    222: 12,  # 'о'
    223: 17,  # 'п'
    224: 4,  # 'р'
    225: 5,  # 'с'
    226: 10,  # 'т'
    227: 16,  # 'у'
    228: 34,  # 'ф'
    229: 27,  # 'х'
    230: 20,  # 'ц'
    231: 23,  # 'ч'
    232: 28,  # 'ш'
    233: 0,  # 'щ'
    234: 0,  # 'ъ'
    235: 6,  # 'ы'
    236: 26,  # 'ь'
    237: 24,  # 'э'
    238: 30,  # 'ю'
    239: 11,  # 'я'
    240: CharacterCategory.SYMBOL,  # '№'
    241: 35,  # 'ё'
    242: 0,  # 'ђ'
    243: 0,  # 'ѓ'
    244: 0,  # 'є'
    245: 0,  # 'ѕ'
    246: 3,  # 'і'
    247: 0,  # 'ї'
    248: 0,  # 'ј'
    249: 0,  # 'љ'
    250: 0,  # 'њ'
    251: 0,  # 'ћ'
    252: 0,  # 'ќ'
    253: CharacterCategory.SYMBOL,  # '§'
    254: 19,  # 'ў'
    255: 0,  # 'џ'
}

ISO_8859_5_BELARUSIAN_MODEL = SingleByteCharSetModel(
    charset_name="ISO-8859-5",
    language="Belarusian",
    char_to_order_map=ISO_8859_5_BELARUSIAN_CHAR_TO_ORDER,
    language_model=BELARUSIAN_LANG_MODEL,
    typical_positive_ratio=0.9680991569568315,
    keep_ascii_letters=False,
    alphabet="ʼЁІЎАБВГДЕЖЗЙКЛМНОПРСТУФХЦЧШЫЬЭЮЯабвгдежзйклмнопрстуфхцчшыьэюяёіў",
)

WINDOWS_1251_BELARUSIAN_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 0,  # 'A'
    66: 0,  # 'B'
    67: 0,  # 'C'
    68: 0,  # 'D'
    69: 0,  # 'E'
    70: 0,  # 'F'
    71: 0,  # 'G'
    72: 0,  # 'H'
    73: 0,  # 'I'
    74: 0,  # 'J'
    75: 0,  # 'K'
    76: 0,  # 'L'
    77: 0,  # 'M'
    78: 0,  # 'N'
    79: 0,  # 'O'
    80: 0,  # 'P'
    81: 0,  # 'Q'
    82: 0,  # 'R'
    83: 0,  # 'S'
    84: 0,  # 'T'
    85: 0,  # 'U'
    86: 0,  # 'V'
    87: 0,  # 'W'
    88: 0,  # 'X'
    89: 0,  # 'Y'
    90: 0,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 0,  # 'a'
    98: 0,  # 'b'
    99: 0,  # 'c'
    100: 0,  # 'd'
    101: 0,  # 'e'
    102: 0,  # 'f'
    103: 0,  # 'g'
    104: 0,  # 'h'
    105: 0,  # 'i'
    106: 0,  # 'j'
    107: 0,  # 'k'
    108: 0,  # 'l'
    109: 0,  # 'm'
    110: 0,  # 'n'
    111: 0,  # 'o'
    112: 0,  # 'p'
    113: 0,  # 'q'
    114: 0,  # 'r'
    115: 0,  # 's'
    116: 0,  # 't'
    117: 0,  # 'u'
    118: 0,  # 'v'
    119: 0,  # 'w'
    120: 0,  # 'x'
    121: 0,  # 'y'
    122: 0,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: 0,  # 'Ђ'
    129: 0,  # 'Ѓ'
    130: CharacterCategory.SYMBOL,  # '‚'
    131: 0,  # 'ѓ'
    132: CharacterCategory.SYMBOL,  # '„'
    133: CharacterCategory.SYMBOL,  # '…'
    134: CharacterCategory.SYMBOL,  # '†'
    135: CharacterCategory.SYMBOL,  # '‡'
    136: CharacterCategory.SYMBOL,  # '€'
    137: CharacterCategory.SYMBOL,  # '‰'
    138: 0,  # 'Љ'
    139: CharacterCategory.SYMBOL,  # '‹'
    140: 0,  # 'Њ'
    141: 0,  # 'Ќ'
    142: 0,  # 'Ћ'
    143: 0,  # 'Џ'
    144: 0,  # 'ђ'
    145: CharacterCategory.SYMBOL,  # '‘'
    146: CharacterCategory.SYMBOL,  # '’'
    147: CharacterCategory.SYMBOL,  # '“'
    148: CharacterCategory.SYMBOL,  # '”'
    149: CharacterCategory.SYMBOL,  # '•'
    150: CharacterCategory.SYMBOL,  # '–'
    151: CharacterCategory.SYMBOL,  # '—'
    152: CharacterCategory.UNDEFINED,  # None
    153: CharacterCategory.SYMBOL,  # '™'
    154: 0,  # 'љ'
    155: CharacterCategory.SYMBOL,  # '›'
    156: 0,  # 'њ'
    157: 0,  # 'ќ'
    158: 0,  # 'ћ'
    159: 0,  # 'џ'
    160: CharacterCategory.CONTROL,  # '\xa0'
    161: 62,  # 'Ў'
    162: 19,  # 'ў'
    163: 0,  # 'Ј'
    164: CharacterCategory.SYMBOL,  # '¤'
    165: 0,  # 'Ґ'
    166: CharacterCategory.SYMBOL,  # '¦'
    167: CharacterCategory.SYMBOL,  # '§'
    168: 60,  # 'Ё'
    169: CharacterCategory.SYMBOL,  # '©'
    170: 0,  # 'Є'
    171: CharacterCategory.SYMBOL,  # '«'
    172: CharacterCategory.SYMBOL,  # '¬'
    173: CharacterCategory.CONTROL,  # '\xad'
    174: CharacterCategory.SYMBOL,  # '®'
    175: 0,  # 'Ї'
    176: CharacterCategory.SYMBOL,  # '°'
    177: CharacterCategory.SYMBOL,  # '±'
    178: 48,  # 'І'
    179: 3,  # 'і'
    180: 0,  # 'ґ'
    181: 0,  # 'µ'
    182: CharacterCategory.SYMBOL,  # '¶'
    183: CharacterCategory.SYMBOL,  # '·'
    184: 35,  # 'ё'
    185: CharacterCategory.SYMBOL,  # '№'
    186: 0,  # 'є'
    187: CharacterCategory.SYMBOL,  # '»'
    188: 0,  # 'ј'
    189: 0,  # 'Ѕ'
    190: 0,  # 'ѕ'
    191: 0,  # 'ї'
    192: 33,  # 'А'
    193: 36,  # 'Б'
    194: 40,  # 'В'
    195: 43,  # 'Г'
    196: 45,  # 'Д'
    197: 56,  # 'Е'
    198: 57,  # 'Ж'
    199: 46,  # 'З'
    200: 0,  # 'И'
    201: 63,  # 'Й'
    202: 37,  # 'К'
    203: 44,  # 'Л'
    204: 38,  # 'М'
    205: 42,  # 'Н'
    206: 58,  # 'О'
    207: 32,  # 'П'
    208: 41,  # 'Р'
    209: 31,  # 'С'
    210: 47,  # 'Т'
    211: 39,  # 'У'
    212: 49,  # 'Ф'
    213: 53,  # 'Х'
    214: 55,  # 'Ц'
    215: 54,  # 'Ч'
    216: 52,  # 'Ш'
    217: 0,  # 'Щ'
    218: 0,  # 'Ъ'
    219: 61,  # 'Ы'
    220: 64,  # 'Ь'
    221: 51,  # 'Э'
    222: 59,  # 'Ю'
    223: 50,  # 'Я'
    224: 1,  # 'а'
    225: 22,  # 'б'
    226: 14,  # 'в'
    227: 21,  # 'г'
    228: 13,  # 'д'
    229: 9,  # 'е'
    230: 29,  # 'ж'
    231: 18,  # 'з'
    232: 0,  # 'и'
    233: 25,  # 'й'
    234: 7,  # 'к'
    235: 8,  # 'л'
    236: 15,  # 'м'
    237: 2,  # 'н'
    238: 12,  # 'о'
    239: 17,  # 'п'
    240: 4,  # 'р'
    241: 5,  # 'с'
    242: 10,  # 'т'
    243: 16,  # 'у'
    244: 34,  # 'ф'
    245: 27,  # 'х'
    246: 20,  # 'ц'
    247: 23,  # 'ч'
    248: 28,  # 'ш'
    249: 0,  # 'щ'
    250: 0,  # 'ъ'
    251: 6,  # 'ы'
    252: 26,  # 'ь'
    253: 24,  # 'э'
    254: 30,  # 'ю'
    255: 11,  # 'я'
}

WINDOWS_1251_BELARUSIAN_MODEL = SingleByteCharSetModel(
    charset_name="WINDOWS-1251",
    language="Belarusian",
    char_to_order_map=WINDOWS_1251_BELARUSIAN_CHAR_TO_ORDER,
    language_model=BELARUSIAN_LANG_MODEL,
    typical_positive_ratio=0.9680991569568315,
    keep_ascii_letters=False,
    alphabet="ʼЁІЎАБВГДЕЖЗЙКЛМНОПРСТУФХЦЧШЫЬЭЮЯабвгдежзйклмнопрстуфхцчшыьэюяёіў",
)

CP866_BELARUSIAN_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 0,  # 'A'
    66: 0,  # 'B'
    67: 0,  # 'C'
    68: 0,  # 'D'
    69: 0,  # 'E'
    70: 0,  # 'F'
    71: 0,  # 'G'
    72: 0,  # 'H'
    73: 0,  # 'I'
    74: 0,  # 'J'
    75: 0,  # 'K'
    76: 0,  # 'L'
    77: 0,  # 'M'
    78: 0,  # 'N'
    79: 0,  # 'O'
    80: 0,  # 'P'
    81: 0,  # 'Q'
    82: 0,  # 'R'
    83: 0,  # 'S'
    84: 0,  # 'T'
    85: 0,  # 'U'
    86: 0,  # 'V'
    87: 0,  # 'W'
    88: 0,  # 'X'
    89: 0,  # 'Y'
    90: 0,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 0,  # 'a'
    98: 0,  # 'b'
    99: 0,  # 'c'
    100: 0,  # 'd'
    101: 0,  # 'e'
    102: 0,  # 'f'
    103: 0,  # 'g'
    104: 0,  # 'h'
    105: 0,  # 'i'
    106: 0,  # 'j'
    107: 0,  # 'k'
    108: 0,  # 'l'
    109: 0,  # 'm'
    110: 0,  # 'n'
    111: 0,  # 'o'
    112: 0,  # 'p'
    113: 0,  # 'q'
    114: 0,  # 'r'
    115: 0,  # 's'
    116: 0,  # 't'
    117: 0,  # 'u'
    118: 0,  # 'v'
    119: 0,  # 'w'
    120: 0,  # 'x'
    121: 0,  # 'y'
    122: 0,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: 33,  # 'А'
    129: 36,  # 'Б'
    130: 40,  # 'В'
    131: 43,  # 'Г'
    132: 45,  # 'Д'
    133: 56,  # 'Е'
    134: 57,  # 'Ж'
    135: 46,  # 'З'
    136: 0,  # 'И'
    137: 63,  # 'Й'
    138: 37,  # 'К'
    139: 44,  # 'Л'
    140: 38,  # 'М'
    141: 42,  # 'Н'
    142: 58,  # 'О'
    143: 32,  # 'П'
    144: 41,  # 'Р'
    145: 31,  # 'С'
    146: 47,  # 'Т'
    147: 39,  # 'У'
    148: 49,  # 'Ф'
    149: 53,  # 'Х'
    150: 55,  # 'Ц'
    151: 54,  # 'Ч'
    152: 52,  # 'Ш'
    153: 0,  # 'Щ'
    154: 0,  # 'Ъ'
    155: 61,  # 'Ы'
    156: 64,  # 'Ь'
    157: 51,  # 'Э'
    158: 59,  # 'Ю'
    159: 50,  # 'Я'
    160: 1,  # 'а'
    161: 22,  # 'б'
    162: 14,  # 'в'
    163: 21,  # 'г'
    164: 13,  # 'д'
    165: 9,  # 'е'
    166: 29,  # 'ж'
    167: 18,  # 'з'
    168: 0,  # 'и'
    169: 25,  # 'й'
    170: 7,  # 'к'
    171: 8,  # 'л'
    172: 15,  # 'м'
    173: 2,  # 'н'
    174: 12,  # 'о'
    175: 17,  # 'п'
    176: CharacterCategory.SYMBOL,  # '░'
    177: CharacterCategory.SYMBOL,  # '▒'
    178: CharacterCategory.SYMBOL,  # '▓'
    179: CharacterCategory.SYMBOL,  # '│'
    180: CharacterCategory.SYMBOL,  # '┤'
    181: CharacterCategory.SYMBOL,  # '╡'
    182: CharacterCategory.SYMBOL,  # '╢'
    183: CharacterCategory.SYMBOL,  # '╖'
    184: CharacterCategory.SYMBOL,  # '╕'
    185: CharacterCategory.SYMBOL,  # '╣'
    186: CharacterCategory.SYMBOL,  # '║'
    187: CharacterCategory.SYMBOL,  # '╗'
    188: CharacterCategory.SYMBOL,  # '╝'
    189: CharacterCategory.SYMBOL,  # '╜'
    190: CharacterCategory.SYMBOL,  # '╛'
    191: CharacterCategory.SYMBOL,  # '┐'
    192: CharacterCategory.SYMBOL,  # '└'
    193: CharacterCategory.SYMBOL,  # '┴'
    194: CharacterCategory.SYMBOL,  # '┬'
    195: CharacterCategory.SYMBOL,  # '├'
    196: CharacterCategory.SYMBOL,  # '─'
    197: CharacterCategory.SYMBOL,  # '┼'
    198: CharacterCategory.SYMBOL,  # '╞'
    199: CharacterCategory.SYMBOL,  # '╟'
    200: CharacterCategory.SYMBOL,  # '╚'
    201: CharacterCategory.SYMBOL,  # '╔'
    202: CharacterCategory.SYMBOL,  # '╩'
    203: CharacterCategory.SYMBOL,  # '╦'
    204: CharacterCategory.SYMBOL,  # '╠'
    205: CharacterCategory.SYMBOL,  # '═'
    206: CharacterCategory.SYMBOL,  # '╬'
    207: CharacterCategory.SYMBOL,  # '╧'
    208: CharacterCategory.SYMBOL,  # '╨'
    209: CharacterCategory.SYMBOL,  # '╤'
    210: CharacterCategory.SYMBOL,  # '╥'
    211: CharacterCategory.SYMBOL,  # '╙'
    212: CharacterCategory.SYMBOL,  # '╘'
    213: CharacterCategory.SYMBOL,  # '╒'
    214: CharacterCategory.SYMBOL,  # '╓'
    215: CharacterCategory.SYMBOL,  # '╫'
    216: CharacterCategory.SYMBOL,  # '╪'
    217: CharacterCategory.SYMBOL,  # '┘'
    218: CharacterCategory.SYMBOL,  # '┌'
    219: CharacterCategory.SYMBOL,  # '█'
    220: CharacterCategory.SYMBOL,  # '▄'
    221: CharacterCategory.SYMBOL,  # '▌'
    222: CharacterCategory.SYMBOL,  # '▐'
    223: CharacterCategory.SYMBOL,  # '▀'
    224: 4,  # 'р'
    225: 5,  # 'с'
    226: 10,  # 'т'
    227: 16,  # 'у'
    228: 34,  # 'ф'
    229: 27,  # 'х'
    230: 20,  # 'ц'
    231: 23,  # 'ч'
    232: 28,  # 'ш'
    233: 0,  # 'щ'
    234: 0,  # 'ъ'
    235: 6,  # 'ы'
    236: 26,  # 'ь'
    237: 24,  # 'э'
    238: 30,  # 'ю'
    239: 11,  # 'я'
    240: 60,  # 'Ё'
    241: 35,  # 'ё'
    242: 0,  # 'Є'
    243: 0,  # 'є'
    244: 0,  # 'Ї'
    245: 0,  # 'ї'
    246: 62,  # 'Ў'
    247: 19,  # 'ў'
    248: CharacterCategory.SYMBOL,  # '°'
    249: CharacterCategory.SYMBOL,  # '∙'
    250: CharacterCategory.SYMBOL,  # '·'
    251: CharacterCategory.SYMBOL,  # '√'
    252: CharacterCategory.SYMBOL,  # '№'
    253: CharacterCategory.SYMBOL,  # '¤'
    254: CharacterCategory.SYMBOL,  # '■'
    255: CharacterCategory.CONTROL,  # '\xa0'
}

CP866_BELARUSIAN_MODEL = SingleByteCharSetModel(
    charset_name="CP866",
    language="Belarusian",
    char_to_order_map=CP866_BELARUSIAN_CHAR_TO_ORDER,
    language_model=BELARUSIAN_LANG_MODEL,
    typical_positive_ratio=0.967059731035038,
    keep_ascii_letters=False,
    alphabet="ʼЁІЎАБВГДЕЖЗЙКЛМНОПРСТУФХЦЧШЫЬЭЮЯабвгдежзйклмнопрстуфхцчшыьэюяёіў",
)

MACCYRILLIC_BELARUSIAN_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 0,  # 'A'
    66: 0,  # 'B'
    67: 0,  # 'C'
    68: 0,  # 'D'
    69: 0,  # 'E'
    70: 0,  # 'F'
    71: 0,  # 'G'
    72: 0,  # 'H'
    73: 0,  # 'I'
    74: 0,  # 'J'
    75: 0,  # 'K'
    76: 0,  # 'L'
    77: 0,  # 'M'
    78: 0,  # 'N'
    79: 0,  # 'O'
    80: 0,  # 'P'
    81: 0,  # 'Q'
    82: 0,  # 'R'
    83: 0,  # 'S'
    84: 0,  # 'T'
    85: 0,  # 'U'
    86: 0,  # 'V'
    87: 0,  # 'W'
    88: 0,  # 'X'
    89: 0,  # 'Y'
    90: 0,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 0,  # 'a'
    98: 0,  # 'b'
    99: 0,  # 'c'
    100: 0,  # 'd'
    101: 0,  # 'e'
    102: 0,  # 'f'
    103: 0,  # 'g'
    104: 0,  # 'h'
    105: 0,  # 'i'
    106: 0,  # 'j'
    107: 0,  # 'k'
    108: 0,  # 'l'
    109: 0,  # 'm'
    110: 0,  # 'n'
    111: 0,  # 'o'
    112: 0,  # 'p'
    113: 0,  # 'q'
    114: 0,  # 'r'
    115: 0,  # 's'
    116: 0,  # 't'
    117: 0,  # 'u'
    118: 0,  # 'v'
    119: 0,  # 'w'
    120: 0,  # 'x'
    121: 0,  # 'y'
    122: 0,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: 33,  # 'А'
    129: 36,  # 'Б'
    130: 40,  # 'В'
    131: 43,  # 'Г'
    132: 45,  # 'Д'
    133: 56,  # 'Е'
    134: 57,  # 'Ж'
    135: 46,  # 'З'
    136: 0,  # 'И'
    137: 63,  # 'Й'
    138: 37,  # 'К'
    139: 44,  # 'Л'
    140: 38,  # 'М'
    141: 42,  # 'Н'
    142: 58,  # 'О'
    143: 32,  # 'П'
    144: 41,  # 'Р'
    145: 31,  # 'С'
    146: 47,  # 'Т'
    147: 39,  # 'У'
    148: 49,  # 'Ф'
    149: 53,  # 'Х'
    150: 55,  # 'Ц'
    151: 54,  # 'Ч'
    152: 52,  # 'Ш'
    153: 0,  # 'Щ'
    154: 0,  # 'Ъ'
    155: 61,  # 'Ы'
    156: 64,  # 'Ь'
    157: 51,  # 'Э'
    158: 59,  # 'Ю'
    159: 50,  # 'Я'
    160: CharacterCategory.SYMBOL,  # '†'
    161: CharacterCategory.SYMBOL,  # '°'
    162: 0,  # 'Ґ'
    163: CharacterCategory.SYMBOL,  # '£'
    164: CharacterCategory.SYMBOL,  # '§'
    165: CharacterCategory.SYMBOL,  # '•'
    166: CharacterCategory.SYMBOL,  # '¶'
    167: 48,  # 'І'
    168: CharacterCategory.SYMBOL,  # '®'
    169: CharacterCategory.SYMBOL,  # '©'
    170: CharacterCategory.SYMBOL,  # '™'
    171: 0,  # 'Ђ'
    172: 0,  # 'ђ'
    173: CharacterCategory.SYMBOL,  # '≠'
    174: 0,  # 'Ѓ'
    175: 0,  # 'ѓ'
    176: CharacterCategory.SYMBOL,  # '∞'
    177: CharacterCategory.SYMBOL,  # '±'
    178: CharacterCategory.SYMBOL,  # '≤'
    179: CharacterCategory.SYMBOL,  # '≥'
    180: 3,  # 'і'
    181: 0,  # 'µ'
    182: 0,  # 'ґ'
    183: 0,  # 'Ј'
    184: 0,  # 'Є'
    185: 0,  # 'є'
    186: 0,  # 'Ї'
    187: 0,  # 'ї'
    188: 0,  # 'Љ'
    189: 0,  # 'љ'
    190: 0,  # 'Њ'
    191: 0,  # 'њ'
    192: 0,  # 'ј'
    193: 0,  # 'Ѕ'
    194: CharacterCategory.SYMBOL,  # '¬'
    195: CharacterCategory.SYMBOL,  # '√'
    196: 0,  # 'ƒ'
    197: CharacterCategory.SYMBOL,  # '≈'
    198: CharacterCategory.SYMBOL,  # '∆'
    199: CharacterCategory.SYMBOL,  # '«'
    200: CharacterCategory.SYMBOL,  # '»'
    201: CharacterCategory.SYMBOL,  # '…'
    202: CharacterCategory.CONTROL,  # '\xa0'
    203: 0,  # 'Ћ'
    204: 0,  # 'ћ'
    205: 0,  # 'Ќ'
    206: 0,  # 'ќ'
    207: 0,  # 'ѕ'
    208: CharacterCategory.SYMBOL,  # '–'
    209: CharacterCategory.SYMBOL,  # '—'
    210: CharacterCategory.SYMBOL,  # '“'
    211: CharacterCategory.SYMBOL,  # '”'
    212: CharacterCategory.SYMBOL,  # '‘'
    213: CharacterCategory.SYMBOL,  # '’'
    214: CharacterCategory.SYMBOL,  # '÷'
    215: CharacterCategory.SYMBOL,  # '„'
    216: 62,  # 'Ў'
    217: 19,  # 'ў'
    218: 0,  # 'Џ'
    219: 0,  # 'џ'
    220: CharacterCategory.SYMBOL,  # '№'
    221: 60,  # 'Ё'
    222: 35,  # 'ё'
    223: 11,  # 'я'
    224: 1,  # 'а'
    225: 22,  # 'б'
    226: 14,  # 'в'
    227: 21,  # 'г'
    228: 13,  # 'д'
    229: 9,  # 'е'
    230: 29,  # 'ж'
    231: 18,  # 'з'
    232: 0,  # 'и'
    233: 25,  # 'й'
    234: 7,  # 'к'
    235: 8,  # 'л'
    236: 15,  # 'м'
    237: 2,  # 'н'
    238: 12,  # 'о'
    239: 17,  # 'п'
    240: 4,  # 'р'
    241: 5,  # 'с'
    242: 10,  # 'т'
    243: 16,  # 'у'
    244: 34,  # 'ф'
    245: 27,  # 'х'
    246: 20,  # 'ц'
    247: 23,  # 'ч'
    248: 28,  # 'ш'
    249: 0,  # 'щ'
    250: 0,  # 'ъ'
    251: 6,  # 'ы'
    252: 26,  # 'ь'
    253: 24,  # 'э'
    254: 30,  # 'ю'
    255: CharacterCategory.SYMBOL,  # '€'
}

MACCYRILLIC_BELARUSIAN_MODEL = SingleByteCharSetModel(
    charset_name="MacCyrillic",
    language="Belarusian",
    char_to_order_map=MACCYRILLIC_BELARUSIAN_CHAR_TO_ORDER,
    language_model=BELARUSIAN_LANG_MODEL,
    typical_positive_ratio=0.9680991569568315,
    keep_ascii_letters=False,
    alphabet="ʼЁІЎАБВГДЕЖЗЙКЛМНОПРСТУФХЦЧШЫЬЭЮЯабвгдежзйклмнопрстуфхцчшыьэюяёіў",
)
