# This file has been autogenerated by the pywayland scanner

# Copyright © 2020 - 2023 Andri Yngvason
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice (including the next
# paragraph) shall be included in all copies or substantial portions of the
# Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
# THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
# DEALINGS IN THE SOFTWARE.

from __future__ import annotations

from pywayland.protocol_core import (
    Argument,
    ArgumentType,
    Global,
    Interface,
    Proxy,
    Resource,
)


class ExtTransientSeatV1(Interface):
    """Transient seat handle

    When the transient seat handle is destroyed, the seat itself will also be
    destroyed.
    """

    name = "ext_transient_seat_v1"
    version = 1


class ExtTransientSeatV1Proxy(Proxy[ExtTransientSeatV1]):
    interface = ExtTransientSeatV1

    @ExtTransientSeatV1.request()
    def destroy(self) -> None:
        """Destroy transient seat

        When the transient seat object is destroyed by the client, the
        associated seat created by the compositor is also destroyed.
        """
        self._marshal(0)
        self._destroy()


class ExtTransientSeatV1Resource(Resource):
    interface = ExtTransientSeatV1

    @ExtTransientSeatV1.event(
        Argument(ArgumentType.Uint),
    )
    def ready(self, global_name: int) -> None:
        """Transient seat is ready

        This event advertises the global name for the
        :class:`~pywayland.protocol.wayland.WlSeat` to be used with
        wl_registry_bind.

        It is sent exactly once, immediately after the transient seat is
        created and the new ":class:`~pywayland.protocol.wayland.WlSeat`"
        global is advertised, if and only if the creation of the transient seat
        was allowed.

        :param global_name:
        :type global_name:
            `ArgumentType.Uint`
        """
        self._post_event(0, global_name)

    @ExtTransientSeatV1.event()
    def denied(self) -> None:
        """Transient seat creation denied

        The event informs the client that the compositor denied its request to
        create a transient seat.

        It is sent exactly once, immediately after the transient seat object is
        created, if and only if the creation of the transient seat was denied.

        After receiving this event, the client should destroy the object.
        """
        self._post_event(1)


class ExtTransientSeatV1Global(Global):
    interface = ExtTransientSeatV1


ExtTransientSeatV1._gen_c()
ExtTransientSeatV1.proxy_class = ExtTransientSeatV1Proxy
ExtTransientSeatV1.resource_class = ExtTransientSeatV1Resource
ExtTransientSeatV1.global_class = ExtTransientSeatV1Global
