# Print an optspec for argparse to handle cmd's options that are independent of any subcommand.
function __fish_alpm_soname_global_optspecs
	string join \n v/verbose q/quiet h/help V/version
end

function __fish_alpm_soname_needs_command
	# Figure out if the current invocation already has a command.
	set -l cmd (commandline -opc)
	set -e cmd[1]
	argparse -s (__fish_alpm_soname_global_optspecs) -- $cmd 2>/dev/null
	or return
	if set -q argv[1]
		# Also print the command, so this can be used to figure out what it is.
		echo $argv[1]
		return 1
	end
	return 0
end

function __fish_alpm_soname_using_subcommand
	set -l cmd (__fish_alpm_soname_needs_command)
	test -z "$cmd"
	and return 1
	contains -- $cmd[1] $argv
end

complete -c alpm-soname -n "__fish_alpm_soname_needs_command" -s v -l verbose -d 'Increase logging verbosity'
complete -c alpm-soname -n "__fish_alpm_soname_needs_command" -s q -l quiet -d 'Decrease logging verbosity'
complete -c alpm-soname -n "__fish_alpm_soname_needs_command" -s h -l help -d 'Print help'
complete -c alpm-soname -n "__fish_alpm_soname_needs_command" -s V -l version -d 'Print version'
complete -c alpm-soname -n "__fish_alpm_soname_needs_command" -f -a "get-provisions" -d 'Get provisions'
complete -c alpm-soname -n "__fish_alpm_soname_needs_command" -f -a "get-dependencies" -d 'Get dependencies'
complete -c alpm-soname -n "__fish_alpm_soname_needs_command" -f -a "get-raw-dependencies" -d 'Get raw dependencies without filtering by lookup directory'
complete -c alpm-soname -n "__fish_alpm_soname_needs_command" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c alpm-soname -n "__fish_alpm_soname_using_subcommand get-provisions" -s l -l lookup-dir -d 'The lookup directory for shared libraries in `<prefix>:<directory>` format' -r
complete -c alpm-soname -n "__fish_alpm_soname_using_subcommand get-provisions" -s o -l output-format -d 'The output format' -r -f -a "plain\t'The plain text output format (line by line)'
json\t'The JSON output format'"
complete -c alpm-soname -n "__fish_alpm_soname_using_subcommand get-provisions" -s p -l pretty -d 'Pretty-print the output'
complete -c alpm-soname -n "__fish_alpm_soname_using_subcommand get-provisions" -s v -l verbose -d 'Increase logging verbosity'
complete -c alpm-soname -n "__fish_alpm_soname_using_subcommand get-provisions" -s q -l quiet -d 'Decrease logging verbosity'
complete -c alpm-soname -n "__fish_alpm_soname_using_subcommand get-provisions" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c alpm-soname -n "__fish_alpm_soname_using_subcommand get-provisions" -s V -l version -d 'Print version'
complete -c alpm-soname -n "__fish_alpm_soname_using_subcommand get-dependencies" -s l -l lookup-dir -d 'The lookup directory for shared libraries in `<prefix>:<directory>` format' -r
complete -c alpm-soname -n "__fish_alpm_soname_using_subcommand get-dependencies" -s o -l output-format -d 'The output format' -r -f -a "plain\t'The plain text output format (line by line)'
json\t'The JSON output format'"
complete -c alpm-soname -n "__fish_alpm_soname_using_subcommand get-dependencies" -s p -l pretty -d 'Pretty-print the output'
complete -c alpm-soname -n "__fish_alpm_soname_using_subcommand get-dependencies" -s v -l verbose -d 'Increase logging verbosity'
complete -c alpm-soname -n "__fish_alpm_soname_using_subcommand get-dependencies" -s q -l quiet -d 'Decrease logging verbosity'
complete -c alpm-soname -n "__fish_alpm_soname_using_subcommand get-dependencies" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c alpm-soname -n "__fish_alpm_soname_using_subcommand get-dependencies" -s V -l version -d 'Print version'
complete -c alpm-soname -n "__fish_alpm_soname_using_subcommand get-raw-dependencies" -s o -l output-format -d 'The output format' -r -f -a "plain\t'The plain text output format (line by line)'
json\t'The JSON output format'"
complete -c alpm-soname -n "__fish_alpm_soname_using_subcommand get-raw-dependencies" -s p -l pretty -d 'Pretty-print the output'
complete -c alpm-soname -n "__fish_alpm_soname_using_subcommand get-raw-dependencies" -l detail -d 'Display detailed dependency information grouped by ELF file when using the plain output format'
complete -c alpm-soname -n "__fish_alpm_soname_using_subcommand get-raw-dependencies" -s v -l verbose -d 'Increase logging verbosity'
complete -c alpm-soname -n "__fish_alpm_soname_using_subcommand get-raw-dependencies" -s q -l quiet -d 'Decrease logging verbosity'
complete -c alpm-soname -n "__fish_alpm_soname_using_subcommand get-raw-dependencies" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c alpm-soname -n "__fish_alpm_soname_using_subcommand get-raw-dependencies" -s V -l version -d 'Print version'
complete -c alpm-soname -n "__fish_alpm_soname_using_subcommand help; and not __fish_seen_subcommand_from get-provisions get-dependencies get-raw-dependencies help" -f -a "get-provisions" -d 'Get provisions'
complete -c alpm-soname -n "__fish_alpm_soname_using_subcommand help; and not __fish_seen_subcommand_from get-provisions get-dependencies get-raw-dependencies help" -f -a "get-dependencies" -d 'Get dependencies'
complete -c alpm-soname -n "__fish_alpm_soname_using_subcommand help; and not __fish_seen_subcommand_from get-provisions get-dependencies get-raw-dependencies help" -f -a "get-raw-dependencies" -d 'Get raw dependencies without filtering by lookup directory'
complete -c alpm-soname -n "__fish_alpm_soname_using_subcommand help; and not __fish_seen_subcommand_from get-provisions get-dependencies get-raw-dependencies help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
