﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/taxsettings/TaxSettings_EXPORTS.h>
#include <aws/taxsettings/model/BatchPutTaxRegistrationError.h>
#include <aws/taxsettings/model/TaxRegistrationStatus.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace TaxSettings {
namespace Model {
class BatchPutTaxRegistrationResult {
 public:
  AWS_TAXSETTINGS_API BatchPutTaxRegistrationResult() = default;
  AWS_TAXSETTINGS_API BatchPutTaxRegistrationResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_TAXSETTINGS_API BatchPutTaxRegistrationResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>List of errors for the accounts the TRN information could not be added or
   * updated to. </p>
   */
  inline const Aws::Vector<BatchPutTaxRegistrationError>& GetErrors() const { return m_errors; }
  template <typename ErrorsT = Aws::Vector<BatchPutTaxRegistrationError>>
  void SetErrors(ErrorsT&& value) {
    m_errorsHasBeenSet = true;
    m_errors = std::forward<ErrorsT>(value);
  }
  template <typename ErrorsT = Aws::Vector<BatchPutTaxRegistrationError>>
  BatchPutTaxRegistrationResult& WithErrors(ErrorsT&& value) {
    SetErrors(std::forward<ErrorsT>(value));
    return *this;
  }
  template <typename ErrorsT = BatchPutTaxRegistrationError>
  BatchPutTaxRegistrationResult& AddErrors(ErrorsT&& value) {
    m_errorsHasBeenSet = true;
    m_errors.emplace_back(std::forward<ErrorsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The status of your TRN stored in the system after processing. Based on the
   * validation occurring on the TRN, the status can be <code>Verified</code>,
   * <code>Pending</code> or <code>Rejected</code>. </p>
   */
  inline TaxRegistrationStatus GetStatus() const { return m_status; }
  inline void SetStatus(TaxRegistrationStatus value) {
    m_statusHasBeenSet = true;
    m_status = value;
  }
  inline BatchPutTaxRegistrationResult& WithStatus(TaxRegistrationStatus value) {
    SetStatus(value);
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  BatchPutTaxRegistrationResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<BatchPutTaxRegistrationError> m_errors;
  bool m_errorsHasBeenSet = false;

  TaxRegistrationStatus m_status{TaxRegistrationStatus::NOT_SET};
  bool m_statusHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace TaxSettings
}  // namespace Aws
