﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/cognito-idp/CognitoIdentityProvider_EXPORTS.h>
#include <aws/cognito-idp/model/TermsDescriptionType.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace CognitoIdentityProvider {
namespace Model {
class ListTermsResult {
 public:
  AWS_COGNITOIDENTITYPROVIDER_API ListTermsResult() = default;
  AWS_COGNITOIDENTITYPROVIDER_API ListTermsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_COGNITOIDENTITYPROVIDER_API ListTermsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>A summary of the requested terms documents. Includes unique identifiers for
   * later changes to the terms documents.</p>
   */
  inline const Aws::Vector<TermsDescriptionType>& GetTerms() const { return m_terms; }
  template <typename TermsT = Aws::Vector<TermsDescriptionType>>
  void SetTerms(TermsT&& value) {
    m_termsHasBeenSet = true;
    m_terms = std::forward<TermsT>(value);
  }
  template <typename TermsT = Aws::Vector<TermsDescriptionType>>
  ListTermsResult& WithTerms(TermsT&& value) {
    SetTerms(std::forward<TermsT>(value));
    return *this;
  }
  template <typename TermsT = TermsDescriptionType>
  ListTermsResult& AddTerms(TermsT&& value) {
    m_termsHasBeenSet = true;
    m_terms.emplace_back(std::forward<TermsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>This API operation returns a limited number of results. The pagination token
   * is an identifier that you can present in an additional API request with the same
   * parameters. When you include the pagination token, Amazon Cognito returns the
   * next set of items after the current list. Subsequent requests return a new
   * pagination token. By use of this token, you can paginate through the full list
   * of items.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListTermsResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ListTermsResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<TermsDescriptionType> m_terms;

  Aws::String m_nextToken;

  Aws::String m_requestId;
  bool m_termsHasBeenSet = false;
  bool m_nextTokenHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace CognitoIdentityProvider
}  // namespace Aws
