﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/customer-profiles/CustomerProfiles_EXPORTS.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace CustomerProfiles {
namespace Model {
class CreateSegmentEstimateResult {
 public:
  AWS_CUSTOMERPROFILES_API CreateSegmentEstimateResult() = default;
  AWS_CUSTOMERPROFILES_API CreateSegmentEstimateResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_CUSTOMERPROFILES_API CreateSegmentEstimateResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The unique name of the domain.</p>
   */
  inline const Aws::String& GetDomainName() const { return m_domainName; }
  template <typename DomainNameT = Aws::String>
  void SetDomainName(DomainNameT&& value) {
    m_domainNameHasBeenSet = true;
    m_domainName = std::forward<DomainNameT>(value);
  }
  template <typename DomainNameT = Aws::String>
  CreateSegmentEstimateResult& WithDomainName(DomainNameT&& value) {
    SetDomainName(std::forward<DomainNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A unique identifier for the resource. The value can be passed to
   * <code>GetSegmentEstimate</code> to retrieve the result of segment estimate
   * status.</p>
   */
  inline const Aws::String& GetEstimateId() const { return m_estimateId; }
  template <typename EstimateIdT = Aws::String>
  void SetEstimateId(EstimateIdT&& value) {
    m_estimateIdHasBeenSet = true;
    m_estimateId = std::forward<EstimateIdT>(value);
  }
  template <typename EstimateIdT = Aws::String>
  CreateSegmentEstimateResult& WithEstimateId(EstimateIdT&& value) {
    SetEstimateId(std::forward<EstimateIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The status code for the response.</p>
   */
  inline int GetStatusCode() const { return m_statusCode; }
  inline void SetStatusCode(int value) {
    m_statusCodeHasBeenSet = true;
    m_statusCode = value;
  }
  inline CreateSegmentEstimateResult& WithStatusCode(int value) {
    SetStatusCode(value);
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  CreateSegmentEstimateResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_domainName;

  Aws::String m_estimateId;

  int m_statusCode{0};

  Aws::String m_requestId;
  bool m_domainNameHasBeenSet = false;
  bool m_estimateIdHasBeenSet = false;
  bool m_statusCodeHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace CustomerProfiles
}  // namespace Aws
