﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/dataexchange/DataExchangeRequest.h>
#include <aws/dataexchange/DataExchange_EXPORTS.h>
#include <aws/dataexchange/model/Action.h>

#include <utility>

namespace Aws {
namespace DataExchange {
namespace Model {

/**
 */
class UpdateEventActionRequest : public DataExchangeRequest {
 public:
  AWS_DATAEXCHANGE_API UpdateEventActionRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "UpdateEventAction"; }

  AWS_DATAEXCHANGE_API Aws::String SerializePayload() const override;

  ///@{
  /**
   * <p>What occurs after a certain event.</p>
   */
  inline const Action& GetAction() const { return m_action; }
  inline bool ActionHasBeenSet() const { return m_actionHasBeenSet; }
  template <typename ActionT = Action>
  void SetAction(ActionT&& value) {
    m_actionHasBeenSet = true;
    m_action = std::forward<ActionT>(value);
  }
  template <typename ActionT = Action>
  UpdateEventActionRequest& WithAction(ActionT&& value) {
    SetAction(std::forward<ActionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The unique identifier for the event action.</p>
   */
  inline const Aws::String& GetEventActionId() const { return m_eventActionId; }
  inline bool EventActionIdHasBeenSet() const { return m_eventActionIdHasBeenSet; }
  template <typename EventActionIdT = Aws::String>
  void SetEventActionId(EventActionIdT&& value) {
    m_eventActionIdHasBeenSet = true;
    m_eventActionId = std::forward<EventActionIdT>(value);
  }
  template <typename EventActionIdT = Aws::String>
  UpdateEventActionRequest& WithEventActionId(EventActionIdT&& value) {
    SetEventActionId(std::forward<EventActionIdT>(value));
    return *this;
  }
  ///@}
 private:
  Action m_action;

  Aws::String m_eventActionId;
  bool m_actionHasBeenSet = false;
  bool m_eventActionIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace DataExchange
}  // namespace Aws
