﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/lightsail/Lightsail_EXPORTS.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace Lightsail {
namespace Model {
class GetActiveNamesResult {
 public:
  AWS_LIGHTSAIL_API GetActiveNamesResult() = default;
  AWS_LIGHTSAIL_API GetActiveNamesResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_LIGHTSAIL_API GetActiveNamesResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The list of active names returned by the get active names request.</p>
   */
  inline const Aws::Vector<Aws::String>& GetActiveNames() const { return m_activeNames; }
  template <typename ActiveNamesT = Aws::Vector<Aws::String>>
  void SetActiveNames(ActiveNamesT&& value) {
    m_activeNamesHasBeenSet = true;
    m_activeNames = std::forward<ActiveNamesT>(value);
  }
  template <typename ActiveNamesT = Aws::Vector<Aws::String>>
  GetActiveNamesResult& WithActiveNames(ActiveNamesT&& value) {
    SetActiveNames(std::forward<ActiveNamesT>(value));
    return *this;
  }
  template <typename ActiveNamesT = Aws::String>
  GetActiveNamesResult& AddActiveNames(ActiveNamesT&& value) {
    m_activeNamesHasBeenSet = true;
    m_activeNames.emplace_back(std::forward<ActiveNamesT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The token to advance to the next page of results from your request.</p> <p>A
   * next page token is not returned if there are no more results to display.</p>
   * <p>To get the next page of results, perform another <code>GetActiveNames</code>
   * request and specify the next page token using the <code>pageToken</code>
   * parameter.</p>
   */
  inline const Aws::String& GetNextPageToken() const { return m_nextPageToken; }
  template <typename NextPageTokenT = Aws::String>
  void SetNextPageToken(NextPageTokenT&& value) {
    m_nextPageTokenHasBeenSet = true;
    m_nextPageToken = std::forward<NextPageTokenT>(value);
  }
  template <typename NextPageTokenT = Aws::String>
  GetActiveNamesResult& WithNextPageToken(NextPageTokenT&& value) {
    SetNextPageToken(std::forward<NextPageTokenT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  GetActiveNamesResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<Aws::String> m_activeNames;

  Aws::String m_nextPageToken;

  Aws::String m_requestId;
  bool m_activeNamesHasBeenSet = false;
  bool m_nextPageTokenHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace Lightsail
}  // namespace Aws
