﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/lightsail/Lightsail_EXPORTS.h>
#include <aws/lightsail/model/ContainerServiceDeployment.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace Lightsail {
namespace Model {
class GetContainerServiceDeploymentsResult {
 public:
  AWS_LIGHTSAIL_API GetContainerServiceDeploymentsResult() = default;
  AWS_LIGHTSAIL_API GetContainerServiceDeploymentsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_LIGHTSAIL_API GetContainerServiceDeploymentsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>An array of objects that describe deployments for a container service.</p>
   */
  inline const Aws::Vector<ContainerServiceDeployment>& GetDeployments() const { return m_deployments; }
  template <typename DeploymentsT = Aws::Vector<ContainerServiceDeployment>>
  void SetDeployments(DeploymentsT&& value) {
    m_deploymentsHasBeenSet = true;
    m_deployments = std::forward<DeploymentsT>(value);
  }
  template <typename DeploymentsT = Aws::Vector<ContainerServiceDeployment>>
  GetContainerServiceDeploymentsResult& WithDeployments(DeploymentsT&& value) {
    SetDeployments(std::forward<DeploymentsT>(value));
    return *this;
  }
  template <typename DeploymentsT = ContainerServiceDeployment>
  GetContainerServiceDeploymentsResult& AddDeployments(DeploymentsT&& value) {
    m_deploymentsHasBeenSet = true;
    m_deployments.emplace_back(std::forward<DeploymentsT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  GetContainerServiceDeploymentsResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<ContainerServiceDeployment> m_deployments;

  Aws::String m_requestId;
  bool m_deploymentsHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace Lightsail
}  // namespace Aws
