﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/managedblockchain/ManagedBlockchain_EXPORTS.h>
#include <aws/managedblockchain/model/ProposalSummary.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace ManagedBlockchain {
namespace Model {
class ListProposalsResult {
 public:
  AWS_MANAGEDBLOCKCHAIN_API ListProposalsResult() = default;
  AWS_MANAGEDBLOCKCHAIN_API ListProposalsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_MANAGEDBLOCKCHAIN_API ListProposalsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The summary of each proposal made on the network.</p>
   */
  inline const Aws::Vector<ProposalSummary>& GetProposals() const { return m_proposals; }
  template <typename ProposalsT = Aws::Vector<ProposalSummary>>
  void SetProposals(ProposalsT&& value) {
    m_proposalsHasBeenSet = true;
    m_proposals = std::forward<ProposalsT>(value);
  }
  template <typename ProposalsT = Aws::Vector<ProposalSummary>>
  ListProposalsResult& WithProposals(ProposalsT&& value) {
    SetProposals(std::forward<ProposalsT>(value));
    return *this;
  }
  template <typename ProposalsT = ProposalSummary>
  ListProposalsResult& AddProposals(ProposalsT&& value) {
    m_proposalsHasBeenSet = true;
    m_proposals.emplace_back(std::forward<ProposalsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The pagination token that indicates the next set of results to retrieve.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListProposalsResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ListProposalsResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<ProposalSummary> m_proposals;

  Aws::String m_nextToken;

  Aws::String m_requestId;
  bool m_proposalsHasBeenSet = false;
  bool m_nextTokenHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace ManagedBlockchain
}  // namespace Aws
